% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eaf.R
\name{read.data.sets}
\alias{read.data.sets}
\title{Read several data.frame sets}
\usage{
read.data.sets(file, col.names)
}
\arguments{
\item{file}{Filename that contains the data.  Each row of the table appears
as one line of the file.  If it does not contain an \emph{absolute} path,
the file name is \emph{relative} to the current working directory,
\code{getwd()}.  Tilde-expansion is performed where supported.}

\item{col.names}{Vector of optional names for the variables.  The
default is to use \samp{"V"} followed by the column number.}
}
\value{
A data frame (\code{data.frame}) containing a representation of the
 data in the file. An extra column \code{set} is added to indicate to
 which set each row belongs.
}
\description{
Reads a text file in table format and creates a data frame from it. The file
may contain several sets, separated by empty lines. The function adds an
additional column \code{set} to indicate to which set each row belongs.
}
\note{
There are several examples of data sets in \code{file.path(system.file(package="eaf"),"extdata")}.
}
\section{Warning}{

 A known limitation is that the input file must use newline characters
 native to the host system, otherwise they will be, possibly silently,
 misinterpreted. In GNU/Linux the program \code{dos2unix} may be used
 to fix newline characters.
}

\examples{
A1<-read.data.sets(file.path(system.file(package="eaf"),"extdata","ALG_1_dat"))
str(A1)
A2<-read.data.sets(file.path(system.file(package="eaf"),"extdata","ALG_2_dat"))
str(A2)

}
\seealso{
\code{\link{read.table}}, \code{\link{eafplot}}, \code{\link{eafdiffplot}}
}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
\keyword{file}
