% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_stat_chisq.R
\name{chisq_to_phi}
\alias{chisq_to_phi}
\alias{chisq_to_cohens_w}
\alias{chisq_to_cramers_v}
\alias{chisq_to_pearsons_c}
\alias{phi_to_chisq}
\title{Conversion Chi-Squared to Phi or Cramer's V}
\usage{
chisq_to_phi(
  chisq,
  n,
  nrow,
  ncol,
  ci = 0.95,
  alternative = "greater",
  adjust = FALSE,
  ...
)

chisq_to_cohens_w(
  chisq,
  n,
  nrow,
  ncol,
  ci = 0.95,
  alternative = "greater",
  adjust = FALSE,
  ...
)

chisq_to_cramers_v(
  chisq,
  n,
  nrow,
  ncol,
  ci = 0.95,
  alternative = "greater",
  adjust = FALSE,
  ...
)

chisq_to_pearsons_c(
  chisq,
  n,
  nrow,
  ncol,
  ci = 0.95,
  alternative = "greater",
  ...
)

phi_to_chisq(phi, n, ...)
}
\arguments{
\item{chisq}{The Chi-squared statistic.}

\item{n}{Total sample size.}

\item{nrow, ncol}{The number of rows/columns in the contingency table (ignored
for Phi when \code{adjust=FALSE} and \code{CI=NULL}).}

\item{ci}{Confidence Interval (CI) level}

\item{alternative}{a character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"greater"} (default) or \code{"less"}
(one-sided CI), or \code{"two.sided"} (default, two-sided CI). Partial matching
is allowed (e.g., \code{"g"}, \code{"l"}, \code{"two"}...). See \emph{One-Sided CIs} in
\link{effectsize_CIs}.}

\item{adjust}{Should the effect size be bias-corrected? Defaults to \code{FALSE}.}

\item{...}{Arguments passed to or from other methods.}

\item{phi}{The Phi statistic.}
}
\value{
A data frame with the effect size(s), and confidence interval(s). See
\code{\link[=cramers_v]{cramers_v()}}.
}
\description{
Convert between Chi square (\eqn{\chi^2}), Cramer's V, phi (\eqn{\phi}),
Cohen's \emph{w} and Pearson's \emph{C} for contingency tables or goodness of fit.
}
\details{
These functions use the following formulae:
\cr
\deqn{\phi = \sqrt{\chi^2 / n}}{phi = sqrt(\chi^2 / n)}
\cr
\deqn{Cramer's V = \phi / \sqrt{min(nrow,ncol)-1}}{Cramer's V = \phi / sqrt(min(nrow,ncol)-1)}
\cr
\deqn{Pearson's C = \sqrt{\chi^2 / (\chi^2 + n)}}{Pearson's C = sqrt(\chi^2 / (\chi^2 + n))}
\cr\cr
For adjusted versions, see Bergsma, 2013.
}
\note{
Cohen's \emph{w} is equivalent to \emph{Phi}.
}
\section{Confidence (Compatibility) Intervals (CIs)}{

Unless stated otherwise, confidence (compatibility) intervals (CIs) are
estimated using the noncentrality parameter method (also called the "pivot
method"). This method finds the noncentrality parameter ("\emph{ncp}") of a
noncentral \emph{t}, \emph{F}, or \eqn{\chi^2} distribution that places the observed
\emph{t}, \emph{F}, or \eqn{\chi^2} test statistic at the desired probability point of
the distribution. For example, if the observed \emph{t} statistic is 2.0, with 50
degrees of freedom, for which cumulative noncentral \emph{t} distribution is \emph{t} =
2.0 the .025 quantile (answer: the noncentral \emph{t} distribution with \emph{ncp} =
.04)? After estimating these confidence bounds on the \emph{ncp}, they are
converted into the effect size metric to obtain a confidence interval for the
effect size (Steiger, 2004).
\cr\cr
For additional details on estimation and troubleshooting, see \link{effectsize_CIs}.
}

\section{CIs and Significance Tests}{

"Confidence intervals on measures of effect size convey all the information
in a hypothesis test, and more." (Steiger, 2004). Confidence (compatibility)
intervals and p values are complementary summaries of parameter uncertainty
given the observed data. A dichotomous hypothesis test could be performed
with either a CI or a p value. The 100 (1 - \eqn{\alpha})\% confidence
interval contains all of the parameter values for which \emph{p} > \eqn{\alpha}
for the current data and model. For example, a 95\% confidence interval
contains all of the values for which p > .05.
\cr\cr
Note that a confidence interval including 0 \emph{does not} indicate that the null
(no effect) is true. Rather, it suggests that the observed data together with
the model and its assumptions combined do not provided clear evidence against
a parameter value of 0 (same as with any other value in the interval), with
the level of this evidence defined by the chosen \eqn{\alpha} level (Rafi &
Greenland, 2020; Schweder & Hjort, 2016; Xie & Singh, 2013). To infer no
effect, additional judgments about what parameter values are "close enough"
to 0 to be negligible are needed ("equivalence testing"; Bauer & Kiesser,
1996).
}

\examples{
contingency_table <- as.table(rbind(c(762, 327, 468), c(484, 239, 477), c(484, 239, 477)))

# chisq.test(contingency_table)
#>
#>         Pearson's Chi-squared test
#>
#> data:  contingency_table
#> X-squared = 41.234, df = 4, p-value = 2.405e-08

chisq_to_phi(41.234,
  n = sum(contingency_table),
  nrow = nrow(contingency_table),
  ncol = ncol(contingency_table)
)
chisq_to_cramers_v(41.234,
  n = sum(contingency_table),
  nrow = nrow(contingency_table),
  ncol = ncol(contingency_table)
)
chisq_to_pearsons_c(41.234,
  n = sum(contingency_table),
  nrow = nrow(contingency_table),
  ncol = ncol(contingency_table)
)
}
\references{
\itemize{
\item Cumming, G., & Finch, S. (2001). A primer on the understanding, use, and
calculation of confidence intervals that are based on central and noncentral
distributions. Educational and Psychological Measurement, 61(4), 532-574.
\item Bergsma, W. (2013). A bias-correction for Cramer's V and Tschuprow's T.
Journal of the Korean Statistical Society, 42(3), 323-328.
}
}
\seealso{
Other effect size from test statistic: 
\code{\link{F_to_eta2}()},
\code{\link{t_to_d}()}
}
\concept{effect size from test statistic}
