% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_kernapply.R
\name{future_kernapply}
\alias{future_kernapply}
\alias{future_kernapply.default}
\alias{future_kernapply.ts}
\title{Apply Smoothing Kernel in Parallel}
\usage{
future_kernapply(x, ...)

\method{future_kernapply}{default}(x, k, circular = FALSE, ...)

\method{future_kernapply}{ts}(x, k, circular = FALSE, ...)
}
\arguments{
\item{x}{an input vector, matrix, time series or kernel to be smoothed.}

\item{...}{arguments passed to or from other methods.}

\item{k}{smoothing \code{"tskernel"} object.}

\item{circular}{a logical indicating whether the input sequence to be
    smoothed is treated as circular, i.e., periodic.}
}
\value{
See \code{\link[stats:kernapply]{stats::kernapply()}} for details.
}
\description{
\code{future_kernapply()} is a futurized version of
\code{\link[stats:kernapply]{stats::kernapply()}}, i.e. it computes, in parallel, the
convolution between an input sequence and a specific kernel.
Parallelization takes place over columns when \code{x} is a matrix,
including a \code{ts} matrix.
}
\examples{
library(datasets)
library(stats)

X <- EuStockMarkets[, 1:2]
k <- kernel("daniell", 50)  # a long moving average
X_smooth <- future_kernapply(X, k = k)

}
