% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.r
\docType{methods}
\name{summary,git_repository-method}
\alias{summary,git_repository-method}
\alias{summary,git_repository-methods}
\title{Summary of repository}
\usage{
\S4method{summary}{git_repository}(object, ...)
}
\arguments{
\item{object}{The repository \code{object}}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
None (invisible 'NULL').
}
\description{
Summary of repository
}
\examples{
\dontrun{
## Initialize a repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Config user
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file
writeLines("Hello world!", file.path(path, "test.txt"))
summary(repo)

## Add file
add(repo, "test.txt")
summary(repo)

## Commit
commit(repo, "First commit message")
summary(repo)

## Change the file
writeLines(c("Hello again!", "Here is a second line", "And a third"),
           file.path(path, "test.txt"))
summary(repo)

## Add file and commit
add(repo, "test.txt")
commit(repo, "Second commit message")
summary(repo)
}
}
\keyword{methods}
