% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semTable.R
\name{testtable}
\alias{testtable}
\title{Test viewer for tex tables}
\usage{
testtable(tablefile, dir, tmpfn = "tmp.tex")
}
\arguments{
\item{tablefile}{The base name of the table file}

\item{dir}{Directory where table is saved, same will be used for build.}

\item{tmpfn}{File name to be used by example document}
}
\value{
LaTeX log, returned from shell function.
}
\description{
Creates a small latex template file that includes a table
file. Compiles it, then displays in viewer if system has
\code{xdg-open} settings.
}
\examples{
\donttest{
require(lavaan)
tempdir <- tempdir()
HS.model <- ' visual  =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
              speed   =~ x7 + x8 + x9'
fit1 <- cfa(HS.model, data = HolzingerSwineford1939,
            std.lv = TRUE, meanstructure = TRUE)
fit1.t <- semTable(fit1, fits = c("chisq", "rmsea"),
               columns = c("estsestars", "rsquare"),
               columnLabels = c("estsestars" = "Est(SE)"),
               file = file.path(tempdir, "fit1.t"))
if (interactive()) testtable("fit1.t", tempdir)
}
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
