% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-butils-extractData.R
\name{extractData}
\alias{extractData}
\alias{extractData.lm}
\alias{extractData.coxph}
\alias{extractData.cph}
\alias{extractData.lvmfit}
\alias{extractData.gls}
\alias{extractData.lme}
\title{Extract Data From a Model}
\usage{
extractData(object, design.matrix, as.data.frame, envir)

\method{extractData}{lm}(
  object,
  design.matrix = FALSE,
  as.data.frame = TRUE,
  envir = environment()
)

\method{extractData}{coxph}(
  object,
  design.matrix = FALSE,
  as.data.frame = TRUE,
  envir = environment()
)

\method{extractData}{cph}(
  object,
  design.matrix = FALSE,
  as.data.frame = TRUE,
  envir = environment()
)

\method{extractData}{lvmfit}(
  object,
  design.matrix = FALSE,
  as.data.frame = TRUE,
  envir = environment()
)

\method{extractData}{gls}(
  object,
  design.matrix = FALSE,
  as.data.frame = TRUE,
  envir = environment()
)

\method{extractData}{lme}(
  object,
  design.matrix = FALSE,
  as.data.frame = TRUE,
  envir = environment()
)
}
\arguments{
\item{object}{the fitted model.}

\item{design.matrix}{[logical] should the data be extracted after transformation (e.g. conversion of categorical variables to dummy variables)?
Otherwise the original data will be returned.}

\item{as.data.frame}{[logical] should the output be converted into a \code{data.frame} object?}

\item{envir}{[environment] the environment from which to search the data.}
}
\value{
a dataset.
}
\description{
Extract data from a model using \code{nlme::getData}, \code{riskRegression::coxDesign} or \code{model.frame}.. 
If it fails it will try to extract it by its name according to \code{model$call$data}.
}
\examples{
set.seed(10)
n <- 101

#### linear regression ####
Y1 <- rnorm(n, mean = 0)
Y2 <- rnorm(n, mean = 0.3)
Id <- findInterval(runif(n), seq(0.1,1,0.1))
data.df <- rbind(data.frame(Y=Y1,G="1",Id = Id),
           data.frame(Y=Y2,G="2",Id = Id)
           )
m.lm <- lm(Y ~ G, data = data.df)
a <- extractData(m.lm, design.matrix = TRUE)
b <- extractData(m.lm, design.matrix = FALSE)

library(nlme)
m.gls <- gls(Y ~ G, weights = varIdent(form = ~ 1|Id), data = data.df)
c <- extractData(m.gls)
m.lme <- lme(Y ~ G, random = ~ 1|Id, data = data.df)
d <- extractData(m.lme)

library(lava)
e.lvm <- estimate(lvm(Y ~ G), data = data.df)
e <- extractData(e.lvm)
e <- extractData(e.lvm, design.matrix = TRUE)

#### survival #### 
library(survival)

\dontrun{
  library(riskRegression) ## needs version >=1.4.3
  dt.surv <- sampleData(n, outcome = "survival")
  m.cox <- coxph(Surv(time, event) ~ X1 + X2, data = dt.surv, x = TRUE, y = TRUE)
  f <- extractData(m.cox, design.matrix = FALSE)
  f <- extractData(m.cox, design.matrix = TRUE)
  m.cox <- coxph(Surv(time, event) ~ strata(X1) + X2, data = dt.surv, x = TRUE, y = TRUE)
  f <- extractData(m.cox, design.matrix = TRUE)
}

#### nested fuuctions ####
fct1 <- function(m){
   fct2(m)
}
fct2 <- function(m){ 
   extractData(m)
}
g <- fct1(m.gls)
}
\concept{extractor}
