% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linter_tags.R
\name{available_linters}
\alias{available_linters}
\alias{available_tags}
\title{Get Linter metadata from a package}
\usage{
available_linters(packages = "lintr", tags = NULL, exclude_tags = "deprecated")

available_tags(packages = "lintr")
}
\arguments{
\item{packages}{A character vector of packages to search for linters.}

\item{tags}{Optional character vector of tags to search. Only linters with at least one matching tag will be
returned. If \code{tags} is \code{NULL}, all linters will be returned. See \code{available_tags("lintr")} to find out what
tags are already used by lintr.}

\item{exclude_tags}{Tags to exclude from the results. Linters with at least one matching tag will not be returned.
If \code{except_tags} is \code{NULL}, no linters will be excluded. Note that \code{tags} takes priority, meaning that any
tag found in both \code{tags} and \code{exclude_tags} will be included, not excluded.}
}
\value{
\code{available_linters} returns a data frame with columns 'linter', 'package' and 'tags':

\describe{
\item{linter}{A character column naming the function associated with the linter.}
\item{package}{A character column containing the name of the package providing the linter.}
\item{tags}{A list column containing tags associated with the linter.}
}

\code{available_tags} returns a character vector of linter tags used by the packages.
}
\description{
\code{available_linters()} obtains a tagged list of all Linters available in a package.

\code{available_tags()} searches for available tags.
}
\section{Package Authors}{


To implement \code{available_linters()} for your package, include a file \code{inst/lintr/linters.csv} in your
package.
The CSV file must contain the columns 'linter' and 'tags', and be UTF-8 encoded.
Additional columns will be silently ignored if present and the columns are identified by name.
Each row describes a linter by
\enumerate{
\item its function name (e.g. \code{"assignment_linter"}) in the column 'linter'.
\item space-separated tags associated with the linter (e.g. \code{"style consistency default"}) in the column 'tags'.
}

Tags should be snake_case.

See \code{available_tags("lintr")} to find out what tags are already used by lintr.
}

\examples{
lintr_linters <- available_linters()

# If the package doesn't exist or isn't installed, an empty data frame will be returned
available_linters("does-not-exist")

lintr_linters2 <- available_linters(c("lintr", "does-not-exist"))
identical(lintr_linters, lintr_linters2)
available_tags()
}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \code{\link[=available_tags]{available_tags()}} to retrieve the set of valid tags.
}
}
