% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_assign.R
\name{assignments}
\alias{assignments}
\alias{pd_is_assignment}
\alias{pd_get_assign_value_id}
\alias{pd_get_assign_variable_id}
\title{Assignment Node Navigation.}
\usage{
pd_is_assignment(id, pd, .check = TRUE)

pd_get_assign_value_id(id, pd, .check = TRUE)

pd_get_assign_variable_id(id, pd, .check = TRUE)
}
\arguments{
\item{id}{id of the expression of interest}

\item{pd}{The \code{\link{parse-data}} information}

\item{.check}{Perform checks for input validation?}
}
\description{
These function help identify and navigate assignments in parse data.
}
\details{
These functions only deal with assignment operators.
Using \code{\link[base:assign]{base::assign()}} or \code{\link[base:delayedAssign]{base::delayedAssign()}} are considered
calls in terms of parse data.

There are five assignment operators grouped into three categories.
\itemize{
\item Left assignment, the \code{\link[base:assignOps]{<-}} and \code{\link[base:assignOps]{<<-}},
\item right assignment, \code{\link[base:assignOps]{->}} and the rarely used \code{\link[base:assignOps]{->>}}
\item and the equals assignment \code{\link[base:assignOps]{=}}.
}
}
\section{Functions}{
\itemize{
\item \code{pd_is_assignment}: Check if the node is an assignment expression.

\item \code{pd_get_assign_value_id}: Get the id for the value portion of an assignment.

\item \code{pd_get_assign_variable_id}: Get the variable of an assignment.
}}

\examples{
# load example file and get_parse data
ex.file <- system.file("examples", "example.R", package="parsetools")
exprs <- parse(ex.file, keep.source = TRUE)
pd <- get_parse_data(exprs)

# There are 3 expressions so there should be three roots.
sum(pd_is_root(pd$id, pd))
roots <- pd_all_root_ids(pd)

# The first should be an assignment
pd_is_assignment(roots[[1]], pd=pd)

# the variable/value of the assignment can be accessed by
variable.id <- pd_get_assign_variable_id(roots[[1]], pd)
value.id <- pd_get_assign_value_id(roots[[1]], pd)
# Note that these function will give the variable/value part
# for both LEFT_ASSIGN and RIGHT_ASSIGN operators, going by order
# of ids, or position in the data may not give the expected results.
}
