% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_discrimination.R
\name{item_discrimination}
\alias{item_discrimination}
\title{Discrimination of Questionnaire Items}
\usage{
item_discrimination(x, standardize = FALSE)
}
\arguments{
\item{x}{A matrix or a data frame.}

\item{standardize}{Logical, if \code{TRUE}, the data frame's vectors will be
standardized. Recommended when the variables have different measures /
scales.}
}
\value{
A data frame with the item discrimination (\emph{corrected item-total
correlations}) for each item of the scale.
}
\description{
Compute various measures of internal consistencies
for tests or item-scales of questionnaires.
}
\details{
This function calculates the item discriminations (corrected item-total
correlations for each item of \code{x} with the remaining items) for each item
of a scale. The absolute value of the item discrimination indices should be
above 0.2. An index between 0.2 and 0.4 is considered as "fair", while a
satisfactory index ranges from 0.4 to 0.7. Items with low discrimination
indices are often ambiguously worded and should be examined. Items with
negative indices should be examined to determine why a negative value was
obtained (e.g. reversed answer categories regarding positive and negative
poles).
}
\examples{
data(mtcars)
x <- mtcars[, c("cyl", "gear", "carb", "hp")]
item_discrimination(x)
}
\references{
\itemize{
\item Kelava A, Moosbrugger H (2020). Deskriptivstatistische Itemanalyse und
Testwertbestimmung. In: Moosbrugger H,  Kelava A, editors. Testtheorie und
Fragebogenkonstruktion. Berlin, Heidelberg: Springer, 143–158
}
}
