% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pldis.R
\name{dpldis}
\alias{dpldis}
\alias{ppldis}
\alias{rpldis}
\title{Discrete power-law distribution}
\usage{
dpldis(x, xmin, alpha, log = FALSE)

ppldis(q, xmin, alpha, lower.tail = TRUE)

rpldis(n, xmin, alpha, discrete_max = 10000)
}
\arguments{
\item{x, q}{vector of quantiles. The discrete
power-law distribution is defined for x > xmin.}

\item{xmin}{The lower bound of the power-law distribution.
For the continuous power-law, xmin >= 0.
for the discrete distribution, xmin > 0.}

\item{alpha}{The scaling parameter: alpha > 1.}

\item{log}{logical (default FALSE) if TRUE, log values are returned.}

\item{lower.tail}{logical;
if TRUE (default), probabilities are \eqn{P[X \le x]},
otherwise, \eqn{P[X > x]}.}

\item{n}{Number of observations. If \code{length(n) > 1}, the length is
taken to be the number required.}

\item{discrete_max}{The value when we switch from the discrete random
numbers to a CTN approximation.}
}
\value{
dpldis returns the density, ppldis returns the distribution function
and rpldis return random numbers.
}
\description{
Density, distribution function and random number generation
for the discrete power law distribution with parameters xmin and alpha.
}
\details{
The Clauset, 2009 paper provides an algorithm for generating discrete random numbers.
However, if this algorithm is implemented in R, it gives terrible performance.
This is because the algorithm involves "growing vectors".
Another problem is when alpha is close to 1, this can result in very large random
number being generated (which means we need
to calculate the discrete CDF for very large values).

The algorithm provided in this package generates true
discrete random numbers up to 10,000 then switches to
using continuous random numbers. This switching point can altered by
changing the \code{discrete_max} argument.

In order to get a efficient power-law discrete random number generator, the
algorithm needs to be implemented in C.
}
\note{
The naming of these functions mirrors standard R functions, i.e. dnorm.
When alpha is close to one, generating random number can be very slow.
}
\examples{
xmin = 1; alpha = 2
x = xmin:100

plot(x, dpldis(x, xmin, alpha), type="l")
plot(x, ppldis(x, xmin, alpha), type="l", main="Distribution function")
dpldis(1, xmin, alpha)

###############################################
## Random number generation                   #
###############################################
n = 1e5
x1 = rpldis(n, xmin, alpha)
## Compare with exact (dpldis(1, xmin, alpha))
sum(x1==1)/n
## Using only the approximation
x2 = rpldis(n, xmin, alpha, 0)
sum(x2==1)/n

}
\references{
Clauset, Aaron, Cosma Rohilla Shalizi, and Mark EJ Newman.
"Power-law distributions in empirical data." SIAM review 51.4 (2009): 661-703.
}
