% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array.R
\name{array_reshape}
\alias{array_reshape}
\title{Reshape an Array}
\usage{
array_reshape(x, dim, order = c("C", "F"))
}
\arguments{
\item{x}{An array}

\item{dim}{The new dimensions to be set on the array.}

\item{order}{The order in which elements of \code{x} should be read during
the rearrangement. \code{"C"} means elements should be read in row-major
order, with the last index changing fastest; \code{"F"} means elements should
be read in column-major order, with the first index changing fastest.}
}
\description{
Reshape (reindex) a multi-dimensional array, using row-major (C-style) reshaping
semantics by default.
}
\details{
This function differs from e.g. \code{dim(x) <- dim} in a very important way: by
default, \code{array_reshape()} will fill the new dimensions in row-major (\code{C}-style)
ordering, while \code{\link[=dim<-]{dim<-()}} will fill new dimensions in column-major
(\code{F}ortran-style) ordering. This is done to be consistent with libraries
like NumPy, Keras, and TensorFlow, which default to this sort of ordering when
reshaping arrays. See the examples for why this difference may be important.
}
\examples{
\dontrun{
# let's construct a 2x2 array from a vector of 4 elements
x <- 1:4

# rearrange will fill the array row-wise
array_reshape(x, c(2, 2))
#      [,1] [,2]
# [1,]    1    2
# [2,]    3    4
# setting the dimensions 'fills' the array col-wise
dim(x) <- c(2, 2)
x
#      [,1] [,2]
# [1,]    1    3
# [2,]    2    4
}
}
