% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{toFactorLoading}
\alias{toFactorLoading}
\title{Convert response function slopes to factor loadings}
\usage{
toFactorLoading(slope, ogive = rpf.ogive)
}
\arguments{
\item{slope}{a matrix with items in the columns and slopes in the rows}

\item{ogive}{the ogive constant (default \link{rpf.ogive})}
}
\value{
a factor loading matrix with items in the rows and factors in the columns
}
\description{
All slopes are divided by the ogive constant. Then the following
transformation is applied to the slope matrix,
}
\details{
\deqn{\frac{\mathrm{slope}}{\left[ 1 + \mathrm{rowSums}(\mathrm{slope}^2) \right]^\frac{1}{2}}}
}
\seealso{
Other factor model equivalence: 
\code{\link{fromFactorLoading}()},
\code{\link{fromFactorThreshold}()},
\code{\link{toFactorThreshold}()}
}
\concept{factor model equivalence}
