% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form.R
\name{submit_form}
\alias{submit_form}
\title{Submit a form back to the server.}
\usage{
submit_form(session, form, submit = NULL, ...)
}
\arguments{
\item{session}{Session to submit form to.}

\item{form}{Form to submit}

\item{submit}{Name of submit button to use. If not supplied, defaults to
first submission button on the form (with a message).}

\item{...}{Additional arguments passed on to \code{\link[httr:GET]{httr::GET()}}
or \code{\link[httr:POST]{httr::POST()}}}
}
\value{
If successful, the parsed html response. Throws an error if http
request fails. To access other elements of response, construct it yourself
using the elements returned by \code{submit_request}.
}
\description{
Submit a form back to the server.
}
\examples{
test <- google_form("1M9B8DsYNFyDjpwSK6ur_bZf8Rv_04ma3rmaaBiveoUI")
f0 <- html_form(test)[[1]]
f1 <- set_values(f0, entry.564397473 = "abc")
}
