% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{get_geo_box}
\alias{get_geo_box}
\title{Get geographic entities based on a bounding box}
\usage{
get_geo_box(
  first_city_code,
  first_corner,
  second_city_code,
  second_corner,
  language = "en",
  ...
)
}
\arguments{
\item{first_city_code}{a Wikidata item, or series of items, to use for
one corner of the bounding box.}

\item{first_corner}{the direction of \code{first_city_code} relative
to \code{city} (eg "NorthWest", "SouthEast").}

\item{second_city_code}{a Wikidata item, or series of items, to use for
one corner of the bounding box.}

\item{second_corner}{the direction of \code{second_city_code} relative
to \code{city} (eg "NorthWest", "SouthEast").}

\item{language}{the two-letter language code to use for the name
of the item. "en" by default.}

\item{\\dots}{further arguments to pass to httr's GET.}
}
\value{
a data.frame of 5 columns:
\itemize{
 \item{item}{ the Wikidata identifier of each object associated with
 \code{entity}.}
 \item{name}{ the name of the item, if available, in the requested language. If it
 is not available, \code{NA} will be returned instead.}
 \item{latitude}{ the latitude of \code{item}}
 \item{longitude}{ the longitude of \code{item}}
 \item{entity}{ the entity the item is associated with (necessary for multi-entity
 queries).}
}
}
\description{
\code{get_geo_box} retrieves all geographic entities in
Wikidata that fall between a bounding box between two existing items
with geographic attributes (usually cities).
}
\examples{
# Simple bounding box
\donttest{bruges_box <- get_geo_box("Q12988", "NorthEast", "Q184287", "SouthWest")}

# Custom language
\donttest{bruges_box_fr <- get_geo_box("Q12988", "NorthEast", "Q184287", "SouthWest",
                                        language = "fr")}

}
\seealso{
\code{\link{get_geo_entity}} for using an unrestricted search or simple radius,
rather than a bounding box.
}
