% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with.R
\docType{package}
\name{withr}
\alias{withr-package}
\alias{withr}
\title{Execute code in temporarily altered environment}
\description{
All functions prefixed by \code{with_} work as follows. First, a particular
aspect of the global environment is modified (see below for a list).
Then, custom code (passed via the \code{code} argument) is executed.
Upon completion or error, the global environment is restored to the previous
state. Each \code{with_} function has a \code{local_} variant, which instead resets
the state when the current evaluation context ends (such as the end of a
function).
}
\section{Arguments pattern}{

\tabular{lll}{
\code{new} \tab \verb{[various]} \tab Values for setting \cr
\code{code} \tab \verb{[any]} \tab Code to execute in the temporary environment \cr
\code{...} \tab \tab Further arguments \cr
}
}

\section{Usage pattern}{

\code{with_...(new, code, ...)}
}

\section{withr functions}{

\itemize{
\item \code{\link[=with_collate]{with_collate()}}: collation order
\item \code{\link[=with_dir]{with_dir()}}: working directory
\item \code{\link[=with_envvar]{with_envvar()}}: environment variables
\item \code{\link[=with_libpaths]{with_libpaths()}}: library paths, replacing current libpaths
\item \code{\link[=with_locale]{with_locale()}}: any locale setting
\item \code{\link[=with_makevars]{with_makevars()}}: Makevars variables
\item \code{\link[=with_options]{with_options()}}: options
\item \code{\link[=with_par]{with_par()}}: graphics parameters
\item \code{\link[=with_path]{with_path()}}: \code{PATH} environment variable
\item \code{\link[=with_sink]{with_sink()}}: output redirection
}
}

\section{Creating new "with" functions}{

All \code{with_} functions are created by a helper function,
\code{\link[=with_]{with_()}}.  This functions accepts two arguments:
a setter function and an optional resetter function.  The setter function is
expected to change the global state and return an "undo instruction".
This undo instruction is then passed to the resetter function, which changes
back the global state. In many cases, the setter function can be used
naturally as resetter.
}

\examples{
getwd()
with_dir(tempdir(), getwd())
getwd()

Sys.getenv("WITHR")
with_envvar(c("WITHR" = 2), Sys.getenv("WITHR"))
Sys.getenv("WITHR")

with_envvar(c("A" = 1),
  with_envvar(c("A" = 2), action = "suffix", Sys.getenv("A"))
)

# local variants are best used within other functions
f <- function(x) {
  local_envvar(c("WITHR" = 2))
  Sys.getenv("WITHR")
}
Sys.getenv("WITHR")
}
\seealso{
Useful links:
\itemize{
  \item \url{https://withr.r-lib.org}
  \item \url{https://github.com/r-lib/withr#readme}
  \item Report bugs at \url{https://github.com/r-lib/withr/issues}
}

}
\author{
\strong{Maintainer}: Lionel Henry \email{lionel@posit.co}

Authors:
\itemize{
  \item Jim Hester
  \item Kirill Müller \email{krlmlr+r@mailbox.org}
  \item Kevin Ushey \email{kevinushey@gmail.com}
  \item Hadley Wickham \email{hadley@posit.co}
  \item Winston Chang
}

Other contributors:
\itemize{
  \item Jennifer Bryan [contributor]
  \item Richard Cotton [contributor]
  \item Posit Software, PBC [copyright holder, funder]
}

}
