/*
 * Copyright (C) 2000, 2001, 2002 Loic Dachary <loic@senga.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#ifdef RECOLL_DATADIR
#include "autoconfig.h"
#else
#include "config.h"
#endif /* RECOLL */
#endif /* HAVE_CONFIG_H */

#ifdef RECOLL_DATADIR
/* Yes, recoll unac is actually c++, lets face modernity, I will not be
   caught writing another binary search  */
#include <vector>
#include <map>
#include <string>
#include <algorithm>
using std::string;
using std::vector;
using std::map;
#include "smallut.h"

/* 
   Storage for the exception translations. These are chars which
   should not be translated according to what UnicodeData says, but
   instead according to some local rule. There will usually be very
   few of them, but they must be looked up for every translated char.
   
   We use a sorted vector for fastest elimination by binary search and
   a vector<string> to store the translations
 */
static vector<unsigned short> except_chars;
static vector<string> except_trans;
static inline size_t is_except_char(unsigned short c)
{
    vector<unsigned short>::iterator it = 
	std::lower_bound(except_chars.begin(), except_chars.end(), c);
    if (it == except_chars.end() || *it != c) {
	return (size_t(-1));
    }
    return std::distance(except_chars.begin(), it);
}
#endif /* RECOLL_DATADIR */

/*
 * If configure.in has not defined this symbol, assume const. It
 * does not harm much: a warning will be issued during compilation.
 */
#ifndef ICONV_CONST
#ifdef RCL_ICONV_INBUF_CONST
#define ICONV_CONST const
#else
#define ICONV_CONST
#endif
#endif /* ICONV_CONST */

#include <stdlib.h>
#include <string.h>
#include <iconv.h>
#include <errno.h>
#ifdef HAVE_VSNPRINTF
#include <stdio.h>
#include <stdarg.h>
#endif /* HAVE_VSNPRINTF */
#include <pthread.h>

#include "unac.h"
#include "unac_version.h"

/* Generated by builder. Do not modify. Start tables */
/*
 * 00A0 NO-BREAK SPACE
 * 	0020 SPACE
 * 00A8 DIAERESIS
 * 	0020 SPACE
 * 00AA FEMININE ORDINAL INDICATOR
 * 	0061 LATIN SMALL LETTER A
 * 00AF MACRON
 * 	0020 SPACE
 * 00B2 SUPERSCRIPT TWO
 * 	0032 DIGIT TWO
 * 00B3 SUPERSCRIPT THREE
 * 	0033 DIGIT THREE
 * 00B4 ACUTE ACCENT
 * 	0020 SPACE
 * 00B5 MICRO SIGN
 * 	03BC GREEK SMALL LETTER MU
 * 00B8 CEDILLA
 * 	0020 SPACE
 * 00B9 SUPERSCRIPT ONE
 * 	0031 DIGIT ONE
 * 00BA MASCULINE ORDINAL INDICATOR
 * 	006F LATIN SMALL LETTER O
 * 00BC VULGAR FRACTION ONE QUARTER
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 	0034 DIGIT FOUR
 * 00BD VULGAR FRACTION ONE HALF
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 	0032 DIGIT TWO
 * 00BE VULGAR FRACTION THREE QUARTERS
 * 	0033 DIGIT THREE
 * 	2044 FRACTION SLASH
 * 	0034 DIGIT FOUR
 * 00C0 LATIN CAPITAL LETTER A WITH GRAVE
 * 	0041 LATIN CAPITAL LETTER A
 * 00C1 LATIN CAPITAL LETTER A WITH ACUTE
 * 	0041 LATIN CAPITAL LETTER A
 * 00C2 LATIN CAPITAL LETTER A WITH CIRCUMFLEX
 * 	0041 LATIN CAPITAL LETTER A
 * 00C3 LATIN CAPITAL LETTER A WITH TILDE
 * 	0041 LATIN CAPITAL LETTER A
 * 00C4 LATIN CAPITAL LETTER A WITH DIAERESIS
 * 	0041 LATIN CAPITAL LETTER A
 * 00C5 LATIN CAPITAL LETTER A WITH RING ABOVE
 * 	0041 LATIN CAPITAL LETTER A
 * 00C7 LATIN CAPITAL LETTER C WITH CEDILLA
 * 	0043 LATIN CAPITAL LETTER C
 * 00C8 LATIN CAPITAL LETTER E WITH GRAVE
 * 	0045 LATIN CAPITAL LETTER E
 * 00C9 LATIN CAPITAL LETTER E WITH ACUTE
 * 	0045 LATIN CAPITAL LETTER E
 * 00CA LATIN CAPITAL LETTER E WITH CIRCUMFLEX
 * 	0045 LATIN CAPITAL LETTER E
 * 00CB LATIN CAPITAL LETTER E WITH DIAERESIS
 * 	0045 LATIN CAPITAL LETTER E
 * 00CC LATIN CAPITAL LETTER I WITH GRAVE
 * 	0049 LATIN CAPITAL LETTER I
 * 00CD LATIN CAPITAL LETTER I WITH ACUTE
 * 	0049 LATIN CAPITAL LETTER I
 * 00CE LATIN CAPITAL LETTER I WITH CIRCUMFLEX
 * 	0049 LATIN CAPITAL LETTER I
 * 00CF LATIN CAPITAL LETTER I WITH DIAERESIS
 * 	0049 LATIN CAPITAL LETTER I
 * 00D1 LATIN CAPITAL LETTER N WITH TILDE
 * 	004E LATIN CAPITAL LETTER N
 * 00D2 LATIN CAPITAL LETTER O WITH GRAVE
 * 	004F LATIN CAPITAL LETTER O
 * 00D3 LATIN CAPITAL LETTER O WITH ACUTE
 * 	004F LATIN CAPITAL LETTER O
 * 00D4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX
 * 	004F LATIN CAPITAL LETTER O
 * 00D5 LATIN CAPITAL LETTER O WITH TILDE
 * 	004F LATIN CAPITAL LETTER O
 * 00D6 LATIN CAPITAL LETTER O WITH DIAERESIS
 * 	004F LATIN CAPITAL LETTER O
 * 00D9 LATIN CAPITAL LETTER U WITH GRAVE
 * 	0055 LATIN CAPITAL LETTER U
 * 00DA LATIN CAPITAL LETTER U WITH ACUTE
 * 	0055 LATIN CAPITAL LETTER U
 * 00DB LATIN CAPITAL LETTER U WITH CIRCUMFLEX
 * 	0055 LATIN CAPITAL LETTER U
 * 00DC LATIN CAPITAL LETTER U WITH DIAERESIS
 * 	0055 LATIN CAPITAL LETTER U
 * 00DD LATIN CAPITAL LETTER Y WITH ACUTE
 * 	0059 LATIN CAPITAL LETTER Y
 * 00E0 LATIN SMALL LETTER A WITH GRAVE
 * 	0061 LATIN SMALL LETTER A
 * 00E1 LATIN SMALL LETTER A WITH ACUTE
 * 	0061 LATIN SMALL LETTER A
 * 00E2 LATIN SMALL LETTER A WITH CIRCUMFLEX
 * 	0061 LATIN SMALL LETTER A
 * 00E3 LATIN SMALL LETTER A WITH TILDE
 * 	0061 LATIN SMALL LETTER A
 * 00E4 LATIN SMALL LETTER A WITH DIAERESIS
 * 	0061 LATIN SMALL LETTER A
 * 00E5 LATIN SMALL LETTER A WITH RING ABOVE
 * 	0061 LATIN SMALL LETTER A
 * 00E7 LATIN SMALL LETTER C WITH CEDILLA
 * 	0063 LATIN SMALL LETTER C
 * 00E8 LATIN SMALL LETTER E WITH GRAVE
 * 	0065 LATIN SMALL LETTER E
 * 00E9 LATIN SMALL LETTER E WITH ACUTE
 * 	0065 LATIN SMALL LETTER E
 * 00EA LATIN SMALL LETTER E WITH CIRCUMFLEX
 * 	0065 LATIN SMALL LETTER E
 * 00EB LATIN SMALL LETTER E WITH DIAERESIS
 * 	0065 LATIN SMALL LETTER E
 * 00EC LATIN SMALL LETTER I WITH GRAVE
 * 	0069 LATIN SMALL LETTER I
 * 00ED LATIN SMALL LETTER I WITH ACUTE
 * 	0069 LATIN SMALL LETTER I
 * 00EE LATIN SMALL LETTER I WITH CIRCUMFLEX
 * 	0069 LATIN SMALL LETTER I
 * 00EF LATIN SMALL LETTER I WITH DIAERESIS
 * 	0069 LATIN SMALL LETTER I
 * 00F1 LATIN SMALL LETTER N WITH TILDE
 * 	006E LATIN SMALL LETTER N
 * 00F2 LATIN SMALL LETTER O WITH GRAVE
 * 	006F LATIN SMALL LETTER O
 * 00F3 LATIN SMALL LETTER O WITH ACUTE
 * 	006F LATIN SMALL LETTER O
 * 00F4 LATIN SMALL LETTER O WITH CIRCUMFLEX
 * 	006F LATIN SMALL LETTER O
 * 00F5 LATIN SMALL LETTER O WITH TILDE
 * 	006F LATIN SMALL LETTER O
 * 00F6 LATIN SMALL LETTER O WITH DIAERESIS
 * 	006F LATIN SMALL LETTER O
 * 00F9 LATIN SMALL LETTER U WITH GRAVE
 * 	0075 LATIN SMALL LETTER U
 * 00FA LATIN SMALL LETTER U WITH ACUTE
 * 	0075 LATIN SMALL LETTER U
 * 00FB LATIN SMALL LETTER U WITH CIRCUMFLEX
 * 	0075 LATIN SMALL LETTER U
 * 00FC LATIN SMALL LETTER U WITH DIAERESIS
 * 	0075 LATIN SMALL LETTER U
 * 00FD LATIN SMALL LETTER Y WITH ACUTE
 * 	0079 LATIN SMALL LETTER Y
 * 00FF LATIN SMALL LETTER Y WITH DIAERESIS
 * 	0079 LATIN SMALL LETTER Y
 * 0100 LATIN CAPITAL LETTER A WITH MACRON
 * 	0041 LATIN CAPITAL LETTER A
 * 0101 LATIN SMALL LETTER A WITH MACRON
 * 	0061 LATIN SMALL LETTER A
 * 0102 LATIN CAPITAL LETTER A WITH BREVE
 * 	0041 LATIN CAPITAL LETTER A
 * 0103 LATIN SMALL LETTER A WITH BREVE
 * 	0061 LATIN SMALL LETTER A
 * 0104 LATIN CAPITAL LETTER A WITH OGONEK
 * 	0041 LATIN CAPITAL LETTER A
 * 0105 LATIN SMALL LETTER A WITH OGONEK
 * 	0061 LATIN SMALL LETTER A
 * 0106 LATIN CAPITAL LETTER C WITH ACUTE
 * 	0043 LATIN CAPITAL LETTER C
 * 0107 LATIN SMALL LETTER C WITH ACUTE
 * 	0063 LATIN SMALL LETTER C
 * 0108 LATIN CAPITAL LETTER C WITH CIRCUMFLEX
 * 	0043 LATIN CAPITAL LETTER C
 * 0109 LATIN SMALL LETTER C WITH CIRCUMFLEX
 * 	0063 LATIN SMALL LETTER C
 * 010A LATIN CAPITAL LETTER C WITH DOT ABOVE
 * 	0043 LATIN CAPITAL LETTER C
 * 010B LATIN SMALL LETTER C WITH DOT ABOVE
 * 	0063 LATIN SMALL LETTER C
 * 010C LATIN CAPITAL LETTER C WITH CARON
 * 	0043 LATIN CAPITAL LETTER C
 * 010D LATIN SMALL LETTER C WITH CARON
 * 	0063 LATIN SMALL LETTER C
 * 010E LATIN CAPITAL LETTER D WITH CARON
 * 	0044 LATIN CAPITAL LETTER D
 * 010F LATIN SMALL LETTER D WITH CARON
 * 	0064 LATIN SMALL LETTER D
 * 0112 LATIN CAPITAL LETTER E WITH MACRON
 * 	0045 LATIN CAPITAL LETTER E
 * 0113 LATIN SMALL LETTER E WITH MACRON
 * 	0065 LATIN SMALL LETTER E
 * 0114 LATIN CAPITAL LETTER E WITH BREVE
 * 	0045 LATIN CAPITAL LETTER E
 * 0115 LATIN SMALL LETTER E WITH BREVE
 * 	0065 LATIN SMALL LETTER E
 * 0116 LATIN CAPITAL LETTER E WITH DOT ABOVE
 * 	0045 LATIN CAPITAL LETTER E
 * 0117 LATIN SMALL LETTER E WITH DOT ABOVE
 * 	0065 LATIN SMALL LETTER E
 * 0118 LATIN CAPITAL LETTER E WITH OGONEK
 * 	0045 LATIN CAPITAL LETTER E
 * 0119 LATIN SMALL LETTER E WITH OGONEK
 * 	0065 LATIN SMALL LETTER E
 * 011A LATIN CAPITAL LETTER E WITH CARON
 * 	0045 LATIN CAPITAL LETTER E
 * 011B LATIN SMALL LETTER E WITH CARON
 * 	0065 LATIN SMALL LETTER E
 * 011C LATIN CAPITAL LETTER G WITH CIRCUMFLEX
 * 	0047 LATIN CAPITAL LETTER G
 * 011D LATIN SMALL LETTER G WITH CIRCUMFLEX
 * 	0067 LATIN SMALL LETTER G
 * 011E LATIN CAPITAL LETTER G WITH BREVE
 * 	0047 LATIN CAPITAL LETTER G
 * 011F LATIN SMALL LETTER G WITH BREVE
 * 	0067 LATIN SMALL LETTER G
 * 0120 LATIN CAPITAL LETTER G WITH DOT ABOVE
 * 	0047 LATIN CAPITAL LETTER G
 * 0121 LATIN SMALL LETTER G WITH DOT ABOVE
 * 	0067 LATIN SMALL LETTER G
 * 0122 LATIN CAPITAL LETTER G WITH CEDILLA
 * 	0047 LATIN CAPITAL LETTER G
 * 0123 LATIN SMALL LETTER G WITH CEDILLA
 * 	0067 LATIN SMALL LETTER G
 * 0124 LATIN CAPITAL LETTER H WITH CIRCUMFLEX
 * 	0048 LATIN CAPITAL LETTER H
 * 0125 LATIN SMALL LETTER H WITH CIRCUMFLEX
 * 	0068 LATIN SMALL LETTER H
 * 0128 LATIN CAPITAL LETTER I WITH TILDE
 * 	0049 LATIN CAPITAL LETTER I
 * 0129 LATIN SMALL LETTER I WITH TILDE
 * 	0069 LATIN SMALL LETTER I
 * 012A LATIN CAPITAL LETTER I WITH MACRON
 * 	0049 LATIN CAPITAL LETTER I
 * 012B LATIN SMALL LETTER I WITH MACRON
 * 	0069 LATIN SMALL LETTER I
 * 012C LATIN CAPITAL LETTER I WITH BREVE
 * 	0049 LATIN CAPITAL LETTER I
 * 012D LATIN SMALL LETTER I WITH BREVE
 * 	0069 LATIN SMALL LETTER I
 * 012E LATIN CAPITAL LETTER I WITH OGONEK
 * 	0049 LATIN CAPITAL LETTER I
 * 012F LATIN SMALL LETTER I WITH OGONEK
 * 	0069 LATIN SMALL LETTER I
 * 0130 LATIN CAPITAL LETTER I WITH DOT ABOVE
 * 	0049 LATIN CAPITAL LETTER I
 * 0132 LATIN CAPITAL LIGATURE IJ
 * 	0049 LATIN CAPITAL LETTER I
 * 	004A LATIN CAPITAL LETTER J
 * 0133 LATIN SMALL LIGATURE IJ
 * 	0069 LATIN SMALL LETTER I
 * 	006A LATIN SMALL LETTER J
 * 0134 LATIN CAPITAL LETTER J WITH CIRCUMFLEX
 * 	004A LATIN CAPITAL LETTER J
 * 0135 LATIN SMALL LETTER J WITH CIRCUMFLEX
 * 	006A LATIN SMALL LETTER J
 * 0136 LATIN CAPITAL LETTER K WITH CEDILLA
 * 	004B LATIN CAPITAL LETTER K
 * 0137 LATIN SMALL LETTER K WITH CEDILLA
 * 	006B LATIN SMALL LETTER K
 * 0139 LATIN CAPITAL LETTER L WITH ACUTE
 * 	004C LATIN CAPITAL LETTER L
 * 013A LATIN SMALL LETTER L WITH ACUTE
 * 	006C LATIN SMALL LETTER L
 * 013B LATIN CAPITAL LETTER L WITH CEDILLA
 * 	004C LATIN CAPITAL LETTER L
 * 013C LATIN SMALL LETTER L WITH CEDILLA
 * 	006C LATIN SMALL LETTER L
 * 013D LATIN CAPITAL LETTER L WITH CARON
 * 	004C LATIN CAPITAL LETTER L
 * 013E LATIN SMALL LETTER L WITH CARON
 * 	006C LATIN SMALL LETTER L
 * 013F LATIN CAPITAL LETTER L WITH MIDDLE DOT
 * 	004C LATIN CAPITAL LETTER L
 * 	00B7 MIDDLE DOT
 * 0140 LATIN SMALL LETTER L WITH MIDDLE DOT
 * 	006C LATIN SMALL LETTER L
 * 	00B7 MIDDLE DOT
 * 0143 LATIN CAPITAL LETTER N WITH ACUTE
 * 	004E LATIN CAPITAL LETTER N
 * 0144 LATIN SMALL LETTER N WITH ACUTE
 * 	006E LATIN SMALL LETTER N
 * 0145 LATIN CAPITAL LETTER N WITH CEDILLA
 * 	004E LATIN CAPITAL LETTER N
 * 0146 LATIN SMALL LETTER N WITH CEDILLA
 * 	006E LATIN SMALL LETTER N
 * 0147 LATIN CAPITAL LETTER N WITH CARON
 * 	004E LATIN CAPITAL LETTER N
 * 0148 LATIN SMALL LETTER N WITH CARON
 * 	006E LATIN SMALL LETTER N
 * 0149 LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
 * 	02BC MODIFIER LETTER APOSTROPHE
 * 	006E LATIN SMALL LETTER N
 * 014C LATIN CAPITAL LETTER O WITH MACRON
 * 	004F LATIN CAPITAL LETTER O
 * 014D LATIN SMALL LETTER O WITH MACRON
 * 	006F LATIN SMALL LETTER O
 * 014E LATIN CAPITAL LETTER O WITH BREVE
 * 	004F LATIN CAPITAL LETTER O
 * 014F LATIN SMALL LETTER O WITH BREVE
 * 	006F LATIN SMALL LETTER O
 * 0150 LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
 * 	004F LATIN CAPITAL LETTER O
 * 0151 LATIN SMALL LETTER O WITH DOUBLE ACUTE
 * 	006F LATIN SMALL LETTER O
 * 0154 LATIN CAPITAL LETTER R WITH ACUTE
 * 	0052 LATIN CAPITAL LETTER R
 * 0155 LATIN SMALL LETTER R WITH ACUTE
 * 	0072 LATIN SMALL LETTER R
 * 0156 LATIN CAPITAL LETTER R WITH CEDILLA
 * 	0052 LATIN CAPITAL LETTER R
 * 0157 LATIN SMALL LETTER R WITH CEDILLA
 * 	0072 LATIN SMALL LETTER R
 * 0158 LATIN CAPITAL LETTER R WITH CARON
 * 	0052 LATIN CAPITAL LETTER R
 * 0159 LATIN SMALL LETTER R WITH CARON
 * 	0072 LATIN SMALL LETTER R
 * 015A LATIN CAPITAL LETTER S WITH ACUTE
 * 	0053 LATIN CAPITAL LETTER S
 * 015B LATIN SMALL LETTER S WITH ACUTE
 * 	0073 LATIN SMALL LETTER S
 * 015C LATIN CAPITAL LETTER S WITH CIRCUMFLEX
 * 	0053 LATIN CAPITAL LETTER S
 * 015D LATIN SMALL LETTER S WITH CIRCUMFLEX
 * 	0073 LATIN SMALL LETTER S
 * 015E LATIN CAPITAL LETTER S WITH CEDILLA
 * 	0053 LATIN CAPITAL LETTER S
 * 015F LATIN SMALL LETTER S WITH CEDILLA
 * 	0073 LATIN SMALL LETTER S
 * 0160 LATIN CAPITAL LETTER S WITH CARON
 * 	0053 LATIN CAPITAL LETTER S
 * 0161 LATIN SMALL LETTER S WITH CARON
 * 	0073 LATIN SMALL LETTER S
 * 0162 LATIN CAPITAL LETTER T WITH CEDILLA
 * 	0054 LATIN CAPITAL LETTER T
 * 0163 LATIN SMALL LETTER T WITH CEDILLA
 * 	0074 LATIN SMALL LETTER T
 * 0164 LATIN CAPITAL LETTER T WITH CARON
 * 	0054 LATIN CAPITAL LETTER T
 * 0165 LATIN SMALL LETTER T WITH CARON
 * 	0074 LATIN SMALL LETTER T
 * 0168 LATIN CAPITAL LETTER U WITH TILDE
 * 	0055 LATIN CAPITAL LETTER U
 * 0169 LATIN SMALL LETTER U WITH TILDE
 * 	0075 LATIN SMALL LETTER U
 * 016A LATIN CAPITAL LETTER U WITH MACRON
 * 	0055 LATIN CAPITAL LETTER U
 * 016B LATIN SMALL LETTER U WITH MACRON
 * 	0075 LATIN SMALL LETTER U
 * 016C LATIN CAPITAL LETTER U WITH BREVE
 * 	0055 LATIN CAPITAL LETTER U
 * 016D LATIN SMALL LETTER U WITH BREVE
 * 	0075 LATIN SMALL LETTER U
 * 016E LATIN CAPITAL LETTER U WITH RING ABOVE
 * 	0055 LATIN CAPITAL LETTER U
 * 016F LATIN SMALL LETTER U WITH RING ABOVE
 * 	0075 LATIN SMALL LETTER U
 * 0170 LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
 * 	0055 LATIN CAPITAL LETTER U
 * 0171 LATIN SMALL LETTER U WITH DOUBLE ACUTE
 * 	0075 LATIN SMALL LETTER U
 * 0172 LATIN CAPITAL LETTER U WITH OGONEK
 * 	0055 LATIN CAPITAL LETTER U
 * 0173 LATIN SMALL LETTER U WITH OGONEK
 * 	0075 LATIN SMALL LETTER U
 * 0174 LATIN CAPITAL LETTER W WITH CIRCUMFLEX
 * 	0057 LATIN CAPITAL LETTER W
 * 0175 LATIN SMALL LETTER W WITH CIRCUMFLEX
 * 	0077 LATIN SMALL LETTER W
 * 0176 LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
 * 	0059 LATIN CAPITAL LETTER Y
 * 0177 LATIN SMALL LETTER Y WITH CIRCUMFLEX
 * 	0079 LATIN SMALL LETTER Y
 * 0178 LATIN CAPITAL LETTER Y WITH DIAERESIS
 * 	0059 LATIN CAPITAL LETTER Y
 * 0179 LATIN CAPITAL LETTER Z WITH ACUTE
 * 	005A LATIN CAPITAL LETTER Z
 * 017A LATIN SMALL LETTER Z WITH ACUTE
 * 	007A LATIN SMALL LETTER Z
 * 017B LATIN CAPITAL LETTER Z WITH DOT ABOVE
 * 	005A LATIN CAPITAL LETTER Z
 * 017C LATIN SMALL LETTER Z WITH DOT ABOVE
 * 	007A LATIN SMALL LETTER Z
 * 017D LATIN CAPITAL LETTER Z WITH CARON
 * 	005A LATIN CAPITAL LETTER Z
 * 017E LATIN SMALL LETTER Z WITH CARON
 * 	007A LATIN SMALL LETTER Z
 * 017F LATIN SMALL LETTER LONG S
 * 	0073 LATIN SMALL LETTER S
 * 01A0 LATIN CAPITAL LETTER O WITH HORN
 * 	004F LATIN CAPITAL LETTER O
 * 01A1 LATIN SMALL LETTER O WITH HORN
 * 	006F LATIN SMALL LETTER O
 * 01AF LATIN CAPITAL LETTER U WITH HORN
 * 	0055 LATIN CAPITAL LETTER U
 * 01B0 LATIN SMALL LETTER U WITH HORN
 * 	0075 LATIN SMALL LETTER U
 * 01C4 LATIN CAPITAL LETTER DZ WITH CARON
 * 	0044 LATIN CAPITAL LETTER D
 * 	005A LATIN CAPITAL LETTER Z
 * 01C5 LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
 * 	0044 LATIN CAPITAL LETTER D
 * 	007A LATIN SMALL LETTER Z
 * 01C6 LATIN SMALL LETTER DZ WITH CARON
 * 	0064 LATIN SMALL LETTER D
 * 	007A LATIN SMALL LETTER Z
 * 01C7 LATIN CAPITAL LETTER LJ
 * 	004C LATIN CAPITAL LETTER L
 * 	004A LATIN CAPITAL LETTER J
 * 01C8 LATIN CAPITAL LETTER L WITH SMALL LETTER J
 * 	004C LATIN CAPITAL LETTER L
 * 	006A LATIN SMALL LETTER J
 * 01C9 LATIN SMALL LETTER LJ
 * 	006C LATIN SMALL LETTER L
 * 	006A LATIN SMALL LETTER J
 * 01CA LATIN CAPITAL LETTER NJ
 * 	004E LATIN CAPITAL LETTER N
 * 	004A LATIN CAPITAL LETTER J
 * 01CB LATIN CAPITAL LETTER N WITH SMALL LETTER J
 * 	004E LATIN CAPITAL LETTER N
 * 	006A LATIN SMALL LETTER J
 * 01CC LATIN SMALL LETTER NJ
 * 	006E LATIN SMALL LETTER N
 * 	006A LATIN SMALL LETTER J
 * 01CD LATIN CAPITAL LETTER A WITH CARON
 * 	0041 LATIN CAPITAL LETTER A
 * 01CE LATIN SMALL LETTER A WITH CARON
 * 	0061 LATIN SMALL LETTER A
 * 01CF LATIN CAPITAL LETTER I WITH CARON
 * 	0049 LATIN CAPITAL LETTER I
 * 01D0 LATIN SMALL LETTER I WITH CARON
 * 	0069 LATIN SMALL LETTER I
 * 01D1 LATIN CAPITAL LETTER O WITH CARON
 * 	004F LATIN CAPITAL LETTER O
 * 01D2 LATIN SMALL LETTER O WITH CARON
 * 	006F LATIN SMALL LETTER O
 * 01D3 LATIN CAPITAL LETTER U WITH CARON
 * 	0055 LATIN CAPITAL LETTER U
 * 01D4 LATIN SMALL LETTER U WITH CARON
 * 	0075 LATIN SMALL LETTER U
 * 01D5 LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
 * 	0055 LATIN CAPITAL LETTER U
 * 01D6 LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
 * 	0075 LATIN SMALL LETTER U
 * 01D7 LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
 * 	0055 LATIN CAPITAL LETTER U
 * 01D8 LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
 * 	0075 LATIN SMALL LETTER U
 * 01D9 LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
 * 	0055 LATIN CAPITAL LETTER U
 * 01DA LATIN SMALL LETTER U WITH DIAERESIS AND CARON
 * 	0075 LATIN SMALL LETTER U
 * 01DB LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
 * 	0055 LATIN CAPITAL LETTER U
 * 01DC LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
 * 	0075 LATIN SMALL LETTER U
 * 01DE LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
 * 	0041 LATIN CAPITAL LETTER A
 * 01DF LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
 * 	0061 LATIN SMALL LETTER A
 * 01E0 LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
 * 	0041 LATIN CAPITAL LETTER A
 * 01E1 LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
 * 	0061 LATIN SMALL LETTER A
 * 01E2 LATIN CAPITAL LETTER AE WITH MACRON
 * 	00C6 LATIN CAPITAL LETTER AE
 * 01E3 LATIN SMALL LETTER AE WITH MACRON
 * 	00E6 LATIN SMALL LETTER AE
 * 01E6 LATIN CAPITAL LETTER G WITH CARON
 * 	0047 LATIN CAPITAL LETTER G
 * 01E7 LATIN SMALL LETTER G WITH CARON
 * 	0067 LATIN SMALL LETTER G
 * 01E8 LATIN CAPITAL LETTER K WITH CARON
 * 	004B LATIN CAPITAL LETTER K
 * 01E9 LATIN SMALL LETTER K WITH CARON
 * 	006B LATIN SMALL LETTER K
 * 01EA LATIN CAPITAL LETTER O WITH OGONEK
 * 	004F LATIN CAPITAL LETTER O
 * 01EB LATIN SMALL LETTER O WITH OGONEK
 * 	006F LATIN SMALL LETTER O
 * 01EC LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
 * 	004F LATIN CAPITAL LETTER O
 * 01ED LATIN SMALL LETTER O WITH OGONEK AND MACRON
 * 	006F LATIN SMALL LETTER O
 * 01EE LATIN CAPITAL LETTER EZH WITH CARON
 * 	01B7 LATIN CAPITAL LETTER EZH
 * 01EF LATIN SMALL LETTER EZH WITH CARON
 * 	0292 LATIN SMALL LETTER EZH
 * 01F0 LATIN SMALL LETTER J WITH CARON
 * 	006A LATIN SMALL LETTER J
 * 01F1 LATIN CAPITAL LETTER DZ
 * 	0044 LATIN CAPITAL LETTER D
 * 	005A LATIN CAPITAL LETTER Z
 * 01F2 LATIN CAPITAL LETTER D WITH SMALL LETTER Z
 * 	0044 LATIN CAPITAL LETTER D
 * 	007A LATIN SMALL LETTER Z
 * 01F3 LATIN SMALL LETTER DZ
 * 	0064 LATIN SMALL LETTER D
 * 	007A LATIN SMALL LETTER Z
 * 01F4 LATIN CAPITAL LETTER G WITH ACUTE
 * 	0047 LATIN CAPITAL LETTER G
 * 01F5 LATIN SMALL LETTER G WITH ACUTE
 * 	0067 LATIN SMALL LETTER G
 * 01F8 LATIN CAPITAL LETTER N WITH GRAVE
 * 	004E LATIN CAPITAL LETTER N
 * 01F9 LATIN SMALL LETTER N WITH GRAVE
 * 	006E LATIN SMALL LETTER N
 * 01FA LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
 * 	0041 LATIN CAPITAL LETTER A
 * 01FB LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
 * 	0061 LATIN SMALL LETTER A
 * 01FC LATIN CAPITAL LETTER AE WITH ACUTE
 * 	00C6 LATIN CAPITAL LETTER AE
 * 01FD LATIN SMALL LETTER AE WITH ACUTE
 * 	00E6 LATIN SMALL LETTER AE
 * 01FE LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
 * 	00D8 LATIN CAPITAL LETTER O WITH STROKE
 * 01FF LATIN SMALL LETTER O WITH STROKE AND ACUTE
 * 	00F8 LATIN SMALL LETTER O WITH STROKE
 * 0200 LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
 * 	0041 LATIN CAPITAL LETTER A
 * 0201 LATIN SMALL LETTER A WITH DOUBLE GRAVE
 * 	0061 LATIN SMALL LETTER A
 * 0202 LATIN CAPITAL LETTER A WITH INVERTED BREVE
 * 	0041 LATIN CAPITAL LETTER A
 * 0203 LATIN SMALL LETTER A WITH INVERTED BREVE
 * 	0061 LATIN SMALL LETTER A
 * 0204 LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
 * 	0045 LATIN CAPITAL LETTER E
 * 0205 LATIN SMALL LETTER E WITH DOUBLE GRAVE
 * 	0065 LATIN SMALL LETTER E
 * 0206 LATIN CAPITAL LETTER E WITH INVERTED BREVE
 * 	0045 LATIN CAPITAL LETTER E
 * 0207 LATIN SMALL LETTER E WITH INVERTED BREVE
 * 	0065 LATIN SMALL LETTER E
 * 0208 LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
 * 	0049 LATIN CAPITAL LETTER I
 * 0209 LATIN SMALL LETTER I WITH DOUBLE GRAVE
 * 	0069 LATIN SMALL LETTER I
 * 020A LATIN CAPITAL LETTER I WITH INVERTED BREVE
 * 	0049 LATIN CAPITAL LETTER I
 * 020B LATIN SMALL LETTER I WITH INVERTED BREVE
 * 	0069 LATIN SMALL LETTER I
 * 020C LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
 * 	004F LATIN CAPITAL LETTER O
 * 020D LATIN SMALL LETTER O WITH DOUBLE GRAVE
 * 	006F LATIN SMALL LETTER O
 * 020E LATIN CAPITAL LETTER O WITH INVERTED BREVE
 * 	004F LATIN CAPITAL LETTER O
 * 020F LATIN SMALL LETTER O WITH INVERTED BREVE
 * 	006F LATIN SMALL LETTER O
 * 0210 LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
 * 	0052 LATIN CAPITAL LETTER R
 * 0211 LATIN SMALL LETTER R WITH DOUBLE GRAVE
 * 	0072 LATIN SMALL LETTER R
 * 0212 LATIN CAPITAL LETTER R WITH INVERTED BREVE
 * 	0052 LATIN CAPITAL LETTER R
 * 0213 LATIN SMALL LETTER R WITH INVERTED BREVE
 * 	0072 LATIN SMALL LETTER R
 * 0214 LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
 * 	0055 LATIN CAPITAL LETTER U
 * 0215 LATIN SMALL LETTER U WITH DOUBLE GRAVE
 * 	0075 LATIN SMALL LETTER U
 * 0216 LATIN CAPITAL LETTER U WITH INVERTED BREVE
 * 	0055 LATIN CAPITAL LETTER U
 * 0217 LATIN SMALL LETTER U WITH INVERTED BREVE
 * 	0075 LATIN SMALL LETTER U
 * 0218 LATIN CAPITAL LETTER S WITH COMMA BELOW
 * 	0053 LATIN CAPITAL LETTER S
 * 0219 LATIN SMALL LETTER S WITH COMMA BELOW
 * 	0073 LATIN SMALL LETTER S
 * 021A LATIN CAPITAL LETTER T WITH COMMA BELOW
 * 	0054 LATIN CAPITAL LETTER T
 * 021B LATIN SMALL LETTER T WITH COMMA BELOW
 * 	0074 LATIN SMALL LETTER T
 * 021E LATIN CAPITAL LETTER H WITH CARON
 * 	0048 LATIN CAPITAL LETTER H
 * 021F LATIN SMALL LETTER H WITH CARON
 * 	0068 LATIN SMALL LETTER H
 * 0226 LATIN CAPITAL LETTER A WITH DOT ABOVE
 * 	0041 LATIN CAPITAL LETTER A
 * 0227 LATIN SMALL LETTER A WITH DOT ABOVE
 * 	0061 LATIN SMALL LETTER A
 * 0228 LATIN CAPITAL LETTER E WITH CEDILLA
 * 	0045 LATIN CAPITAL LETTER E
 * 0229 LATIN SMALL LETTER E WITH CEDILLA
 * 	0065 LATIN SMALL LETTER E
 * 022A LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
 * 	004F LATIN CAPITAL LETTER O
 * 022B LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
 * 	006F LATIN SMALL LETTER O
 * 022C LATIN CAPITAL LETTER O WITH TILDE AND MACRON
 * 	004F LATIN CAPITAL LETTER O
 * 022D LATIN SMALL LETTER O WITH TILDE AND MACRON
 * 	006F LATIN SMALL LETTER O
 * 022E LATIN CAPITAL LETTER O WITH DOT ABOVE
 * 	004F LATIN CAPITAL LETTER O
 * 022F LATIN SMALL LETTER O WITH DOT ABOVE
 * 	006F LATIN SMALL LETTER O
 * 0230 LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
 * 	004F LATIN CAPITAL LETTER O
 * 0231 LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
 * 	006F LATIN SMALL LETTER O
 * 0232 LATIN CAPITAL LETTER Y WITH MACRON
 * 	0059 LATIN CAPITAL LETTER Y
 * 0233 LATIN SMALL LETTER Y WITH MACRON
 * 	0079 LATIN SMALL LETTER Y
 * 02B0 MODIFIER LETTER SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 02B1 MODIFIER LETTER SMALL H WITH HOOK
 * 	0266 LATIN SMALL LETTER H WITH HOOK
 * 02B2 MODIFIER LETTER SMALL J
 * 	006A LATIN SMALL LETTER J
 * 02B3 MODIFIER LETTER SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 02B4 MODIFIER LETTER SMALL TURNED R
 * 	0279 LATIN SMALL LETTER TURNED R
 * 02B5 MODIFIER LETTER SMALL TURNED R WITH HOOK
 * 	027B LATIN SMALL LETTER TURNED R WITH HOOK
 * 02B6 MODIFIER LETTER SMALL CAPITAL INVERTED R
 * 	0281 LATIN LETTER SMALL CAPITAL INVERTED R
 * 02B7 MODIFIER LETTER SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 02B8 MODIFIER LETTER SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 02D8 BREVE
 * 	0020 SPACE
 * 02D9 DOT ABOVE
 * 	0020 SPACE
 * 02DA RING ABOVE
 * 	0020 SPACE
 * 02DB OGONEK
 * 	0020 SPACE
 * 02DC SMALL TILDE
 * 	0020 SPACE
 * 02DD DOUBLE ACUTE ACCENT
 * 	0020 SPACE
 * 02E0 MODIFIER LETTER SMALL GAMMA
 * 	0263 LATIN SMALL LETTER GAMMA
 * 02E1 MODIFIER LETTER SMALL L
 * 	006C LATIN SMALL LETTER L
 * 02E2 MODIFIER LETTER SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 02E3 MODIFIER LETTER SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 02E4 MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
 * 	0295 LATIN LETTER PHARYNGEAL VOICED FRICATIVE
 * 0300 COMBINING GRAVE ACCENT
 * 	0000 <control>
 * 0301 COMBINING ACUTE ACCENT
 * 	0000 <control>
 * 0302 COMBINING CIRCUMFLEX ACCENT
 * 	0000 <control>
 * 0303 COMBINING TILDE
 * 	0000 <control>
 * 0304 COMBINING MACRON
 * 	0000 <control>
 * 0305 COMBINING OVERLINE
 * 	0000 <control>
 * 0306 COMBINING BREVE
 * 	0000 <control>
 * 0307 COMBINING DOT ABOVE
 * 	0000 <control>
 * 0308 COMBINING DIAERESIS
 * 	0000 <control>
 * 0309 COMBINING HOOK ABOVE
 * 	0000 <control>
 * 030A COMBINING RING ABOVE
 * 	0000 <control>
 * 030B COMBINING DOUBLE ACUTE ACCENT
 * 	0000 <control>
 * 030C COMBINING CARON
 * 	0000 <control>
 * 030D COMBINING VERTICAL LINE ABOVE
 * 	0000 <control>
 * 030E COMBINING DOUBLE VERTICAL LINE ABOVE
 * 	0000 <control>
 * 030F COMBINING DOUBLE GRAVE ACCENT
 * 	0000 <control>
 * 0310 COMBINING CANDRABINDU
 * 	0000 <control>
 * 0311 COMBINING INVERTED BREVE
 * 	0000 <control>
 * 0312 COMBINING TURNED COMMA ABOVE
 * 	0000 <control>
 * 0313 COMBINING COMMA ABOVE
 * 	0000 <control>
 * 0314 COMBINING REVERSED COMMA ABOVE
 * 	0000 <control>
 * 0315 COMBINING COMMA ABOVE RIGHT
 * 	0000 <control>
 * 0316 COMBINING GRAVE ACCENT BELOW
 * 	0000 <control>
 * 0317 COMBINING ACUTE ACCENT BELOW
 * 	0000 <control>
 * 0318 COMBINING LEFT TACK BELOW
 * 	0000 <control>
 * 0319 COMBINING RIGHT TACK BELOW
 * 	0000 <control>
 * 031A COMBINING LEFT ANGLE ABOVE
 * 	0000 <control>
 * 031B COMBINING HORN
 * 	0000 <control>
 * 031C COMBINING LEFT HALF RING BELOW
 * 	0000 <control>
 * 031D COMBINING UP TACK BELOW
 * 	0000 <control>
 * 031E COMBINING DOWN TACK BELOW
 * 	0000 <control>
 * 031F COMBINING PLUS SIGN BELOW
 * 	0000 <control>
 * 0320 COMBINING MINUS SIGN BELOW
 * 	0000 <control>
 * 0321 COMBINING PALATALIZED HOOK BELOW
 * 	0000 <control>
 * 0322 COMBINING RETROFLEX HOOK BELOW
 * 	0000 <control>
 * 0323 COMBINING DOT BELOW
 * 	0000 <control>
 * 0324 COMBINING DIAERESIS BELOW
 * 	0000 <control>
 * 0325 COMBINING RING BELOW
 * 	0000 <control>
 * 0326 COMBINING COMMA BELOW
 * 	0000 <control>
 * 0327 COMBINING CEDILLA
 * 	0000 <control>
 * 0328 COMBINING OGONEK
 * 	0000 <control>
 * 0329 COMBINING VERTICAL LINE BELOW
 * 	0000 <control>
 * 032A COMBINING BRIDGE BELOW
 * 	0000 <control>
 * 032B COMBINING INVERTED DOUBLE ARCH BELOW
 * 	0000 <control>
 * 032C COMBINING CARON BELOW
 * 	0000 <control>
 * 032D COMBINING CIRCUMFLEX ACCENT BELOW
 * 	0000 <control>
 * 032E COMBINING BREVE BELOW
 * 	0000 <control>
 * 032F COMBINING INVERTED BREVE BELOW
 * 	0000 <control>
 * 0330 COMBINING TILDE BELOW
 * 	0000 <control>
 * 0331 COMBINING MACRON BELOW
 * 	0000 <control>
 * 0332 COMBINING LOW LINE
 * 	0000 <control>
 * 0333 COMBINING DOUBLE LOW LINE
 * 	0000 <control>
 * 0334 COMBINING TILDE OVERLAY
 * 	0000 <control>
 * 0335 COMBINING SHORT STROKE OVERLAY
 * 	0000 <control>
 * 0336 COMBINING LONG STROKE OVERLAY
 * 	0000 <control>
 * 0337 COMBINING SHORT SOLIDUS OVERLAY
 * 	0000 <control>
 * 0338 COMBINING LONG SOLIDUS OVERLAY
 * 	0000 <control>
 * 0339 COMBINING RIGHT HALF RING BELOW
 * 	0000 <control>
 * 033A COMBINING INVERTED BRIDGE BELOW
 * 	0000 <control>
 * 033B COMBINING SQUARE BELOW
 * 	0000 <control>
 * 033C COMBINING SEAGULL BELOW
 * 	0000 <control>
 * 033D COMBINING X ABOVE
 * 	0000 <control>
 * 033E COMBINING VERTICAL TILDE
 * 	0000 <control>
 * 033F COMBINING DOUBLE OVERLINE
 * 	0000 <control>
 * 0340 COMBINING GRAVE TONE MARK
 * 	0000 <control>
 * 0341 COMBINING ACUTE TONE MARK
 * 	0000 <control>
 * 0342 COMBINING GREEK PERISPOMENI
 * 	0000 <control>
 * 0343 COMBINING GREEK KORONIS
 * 	0000 <control>
 * 0344 COMBINING GREEK DIALYTIKA TONOS
 * 	0000 <control>
 * 0345 COMBINING GREEK YPOGEGRAMMENI
 * 	0000 <control>
 * 0346 COMBINING BRIDGE ABOVE
 * 	0000 <control>
 * 0347 COMBINING EQUALS SIGN BELOW
 * 	0000 <control>
 * 0348 COMBINING DOUBLE VERTICAL LINE BELOW
 * 	0000 <control>
 * 0349 COMBINING LEFT ANGLE BELOW
 * 	0000 <control>
 * 034A COMBINING NOT TILDE ABOVE
 * 	0000 <control>
 * 034B COMBINING HOMOTHETIC ABOVE
 * 	0000 <control>
 * 034C COMBINING ALMOST EQUAL TO ABOVE
 * 	0000 <control>
 * 034D COMBINING LEFT RIGHT ARROW BELOW
 * 	0000 <control>
 * 034E COMBINING UPWARDS ARROW BELOW
 * 	0000 <control>
 * 034F COMBINING GRAPHEME JOINER
 * 	0000 <control>
 * 0350 COMBINING RIGHT ARROWHEAD ABOVE
 * 	0000 <control>
 * 0351 COMBINING LEFT HALF RING ABOVE
 * 	0000 <control>
 * 0352 COMBINING FERMATA
 * 	0000 <control>
 * 0353 COMBINING X BELOW
 * 	0000 <control>
 * 0354 COMBINING LEFT ARROWHEAD BELOW
 * 	0000 <control>
 * 0355 COMBINING RIGHT ARROWHEAD BELOW
 * 	0000 <control>
 * 0356 COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW
 * 	0000 <control>
 * 0357 COMBINING RIGHT HALF RING ABOVE
 * 	0000 <control>
 * 0358 COMBINING DOT ABOVE RIGHT
 * 	0000 <control>
 * 0359 COMBINING ASTERISK BELOW
 * 	0000 <control>
 * 035A COMBINING DOUBLE RING BELOW
 * 	0000 <control>
 * 035B COMBINING ZIGZAG ABOVE
 * 	0000 <control>
 * 035C COMBINING DOUBLE BREVE BELOW
 * 	0000 <control>
 * 035D COMBINING DOUBLE BREVE
 * 	0000 <control>
 * 035E COMBINING DOUBLE MACRON
 * 	0000 <control>
 * 035F COMBINING DOUBLE MACRON BELOW
 * 	0000 <control>
 * 0360 COMBINING DOUBLE TILDE
 * 	0000 <control>
 * 0361 COMBINING DOUBLE INVERTED BREVE
 * 	0000 <control>
 * 0362 COMBINING DOUBLE RIGHTWARDS ARROW BELOW
 * 	0000 <control>
 * 0363 COMBINING LATIN SMALL LETTER A
 * 	0000 <control>
 * 0364 COMBINING LATIN SMALL LETTER E
 * 	0000 <control>
 * 0365 COMBINING LATIN SMALL LETTER I
 * 	0000 <control>
 * 0366 COMBINING LATIN SMALL LETTER O
 * 	0000 <control>
 * 0367 COMBINING LATIN SMALL LETTER U
 * 	0000 <control>
 * 0368 COMBINING LATIN SMALL LETTER C
 * 	0000 <control>
 * 0369 COMBINING LATIN SMALL LETTER D
 * 	0000 <control>
 * 036A COMBINING LATIN SMALL LETTER H
 * 	0000 <control>
 * 036B COMBINING LATIN SMALL LETTER M
 * 	0000 <control>
 * 036C COMBINING LATIN SMALL LETTER R
 * 	0000 <control>
 * 036D COMBINING LATIN SMALL LETTER T
 * 	0000 <control>
 * 036E COMBINING LATIN SMALL LETTER V
 * 	0000 <control>
 * 036F COMBINING LATIN SMALL LETTER X
 * 	0000 <control>
 * 0374 GREEK NUMERAL SIGN
 * 	02B9 MODIFIER LETTER PRIME
 * 037A GREEK YPOGEGRAMMENI
 * 	0020 SPACE
 * 037E GREEK QUESTION MARK
 * 	003B SEMICOLON
 * 0384 GREEK TONOS
 * 	0020 SPACE
 * 0385 GREEK DIALYTIKA TONOS
 * 	0020 SPACE
 * 0386 GREEK CAPITAL LETTER ALPHA WITH TONOS
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 0387 GREEK ANO TELEIA
 * 	00B7 MIDDLE DOT
 * 0388 GREEK CAPITAL LETTER EPSILON WITH TONOS
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 0389 GREEK CAPITAL LETTER ETA WITH TONOS
 * 	0397 GREEK CAPITAL LETTER ETA
 * 038A GREEK CAPITAL LETTER IOTA WITH TONOS
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 038C GREEK CAPITAL LETTER OMICRON WITH TONOS
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 038E GREEK CAPITAL LETTER UPSILON WITH TONOS
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 038F GREEK CAPITAL LETTER OMEGA WITH TONOS
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 0390 GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
 * 	03B9 GREEK SMALL LETTER IOTA
 * 03AA GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 03AB GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 03AC GREEK SMALL LETTER ALPHA WITH TONOS
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 03AD GREEK SMALL LETTER EPSILON WITH TONOS
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 03AE GREEK SMALL LETTER ETA WITH TONOS
 * 	03B7 GREEK SMALL LETTER ETA
 * 03AF GREEK SMALL LETTER IOTA WITH TONOS
 * 	03B9 GREEK SMALL LETTER IOTA
 * 03B0 GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 03CA GREEK SMALL LETTER IOTA WITH DIALYTIKA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 03CB GREEK SMALL LETTER UPSILON WITH DIALYTIKA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 03CC GREEK SMALL LETTER OMICRON WITH TONOS
 * 	03BF GREEK SMALL LETTER OMICRON
 * 03CD GREEK SMALL LETTER UPSILON WITH TONOS
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 03CE GREEK SMALL LETTER OMEGA WITH TONOS
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 03D0 GREEK BETA SYMBOL
 * 	03B2 GREEK SMALL LETTER BETA
 * 03D1 GREEK THETA SYMBOL
 * 	03B8 GREEK SMALL LETTER THETA
 * 03D2 GREEK UPSILON WITH HOOK SYMBOL
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 03D3 GREEK UPSILON WITH ACUTE AND HOOK SYMBOL
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 03D4 GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 03D5 GREEK PHI SYMBOL
 * 	03C6 GREEK SMALL LETTER PHI
 * 03D6 GREEK PI SYMBOL
 * 	03C0 GREEK SMALL LETTER PI
 * 03F0 GREEK KAPPA SYMBOL
 * 	03BA GREEK SMALL LETTER KAPPA
 * 03F1 GREEK RHO SYMBOL
 * 	03C1 GREEK SMALL LETTER RHO
 * 03F2 GREEK LUNATE SIGMA SYMBOL
 * 	03C2 GREEK SMALL LETTER FINAL SIGMA
 * 03F4 GREEK CAPITAL THETA SYMBOL
 * 	0398 GREEK CAPITAL LETTER THETA
 * 03F5 GREEK LUNATE EPSILON SYMBOL
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 03F9 GREEK CAPITAL LUNATE SIGMA SYMBOL
 * 	03A3 GREEK CAPITAL LETTER SIGMA
 * 0400 CYRILLIC CAPITAL LETTER IE WITH GRAVE
 * 	0415 CYRILLIC CAPITAL LETTER IE
 * 0401 CYRILLIC CAPITAL LETTER IO
 * 	0415 CYRILLIC CAPITAL LETTER IE
 * 0403 CYRILLIC CAPITAL LETTER GJE
 * 	0413 CYRILLIC CAPITAL LETTER GHE
 * 0407 CYRILLIC CAPITAL LETTER YI
 * 	0406 CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
 * 040C CYRILLIC CAPITAL LETTER KJE
 * 	041A CYRILLIC CAPITAL LETTER KA
 * 040D CYRILLIC CAPITAL LETTER I WITH GRAVE
 * 	0418 CYRILLIC CAPITAL LETTER I
 * 040E CYRILLIC CAPITAL LETTER SHORT U
 * 	0423 CYRILLIC CAPITAL LETTER U
 * 0419 CYRILLIC CAPITAL LETTER SHORT I
 * 	0418 CYRILLIC CAPITAL LETTER I
 * 0439 CYRILLIC SMALL LETTER SHORT I
 * 	0438 CYRILLIC SMALL LETTER I
 * 0450 CYRILLIC SMALL LETTER IE WITH GRAVE
 * 	0435 CYRILLIC SMALL LETTER IE
 * 0451 CYRILLIC SMALL LETTER IO
 * 	0435 CYRILLIC SMALL LETTER IE
 * 0453 CYRILLIC SMALL LETTER GJE
 * 	0433 CYRILLIC SMALL LETTER GHE
 * 0457 CYRILLIC SMALL LETTER YI
 * 	0456 CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
 * 045C CYRILLIC SMALL LETTER KJE
 * 	043A CYRILLIC SMALL LETTER KA
 * 045D CYRILLIC SMALL LETTER I WITH GRAVE
 * 	0438 CYRILLIC SMALL LETTER I
 * 045E CYRILLIC SMALL LETTER SHORT U
 * 	0443 CYRILLIC SMALL LETTER U
 * 0476 CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
 * 	0474 CYRILLIC CAPITAL LETTER IZHITSA
 * 0477 CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
 * 	0475 CYRILLIC SMALL LETTER IZHITSA
 * 0483 COMBINING CYRILLIC TITLO
 * 	0000 <control>
 * 0484 COMBINING CYRILLIC PALATALIZATION
 * 	0000 <control>
 * 0485 COMBINING CYRILLIC DASIA PNEUMATA
 * 	0000 <control>
 * 0486 COMBINING CYRILLIC PSILI PNEUMATA
 * 	0000 <control>
 * 0487 COMBINING CYRILLIC POKRYTIE
 * 	0000 <control>
 * 0488 COMBINING CYRILLIC HUNDRED THOUSANDS SIGN
 * 	0000 <control>
 * 0489 COMBINING CYRILLIC MILLIONS SIGN
 * 	0000 <control>
 * 04C1 CYRILLIC CAPITAL LETTER ZHE WITH BREVE
 * 	0416 CYRILLIC CAPITAL LETTER ZHE
 * 04C2 CYRILLIC SMALL LETTER ZHE WITH BREVE
 * 	0436 CYRILLIC SMALL LETTER ZHE
 * 04D0 CYRILLIC CAPITAL LETTER A WITH BREVE
 * 	0410 CYRILLIC CAPITAL LETTER A
 * 04D1 CYRILLIC SMALL LETTER A WITH BREVE
 * 	0430 CYRILLIC SMALL LETTER A
 * 04D2 CYRILLIC CAPITAL LETTER A WITH DIAERESIS
 * 	0410 CYRILLIC CAPITAL LETTER A
 * 04D3 CYRILLIC SMALL LETTER A WITH DIAERESIS
 * 	0430 CYRILLIC SMALL LETTER A
 * 04D6 CYRILLIC CAPITAL LETTER IE WITH BREVE
 * 	0415 CYRILLIC CAPITAL LETTER IE
 * 04D7 CYRILLIC SMALL LETTER IE WITH BREVE
 * 	0435 CYRILLIC SMALL LETTER IE
 * 04DA CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
 * 	04D8 CYRILLIC CAPITAL LETTER SCHWA
 * 04DB CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
 * 	04D9 CYRILLIC SMALL LETTER SCHWA
 * 04DC CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
 * 	0416 CYRILLIC CAPITAL LETTER ZHE
 * 04DD CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
 * 	0436 CYRILLIC SMALL LETTER ZHE
 * 04DE CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
 * 	0417 CYRILLIC CAPITAL LETTER ZE
 * 04DF CYRILLIC SMALL LETTER ZE WITH DIAERESIS
 * 	0437 CYRILLIC SMALL LETTER ZE
 * 04E2 CYRILLIC CAPITAL LETTER I WITH MACRON
 * 	0418 CYRILLIC CAPITAL LETTER I
 * 04E3 CYRILLIC SMALL LETTER I WITH MACRON
 * 	0438 CYRILLIC SMALL LETTER I
 * 04E4 CYRILLIC CAPITAL LETTER I WITH DIAERESIS
 * 	0418 CYRILLIC CAPITAL LETTER I
 * 04E5 CYRILLIC SMALL LETTER I WITH DIAERESIS
 * 	0438 CYRILLIC SMALL LETTER I
 * 04E6 CYRILLIC CAPITAL LETTER O WITH DIAERESIS
 * 	041E CYRILLIC CAPITAL LETTER O
 * 04E7 CYRILLIC SMALL LETTER O WITH DIAERESIS
 * 	043E CYRILLIC SMALL LETTER O
 * 04EA CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
 * 	04E8 CYRILLIC CAPITAL LETTER BARRED O
 * 04EB CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
 * 	04E9 CYRILLIC SMALL LETTER BARRED O
 * 04EC CYRILLIC CAPITAL LETTER E WITH DIAERESIS
 * 	042D CYRILLIC CAPITAL LETTER E
 * 04ED CYRILLIC SMALL LETTER E WITH DIAERESIS
 * 	044D CYRILLIC SMALL LETTER E
 * 04EE CYRILLIC CAPITAL LETTER U WITH MACRON
 * 	0423 CYRILLIC CAPITAL LETTER U
 * 04EF CYRILLIC SMALL LETTER U WITH MACRON
 * 	0443 CYRILLIC SMALL LETTER U
 * 04F0 CYRILLIC CAPITAL LETTER U WITH DIAERESIS
 * 	0423 CYRILLIC CAPITAL LETTER U
 * 04F1 CYRILLIC SMALL LETTER U WITH DIAERESIS
 * 	0443 CYRILLIC SMALL LETTER U
 * 04F2 CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
 * 	0423 CYRILLIC CAPITAL LETTER U
 * 04F3 CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
 * 	0443 CYRILLIC SMALL LETTER U
 * 04F4 CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
 * 	0427 CYRILLIC CAPITAL LETTER CHE
 * 04F5 CYRILLIC SMALL LETTER CHE WITH DIAERESIS
 * 	0447 CYRILLIC SMALL LETTER CHE
 * 04F8 CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
 * 	042B CYRILLIC CAPITAL LETTER YERU
 * 04F9 CYRILLIC SMALL LETTER YERU WITH DIAERESIS
 * 	044B CYRILLIC SMALL LETTER YERU
 * 0587 ARMENIAN SMALL LIGATURE ECH YIWN
 * 	0565 ARMENIAN SMALL LETTER ECH
 * 	0582 ARMENIAN SMALL LETTER YIWN
 * 0591 HEBREW ACCENT ETNAHTA
 * 	0000 <control>
 * 0592 HEBREW ACCENT SEGOL
 * 	0000 <control>
 * 0593 HEBREW ACCENT SHALSHELET
 * 	0000 <control>
 * 0594 HEBREW ACCENT ZAQEF QATAN
 * 	0000 <control>
 * 0595 HEBREW ACCENT ZAQEF GADOL
 * 	0000 <control>
 * 0596 HEBREW ACCENT TIPEHA
 * 	0000 <control>
 * 0597 HEBREW ACCENT REVIA
 * 	0000 <control>
 * 0598 HEBREW ACCENT ZARQA
 * 	0000 <control>
 * 0599 HEBREW ACCENT PASHTA
 * 	0000 <control>
 * 059A HEBREW ACCENT YETIV
 * 	0000 <control>
 * 059B HEBREW ACCENT TEVIR
 * 	0000 <control>
 * 059C HEBREW ACCENT GERESH
 * 	0000 <control>
 * 059D HEBREW ACCENT GERESH MUQDAM
 * 	0000 <control>
 * 059E HEBREW ACCENT GERSHAYIM
 * 	0000 <control>
 * 059F HEBREW ACCENT QARNEY PARA
 * 	0000 <control>
 * 05A0 HEBREW ACCENT TELISHA GEDOLA
 * 	0000 <control>
 * 05A1 HEBREW ACCENT PAZER
 * 	0000 <control>
 * 05A2 HEBREW ACCENT ATNAH HAFUKH
 * 	0000 <control>
 * 05A3 HEBREW ACCENT MUNAH
 * 	0000 <control>
 * 05A4 HEBREW ACCENT MAHAPAKH
 * 	0000 <control>
 * 05A5 HEBREW ACCENT MERKHA
 * 	0000 <control>
 * 05A6 HEBREW ACCENT MERKHA KEFULA
 * 	0000 <control>
 * 05A7 HEBREW ACCENT DARGA
 * 	0000 <control>
 * 05A8 HEBREW ACCENT QADMA
 * 	0000 <control>
 * 05A9 HEBREW ACCENT TELISHA QETANA
 * 	0000 <control>
 * 05AA HEBREW ACCENT YERAH BEN YOMO
 * 	0000 <control>
 * 05AB HEBREW ACCENT OLE
 * 	0000 <control>
 * 05AC HEBREW ACCENT ILUY
 * 	0000 <control>
 * 05AD HEBREW ACCENT DEHI
 * 	0000 <control>
 * 05AE HEBREW ACCENT ZINOR
 * 	0000 <control>
 * 05AF HEBREW MARK MASORA CIRCLE
 * 	0000 <control>
 * 05B0 HEBREW POINT SHEVA
 * 	0000 <control>
 * 05B1 HEBREW POINT HATAF SEGOL
 * 	0000 <control>
 * 05B2 HEBREW POINT HATAF PATAH
 * 	0000 <control>
 * 05B3 HEBREW POINT HATAF QAMATS
 * 	0000 <control>
 * 05B4 HEBREW POINT HIRIQ
 * 	0000 <control>
 * 05B5 HEBREW POINT TSERE
 * 	0000 <control>
 * 05B6 HEBREW POINT SEGOL
 * 	0000 <control>
 * 05B7 HEBREW POINT PATAH
 * 	0000 <control>
 * 05B8 HEBREW POINT QAMATS
 * 	0000 <control>
 * 05B9 HEBREW POINT HOLAM
 * 	0000 <control>
 * 05BA HEBREW POINT HOLAM HASER FOR VAV
 * 	0000 <control>
 * 05BB HEBREW POINT QUBUTS
 * 	0000 <control>
 * 05BC HEBREW POINT DAGESH OR MAPIQ
 * 	0000 <control>
 * 05BD HEBREW POINT METEG
 * 	0000 <control>
 * 05BF HEBREW POINT RAFE
 * 	0000 <control>
 * 05C1 HEBREW POINT SHIN DOT
 * 	0000 <control>
 * 05C2 HEBREW POINT SIN DOT
 * 	0000 <control>
 * 05C4 HEBREW MARK UPPER DOT
 * 	0000 <control>
 * 05C5 HEBREW MARK LOWER DOT
 * 	0000 <control>
 * 05C7 HEBREW POINT QAMATS QATAN
 * 	0000 <control>
 * 0610 ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM
 * 	0000 <control>
 * 0611 ARABIC SIGN ALAYHE ASSALLAM
 * 	0000 <control>
 * 0612 ARABIC SIGN RAHMATULLAH ALAYHE
 * 	0000 <control>
 * 0613 ARABIC SIGN RADI ALLAHOU ANHU
 * 	0000 <control>
 * 0614 ARABIC SIGN TAKHALLUS
 * 	0000 <control>
 * 0615 ARABIC SMALL HIGH TAH
 * 	0000 <control>
 * 0616 ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH
 * 	0000 <control>
 * 0617 ARABIC SMALL HIGH ZAIN
 * 	0000 <control>
 * 0618 ARABIC SMALL FATHA
 * 	0000 <control>
 * 0619 ARABIC SMALL DAMMA
 * 	0000 <control>
 * 061A ARABIC SMALL KASRA
 * 	0000 <control>
 * 0622 ARABIC LETTER ALEF WITH MADDA ABOVE
 * 	0627 ARABIC LETTER ALEF
 * 0623 ARABIC LETTER ALEF WITH HAMZA ABOVE
 * 	0627 ARABIC LETTER ALEF
 * 0624 ARABIC LETTER WAW WITH HAMZA ABOVE
 * 	0648 ARABIC LETTER WAW
 * 0625 ARABIC LETTER ALEF WITH HAMZA BELOW
 * 	0627 ARABIC LETTER ALEF
 * 0626 ARABIC LETTER YEH WITH HAMZA ABOVE
 * 	064A ARABIC LETTER YEH
 * 064B ARABIC FATHATAN
 * 	0000 <control>
 * 064C ARABIC DAMMATAN
 * 	0000 <control>
 * 064D ARABIC KASRATAN
 * 	0000 <control>
 * 064E ARABIC FATHA
 * 	0000 <control>
 * 064F ARABIC DAMMA
 * 	0000 <control>
 * 0650 ARABIC KASRA
 * 	0000 <control>
 * 0651 ARABIC SHADDA
 * 	0000 <control>
 * 0652 ARABIC SUKUN
 * 	0000 <control>
 * 0653 ARABIC MADDAH ABOVE
 * 	0000 <control>
 * 0654 ARABIC HAMZA ABOVE
 * 	0000 <control>
 * 0655 ARABIC HAMZA BELOW
 * 	0000 <control>
 * 0656 ARABIC SUBSCRIPT ALEF
 * 	0000 <control>
 * 0657 ARABIC INVERTED DAMMA
 * 	0000 <control>
 * 0658 ARABIC MARK NOON GHUNNA
 * 	0000 <control>
 * 0659 ARABIC ZWARAKAY
 * 	0000 <control>
 * 065A ARABIC VOWEL SIGN SMALL V ABOVE
 * 	0000 <control>
 * 065B ARABIC VOWEL SIGN INVERTED SMALL V ABOVE
 * 	0000 <control>
 * 065C ARABIC VOWEL SIGN DOT BELOW
 * 	0000 <control>
 * 065D ARABIC REVERSED DAMMA
 * 	0000 <control>
 * 065E ARABIC FATHA WITH TWO DOTS
 * 	0000 <control>
 * 0670 ARABIC LETTER SUPERSCRIPT ALEF
 * 	0000 <control>
 * 0675 ARABIC LETTER HIGH HAMZA ALEF
 * 	0627 ARABIC LETTER ALEF
 * 	0674 ARABIC LETTER HIGH HAMZA
 * 0676 ARABIC LETTER HIGH HAMZA WAW
 * 	0648 ARABIC LETTER WAW
 * 	0674 ARABIC LETTER HIGH HAMZA
 * 0677 ARABIC LETTER U WITH HAMZA ABOVE
 * 	06C7 ARABIC LETTER U
 * 	0674 ARABIC LETTER HIGH HAMZA
 * 0678 ARABIC LETTER HIGH HAMZA YEH
 * 	064A ARABIC LETTER YEH
 * 	0674 ARABIC LETTER HIGH HAMZA
 * 06C0 ARABIC LETTER HEH WITH YEH ABOVE
 * 	06D5 ARABIC LETTER AE
 * 06C2 ARABIC LETTER HEH GOAL WITH HAMZA ABOVE
 * 	06C1 ARABIC LETTER HEH GOAL
 * 06D3 ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
 * 	06D2 ARABIC LETTER YEH BARREE
 * 06D6 ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA
 * 	0000 <control>
 * 06D7 ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA
 * 	0000 <control>
 * 06D8 ARABIC SMALL HIGH MEEM INITIAL FORM
 * 	0000 <control>
 * 06D9 ARABIC SMALL HIGH LAM ALEF
 * 	0000 <control>
 * 06DA ARABIC SMALL HIGH JEEM
 * 	0000 <control>
 * 06DB ARABIC SMALL HIGH THREE DOTS
 * 	0000 <control>
 * 06DC ARABIC SMALL HIGH SEEN
 * 	0000 <control>
 * 06DE ARABIC START OF RUB EL HIZB
 * 	0000 <control>
 * 06DF ARABIC SMALL HIGH ROUNDED ZERO
 * 	0000 <control>
 * 06E0 ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO
 * 	0000 <control>
 * 06E1 ARABIC SMALL HIGH DOTLESS HEAD OF KHAH
 * 	0000 <control>
 * 06E2 ARABIC SMALL HIGH MEEM ISOLATED FORM
 * 	0000 <control>
 * 06E3 ARABIC SMALL LOW SEEN
 * 	0000 <control>
 * 06E4 ARABIC SMALL HIGH MADDA
 * 	0000 <control>
 * 06E7 ARABIC SMALL HIGH YEH
 * 	0000 <control>
 * 06E8 ARABIC SMALL HIGH NOON
 * 	0000 <control>
 * 06EA ARABIC EMPTY CENTRE LOW STOP
 * 	0000 <control>
 * 06EB ARABIC EMPTY CENTRE HIGH STOP
 * 	0000 <control>
 * 06EC ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE
 * 	0000 <control>
 * 06ED ARABIC SMALL LOW MEEM
 * 	0000 <control>
 * 0711 SYRIAC LETTER SUPERSCRIPT ALAPH
 * 	0000 <control>
 * 0730 SYRIAC PTHAHA ABOVE
 * 	0000 <control>
 * 0731 SYRIAC PTHAHA BELOW
 * 	0000 <control>
 * 0732 SYRIAC PTHAHA DOTTED
 * 	0000 <control>
 * 0733 SYRIAC ZQAPHA ABOVE
 * 	0000 <control>
 * 0734 SYRIAC ZQAPHA BELOW
 * 	0000 <control>
 * 0735 SYRIAC ZQAPHA DOTTED
 * 	0000 <control>
 * 0736 SYRIAC RBASA ABOVE
 * 	0000 <control>
 * 0737 SYRIAC RBASA BELOW
 * 	0000 <control>
 * 0738 SYRIAC DOTTED ZLAMA HORIZONTAL
 * 	0000 <control>
 * 0739 SYRIAC DOTTED ZLAMA ANGULAR
 * 	0000 <control>
 * 073A SYRIAC HBASA ABOVE
 * 	0000 <control>
 * 073B SYRIAC HBASA BELOW
 * 	0000 <control>
 * 073C SYRIAC HBASA-ESASA DOTTED
 * 	0000 <control>
 * 073D SYRIAC ESASA ABOVE
 * 	0000 <control>
 * 073E SYRIAC ESASA BELOW
 * 	0000 <control>
 * 073F SYRIAC RWAHA
 * 	0000 <control>
 * 0740 SYRIAC FEMININE DOT
 * 	0000 <control>
 * 0741 SYRIAC QUSHSHAYA
 * 	0000 <control>
 * 0742 SYRIAC RUKKAKHA
 * 	0000 <control>
 * 0743 SYRIAC TWO VERTICAL DOTS ABOVE
 * 	0000 <control>
 * 0744 SYRIAC TWO VERTICAL DOTS BELOW
 * 	0000 <control>
 * 0745 SYRIAC THREE DOTS ABOVE
 * 	0000 <control>
 * 0746 SYRIAC THREE DOTS BELOW
 * 	0000 <control>
 * 0747 SYRIAC OBLIQUE LINE ABOVE
 * 	0000 <control>
 * 0748 SYRIAC OBLIQUE LINE BELOW
 * 	0000 <control>
 * 0749 SYRIAC MUSIC
 * 	0000 <control>
 * 074A SYRIAC BARREKH
 * 	0000 <control>
 * 07A6 THAANA ABAFILI
 * 	0000 <control>
 * 07A7 THAANA AABAAFILI
 * 	0000 <control>
 * 07A8 THAANA IBIFILI
 * 	0000 <control>
 * 07A9 THAANA EEBEEFILI
 * 	0000 <control>
 * 07AA THAANA UBUFILI
 * 	0000 <control>
 * 07AB THAANA OOBOOFILI
 * 	0000 <control>
 * 07AC THAANA EBEFILI
 * 	0000 <control>
 * 07AD THAANA EYBEYFILI
 * 	0000 <control>
 * 07AE THAANA OBOFILI
 * 	0000 <control>
 * 07AF THAANA OABOAFILI
 * 	0000 <control>
 * 07B0 THAANA SUKUN
 * 	0000 <control>
 * 07EB NKO COMBINING SHORT HIGH TONE
 * 	0000 <control>
 * 07EC NKO COMBINING SHORT LOW TONE
 * 	0000 <control>
 * 07ED NKO COMBINING SHORT RISING TONE
 * 	0000 <control>
 * 07EE NKO COMBINING LONG DESCENDING TONE
 * 	0000 <control>
 * 07EF NKO COMBINING LONG HIGH TONE
 * 	0000 <control>
 * 07F0 NKO COMBINING LONG LOW TONE
 * 	0000 <control>
 * 07F1 NKO COMBINING LONG RISING TONE
 * 	0000 <control>
 * 07F2 NKO COMBINING NASALIZATION MARK
 * 	0000 <control>
 * 07F3 NKO COMBINING DOUBLE DOT ABOVE
 * 	0000 <control>
 * 0901 DEVANAGARI SIGN CANDRABINDU
 * 	0000 <control>
 * 0902 DEVANAGARI SIGN ANUSVARA
 * 	0000 <control>
 * 0903 DEVANAGARI SIGN VISARGA
 * 	0000 <control>
 * 0929 DEVANAGARI LETTER NNNA
 * 	0928 DEVANAGARI LETTER NA
 * 0931 DEVANAGARI LETTER RRA
 * 	0930 DEVANAGARI LETTER RA
 * 0934 DEVANAGARI LETTER LLLA
 * 	0933 DEVANAGARI LETTER LLA
 * 093C DEVANAGARI SIGN NUKTA
 * 	0000 <control>
 * 093E DEVANAGARI VOWEL SIGN AA
 * 	0000 <control>
 * 093F DEVANAGARI VOWEL SIGN I
 * 	0000 <control>
 * 0940 DEVANAGARI VOWEL SIGN II
 * 	0000 <control>
 * 0941 DEVANAGARI VOWEL SIGN U
 * 	0000 <control>
 * 0942 DEVANAGARI VOWEL SIGN UU
 * 	0000 <control>
 * 0943 DEVANAGARI VOWEL SIGN VOCALIC R
 * 	0000 <control>
 * 0944 DEVANAGARI VOWEL SIGN VOCALIC RR
 * 	0000 <control>
 * 0945 DEVANAGARI VOWEL SIGN CANDRA E
 * 	0000 <control>
 * 0946 DEVANAGARI VOWEL SIGN SHORT E
 * 	0000 <control>
 * 0947 DEVANAGARI VOWEL SIGN E
 * 	0000 <control>
 * 0948 DEVANAGARI VOWEL SIGN AI
 * 	0000 <control>
 * 0949 DEVANAGARI VOWEL SIGN CANDRA O
 * 	0000 <control>
 * 094A DEVANAGARI VOWEL SIGN SHORT O
 * 	0000 <control>
 * 094B DEVANAGARI VOWEL SIGN O
 * 	0000 <control>
 * 094C DEVANAGARI VOWEL SIGN AU
 * 	0000 <control>
 * 094D DEVANAGARI SIGN VIRAMA
 * 	0000 <control>
 * 0951 DEVANAGARI STRESS SIGN UDATTA
 * 	0000 <control>
 * 0952 DEVANAGARI STRESS SIGN ANUDATTA
 * 	0000 <control>
 * 0953 DEVANAGARI GRAVE ACCENT
 * 	0000 <control>
 * 0954 DEVANAGARI ACUTE ACCENT
 * 	0000 <control>
 * 0958 DEVANAGARI LETTER QA
 * 	0915 DEVANAGARI LETTER KA
 * 0959 DEVANAGARI LETTER KHHA
 * 	0916 DEVANAGARI LETTER KHA
 * 095A DEVANAGARI LETTER GHHA
 * 	0917 DEVANAGARI LETTER GA
 * 095B DEVANAGARI LETTER ZA
 * 	091C DEVANAGARI LETTER JA
 * 095C DEVANAGARI LETTER DDDHA
 * 	0921 DEVANAGARI LETTER DDA
 * 095D DEVANAGARI LETTER RHA
 * 	0922 DEVANAGARI LETTER DDHA
 * 095E DEVANAGARI LETTER FA
 * 	092B DEVANAGARI LETTER PHA
 * 095F DEVANAGARI LETTER YYA
 * 	092F DEVANAGARI LETTER YA
 * 0962 DEVANAGARI VOWEL SIGN VOCALIC L
 * 	0000 <control>
 * 0963 DEVANAGARI VOWEL SIGN VOCALIC LL
 * 	0000 <control>
 * 0981 BENGALI SIGN CANDRABINDU
 * 	0000 <control>
 * 0982 BENGALI SIGN ANUSVARA
 * 	0000 <control>
 * 0983 BENGALI SIGN VISARGA
 * 	0000 <control>
 * 09BC BENGALI SIGN NUKTA
 * 	0000 <control>
 * 09BE BENGALI VOWEL SIGN AA
 * 	0000 <control>
 * 09BF BENGALI VOWEL SIGN I
 * 	0000 <control>
 * 09C0 BENGALI VOWEL SIGN II
 * 	0000 <control>
 * 09C1 BENGALI VOWEL SIGN U
 * 	0000 <control>
 * 09C2 BENGALI VOWEL SIGN UU
 * 	0000 <control>
 * 09C3 BENGALI VOWEL SIGN VOCALIC R
 * 	0000 <control>
 * 09C4 BENGALI VOWEL SIGN VOCALIC RR
 * 	0000 <control>
 * 09C7 BENGALI VOWEL SIGN E
 * 	0000 <control>
 * 09C8 BENGALI VOWEL SIGN AI
 * 	0000 <control>
 * 09CB BENGALI VOWEL SIGN O
 * 	0000 <control>
 * 09CC BENGALI VOWEL SIGN AU
 * 	0000 <control>
 * 09CD BENGALI SIGN VIRAMA
 * 	0000 <control>
 * 09D7 BENGALI AU LENGTH MARK
 * 	0000 <control>
 * 09DC BENGALI LETTER RRA
 * 	09A1 BENGALI LETTER DDA
 * 09DD BENGALI LETTER RHA
 * 	09A2 BENGALI LETTER DDHA
 * 09DF BENGALI LETTER YYA
 * 	09AF BENGALI LETTER YA
 * 09E2 BENGALI VOWEL SIGN VOCALIC L
 * 	0000 <control>
 * 09E3 BENGALI VOWEL SIGN VOCALIC LL
 * 	0000 <control>
 * 0A01 GURMUKHI SIGN ADAK BINDI
 * 	0000 <control>
 * 0A02 GURMUKHI SIGN BINDI
 * 	0000 <control>
 * 0A03 GURMUKHI SIGN VISARGA
 * 	0000 <control>
 * 0A33 GURMUKHI LETTER LLA
 * 	0A32 GURMUKHI LETTER LA
 * 0A36 GURMUKHI LETTER SHA
 * 	0A38 GURMUKHI LETTER SA
 * 0A3C GURMUKHI SIGN NUKTA
 * 	0000 <control>
 * 0A3E GURMUKHI VOWEL SIGN AA
 * 	0000 <control>
 * 0A3F GURMUKHI VOWEL SIGN I
 * 	0000 <control>
 * 0A40 GURMUKHI VOWEL SIGN II
 * 	0000 <control>
 * 0A41 GURMUKHI VOWEL SIGN U
 * 	0000 <control>
 * 0A42 GURMUKHI VOWEL SIGN UU
 * 	0000 <control>
 * 0A47 GURMUKHI VOWEL SIGN EE
 * 	0000 <control>
 * 0A48 GURMUKHI VOWEL SIGN AI
 * 	0000 <control>
 * 0A4B GURMUKHI VOWEL SIGN OO
 * 	0000 <control>
 * 0A4C GURMUKHI VOWEL SIGN AU
 * 	0000 <control>
 * 0A4D GURMUKHI SIGN VIRAMA
 * 	0000 <control>
 * 0A51 GURMUKHI SIGN UDAAT
 * 	0000 <control>
 * 0A59 GURMUKHI LETTER KHHA
 * 	0A16 GURMUKHI LETTER KHA
 * 0A5A GURMUKHI LETTER GHHA
 * 	0A17 GURMUKHI LETTER GA
 * 0A5B GURMUKHI LETTER ZA
 * 	0A1C GURMUKHI LETTER JA
 * 0A5E GURMUKHI LETTER FA
 * 	0A2B GURMUKHI LETTER PHA
 * 0A70 GURMUKHI TIPPI
 * 	0000 <control>
 * 0A71 GURMUKHI ADDAK
 * 	0000 <control>
 * 0A75 GURMUKHI SIGN YAKASH
 * 	0000 <control>
 * 0A81 GUJARATI SIGN CANDRABINDU
 * 	0000 <control>
 * 0A82 GUJARATI SIGN ANUSVARA
 * 	0000 <control>
 * 0A83 GUJARATI SIGN VISARGA
 * 	0000 <control>
 * 0ABC GUJARATI SIGN NUKTA
 * 	0000 <control>
 * 0ABE GUJARATI VOWEL SIGN AA
 * 	0000 <control>
 * 0ABF GUJARATI VOWEL SIGN I
 * 	0000 <control>
 * 0AC0 GUJARATI VOWEL SIGN II
 * 	0000 <control>
 * 0AC1 GUJARATI VOWEL SIGN U
 * 	0000 <control>
 * 0AC2 GUJARATI VOWEL SIGN UU
 * 	0000 <control>
 * 0AC3 GUJARATI VOWEL SIGN VOCALIC R
 * 	0000 <control>
 * 0AC4 GUJARATI VOWEL SIGN VOCALIC RR
 * 	0000 <control>
 * 0AC5 GUJARATI VOWEL SIGN CANDRA E
 * 	0000 <control>
 * 0AC7 GUJARATI VOWEL SIGN E
 * 	0000 <control>
 * 0AC8 GUJARATI VOWEL SIGN AI
 * 	0000 <control>
 * 0AC9 GUJARATI VOWEL SIGN CANDRA O
 * 	0000 <control>
 * 0ACB GUJARATI VOWEL SIGN O
 * 	0000 <control>
 * 0ACC GUJARATI VOWEL SIGN AU
 * 	0000 <control>
 * 0ACD GUJARATI SIGN VIRAMA
 * 	0000 <control>
 * 0AE2 GUJARATI VOWEL SIGN VOCALIC L
 * 	0000 <control>
 * 0AE3 GUJARATI VOWEL SIGN VOCALIC LL
 * 	0000 <control>
 * 0B01 ORIYA SIGN CANDRABINDU
 * 	0000 <control>
 * 0B02 ORIYA SIGN ANUSVARA
 * 	0000 <control>
 * 0B03 ORIYA SIGN VISARGA
 * 	0000 <control>
 * 0B3C ORIYA SIGN NUKTA
 * 	0000 <control>
 * 0B3E ORIYA VOWEL SIGN AA
 * 	0000 <control>
 * 0B3F ORIYA VOWEL SIGN I
 * 	0000 <control>
 * 0B40 ORIYA VOWEL SIGN II
 * 	0000 <control>
 * 0B41 ORIYA VOWEL SIGN U
 * 	0000 <control>
 * 0B42 ORIYA VOWEL SIGN UU
 * 	0000 <control>
 * 0B43 ORIYA VOWEL SIGN VOCALIC R
 * 	0000 <control>
 * 0B44 ORIYA VOWEL SIGN VOCALIC RR
 * 	0000 <control>
 * 0B47 ORIYA VOWEL SIGN E
 * 	0000 <control>
 * 0B48 ORIYA VOWEL SIGN AI
 * 	0000 <control>
 * 0B4B ORIYA VOWEL SIGN O
 * 	0000 <control>
 * 0B4C ORIYA VOWEL SIGN AU
 * 	0000 <control>
 * 0B4D ORIYA SIGN VIRAMA
 * 	0000 <control>
 * 0B56 ORIYA AI LENGTH MARK
 * 	0000 <control>
 * 0B57 ORIYA AU LENGTH MARK
 * 	0000 <control>
 * 0B5C ORIYA LETTER RRA
 * 	0B21 ORIYA LETTER DDA
 * 0B5D ORIYA LETTER RHA
 * 	0B22 ORIYA LETTER DDHA
 * 0B62 ORIYA VOWEL SIGN VOCALIC L
 * 	0000 <control>
 * 0B63 ORIYA VOWEL SIGN VOCALIC LL
 * 	0000 <control>
 * 0B82 TAMIL SIGN ANUSVARA
 * 	0000 <control>
 * 0B94 TAMIL LETTER AU
 * 	0B92 TAMIL LETTER O
 * 0BBE TAMIL VOWEL SIGN AA
 * 	0000 <control>
 * 0BBF TAMIL VOWEL SIGN I
 * 	0000 <control>
 * 0BC0 TAMIL VOWEL SIGN II
 * 	0000 <control>
 * 0BC1 TAMIL VOWEL SIGN U
 * 	0000 <control>
 * 0BC2 TAMIL VOWEL SIGN UU
 * 	0000 <control>
 * 0BC6 TAMIL VOWEL SIGN E
 * 	0000 <control>
 * 0BC7 TAMIL VOWEL SIGN EE
 * 	0000 <control>
 * 0BC8 TAMIL VOWEL SIGN AI
 * 	0000 <control>
 * 0BCA TAMIL VOWEL SIGN O
 * 	0000 <control>
 * 0BCB TAMIL VOWEL SIGN OO
 * 	0000 <control>
 * 0BCC TAMIL VOWEL SIGN AU
 * 	0000 <control>
 * 0BCD TAMIL SIGN VIRAMA
 * 	0000 <control>
 * 0BD7 TAMIL AU LENGTH MARK
 * 	0000 <control>
 * 0C01 TELUGU SIGN CANDRABINDU
 * 	0000 <control>
 * 0C02 TELUGU SIGN ANUSVARA
 * 	0000 <control>
 * 0C03 TELUGU SIGN VISARGA
 * 	0000 <control>
 * 0C3E TELUGU VOWEL SIGN AA
 * 	0000 <control>
 * 0C3F TELUGU VOWEL SIGN I
 * 	0000 <control>
 * 0C40 TELUGU VOWEL SIGN II
 * 	0000 <control>
 * 0C41 TELUGU VOWEL SIGN U
 * 	0000 <control>
 * 0C42 TELUGU VOWEL SIGN UU
 * 	0000 <control>
 * 0C43 TELUGU VOWEL SIGN VOCALIC R
 * 	0000 <control>
 * 0C44 TELUGU VOWEL SIGN VOCALIC RR
 * 	0000 <control>
 * 0C46 TELUGU VOWEL SIGN E
 * 	0000 <control>
 * 0C47 TELUGU VOWEL SIGN EE
 * 	0000 <control>
 * 0C48 TELUGU VOWEL SIGN AI
 * 	0000 <control>
 * 0C4A TELUGU VOWEL SIGN O
 * 	0000 <control>
 * 0C4B TELUGU VOWEL SIGN OO
 * 	0000 <control>
 * 0C4C TELUGU VOWEL SIGN AU
 * 	0000 <control>
 * 0C4D TELUGU SIGN VIRAMA
 * 	0000 <control>
 * 0C55 TELUGU LENGTH MARK
 * 	0000 <control>
 * 0C56 TELUGU AI LENGTH MARK
 * 	0000 <control>
 * 0C62 TELUGU VOWEL SIGN VOCALIC L
 * 	0000 <control>
 * 0C63 TELUGU VOWEL SIGN VOCALIC LL
 * 	0000 <control>
 * 0C82 KANNADA SIGN ANUSVARA
 * 	0000 <control>
 * 0C83 KANNADA SIGN VISARGA
 * 	0000 <control>
 * 0CBC KANNADA SIGN NUKTA
 * 	0000 <control>
 * 0CBE KANNADA VOWEL SIGN AA
 * 	0000 <control>
 * 0CBF KANNADA VOWEL SIGN I
 * 	0000 <control>
 * 0CC0 KANNADA VOWEL SIGN II
 * 	0000 <control>
 * 0CC1 KANNADA VOWEL SIGN U
 * 	0000 <control>
 * 0CC2 KANNADA VOWEL SIGN UU
 * 	0000 <control>
 * 0CC3 KANNADA VOWEL SIGN VOCALIC R
 * 	0000 <control>
 * 0CC4 KANNADA VOWEL SIGN VOCALIC RR
 * 	0000 <control>
 * 0CC6 KANNADA VOWEL SIGN E
 * 	0000 <control>
 * 0CC7 KANNADA VOWEL SIGN EE
 * 	0000 <control>
 * 0CC8 KANNADA VOWEL SIGN AI
 * 	0000 <control>
 * 0CCA KANNADA VOWEL SIGN O
 * 	0000 <control>
 * 0CCB KANNADA VOWEL SIGN OO
 * 	0000 <control>
 * 0CCC KANNADA VOWEL SIGN AU
 * 	0000 <control>
 * 0CCD KANNADA SIGN VIRAMA
 * 	0000 <control>
 * 0CD5 KANNADA LENGTH MARK
 * 	0000 <control>
 * 0CD6 KANNADA AI LENGTH MARK
 * 	0000 <control>
 * 0CE2 KANNADA VOWEL SIGN VOCALIC L
 * 	0000 <control>
 * 0CE3 KANNADA VOWEL SIGN VOCALIC LL
 * 	0000 <control>
 * 0D02 MALAYALAM SIGN ANUSVARA
 * 	0000 <control>
 * 0D03 MALAYALAM SIGN VISARGA
 * 	0000 <control>
 * 0D3E MALAYALAM VOWEL SIGN AA
 * 	0000 <control>
 * 0D3F MALAYALAM VOWEL SIGN I
 * 	0000 <control>
 * 0D40 MALAYALAM VOWEL SIGN II
 * 	0000 <control>
 * 0D41 MALAYALAM VOWEL SIGN U
 * 	0000 <control>
 * 0D42 MALAYALAM VOWEL SIGN UU
 * 	0000 <control>
 * 0D43 MALAYALAM VOWEL SIGN VOCALIC R
 * 	0000 <control>
 * 0D44 MALAYALAM VOWEL SIGN VOCALIC RR
 * 	0000 <control>
 * 0D46 MALAYALAM VOWEL SIGN E
 * 	0000 <control>
 * 0D47 MALAYALAM VOWEL SIGN EE
 * 	0000 <control>
 * 0D48 MALAYALAM VOWEL SIGN AI
 * 	0000 <control>
 * 0D4A MALAYALAM VOWEL SIGN O
 * 	0000 <control>
 * 0D4B MALAYALAM VOWEL SIGN OO
 * 	0000 <control>
 * 0D4C MALAYALAM VOWEL SIGN AU
 * 	0000 <control>
 * 0D4D MALAYALAM SIGN VIRAMA
 * 	0000 <control>
 * 0D57 MALAYALAM AU LENGTH MARK
 * 	0000 <control>
 * 0D62 MALAYALAM VOWEL SIGN VOCALIC L
 * 	0000 <control>
 * 0D63 MALAYALAM VOWEL SIGN VOCALIC LL
 * 	0000 <control>
 * 0D82 SINHALA SIGN ANUSVARAYA
 * 	0000 <control>
 * 0D83 SINHALA SIGN VISARGAYA
 * 	0000 <control>
 * 0DCA SINHALA SIGN AL-LAKUNA
 * 	0000 <control>
 * 0DCF SINHALA VOWEL SIGN AELA-PILLA
 * 	0000 <control>
 * 0DD0 SINHALA VOWEL SIGN KETTI AEDA-PILLA
 * 	0000 <control>
 * 0DD1 SINHALA VOWEL SIGN DIGA AEDA-PILLA
 * 	0000 <control>
 * 0DD2 SINHALA VOWEL SIGN KETTI IS-PILLA
 * 	0000 <control>
 * 0DD3 SINHALA VOWEL SIGN DIGA IS-PILLA
 * 	0000 <control>
 * 0DD4 SINHALA VOWEL SIGN KETTI PAA-PILLA
 * 	0000 <control>
 * 0DD6 SINHALA VOWEL SIGN DIGA PAA-PILLA
 * 	0000 <control>
 * 0DD8 SINHALA VOWEL SIGN GAETTA-PILLA
 * 	0000 <control>
 * 0DD9 SINHALA VOWEL SIGN KOMBUVA
 * 	0000 <control>
 * 0DDA SINHALA VOWEL SIGN DIGA KOMBUVA
 * 	0000 <control>
 * 0DDB SINHALA VOWEL SIGN KOMBU DEKA
 * 	0000 <control>
 * 0DDC SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA
 * 	0000 <control>
 * 0DDD SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA
 * 	0000 <control>
 * 0DDE SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA
 * 	0000 <control>
 * 0DDF SINHALA VOWEL SIGN GAYANUKITTA
 * 	0000 <control>
 * 0DF2 SINHALA VOWEL SIGN DIGA GAETTA-PILLA
 * 	0000 <control>
 * 0DF3 SINHALA VOWEL SIGN DIGA GAYANUKITTA
 * 	0000 <control>
 * 0E31 THAI CHARACTER MAI HAN-AKAT
 * 	0000 <control>
 * 0E33 THAI CHARACTER SARA AM
 * 	0E32 THAI CHARACTER SARA AA
 * 0E34 THAI CHARACTER SARA I
 * 	0000 <control>
 * 0E35 THAI CHARACTER SARA II
 * 	0000 <control>
 * 0E36 THAI CHARACTER SARA UE
 * 	0000 <control>
 * 0E37 THAI CHARACTER SARA UEE
 * 	0000 <control>
 * 0E38 THAI CHARACTER SARA U
 * 	0000 <control>
 * 0E39 THAI CHARACTER SARA UU
 * 	0000 <control>
 * 0E3A THAI CHARACTER PHINTHU
 * 	0000 <control>
 * 0E47 THAI CHARACTER MAITAIKHU
 * 	0000 <control>
 * 0E48 THAI CHARACTER MAI EK
 * 	0000 <control>
 * 0E49 THAI CHARACTER MAI THO
 * 	0000 <control>
 * 0E4A THAI CHARACTER MAI TRI
 * 	0000 <control>
 * 0E4B THAI CHARACTER MAI CHATTAWA
 * 	0000 <control>
 * 0E4C THAI CHARACTER THANTHAKHAT
 * 	0000 <control>
 * 0E4D THAI CHARACTER NIKHAHIT
 * 	0000 <control>
 * 0E4E THAI CHARACTER YAMAKKAN
 * 	0000 <control>
 * 0EB1 LAO VOWEL SIGN MAI KAN
 * 	0000 <control>
 * 0EB3 LAO VOWEL SIGN AM
 * 	0EB2 LAO VOWEL SIGN AA
 * 0EB4 LAO VOWEL SIGN I
 * 	0000 <control>
 * 0EB5 LAO VOWEL SIGN II
 * 	0000 <control>
 * 0EB6 LAO VOWEL SIGN Y
 * 	0000 <control>
 * 0EB7 LAO VOWEL SIGN YY
 * 	0000 <control>
 * 0EB8 LAO VOWEL SIGN U
 * 	0000 <control>
 * 0EB9 LAO VOWEL SIGN UU
 * 	0000 <control>
 * 0EBB LAO VOWEL SIGN MAI KON
 * 	0000 <control>
 * 0EBC LAO SEMIVOWEL SIGN LO
 * 	0000 <control>
 * 0EC8 LAO TONE MAI EK
 * 	0000 <control>
 * 0EC9 LAO TONE MAI THO
 * 	0000 <control>
 * 0ECA LAO TONE MAI TI
 * 	0000 <control>
 * 0ECB LAO TONE MAI CATAWA
 * 	0000 <control>
 * 0ECC LAO CANCELLATION MARK
 * 	0000 <control>
 * 0ECD LAO NIGGAHITA
 * 	0000 <control>
 * 0EDC LAO HO NO
 * 	0EAB LAO LETTER HO SUNG
 * 	0E99 LAO LETTER NO
 * 0EDD LAO HO MO
 * 	0EAB LAO LETTER HO SUNG
 * 	0EA1 LAO LETTER MO
 * 0F0C TIBETAN MARK DELIMITER TSHEG BSTAR
 * 	0F0B TIBETAN MARK INTERSYLLABIC TSHEG
 * 0F18 TIBETAN ASTROLOGICAL SIGN -KHYUD PA
 * 	0000 <control>
 * 0F19 TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
 * 	0000 <control>
 * 0F35 TIBETAN MARK NGAS BZUNG NYI ZLA
 * 	0000 <control>
 * 0F37 TIBETAN MARK NGAS BZUNG SGOR RTAGS
 * 	0000 <control>
 * 0F39 TIBETAN MARK TSA -PHRU
 * 	0000 <control>
 * 0F3E TIBETAN SIGN YAR TSHES
 * 	0000 <control>
 * 0F3F TIBETAN SIGN MAR TSHES
 * 	0000 <control>
 * 0F43 TIBETAN LETTER GHA
 * 	0F42 TIBETAN LETTER GA
 * 0F4D TIBETAN LETTER DDHA
 * 	0F4C TIBETAN LETTER DDA
 * 0F52 TIBETAN LETTER DHA
 * 	0F51 TIBETAN LETTER DA
 * 0F57 TIBETAN LETTER BHA
 * 	0F56 TIBETAN LETTER BA
 * 0F5C TIBETAN LETTER DZHA
 * 	0F5B TIBETAN LETTER DZA
 * 0F69 TIBETAN LETTER KSSA
 * 	0F40 TIBETAN LETTER KA
 * 0F71 TIBETAN VOWEL SIGN AA
 * 	0000 <control>
 * 0F72 TIBETAN VOWEL SIGN I
 * 	0000 <control>
 * 0F73 TIBETAN VOWEL SIGN II
 * 	0000 <control>
 * 0F74 TIBETAN VOWEL SIGN U
 * 	0000 <control>
 * 0F75 TIBETAN VOWEL SIGN UU
 * 	0000 <control>
 * 0F76 TIBETAN VOWEL SIGN VOCALIC R
 * 	0000 <control>
 * 0F77 TIBETAN VOWEL SIGN VOCALIC RR
 * 	0000 <control>
 * 0F78 TIBETAN VOWEL SIGN VOCALIC L
 * 	0000 <control>
 * 0F79 TIBETAN VOWEL SIGN VOCALIC LL
 * 	0000 <control>
 * 0F7A TIBETAN VOWEL SIGN E
 * 	0000 <control>
 * 0F7B TIBETAN VOWEL SIGN EE
 * 	0000 <control>
 * 0F7C TIBETAN VOWEL SIGN O
 * 	0000 <control>
 * 0F7D TIBETAN VOWEL SIGN OO
 * 	0000 <control>
 * 0F7E TIBETAN SIGN RJES SU NGA RO
 * 	0000 <control>
 * 0F7F TIBETAN SIGN RNAM BCAD
 * 	0000 <control>
 * 0F80 TIBETAN VOWEL SIGN REVERSED I
 * 	0000 <control>
 * 0F81 TIBETAN VOWEL SIGN REVERSED II
 * 	0000 <control>
 * 0F82 TIBETAN SIGN NYI ZLA NAA DA
 * 	0000 <control>
 * 0F83 TIBETAN SIGN SNA LDAN
 * 	0000 <control>
 * 0F84 TIBETAN MARK HALANTA
 * 	0000 <control>
 * 0F86 TIBETAN SIGN LCI RTAGS
 * 	0000 <control>
 * 0F87 TIBETAN SIGN YANG RTAGS
 * 	0000 <control>
 * 0F90 TIBETAN SUBJOINED LETTER KA
 * 	0000 <control>
 * 0F91 TIBETAN SUBJOINED LETTER KHA
 * 	0000 <control>
 * 0F92 TIBETAN SUBJOINED LETTER GA
 * 	0000 <control>
 * 0F93 TIBETAN SUBJOINED LETTER GHA
 * 	0000 <control>
 * 0F94 TIBETAN SUBJOINED LETTER NGA
 * 	0000 <control>
 * 0F95 TIBETAN SUBJOINED LETTER CA
 * 	0000 <control>
 * 0F96 TIBETAN SUBJOINED LETTER CHA
 * 	0000 <control>
 * 0F97 TIBETAN SUBJOINED LETTER JA
 * 	0000 <control>
 * 0F99 TIBETAN SUBJOINED LETTER NYA
 * 	0000 <control>
 * 0F9A TIBETAN SUBJOINED LETTER TTA
 * 	0000 <control>
 * 0F9B TIBETAN SUBJOINED LETTER TTHA
 * 	0000 <control>
 * 0F9C TIBETAN SUBJOINED LETTER DDA
 * 	0000 <control>
 * 0F9D TIBETAN SUBJOINED LETTER DDHA
 * 	0000 <control>
 * 0F9E TIBETAN SUBJOINED LETTER NNA
 * 	0000 <control>
 * 0F9F TIBETAN SUBJOINED LETTER TA
 * 	0000 <control>
 * 0FA0 TIBETAN SUBJOINED LETTER THA
 * 	0000 <control>
 * 0FA1 TIBETAN SUBJOINED LETTER DA
 * 	0000 <control>
 * 0FA2 TIBETAN SUBJOINED LETTER DHA
 * 	0000 <control>
 * 0FA3 TIBETAN SUBJOINED LETTER NA
 * 	0000 <control>
 * 0FA4 TIBETAN SUBJOINED LETTER PA
 * 	0000 <control>
 * 0FA5 TIBETAN SUBJOINED LETTER PHA
 * 	0000 <control>
 * 0FA6 TIBETAN SUBJOINED LETTER BA
 * 	0000 <control>
 * 0FA7 TIBETAN SUBJOINED LETTER BHA
 * 	0000 <control>
 * 0FA8 TIBETAN SUBJOINED LETTER MA
 * 	0000 <control>
 * 0FA9 TIBETAN SUBJOINED LETTER TSA
 * 	0000 <control>
 * 0FAA TIBETAN SUBJOINED LETTER TSHA
 * 	0000 <control>
 * 0FAB TIBETAN SUBJOINED LETTER DZA
 * 	0000 <control>
 * 0FAC TIBETAN SUBJOINED LETTER DZHA
 * 	0000 <control>
 * 0FAD TIBETAN SUBJOINED LETTER WA
 * 	0000 <control>
 * 0FAE TIBETAN SUBJOINED LETTER ZHA
 * 	0000 <control>
 * 0FAF TIBETAN SUBJOINED LETTER ZA
 * 	0000 <control>
 * 0FB0 TIBETAN SUBJOINED LETTER -A
 * 	0000 <control>
 * 0FB1 TIBETAN SUBJOINED LETTER YA
 * 	0000 <control>
 * 0FB2 TIBETAN SUBJOINED LETTER RA
 * 	0000 <control>
 * 0FB3 TIBETAN SUBJOINED LETTER LA
 * 	0000 <control>
 * 0FB4 TIBETAN SUBJOINED LETTER SHA
 * 	0000 <control>
 * 0FB5 TIBETAN SUBJOINED LETTER SSA
 * 	0000 <control>
 * 0FB6 TIBETAN SUBJOINED LETTER SA
 * 	0000 <control>
 * 0FB7 TIBETAN SUBJOINED LETTER HA
 * 	0000 <control>
 * 0FB8 TIBETAN SUBJOINED LETTER A
 * 	0000 <control>
 * 0FB9 TIBETAN SUBJOINED LETTER KSSA
 * 	0000 <control>
 * 0FBA TIBETAN SUBJOINED LETTER FIXED-FORM WA
 * 	0000 <control>
 * 0FBB TIBETAN SUBJOINED LETTER FIXED-FORM YA
 * 	0000 <control>
 * 0FBC TIBETAN SUBJOINED LETTER FIXED-FORM RA
 * 	0000 <control>
 * 0FC6 TIBETAN SYMBOL PADMA GDAN
 * 	0000 <control>
 * 1026 MYANMAR LETTER UU
 * 	1025 MYANMAR LETTER U
 * 102B MYANMAR VOWEL SIGN TALL AA
 * 	0000 <control>
 * 102C MYANMAR VOWEL SIGN AA
 * 	0000 <control>
 * 102D MYANMAR VOWEL SIGN I
 * 	0000 <control>
 * 102E MYANMAR VOWEL SIGN II
 * 	0000 <control>
 * 102F MYANMAR VOWEL SIGN U
 * 	0000 <control>
 * 1030 MYANMAR VOWEL SIGN UU
 * 	0000 <control>
 * 1031 MYANMAR VOWEL SIGN E
 * 	0000 <control>
 * 1032 MYANMAR VOWEL SIGN AI
 * 	0000 <control>
 * 1033 MYANMAR VOWEL SIGN MON II
 * 	0000 <control>
 * 1034 MYANMAR VOWEL SIGN MON O
 * 	0000 <control>
 * 1035 MYANMAR VOWEL SIGN E ABOVE
 * 	0000 <control>
 * 1036 MYANMAR SIGN ANUSVARA
 * 	0000 <control>
 * 1037 MYANMAR SIGN DOT BELOW
 * 	0000 <control>
 * 1038 MYANMAR SIGN VISARGA
 * 	0000 <control>
 * 1039 MYANMAR SIGN VIRAMA
 * 	0000 <control>
 * 103A MYANMAR SIGN ASAT
 * 	0000 <control>
 * 103B MYANMAR CONSONANT SIGN MEDIAL YA
 * 	0000 <control>
 * 103C MYANMAR CONSONANT SIGN MEDIAL RA
 * 	0000 <control>
 * 103D MYANMAR CONSONANT SIGN MEDIAL WA
 * 	0000 <control>
 * 103E MYANMAR CONSONANT SIGN MEDIAL HA
 * 	0000 <control>
 * 1056 MYANMAR VOWEL SIGN VOCALIC R
 * 	0000 <control>
 * 1057 MYANMAR VOWEL SIGN VOCALIC RR
 * 	0000 <control>
 * 1058 MYANMAR VOWEL SIGN VOCALIC L
 * 	0000 <control>
 * 1059 MYANMAR VOWEL SIGN VOCALIC LL
 * 	0000 <control>
 * 105E MYANMAR CONSONANT SIGN MON MEDIAL NA
 * 	0000 <control>
 * 105F MYANMAR CONSONANT SIGN MON MEDIAL MA
 * 	0000 <control>
 * 1060 MYANMAR CONSONANT SIGN MON MEDIAL LA
 * 	0000 <control>
 * 1062 MYANMAR VOWEL SIGN SGAW KAREN EU
 * 	0000 <control>
 * 1063 MYANMAR TONE MARK SGAW KAREN HATHI
 * 	0000 <control>
 * 1064 MYANMAR TONE MARK SGAW KAREN KE PHO
 * 	0000 <control>
 * 1067 MYANMAR VOWEL SIGN WESTERN PWO KAREN EU
 * 	0000 <control>
 * 1068 MYANMAR VOWEL SIGN WESTERN PWO KAREN UE
 * 	0000 <control>
 * 1069 MYANMAR SIGN WESTERN PWO KAREN TONE-1
 * 	0000 <control>
 * 106A MYANMAR SIGN WESTERN PWO KAREN TONE-2
 * 	0000 <control>
 * 106B MYANMAR SIGN WESTERN PWO KAREN TONE-3
 * 	0000 <control>
 * 106C MYANMAR SIGN WESTERN PWO KAREN TONE-4
 * 	0000 <control>
 * 106D MYANMAR SIGN WESTERN PWO KAREN TONE-5
 * 	0000 <control>
 * 1071 MYANMAR VOWEL SIGN GEBA KAREN I
 * 	0000 <control>
 * 1072 MYANMAR VOWEL SIGN KAYAH OE
 * 	0000 <control>
 * 1073 MYANMAR VOWEL SIGN KAYAH U
 * 	0000 <control>
 * 1074 MYANMAR VOWEL SIGN KAYAH EE
 * 	0000 <control>
 * 1082 MYANMAR CONSONANT SIGN SHAN MEDIAL WA
 * 	0000 <control>
 * 1083 MYANMAR VOWEL SIGN SHAN AA
 * 	0000 <control>
 * 1084 MYANMAR VOWEL SIGN SHAN E
 * 	0000 <control>
 * 1085 MYANMAR VOWEL SIGN SHAN E ABOVE
 * 	0000 <control>
 * 1086 MYANMAR VOWEL SIGN SHAN FINAL Y
 * 	0000 <control>
 * 1087 MYANMAR SIGN SHAN TONE-2
 * 	0000 <control>
 * 1088 MYANMAR SIGN SHAN TONE-3
 * 	0000 <control>
 * 1089 MYANMAR SIGN SHAN TONE-5
 * 	0000 <control>
 * 108A MYANMAR SIGN SHAN TONE-6
 * 	0000 <control>
 * 108B MYANMAR SIGN SHAN COUNCIL TONE-2
 * 	0000 <control>
 * 108C MYANMAR SIGN SHAN COUNCIL TONE-3
 * 	0000 <control>
 * 108D MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE
 * 	0000 <control>
 * 108F MYANMAR SIGN RUMAI PALAUNG TONE-5
 * 	0000 <control>
 * 10FC MODIFIER LETTER GEORGIAN NAR
 * 	10DC GEORGIAN LETTER NAR
 * 135F ETHIOPIC COMBINING GEMINATION MARK
 * 	0000 <control>
 * 1712 TAGALOG VOWEL SIGN I
 * 	0000 <control>
 * 1713 TAGALOG VOWEL SIGN U
 * 	0000 <control>
 * 1714 TAGALOG SIGN VIRAMA
 * 	0000 <control>
 * 1732 HANUNOO VOWEL SIGN I
 * 	0000 <control>
 * 1733 HANUNOO VOWEL SIGN U
 * 	0000 <control>
 * 1734 HANUNOO SIGN PAMUDPOD
 * 	0000 <control>
 * 1752 BUHID VOWEL SIGN I
 * 	0000 <control>
 * 1753 BUHID VOWEL SIGN U
 * 	0000 <control>
 * 1772 TAGBANWA VOWEL SIGN I
 * 	0000 <control>
 * 1773 TAGBANWA VOWEL SIGN U
 * 	0000 <control>
 * 17B6 KHMER VOWEL SIGN AA
 * 	0000 <control>
 * 17B7 KHMER VOWEL SIGN I
 * 	0000 <control>
 * 17B8 KHMER VOWEL SIGN II
 * 	0000 <control>
 * 17B9 KHMER VOWEL SIGN Y
 * 	0000 <control>
 * 17BA KHMER VOWEL SIGN YY
 * 	0000 <control>
 * 17BB KHMER VOWEL SIGN U
 * 	0000 <control>
 * 17BC KHMER VOWEL SIGN UU
 * 	0000 <control>
 * 17BD KHMER VOWEL SIGN UA
 * 	0000 <control>
 * 17BE KHMER VOWEL SIGN OE
 * 	0000 <control>
 * 17BF KHMER VOWEL SIGN YA
 * 	0000 <control>
 * 17C0 KHMER VOWEL SIGN IE
 * 	0000 <control>
 * 17C1 KHMER VOWEL SIGN E
 * 	0000 <control>
 * 17C2 KHMER VOWEL SIGN AE
 * 	0000 <control>
 * 17C3 KHMER VOWEL SIGN AI
 * 	0000 <control>
 * 17C4 KHMER VOWEL SIGN OO
 * 	0000 <control>
 * 17C5 KHMER VOWEL SIGN AU
 * 	0000 <control>
 * 17C6 KHMER SIGN NIKAHIT
 * 	0000 <control>
 * 17C7 KHMER SIGN REAHMUK
 * 	0000 <control>
 * 17C8 KHMER SIGN YUUKALEAPINTU
 * 	0000 <control>
 * 17C9 KHMER SIGN MUUSIKATOAN
 * 	0000 <control>
 * 17CA KHMER SIGN TRIISAP
 * 	0000 <control>
 * 17CB KHMER SIGN BANTOC
 * 	0000 <control>
 * 17CC KHMER SIGN ROBAT
 * 	0000 <control>
 * 17CD KHMER SIGN TOANDAKHIAT
 * 	0000 <control>
 * 17CE KHMER SIGN KAKABAT
 * 	0000 <control>
 * 17CF KHMER SIGN AHSDA
 * 	0000 <control>
 * 17D0 KHMER SIGN SAMYOK SANNYA
 * 	0000 <control>
 * 17D1 KHMER SIGN VIRIAM
 * 	0000 <control>
 * 17D2 KHMER SIGN COENG
 * 	0000 <control>
 * 17D3 KHMER SIGN BATHAMASAT
 * 	0000 <control>
 * 17DD KHMER SIGN ATTHACAN
 * 	0000 <control>
 * 180B MONGOLIAN FREE VARIATION SELECTOR ONE
 * 	0000 <control>
 * 180C MONGOLIAN FREE VARIATION SELECTOR TWO
 * 	0000 <control>
 * 180D MONGOLIAN FREE VARIATION SELECTOR THREE
 * 	0000 <control>
 * 18A9 MONGOLIAN LETTER ALI GALI DAGALGA
 * 	0000 <control>
 * 1920 LIMBU VOWEL SIGN A
 * 	0000 <control>
 * 1921 LIMBU VOWEL SIGN I
 * 	0000 <control>
 * 1922 LIMBU VOWEL SIGN U
 * 	0000 <control>
 * 1923 LIMBU VOWEL SIGN EE
 * 	0000 <control>
 * 1924 LIMBU VOWEL SIGN AI
 * 	0000 <control>
 * 1925 LIMBU VOWEL SIGN OO
 * 	0000 <control>
 * 1926 LIMBU VOWEL SIGN AU
 * 	0000 <control>
 * 1927 LIMBU VOWEL SIGN E
 * 	0000 <control>
 * 1928 LIMBU VOWEL SIGN O
 * 	0000 <control>
 * 1929 LIMBU SUBJOINED LETTER YA
 * 	0000 <control>
 * 192A LIMBU SUBJOINED LETTER RA
 * 	0000 <control>
 * 192B LIMBU SUBJOINED LETTER WA
 * 	0000 <control>
 * 1930 LIMBU SMALL LETTER KA
 * 	0000 <control>
 * 1931 LIMBU SMALL LETTER NGA
 * 	0000 <control>
 * 1932 LIMBU SMALL LETTER ANUSVARA
 * 	0000 <control>
 * 1933 LIMBU SMALL LETTER TA
 * 	0000 <control>
 * 1934 LIMBU SMALL LETTER NA
 * 	0000 <control>
 * 1935 LIMBU SMALL LETTER PA
 * 	0000 <control>
 * 1936 LIMBU SMALL LETTER MA
 * 	0000 <control>
 * 1937 LIMBU SMALL LETTER RA
 * 	0000 <control>
 * 1938 LIMBU SMALL LETTER LA
 * 	0000 <control>
 * 1939 LIMBU SIGN MUKPHRENG
 * 	0000 <control>
 * 193A LIMBU SIGN KEMPHRENG
 * 	0000 <control>
 * 193B LIMBU SIGN SA-I
 * 	0000 <control>
 * 19B0 NEW TAI LUE VOWEL SIGN VOWEL SHORTENER
 * 	0000 <control>
 * 19B1 NEW TAI LUE VOWEL SIGN AA
 * 	0000 <control>
 * 19B2 NEW TAI LUE VOWEL SIGN II
 * 	0000 <control>
 * 19B3 NEW TAI LUE VOWEL SIGN U
 * 	0000 <control>
 * 19B4 NEW TAI LUE VOWEL SIGN UU
 * 	0000 <control>
 * 19B5 NEW TAI LUE VOWEL SIGN E
 * 	0000 <control>
 * 19B6 NEW TAI LUE VOWEL SIGN AE
 * 	0000 <control>
 * 19B7 NEW TAI LUE VOWEL SIGN O
 * 	0000 <control>
 * 19B8 NEW TAI LUE VOWEL SIGN OA
 * 	0000 <control>
 * 19B9 NEW TAI LUE VOWEL SIGN UE
 * 	0000 <control>
 * 19BA NEW TAI LUE VOWEL SIGN AY
 * 	0000 <control>
 * 19BB NEW TAI LUE VOWEL SIGN AAY
 * 	0000 <control>
 * 19BC NEW TAI LUE VOWEL SIGN UY
 * 	0000 <control>
 * 19BD NEW TAI LUE VOWEL SIGN OY
 * 	0000 <control>
 * 19BE NEW TAI LUE VOWEL SIGN OAY
 * 	0000 <control>
 * 19BF NEW TAI LUE VOWEL SIGN UEY
 * 	0000 <control>
 * 19C0 NEW TAI LUE VOWEL SIGN IY
 * 	0000 <control>
 * 19C8 NEW TAI LUE TONE MARK-1
 * 	0000 <control>
 * 19C9 NEW TAI LUE TONE MARK-2
 * 	0000 <control>
 * 1A17 BUGINESE VOWEL SIGN I
 * 	0000 <control>
 * 1A18 BUGINESE VOWEL SIGN U
 * 	0000 <control>
 * 1A19 BUGINESE VOWEL SIGN E
 * 	0000 <control>
 * 1A1A BUGINESE VOWEL SIGN O
 * 	0000 <control>
 * 1A1B BUGINESE VOWEL SIGN AE
 * 	0000 <control>
 * 1B00 BALINESE SIGN ULU RICEM
 * 	0000 <control>
 * 1B01 BALINESE SIGN ULU CANDRA
 * 	0000 <control>
 * 1B02 BALINESE SIGN CECEK
 * 	0000 <control>
 * 1B03 BALINESE SIGN SURANG
 * 	0000 <control>
 * 1B04 BALINESE SIGN BISAH
 * 	0000 <control>
 * 1B06 BALINESE LETTER AKARA TEDUNG
 * 	1B05 BALINESE LETTER AKARA
 * 1B08 BALINESE LETTER IKARA TEDUNG
 * 	1B07 BALINESE LETTER IKARA
 * 1B0A BALINESE LETTER UKARA TEDUNG
 * 	1B09 BALINESE LETTER UKARA
 * 1B0C BALINESE LETTER RA REPA TEDUNG
 * 	1B0B BALINESE LETTER RA REPA
 * 1B0E BALINESE LETTER LA LENGA TEDUNG
 * 	1B0D BALINESE LETTER LA LENGA
 * 1B12 BALINESE LETTER OKARA TEDUNG
 * 	1B11 BALINESE LETTER OKARA
 * 1B34 BALINESE SIGN REREKAN
 * 	0000 <control>
 * 1B35 BALINESE VOWEL SIGN TEDUNG
 * 	0000 <control>
 * 1B36 BALINESE VOWEL SIGN ULU
 * 	0000 <control>
 * 1B37 BALINESE VOWEL SIGN ULU SARI
 * 	0000 <control>
 * 1B38 BALINESE VOWEL SIGN SUKU
 * 	0000 <control>
 * 1B39 BALINESE VOWEL SIGN SUKU ILUT
 * 	0000 <control>
 * 1B3A BALINESE VOWEL SIGN RA REPA
 * 	0000 <control>
 * 1B3B BALINESE VOWEL SIGN RA REPA TEDUNG
 * 	0000 <control>
 * 1B3C BALINESE VOWEL SIGN LA LENGA
 * 	0000 <control>
 * 1B3D BALINESE VOWEL SIGN LA LENGA TEDUNG
 * 	0000 <control>
 * 1B3E BALINESE VOWEL SIGN TALING
 * 	0000 <control>
 * 1B3F BALINESE VOWEL SIGN TALING REPA
 * 	0000 <control>
 * 1B40 BALINESE VOWEL SIGN TALING TEDUNG
 * 	0000 <control>
 * 1B41 BALINESE VOWEL SIGN TALING REPA TEDUNG
 * 	0000 <control>
 * 1B42 BALINESE VOWEL SIGN PEPET
 * 	0000 <control>
 * 1B43 BALINESE VOWEL SIGN PEPET TEDUNG
 * 	0000 <control>
 * 1B44 BALINESE ADEG ADEG
 * 	0000 <control>
 * 1B6B BALINESE MUSICAL SYMBOL COMBINING TEGEH
 * 	0000 <control>
 * 1B6C BALINESE MUSICAL SYMBOL COMBINING ENDEP
 * 	0000 <control>
 * 1B6D BALINESE MUSICAL SYMBOL COMBINING KEMPUL
 * 	0000 <control>
 * 1B6E BALINESE MUSICAL SYMBOL COMBINING KEMPLI
 * 	0000 <control>
 * 1B6F BALINESE MUSICAL SYMBOL COMBINING JEGOGAN
 * 	0000 <control>
 * 1B70 BALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH JEGOGAN
 * 	0000 <control>
 * 1B71 BALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGAN
 * 	0000 <control>
 * 1B72 BALINESE MUSICAL SYMBOL COMBINING BENDE
 * 	0000 <control>
 * 1B73 BALINESE MUSICAL SYMBOL COMBINING GONG
 * 	0000 <control>
 * 1B80 SUNDANESE SIGN PANYECEK
 * 	0000 <control>
 * 1B81 SUNDANESE SIGN PANGLAYAR
 * 	0000 <control>
 * 1B82 SUNDANESE SIGN PANGWISAD
 * 	0000 <control>
 * 1BA1 SUNDANESE CONSONANT SIGN PAMINGKAL
 * 	0000 <control>
 * 1BA2 SUNDANESE CONSONANT SIGN PANYAKRA
 * 	0000 <control>
 * 1BA3 SUNDANESE CONSONANT SIGN PANYIKU
 * 	0000 <control>
 * 1BA4 SUNDANESE VOWEL SIGN PANGHULU
 * 	0000 <control>
 * 1BA5 SUNDANESE VOWEL SIGN PANYUKU
 * 	0000 <control>
 * 1BA6 SUNDANESE VOWEL SIGN PANAELAENG
 * 	0000 <control>
 * 1BA7 SUNDANESE VOWEL SIGN PANOLONG
 * 	0000 <control>
 * 1BA8 SUNDANESE VOWEL SIGN PAMEPET
 * 	0000 <control>
 * 1BA9 SUNDANESE VOWEL SIGN PANEULEUNG
 * 	0000 <control>
 * 1BAA SUNDANESE SIGN PAMAAEH
 * 	0000 <control>
 * 1C24 LEPCHA SUBJOINED LETTER YA
 * 	0000 <control>
 * 1C25 LEPCHA SUBJOINED LETTER RA
 * 	0000 <control>
 * 1C26 LEPCHA VOWEL SIGN AA
 * 	0000 <control>
 * 1C27 LEPCHA VOWEL SIGN I
 * 	0000 <control>
 * 1C28 LEPCHA VOWEL SIGN O
 * 	0000 <control>
 * 1C29 LEPCHA VOWEL SIGN OO
 * 	0000 <control>
 * 1C2A LEPCHA VOWEL SIGN U
 * 	0000 <control>
 * 1C2B LEPCHA VOWEL SIGN UU
 * 	0000 <control>
 * 1C2C LEPCHA VOWEL SIGN E
 * 	0000 <control>
 * 1C2D LEPCHA CONSONANT SIGN K
 * 	0000 <control>
 * 1C2E LEPCHA CONSONANT SIGN M
 * 	0000 <control>
 * 1C2F LEPCHA CONSONANT SIGN L
 * 	0000 <control>
 * 1C30 LEPCHA CONSONANT SIGN N
 * 	0000 <control>
 * 1C31 LEPCHA CONSONANT SIGN P
 * 	0000 <control>
 * 1C32 LEPCHA CONSONANT SIGN R
 * 	0000 <control>
 * 1C33 LEPCHA CONSONANT SIGN T
 * 	0000 <control>
 * 1C34 LEPCHA CONSONANT SIGN NYIN-DO
 * 	0000 <control>
 * 1C35 LEPCHA CONSONANT SIGN KANG
 * 	0000 <control>
 * 1C36 LEPCHA SIGN RAN
 * 	0000 <control>
 * 1C37 LEPCHA SIGN NUKTA
 * 	0000 <control>
 * 1D2C MODIFIER LETTER CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D2D MODIFIER LETTER CAPITAL AE
 * 	00C6 LATIN CAPITAL LETTER AE
 * 1D2E MODIFIER LETTER CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 1D30 MODIFIER LETTER CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D31 MODIFIER LETTER CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 1D32 MODIFIER LETTER CAPITAL REVERSED E
 * 	018E LATIN CAPITAL LETTER REVERSED E
 * 1D33 MODIFIER LETTER CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D34 MODIFIER LETTER CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 1D35 MODIFIER LETTER CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 1D36 MODIFIER LETTER CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D37 MODIFIER LETTER CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D38 MODIFIER LETTER CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 1D39 MODIFIER LETTER CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 1D3A MODIFIER LETTER CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 1D3C MODIFIER LETTER CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D3D MODIFIER LETTER CAPITAL OU
 * 	0222 LATIN CAPITAL LETTER OU
 * 1D3E MODIFIER LETTER CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 1D3F MODIFIER LETTER CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 1D40 MODIFIER LETTER CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D41 MODIFIER LETTER CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D42 MODIFIER LETTER CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D43 MODIFIER LETTER SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D44 MODIFIER LETTER SMALL TURNED A
 * 	0250 LATIN SMALL LETTER TURNED A
 * 1D45 MODIFIER LETTER SMALL ALPHA
 * 	0251 LATIN SMALL LETTER ALPHA
 * 1D46 MODIFIER LETTER SMALL TURNED AE
 * 	1D02 LATIN SMALL LETTER TURNED AE
 * 1D47 MODIFIER LETTER SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D48 MODIFIER LETTER SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D49 MODIFIER LETTER SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 1D4A MODIFIER LETTER SMALL SCHWA
 * 	0259 LATIN SMALL LETTER SCHWA
 * 1D4B MODIFIER LETTER SMALL OPEN E
 * 	025B LATIN SMALL LETTER OPEN E
 * 1D4C MODIFIER LETTER SMALL TURNED OPEN E
 * 	025C LATIN SMALL LETTER REVERSED OPEN E
 * 1D4D MODIFIER LETTER SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 1D4F MODIFIER LETTER SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D50 MODIFIER LETTER SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D51 MODIFIER LETTER SMALL ENG
 * 	014B LATIN SMALL LETTER ENG
 * 1D52 MODIFIER LETTER SMALL O
 * 	006F LATIN SMALL LETTER O
 * 1D53 MODIFIER LETTER SMALL OPEN O
 * 	0254 LATIN SMALL LETTER OPEN O
 * 1D54 MODIFIER LETTER SMALL TOP HALF O
 * 	1D16 LATIN SMALL LETTER TOP HALF O
 * 1D55 MODIFIER LETTER SMALL BOTTOM HALF O
 * 	1D17 LATIN SMALL LETTER BOTTOM HALF O
 * 1D56 MODIFIER LETTER SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D57 MODIFIER LETTER SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D58 MODIFIER LETTER SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D59 MODIFIER LETTER SMALL SIDEWAYS U
 * 	1D1D LATIN SMALL LETTER SIDEWAYS U
 * 1D5A MODIFIER LETTER SMALL TURNED M
 * 	026F LATIN SMALL LETTER TURNED M
 * 1D5B MODIFIER LETTER SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D5C MODIFIER LETTER SMALL AIN
 * 	1D25 LATIN LETTER AIN
 * 1D5D MODIFIER LETTER SMALL BETA
 * 	03B2 GREEK SMALL LETTER BETA
 * 1D5E MODIFIER LETTER SMALL GREEK GAMMA
 * 	03B3 GREEK SMALL LETTER GAMMA
 * 1D5F MODIFIER LETTER SMALL DELTA
 * 	03B4 GREEK SMALL LETTER DELTA
 * 1D60 MODIFIER LETTER SMALL GREEK PHI
 * 	03C6 GREEK SMALL LETTER PHI
 * 1D61 MODIFIER LETTER SMALL CHI
 * 	03C7 GREEK SMALL LETTER CHI
 * 1D62 LATIN SUBSCRIPT SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 1D63 LATIN SUBSCRIPT SMALL LETTER R
 * 	0072 LATIN SMALL LETTER R
 * 1D64 LATIN SUBSCRIPT SMALL LETTER U
 * 	0075 LATIN SMALL LETTER U
 * 1D65 LATIN SUBSCRIPT SMALL LETTER V
 * 	0076 LATIN SMALL LETTER V
 * 1D66 GREEK SUBSCRIPT SMALL LETTER BETA
 * 	03B2 GREEK SMALL LETTER BETA
 * 1D67 GREEK SUBSCRIPT SMALL LETTER GAMMA
 * 	03B3 GREEK SMALL LETTER GAMMA
 * 1D68 GREEK SUBSCRIPT SMALL LETTER RHO
 * 	03C1 GREEK SMALL LETTER RHO
 * 1D69 GREEK SUBSCRIPT SMALL LETTER PHI
 * 	03C6 GREEK SMALL LETTER PHI
 * 1D6A GREEK SUBSCRIPT SMALL LETTER CHI
 * 	03C7 GREEK SMALL LETTER CHI
 * 1D78 MODIFIER LETTER CYRILLIC EN
 * 	043D CYRILLIC SMALL LETTER EN
 * 1D9B MODIFIER LETTER SMALL TURNED ALPHA
 * 	0252 LATIN SMALL LETTER TURNED ALPHA
 * 1D9C MODIFIER LETTER SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D9D MODIFIER LETTER SMALL C WITH CURL
 * 	0255 LATIN SMALL LETTER C WITH CURL
 * 1D9E MODIFIER LETTER SMALL ETH
 * 	00F0 LATIN SMALL LETTER ETH
 * 1D9F MODIFIER LETTER SMALL REVERSED OPEN E
 * 	025C LATIN SMALL LETTER REVERSED OPEN E
 * 1DA0 MODIFIER LETTER SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1DA1 MODIFIER LETTER SMALL DOTLESS J WITH STROKE
 * 	025F LATIN SMALL LETTER DOTLESS J WITH STROKE
 * 1DA2 MODIFIER LETTER SMALL SCRIPT G
 * 	0261 LATIN SMALL LETTER SCRIPT G
 * 1DA3 MODIFIER LETTER SMALL TURNED H
 * 	0265 LATIN SMALL LETTER TURNED H
 * 1DA4 MODIFIER LETTER SMALL I WITH STROKE
 * 	0268 LATIN SMALL LETTER I WITH STROKE
 * 1DA5 MODIFIER LETTER SMALL IOTA
 * 	0269 LATIN SMALL LETTER IOTA
 * 1DA6 MODIFIER LETTER SMALL CAPITAL I
 * 	026A LATIN LETTER SMALL CAPITAL I
 * 1DA7 MODIFIER LETTER SMALL CAPITAL I WITH STROKE
 * 	1D7B LATIN SMALL CAPITAL LETTER I WITH STROKE
 * 1DA8 MODIFIER LETTER SMALL J WITH CROSSED-TAIL
 * 	029D LATIN SMALL LETTER J WITH CROSSED-TAIL
 * 1DA9 MODIFIER LETTER SMALL L WITH RETROFLEX HOOK
 * 	026D LATIN SMALL LETTER L WITH RETROFLEX HOOK
 * 1DAA MODIFIER LETTER SMALL L WITH PALATAL HOOK
 * 	1D85 LATIN SMALL LETTER L WITH PALATAL HOOK
 * 1DAB MODIFIER LETTER SMALL CAPITAL L
 * 	029F LATIN LETTER SMALL CAPITAL L
 * 1DAC MODIFIER LETTER SMALL M WITH HOOK
 * 	0271 LATIN SMALL LETTER M WITH HOOK
 * 1DAD MODIFIER LETTER SMALL TURNED M WITH LONG LEG
 * 	0270 LATIN SMALL LETTER TURNED M WITH LONG LEG
 * 1DAE MODIFIER LETTER SMALL N WITH LEFT HOOK
 * 	0272 LATIN SMALL LETTER N WITH LEFT HOOK
 * 1DAF MODIFIER LETTER SMALL N WITH RETROFLEX HOOK
 * 	0273 LATIN SMALL LETTER N WITH RETROFLEX HOOK
 * 1DB0 MODIFIER LETTER SMALL CAPITAL N
 * 	0274 LATIN LETTER SMALL CAPITAL N
 * 1DB1 MODIFIER LETTER SMALL BARRED O
 * 	0275 LATIN SMALL LETTER BARRED O
 * 1DB2 MODIFIER LETTER SMALL PHI
 * 	0278 LATIN SMALL LETTER PHI
 * 1DB3 MODIFIER LETTER SMALL S WITH HOOK
 * 	0282 LATIN SMALL LETTER S WITH HOOK
 * 1DB4 MODIFIER LETTER SMALL ESH
 * 	0283 LATIN SMALL LETTER ESH
 * 1DB5 MODIFIER LETTER SMALL T WITH PALATAL HOOK
 * 	01AB LATIN SMALL LETTER T WITH PALATAL HOOK
 * 1DB6 MODIFIER LETTER SMALL U BAR
 * 	0289 LATIN SMALL LETTER U BAR
 * 1DB7 MODIFIER LETTER SMALL UPSILON
 * 	028A LATIN SMALL LETTER UPSILON
 * 1DB8 MODIFIER LETTER SMALL CAPITAL U
 * 	1D1C LATIN LETTER SMALL CAPITAL U
 * 1DB9 MODIFIER LETTER SMALL V WITH HOOK
 * 	028B LATIN SMALL LETTER V WITH HOOK
 * 1DBA MODIFIER LETTER SMALL TURNED V
 * 	028C LATIN SMALL LETTER TURNED V
 * 1DBB MODIFIER LETTER SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1DBC MODIFIER LETTER SMALL Z WITH RETROFLEX HOOK
 * 	0290 LATIN SMALL LETTER Z WITH RETROFLEX HOOK
 * 1DBD MODIFIER LETTER SMALL Z WITH CURL
 * 	0291 LATIN SMALL LETTER Z WITH CURL
 * 1DBE MODIFIER LETTER SMALL EZH
 * 	0292 LATIN SMALL LETTER EZH
 * 1DBF MODIFIER LETTER SMALL THETA
 * 	03B8 GREEK SMALL LETTER THETA
 * 1DC0 COMBINING DOTTED GRAVE ACCENT
 * 	0000 <control>
 * 1DC1 COMBINING DOTTED ACUTE ACCENT
 * 	0000 <control>
 * 1DC2 COMBINING SNAKE BELOW
 * 	0000 <control>
 * 1DC3 COMBINING SUSPENSION MARK
 * 	0000 <control>
 * 1DC4 COMBINING MACRON-ACUTE
 * 	0000 <control>
 * 1DC5 COMBINING GRAVE-MACRON
 * 	0000 <control>
 * 1DC6 COMBINING MACRON-GRAVE
 * 	0000 <control>
 * 1DC7 COMBINING ACUTE-MACRON
 * 	0000 <control>
 * 1DC8 COMBINING GRAVE-ACUTE-GRAVE
 * 	0000 <control>
 * 1DC9 COMBINING ACUTE-GRAVE-ACUTE
 * 	0000 <control>
 * 1DCA COMBINING LATIN SMALL LETTER R BELOW
 * 	0000 <control>
 * 1DCB COMBINING BREVE-MACRON
 * 	0000 <control>
 * 1DCC COMBINING MACRON-BREVE
 * 	0000 <control>
 * 1DCD COMBINING DOUBLE CIRCUMFLEX ABOVE
 * 	0000 <control>
 * 1DCE COMBINING OGONEK ABOVE
 * 	0000 <control>
 * 1DCF COMBINING ZIGZAG BELOW
 * 	0000 <control>
 * 1DD0 COMBINING IS BELOW
 * 	0000 <control>
 * 1DD1 COMBINING UR ABOVE
 * 	0000 <control>
 * 1DD2 COMBINING US ABOVE
 * 	0000 <control>
 * 1DD3 COMBINING LATIN SMALL LETTER FLATTENED OPEN A ABOVE
 * 	0000 <control>
 * 1DD4 COMBINING LATIN SMALL LETTER AE
 * 	0000 <control>
 * 1DD5 COMBINING LATIN SMALL LETTER AO
 * 	0000 <control>
 * 1DD6 COMBINING LATIN SMALL LETTER AV
 * 	0000 <control>
 * 1DD7 COMBINING LATIN SMALL LETTER C CEDILLA
 * 	0000 <control>
 * 1DD8 COMBINING LATIN SMALL LETTER INSULAR D
 * 	0000 <control>
 * 1DD9 COMBINING LATIN SMALL LETTER ETH
 * 	0000 <control>
 * 1DDA COMBINING LATIN SMALL LETTER G
 * 	0000 <control>
 * 1DDB COMBINING LATIN LETTER SMALL CAPITAL G
 * 	0000 <control>
 * 1DDC COMBINING LATIN SMALL LETTER K
 * 	0000 <control>
 * 1DDD COMBINING LATIN SMALL LETTER L
 * 	0000 <control>
 * 1DDE COMBINING LATIN LETTER SMALL CAPITAL L
 * 	0000 <control>
 * 1DDF COMBINING LATIN LETTER SMALL CAPITAL M
 * 	0000 <control>
 * 1DE0 COMBINING LATIN SMALL LETTER N
 * 	0000 <control>
 * 1DE1 COMBINING LATIN LETTER SMALL CAPITAL N
 * 	0000 <control>
 * 1DE2 COMBINING LATIN LETTER SMALL CAPITAL R
 * 	0000 <control>
 * 1DE3 COMBINING LATIN SMALL LETTER R ROTUNDA
 * 	0000 <control>
 * 1DE4 COMBINING LATIN SMALL LETTER S
 * 	0000 <control>
 * 1DE5 COMBINING LATIN SMALL LETTER LONG S
 * 	0000 <control>
 * 1DE6 COMBINING LATIN SMALL LETTER Z
 * 	0000 <control>
 * 1DFE COMBINING LEFT ARROWHEAD ABOVE
 * 	0000 <control>
 * 1DFF COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW
 * 	0000 <control>
 * 1E00 LATIN CAPITAL LETTER A WITH RING BELOW
 * 	0041 LATIN CAPITAL LETTER A
 * 1E01 LATIN SMALL LETTER A WITH RING BELOW
 * 	0061 LATIN SMALL LETTER A
 * 1E02 LATIN CAPITAL LETTER B WITH DOT ABOVE
 * 	0042 LATIN CAPITAL LETTER B
 * 1E03 LATIN SMALL LETTER B WITH DOT ABOVE
 * 	0062 LATIN SMALL LETTER B
 * 1E04 LATIN CAPITAL LETTER B WITH DOT BELOW
 * 	0042 LATIN CAPITAL LETTER B
 * 1E05 LATIN SMALL LETTER B WITH DOT BELOW
 * 	0062 LATIN SMALL LETTER B
 * 1E06 LATIN CAPITAL LETTER B WITH LINE BELOW
 * 	0042 LATIN CAPITAL LETTER B
 * 1E07 LATIN SMALL LETTER B WITH LINE BELOW
 * 	0062 LATIN SMALL LETTER B
 * 1E08 LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
 * 	0043 LATIN CAPITAL LETTER C
 * 1E09 LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
 * 	0063 LATIN SMALL LETTER C
 * 1E0A LATIN CAPITAL LETTER D WITH DOT ABOVE
 * 	0044 LATIN CAPITAL LETTER D
 * 1E0B LATIN SMALL LETTER D WITH DOT ABOVE
 * 	0064 LATIN SMALL LETTER D
 * 1E0C LATIN CAPITAL LETTER D WITH DOT BELOW
 * 	0044 LATIN CAPITAL LETTER D
 * 1E0D LATIN SMALL LETTER D WITH DOT BELOW
 * 	0064 LATIN SMALL LETTER D
 * 1E0E LATIN CAPITAL LETTER D WITH LINE BELOW
 * 	0044 LATIN CAPITAL LETTER D
 * 1E0F LATIN SMALL LETTER D WITH LINE BELOW
 * 	0064 LATIN SMALL LETTER D
 * 1E10 LATIN CAPITAL LETTER D WITH CEDILLA
 * 	0044 LATIN CAPITAL LETTER D
 * 1E11 LATIN SMALL LETTER D WITH CEDILLA
 * 	0064 LATIN SMALL LETTER D
 * 1E12 LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
 * 	0044 LATIN CAPITAL LETTER D
 * 1E13 LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
 * 	0064 LATIN SMALL LETTER D
 * 1E14 LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
 * 	0045 LATIN CAPITAL LETTER E
 * 1E15 LATIN SMALL LETTER E WITH MACRON AND GRAVE
 * 	0065 LATIN SMALL LETTER E
 * 1E16 LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
 * 	0045 LATIN CAPITAL LETTER E
 * 1E17 LATIN SMALL LETTER E WITH MACRON AND ACUTE
 * 	0065 LATIN SMALL LETTER E
 * 1E18 LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
 * 	0045 LATIN CAPITAL LETTER E
 * 1E19 LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
 * 	0065 LATIN SMALL LETTER E
 * 1E1A LATIN CAPITAL LETTER E WITH TILDE BELOW
 * 	0045 LATIN CAPITAL LETTER E
 * 1E1B LATIN SMALL LETTER E WITH TILDE BELOW
 * 	0065 LATIN SMALL LETTER E
 * 1E1C LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
 * 	0045 LATIN CAPITAL LETTER E
 * 1E1D LATIN SMALL LETTER E WITH CEDILLA AND BREVE
 * 	0065 LATIN SMALL LETTER E
 * 1E1E LATIN CAPITAL LETTER F WITH DOT ABOVE
 * 	0046 LATIN CAPITAL LETTER F
 * 1E1F LATIN SMALL LETTER F WITH DOT ABOVE
 * 	0066 LATIN SMALL LETTER F
 * 1E20 LATIN CAPITAL LETTER G WITH MACRON
 * 	0047 LATIN CAPITAL LETTER G
 * 1E21 LATIN SMALL LETTER G WITH MACRON
 * 	0067 LATIN SMALL LETTER G
 * 1E22 LATIN CAPITAL LETTER H WITH DOT ABOVE
 * 	0048 LATIN CAPITAL LETTER H
 * 1E23 LATIN SMALL LETTER H WITH DOT ABOVE
 * 	0068 LATIN SMALL LETTER H
 * 1E24 LATIN CAPITAL LETTER H WITH DOT BELOW
 * 	0048 LATIN CAPITAL LETTER H
 * 1E25 LATIN SMALL LETTER H WITH DOT BELOW
 * 	0068 LATIN SMALL LETTER H
 * 1E26 LATIN CAPITAL LETTER H WITH DIAERESIS
 * 	0048 LATIN CAPITAL LETTER H
 * 1E27 LATIN SMALL LETTER H WITH DIAERESIS
 * 	0068 LATIN SMALL LETTER H
 * 1E28 LATIN CAPITAL LETTER H WITH CEDILLA
 * 	0048 LATIN CAPITAL LETTER H
 * 1E29 LATIN SMALL LETTER H WITH CEDILLA
 * 	0068 LATIN SMALL LETTER H
 * 1E2A LATIN CAPITAL LETTER H WITH BREVE BELOW
 * 	0048 LATIN CAPITAL LETTER H
 * 1E2B LATIN SMALL LETTER H WITH BREVE BELOW
 * 	0068 LATIN SMALL LETTER H
 * 1E2C LATIN CAPITAL LETTER I WITH TILDE BELOW
 * 	0049 LATIN CAPITAL LETTER I
 * 1E2D LATIN SMALL LETTER I WITH TILDE BELOW
 * 	0069 LATIN SMALL LETTER I
 * 1E2E LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
 * 	0049 LATIN CAPITAL LETTER I
 * 1E2F LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
 * 	0069 LATIN SMALL LETTER I
 * 1E30 LATIN CAPITAL LETTER K WITH ACUTE
 * 	004B LATIN CAPITAL LETTER K
 * 1E31 LATIN SMALL LETTER K WITH ACUTE
 * 	006B LATIN SMALL LETTER K
 * 1E32 LATIN CAPITAL LETTER K WITH DOT BELOW
 * 	004B LATIN CAPITAL LETTER K
 * 1E33 LATIN SMALL LETTER K WITH DOT BELOW
 * 	006B LATIN SMALL LETTER K
 * 1E34 LATIN CAPITAL LETTER K WITH LINE BELOW
 * 	004B LATIN CAPITAL LETTER K
 * 1E35 LATIN SMALL LETTER K WITH LINE BELOW
 * 	006B LATIN SMALL LETTER K
 * 1E36 LATIN CAPITAL LETTER L WITH DOT BELOW
 * 	004C LATIN CAPITAL LETTER L
 * 1E37 LATIN SMALL LETTER L WITH DOT BELOW
 * 	006C LATIN SMALL LETTER L
 * 1E38 LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
 * 	004C LATIN CAPITAL LETTER L
 * 1E39 LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
 * 	006C LATIN SMALL LETTER L
 * 1E3A LATIN CAPITAL LETTER L WITH LINE BELOW
 * 	004C LATIN CAPITAL LETTER L
 * 1E3B LATIN SMALL LETTER L WITH LINE BELOW
 * 	006C LATIN SMALL LETTER L
 * 1E3C LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
 * 	004C LATIN CAPITAL LETTER L
 * 1E3D LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
 * 	006C LATIN SMALL LETTER L
 * 1E3E LATIN CAPITAL LETTER M WITH ACUTE
 * 	004D LATIN CAPITAL LETTER M
 * 1E3F LATIN SMALL LETTER M WITH ACUTE
 * 	006D LATIN SMALL LETTER M
 * 1E40 LATIN CAPITAL LETTER M WITH DOT ABOVE
 * 	004D LATIN CAPITAL LETTER M
 * 1E41 LATIN SMALL LETTER M WITH DOT ABOVE
 * 	006D LATIN SMALL LETTER M
 * 1E42 LATIN CAPITAL LETTER M WITH DOT BELOW
 * 	004D LATIN CAPITAL LETTER M
 * 1E43 LATIN SMALL LETTER M WITH DOT BELOW
 * 	006D LATIN SMALL LETTER M
 * 1E44 LATIN CAPITAL LETTER N WITH DOT ABOVE
 * 	004E LATIN CAPITAL LETTER N
 * 1E45 LATIN SMALL LETTER N WITH DOT ABOVE
 * 	006E LATIN SMALL LETTER N
 * 1E46 LATIN CAPITAL LETTER N WITH DOT BELOW
 * 	004E LATIN CAPITAL LETTER N
 * 1E47 LATIN SMALL LETTER N WITH DOT BELOW
 * 	006E LATIN SMALL LETTER N
 * 1E48 LATIN CAPITAL LETTER N WITH LINE BELOW
 * 	004E LATIN CAPITAL LETTER N
 * 1E49 LATIN SMALL LETTER N WITH LINE BELOW
 * 	006E LATIN SMALL LETTER N
 * 1E4A LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
 * 	004E LATIN CAPITAL LETTER N
 * 1E4B LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
 * 	006E LATIN SMALL LETTER N
 * 1E4C LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
 * 	004F LATIN CAPITAL LETTER O
 * 1E4D LATIN SMALL LETTER O WITH TILDE AND ACUTE
 * 	006F LATIN SMALL LETTER O
 * 1E4E LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
 * 	004F LATIN CAPITAL LETTER O
 * 1E4F LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
 * 	006F LATIN SMALL LETTER O
 * 1E50 LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
 * 	004F LATIN CAPITAL LETTER O
 * 1E51 LATIN SMALL LETTER O WITH MACRON AND GRAVE
 * 	006F LATIN SMALL LETTER O
 * 1E52 LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
 * 	004F LATIN CAPITAL LETTER O
 * 1E53 LATIN SMALL LETTER O WITH MACRON AND ACUTE
 * 	006F LATIN SMALL LETTER O
 * 1E54 LATIN CAPITAL LETTER P WITH ACUTE
 * 	0050 LATIN CAPITAL LETTER P
 * 1E55 LATIN SMALL LETTER P WITH ACUTE
 * 	0070 LATIN SMALL LETTER P
 * 1E56 LATIN CAPITAL LETTER P WITH DOT ABOVE
 * 	0050 LATIN CAPITAL LETTER P
 * 1E57 LATIN SMALL LETTER P WITH DOT ABOVE
 * 	0070 LATIN SMALL LETTER P
 * 1E58 LATIN CAPITAL LETTER R WITH DOT ABOVE
 * 	0052 LATIN CAPITAL LETTER R
 * 1E59 LATIN SMALL LETTER R WITH DOT ABOVE
 * 	0072 LATIN SMALL LETTER R
 * 1E5A LATIN CAPITAL LETTER R WITH DOT BELOW
 * 	0052 LATIN CAPITAL LETTER R
 * 1E5B LATIN SMALL LETTER R WITH DOT BELOW
 * 	0072 LATIN SMALL LETTER R
 * 1E5C LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
 * 	0052 LATIN CAPITAL LETTER R
 * 1E5D LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
 * 	0072 LATIN SMALL LETTER R
 * 1E5E LATIN CAPITAL LETTER R WITH LINE BELOW
 * 	0052 LATIN CAPITAL LETTER R
 * 1E5F LATIN SMALL LETTER R WITH LINE BELOW
 * 	0072 LATIN SMALL LETTER R
 * 1E60 LATIN CAPITAL LETTER S WITH DOT ABOVE
 * 	0053 LATIN CAPITAL LETTER S
 * 1E61 LATIN SMALL LETTER S WITH DOT ABOVE
 * 	0073 LATIN SMALL LETTER S
 * 1E62 LATIN CAPITAL LETTER S WITH DOT BELOW
 * 	0053 LATIN CAPITAL LETTER S
 * 1E63 LATIN SMALL LETTER S WITH DOT BELOW
 * 	0073 LATIN SMALL LETTER S
 * 1E64 LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
 * 	0053 LATIN CAPITAL LETTER S
 * 1E65 LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
 * 	0073 LATIN SMALL LETTER S
 * 1E66 LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
 * 	0053 LATIN CAPITAL LETTER S
 * 1E67 LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
 * 	0073 LATIN SMALL LETTER S
 * 1E68 LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
 * 	0053 LATIN CAPITAL LETTER S
 * 1E69 LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
 * 	0073 LATIN SMALL LETTER S
 * 1E6A LATIN CAPITAL LETTER T WITH DOT ABOVE
 * 	0054 LATIN CAPITAL LETTER T
 * 1E6B LATIN SMALL LETTER T WITH DOT ABOVE
 * 	0074 LATIN SMALL LETTER T
 * 1E6C LATIN CAPITAL LETTER T WITH DOT BELOW
 * 	0054 LATIN CAPITAL LETTER T
 * 1E6D LATIN SMALL LETTER T WITH DOT BELOW
 * 	0074 LATIN SMALL LETTER T
 * 1E6E LATIN CAPITAL LETTER T WITH LINE BELOW
 * 	0054 LATIN CAPITAL LETTER T
 * 1E6F LATIN SMALL LETTER T WITH LINE BELOW
 * 	0074 LATIN SMALL LETTER T
 * 1E70 LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
 * 	0054 LATIN CAPITAL LETTER T
 * 1E71 LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
 * 	0074 LATIN SMALL LETTER T
 * 1E72 LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
 * 	0055 LATIN CAPITAL LETTER U
 * 1E73 LATIN SMALL LETTER U WITH DIAERESIS BELOW
 * 	0075 LATIN SMALL LETTER U
 * 1E74 LATIN CAPITAL LETTER U WITH TILDE BELOW
 * 	0055 LATIN CAPITAL LETTER U
 * 1E75 LATIN SMALL LETTER U WITH TILDE BELOW
 * 	0075 LATIN SMALL LETTER U
 * 1E76 LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
 * 	0055 LATIN CAPITAL LETTER U
 * 1E77 LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
 * 	0075 LATIN SMALL LETTER U
 * 1E78 LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
 * 	0055 LATIN CAPITAL LETTER U
 * 1E79 LATIN SMALL LETTER U WITH TILDE AND ACUTE
 * 	0075 LATIN SMALL LETTER U
 * 1E7A LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
 * 	0055 LATIN CAPITAL LETTER U
 * 1E7B LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
 * 	0075 LATIN SMALL LETTER U
 * 1E7C LATIN CAPITAL LETTER V WITH TILDE
 * 	0056 LATIN CAPITAL LETTER V
 * 1E7D LATIN SMALL LETTER V WITH TILDE
 * 	0076 LATIN SMALL LETTER V
 * 1E7E LATIN CAPITAL LETTER V WITH DOT BELOW
 * 	0056 LATIN CAPITAL LETTER V
 * 1E7F LATIN SMALL LETTER V WITH DOT BELOW
 * 	0076 LATIN SMALL LETTER V
 * 1E80 LATIN CAPITAL LETTER W WITH GRAVE
 * 	0057 LATIN CAPITAL LETTER W
 * 1E81 LATIN SMALL LETTER W WITH GRAVE
 * 	0077 LATIN SMALL LETTER W
 * 1E82 LATIN CAPITAL LETTER W WITH ACUTE
 * 	0057 LATIN CAPITAL LETTER W
 * 1E83 LATIN SMALL LETTER W WITH ACUTE
 * 	0077 LATIN SMALL LETTER W
 * 1E84 LATIN CAPITAL LETTER W WITH DIAERESIS
 * 	0057 LATIN CAPITAL LETTER W
 * 1E85 LATIN SMALL LETTER W WITH DIAERESIS
 * 	0077 LATIN SMALL LETTER W
 * 1E86 LATIN CAPITAL LETTER W WITH DOT ABOVE
 * 	0057 LATIN CAPITAL LETTER W
 * 1E87 LATIN SMALL LETTER W WITH DOT ABOVE
 * 	0077 LATIN SMALL LETTER W
 * 1E88 LATIN CAPITAL LETTER W WITH DOT BELOW
 * 	0057 LATIN CAPITAL LETTER W
 * 1E89 LATIN SMALL LETTER W WITH DOT BELOW
 * 	0077 LATIN SMALL LETTER W
 * 1E8A LATIN CAPITAL LETTER X WITH DOT ABOVE
 * 	0058 LATIN CAPITAL LETTER X
 * 1E8B LATIN SMALL LETTER X WITH DOT ABOVE
 * 	0078 LATIN SMALL LETTER X
 * 1E8C LATIN CAPITAL LETTER X WITH DIAERESIS
 * 	0058 LATIN CAPITAL LETTER X
 * 1E8D LATIN SMALL LETTER X WITH DIAERESIS
 * 	0078 LATIN SMALL LETTER X
 * 1E8E LATIN CAPITAL LETTER Y WITH DOT ABOVE
 * 	0059 LATIN CAPITAL LETTER Y
 * 1E8F LATIN SMALL LETTER Y WITH DOT ABOVE
 * 	0079 LATIN SMALL LETTER Y
 * 1E90 LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
 * 	005A LATIN CAPITAL LETTER Z
 * 1E91 LATIN SMALL LETTER Z WITH CIRCUMFLEX
 * 	007A LATIN SMALL LETTER Z
 * 1E92 LATIN CAPITAL LETTER Z WITH DOT BELOW
 * 	005A LATIN CAPITAL LETTER Z
 * 1E93 LATIN SMALL LETTER Z WITH DOT BELOW
 * 	007A LATIN SMALL LETTER Z
 * 1E94 LATIN CAPITAL LETTER Z WITH LINE BELOW
 * 	005A LATIN CAPITAL LETTER Z
 * 1E95 LATIN SMALL LETTER Z WITH LINE BELOW
 * 	007A LATIN SMALL LETTER Z
 * 1E96 LATIN SMALL LETTER H WITH LINE BELOW
 * 	0068 LATIN SMALL LETTER H
 * 1E97 LATIN SMALL LETTER T WITH DIAERESIS
 * 	0074 LATIN SMALL LETTER T
 * 1E98 LATIN SMALL LETTER W WITH RING ABOVE
 * 	0077 LATIN SMALL LETTER W
 * 1E99 LATIN SMALL LETTER Y WITH RING ABOVE
 * 	0079 LATIN SMALL LETTER Y
 * 1E9A LATIN SMALL LETTER A WITH RIGHT HALF RING
 * 	0061 LATIN SMALL LETTER A
 * 	02BE MODIFIER LETTER RIGHT HALF RING
 * 1E9B LATIN SMALL LETTER LONG S WITH DOT ABOVE
 * 	0073 LATIN SMALL LETTER S
 * 1EA0 LATIN CAPITAL LETTER A WITH DOT BELOW
 * 	0041 LATIN CAPITAL LETTER A
 * 1EA1 LATIN SMALL LETTER A WITH DOT BELOW
 * 	0061 LATIN SMALL LETTER A
 * 1EA2 LATIN CAPITAL LETTER A WITH HOOK ABOVE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EA3 LATIN SMALL LETTER A WITH HOOK ABOVE
 * 	0061 LATIN SMALL LETTER A
 * 1EA4 LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EA5 LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
 * 	0061 LATIN SMALL LETTER A
 * 1EA6 LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EA7 LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
 * 	0061 LATIN SMALL LETTER A
 * 1EA8 LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EA9 LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
 * 	0061 LATIN SMALL LETTER A
 * 1EAA LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EAB LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
 * 	0061 LATIN SMALL LETTER A
 * 1EAC LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
 * 	0041 LATIN CAPITAL LETTER A
 * 1EAD LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
 * 	0061 LATIN SMALL LETTER A
 * 1EAE LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EAF LATIN SMALL LETTER A WITH BREVE AND ACUTE
 * 	0061 LATIN SMALL LETTER A
 * 1EB0 LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EB1 LATIN SMALL LETTER A WITH BREVE AND GRAVE
 * 	0061 LATIN SMALL LETTER A
 * 1EB2 LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EB3 LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
 * 	0061 LATIN SMALL LETTER A
 * 1EB4 LATIN CAPITAL LETTER A WITH BREVE AND TILDE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EB5 LATIN SMALL LETTER A WITH BREVE AND TILDE
 * 	0061 LATIN SMALL LETTER A
 * 1EB6 LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
 * 	0041 LATIN CAPITAL LETTER A
 * 1EB7 LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
 * 	0061 LATIN SMALL LETTER A
 * 1EB8 LATIN CAPITAL LETTER E WITH DOT BELOW
 * 	0045 LATIN CAPITAL LETTER E
 * 1EB9 LATIN SMALL LETTER E WITH DOT BELOW
 * 	0065 LATIN SMALL LETTER E
 * 1EBA LATIN CAPITAL LETTER E WITH HOOK ABOVE
 * 	0045 LATIN CAPITAL LETTER E
 * 1EBB LATIN SMALL LETTER E WITH HOOK ABOVE
 * 	0065 LATIN SMALL LETTER E
 * 1EBC LATIN CAPITAL LETTER E WITH TILDE
 * 	0045 LATIN CAPITAL LETTER E
 * 1EBD LATIN SMALL LETTER E WITH TILDE
 * 	0065 LATIN SMALL LETTER E
 * 1EBE LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
 * 	0045 LATIN CAPITAL LETTER E
 * 1EBF LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
 * 	0065 LATIN SMALL LETTER E
 * 1EC0 LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
 * 	0045 LATIN CAPITAL LETTER E
 * 1EC1 LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
 * 	0065 LATIN SMALL LETTER E
 * 1EC2 LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
 * 	0045 LATIN CAPITAL LETTER E
 * 1EC3 LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
 * 	0065 LATIN SMALL LETTER E
 * 1EC4 LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
 * 	0045 LATIN CAPITAL LETTER E
 * 1EC5 LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
 * 	0065 LATIN SMALL LETTER E
 * 1EC6 LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
 * 	0045 LATIN CAPITAL LETTER E
 * 1EC7 LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
 * 	0065 LATIN SMALL LETTER E
 * 1EC8 LATIN CAPITAL LETTER I WITH HOOK ABOVE
 * 	0049 LATIN CAPITAL LETTER I
 * 1EC9 LATIN SMALL LETTER I WITH HOOK ABOVE
 * 	0069 LATIN SMALL LETTER I
 * 1ECA LATIN CAPITAL LETTER I WITH DOT BELOW
 * 	0049 LATIN CAPITAL LETTER I
 * 1ECB LATIN SMALL LETTER I WITH DOT BELOW
 * 	0069 LATIN SMALL LETTER I
 * 1ECC LATIN CAPITAL LETTER O WITH DOT BELOW
 * 	004F LATIN CAPITAL LETTER O
 * 1ECD LATIN SMALL LETTER O WITH DOT BELOW
 * 	006F LATIN SMALL LETTER O
 * 1ECE LATIN CAPITAL LETTER O WITH HOOK ABOVE
 * 	004F LATIN CAPITAL LETTER O
 * 1ECF LATIN SMALL LETTER O WITH HOOK ABOVE
 * 	006F LATIN SMALL LETTER O
 * 1ED0 LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
 * 	004F LATIN CAPITAL LETTER O
 * 1ED1 LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
 * 	006F LATIN SMALL LETTER O
 * 1ED2 LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
 * 	004F LATIN CAPITAL LETTER O
 * 1ED3 LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
 * 	006F LATIN SMALL LETTER O
 * 1ED4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
 * 	004F LATIN CAPITAL LETTER O
 * 1ED5 LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
 * 	006F LATIN SMALL LETTER O
 * 1ED6 LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
 * 	004F LATIN CAPITAL LETTER O
 * 1ED7 LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
 * 	006F LATIN SMALL LETTER O
 * 1ED8 LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
 * 	004F LATIN CAPITAL LETTER O
 * 1ED9 LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
 * 	006F LATIN SMALL LETTER O
 * 1EDA LATIN CAPITAL LETTER O WITH HORN AND ACUTE
 * 	004F LATIN CAPITAL LETTER O
 * 1EDB LATIN SMALL LETTER O WITH HORN AND ACUTE
 * 	006F LATIN SMALL LETTER O
 * 1EDC LATIN CAPITAL LETTER O WITH HORN AND GRAVE
 * 	004F LATIN CAPITAL LETTER O
 * 1EDD LATIN SMALL LETTER O WITH HORN AND GRAVE
 * 	006F LATIN SMALL LETTER O
 * 1EDE LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
 * 	004F LATIN CAPITAL LETTER O
 * 1EDF LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
 * 	006F LATIN SMALL LETTER O
 * 1EE0 LATIN CAPITAL LETTER O WITH HORN AND TILDE
 * 	004F LATIN CAPITAL LETTER O
 * 1EE1 LATIN SMALL LETTER O WITH HORN AND TILDE
 * 	006F LATIN SMALL LETTER O
 * 1EE2 LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
 * 	004F LATIN CAPITAL LETTER O
 * 1EE3 LATIN SMALL LETTER O WITH HORN AND DOT BELOW
 * 	006F LATIN SMALL LETTER O
 * 1EE4 LATIN CAPITAL LETTER U WITH DOT BELOW
 * 	0055 LATIN CAPITAL LETTER U
 * 1EE5 LATIN SMALL LETTER U WITH DOT BELOW
 * 	0075 LATIN SMALL LETTER U
 * 1EE6 LATIN CAPITAL LETTER U WITH HOOK ABOVE
 * 	0055 LATIN CAPITAL LETTER U
 * 1EE7 LATIN SMALL LETTER U WITH HOOK ABOVE
 * 	0075 LATIN SMALL LETTER U
 * 1EE8 LATIN CAPITAL LETTER U WITH HORN AND ACUTE
 * 	0055 LATIN CAPITAL LETTER U
 * 1EE9 LATIN SMALL LETTER U WITH HORN AND ACUTE
 * 	0075 LATIN SMALL LETTER U
 * 1EEA LATIN CAPITAL LETTER U WITH HORN AND GRAVE
 * 	0055 LATIN CAPITAL LETTER U
 * 1EEB LATIN SMALL LETTER U WITH HORN AND GRAVE
 * 	0075 LATIN SMALL LETTER U
 * 1EEC LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
 * 	0055 LATIN CAPITAL LETTER U
 * 1EED LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
 * 	0075 LATIN SMALL LETTER U
 * 1EEE LATIN CAPITAL LETTER U WITH HORN AND TILDE
 * 	0055 LATIN CAPITAL LETTER U
 * 1EEF LATIN SMALL LETTER U WITH HORN AND TILDE
 * 	0075 LATIN SMALL LETTER U
 * 1EF0 LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
 * 	0055 LATIN CAPITAL LETTER U
 * 1EF1 LATIN SMALL LETTER U WITH HORN AND DOT BELOW
 * 	0075 LATIN SMALL LETTER U
 * 1EF2 LATIN CAPITAL LETTER Y WITH GRAVE
 * 	0059 LATIN CAPITAL LETTER Y
 * 1EF3 LATIN SMALL LETTER Y WITH GRAVE
 * 	0079 LATIN SMALL LETTER Y
 * 1EF4 LATIN CAPITAL LETTER Y WITH DOT BELOW
 * 	0059 LATIN CAPITAL LETTER Y
 * 1EF5 LATIN SMALL LETTER Y WITH DOT BELOW
 * 	0079 LATIN SMALL LETTER Y
 * 1EF6 LATIN CAPITAL LETTER Y WITH HOOK ABOVE
 * 	0059 LATIN CAPITAL LETTER Y
 * 1EF7 LATIN SMALL LETTER Y WITH HOOK ABOVE
 * 	0079 LATIN SMALL LETTER Y
 * 1EF8 LATIN CAPITAL LETTER Y WITH TILDE
 * 	0059 LATIN CAPITAL LETTER Y
 * 1EF9 LATIN SMALL LETTER Y WITH TILDE
 * 	0079 LATIN SMALL LETTER Y
 * 1F00 GREEK SMALL LETTER ALPHA WITH PSILI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F01 GREEK SMALL LETTER ALPHA WITH DASIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F02 GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F03 GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F04 GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F05 GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F06 GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F07 GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F08 GREEK CAPITAL LETTER ALPHA WITH PSILI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F09 GREEK CAPITAL LETTER ALPHA WITH DASIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F0A GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F0B GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F0C GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F0D GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F0E GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F0F GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F10 GREEK SMALL LETTER EPSILON WITH PSILI
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F11 GREEK SMALL LETTER EPSILON WITH DASIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F12 GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F13 GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F14 GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F15 GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F18 GREEK CAPITAL LETTER EPSILON WITH PSILI
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1F19 GREEK CAPITAL LETTER EPSILON WITH DASIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1F1A GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1F1B GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1F1C GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1F1D GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1F20 GREEK SMALL LETTER ETA WITH PSILI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F21 GREEK SMALL LETTER ETA WITH DASIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F22 GREEK SMALL LETTER ETA WITH PSILI AND VARIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F23 GREEK SMALL LETTER ETA WITH DASIA AND VARIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F24 GREEK SMALL LETTER ETA WITH PSILI AND OXIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F25 GREEK SMALL LETTER ETA WITH DASIA AND OXIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F26 GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F27 GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F28 GREEK CAPITAL LETTER ETA WITH PSILI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F29 GREEK CAPITAL LETTER ETA WITH DASIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F2A GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F2B GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F2C GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F2D GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F2E GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F2F GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F30 GREEK SMALL LETTER IOTA WITH PSILI
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F31 GREEK SMALL LETTER IOTA WITH DASIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F32 GREEK SMALL LETTER IOTA WITH PSILI AND VARIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F33 GREEK SMALL LETTER IOTA WITH DASIA AND VARIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F34 GREEK SMALL LETTER IOTA WITH PSILI AND OXIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F35 GREEK SMALL LETTER IOTA WITH DASIA AND OXIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F36 GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F37 GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F38 GREEK CAPITAL LETTER IOTA WITH PSILI
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F39 GREEK CAPITAL LETTER IOTA WITH DASIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F3A GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F3B GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F3C GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F3D GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F3E GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F3F GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F40 GREEK SMALL LETTER OMICRON WITH PSILI
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F41 GREEK SMALL LETTER OMICRON WITH DASIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F42 GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F43 GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F44 GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F45 GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F48 GREEK CAPITAL LETTER OMICRON WITH PSILI
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1F49 GREEK CAPITAL LETTER OMICRON WITH DASIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1F4A GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1F4B GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1F4C GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1F4D GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1F50 GREEK SMALL LETTER UPSILON WITH PSILI
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F51 GREEK SMALL LETTER UPSILON WITH DASIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F52 GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F53 GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F54 GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F55 GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F56 GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F57 GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F59 GREEK CAPITAL LETTER UPSILON WITH DASIA
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1F5B GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1F5D GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1F5F GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1F60 GREEK SMALL LETTER OMEGA WITH PSILI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F61 GREEK SMALL LETTER OMEGA WITH DASIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F62 GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F63 GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F64 GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F65 GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F66 GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F67 GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F68 GREEK CAPITAL LETTER OMEGA WITH PSILI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F69 GREEK CAPITAL LETTER OMEGA WITH DASIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F6A GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F6B GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F6C GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F6D GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F6E GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F6F GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F70 GREEK SMALL LETTER ALPHA WITH VARIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F71 GREEK SMALL LETTER ALPHA WITH OXIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F72 GREEK SMALL LETTER EPSILON WITH VARIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F73 GREEK SMALL LETTER EPSILON WITH OXIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F74 GREEK SMALL LETTER ETA WITH VARIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F75 GREEK SMALL LETTER ETA WITH OXIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F76 GREEK SMALL LETTER IOTA WITH VARIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F77 GREEK SMALL LETTER IOTA WITH OXIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F78 GREEK SMALL LETTER OMICRON WITH VARIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F79 GREEK SMALL LETTER OMICRON WITH OXIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F7A GREEK SMALL LETTER UPSILON WITH VARIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F7B GREEK SMALL LETTER UPSILON WITH OXIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F7C GREEK SMALL LETTER OMEGA WITH VARIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F7D GREEK SMALL LETTER OMEGA WITH OXIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F80 GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F81 GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F82 GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F83 GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F84 GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F85 GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F86 GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F87 GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F88 GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F89 GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F8A GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F8B GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F8C GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F8D GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F8E GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F8F GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F90 GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F91 GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F92 GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F93 GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F94 GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F95 GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F96 GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F97 GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F98 GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F99 GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F9A GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F9B GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F9C GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F9D GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F9E GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F9F GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1FA0 GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA1 GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA2 GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA3 GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA4 GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA5 GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA6 GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA7 GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA8 GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FA9 GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FAA GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FAB GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FAC GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FAD GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FAE GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FAF GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FB0 GREEK SMALL LETTER ALPHA WITH VRACHY
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB1 GREEK SMALL LETTER ALPHA WITH MACRON
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB2 GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB3 GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB4 GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB6 GREEK SMALL LETTER ALPHA WITH PERISPOMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB7 GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB8 GREEK CAPITAL LETTER ALPHA WITH VRACHY
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1FB9 GREEK CAPITAL LETTER ALPHA WITH MACRON
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1FBA GREEK CAPITAL LETTER ALPHA WITH VARIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1FBB GREEK CAPITAL LETTER ALPHA WITH OXIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1FBC GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1FBD GREEK KORONIS
 * 	0020 SPACE
 * 1FBE GREEK PROSGEGRAMMENI
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FBF GREEK PSILI
 * 	0020 SPACE
 * 1FC0 GREEK PERISPOMENI
 * 	0020 SPACE
 * 1FC1 GREEK DIALYTIKA AND PERISPOMENI
 * 	0020 SPACE
 * 1FC2 GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1FC3 GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1FC4 GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1FC6 GREEK SMALL LETTER ETA WITH PERISPOMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1FC7 GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1FC8 GREEK CAPITAL LETTER EPSILON WITH VARIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1FC9 GREEK CAPITAL LETTER EPSILON WITH OXIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1FCA GREEK CAPITAL LETTER ETA WITH VARIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1FCB GREEK CAPITAL LETTER ETA WITH OXIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1FCC GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1FCD GREEK PSILI AND VARIA
 * 	0020 SPACE
 * 1FCE GREEK PSILI AND OXIA
 * 	0020 SPACE
 * 1FCF GREEK PSILI AND PERISPOMENI
 * 	0020 SPACE
 * 1FD0 GREEK SMALL LETTER IOTA WITH VRACHY
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FD1 GREEK SMALL LETTER IOTA WITH MACRON
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FD2 GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FD3 GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FD6 GREEK SMALL LETTER IOTA WITH PERISPOMENI
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FD7 GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FD8 GREEK CAPITAL LETTER IOTA WITH VRACHY
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1FD9 GREEK CAPITAL LETTER IOTA WITH MACRON
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1FDA GREEK CAPITAL LETTER IOTA WITH VARIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1FDB GREEK CAPITAL LETTER IOTA WITH OXIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1FDD GREEK DASIA AND VARIA
 * 	0020 SPACE
 * 1FDE GREEK DASIA AND OXIA
 * 	0020 SPACE
 * 1FDF GREEK DASIA AND PERISPOMENI
 * 	0020 SPACE
 * 1FE0 GREEK SMALL LETTER UPSILON WITH VRACHY
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1FE1 GREEK SMALL LETTER UPSILON WITH MACRON
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1FE2 GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1FE3 GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1FE4 GREEK SMALL LETTER RHO WITH PSILI
 * 	03C1 GREEK SMALL LETTER RHO
 * 1FE5 GREEK SMALL LETTER RHO WITH DASIA
 * 	03C1 GREEK SMALL LETTER RHO
 * 1FE6 GREEK SMALL LETTER UPSILON WITH PERISPOMENI
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1FE7 GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1FE8 GREEK CAPITAL LETTER UPSILON WITH VRACHY
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1FE9 GREEK CAPITAL LETTER UPSILON WITH MACRON
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1FEA GREEK CAPITAL LETTER UPSILON WITH VARIA
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1FEB GREEK CAPITAL LETTER UPSILON WITH OXIA
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1FEC GREEK CAPITAL LETTER RHO WITH DASIA
 * 	03A1 GREEK CAPITAL LETTER RHO
 * 1FED GREEK DIALYTIKA AND VARIA
 * 	0020 SPACE
 * 1FEE GREEK DIALYTIKA AND OXIA
 * 	0020 SPACE
 * 1FEF GREEK VARIA
 * 	0060 GRAVE ACCENT
 * 1FF2 GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FF3 GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FF4 GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FF6 GREEK SMALL LETTER OMEGA WITH PERISPOMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FF7 GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FF8 GREEK CAPITAL LETTER OMICRON WITH VARIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1FF9 GREEK CAPITAL LETTER OMICRON WITH OXIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1FFA GREEK CAPITAL LETTER OMEGA WITH VARIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FFB GREEK CAPITAL LETTER OMEGA WITH OXIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FFC GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FFD GREEK OXIA
 * 	0020 SPACE
 * 1FFE GREEK DASIA
 * 	0020 SPACE
 * 2000 EN QUAD
 * 	0020 SPACE
 * 2001 EM QUAD
 * 	0020 SPACE
 * 2002 EN SPACE
 * 	0020 SPACE
 * 2003 EM SPACE
 * 	0020 SPACE
 * 2004 THREE-PER-EM SPACE
 * 	0020 SPACE
 * 2005 FOUR-PER-EM SPACE
 * 	0020 SPACE
 * 2006 SIX-PER-EM SPACE
 * 	0020 SPACE
 * 2007 FIGURE SPACE
 * 	0020 SPACE
 * 2008 PUNCTUATION SPACE
 * 	0020 SPACE
 * 2009 THIN SPACE
 * 	0020 SPACE
 * 200A HAIR SPACE
 * 	0020 SPACE
 * 2011 NON-BREAKING HYPHEN
 * 	2010 HYPHEN
 * 2017 DOUBLE LOW LINE
 * 	0020 SPACE
 * 2024 ONE DOT LEADER
 * 	002E FULL STOP
 * 2025 TWO DOT LEADER
 * 	002E FULL STOP
 * 	002E FULL STOP
 * 2026 HORIZONTAL ELLIPSIS
 * 	002E FULL STOP
 * 	002E FULL STOP
 * 	002E FULL STOP
 * 202F NARROW NO-BREAK SPACE
 * 	0020 SPACE
 * 2033 DOUBLE PRIME
 * 	2032 PRIME
 * 	2032 PRIME
 * 2034 TRIPLE PRIME
 * 	2032 PRIME
 * 	2032 PRIME
 * 	2032 PRIME
 * 2036 REVERSED DOUBLE PRIME
 * 	2035 REVERSED PRIME
 * 	2035 REVERSED PRIME
 * 2037 REVERSED TRIPLE PRIME
 * 	2035 REVERSED PRIME
 * 	2035 REVERSED PRIME
 * 	2035 REVERSED PRIME
 * 203C DOUBLE EXCLAMATION MARK
 * 	0021 EXCLAMATION MARK
 * 	0021 EXCLAMATION MARK
 * 203E OVERLINE
 * 	0020 SPACE
 * 2047 DOUBLE QUESTION MARK
 * 	003F QUESTION MARK
 * 	003F QUESTION MARK
 * 2048 QUESTION EXCLAMATION MARK
 * 	003F QUESTION MARK
 * 	0021 EXCLAMATION MARK
 * 2049 EXCLAMATION QUESTION MARK
 * 	0021 EXCLAMATION MARK
 * 	003F QUESTION MARK
 * 2057 QUADRUPLE PRIME
 * 	2032 PRIME
 * 	2032 PRIME
 * 	2032 PRIME
 * 	2032 PRIME
 * 205F MEDIUM MATHEMATICAL SPACE
 * 	0020 SPACE
 * 2070 SUPERSCRIPT ZERO
 * 	0030 DIGIT ZERO
 * 2071 SUPERSCRIPT LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 2074 SUPERSCRIPT FOUR
 * 	0034 DIGIT FOUR
 * 2075 SUPERSCRIPT FIVE
 * 	0035 DIGIT FIVE
 * 2076 SUPERSCRIPT SIX
 * 	0036 DIGIT SIX
 * 2077 SUPERSCRIPT SEVEN
 * 	0037 DIGIT SEVEN
 * 2078 SUPERSCRIPT EIGHT
 * 	0038 DIGIT EIGHT
 * 2079 SUPERSCRIPT NINE
 * 	0039 DIGIT NINE
 * 207A SUPERSCRIPT PLUS SIGN
 * 	002B PLUS SIGN
 * 207B SUPERSCRIPT MINUS
 * 	2212 MINUS SIGN
 * 207C SUPERSCRIPT EQUALS SIGN
 * 	003D EQUALS SIGN
 * 207D SUPERSCRIPT LEFT PARENTHESIS
 * 	0028 LEFT PARENTHESIS
 * 207E SUPERSCRIPT RIGHT PARENTHESIS
 * 	0029 RIGHT PARENTHESIS
 * 207F SUPERSCRIPT LATIN SMALL LETTER N
 * 	006E LATIN SMALL LETTER N
 * 2080 SUBSCRIPT ZERO
 * 	0030 DIGIT ZERO
 * 2081 SUBSCRIPT ONE
 * 	0031 DIGIT ONE
 * 2082 SUBSCRIPT TWO
 * 	0032 DIGIT TWO
 * 2083 SUBSCRIPT THREE
 * 	0033 DIGIT THREE
 * 2084 SUBSCRIPT FOUR
 * 	0034 DIGIT FOUR
 * 2085 SUBSCRIPT FIVE
 * 	0035 DIGIT FIVE
 * 2086 SUBSCRIPT SIX
 * 	0036 DIGIT SIX
 * 2087 SUBSCRIPT SEVEN
 * 	0037 DIGIT SEVEN
 * 2088 SUBSCRIPT EIGHT
 * 	0038 DIGIT EIGHT
 * 2089 SUBSCRIPT NINE
 * 	0039 DIGIT NINE
 * 208A SUBSCRIPT PLUS SIGN
 * 	002B PLUS SIGN
 * 208B SUBSCRIPT MINUS
 * 	2212 MINUS SIGN
 * 208C SUBSCRIPT EQUALS SIGN
 * 	003D EQUALS SIGN
 * 208D SUBSCRIPT LEFT PARENTHESIS
 * 	0028 LEFT PARENTHESIS
 * 208E SUBSCRIPT RIGHT PARENTHESIS
 * 	0029 RIGHT PARENTHESIS
 * 2090 LATIN SUBSCRIPT SMALL LETTER A
 * 	0061 LATIN SMALL LETTER A
 * 2091 LATIN SUBSCRIPT SMALL LETTER E
 * 	0065 LATIN SMALL LETTER E
 * 2092 LATIN SUBSCRIPT SMALL LETTER O
 * 	006F LATIN SMALL LETTER O
 * 2093 LATIN SUBSCRIPT SMALL LETTER X
 * 	0078 LATIN SMALL LETTER X
 * 2094 LATIN SUBSCRIPT SMALL LETTER SCHWA
 * 	0259 LATIN SMALL LETTER SCHWA
 * 20A8 RUPEE SIGN
 * 	0052 LATIN CAPITAL LETTER R
 * 	0073 LATIN SMALL LETTER S
 * 20D0 COMBINING LEFT HARPOON ABOVE
 * 	0000 <control>
 * 20D1 COMBINING RIGHT HARPOON ABOVE
 * 	0000 <control>
 * 20D2 COMBINING LONG VERTICAL LINE OVERLAY
 * 	0000 <control>
 * 20D3 COMBINING SHORT VERTICAL LINE OVERLAY
 * 	0000 <control>
 * 20D4 COMBINING ANTICLOCKWISE ARROW ABOVE
 * 	0000 <control>
 * 20D5 COMBINING CLOCKWISE ARROW ABOVE
 * 	0000 <control>
 * 20D6 COMBINING LEFT ARROW ABOVE
 * 	0000 <control>
 * 20D7 COMBINING RIGHT ARROW ABOVE
 * 	0000 <control>
 * 20D8 COMBINING RING OVERLAY
 * 	0000 <control>
 * 20D9 COMBINING CLOCKWISE RING OVERLAY
 * 	0000 <control>
 * 20DA COMBINING ANTICLOCKWISE RING OVERLAY
 * 	0000 <control>
 * 20DB COMBINING THREE DOTS ABOVE
 * 	0000 <control>
 * 20DC COMBINING FOUR DOTS ABOVE
 * 	0000 <control>
 * 20DD COMBINING ENCLOSING CIRCLE
 * 	0000 <control>
 * 20DE COMBINING ENCLOSING SQUARE
 * 	0000 <control>
 * 20DF COMBINING ENCLOSING DIAMOND
 * 	0000 <control>
 * 20E0 COMBINING ENCLOSING CIRCLE BACKSLASH
 * 	0000 <control>
 * 20E1 COMBINING LEFT RIGHT ARROW ABOVE
 * 	0000 <control>
 * 20E2 COMBINING ENCLOSING SCREEN
 * 	0000 <control>
 * 20E3 COMBINING ENCLOSING KEYCAP
 * 	0000 <control>
 * 20E4 COMBINING ENCLOSING UPWARD POINTING TRIANGLE
 * 	0000 <control>
 * 20E5 COMBINING REVERSE SOLIDUS OVERLAY
 * 	0000 <control>
 * 20E6 COMBINING DOUBLE VERTICAL STROKE OVERLAY
 * 	0000 <control>
 * 20E7 COMBINING ANNUITY SYMBOL
 * 	0000 <control>
 * 20E8 COMBINING TRIPLE UNDERDOT
 * 	0000 <control>
 * 20E9 COMBINING WIDE BRIDGE ABOVE
 * 	0000 <control>
 * 20EA COMBINING LEFTWARDS ARROW OVERLAY
 * 	0000 <control>
 * 20EB COMBINING LONG DOUBLE SOLIDUS OVERLAY
 * 	0000 <control>
 * 20EC COMBINING RIGHTWARDS HARPOON WITH BARB DOWNWARDS
 * 	0000 <control>
 * 20ED COMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDS
 * 	0000 <control>
 * 20EE COMBINING LEFT ARROW BELOW
 * 	0000 <control>
 * 20EF COMBINING RIGHT ARROW BELOW
 * 	0000 <control>
 * 20F0 COMBINING ASTERISK ABOVE
 * 	0000 <control>
 * 2100 ACCOUNT OF
 * 	0061 LATIN SMALL LETTER A
 * 	002F SOLIDUS
 * 	0063 LATIN SMALL LETTER C
 * 2101 ADDRESSED TO THE SUBJECT
 * 	0061 LATIN SMALL LETTER A
 * 	002F SOLIDUS
 * 	0073 LATIN SMALL LETTER S
 * 2102 DOUBLE-STRUCK CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 2103 DEGREE CELSIUS
 * 	00B0 DEGREE SIGN
 * 	0043 LATIN CAPITAL LETTER C
 * 2105 CARE OF
 * 	0063 LATIN SMALL LETTER C
 * 	002F SOLIDUS
 * 	006F LATIN SMALL LETTER O
 * 2106 CADA UNA
 * 	0063 LATIN SMALL LETTER C
 * 	002F SOLIDUS
 * 	0075 LATIN SMALL LETTER U
 * 2107 EULER CONSTANT
 * 	0190 LATIN CAPITAL LETTER OPEN E
 * 2109 DEGREE FAHRENHEIT
 * 	00B0 DEGREE SIGN
 * 	0046 LATIN CAPITAL LETTER F
 * 210A SCRIPT SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 210B SCRIPT CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 210C BLACK-LETTER CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 210D DOUBLE-STRUCK CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 210E PLANCK CONSTANT
 * 	0068 LATIN SMALL LETTER H
 * 210F PLANCK CONSTANT OVER TWO PI
 * 	0127 LATIN SMALL LETTER H WITH STROKE
 * 2110 SCRIPT CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 2111 BLACK-LETTER CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 2112 SCRIPT CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 2113 SCRIPT SMALL L
 * 	006C LATIN SMALL LETTER L
 * 2115 DOUBLE-STRUCK CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 2116 NUMERO SIGN
 * 	004E LATIN CAPITAL LETTER N
 * 	006F LATIN SMALL LETTER O
 * 2119 DOUBLE-STRUCK CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 211A DOUBLE-STRUCK CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 211B SCRIPT CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 211C BLACK-LETTER CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 211D DOUBLE-STRUCK CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 2120 SERVICE MARK
 * 	0053 LATIN CAPITAL LETTER S
 * 	004D LATIN CAPITAL LETTER M
 * 2121 TELEPHONE SIGN
 * 	0054 LATIN CAPITAL LETTER T
 * 	0045 LATIN CAPITAL LETTER E
 * 	004C LATIN CAPITAL LETTER L
 * 2122 TRADE MARK SIGN
 * 	0054 LATIN CAPITAL LETTER T
 * 	004D LATIN CAPITAL LETTER M
 * 2124 DOUBLE-STRUCK CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 2126 OHM SIGN
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 2128 BLACK-LETTER CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 212A KELVIN SIGN
 * 	004B LATIN CAPITAL LETTER K
 * 212B ANGSTROM SIGN
 * 	0041 LATIN CAPITAL LETTER A
 * 212C SCRIPT CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 212D BLACK-LETTER CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 212F SCRIPT SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 2130 SCRIPT CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 2131 SCRIPT CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 2133 SCRIPT CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 2134 SCRIPT SMALL O
 * 	006F LATIN SMALL LETTER O
 * 2135 ALEF SYMBOL
 * 	05D0 HEBREW LETTER ALEF
 * 2136 BET SYMBOL
 * 	05D1 HEBREW LETTER BET
 * 2137 GIMEL SYMBOL
 * 	05D2 HEBREW LETTER GIMEL
 * 2138 DALET SYMBOL
 * 	05D3 HEBREW LETTER DALET
 * 2139 INFORMATION SOURCE
 * 	0069 LATIN SMALL LETTER I
 * 213B FACSIMILE SIGN
 * 	0046 LATIN CAPITAL LETTER F
 * 	0041 LATIN CAPITAL LETTER A
 * 	0058 LATIN CAPITAL LETTER X
 * 213C DOUBLE-STRUCK SMALL PI
 * 	03C0 GREEK SMALL LETTER PI
 * 213D DOUBLE-STRUCK SMALL GAMMA
 * 	03B3 GREEK SMALL LETTER GAMMA
 * 213E DOUBLE-STRUCK CAPITAL GAMMA
 * 	0393 GREEK CAPITAL LETTER GAMMA
 * 213F DOUBLE-STRUCK CAPITAL PI
 * 	03A0 GREEK CAPITAL LETTER PI
 * 2140 DOUBLE-STRUCK N-ARY SUMMATION
 * 	2211 N-ARY SUMMATION
 * 2145 DOUBLE-STRUCK ITALIC CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 2146 DOUBLE-STRUCK ITALIC SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 2147 DOUBLE-STRUCK ITALIC SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 2148 DOUBLE-STRUCK ITALIC SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 2149 DOUBLE-STRUCK ITALIC SMALL J
 * 	006A LATIN SMALL LETTER J
 * 2153 VULGAR FRACTION ONE THIRD
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 	0033 DIGIT THREE
 * 2154 VULGAR FRACTION TWO THIRDS
 * 	0032 DIGIT TWO
 * 	2044 FRACTION SLASH
 * 	0033 DIGIT THREE
 * 2155 VULGAR FRACTION ONE FIFTH
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 	0035 DIGIT FIVE
 * 2156 VULGAR FRACTION TWO FIFTHS
 * 	0032 DIGIT TWO
 * 	2044 FRACTION SLASH
 * 	0035 DIGIT FIVE
 * 2157 VULGAR FRACTION THREE FIFTHS
 * 	0033 DIGIT THREE
 * 	2044 FRACTION SLASH
 * 	0035 DIGIT FIVE
 * 2158 VULGAR FRACTION FOUR FIFTHS
 * 	0034 DIGIT FOUR
 * 	2044 FRACTION SLASH
 * 	0035 DIGIT FIVE
 * 2159 VULGAR FRACTION ONE SIXTH
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 	0036 DIGIT SIX
 * 215A VULGAR FRACTION FIVE SIXTHS
 * 	0035 DIGIT FIVE
 * 	2044 FRACTION SLASH
 * 	0036 DIGIT SIX
 * 215B VULGAR FRACTION ONE EIGHTH
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 	0038 DIGIT EIGHT
 * 215C VULGAR FRACTION THREE EIGHTHS
 * 	0033 DIGIT THREE
 * 	2044 FRACTION SLASH
 * 	0038 DIGIT EIGHT
 * 215D VULGAR FRACTION FIVE EIGHTHS
 * 	0035 DIGIT FIVE
 * 	2044 FRACTION SLASH
 * 	0038 DIGIT EIGHT
 * 215E VULGAR FRACTION SEVEN EIGHTHS
 * 	0037 DIGIT SEVEN
 * 	2044 FRACTION SLASH
 * 	0038 DIGIT EIGHT
 * 215F FRACTION NUMERATOR ONE
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 2160 ROMAN NUMERAL ONE
 * 	0049 LATIN CAPITAL LETTER I
 * 2161 ROMAN NUMERAL TWO
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 2162 ROMAN NUMERAL THREE
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 2163 ROMAN NUMERAL FOUR
 * 	0049 LATIN CAPITAL LETTER I
 * 	0056 LATIN CAPITAL LETTER V
 * 2164 ROMAN NUMERAL FIVE
 * 	0056 LATIN CAPITAL LETTER V
 * 2165 ROMAN NUMERAL SIX
 * 	0056 LATIN CAPITAL LETTER V
 * 	0049 LATIN CAPITAL LETTER I
 * 2166 ROMAN NUMERAL SEVEN
 * 	0056 LATIN CAPITAL LETTER V
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 2167 ROMAN NUMERAL EIGHT
 * 	0056 LATIN CAPITAL LETTER V
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 2168 ROMAN NUMERAL NINE
 * 	0049 LATIN CAPITAL LETTER I
 * 	0058 LATIN CAPITAL LETTER X
 * 2169 ROMAN NUMERAL TEN
 * 	0058 LATIN CAPITAL LETTER X
 * 216A ROMAN NUMERAL ELEVEN
 * 	0058 LATIN CAPITAL LETTER X
 * 	0049 LATIN CAPITAL LETTER I
 * 216B ROMAN NUMERAL TWELVE
 * 	0058 LATIN CAPITAL LETTER X
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 216C ROMAN NUMERAL FIFTY
 * 	004C LATIN CAPITAL LETTER L
 * 216D ROMAN NUMERAL ONE HUNDRED
 * 	0043 LATIN CAPITAL LETTER C
 * 216E ROMAN NUMERAL FIVE HUNDRED
 * 	0044 LATIN CAPITAL LETTER D
 * 216F ROMAN NUMERAL ONE THOUSAND
 * 	004D LATIN CAPITAL LETTER M
 * 2170 SMALL ROMAN NUMERAL ONE
 * 	0069 LATIN SMALL LETTER I
 * 2171 SMALL ROMAN NUMERAL TWO
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 2172 SMALL ROMAN NUMERAL THREE
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 2173 SMALL ROMAN NUMERAL FOUR
 * 	0069 LATIN SMALL LETTER I
 * 	0076 LATIN SMALL LETTER V
 * 2174 SMALL ROMAN NUMERAL FIVE
 * 	0076 LATIN SMALL LETTER V
 * 2175 SMALL ROMAN NUMERAL SIX
 * 	0076 LATIN SMALL LETTER V
 * 	0069 LATIN SMALL LETTER I
 * 2176 SMALL ROMAN NUMERAL SEVEN
 * 	0076 LATIN SMALL LETTER V
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 2177 SMALL ROMAN NUMERAL EIGHT
 * 	0076 LATIN SMALL LETTER V
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 2178 SMALL ROMAN NUMERAL NINE
 * 	0069 LATIN SMALL LETTER I
 * 	0078 LATIN SMALL LETTER X
 * 2179 SMALL ROMAN NUMERAL TEN
 * 	0078 LATIN SMALL LETTER X
 * 217A SMALL ROMAN NUMERAL ELEVEN
 * 	0078 LATIN SMALL LETTER X
 * 	0069 LATIN SMALL LETTER I
 * 217B SMALL ROMAN NUMERAL TWELVE
 * 	0078 LATIN SMALL LETTER X
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 217C SMALL ROMAN NUMERAL FIFTY
 * 	006C LATIN SMALL LETTER L
 * 217D SMALL ROMAN NUMERAL ONE HUNDRED
 * 	0063 LATIN SMALL LETTER C
 * 217E SMALL ROMAN NUMERAL FIVE HUNDRED
 * 	0064 LATIN SMALL LETTER D
 * 217F SMALL ROMAN NUMERAL ONE THOUSAND
 * 	006D LATIN SMALL LETTER M
 * 219A LEFTWARDS ARROW WITH STROKE
 * 	2190 LEFTWARDS ARROW
 * 219B RIGHTWARDS ARROW WITH STROKE
 * 	2192 RIGHTWARDS ARROW
 * 21AE LEFT RIGHT ARROW WITH STROKE
 * 	2194 LEFT RIGHT ARROW
 * 21CD LEFTWARDS DOUBLE ARROW WITH STROKE
 * 	21D0 LEFTWARDS DOUBLE ARROW
 * 21CE LEFT RIGHT DOUBLE ARROW WITH STROKE
 * 	21D4 LEFT RIGHT DOUBLE ARROW
 * 21CF RIGHTWARDS DOUBLE ARROW WITH STROKE
 * 	21D2 RIGHTWARDS DOUBLE ARROW
 * 2204 THERE DOES NOT EXIST
 * 	2203 THERE EXISTS
 * 2209 NOT AN ELEMENT OF
 * 	2208 ELEMENT OF
 * 220C DOES NOT CONTAIN AS MEMBER
 * 	220B CONTAINS AS MEMBER
 * 2224 DOES NOT DIVIDE
 * 	2223 DIVIDES
 * 2226 NOT PARALLEL TO
 * 	2225 PARALLEL TO
 * 222C DOUBLE INTEGRAL
 * 	222B INTEGRAL
 * 	222B INTEGRAL
 * 222D TRIPLE INTEGRAL
 * 	222B INTEGRAL
 * 	222B INTEGRAL
 * 	222B INTEGRAL
 * 222F SURFACE INTEGRAL
 * 	222E CONTOUR INTEGRAL
 * 	222E CONTOUR INTEGRAL
 * 2230 VOLUME INTEGRAL
 * 	222E CONTOUR INTEGRAL
 * 	222E CONTOUR INTEGRAL
 * 	222E CONTOUR INTEGRAL
 * 2241 NOT TILDE
 * 	223C TILDE OPERATOR
 * 2244 NOT ASYMPTOTICALLY EQUAL TO
 * 	2243 ASYMPTOTICALLY EQUAL TO
 * 2247 NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
 * 	2245 APPROXIMATELY EQUAL TO
 * 2249 NOT ALMOST EQUAL TO
 * 	2248 ALMOST EQUAL TO
 * 2260 NOT EQUAL TO
 * 	003D EQUALS SIGN
 * 2262 NOT IDENTICAL TO
 * 	2261 IDENTICAL TO
 * 226D NOT EQUIVALENT TO
 * 	224D EQUIVALENT TO
 * 226E NOT LESS-THAN
 * 	003C LESS-THAN SIGN
 * 226F NOT GREATER-THAN
 * 	003E GREATER-THAN SIGN
 * 2270 NEITHER LESS-THAN NOR EQUAL TO
 * 	2264 LESS-THAN OR EQUAL TO
 * 2271 NEITHER GREATER-THAN NOR EQUAL TO
 * 	2265 GREATER-THAN OR EQUAL TO
 * 2274 NEITHER LESS-THAN NOR EQUIVALENT TO
 * 	2272 LESS-THAN OR EQUIVALENT TO
 * 2275 NEITHER GREATER-THAN NOR EQUIVALENT TO
 * 	2273 GREATER-THAN OR EQUIVALENT TO
 * 2278 NEITHER LESS-THAN NOR GREATER-THAN
 * 	2276 LESS-THAN OR GREATER-THAN
 * 2279 NEITHER GREATER-THAN NOR LESS-THAN
 * 	2277 GREATER-THAN OR LESS-THAN
 * 2280 DOES NOT PRECEDE
 * 	227A PRECEDES
 * 2281 DOES NOT SUCCEED
 * 	227B SUCCEEDS
 * 2284 NOT A SUBSET OF
 * 	2282 SUBSET OF
 * 2285 NOT A SUPERSET OF
 * 	2283 SUPERSET OF
 * 2288 NEITHER A SUBSET OF NOR EQUAL TO
 * 	2286 SUBSET OF OR EQUAL TO
 * 2289 NEITHER A SUPERSET OF NOR EQUAL TO
 * 	2287 SUPERSET OF OR EQUAL TO
 * 22AC DOES NOT PROVE
 * 	22A2 RIGHT TACK
 * 22AD NOT TRUE
 * 	22A8 TRUE
 * 22AE DOES NOT FORCE
 * 	22A9 FORCES
 * 22AF NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
 * 	22AB DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
 * 22E0 DOES NOT PRECEDE OR EQUAL
 * 	227C PRECEDES OR EQUAL TO
 * 22E1 DOES NOT SUCCEED OR EQUAL
 * 	227D SUCCEEDS OR EQUAL TO
 * 22E2 NOT SQUARE IMAGE OF OR EQUAL TO
 * 	2291 SQUARE IMAGE OF OR EQUAL TO
 * 22E3 NOT SQUARE ORIGINAL OF OR EQUAL TO
 * 	2292 SQUARE ORIGINAL OF OR EQUAL TO
 * 22EA NOT NORMAL SUBGROUP OF
 * 	22B2 NORMAL SUBGROUP OF
 * 22EB DOES NOT CONTAIN AS NORMAL SUBGROUP
 * 	22B3 CONTAINS AS NORMAL SUBGROUP
 * 22EC NOT NORMAL SUBGROUP OF OR EQUAL TO
 * 	22B4 NORMAL SUBGROUP OF OR EQUAL TO
 * 22ED DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL
 * 	22B5 CONTAINS AS NORMAL SUBGROUP OR EQUAL TO
 * 2329 LEFT-POINTING ANGLE BRACKET
 * 	3008 LEFT ANGLE BRACKET
 * 232A RIGHT-POINTING ANGLE BRACKET
 * 	3009 RIGHT ANGLE BRACKET
 * 2460 CIRCLED DIGIT ONE
 * 	0031 DIGIT ONE
 * 2461 CIRCLED DIGIT TWO
 * 	0032 DIGIT TWO
 * 2462 CIRCLED DIGIT THREE
 * 	0033 DIGIT THREE
 * 2463 CIRCLED DIGIT FOUR
 * 	0034 DIGIT FOUR
 * 2464 CIRCLED DIGIT FIVE
 * 	0035 DIGIT FIVE
 * 2465 CIRCLED DIGIT SIX
 * 	0036 DIGIT SIX
 * 2466 CIRCLED DIGIT SEVEN
 * 	0037 DIGIT SEVEN
 * 2467 CIRCLED DIGIT EIGHT
 * 	0038 DIGIT EIGHT
 * 2468 CIRCLED DIGIT NINE
 * 	0039 DIGIT NINE
 * 2469 CIRCLED NUMBER TEN
 * 	0031 DIGIT ONE
 * 	0030 DIGIT ZERO
 * 246A CIRCLED NUMBER ELEVEN
 * 	0031 DIGIT ONE
 * 	0031 DIGIT ONE
 * 246B CIRCLED NUMBER TWELVE
 * 	0031 DIGIT ONE
 * 	0032 DIGIT TWO
 * 246C CIRCLED NUMBER THIRTEEN
 * 	0031 DIGIT ONE
 * 	0033 DIGIT THREE
 * 246D CIRCLED NUMBER FOURTEEN
 * 	0031 DIGIT ONE
 * 	0034 DIGIT FOUR
 * 246E CIRCLED NUMBER FIFTEEN
 * 	0031 DIGIT ONE
 * 	0035 DIGIT FIVE
 * 246F CIRCLED NUMBER SIXTEEN
 * 	0031 DIGIT ONE
 * 	0036 DIGIT SIX
 * 2470 CIRCLED NUMBER SEVENTEEN
 * 	0031 DIGIT ONE
 * 	0037 DIGIT SEVEN
 * 2471 CIRCLED NUMBER EIGHTEEN
 * 	0031 DIGIT ONE
 * 	0038 DIGIT EIGHT
 * 2472 CIRCLED NUMBER NINETEEN
 * 	0031 DIGIT ONE
 * 	0039 DIGIT NINE
 * 2473 CIRCLED NUMBER TWENTY
 * 	0032 DIGIT TWO
 * 	0030 DIGIT ZERO
 * 2474 PARENTHESIZED DIGIT ONE
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0029 RIGHT PARENTHESIS
 * 2475 PARENTHESIZED DIGIT TWO
 * 	0028 LEFT PARENTHESIS
 * 	0032 DIGIT TWO
 * 	0029 RIGHT PARENTHESIS
 * 2476 PARENTHESIZED DIGIT THREE
 * 	0028 LEFT PARENTHESIS
 * 	0033 DIGIT THREE
 * 	0029 RIGHT PARENTHESIS
 * 2477 PARENTHESIZED DIGIT FOUR
 * 	0028 LEFT PARENTHESIS
 * 	0034 DIGIT FOUR
 * 	0029 RIGHT PARENTHESIS
 * 2478 PARENTHESIZED DIGIT FIVE
 * 	0028 LEFT PARENTHESIS
 * 	0035 DIGIT FIVE
 * 	0029 RIGHT PARENTHESIS
 * 2479 PARENTHESIZED DIGIT SIX
 * 	0028 LEFT PARENTHESIS
 * 	0036 DIGIT SIX
 * 	0029 RIGHT PARENTHESIS
 * 247A PARENTHESIZED DIGIT SEVEN
 * 	0028 LEFT PARENTHESIS
 * 	0037 DIGIT SEVEN
 * 	0029 RIGHT PARENTHESIS
 * 247B PARENTHESIZED DIGIT EIGHT
 * 	0028 LEFT PARENTHESIS
 * 	0038 DIGIT EIGHT
 * 	0029 RIGHT PARENTHESIS
 * 247C PARENTHESIZED DIGIT NINE
 * 	0028 LEFT PARENTHESIS
 * 	0039 DIGIT NINE
 * 	0029 RIGHT PARENTHESIS
 * 247D PARENTHESIZED NUMBER TEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0030 DIGIT ZERO
 * 	0029 RIGHT PARENTHESIS
 * 247E PARENTHESIZED NUMBER ELEVEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0031 DIGIT ONE
 * 	0029 RIGHT PARENTHESIS
 * 247F PARENTHESIZED NUMBER TWELVE
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0032 DIGIT TWO
 * 	0029 RIGHT PARENTHESIS
 * 2480 PARENTHESIZED NUMBER THIRTEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0033 DIGIT THREE
 * 	0029 RIGHT PARENTHESIS
 * 2481 PARENTHESIZED NUMBER FOURTEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0034 DIGIT FOUR
 * 	0029 RIGHT PARENTHESIS
 * 2482 PARENTHESIZED NUMBER FIFTEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0035 DIGIT FIVE
 * 	0029 RIGHT PARENTHESIS
 * 2483 PARENTHESIZED NUMBER SIXTEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0036 DIGIT SIX
 * 	0029 RIGHT PARENTHESIS
 * 2484 PARENTHESIZED NUMBER SEVENTEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0037 DIGIT SEVEN
 * 	0029 RIGHT PARENTHESIS
 * 2485 PARENTHESIZED NUMBER EIGHTEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0038 DIGIT EIGHT
 * 	0029 RIGHT PARENTHESIS
 * 2486 PARENTHESIZED NUMBER NINETEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0039 DIGIT NINE
 * 	0029 RIGHT PARENTHESIS
 * 2487 PARENTHESIZED NUMBER TWENTY
 * 	0028 LEFT PARENTHESIS
 * 	0032 DIGIT TWO
 * 	0030 DIGIT ZERO
 * 	0029 RIGHT PARENTHESIS
 * 2488 DIGIT ONE FULL STOP
 * 	0031 DIGIT ONE
 * 	002E FULL STOP
 * 2489 DIGIT TWO FULL STOP
 * 	0032 DIGIT TWO
 * 	002E FULL STOP
 * 248A DIGIT THREE FULL STOP
 * 	0033 DIGIT THREE
 * 	002E FULL STOP
 * 248B DIGIT FOUR FULL STOP
 * 	0034 DIGIT FOUR
 * 	002E FULL STOP
 * 248C DIGIT FIVE FULL STOP
 * 	0035 DIGIT FIVE
 * 	002E FULL STOP
 * 248D DIGIT SIX FULL STOP
 * 	0036 DIGIT SIX
 * 	002E FULL STOP
 * 248E DIGIT SEVEN FULL STOP
 * 	0037 DIGIT SEVEN
 * 	002E FULL STOP
 * 248F DIGIT EIGHT FULL STOP
 * 	0038 DIGIT EIGHT
 * 	002E FULL STOP
 * 2490 DIGIT NINE FULL STOP
 * 	0039 DIGIT NINE
 * 	002E FULL STOP
 * 2491 NUMBER TEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0030 DIGIT ZERO
 * 	002E FULL STOP
 * 2492 NUMBER ELEVEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0031 DIGIT ONE
 * 	002E FULL STOP
 * 2493 NUMBER TWELVE FULL STOP
 * 	0031 DIGIT ONE
 * 	0032 DIGIT TWO
 * 	002E FULL STOP
 * 2494 NUMBER THIRTEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0033 DIGIT THREE
 * 	002E FULL STOP
 * 2495 NUMBER FOURTEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0034 DIGIT FOUR
 * 	002E FULL STOP
 * 2496 NUMBER FIFTEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0035 DIGIT FIVE
 * 	002E FULL STOP
 * 2497 NUMBER SIXTEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0036 DIGIT SIX
 * 	002E FULL STOP
 * 2498 NUMBER SEVENTEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0037 DIGIT SEVEN
 * 	002E FULL STOP
 * 2499 NUMBER EIGHTEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0038 DIGIT EIGHT
 * 	002E FULL STOP
 * 249A NUMBER NINETEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0039 DIGIT NINE
 * 	002E FULL STOP
 * 249B NUMBER TWENTY FULL STOP
 * 	0032 DIGIT TWO
 * 	0030 DIGIT ZERO
 * 	002E FULL STOP
 * 249C PARENTHESIZED LATIN SMALL LETTER A
 * 	0028 LEFT PARENTHESIS
 * 	0061 LATIN SMALL LETTER A
 * 	0029 RIGHT PARENTHESIS
 * 249D PARENTHESIZED LATIN SMALL LETTER B
 * 	0028 LEFT PARENTHESIS
 * 	0062 LATIN SMALL LETTER B
 * 	0029 RIGHT PARENTHESIS
 * 249E PARENTHESIZED LATIN SMALL LETTER C
 * 	0028 LEFT PARENTHESIS
 * 	0063 LATIN SMALL LETTER C
 * 	0029 RIGHT PARENTHESIS
 * 249F PARENTHESIZED LATIN SMALL LETTER D
 * 	0028 LEFT PARENTHESIS
 * 	0064 LATIN SMALL LETTER D
 * 	0029 RIGHT PARENTHESIS
 * 24A0 PARENTHESIZED LATIN SMALL LETTER E
 * 	0028 LEFT PARENTHESIS
 * 	0065 LATIN SMALL LETTER E
 * 	0029 RIGHT PARENTHESIS
 * 24A1 PARENTHESIZED LATIN SMALL LETTER F
 * 	0028 LEFT PARENTHESIS
 * 	0066 LATIN SMALL LETTER F
 * 	0029 RIGHT PARENTHESIS
 * 24A2 PARENTHESIZED LATIN SMALL LETTER G
 * 	0028 LEFT PARENTHESIS
 * 	0067 LATIN SMALL LETTER G
 * 	0029 RIGHT PARENTHESIS
 * 24A3 PARENTHESIZED LATIN SMALL LETTER H
 * 	0028 LEFT PARENTHESIS
 * 	0068 LATIN SMALL LETTER H
 * 	0029 RIGHT PARENTHESIS
 * 24A4 PARENTHESIZED LATIN SMALL LETTER I
 * 	0028 LEFT PARENTHESIS
 * 	0069 LATIN SMALL LETTER I
 * 	0029 RIGHT PARENTHESIS
 * 24A5 PARENTHESIZED LATIN SMALL LETTER J
 * 	0028 LEFT PARENTHESIS
 * 	006A LATIN SMALL LETTER J
 * 	0029 RIGHT PARENTHESIS
 * 24A6 PARENTHESIZED LATIN SMALL LETTER K
 * 	0028 LEFT PARENTHESIS
 * 	006B LATIN SMALL LETTER K
 * 	0029 RIGHT PARENTHESIS
 * 24A7 PARENTHESIZED LATIN SMALL LETTER L
 * 	0028 LEFT PARENTHESIS
 * 	006C LATIN SMALL LETTER L
 * 	0029 RIGHT PARENTHESIS
 * 24A8 PARENTHESIZED LATIN SMALL LETTER M
 * 	0028 LEFT PARENTHESIS
 * 	006D LATIN SMALL LETTER M
 * 	0029 RIGHT PARENTHESIS
 * 24A9 PARENTHESIZED LATIN SMALL LETTER N
 * 	0028 LEFT PARENTHESIS
 * 	006E LATIN SMALL LETTER N
 * 	0029 RIGHT PARENTHESIS
 * 24AA PARENTHESIZED LATIN SMALL LETTER O
 * 	0028 LEFT PARENTHESIS
 * 	006F LATIN SMALL LETTER O
 * 	0029 RIGHT PARENTHESIS
 * 24AB PARENTHESIZED LATIN SMALL LETTER P
 * 	0028 LEFT PARENTHESIS
 * 	0070 LATIN SMALL LETTER P
 * 	0029 RIGHT PARENTHESIS
 * 24AC PARENTHESIZED LATIN SMALL LETTER Q
 * 	0028 LEFT PARENTHESIS
 * 	0071 LATIN SMALL LETTER Q
 * 	0029 RIGHT PARENTHESIS
 * 24AD PARENTHESIZED LATIN SMALL LETTER R
 * 	0028 LEFT PARENTHESIS
 * 	0072 LATIN SMALL LETTER R
 * 	0029 RIGHT PARENTHESIS
 * 24AE PARENTHESIZED LATIN SMALL LETTER S
 * 	0028 LEFT PARENTHESIS
 * 	0073 LATIN SMALL LETTER S
 * 	0029 RIGHT PARENTHESIS
 * 24AF PARENTHESIZED LATIN SMALL LETTER T
 * 	0028 LEFT PARENTHESIS
 * 	0074 LATIN SMALL LETTER T
 * 	0029 RIGHT PARENTHESIS
 * 24B0 PARENTHESIZED LATIN SMALL LETTER U
 * 	0028 LEFT PARENTHESIS
 * 	0075 LATIN SMALL LETTER U
 * 	0029 RIGHT PARENTHESIS
 * 24B1 PARENTHESIZED LATIN SMALL LETTER V
 * 	0028 LEFT PARENTHESIS
 * 	0076 LATIN SMALL LETTER V
 * 	0029 RIGHT PARENTHESIS
 * 24B2 PARENTHESIZED LATIN SMALL LETTER W
 * 	0028 LEFT PARENTHESIS
 * 	0077 LATIN SMALL LETTER W
 * 	0029 RIGHT PARENTHESIS
 * 24B3 PARENTHESIZED LATIN SMALL LETTER X
 * 	0028 LEFT PARENTHESIS
 * 	0078 LATIN SMALL LETTER X
 * 	0029 RIGHT PARENTHESIS
 * 24B4 PARENTHESIZED LATIN SMALL LETTER Y
 * 	0028 LEFT PARENTHESIS
 * 	0079 LATIN SMALL LETTER Y
 * 	0029 RIGHT PARENTHESIS
 * 24B5 PARENTHESIZED LATIN SMALL LETTER Z
 * 	0028 LEFT PARENTHESIS
 * 	007A LATIN SMALL LETTER Z
 * 	0029 RIGHT PARENTHESIS
 * 24B6 CIRCLED LATIN CAPITAL LETTER A
 * 	0041 LATIN CAPITAL LETTER A
 * 24B7 CIRCLED LATIN CAPITAL LETTER B
 * 	0042 LATIN CAPITAL LETTER B
 * 24B8 CIRCLED LATIN CAPITAL LETTER C
 * 	0043 LATIN CAPITAL LETTER C
 * 24B9 CIRCLED LATIN CAPITAL LETTER D
 * 	0044 LATIN CAPITAL LETTER D
 * 24BA CIRCLED LATIN CAPITAL LETTER E
 * 	0045 LATIN CAPITAL LETTER E
 * 24BB CIRCLED LATIN CAPITAL LETTER F
 * 	0046 LATIN CAPITAL LETTER F
 * 24BC CIRCLED LATIN CAPITAL LETTER G
 * 	0047 LATIN CAPITAL LETTER G
 * 24BD CIRCLED LATIN CAPITAL LETTER H
 * 	0048 LATIN CAPITAL LETTER H
 * 24BE CIRCLED LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 24BF CIRCLED LATIN CAPITAL LETTER J
 * 	004A LATIN CAPITAL LETTER J
 * 24C0 CIRCLED LATIN CAPITAL LETTER K
 * 	004B LATIN CAPITAL LETTER K
 * 24C1 CIRCLED LATIN CAPITAL LETTER L
 * 	004C LATIN CAPITAL LETTER L
 * 24C2 CIRCLED LATIN CAPITAL LETTER M
 * 	004D LATIN CAPITAL LETTER M
 * 24C3 CIRCLED LATIN CAPITAL LETTER N
 * 	004E LATIN CAPITAL LETTER N
 * 24C4 CIRCLED LATIN CAPITAL LETTER O
 * 	004F LATIN CAPITAL LETTER O
 * 24C5 CIRCLED LATIN CAPITAL LETTER P
 * 	0050 LATIN CAPITAL LETTER P
 * 24C6 CIRCLED LATIN CAPITAL LETTER Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 24C7 CIRCLED LATIN CAPITAL LETTER R
 * 	0052 LATIN CAPITAL LETTER R
 * 24C8 CIRCLED LATIN CAPITAL LETTER S
 * 	0053 LATIN CAPITAL LETTER S
 * 24C9 CIRCLED LATIN CAPITAL LETTER T
 * 	0054 LATIN CAPITAL LETTER T
 * 24CA CIRCLED LATIN CAPITAL LETTER U
 * 	0055 LATIN CAPITAL LETTER U
 * 24CB CIRCLED LATIN CAPITAL LETTER V
 * 	0056 LATIN CAPITAL LETTER V
 * 24CC CIRCLED LATIN CAPITAL LETTER W
 * 	0057 LATIN CAPITAL LETTER W
 * 24CD CIRCLED LATIN CAPITAL LETTER X
 * 	0058 LATIN CAPITAL LETTER X
 * 24CE CIRCLED LATIN CAPITAL LETTER Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 24CF CIRCLED LATIN CAPITAL LETTER Z
 * 	005A LATIN CAPITAL LETTER Z
 * 24D0 CIRCLED LATIN SMALL LETTER A
 * 	0061 LATIN SMALL LETTER A
 * 24D1 CIRCLED LATIN SMALL LETTER B
 * 	0062 LATIN SMALL LETTER B
 * 24D2 CIRCLED LATIN SMALL LETTER C
 * 	0063 LATIN SMALL LETTER C
 * 24D3 CIRCLED LATIN SMALL LETTER D
 * 	0064 LATIN SMALL LETTER D
 * 24D4 CIRCLED LATIN SMALL LETTER E
 * 	0065 LATIN SMALL LETTER E
 * 24D5 CIRCLED LATIN SMALL LETTER F
 * 	0066 LATIN SMALL LETTER F
 * 24D6 CIRCLED LATIN SMALL LETTER G
 * 	0067 LATIN SMALL LETTER G
 * 24D7 CIRCLED LATIN SMALL LETTER H
 * 	0068 LATIN SMALL LETTER H
 * 24D8 CIRCLED LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 24D9 CIRCLED LATIN SMALL LETTER J
 * 	006A LATIN SMALL LETTER J
 * 24DA CIRCLED LATIN SMALL LETTER K
 * 	006B LATIN SMALL LETTER K
 * 24DB CIRCLED LATIN SMALL LETTER L
 * 	006C LATIN SMALL LETTER L
 * 24DC CIRCLED LATIN SMALL LETTER M
 * 	006D LATIN SMALL LETTER M
 * 24DD CIRCLED LATIN SMALL LETTER N
 * 	006E LATIN SMALL LETTER N
 * 24DE CIRCLED LATIN SMALL LETTER O
 * 	006F LATIN SMALL LETTER O
 * 24DF CIRCLED LATIN SMALL LETTER P
 * 	0070 LATIN SMALL LETTER P
 * 24E0 CIRCLED LATIN SMALL LETTER Q
 * 	0071 LATIN SMALL LETTER Q
 * 24E1 CIRCLED LATIN SMALL LETTER R
 * 	0072 LATIN SMALL LETTER R
 * 24E2 CIRCLED LATIN SMALL LETTER S
 * 	0073 LATIN SMALL LETTER S
 * 24E3 CIRCLED LATIN SMALL LETTER T
 * 	0074 LATIN SMALL LETTER T
 * 24E4 CIRCLED LATIN SMALL LETTER U
 * 	0075 LATIN SMALL LETTER U
 * 24E5 CIRCLED LATIN SMALL LETTER V
 * 	0076 LATIN SMALL LETTER V
 * 24E6 CIRCLED LATIN SMALL LETTER W
 * 	0077 LATIN SMALL LETTER W
 * 24E7 CIRCLED LATIN SMALL LETTER X
 * 	0078 LATIN SMALL LETTER X
 * 24E8 CIRCLED LATIN SMALL LETTER Y
 * 	0079 LATIN SMALL LETTER Y
 * 24E9 CIRCLED LATIN SMALL LETTER Z
 * 	007A LATIN SMALL LETTER Z
 * 24EA CIRCLED DIGIT ZERO
 * 	0030 DIGIT ZERO
 * 2A0C QUADRUPLE INTEGRAL OPERATOR
 * 	222B INTEGRAL
 * 	222B INTEGRAL
 * 	222B INTEGRAL
 * 	222B INTEGRAL
 * 2A74 DOUBLE COLON EQUAL
 * 	003A COLON
 * 	003A COLON
 * 	003D EQUALS SIGN
 * 2A75 TWO CONSECUTIVE EQUALS SIGNS
 * 	003D EQUALS SIGN
 * 	003D EQUALS SIGN
 * 2A76 THREE CONSECUTIVE EQUALS SIGNS
 * 	003D EQUALS SIGN
 * 	003D EQUALS SIGN
 * 	003D EQUALS SIGN
 * 2ADC FORKING
 * 	2ADD NONFORKING
 * 2C7C LATIN SUBSCRIPT SMALL LETTER J
 * 	006A LATIN SMALL LETTER J
 * 2C7D MODIFIER LETTER CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 2D6F TIFINAGH MODIFIER LETTER LABIALIZATION MARK
 * 	2D61 TIFINAGH LETTER YAW
 * 2DE0 COMBINING CYRILLIC LETTER BE
 * 	0000 <control>
 * 2DE1 COMBINING CYRILLIC LETTER VE
 * 	0000 <control>
 * 2DE2 COMBINING CYRILLIC LETTER GHE
 * 	0000 <control>
 * 2DE3 COMBINING CYRILLIC LETTER DE
 * 	0000 <control>
 * 2DE4 COMBINING CYRILLIC LETTER ZHE
 * 	0000 <control>
 * 2DE5 COMBINING CYRILLIC LETTER ZE
 * 	0000 <control>
 * 2DE6 COMBINING CYRILLIC LETTER KA
 * 	0000 <control>
 * 2DE7 COMBINING CYRILLIC LETTER EL
 * 	0000 <control>
 * 2DE8 COMBINING CYRILLIC LETTER EM
 * 	0000 <control>
 * 2DE9 COMBINING CYRILLIC LETTER EN
 * 	0000 <control>
 * 2DEA COMBINING CYRILLIC LETTER O
 * 	0000 <control>
 * 2DEB COMBINING CYRILLIC LETTER PE
 * 	0000 <control>
 * 2DEC COMBINING CYRILLIC LETTER ER
 * 	0000 <control>
 * 2DED COMBINING CYRILLIC LETTER ES
 * 	0000 <control>
 * 2DEE COMBINING CYRILLIC LETTER TE
 * 	0000 <control>
 * 2DEF COMBINING CYRILLIC LETTER HA
 * 	0000 <control>
 * 2DF0 COMBINING CYRILLIC LETTER TSE
 * 	0000 <control>
 * 2DF1 COMBINING CYRILLIC LETTER CHE
 * 	0000 <control>
 * 2DF2 COMBINING CYRILLIC LETTER SHA
 * 	0000 <control>
 * 2DF3 COMBINING CYRILLIC LETTER SHCHA
 * 	0000 <control>
 * 2DF4 COMBINING CYRILLIC LETTER FITA
 * 	0000 <control>
 * 2DF5 COMBINING CYRILLIC LETTER ES-TE
 * 	0000 <control>
 * 2DF6 COMBINING CYRILLIC LETTER A
 * 	0000 <control>
 * 2DF7 COMBINING CYRILLIC LETTER IE
 * 	0000 <control>
 * 2DF8 COMBINING CYRILLIC LETTER DJERV
 * 	0000 <control>
 * 2DF9 COMBINING CYRILLIC LETTER MONOGRAPH UK
 * 	0000 <control>
 * 2DFA COMBINING CYRILLIC LETTER YAT
 * 	0000 <control>
 * 2DFB COMBINING CYRILLIC LETTER YU
 * 	0000 <control>
 * 2DFC COMBINING CYRILLIC LETTER IOTIFIED A
 * 	0000 <control>
 * 2DFD COMBINING CYRILLIC LETTER LITTLE YUS
 * 	0000 <control>
 * 2DFE COMBINING CYRILLIC LETTER BIG YUS
 * 	0000 <control>
 * 2DFF COMBINING CYRILLIC LETTER IOTIFIED BIG YUS
 * 	0000 <control>
 * 2E9F CJK RADICAL MOTHER
 * 	6BCD ??
 * 2EF3 CJK RADICAL C-SIMPLIFIED TURTLE
 * 	9F9F ??
 * 2F00 KANGXI RADICAL ONE
 * 	4E00 <CJK Ideograph, First>
 * 2F01 KANGXI RADICAL LINE
 * 	4E28 ??
 * 2F02 KANGXI RADICAL DOT
 * 	4E36 ??
 * 2F03 KANGXI RADICAL SLASH
 * 	4E3F ??
 * 2F04 KANGXI RADICAL SECOND
 * 	4E59 ??
 * 2F05 KANGXI RADICAL HOOK
 * 	4E85 ??
 * 2F06 KANGXI RADICAL TWO
 * 	4E8C ??
 * 2F07 KANGXI RADICAL LID
 * 	4EA0 ??
 * 2F08 KANGXI RADICAL MAN
 * 	4EBA ??
 * 2F09 KANGXI RADICAL LEGS
 * 	513F ??
 * 2F0A KANGXI RADICAL ENTER
 * 	5165 ??
 * 2F0B KANGXI RADICAL EIGHT
 * 	516B ??
 * 2F0C KANGXI RADICAL DOWN BOX
 * 	5182 ??
 * 2F0D KANGXI RADICAL COVER
 * 	5196 ??
 * 2F0E KANGXI RADICAL ICE
 * 	51AB ??
 * 2F0F KANGXI RADICAL TABLE
 * 	51E0 ??
 * 2F10 KANGXI RADICAL OPEN BOX
 * 	51F5 ??
 * 2F11 KANGXI RADICAL KNIFE
 * 	5200 ??
 * 2F12 KANGXI RADICAL POWER
 * 	529B ??
 * 2F13 KANGXI RADICAL WRAP
 * 	52F9 ??
 * 2F14 KANGXI RADICAL SPOON
 * 	5315 ??
 * 2F15 KANGXI RADICAL RIGHT OPEN BOX
 * 	531A ??
 * 2F16 KANGXI RADICAL HIDING ENCLOSURE
 * 	5338 ??
 * 2F17 KANGXI RADICAL TEN
 * 	5341 ??
 * 2F18 KANGXI RADICAL DIVINATION
 * 	535C ??
 * 2F19 KANGXI RADICAL SEAL
 * 	5369 ??
 * 2F1A KANGXI RADICAL CLIFF
 * 	5382 ??
 * 2F1B KANGXI RADICAL PRIVATE
 * 	53B6 ??
 * 2F1C KANGXI RADICAL AGAIN
 * 	53C8 ??
 * 2F1D KANGXI RADICAL MOUTH
 * 	53E3 ??
 * 2F1E KANGXI RADICAL ENCLOSURE
 * 	56D7 ??
 * 2F1F KANGXI RADICAL EARTH
 * 	571F ??
 * 2F20 KANGXI RADICAL SCHOLAR
 * 	58EB ??
 * 2F21 KANGXI RADICAL GO
 * 	5902 ??
 * 2F22 KANGXI RADICAL GO SLOWLY
 * 	590A ??
 * 2F23 KANGXI RADICAL EVENING
 * 	5915 ??
 * 2F24 KANGXI RADICAL BIG
 * 	5927 ??
 * 2F25 KANGXI RADICAL WOMAN
 * 	5973 ??
 * 2F26 KANGXI RADICAL CHILD
 * 	5B50 ??
 * 2F27 KANGXI RADICAL ROOF
 * 	5B80 ??
 * 2F28 KANGXI RADICAL INCH
 * 	5BF8 ??
 * 2F29 KANGXI RADICAL SMALL
 * 	5C0F ??
 * 2F2A KANGXI RADICAL LAME
 * 	5C22 ??
 * 2F2B KANGXI RADICAL CORPSE
 * 	5C38 ??
 * 2F2C KANGXI RADICAL SPROUT
 * 	5C6E ??
 * 2F2D KANGXI RADICAL MOUNTAIN
 * 	5C71 ??
 * 2F2E KANGXI RADICAL RIVER
 * 	5DDB ??
 * 2F2F KANGXI RADICAL WORK
 * 	5DE5 ??
 * 2F30 KANGXI RADICAL ONESELF
 * 	5DF1 ??
 * 2F31 KANGXI RADICAL TURBAN
 * 	5DFE ??
 * 2F32 KANGXI RADICAL DRY
 * 	5E72 ??
 * 2F33 KANGXI RADICAL SHORT THREAD
 * 	5E7A ??
 * 2F34 KANGXI RADICAL DOTTED CLIFF
 * 	5E7F ??
 * 2F35 KANGXI RADICAL LONG STRIDE
 * 	5EF4 ??
 * 2F36 KANGXI RADICAL TWO HANDS
 * 	5EFE ??
 * 2F37 KANGXI RADICAL SHOOT
 * 	5F0B ??
 * 2F38 KANGXI RADICAL BOW
 * 	5F13 ??
 * 2F39 KANGXI RADICAL SNOUT
 * 	5F50 ??
 * 2F3A KANGXI RADICAL BRISTLE
 * 	5F61 ??
 * 2F3B KANGXI RADICAL STEP
 * 	5F73 ??
 * 2F3C KANGXI RADICAL HEART
 * 	5FC3 ??
 * 2F3D KANGXI RADICAL HALBERD
 * 	6208 ??
 * 2F3E KANGXI RADICAL DOOR
 * 	6236 ??
 * 2F3F KANGXI RADICAL HAND
 * 	624B ??
 * 2F40 KANGXI RADICAL BRANCH
 * 	652F ??
 * 2F41 KANGXI RADICAL RAP
 * 	6534 ??
 * 2F42 KANGXI RADICAL SCRIPT
 * 	6587 ??
 * 2F43 KANGXI RADICAL DIPPER
 * 	6597 ??
 * 2F44 KANGXI RADICAL AXE
 * 	65A4 ??
 * 2F45 KANGXI RADICAL SQUARE
 * 	65B9 ??
 * 2F46 KANGXI RADICAL NOT
 * 	65E0 ??
 * 2F47 KANGXI RADICAL SUN
 * 	65E5 ??
 * 2F48 KANGXI RADICAL SAY
 * 	66F0 ??
 * 2F49 KANGXI RADICAL MOON
 * 	6708 ??
 * 2F4A KANGXI RADICAL TREE
 * 	6728 ??
 * 2F4B KANGXI RADICAL LACK
 * 	6B20 ??
 * 2F4C KANGXI RADICAL STOP
 * 	6B62 ??
 * 2F4D KANGXI RADICAL DEATH
 * 	6B79 ??
 * 2F4E KANGXI RADICAL WEAPON
 * 	6BB3 ??
 * 2F4F KANGXI RADICAL DO NOT
 * 	6BCB ??
 * 2F50 KANGXI RADICAL COMPARE
 * 	6BD4 ??
 * 2F51 KANGXI RADICAL FUR
 * 	6BDB ??
 * 2F52 KANGXI RADICAL CLAN
 * 	6C0F ??
 * 2F53 KANGXI RADICAL STEAM
 * 	6C14 ??
 * 2F54 KANGXI RADICAL WATER
 * 	6C34 ??
 * 2F55 KANGXI RADICAL FIRE
 * 	706B ??
 * 2F56 KANGXI RADICAL CLAW
 * 	722A ??
 * 2F57 KANGXI RADICAL FATHER
 * 	7236 ??
 * 2F58 KANGXI RADICAL DOUBLE X
 * 	723B ??
 * 2F59 KANGXI RADICAL HALF TREE TRUNK
 * 	723F ??
 * 2F5A KANGXI RADICAL SLICE
 * 	7247 ??
 * 2F5B KANGXI RADICAL FANG
 * 	7259 ??
 * 2F5C KANGXI RADICAL COW
 * 	725B ??
 * 2F5D KANGXI RADICAL DOG
 * 	72AC ??
 * 2F5E KANGXI RADICAL PROFOUND
 * 	7384 ??
 * 2F5F KANGXI RADICAL JADE
 * 	7389 ??
 * 2F60 KANGXI RADICAL MELON
 * 	74DC ??
 * 2F61 KANGXI RADICAL TILE
 * 	74E6 ??
 * 2F62 KANGXI RADICAL SWEET
 * 	7518 ??
 * 2F63 KANGXI RADICAL LIFE
 * 	751F ??
 * 2F64 KANGXI RADICAL USE
 * 	7528 ??
 * 2F65 KANGXI RADICAL FIELD
 * 	7530 ??
 * 2F66 KANGXI RADICAL BOLT OF CLOTH
 * 	758B ??
 * 2F67 KANGXI RADICAL SICKNESS
 * 	7592 ??
 * 2F68 KANGXI RADICAL DOTTED TENT
 * 	7676 ??
 * 2F69 KANGXI RADICAL WHITE
 * 	767D ??
 * 2F6A KANGXI RADICAL SKIN
 * 	76AE ??
 * 2F6B KANGXI RADICAL DISH
 * 	76BF ??
 * 2F6C KANGXI RADICAL EYE
 * 	76EE ??
 * 2F6D KANGXI RADICAL SPEAR
 * 	77DB ??
 * 2F6E KANGXI RADICAL ARROW
 * 	77E2 ??
 * 2F6F KANGXI RADICAL STONE
 * 	77F3 ??
 * 2F70 KANGXI RADICAL SPIRIT
 * 	793A ??
 * 2F71 KANGXI RADICAL TRACK
 * 	79B8 ??
 * 2F72 KANGXI RADICAL GRAIN
 * 	79BE ??
 * 2F73 KANGXI RADICAL CAVE
 * 	7A74 ??
 * 2F74 KANGXI RADICAL STAND
 * 	7ACB ??
 * 2F75 KANGXI RADICAL BAMBOO
 * 	7AF9 ??
 * 2F76 KANGXI RADICAL RICE
 * 	7C73 ??
 * 2F77 KANGXI RADICAL SILK
 * 	7CF8 ??
 * 2F78 KANGXI RADICAL JAR
 * 	7F36 ??
 * 2F79 KANGXI RADICAL NET
 * 	7F51 ??
 * 2F7A KANGXI RADICAL SHEEP
 * 	7F8A ??
 * 2F7B KANGXI RADICAL FEATHER
 * 	7FBD ??
 * 2F7C KANGXI RADICAL OLD
 * 	8001 ??
 * 2F7D KANGXI RADICAL AND
 * 	800C ??
 * 2F7E KANGXI RADICAL PLOW
 * 	8012 ??
 * 2F7F KANGXI RADICAL EAR
 * 	8033 ??
 * 2F80 KANGXI RADICAL BRUSH
 * 	807F ??
 * 2F81 KANGXI RADICAL MEAT
 * 	8089 ??
 * 2F82 KANGXI RADICAL MINISTER
 * 	81E3 ??
 * 2F83 KANGXI RADICAL SELF
 * 	81EA ??
 * 2F84 KANGXI RADICAL ARRIVE
 * 	81F3 ??
 * 2F85 KANGXI RADICAL MORTAR
 * 	81FC ??
 * 2F86 KANGXI RADICAL TONGUE
 * 	820C ??
 * 2F87 KANGXI RADICAL OPPOSE
 * 	821B ??
 * 2F88 KANGXI RADICAL BOAT
 * 	821F ??
 * 2F89 KANGXI RADICAL STOPPING
 * 	826E ??
 * 2F8A KANGXI RADICAL COLOR
 * 	8272 ??
 * 2F8B KANGXI RADICAL GRASS
 * 	8278 ??
 * 2F8C KANGXI RADICAL TIGER
 * 	864D ??
 * 2F8D KANGXI RADICAL INSECT
 * 	866B ??
 * 2F8E KANGXI RADICAL BLOOD
 * 	8840 ??
 * 2F8F KANGXI RADICAL WALK ENCLOSURE
 * 	884C ??
 * 2F90 KANGXI RADICAL CLOTHES
 * 	8863 ??
 * 2F91 KANGXI RADICAL WEST
 * 	897E ??
 * 2F92 KANGXI RADICAL SEE
 * 	898B ??
 * 2F93 KANGXI RADICAL HORN
 * 	89D2 ??
 * 2F94 KANGXI RADICAL SPEECH
 * 	8A00 ??
 * 2F95 KANGXI RADICAL VALLEY
 * 	8C37 ??
 * 2F96 KANGXI RADICAL BEAN
 * 	8C46 ??
 * 2F97 KANGXI RADICAL PIG
 * 	8C55 ??
 * 2F98 KANGXI RADICAL BADGER
 * 	8C78 ??
 * 2F99 KANGXI RADICAL SHELL
 * 	8C9D ??
 * 2F9A KANGXI RADICAL RED
 * 	8D64 ??
 * 2F9B KANGXI RADICAL RUN
 * 	8D70 ??
 * 2F9C KANGXI RADICAL FOOT
 * 	8DB3 ??
 * 2F9D KANGXI RADICAL BODY
 * 	8EAB ??
 * 2F9E KANGXI RADICAL CART
 * 	8ECA ??
 * 2F9F KANGXI RADICAL BITTER
 * 	8F9B ??
 * 2FA0 KANGXI RADICAL MORNING
 * 	8FB0 ??
 * 2FA1 KANGXI RADICAL WALK
 * 	8FB5 ??
 * 2FA2 KANGXI RADICAL CITY
 * 	9091 ??
 * 2FA3 KANGXI RADICAL WINE
 * 	9149 ??
 * 2FA4 KANGXI RADICAL DISTINGUISH
 * 	91C6 ??
 * 2FA5 KANGXI RADICAL VILLAGE
 * 	91CC ??
 * 2FA6 KANGXI RADICAL GOLD
 * 	91D1 ??
 * 2FA7 KANGXI RADICAL LONG
 * 	9577 ??
 * 2FA8 KANGXI RADICAL GATE
 * 	9580 ??
 * 2FA9 KANGXI RADICAL MOUND
 * 	961C ??
 * 2FAA KANGXI RADICAL SLAVE
 * 	96B6 ??
 * 2FAB KANGXI RADICAL SHORT TAILED BIRD
 * 	96B9 ??
 * 2FAC KANGXI RADICAL RAIN
 * 	96E8 ??
 * 2FAD KANGXI RADICAL BLUE
 * 	9751 ??
 * 2FAE KANGXI RADICAL WRONG
 * 	975E ??
 * 2FAF KANGXI RADICAL FACE
 * 	9762 ??
 * 2FB0 KANGXI RADICAL LEATHER
 * 	9769 ??
 * 2FB1 KANGXI RADICAL TANNED LEATHER
 * 	97CB ??
 * 2FB2 KANGXI RADICAL LEEK
 * 	97ED ??
 * 2FB3 KANGXI RADICAL SOUND
 * 	97F3 ??
 * 2FB4 KANGXI RADICAL LEAF
 * 	9801 ??
 * 2FB5 KANGXI RADICAL WIND
 * 	98A8 ??
 * 2FB6 KANGXI RADICAL FLY
 * 	98DB ??
 * 2FB7 KANGXI RADICAL EAT
 * 	98DF ??
 * 2FB8 KANGXI RADICAL HEAD
 * 	9996 ??
 * 2FB9 KANGXI RADICAL FRAGRANT
 * 	9999 ??
 * 2FBA KANGXI RADICAL HORSE
 * 	99AC ??
 * 2FBB KANGXI RADICAL BONE
 * 	9AA8 ??
 * 2FBC KANGXI RADICAL TALL
 * 	9AD8 ??
 * 2FBD KANGXI RADICAL HAIR
 * 	9ADF ??
 * 2FBE KANGXI RADICAL FIGHT
 * 	9B25 ??
 * 2FBF KANGXI RADICAL SACRIFICIAL WINE
 * 	9B2F ??
 * 2FC0 KANGXI RADICAL CAULDRON
 * 	9B32 ??
 * 2FC1 KANGXI RADICAL GHOST
 * 	9B3C ??
 * 2FC2 KANGXI RADICAL FISH
 * 	9B5A ??
 * 2FC3 KANGXI RADICAL BIRD
 * 	9CE5 ??
 * 2FC4 KANGXI RADICAL SALT
 * 	9E75 ??
 * 2FC5 KANGXI RADICAL DEER
 * 	9E7F ??
 * 2FC6 KANGXI RADICAL WHEAT
 * 	9EA5 ??
 * 2FC7 KANGXI RADICAL HEMP
 * 	9EBB ??
 * 2FC8 KANGXI RADICAL YELLOW
 * 	9EC3 ??
 * 2FC9 KANGXI RADICAL MILLET
 * 	9ECD ??
 * 2FCA KANGXI RADICAL BLACK
 * 	9ED1 ??
 * 2FCB KANGXI RADICAL EMBROIDERY
 * 	9EF9 ??
 * 2FCC KANGXI RADICAL FROG
 * 	9EFD ??
 * 2FCD KANGXI RADICAL TRIPOD
 * 	9F0E ??
 * 2FCE KANGXI RADICAL DRUM
 * 	9F13 ??
 * 2FCF KANGXI RADICAL RAT
 * 	9F20 ??
 * 2FD0 KANGXI RADICAL NOSE
 * 	9F3B ??
 * 2FD1 KANGXI RADICAL EVEN
 * 	9F4A ??
 * 2FD2 KANGXI RADICAL TOOTH
 * 	9F52 ??
 * 2FD3 KANGXI RADICAL DRAGON
 * 	9F8D ??
 * 2FD4 KANGXI RADICAL TURTLE
 * 	9F9C ??
 * 2FD5 KANGXI RADICAL FLUTE
 * 	9FA0 ??
 * 3000 IDEOGRAPHIC SPACE
 * 	0020 SPACE
 * 302A IDEOGRAPHIC LEVEL TONE MARK
 * 	0000 <control>
 * 302B IDEOGRAPHIC RISING TONE MARK
 * 	0000 <control>
 * 302C IDEOGRAPHIC DEPARTING TONE MARK
 * 	0000 <control>
 * 302D IDEOGRAPHIC ENTERING TONE MARK
 * 	0000 <control>
 * 302E HANGUL SINGLE DOT TONE MARK
 * 	0000 <control>
 * 302F HANGUL DOUBLE DOT TONE MARK
 * 	0000 <control>
 * 3036 CIRCLED POSTAL MARK
 * 	3012 POSTAL MARK
 * 3038 HANGZHOU NUMERAL TEN
 * 	5341 ??
 * 3039 HANGZHOU NUMERAL TWENTY
 * 	5344 ??
 * 303A HANGZHOU NUMERAL THIRTY
 * 	5345 ??
 * 3099 COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
 * 	0000 <control>
 * 309A COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
 * 	0000 <control>
 * 3131 HANGUL LETTER KIYEOK
 * 	1100 HANGUL CHOSEONG KIYEOK
 * 3132 HANGUL LETTER SSANGKIYEOK
 * 	1101 HANGUL CHOSEONG SSANGKIYEOK
 * 3133 HANGUL LETTER KIYEOK-SIOS
 * 	11AA HANGUL JONGSEONG KIYEOK-SIOS
 * 3134 HANGUL LETTER NIEUN
 * 	1102 HANGUL CHOSEONG NIEUN
 * 3135 HANGUL LETTER NIEUN-CIEUC
 * 	11AC HANGUL JONGSEONG NIEUN-CIEUC
 * 3136 HANGUL LETTER NIEUN-HIEUH
 * 	11AD HANGUL JONGSEONG NIEUN-HIEUH
 * 3137 HANGUL LETTER TIKEUT
 * 	1103 HANGUL CHOSEONG TIKEUT
 * 3138 HANGUL LETTER SSANGTIKEUT
 * 	1104 HANGUL CHOSEONG SSANGTIKEUT
 * 3139 HANGUL LETTER RIEUL
 * 	1105 HANGUL CHOSEONG RIEUL
 * 313A HANGUL LETTER RIEUL-KIYEOK
 * 	11B0 HANGUL JONGSEONG RIEUL-KIYEOK
 * 313B HANGUL LETTER RIEUL-MIEUM
 * 	11B1 HANGUL JONGSEONG RIEUL-MIEUM
 * 313C HANGUL LETTER RIEUL-PIEUP
 * 	11B2 HANGUL JONGSEONG RIEUL-PIEUP
 * 313D HANGUL LETTER RIEUL-SIOS
 * 	11B3 HANGUL JONGSEONG RIEUL-SIOS
 * 313E HANGUL LETTER RIEUL-THIEUTH
 * 	11B4 HANGUL JONGSEONG RIEUL-THIEUTH
 * 313F HANGUL LETTER RIEUL-PHIEUPH
 * 	11B5 HANGUL JONGSEONG RIEUL-PHIEUPH
 * 3140 HANGUL LETTER RIEUL-HIEUH
 * 	111A HANGUL CHOSEONG RIEUL-HIEUH
 * 3141 HANGUL LETTER MIEUM
 * 	1106 HANGUL CHOSEONG MIEUM
 * 3142 HANGUL LETTER PIEUP
 * 	1107 HANGUL CHOSEONG PIEUP
 * 3143 HANGUL LETTER SSANGPIEUP
 * 	1108 HANGUL CHOSEONG SSANGPIEUP
 * 3144 HANGUL LETTER PIEUP-SIOS
 * 	1121 HANGUL CHOSEONG PIEUP-SIOS
 * 3145 HANGUL LETTER SIOS
 * 	1109 HANGUL CHOSEONG SIOS
 * 3146 HANGUL LETTER SSANGSIOS
 * 	110A HANGUL CHOSEONG SSANGSIOS
 * 3147 HANGUL LETTER IEUNG
 * 	110B HANGUL CHOSEONG IEUNG
 * 3148 HANGUL LETTER CIEUC
 * 	110C HANGUL CHOSEONG CIEUC
 * 3149 HANGUL LETTER SSANGCIEUC
 * 	110D HANGUL CHOSEONG SSANGCIEUC
 * 314A HANGUL LETTER CHIEUCH
 * 	110E HANGUL CHOSEONG CHIEUCH
 * 314B HANGUL LETTER KHIEUKH
 * 	110F HANGUL CHOSEONG KHIEUKH
 * 314C HANGUL LETTER THIEUTH
 * 	1110 HANGUL CHOSEONG THIEUTH
 * 314D HANGUL LETTER PHIEUPH
 * 	1111 HANGUL CHOSEONG PHIEUPH
 * 314E HANGUL LETTER HIEUH
 * 	1112 HANGUL CHOSEONG HIEUH
 * 314F HANGUL LETTER A
 * 	1161 HANGUL JUNGSEONG A
 * 3150 HANGUL LETTER AE
 * 	1162 HANGUL JUNGSEONG AE
 * 3151 HANGUL LETTER YA
 * 	1163 HANGUL JUNGSEONG YA
 * 3152 HANGUL LETTER YAE
 * 	1164 HANGUL JUNGSEONG YAE
 * 3153 HANGUL LETTER EO
 * 	1165 HANGUL JUNGSEONG EO
 * 3154 HANGUL LETTER E
 * 	1166 HANGUL JUNGSEONG E
 * 3155 HANGUL LETTER YEO
 * 	1167 HANGUL JUNGSEONG YEO
 * 3156 HANGUL LETTER YE
 * 	1168 HANGUL JUNGSEONG YE
 * 3157 HANGUL LETTER O
 * 	1169 HANGUL JUNGSEONG O
 * 3158 HANGUL LETTER WA
 * 	116A HANGUL JUNGSEONG WA
 * 3159 HANGUL LETTER WAE
 * 	116B HANGUL JUNGSEONG WAE
 * 315A HANGUL LETTER OE
 * 	116C HANGUL JUNGSEONG OE
 * 315B HANGUL LETTER YO
 * 	116D HANGUL JUNGSEONG YO
 * 315C HANGUL LETTER U
 * 	116E HANGUL JUNGSEONG U
 * 315D HANGUL LETTER WEO
 * 	116F HANGUL JUNGSEONG WEO
 * 315E HANGUL LETTER WE
 * 	1170 HANGUL JUNGSEONG WE
 * 315F HANGUL LETTER WI
 * 	1171 HANGUL JUNGSEONG WI
 * 3160 HANGUL LETTER YU
 * 	1172 HANGUL JUNGSEONG YU
 * 3161 HANGUL LETTER EU
 * 	1173 HANGUL JUNGSEONG EU
 * 3162 HANGUL LETTER YI
 * 	1174 HANGUL JUNGSEONG YI
 * 3163 HANGUL LETTER I
 * 	1175 HANGUL JUNGSEONG I
 * 3164 HANGUL FILLER
 * 	1160 HANGUL JUNGSEONG FILLER
 * 3165 HANGUL LETTER SSANGNIEUN
 * 	1114 HANGUL CHOSEONG SSANGNIEUN
 * 3166 HANGUL LETTER NIEUN-TIKEUT
 * 	1115 HANGUL CHOSEONG NIEUN-TIKEUT
 * 3167 HANGUL LETTER NIEUN-SIOS
 * 	11C7 HANGUL JONGSEONG NIEUN-SIOS
 * 3168 HANGUL LETTER NIEUN-PANSIOS
 * 	11C8 HANGUL JONGSEONG NIEUN-PANSIOS
 * 3169 HANGUL LETTER RIEUL-KIYEOK-SIOS
 * 	11CC HANGUL JONGSEONG RIEUL-KIYEOK-SIOS
 * 316A HANGUL LETTER RIEUL-TIKEUT
 * 	11CE HANGUL JONGSEONG RIEUL-TIKEUT
 * 316B HANGUL LETTER RIEUL-PIEUP-SIOS
 * 	11D3 HANGUL JONGSEONG RIEUL-PIEUP-SIOS
 * 316C HANGUL LETTER RIEUL-PANSIOS
 * 	11D7 HANGUL JONGSEONG RIEUL-PANSIOS
 * 316D HANGUL LETTER RIEUL-YEORINHIEUH
 * 	11D9 HANGUL JONGSEONG RIEUL-YEORINHIEUH
 * 316E HANGUL LETTER MIEUM-PIEUP
 * 	111C HANGUL CHOSEONG MIEUM-PIEUP
 * 316F HANGUL LETTER MIEUM-SIOS
 * 	11DD HANGUL JONGSEONG MIEUM-SIOS
 * 3170 HANGUL LETTER MIEUM-PANSIOS
 * 	11DF HANGUL JONGSEONG MIEUM-PANSIOS
 * 3171 HANGUL LETTER KAPYEOUNMIEUM
 * 	111D HANGUL CHOSEONG KAPYEOUNMIEUM
 * 3172 HANGUL LETTER PIEUP-KIYEOK
 * 	111E HANGUL CHOSEONG PIEUP-KIYEOK
 * 3173 HANGUL LETTER PIEUP-TIKEUT
 * 	1120 HANGUL CHOSEONG PIEUP-TIKEUT
 * 3174 HANGUL LETTER PIEUP-SIOS-KIYEOK
 * 	1122 HANGUL CHOSEONG PIEUP-SIOS-KIYEOK
 * 3175 HANGUL LETTER PIEUP-SIOS-TIKEUT
 * 	1123 HANGUL CHOSEONG PIEUP-SIOS-TIKEUT
 * 3176 HANGUL LETTER PIEUP-CIEUC
 * 	1127 HANGUL CHOSEONG PIEUP-CIEUC
 * 3177 HANGUL LETTER PIEUP-THIEUTH
 * 	1129 HANGUL CHOSEONG PIEUP-THIEUTH
 * 3178 HANGUL LETTER KAPYEOUNPIEUP
 * 	112B HANGUL CHOSEONG KAPYEOUNPIEUP
 * 3179 HANGUL LETTER KAPYEOUNSSANGPIEUP
 * 	112C HANGUL CHOSEONG KAPYEOUNSSANGPIEUP
 * 317A HANGUL LETTER SIOS-KIYEOK
 * 	112D HANGUL CHOSEONG SIOS-KIYEOK
 * 317B HANGUL LETTER SIOS-NIEUN
 * 	112E HANGUL CHOSEONG SIOS-NIEUN
 * 317C HANGUL LETTER SIOS-TIKEUT
 * 	112F HANGUL CHOSEONG SIOS-TIKEUT
 * 317D HANGUL LETTER SIOS-PIEUP
 * 	1132 HANGUL CHOSEONG SIOS-PIEUP
 * 317E HANGUL LETTER SIOS-CIEUC
 * 	1136 HANGUL CHOSEONG SIOS-CIEUC
 * 317F HANGUL LETTER PANSIOS
 * 	1140 HANGUL CHOSEONG PANSIOS
 * 3180 HANGUL LETTER SSANGIEUNG
 * 	1147 HANGUL CHOSEONG SSANGIEUNG
 * 3181 HANGUL LETTER YESIEUNG
 * 	114C HANGUL CHOSEONG YESIEUNG
 * 3182 HANGUL LETTER YESIEUNG-SIOS
 * 	11F1 HANGUL JONGSEONG YESIEUNG-SIOS
 * 3183 HANGUL LETTER YESIEUNG-PANSIOS
 * 	11F2 HANGUL JONGSEONG YESIEUNG-PANSIOS
 * 3184 HANGUL LETTER KAPYEOUNPHIEUPH
 * 	1157 HANGUL CHOSEONG KAPYEOUNPHIEUPH
 * 3185 HANGUL LETTER SSANGHIEUH
 * 	1158 HANGUL CHOSEONG SSANGHIEUH
 * 3186 HANGUL LETTER YEORINHIEUH
 * 	1159 HANGUL CHOSEONG YEORINHIEUH
 * 3187 HANGUL LETTER YO-YA
 * 	1184 HANGUL JUNGSEONG YO-YA
 * 3188 HANGUL LETTER YO-YAE
 * 	1185 HANGUL JUNGSEONG YO-YAE
 * 3189 HANGUL LETTER YO-I
 * 	1188 HANGUL JUNGSEONG YO-I
 * 318A HANGUL LETTER YU-YEO
 * 	1191 HANGUL JUNGSEONG YU-YEO
 * 318B HANGUL LETTER YU-YE
 * 	1192 HANGUL JUNGSEONG YU-YE
 * 318C HANGUL LETTER YU-I
 * 	1194 HANGUL JUNGSEONG YU-I
 * 318D HANGUL LETTER ARAEA
 * 	119E HANGUL JUNGSEONG ARAEA
 * 318E HANGUL LETTER ARAEAE
 * 	11A1 HANGUL JUNGSEONG ARAEA-I
 * 3192 IDEOGRAPHIC ANNOTATION ONE MARK
 * 	4E00 <CJK Ideograph, First>
 * 3193 IDEOGRAPHIC ANNOTATION TWO MARK
 * 	4E8C ??
 * 3194 IDEOGRAPHIC ANNOTATION THREE MARK
 * 	4E09 ??
 * 3195 IDEOGRAPHIC ANNOTATION FOUR MARK
 * 	56DB ??
 * 3196 IDEOGRAPHIC ANNOTATION TOP MARK
 * 	4E0A ??
 * 3197 IDEOGRAPHIC ANNOTATION MIDDLE MARK
 * 	4E2D ??
 * 3198 IDEOGRAPHIC ANNOTATION BOTTOM MARK
 * 	4E0B ??
 * 3199 IDEOGRAPHIC ANNOTATION FIRST MARK
 * 	7532 ??
 * 319A IDEOGRAPHIC ANNOTATION SECOND MARK
 * 	4E59 ??
 * 319B IDEOGRAPHIC ANNOTATION THIRD MARK
 * 	4E19 ??
 * 319C IDEOGRAPHIC ANNOTATION FOURTH MARK
 * 	4E01 ??
 * 319D IDEOGRAPHIC ANNOTATION HEAVEN MARK
 * 	5929 ??
 * 319E IDEOGRAPHIC ANNOTATION EARTH MARK
 * 	5730 ??
 * 319F IDEOGRAPHIC ANNOTATION MAN MARK
 * 	4EBA ??
 * 3200 PARENTHESIZED HANGUL KIYEOK
 * 	0028 LEFT PARENTHESIS
 * 	1100 HANGUL CHOSEONG KIYEOK
 * 	0029 RIGHT PARENTHESIS
 * 3201 PARENTHESIZED HANGUL NIEUN
 * 	0028 LEFT PARENTHESIS
 * 	1102 HANGUL CHOSEONG NIEUN
 * 	0029 RIGHT PARENTHESIS
 * 3202 PARENTHESIZED HANGUL TIKEUT
 * 	0028 LEFT PARENTHESIS
 * 	1103 HANGUL CHOSEONG TIKEUT
 * 	0029 RIGHT PARENTHESIS
 * 3203 PARENTHESIZED HANGUL RIEUL
 * 	0028 LEFT PARENTHESIS
 * 	1105 HANGUL CHOSEONG RIEUL
 * 	0029 RIGHT PARENTHESIS
 * 3204 PARENTHESIZED HANGUL MIEUM
 * 	0028 LEFT PARENTHESIS
 * 	1106 HANGUL CHOSEONG MIEUM
 * 	0029 RIGHT PARENTHESIS
 * 3205 PARENTHESIZED HANGUL PIEUP
 * 	0028 LEFT PARENTHESIS
 * 	1107 HANGUL CHOSEONG PIEUP
 * 	0029 RIGHT PARENTHESIS
 * 3206 PARENTHESIZED HANGUL SIOS
 * 	0028 LEFT PARENTHESIS
 * 	1109 HANGUL CHOSEONG SIOS
 * 	0029 RIGHT PARENTHESIS
 * 3207 PARENTHESIZED HANGUL IEUNG
 * 	0028 LEFT PARENTHESIS
 * 	110B HANGUL CHOSEONG IEUNG
 * 	0029 RIGHT PARENTHESIS
 * 3208 PARENTHESIZED HANGUL CIEUC
 * 	0028 LEFT PARENTHESIS
 * 	110C HANGUL CHOSEONG CIEUC
 * 	0029 RIGHT PARENTHESIS
 * 3209 PARENTHESIZED HANGUL CHIEUCH
 * 	0028 LEFT PARENTHESIS
 * 	110E HANGUL CHOSEONG CHIEUCH
 * 	0029 RIGHT PARENTHESIS
 * 320A PARENTHESIZED HANGUL KHIEUKH
 * 	0028 LEFT PARENTHESIS
 * 	110F HANGUL CHOSEONG KHIEUKH
 * 	0029 RIGHT PARENTHESIS
 * 320B PARENTHESIZED HANGUL THIEUTH
 * 	0028 LEFT PARENTHESIS
 * 	1110 HANGUL CHOSEONG THIEUTH
 * 	0029 RIGHT PARENTHESIS
 * 320C PARENTHESIZED HANGUL PHIEUPH
 * 	0028 LEFT PARENTHESIS
 * 	1111 HANGUL CHOSEONG PHIEUPH
 * 	0029 RIGHT PARENTHESIS
 * 320D PARENTHESIZED HANGUL HIEUH
 * 	0028 LEFT PARENTHESIS
 * 	1112 HANGUL CHOSEONG HIEUH
 * 	0029 RIGHT PARENTHESIS
 * 320E PARENTHESIZED HANGUL KIYEOK A
 * 	0028 LEFT PARENTHESIS
 * 	1100 HANGUL CHOSEONG KIYEOK
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 320F PARENTHESIZED HANGUL NIEUN A
 * 	0028 LEFT PARENTHESIS
 * 	1102 HANGUL CHOSEONG NIEUN
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3210 PARENTHESIZED HANGUL TIKEUT A
 * 	0028 LEFT PARENTHESIS
 * 	1103 HANGUL CHOSEONG TIKEUT
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3211 PARENTHESIZED HANGUL RIEUL A
 * 	0028 LEFT PARENTHESIS
 * 	1105 HANGUL CHOSEONG RIEUL
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3212 PARENTHESIZED HANGUL MIEUM A
 * 	0028 LEFT PARENTHESIS
 * 	1106 HANGUL CHOSEONG MIEUM
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3213 PARENTHESIZED HANGUL PIEUP A
 * 	0028 LEFT PARENTHESIS
 * 	1107 HANGUL CHOSEONG PIEUP
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3214 PARENTHESIZED HANGUL SIOS A
 * 	0028 LEFT PARENTHESIS
 * 	1109 HANGUL CHOSEONG SIOS
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3215 PARENTHESIZED HANGUL IEUNG A
 * 	0028 LEFT PARENTHESIS
 * 	110B HANGUL CHOSEONG IEUNG
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3216 PARENTHESIZED HANGUL CIEUC A
 * 	0028 LEFT PARENTHESIS
 * 	110C HANGUL CHOSEONG CIEUC
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3217 PARENTHESIZED HANGUL CHIEUCH A
 * 	0028 LEFT PARENTHESIS
 * 	110E HANGUL CHOSEONG CHIEUCH
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3218 PARENTHESIZED HANGUL KHIEUKH A
 * 	0028 LEFT PARENTHESIS
 * 	110F HANGUL CHOSEONG KHIEUKH
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3219 PARENTHESIZED HANGUL THIEUTH A
 * 	0028 LEFT PARENTHESIS
 * 	1110 HANGUL CHOSEONG THIEUTH
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 321A PARENTHESIZED HANGUL PHIEUPH A
 * 	0028 LEFT PARENTHESIS
 * 	1111 HANGUL CHOSEONG PHIEUPH
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 321B PARENTHESIZED HANGUL HIEUH A
 * 	0028 LEFT PARENTHESIS
 * 	1112 HANGUL CHOSEONG HIEUH
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 321C PARENTHESIZED HANGUL CIEUC U
 * 	0028 LEFT PARENTHESIS
 * 	110C HANGUL CHOSEONG CIEUC
 * 	116E HANGUL JUNGSEONG U
 * 	0029 RIGHT PARENTHESIS
 * 321D PARENTHESIZED KOREAN CHARACTER OJEON
 * 	0028 LEFT PARENTHESIS
 * 	110B HANGUL CHOSEONG IEUNG
 * 	1169 HANGUL JUNGSEONG O
 * 	110C HANGUL CHOSEONG CIEUC
 * 	1165 HANGUL JUNGSEONG EO
 * 	11AB HANGUL JONGSEONG NIEUN
 * 	0029 RIGHT PARENTHESIS
 * 321E PARENTHESIZED KOREAN CHARACTER O HU
 * 	0028 LEFT PARENTHESIS
 * 	110B HANGUL CHOSEONG IEUNG
 * 	1169 HANGUL JUNGSEONG O
 * 	1112 HANGUL CHOSEONG HIEUH
 * 	116E HANGUL JUNGSEONG U
 * 	0029 RIGHT PARENTHESIS
 * 3220 PARENTHESIZED IDEOGRAPH ONE
 * 	0028 LEFT PARENTHESIS
 * 	4E00 <CJK Ideograph, First>
 * 	0029 RIGHT PARENTHESIS
 * 3221 PARENTHESIZED IDEOGRAPH TWO
 * 	0028 LEFT PARENTHESIS
 * 	4E8C ??
 * 	0029 RIGHT PARENTHESIS
 * 3222 PARENTHESIZED IDEOGRAPH THREE
 * 	0028 LEFT PARENTHESIS
 * 	4E09 ??
 * 	0029 RIGHT PARENTHESIS
 * 3223 PARENTHESIZED IDEOGRAPH FOUR
 * 	0028 LEFT PARENTHESIS
 * 	56DB ??
 * 	0029 RIGHT PARENTHESIS
 * 3224 PARENTHESIZED IDEOGRAPH FIVE
 * 	0028 LEFT PARENTHESIS
 * 	4E94 ??
 * 	0029 RIGHT PARENTHESIS
 * 3225 PARENTHESIZED IDEOGRAPH SIX
 * 	0028 LEFT PARENTHESIS
 * 	516D ??
 * 	0029 RIGHT PARENTHESIS
 * 3226 PARENTHESIZED IDEOGRAPH SEVEN
 * 	0028 LEFT PARENTHESIS
 * 	4E03 ??
 * 	0029 RIGHT PARENTHESIS
 * 3227 PARENTHESIZED IDEOGRAPH EIGHT
 * 	0028 LEFT PARENTHESIS
 * 	516B ??
 * 	0029 RIGHT PARENTHESIS
 * 3228 PARENTHESIZED IDEOGRAPH NINE
 * 	0028 LEFT PARENTHESIS
 * 	4E5D ??
 * 	0029 RIGHT PARENTHESIS
 * 3229 PARENTHESIZED IDEOGRAPH TEN
 * 	0028 LEFT PARENTHESIS
 * 	5341 ??
 * 	0029 RIGHT PARENTHESIS
 * 322A PARENTHESIZED IDEOGRAPH MOON
 * 	0028 LEFT PARENTHESIS
 * 	6708 ??
 * 	0029 RIGHT PARENTHESIS
 * 322B PARENTHESIZED IDEOGRAPH FIRE
 * 	0028 LEFT PARENTHESIS
 * 	706B ??
 * 	0029 RIGHT PARENTHESIS
 * 322C PARENTHESIZED IDEOGRAPH WATER
 * 	0028 LEFT PARENTHESIS
 * 	6C34 ??
 * 	0029 RIGHT PARENTHESIS
 * 322D PARENTHESIZED IDEOGRAPH WOOD
 * 	0028 LEFT PARENTHESIS
 * 	6728 ??
 * 	0029 RIGHT PARENTHESIS
 * 322E PARENTHESIZED IDEOGRAPH METAL
 * 	0028 LEFT PARENTHESIS
 * 	91D1 ??
 * 	0029 RIGHT PARENTHESIS
 * 322F PARENTHESIZED IDEOGRAPH EARTH
 * 	0028 LEFT PARENTHESIS
 * 	571F ??
 * 	0029 RIGHT PARENTHESIS
 * 3230 PARENTHESIZED IDEOGRAPH SUN
 * 	0028 LEFT PARENTHESIS
 * 	65E5 ??
 * 	0029 RIGHT PARENTHESIS
 * 3231 PARENTHESIZED IDEOGRAPH STOCK
 * 	0028 LEFT PARENTHESIS
 * 	682A ??
 * 	0029 RIGHT PARENTHESIS
 * 3232 PARENTHESIZED IDEOGRAPH HAVE
 * 	0028 LEFT PARENTHESIS
 * 	6709 ??
 * 	0029 RIGHT PARENTHESIS
 * 3233 PARENTHESIZED IDEOGRAPH SOCIETY
 * 	0028 LEFT PARENTHESIS
 * 	793E ??
 * 	0029 RIGHT PARENTHESIS
 * 3234 PARENTHESIZED IDEOGRAPH NAME
 * 	0028 LEFT PARENTHESIS
 * 	540D ??
 * 	0029 RIGHT PARENTHESIS
 * 3235 PARENTHESIZED IDEOGRAPH SPECIAL
 * 	0028 LEFT PARENTHESIS
 * 	7279 ??
 * 	0029 RIGHT PARENTHESIS
 * 3236 PARENTHESIZED IDEOGRAPH FINANCIAL
 * 	0028 LEFT PARENTHESIS
 * 	8CA1 ??
 * 	0029 RIGHT PARENTHESIS
 * 3237 PARENTHESIZED IDEOGRAPH CONGRATULATION
 * 	0028 LEFT PARENTHESIS
 * 	795D ??
 * 	0029 RIGHT PARENTHESIS
 * 3238 PARENTHESIZED IDEOGRAPH LABOR
 * 	0028 LEFT PARENTHESIS
 * 	52B4 ??
 * 	0029 RIGHT PARENTHESIS
 * 3239 PARENTHESIZED IDEOGRAPH REPRESENT
 * 	0028 LEFT PARENTHESIS
 * 	4EE3 ??
 * 	0029 RIGHT PARENTHESIS
 * 323A PARENTHESIZED IDEOGRAPH CALL
 * 	0028 LEFT PARENTHESIS
 * 	547C ??
 * 	0029 RIGHT PARENTHESIS
 * 323B PARENTHESIZED IDEOGRAPH STUDY
 * 	0028 LEFT PARENTHESIS
 * 	5B66 ??
 * 	0029 RIGHT PARENTHESIS
 * 323C PARENTHESIZED IDEOGRAPH SUPERVISE
 * 	0028 LEFT PARENTHESIS
 * 	76E3 ??
 * 	0029 RIGHT PARENTHESIS
 * 323D PARENTHESIZED IDEOGRAPH ENTERPRISE
 * 	0028 LEFT PARENTHESIS
 * 	4F01 ??
 * 	0029 RIGHT PARENTHESIS
 * 323E PARENTHESIZED IDEOGRAPH RESOURCE
 * 	0028 LEFT PARENTHESIS
 * 	8CC7 ??
 * 	0029 RIGHT PARENTHESIS
 * 323F PARENTHESIZED IDEOGRAPH ALLIANCE
 * 	0028 LEFT PARENTHESIS
 * 	5354 ??
 * 	0029 RIGHT PARENTHESIS
 * 3240 PARENTHESIZED IDEOGRAPH FESTIVAL
 * 	0028 LEFT PARENTHESIS
 * 	796D ??
 * 	0029 RIGHT PARENTHESIS
 * 3241 PARENTHESIZED IDEOGRAPH REST
 * 	0028 LEFT PARENTHESIS
 * 	4F11 ??
 * 	0029 RIGHT PARENTHESIS
 * 3242 PARENTHESIZED IDEOGRAPH SELF
 * 	0028 LEFT PARENTHESIS
 * 	81EA ??
 * 	0029 RIGHT PARENTHESIS
 * 3243 PARENTHESIZED IDEOGRAPH REACH
 * 	0028 LEFT PARENTHESIS
 * 	81F3 ??
 * 	0029 RIGHT PARENTHESIS
 * 3250 PARTNERSHIP SIGN
 * 	0050 LATIN CAPITAL LETTER P
 * 	0054 LATIN CAPITAL LETTER T
 * 	0045 LATIN CAPITAL LETTER E
 * 3251 CIRCLED NUMBER TWENTY ONE
 * 	0032 DIGIT TWO
 * 	0031 DIGIT ONE
 * 3252 CIRCLED NUMBER TWENTY TWO
 * 	0032 DIGIT TWO
 * 	0032 DIGIT TWO
 * 3253 CIRCLED NUMBER TWENTY THREE
 * 	0032 DIGIT TWO
 * 	0033 DIGIT THREE
 * 3254 CIRCLED NUMBER TWENTY FOUR
 * 	0032 DIGIT TWO
 * 	0034 DIGIT FOUR
 * 3255 CIRCLED NUMBER TWENTY FIVE
 * 	0032 DIGIT TWO
 * 	0035 DIGIT FIVE
 * 3256 CIRCLED NUMBER TWENTY SIX
 * 	0032 DIGIT TWO
 * 	0036 DIGIT SIX
 * 3257 CIRCLED NUMBER TWENTY SEVEN
 * 	0032 DIGIT TWO
 * 	0037 DIGIT SEVEN
 * 3258 CIRCLED NUMBER TWENTY EIGHT
 * 	0032 DIGIT TWO
 * 	0038 DIGIT EIGHT
 * 3259 CIRCLED NUMBER TWENTY NINE
 * 	0032 DIGIT TWO
 * 	0039 DIGIT NINE
 * 325A CIRCLED NUMBER THIRTY
 * 	0033 DIGIT THREE
 * 	0030 DIGIT ZERO
 * 325B CIRCLED NUMBER THIRTY ONE
 * 	0033 DIGIT THREE
 * 	0031 DIGIT ONE
 * 325C CIRCLED NUMBER THIRTY TWO
 * 	0033 DIGIT THREE
 * 	0032 DIGIT TWO
 * 325D CIRCLED NUMBER THIRTY THREE
 * 	0033 DIGIT THREE
 * 	0033 DIGIT THREE
 * 325E CIRCLED NUMBER THIRTY FOUR
 * 	0033 DIGIT THREE
 * 	0034 DIGIT FOUR
 * 325F CIRCLED NUMBER THIRTY FIVE
 * 	0033 DIGIT THREE
 * 	0035 DIGIT FIVE
 * 3260 CIRCLED HANGUL KIYEOK
 * 	1100 HANGUL CHOSEONG KIYEOK
 * 3261 CIRCLED HANGUL NIEUN
 * 	1102 HANGUL CHOSEONG NIEUN
 * 3262 CIRCLED HANGUL TIKEUT
 * 	1103 HANGUL CHOSEONG TIKEUT
 * 3263 CIRCLED HANGUL RIEUL
 * 	1105 HANGUL CHOSEONG RIEUL
 * 3264 CIRCLED HANGUL MIEUM
 * 	1106 HANGUL CHOSEONG MIEUM
 * 3265 CIRCLED HANGUL PIEUP
 * 	1107 HANGUL CHOSEONG PIEUP
 * 3266 CIRCLED HANGUL SIOS
 * 	1109 HANGUL CHOSEONG SIOS
 * 3267 CIRCLED HANGUL IEUNG
 * 	110B HANGUL CHOSEONG IEUNG
 * 3268 CIRCLED HANGUL CIEUC
 * 	110C HANGUL CHOSEONG CIEUC
 * 3269 CIRCLED HANGUL CHIEUCH
 * 	110E HANGUL CHOSEONG CHIEUCH
 * 326A CIRCLED HANGUL KHIEUKH
 * 	110F HANGUL CHOSEONG KHIEUKH
 * 326B CIRCLED HANGUL THIEUTH
 * 	1110 HANGUL CHOSEONG THIEUTH
 * 326C CIRCLED HANGUL PHIEUPH
 * 	1111 HANGUL CHOSEONG PHIEUPH
 * 326D CIRCLED HANGUL HIEUH
 * 	1112 HANGUL CHOSEONG HIEUH
 * 326E CIRCLED HANGUL KIYEOK A
 * 	1100 HANGUL CHOSEONG KIYEOK
 * 	1161 HANGUL JUNGSEONG A
 * 326F CIRCLED HANGUL NIEUN A
 * 	1102 HANGUL CHOSEONG NIEUN
 * 	1161 HANGUL JUNGSEONG A
 * 3270 CIRCLED HANGUL TIKEUT A
 * 	1103 HANGUL CHOSEONG TIKEUT
 * 	1161 HANGUL JUNGSEONG A
 * 3271 CIRCLED HANGUL RIEUL A
 * 	1105 HANGUL CHOSEONG RIEUL
 * 	1161 HANGUL JUNGSEONG A
 * 3272 CIRCLED HANGUL MIEUM A
 * 	1106 HANGUL CHOSEONG MIEUM
 * 	1161 HANGUL JUNGSEONG A
 * 3273 CIRCLED HANGUL PIEUP A
 * 	1107 HANGUL CHOSEONG PIEUP
 * 	1161 HANGUL JUNGSEONG A
 * 3274 CIRCLED HANGUL SIOS A
 * 	1109 HANGUL CHOSEONG SIOS
 * 	1161 HANGUL JUNGSEONG A
 * 3275 CIRCLED HANGUL IEUNG A
 * 	110B HANGUL CHOSEONG IEUNG
 * 	1161 HANGUL JUNGSEONG A
 * 3276 CIRCLED HANGUL CIEUC A
 * 	110C HANGUL CHOSEONG CIEUC
 * 	1161 HANGUL JUNGSEONG A
 * 3277 CIRCLED HANGUL CHIEUCH A
 * 	110E HANGUL CHOSEONG CHIEUCH
 * 	1161 HANGUL JUNGSEONG A
 * 3278 CIRCLED HANGUL KHIEUKH A
 * 	110F HANGUL CHOSEONG KHIEUKH
 * 	1161 HANGUL JUNGSEONG A
 * 3279 CIRCLED HANGUL THIEUTH A
 * 	1110 HANGUL CHOSEONG THIEUTH
 * 	1161 HANGUL JUNGSEONG A
 * 327A CIRCLED HANGUL PHIEUPH A
 * 	1111 HANGUL CHOSEONG PHIEUPH
 * 	1161 HANGUL JUNGSEONG A
 * 327B CIRCLED HANGUL HIEUH A
 * 	1112 HANGUL CHOSEONG HIEUH
 * 	1161 HANGUL JUNGSEONG A
 * 327C CIRCLED KOREAN CHARACTER CHAMKO
 * 	110E HANGUL CHOSEONG CHIEUCH
 * 	1161 HANGUL JUNGSEONG A
 * 	11B7 HANGUL JONGSEONG MIEUM
 * 	1100 HANGUL CHOSEONG KIYEOK
 * 	1169 HANGUL JUNGSEONG O
 * 327D CIRCLED KOREAN CHARACTER JUEUI
 * 	110C HANGUL CHOSEONG CIEUC
 * 	116E HANGUL JUNGSEONG U
 * 	110B HANGUL CHOSEONG IEUNG
 * 	1174 HANGUL JUNGSEONG YI
 * 327E CIRCLED HANGUL IEUNG U
 * 	110B HANGUL CHOSEONG IEUNG
 * 	116E HANGUL JUNGSEONG U
 * 3280 CIRCLED IDEOGRAPH ONE
 * 	4E00 <CJK Ideograph, First>
 * 3281 CIRCLED IDEOGRAPH TWO
 * 	4E8C ??
 * 3282 CIRCLED IDEOGRAPH THREE
 * 	4E09 ??
 * 3283 CIRCLED IDEOGRAPH FOUR
 * 	56DB ??
 * 3284 CIRCLED IDEOGRAPH FIVE
 * 	4E94 ??
 * 3285 CIRCLED IDEOGRAPH SIX
 * 	516D ??
 * 3286 CIRCLED IDEOGRAPH SEVEN
 * 	4E03 ??
 * 3287 CIRCLED IDEOGRAPH EIGHT
 * 	516B ??
 * 3288 CIRCLED IDEOGRAPH NINE
 * 	4E5D ??
 * 3289 CIRCLED IDEOGRAPH TEN
 * 	5341 ??
 * 328A CIRCLED IDEOGRAPH MOON
 * 	6708 ??
 * 328B CIRCLED IDEOGRAPH FIRE
 * 	706B ??
 * 328C CIRCLED IDEOGRAPH WATER
 * 	6C34 ??
 * 328D CIRCLED IDEOGRAPH WOOD
 * 	6728 ??
 * 328E CIRCLED IDEOGRAPH METAL
 * 	91D1 ??
 * 328F CIRCLED IDEOGRAPH EARTH
 * 	571F ??
 * 3290 CIRCLED IDEOGRAPH SUN
 * 	65E5 ??
 * 3291 CIRCLED IDEOGRAPH STOCK
 * 	682A ??
 * 3292 CIRCLED IDEOGRAPH HAVE
 * 	6709 ??
 * 3293 CIRCLED IDEOGRAPH SOCIETY
 * 	793E ??
 * 3294 CIRCLED IDEOGRAPH NAME
 * 	540D ??
 * 3295 CIRCLED IDEOGRAPH SPECIAL
 * 	7279 ??
 * 3296 CIRCLED IDEOGRAPH FINANCIAL
 * 	8CA1 ??
 * 3297 CIRCLED IDEOGRAPH CONGRATULATION
 * 	795D ??
 * 3298 CIRCLED IDEOGRAPH LABOR
 * 	52B4 ??
 * 3299 CIRCLED IDEOGRAPH SECRET
 * 	79D8 ??
 * 329A CIRCLED IDEOGRAPH MALE
 * 	7537 ??
 * 329B CIRCLED IDEOGRAPH FEMALE
 * 	5973 ??
 * 329C CIRCLED IDEOGRAPH SUITABLE
 * 	9069 ??
 * 329D CIRCLED IDEOGRAPH EXCELLENT
 * 	512A ??
 * 329E CIRCLED IDEOGRAPH PRINT
 * 	5370 ??
 * 329F CIRCLED IDEOGRAPH ATTENTION
 * 	6CE8 ??
 * 32A0 CIRCLED IDEOGRAPH ITEM
 * 	9805 ??
 * 32A1 CIRCLED IDEOGRAPH REST
 * 	4F11 ??
 * 32A2 CIRCLED IDEOGRAPH COPY
 * 	5199 ??
 * 32A3 CIRCLED IDEOGRAPH CORRECT
 * 	6B63 ??
 * 32A4 CIRCLED IDEOGRAPH HIGH
 * 	4E0A ??
 * 32A5 CIRCLED IDEOGRAPH CENTRE
 * 	4E2D ??
 * 32A6 CIRCLED IDEOGRAPH LOW
 * 	4E0B ??
 * 32A7 CIRCLED IDEOGRAPH LEFT
 * 	5DE6 ??
 * 32A8 CIRCLED IDEOGRAPH RIGHT
 * 	53F3 ??
 * 32A9 CIRCLED IDEOGRAPH MEDICINE
 * 	533B ??
 * 32AA CIRCLED IDEOGRAPH RELIGION
 * 	5B97 ??
 * 32AB CIRCLED IDEOGRAPH STUDY
 * 	5B66 ??
 * 32AC CIRCLED IDEOGRAPH SUPERVISE
 * 	76E3 ??
 * 32AD CIRCLED IDEOGRAPH ENTERPRISE
 * 	4F01 ??
 * 32AE CIRCLED IDEOGRAPH RESOURCE
 * 	8CC7 ??
 * 32AF CIRCLED IDEOGRAPH ALLIANCE
 * 	5354 ??
 * 32B0 CIRCLED IDEOGRAPH NIGHT
 * 	591C ??
 * 32B1 CIRCLED NUMBER THIRTY SIX
 * 	0033 DIGIT THREE
 * 	0036 DIGIT SIX
 * 32B2 CIRCLED NUMBER THIRTY SEVEN
 * 	0033 DIGIT THREE
 * 	0037 DIGIT SEVEN
 * 32B3 CIRCLED NUMBER THIRTY EIGHT
 * 	0033 DIGIT THREE
 * 	0038 DIGIT EIGHT
 * 32B4 CIRCLED NUMBER THIRTY NINE
 * 	0033 DIGIT THREE
 * 	0039 DIGIT NINE
 * 32B5 CIRCLED NUMBER FORTY
 * 	0034 DIGIT FOUR
 * 	0030 DIGIT ZERO
 * 32B6 CIRCLED NUMBER FORTY ONE
 * 	0034 DIGIT FOUR
 * 	0031 DIGIT ONE
 * 32B7 CIRCLED NUMBER FORTY TWO
 * 	0034 DIGIT FOUR
 * 	0032 DIGIT TWO
 * 32B8 CIRCLED NUMBER FORTY THREE
 * 	0034 DIGIT FOUR
 * 	0033 DIGIT THREE
 * 32B9 CIRCLED NUMBER FORTY FOUR
 * 	0034 DIGIT FOUR
 * 	0034 DIGIT FOUR
 * 32BA CIRCLED NUMBER FORTY FIVE
 * 	0034 DIGIT FOUR
 * 	0035 DIGIT FIVE
 * 32BB CIRCLED NUMBER FORTY SIX
 * 	0034 DIGIT FOUR
 * 	0036 DIGIT SIX
 * 32BC CIRCLED NUMBER FORTY SEVEN
 * 	0034 DIGIT FOUR
 * 	0037 DIGIT SEVEN
 * 32BD CIRCLED NUMBER FORTY EIGHT
 * 	0034 DIGIT FOUR
 * 	0038 DIGIT EIGHT
 * 32BE CIRCLED NUMBER FORTY NINE
 * 	0034 DIGIT FOUR
 * 	0039 DIGIT NINE
 * 32BF CIRCLED NUMBER FIFTY
 * 	0035 DIGIT FIVE
 * 	0030 DIGIT ZERO
 * 32C0 IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY
 * 	0031 DIGIT ONE
 * 	6708 ??
 * 32C1 IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY
 * 	0032 DIGIT TWO
 * 	6708 ??
 * 32C2 IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH
 * 	0033 DIGIT THREE
 * 	6708 ??
 * 32C3 IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL
 * 	0034 DIGIT FOUR
 * 	6708 ??
 * 32C4 IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY
 * 	0035 DIGIT FIVE
 * 	6708 ??
 * 32C5 IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE
 * 	0036 DIGIT SIX
 * 	6708 ??
 * 32C6 IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY
 * 	0037 DIGIT SEVEN
 * 	6708 ??
 * 32C7 IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST
 * 	0038 DIGIT EIGHT
 * 	6708 ??
 * 32C8 IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER
 * 	0039 DIGIT NINE
 * 	6708 ??
 * 32C9 IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER
 * 	0031 DIGIT ONE
 * 	0030 DIGIT ZERO
 * 	6708 ??
 * 32CA IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER
 * 	0031 DIGIT ONE
 * 	0031 DIGIT ONE
 * 	6708 ??
 * 32CB IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER
 * 	0031 DIGIT ONE
 * 	0032 DIGIT TWO
 * 	6708 ??
 * 32CC SQUARE HG
 * 	0048 LATIN CAPITAL LETTER H
 * 	0067 LATIN SMALL LETTER G
 * 32CD SQUARE ERG
 * 	0065 LATIN SMALL LETTER E
 * 	0072 LATIN SMALL LETTER R
 * 	0067 LATIN SMALL LETTER G
 * 32CE SQUARE EV
 * 	0065 LATIN SMALL LETTER E
 * 	0056 LATIN CAPITAL LETTER V
 * 32CF LIMITED LIABILITY SIGN
 * 	004C LATIN CAPITAL LETTER L
 * 	0054 LATIN CAPITAL LETTER T
 * 	0044 LATIN CAPITAL LETTER D
 * 32D0 CIRCLED KATAKANA A
 * 	30A2 KATAKANA LETTER A
 * 32D1 CIRCLED KATAKANA I
 * 	30A4 KATAKANA LETTER I
 * 32D2 CIRCLED KATAKANA U
 * 	30A6 KATAKANA LETTER U
 * 32D3 CIRCLED KATAKANA E
 * 	30A8 KATAKANA LETTER E
 * 32D4 CIRCLED KATAKANA O
 * 	30AA KATAKANA LETTER O
 * 32D5 CIRCLED KATAKANA KA
 * 	30AB KATAKANA LETTER KA
 * 32D6 CIRCLED KATAKANA KI
 * 	30AD KATAKANA LETTER KI
 * 32D7 CIRCLED KATAKANA KU
 * 	30AF KATAKANA LETTER KU
 * 32D8 CIRCLED KATAKANA KE
 * 	30B1 KATAKANA LETTER KE
 * 32D9 CIRCLED KATAKANA KO
 * 	30B3 KATAKANA LETTER KO
 * 32DA CIRCLED KATAKANA SA
 * 	30B5 KATAKANA LETTER SA
 * 32DB CIRCLED KATAKANA SI
 * 	30B7 KATAKANA LETTER SI
 * 32DC CIRCLED KATAKANA SU
 * 	30B9 KATAKANA LETTER SU
 * 32DD CIRCLED KATAKANA SE
 * 	30BB KATAKANA LETTER SE
 * 32DE CIRCLED KATAKANA SO
 * 	30BD KATAKANA LETTER SO
 * 32DF CIRCLED KATAKANA TA
 * 	30BF KATAKANA LETTER TA
 * 32E0 CIRCLED KATAKANA TI
 * 	30C1 KATAKANA LETTER TI
 * 32E1 CIRCLED KATAKANA TU
 * 	30C4 KATAKANA LETTER TU
 * 32E2 CIRCLED KATAKANA TE
 * 	30C6 KATAKANA LETTER TE
 * 32E3 CIRCLED KATAKANA TO
 * 	30C8 KATAKANA LETTER TO
 * 32E4 CIRCLED KATAKANA NA
 * 	30CA KATAKANA LETTER NA
 * 32E5 CIRCLED KATAKANA NI
 * 	30CB KATAKANA LETTER NI
 * 32E6 CIRCLED KATAKANA NU
 * 	30CC KATAKANA LETTER NU
 * 32E7 CIRCLED KATAKANA NE
 * 	30CD KATAKANA LETTER NE
 * 32E8 CIRCLED KATAKANA NO
 * 	30CE KATAKANA LETTER NO
 * 32E9 CIRCLED KATAKANA HA
 * 	30CF KATAKANA LETTER HA
 * 32EA CIRCLED KATAKANA HI
 * 	30D2 KATAKANA LETTER HI
 * 32EB CIRCLED KATAKANA HU
 * 	30D5 KATAKANA LETTER HU
 * 32EC CIRCLED KATAKANA HE
 * 	30D8 KATAKANA LETTER HE
 * 32ED CIRCLED KATAKANA HO
 * 	30DB KATAKANA LETTER HO
 * 32EE CIRCLED KATAKANA MA
 * 	30DE KATAKANA LETTER MA
 * 32EF CIRCLED KATAKANA MI
 * 	30DF KATAKANA LETTER MI
 * 32F0 CIRCLED KATAKANA MU
 * 	30E0 KATAKANA LETTER MU
 * 32F1 CIRCLED KATAKANA ME
 * 	30E1 KATAKANA LETTER ME
 * 32F2 CIRCLED KATAKANA MO
 * 	30E2 KATAKANA LETTER MO
 * 32F3 CIRCLED KATAKANA YA
 * 	30E4 KATAKANA LETTER YA
 * 32F4 CIRCLED KATAKANA YU
 * 	30E6 KATAKANA LETTER YU
 * 32F5 CIRCLED KATAKANA YO
 * 	30E8 KATAKANA LETTER YO
 * 32F6 CIRCLED KATAKANA RA
 * 	30E9 KATAKANA LETTER RA
 * 32F7 CIRCLED KATAKANA RI
 * 	30EA KATAKANA LETTER RI
 * 32F8 CIRCLED KATAKANA RU
 * 	30EB KATAKANA LETTER RU
 * 32F9 CIRCLED KATAKANA RE
 * 	30EC KATAKANA LETTER RE
 * 32FA CIRCLED KATAKANA RO
 * 	30ED KATAKANA LETTER RO
 * 32FB CIRCLED KATAKANA WA
 * 	30EF KATAKANA LETTER WA
 * 32FC CIRCLED KATAKANA WI
 * 	30F0 KATAKANA LETTER WI
 * 32FD CIRCLED KATAKANA WE
 * 	30F1 KATAKANA LETTER WE
 * 32FE CIRCLED KATAKANA WO
 * 	30F2 KATAKANA LETTER WO
 * 3300 SQUARE APAATO
 * 	30A2 KATAKANA LETTER A
 * 	30D1 KATAKANA LETTER PA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C8 KATAKANA LETTER TO
 * 3301 SQUARE ARUHUA
 * 	30A2 KATAKANA LETTER A
 * 	30EB KATAKANA LETTER RU
 * 	30D5 KATAKANA LETTER HU
 * 	30A1 KATAKANA LETTER SMALL A
 * 3302 SQUARE ANPEA
 * 	30A2 KATAKANA LETTER A
 * 	30F3 KATAKANA LETTER N
 * 	30DA KATAKANA LETTER PE
 * 	30A2 KATAKANA LETTER A
 * 3303 SQUARE AARU
 * 	30A2 KATAKANA LETTER A
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30EB KATAKANA LETTER RU
 * 3304 SQUARE ININGU
 * 	30A4 KATAKANA LETTER I
 * 	30CB KATAKANA LETTER NI
 * 	30F3 KATAKANA LETTER N
 * 	30B0 KATAKANA LETTER GU
 * 3305 SQUARE INTI
 * 	30A4 KATAKANA LETTER I
 * 	30F3 KATAKANA LETTER N
 * 	30C1 KATAKANA LETTER TI
 * 3306 SQUARE UON
 * 	30A6 KATAKANA LETTER U
 * 	30A9 KATAKANA LETTER SMALL O
 * 	30F3 KATAKANA LETTER N
 * 3307 SQUARE ESUKUUDO
 * 	30A8 KATAKANA LETTER E
 * 	30B9 KATAKANA LETTER SU
 * 	30AF KATAKANA LETTER KU
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C9 KATAKANA LETTER DO
 * 3308 SQUARE EEKAA
 * 	30A8 KATAKANA LETTER E
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30AB KATAKANA LETTER KA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 3309 SQUARE ONSU
 * 	30AA KATAKANA LETTER O
 * 	30F3 KATAKANA LETTER N
 * 	30B9 KATAKANA LETTER SU
 * 330A SQUARE OOMU
 * 	30AA KATAKANA LETTER O
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30E0 KATAKANA LETTER MU
 * 330B SQUARE KAIRI
 * 	30AB KATAKANA LETTER KA
 * 	30A4 KATAKANA LETTER I
 * 	30EA KATAKANA LETTER RI
 * 330C SQUARE KARATTO
 * 	30AB KATAKANA LETTER KA
 * 	30E9 KATAKANA LETTER RA
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30C8 KATAKANA LETTER TO
 * 330D SQUARE KARORII
 * 	30AB KATAKANA LETTER KA
 * 	30ED KATAKANA LETTER RO
 * 	30EA KATAKANA LETTER RI
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 330E SQUARE GARON
 * 	30AC KATAKANA LETTER GA
 * 	30ED KATAKANA LETTER RO
 * 	30F3 KATAKANA LETTER N
 * 330F SQUARE GANMA
 * 	30AC KATAKANA LETTER GA
 * 	30F3 KATAKANA LETTER N
 * 	30DE KATAKANA LETTER MA
 * 3310 SQUARE GIGA
 * 	30AE KATAKANA LETTER GI
 * 	30AC KATAKANA LETTER GA
 * 3311 SQUARE GINII
 * 	30AE KATAKANA LETTER GI
 * 	30CB KATAKANA LETTER NI
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 3312 SQUARE KYURII
 * 	30AD KATAKANA LETTER KI
 * 	30E5 KATAKANA LETTER SMALL YU
 * 	30EA KATAKANA LETTER RI
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 3313 SQUARE GIRUDAA
 * 	30AE KATAKANA LETTER GI
 * 	30EB KATAKANA LETTER RU
 * 	30C0 KATAKANA LETTER DA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 3314 SQUARE KIRO
 * 	30AD KATAKANA LETTER KI
 * 	30ED KATAKANA LETTER RO
 * 3315 SQUARE KIROGURAMU
 * 	30AD KATAKANA LETTER KI
 * 	30ED KATAKANA LETTER RO
 * 	30B0 KATAKANA LETTER GU
 * 	30E9 KATAKANA LETTER RA
 * 	30E0 KATAKANA LETTER MU
 * 3316 SQUARE KIROMEETORU
 * 	30AD KATAKANA LETTER KI
 * 	30ED KATAKANA LETTER RO
 * 	30E1 KATAKANA LETTER ME
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C8 KATAKANA LETTER TO
 * 	30EB KATAKANA LETTER RU
 * 3317 SQUARE KIROWATTO
 * 	30AD KATAKANA LETTER KI
 * 	30ED KATAKANA LETTER RO
 * 	30EF KATAKANA LETTER WA
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30C8 KATAKANA LETTER TO
 * 3318 SQUARE GURAMU
 * 	30B0 KATAKANA LETTER GU
 * 	30E9 KATAKANA LETTER RA
 * 	30E0 KATAKANA LETTER MU
 * 3319 SQUARE GURAMUTON
 * 	30B0 KATAKANA LETTER GU
 * 	30E9 KATAKANA LETTER RA
 * 	30E0 KATAKANA LETTER MU
 * 	30C8 KATAKANA LETTER TO
 * 	30F3 KATAKANA LETTER N
 * 331A SQUARE KURUZEIRO
 * 	30AF KATAKANA LETTER KU
 * 	30EB KATAKANA LETTER RU
 * 	30BC KATAKANA LETTER ZE
 * 	30A4 KATAKANA LETTER I
 * 	30ED KATAKANA LETTER RO
 * 331B SQUARE KUROONE
 * 	30AF KATAKANA LETTER KU
 * 	30ED KATAKANA LETTER RO
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30CD KATAKANA LETTER NE
 * 331C SQUARE KEESU
 * 	30B1 KATAKANA LETTER KE
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30B9 KATAKANA LETTER SU
 * 331D SQUARE KORUNA
 * 	30B3 KATAKANA LETTER KO
 * 	30EB KATAKANA LETTER RU
 * 	30CA KATAKANA LETTER NA
 * 331E SQUARE KOOPO
 * 	30B3 KATAKANA LETTER KO
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30DD KATAKANA LETTER PO
 * 331F SQUARE SAIKURU
 * 	30B5 KATAKANA LETTER SA
 * 	30A4 KATAKANA LETTER I
 * 	30AF KATAKANA LETTER KU
 * 	30EB KATAKANA LETTER RU
 * 3320 SQUARE SANTIIMU
 * 	30B5 KATAKANA LETTER SA
 * 	30F3 KATAKANA LETTER N
 * 	30C1 KATAKANA LETTER TI
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30E0 KATAKANA LETTER MU
 * 3321 SQUARE SIRINGU
 * 	30B7 KATAKANA LETTER SI
 * 	30EA KATAKANA LETTER RI
 * 	30F3 KATAKANA LETTER N
 * 	30B0 KATAKANA LETTER GU
 * 3322 SQUARE SENTI
 * 	30BB KATAKANA LETTER SE
 * 	30F3 KATAKANA LETTER N
 * 	30C1 KATAKANA LETTER TI
 * 3323 SQUARE SENTO
 * 	30BB KATAKANA LETTER SE
 * 	30F3 KATAKANA LETTER N
 * 	30C8 KATAKANA LETTER TO
 * 3324 SQUARE DAASU
 * 	30C0 KATAKANA LETTER DA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30B9 KATAKANA LETTER SU
 * 3325 SQUARE DESI
 * 	30C7 KATAKANA LETTER DE
 * 	30B7 KATAKANA LETTER SI
 * 3326 SQUARE DORU
 * 	30C9 KATAKANA LETTER DO
 * 	30EB KATAKANA LETTER RU
 * 3327 SQUARE TON
 * 	30C8 KATAKANA LETTER TO
 * 	30F3 KATAKANA LETTER N
 * 3328 SQUARE NANO
 * 	30CA KATAKANA LETTER NA
 * 	30CE KATAKANA LETTER NO
 * 3329 SQUARE NOTTO
 * 	30CE KATAKANA LETTER NO
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30C8 KATAKANA LETTER TO
 * 332A SQUARE HAITU
 * 	30CF KATAKANA LETTER HA
 * 	30A4 KATAKANA LETTER I
 * 	30C4 KATAKANA LETTER TU
 * 332B SQUARE PAASENTO
 * 	30D1 KATAKANA LETTER PA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30BB KATAKANA LETTER SE
 * 	30F3 KATAKANA LETTER N
 * 	30C8 KATAKANA LETTER TO
 * 332C SQUARE PAATU
 * 	30D1 KATAKANA LETTER PA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C4 KATAKANA LETTER TU
 * 332D SQUARE BAARERU
 * 	30D0 KATAKANA LETTER BA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30EC KATAKANA LETTER RE
 * 	30EB KATAKANA LETTER RU
 * 332E SQUARE PIASUTORU
 * 	30D4 KATAKANA LETTER PI
 * 	30A2 KATAKANA LETTER A
 * 	30B9 KATAKANA LETTER SU
 * 	30C8 KATAKANA LETTER TO
 * 	30EB KATAKANA LETTER RU
 * 332F SQUARE PIKURU
 * 	30D4 KATAKANA LETTER PI
 * 	30AF KATAKANA LETTER KU
 * 	30EB KATAKANA LETTER RU
 * 3330 SQUARE PIKO
 * 	30D4 KATAKANA LETTER PI
 * 	30B3 KATAKANA LETTER KO
 * 3331 SQUARE BIRU
 * 	30D3 KATAKANA LETTER BI
 * 	30EB KATAKANA LETTER RU
 * 3332 SQUARE HUARADDO
 * 	30D5 KATAKANA LETTER HU
 * 	30A1 KATAKANA LETTER SMALL A
 * 	30E9 KATAKANA LETTER RA
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30C9 KATAKANA LETTER DO
 * 3333 SQUARE HUIITO
 * 	30D5 KATAKANA LETTER HU
 * 	30A3 KATAKANA LETTER SMALL I
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C8 KATAKANA LETTER TO
 * 3334 SQUARE BUSSYERU
 * 	30D6 KATAKANA LETTER BU
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30B7 KATAKANA LETTER SI
 * 	30A7 KATAKANA LETTER SMALL E
 * 	30EB KATAKANA LETTER RU
 * 3335 SQUARE HURAN
 * 	30D5 KATAKANA LETTER HU
 * 	30E9 KATAKANA LETTER RA
 * 	30F3 KATAKANA LETTER N
 * 3336 SQUARE HEKUTAARU
 * 	30D8 KATAKANA LETTER HE
 * 	30AF KATAKANA LETTER KU
 * 	30BF KATAKANA LETTER TA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30EB KATAKANA LETTER RU
 * 3337 SQUARE PESO
 * 	30DA KATAKANA LETTER PE
 * 	30BD KATAKANA LETTER SO
 * 3338 SQUARE PENIHI
 * 	30DA KATAKANA LETTER PE
 * 	30CB KATAKANA LETTER NI
 * 	30D2 KATAKANA LETTER HI
 * 3339 SQUARE HERUTU
 * 	30D8 KATAKANA LETTER HE
 * 	30EB KATAKANA LETTER RU
 * 	30C4 KATAKANA LETTER TU
 * 333A SQUARE PENSU
 * 	30DA KATAKANA LETTER PE
 * 	30F3 KATAKANA LETTER N
 * 	30B9 KATAKANA LETTER SU
 * 333B SQUARE PEEZI
 * 	30DA KATAKANA LETTER PE
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30B8 KATAKANA LETTER ZI
 * 333C SQUARE BEETA
 * 	30D9 KATAKANA LETTER BE
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30BF KATAKANA LETTER TA
 * 333D SQUARE POINTO
 * 	30DD KATAKANA LETTER PO
 * 	30A4 KATAKANA LETTER I
 * 	30F3 KATAKANA LETTER N
 * 	30C8 KATAKANA LETTER TO
 * 333E SQUARE BORUTO
 * 	30DC KATAKANA LETTER BO
 * 	30EB KATAKANA LETTER RU
 * 	30C8 KATAKANA LETTER TO
 * 333F SQUARE HON
 * 	30DB KATAKANA LETTER HO
 * 	30F3 KATAKANA LETTER N
 * 3340 SQUARE PONDO
 * 	30DD KATAKANA LETTER PO
 * 	30F3 KATAKANA LETTER N
 * 	30C9 KATAKANA LETTER DO
 * 3341 SQUARE HOORU
 * 	30DB KATAKANA LETTER HO
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30EB KATAKANA LETTER RU
 * 3342 SQUARE HOON
 * 	30DB KATAKANA LETTER HO
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30F3 KATAKANA LETTER N
 * 3343 SQUARE MAIKURO
 * 	30DE KATAKANA LETTER MA
 * 	30A4 KATAKANA LETTER I
 * 	30AF KATAKANA LETTER KU
 * 	30ED KATAKANA LETTER RO
 * 3344 SQUARE MAIRU
 * 	30DE KATAKANA LETTER MA
 * 	30A4 KATAKANA LETTER I
 * 	30EB KATAKANA LETTER RU
 * 3345 SQUARE MAHHA
 * 	30DE KATAKANA LETTER MA
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30CF KATAKANA LETTER HA
 * 3346 SQUARE MARUKU
 * 	30DE KATAKANA LETTER MA
 * 	30EB KATAKANA LETTER RU
 * 	30AF KATAKANA LETTER KU
 * 3347 SQUARE MANSYON
 * 	30DE KATAKANA LETTER MA
 * 	30F3 KATAKANA LETTER N
 * 	30B7 KATAKANA LETTER SI
 * 	30E7 KATAKANA LETTER SMALL YO
 * 	30F3 KATAKANA LETTER N
 * 3348 SQUARE MIKURON
 * 	30DF KATAKANA LETTER MI
 * 	30AF KATAKANA LETTER KU
 * 	30ED KATAKANA LETTER RO
 * 	30F3 KATAKANA LETTER N
 * 3349 SQUARE MIRI
 * 	30DF KATAKANA LETTER MI
 * 	30EA KATAKANA LETTER RI
 * 334A SQUARE MIRIBAARU
 * 	30DF KATAKANA LETTER MI
 * 	30EA KATAKANA LETTER RI
 * 	30D0 KATAKANA LETTER BA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30EB KATAKANA LETTER RU
 * 334B SQUARE MEGA
 * 	30E1 KATAKANA LETTER ME
 * 	30AC KATAKANA LETTER GA
 * 334C SQUARE MEGATON
 * 	30E1 KATAKANA LETTER ME
 * 	30AC KATAKANA LETTER GA
 * 	30C8 KATAKANA LETTER TO
 * 	30F3 KATAKANA LETTER N
 * 334D SQUARE MEETORU
 * 	30E1 KATAKANA LETTER ME
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C8 KATAKANA LETTER TO
 * 	30EB KATAKANA LETTER RU
 * 334E SQUARE YAADO
 * 	30E4 KATAKANA LETTER YA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C9 KATAKANA LETTER DO
 * 334F SQUARE YAARU
 * 	30E4 KATAKANA LETTER YA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30EB KATAKANA LETTER RU
 * 3350 SQUARE YUAN
 * 	30E6 KATAKANA LETTER YU
 * 	30A2 KATAKANA LETTER A
 * 	30F3 KATAKANA LETTER N
 * 3351 SQUARE RITTORU
 * 	30EA KATAKANA LETTER RI
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30C8 KATAKANA LETTER TO
 * 	30EB KATAKANA LETTER RU
 * 3352 SQUARE RIRA
 * 	30EA KATAKANA LETTER RI
 * 	30E9 KATAKANA LETTER RA
 * 3353 SQUARE RUPII
 * 	30EB KATAKANA LETTER RU
 * 	30D4 KATAKANA LETTER PI
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 3354 SQUARE RUUBURU
 * 	30EB KATAKANA LETTER RU
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30D6 KATAKANA LETTER BU
 * 	30EB KATAKANA LETTER RU
 * 3355 SQUARE REMU
 * 	30EC KATAKANA LETTER RE
 * 	30E0 KATAKANA LETTER MU
 * 3356 SQUARE RENTOGEN
 * 	30EC KATAKANA LETTER RE
 * 	30F3 KATAKANA LETTER N
 * 	30C8 KATAKANA LETTER TO
 * 	30B2 KATAKANA LETTER GE
 * 	30F3 KATAKANA LETTER N
 * 3357 SQUARE WATTO
 * 	30EF KATAKANA LETTER WA
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30C8 KATAKANA LETTER TO
 * 3358 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO
 * 	0030 DIGIT ZERO
 * 	70B9 ??
 * 3359 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE
 * 	0031 DIGIT ONE
 * 	70B9 ??
 * 335A IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO
 * 	0032 DIGIT TWO
 * 	70B9 ??
 * 335B IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE
 * 	0033 DIGIT THREE
 * 	70B9 ??
 * 335C IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR
 * 	0034 DIGIT FOUR
 * 	70B9 ??
 * 335D IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE
 * 	0035 DIGIT FIVE
 * 	70B9 ??
 * 335E IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX
 * 	0036 DIGIT SIX
 * 	70B9 ??
 * 335F IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN
 * 	0037 DIGIT SEVEN
 * 	70B9 ??
 * 3360 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT
 * 	0038 DIGIT EIGHT
 * 	70B9 ??
 * 3361 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE
 * 	0039 DIGIT NINE
 * 	70B9 ??
 * 3362 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN
 * 	0031 DIGIT ONE
 * 	0030 DIGIT ZERO
 * 	70B9 ??
 * 3363 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN
 * 	0031 DIGIT ONE
 * 	0031 DIGIT ONE
 * 	70B9 ??
 * 3364 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE
 * 	0031 DIGIT ONE
 * 	0032 DIGIT TWO
 * 	70B9 ??
 * 3365 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN
 * 	0031 DIGIT ONE
 * 	0033 DIGIT THREE
 * 	70B9 ??
 * 3366 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN
 * 	0031 DIGIT ONE
 * 	0034 DIGIT FOUR
 * 	70B9 ??
 * 3367 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN
 * 	0031 DIGIT ONE
 * 	0035 DIGIT FIVE
 * 	70B9 ??
 * 3368 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN
 * 	0031 DIGIT ONE
 * 	0036 DIGIT SIX
 * 	70B9 ??
 * 3369 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN
 * 	0031 DIGIT ONE
 * 	0037 DIGIT SEVEN
 * 	70B9 ??
 * 336A IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN
 * 	0031 DIGIT ONE
 * 	0038 DIGIT EIGHT
 * 	70B9 ??
 * 336B IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN
 * 	0031 DIGIT ONE
 * 	0039 DIGIT NINE
 * 	70B9 ??
 * 336C IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY
 * 	0032 DIGIT TWO
 * 	0030 DIGIT ZERO
 * 	70B9 ??
 * 336D IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE
 * 	0032 DIGIT TWO
 * 	0031 DIGIT ONE
 * 	70B9 ??
 * 336E IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO
 * 	0032 DIGIT TWO
 * 	0032 DIGIT TWO
 * 	70B9 ??
 * 336F IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE
 * 	0032 DIGIT TWO
 * 	0033 DIGIT THREE
 * 	70B9 ??
 * 3370 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR
 * 	0032 DIGIT TWO
 * 	0034 DIGIT FOUR
 * 	70B9 ??
 * 3371 SQUARE HPA
 * 	0068 LATIN SMALL LETTER H
 * 	0050 LATIN CAPITAL LETTER P
 * 	0061 LATIN SMALL LETTER A
 * 3372 SQUARE DA
 * 	0064 LATIN SMALL LETTER D
 * 	0061 LATIN SMALL LETTER A
 * 3373 SQUARE AU
 * 	0041 LATIN CAPITAL LETTER A
 * 	0055 LATIN CAPITAL LETTER U
 * 3374 SQUARE BAR
 * 	0062 LATIN SMALL LETTER B
 * 	0061 LATIN SMALL LETTER A
 * 	0072 LATIN SMALL LETTER R
 * 3375 SQUARE OV
 * 	006F LATIN SMALL LETTER O
 * 	0056 LATIN CAPITAL LETTER V
 * 3376 SQUARE PC
 * 	0070 LATIN SMALL LETTER P
 * 	0063 LATIN SMALL LETTER C
 * 3377 SQUARE DM
 * 	0064 LATIN SMALL LETTER D
 * 	006D LATIN SMALL LETTER M
 * 3378 SQUARE DM SQUARED
 * 	0064 LATIN SMALL LETTER D
 * 	006D LATIN SMALL LETTER M
 * 	0032 DIGIT TWO
 * 3379 SQUARE DM CUBED
 * 	0064 LATIN SMALL LETTER D
 * 	006D LATIN SMALL LETTER M
 * 	0033 DIGIT THREE
 * 337A SQUARE IU
 * 	0049 LATIN CAPITAL LETTER I
 * 	0055 LATIN CAPITAL LETTER U
 * 337B SQUARE ERA NAME HEISEI
 * 	5E73 ??
 * 	6210 ??
 * 337C SQUARE ERA NAME SYOUWA
 * 	662D ??
 * 	548C ??
 * 337D SQUARE ERA NAME TAISYOU
 * 	5927 ??
 * 	6B63 ??
 * 337E SQUARE ERA NAME MEIZI
 * 	660E ??
 * 	6CBB ??
 * 337F SQUARE CORPORATION
 * 	682A ??
 * 	5F0F ??
 * 	4F1A ??
 * 	793E ??
 * 3380 SQUARE PA AMPS
 * 	0070 LATIN SMALL LETTER P
 * 	0041 LATIN CAPITAL LETTER A
 * 3381 SQUARE NA
 * 	006E LATIN SMALL LETTER N
 * 	0041 LATIN CAPITAL LETTER A
 * 3382 SQUARE MU A
 * 	03BC GREEK SMALL LETTER MU
 * 	0041 LATIN CAPITAL LETTER A
 * 3383 SQUARE MA
 * 	006D LATIN SMALL LETTER M
 * 	0041 LATIN CAPITAL LETTER A
 * 3384 SQUARE KA
 * 	006B LATIN SMALL LETTER K
 * 	0041 LATIN CAPITAL LETTER A
 * 3385 SQUARE KB
 * 	004B LATIN CAPITAL LETTER K
 * 	0042 LATIN CAPITAL LETTER B
 * 3386 SQUARE MB
 * 	004D LATIN CAPITAL LETTER M
 * 	0042 LATIN CAPITAL LETTER B
 * 3387 SQUARE GB
 * 	0047 LATIN CAPITAL LETTER G
 * 	0042 LATIN CAPITAL LETTER B
 * 3388 SQUARE CAL
 * 	0063 LATIN SMALL LETTER C
 * 	0061 LATIN SMALL LETTER A
 * 	006C LATIN SMALL LETTER L
 * 3389 SQUARE KCAL
 * 	006B LATIN SMALL LETTER K
 * 	0063 LATIN SMALL LETTER C
 * 	0061 LATIN SMALL LETTER A
 * 	006C LATIN SMALL LETTER L
 * 338A SQUARE PF
 * 	0070 LATIN SMALL LETTER P
 * 	0046 LATIN CAPITAL LETTER F
 * 338B SQUARE NF
 * 	006E LATIN SMALL LETTER N
 * 	0046 LATIN CAPITAL LETTER F
 * 338C SQUARE MU F
 * 	03BC GREEK SMALL LETTER MU
 * 	0046 LATIN CAPITAL LETTER F
 * 338D SQUARE MU G
 * 	03BC GREEK SMALL LETTER MU
 * 	0067 LATIN SMALL LETTER G
 * 338E SQUARE MG
 * 	006D LATIN SMALL LETTER M
 * 	0067 LATIN SMALL LETTER G
 * 338F SQUARE KG
 * 	006B LATIN SMALL LETTER K
 * 	0067 LATIN SMALL LETTER G
 * 3390 SQUARE HZ
 * 	0048 LATIN CAPITAL LETTER H
 * 	007A LATIN SMALL LETTER Z
 * 3391 SQUARE KHZ
 * 	006B LATIN SMALL LETTER K
 * 	0048 LATIN CAPITAL LETTER H
 * 	007A LATIN SMALL LETTER Z
 * 3392 SQUARE MHZ
 * 	004D LATIN CAPITAL LETTER M
 * 	0048 LATIN CAPITAL LETTER H
 * 	007A LATIN SMALL LETTER Z
 * 3393 SQUARE GHZ
 * 	0047 LATIN CAPITAL LETTER G
 * 	0048 LATIN CAPITAL LETTER H
 * 	007A LATIN SMALL LETTER Z
 * 3394 SQUARE THZ
 * 	0054 LATIN CAPITAL LETTER T
 * 	0048 LATIN CAPITAL LETTER H
 * 	007A LATIN SMALL LETTER Z
 * 3395 SQUARE MU L
 * 	03BC GREEK SMALL LETTER MU
 * 	006C LATIN SMALL LETTER L
 * 3396 SQUARE ML
 * 	006D LATIN SMALL LETTER M
 * 	006C LATIN SMALL LETTER L
 * 3397 SQUARE DL
 * 	0064 LATIN SMALL LETTER D
 * 	006C LATIN SMALL LETTER L
 * 3398 SQUARE KL
 * 	006B LATIN SMALL LETTER K
 * 	006C LATIN SMALL LETTER L
 * 3399 SQUARE FM
 * 	0066 LATIN SMALL LETTER F
 * 	006D LATIN SMALL LETTER M
 * 339A SQUARE NM
 * 	006E LATIN SMALL LETTER N
 * 	006D LATIN SMALL LETTER M
 * 339B SQUARE MU M
 * 	03BC GREEK SMALL LETTER MU
 * 	006D LATIN SMALL LETTER M
 * 339C SQUARE MM
 * 	006D LATIN SMALL LETTER M
 * 	006D LATIN SMALL LETTER M
 * 339D SQUARE CM
 * 	0063 LATIN SMALL LETTER C
 * 	006D LATIN SMALL LETTER M
 * 339E SQUARE KM
 * 	006B LATIN SMALL LETTER K
 * 	006D LATIN SMALL LETTER M
 * 339F SQUARE MM SQUARED
 * 	006D LATIN SMALL LETTER M
 * 	006D LATIN SMALL LETTER M
 * 	0032 DIGIT TWO
 * 33A0 SQUARE CM SQUARED
 * 	0063 LATIN SMALL LETTER C
 * 	006D LATIN SMALL LETTER M
 * 	0032 DIGIT TWO
 * 33A1 SQUARE M SQUARED
 * 	006D LATIN SMALL LETTER M
 * 	0032 DIGIT TWO
 * 33A2 SQUARE KM SQUARED
 * 	006B LATIN SMALL LETTER K
 * 	006D LATIN SMALL LETTER M
 * 	0032 DIGIT TWO
 * 33A3 SQUARE MM CUBED
 * 	006D LATIN SMALL LETTER M
 * 	006D LATIN SMALL LETTER M
 * 	0033 DIGIT THREE
 * 33A4 SQUARE CM CUBED
 * 	0063 LATIN SMALL LETTER C
 * 	006D LATIN SMALL LETTER M
 * 	0033 DIGIT THREE
 * 33A5 SQUARE M CUBED
 * 	006D LATIN SMALL LETTER M
 * 	0033 DIGIT THREE
 * 33A6 SQUARE KM CUBED
 * 	006B LATIN SMALL LETTER K
 * 	006D LATIN SMALL LETTER M
 * 	0033 DIGIT THREE
 * 33A7 SQUARE M OVER S
 * 	006D LATIN SMALL LETTER M
 * 	2215 DIVISION SLASH
 * 	0073 LATIN SMALL LETTER S
 * 33A8 SQUARE M OVER S SQUARED
 * 	006D LATIN SMALL LETTER M
 * 	2215 DIVISION SLASH
 * 	0073 LATIN SMALL LETTER S
 * 	0032 DIGIT TWO
 * 33A9 SQUARE PA
 * 	0050 LATIN CAPITAL LETTER P
 * 	0061 LATIN SMALL LETTER A
 * 33AA SQUARE KPA
 * 	006B LATIN SMALL LETTER K
 * 	0050 LATIN CAPITAL LETTER P
 * 	0061 LATIN SMALL LETTER A
 * 33AB SQUARE MPA
 * 	004D LATIN CAPITAL LETTER M
 * 	0050 LATIN CAPITAL LETTER P
 * 	0061 LATIN SMALL LETTER A
 * 33AC SQUARE GPA
 * 	0047 LATIN CAPITAL LETTER G
 * 	0050 LATIN CAPITAL LETTER P
 * 	0061 LATIN SMALL LETTER A
 * 33AD SQUARE RAD
 * 	0072 LATIN SMALL LETTER R
 * 	0061 LATIN SMALL LETTER A
 * 	0064 LATIN SMALL LETTER D
 * 33AE SQUARE RAD OVER S
 * 	0072 LATIN SMALL LETTER R
 * 	0061 LATIN SMALL LETTER A
 * 	0064 LATIN SMALL LETTER D
 * 	2215 DIVISION SLASH
 * 	0073 LATIN SMALL LETTER S
 * 33AF SQUARE RAD OVER S SQUARED
 * 	0072 LATIN SMALL LETTER R
 * 	0061 LATIN SMALL LETTER A
 * 	0064 LATIN SMALL LETTER D
 * 	2215 DIVISION SLASH
 * 	0073 LATIN SMALL LETTER S
 * 	0032 DIGIT TWO
 * 33B0 SQUARE PS
 * 	0070 LATIN SMALL LETTER P
 * 	0073 LATIN SMALL LETTER S
 * 33B1 SQUARE NS
 * 	006E LATIN SMALL LETTER N
 * 	0073 LATIN SMALL LETTER S
 * 33B2 SQUARE MU S
 * 	03BC GREEK SMALL LETTER MU
 * 	0073 LATIN SMALL LETTER S
 * 33B3 SQUARE MS
 * 	006D LATIN SMALL LETTER M
 * 	0073 LATIN SMALL LETTER S
 * 33B4 SQUARE PV
 * 	0070 LATIN SMALL LETTER P
 * 	0056 LATIN CAPITAL LETTER V
 * 33B5 SQUARE NV
 * 	006E LATIN SMALL LETTER N
 * 	0056 LATIN CAPITAL LETTER V
 * 33B6 SQUARE MU V
 * 	03BC GREEK SMALL LETTER MU
 * 	0056 LATIN CAPITAL LETTER V
 * 33B7 SQUARE MV
 * 	006D LATIN SMALL LETTER M
 * 	0056 LATIN CAPITAL LETTER V
 * 33B8 SQUARE KV
 * 	006B LATIN SMALL LETTER K
 * 	0056 LATIN CAPITAL LETTER V
 * 33B9 SQUARE MV MEGA
 * 	004D LATIN CAPITAL LETTER M
 * 	0056 LATIN CAPITAL LETTER V
 * 33BA SQUARE PW
 * 	0070 LATIN SMALL LETTER P
 * 	0057 LATIN CAPITAL LETTER W
 * 33BB SQUARE NW
 * 	006E LATIN SMALL LETTER N
 * 	0057 LATIN CAPITAL LETTER W
 * 33BC SQUARE MU W
 * 	03BC GREEK SMALL LETTER MU
 * 	0057 LATIN CAPITAL LETTER W
 * 33BD SQUARE MW
 * 	006D LATIN SMALL LETTER M
 * 	0057 LATIN CAPITAL LETTER W
 * 33BE SQUARE KW
 * 	006B LATIN SMALL LETTER K
 * 	0057 LATIN CAPITAL LETTER W
 * 33BF SQUARE MW MEGA
 * 	004D LATIN CAPITAL LETTER M
 * 	0057 LATIN CAPITAL LETTER W
 * 33C0 SQUARE K OHM
 * 	006B LATIN SMALL LETTER K
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 33C1 SQUARE M OHM
 * 	004D LATIN CAPITAL LETTER M
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 33C2 SQUARE AM
 * 	0061 LATIN SMALL LETTER A
 * 	002E FULL STOP
 * 	006D LATIN SMALL LETTER M
 * 	002E FULL STOP
 * 33C3 SQUARE BQ
 * 	0042 LATIN CAPITAL LETTER B
 * 	0071 LATIN SMALL LETTER Q
 * 33C4 SQUARE CC
 * 	0063 LATIN SMALL LETTER C
 * 	0063 LATIN SMALL LETTER C
 * 33C5 SQUARE CD
 * 	0063 LATIN SMALL LETTER C
 * 	0064 LATIN SMALL LETTER D
 * 33C6 SQUARE C OVER KG
 * 	0043 LATIN CAPITAL LETTER C
 * 	2215 DIVISION SLASH
 * 	006B LATIN SMALL LETTER K
 * 	0067 LATIN SMALL LETTER G
 * 33C7 SQUARE CO
 * 	0043 LATIN CAPITAL LETTER C
 * 	006F LATIN SMALL LETTER O
 * 	002E FULL STOP
 * 33C8 SQUARE DB
 * 	0064 LATIN SMALL LETTER D
 * 	0042 LATIN CAPITAL LETTER B
 * 33C9 SQUARE GY
 * 	0047 LATIN CAPITAL LETTER G
 * 	0079 LATIN SMALL LETTER Y
 * 33CA SQUARE HA
 * 	0068 LATIN SMALL LETTER H
 * 	0061 LATIN SMALL LETTER A
 * 33CB SQUARE HP
 * 	0048 LATIN CAPITAL LETTER H
 * 	0050 LATIN CAPITAL LETTER P
 * 33CC SQUARE IN
 * 	0069 LATIN SMALL LETTER I
 * 	006E LATIN SMALL LETTER N
 * 33CD SQUARE KK
 * 	004B LATIN CAPITAL LETTER K
 * 	004B LATIN CAPITAL LETTER K
 * 33CE SQUARE KM CAPITAL
 * 	004B LATIN CAPITAL LETTER K
 * 	004D LATIN CAPITAL LETTER M
 * 33CF SQUARE KT
 * 	006B LATIN SMALL LETTER K
 * 	0074 LATIN SMALL LETTER T
 * 33D0 SQUARE LM
 * 	006C LATIN SMALL LETTER L
 * 	006D LATIN SMALL LETTER M
 * 33D1 SQUARE LN
 * 	006C LATIN SMALL LETTER L
 * 	006E LATIN SMALL LETTER N
 * 33D2 SQUARE LOG
 * 	006C LATIN SMALL LETTER L
 * 	006F LATIN SMALL LETTER O
 * 	0067 LATIN SMALL LETTER G
 * 33D3 SQUARE LX
 * 	006C LATIN SMALL LETTER L
 * 	0078 LATIN SMALL LETTER X
 * 33D4 SQUARE MB SMALL
 * 	006D LATIN SMALL LETTER M
 * 	0062 LATIN SMALL LETTER B
 * 33D5 SQUARE MIL
 * 	006D LATIN SMALL LETTER M
 * 	0069 LATIN SMALL LETTER I
 * 	006C LATIN SMALL LETTER L
 * 33D6 SQUARE MOL
 * 	006D LATIN SMALL LETTER M
 * 	006F LATIN SMALL LETTER O
 * 	006C LATIN SMALL LETTER L
 * 33D7 SQUARE PH
 * 	0050 LATIN CAPITAL LETTER P
 * 	0048 LATIN CAPITAL LETTER H
 * 33D8 SQUARE PM
 * 	0070 LATIN SMALL LETTER P
 * 	002E FULL STOP
 * 	006D LATIN SMALL LETTER M
 * 	002E FULL STOP
 * 33D9 SQUARE PPM
 * 	0050 LATIN CAPITAL LETTER P
 * 	0050 LATIN CAPITAL LETTER P
 * 	004D LATIN CAPITAL LETTER M
 * 33DA SQUARE PR
 * 	0050 LATIN CAPITAL LETTER P
 * 	0052 LATIN CAPITAL LETTER R
 * 33DB SQUARE SR
 * 	0073 LATIN SMALL LETTER S
 * 	0072 LATIN SMALL LETTER R
 * 33DC SQUARE SV
 * 	0053 LATIN CAPITAL LETTER S
 * 	0076 LATIN SMALL LETTER V
 * 33DD SQUARE WB
 * 	0057 LATIN CAPITAL LETTER W
 * 	0062 LATIN SMALL LETTER B
 * 33DE SQUARE V OVER M
 * 	0056 LATIN CAPITAL LETTER V
 * 	2215 DIVISION SLASH
 * 	006D LATIN SMALL LETTER M
 * 33DF SQUARE A OVER M
 * 	0041 LATIN CAPITAL LETTER A
 * 	2215 DIVISION SLASH
 * 	006D LATIN SMALL LETTER M
 * 33E0 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE
 * 	0031 DIGIT ONE
 * 	65E5 ??
 * 33E1 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO
 * 	0032 DIGIT TWO
 * 	65E5 ??
 * 33E2 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE
 * 	0033 DIGIT THREE
 * 	65E5 ??
 * 33E3 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR
 * 	0034 DIGIT FOUR
 * 	65E5 ??
 * 33E4 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE
 * 	0035 DIGIT FIVE
 * 	65E5 ??
 * 33E5 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX
 * 	0036 DIGIT SIX
 * 	65E5 ??
 * 33E6 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN
 * 	0037 DIGIT SEVEN
 * 	65E5 ??
 * 33E7 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT
 * 	0038 DIGIT EIGHT
 * 	65E5 ??
 * 33E8 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE
 * 	0039 DIGIT NINE
 * 	65E5 ??
 * 33E9 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN
 * 	0031 DIGIT ONE
 * 	0030 DIGIT ZERO
 * 	65E5 ??
 * 33EA IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN
 * 	0031 DIGIT ONE
 * 	0031 DIGIT ONE
 * 	65E5 ??
 * 33EB IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE
 * 	0031 DIGIT ONE
 * 	0032 DIGIT TWO
 * 	65E5 ??
 * 33EC IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN
 * 	0031 DIGIT ONE
 * 	0033 DIGIT THREE
 * 	65E5 ??
 * 33ED IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN
 * 	0031 DIGIT ONE
 * 	0034 DIGIT FOUR
 * 	65E5 ??
 * 33EE IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN
 * 	0031 DIGIT ONE
 * 	0035 DIGIT FIVE
 * 	65E5 ??
 * 33EF IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN
 * 	0031 DIGIT ONE
 * 	0036 DIGIT SIX
 * 	65E5 ??
 * 33F0 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN
 * 	0031 DIGIT ONE
 * 	0037 DIGIT SEVEN
 * 	65E5 ??
 * 33F1 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN
 * 	0031 DIGIT ONE
 * 	0038 DIGIT EIGHT
 * 	65E5 ??
 * 33F2 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN
 * 	0031 DIGIT ONE
 * 	0039 DIGIT NINE
 * 	65E5 ??
 * 33F3 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY
 * 	0032 DIGIT TWO
 * 	0030 DIGIT ZERO
 * 	65E5 ??
 * 33F4 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE
 * 	0032 DIGIT TWO
 * 	0031 DIGIT ONE
 * 	65E5 ??
 * 33F5 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO
 * 	0032 DIGIT TWO
 * 	0032 DIGIT TWO
 * 	65E5 ??
 * 33F6 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE
 * 	0032 DIGIT TWO
 * 	0033 DIGIT THREE
 * 	65E5 ??
 * 33F7 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR
 * 	0032 DIGIT TWO
 * 	0034 DIGIT FOUR
 * 	65E5 ??
 * 33F8 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE
 * 	0032 DIGIT TWO
 * 	0035 DIGIT FIVE
 * 	65E5 ??
 * 33F9 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX
 * 	0032 DIGIT TWO
 * 	0036 DIGIT SIX
 * 	65E5 ??
 * 33FA IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN
 * 	0032 DIGIT TWO
 * 	0037 DIGIT SEVEN
 * 	65E5 ??
 * 33FB IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT
 * 	0032 DIGIT TWO
 * 	0038 DIGIT EIGHT
 * 	65E5 ??
 * 33FC IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE
 * 	0032 DIGIT TWO
 * 	0039 DIGIT NINE
 * 	65E5 ??
 * 33FD IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY
 * 	0033 DIGIT THREE
 * 	0030 DIGIT ZERO
 * 	65E5 ??
 * 33FE IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE
 * 	0033 DIGIT THREE
 * 	0031 DIGIT ONE
 * 	65E5 ??
 * 33FF SQUARE GAL
 * 	0067 LATIN SMALL LETTER G
 * 	0061 LATIN SMALL LETTER A
 * 	006C LATIN SMALL LETTER L
 * A66F COMBINING CYRILLIC VZMET
 * 	0000 <control>
 * A670 COMBINING CYRILLIC TEN MILLIONS SIGN
 * 	0000 <control>
 * A671 COMBINING CYRILLIC HUNDRED MILLIONS SIGN
 * 	0000 <control>
 * A672 COMBINING CYRILLIC THOUSAND MILLIONS SIGN
 * 	0000 <control>
 * A67C COMBINING CYRILLIC KAVYKA
 * 	0000 <control>
 * A67D COMBINING CYRILLIC PAYEROK
 * 	0000 <control>
 * A770 MODIFIER LETTER US
 * 	A76F LATIN SMALL LETTER CON
 * A802 SYLOTI NAGRI SIGN DVISVARA
 * 	0000 <control>
 * A806 SYLOTI NAGRI SIGN HASANTA
 * 	0000 <control>
 * A80B SYLOTI NAGRI SIGN ANUSVARA
 * 	0000 <control>
 * A823 SYLOTI NAGRI VOWEL SIGN A
 * 	0000 <control>
 * A824 SYLOTI NAGRI VOWEL SIGN I
 * 	0000 <control>
 * A825 SYLOTI NAGRI VOWEL SIGN U
 * 	0000 <control>
 * A826 SYLOTI NAGRI VOWEL SIGN E
 * 	0000 <control>
 * A827 SYLOTI NAGRI VOWEL SIGN OO
 * 	0000 <control>
 * A880 SAURASHTRA SIGN ANUSVARA
 * 	0000 <control>
 * A881 SAURASHTRA SIGN VISARGA
 * 	0000 <control>
 * A8B4 SAURASHTRA CONSONANT SIGN HAARU
 * 	0000 <control>
 * A8B5 SAURASHTRA VOWEL SIGN AA
 * 	0000 <control>
 * A8B6 SAURASHTRA VOWEL SIGN I
 * 	0000 <control>
 * A8B7 SAURASHTRA VOWEL SIGN II
 * 	0000 <control>
 * A8B8 SAURASHTRA VOWEL SIGN U
 * 	0000 <control>
 * A8B9 SAURASHTRA VOWEL SIGN UU
 * 	0000 <control>
 * A8BA SAURASHTRA VOWEL SIGN VOCALIC R
 * 	0000 <control>
 * A8BB SAURASHTRA VOWEL SIGN VOCALIC RR
 * 	0000 <control>
 * A8BC SAURASHTRA VOWEL SIGN VOCALIC L
 * 	0000 <control>
 * A8BD SAURASHTRA VOWEL SIGN VOCALIC LL
 * 	0000 <control>
 * A8BE SAURASHTRA VOWEL SIGN E
 * 	0000 <control>
 * A8BF SAURASHTRA VOWEL SIGN EE
 * 	0000 <control>
 * A8C0 SAURASHTRA VOWEL SIGN AI
 * 	0000 <control>
 * A8C1 SAURASHTRA VOWEL SIGN O
 * 	0000 <control>
 * A8C2 SAURASHTRA VOWEL SIGN OO
 * 	0000 <control>
 * A8C3 SAURASHTRA VOWEL SIGN AU
 * 	0000 <control>
 * A8C4 SAURASHTRA SIGN VIRAMA
 * 	0000 <control>
 * A926 KAYAH LI VOWEL UE
 * 	0000 <control>
 * A927 KAYAH LI VOWEL E
 * 	0000 <control>
 * A928 KAYAH LI VOWEL U
 * 	0000 <control>
 * A929 KAYAH LI VOWEL EE
 * 	0000 <control>
 * A92A KAYAH LI VOWEL O
 * 	0000 <control>
 * A92B KAYAH LI TONE PLOPHU
 * 	0000 <control>
 * A92C KAYAH LI TONE CALYA
 * 	0000 <control>
 * A92D KAYAH LI TONE CALYA PLOPHU
 * 	0000 <control>
 * A947 REJANG VOWEL SIGN I
 * 	0000 <control>
 * A948 REJANG VOWEL SIGN U
 * 	0000 <control>
 * A949 REJANG VOWEL SIGN E
 * 	0000 <control>
 * A94A REJANG VOWEL SIGN AI
 * 	0000 <control>
 * A94B REJANG VOWEL SIGN O
 * 	0000 <control>
 * A94C REJANG VOWEL SIGN AU
 * 	0000 <control>
 * A94D REJANG VOWEL SIGN EU
 * 	0000 <control>
 * A94E REJANG VOWEL SIGN EA
 * 	0000 <control>
 * A94F REJANG CONSONANT SIGN NG
 * 	0000 <control>
 * A950 REJANG CONSONANT SIGN N
 * 	0000 <control>
 * A951 REJANG CONSONANT SIGN R
 * 	0000 <control>
 * A952 REJANG CONSONANT SIGN H
 * 	0000 <control>
 * A953 REJANG VIRAMA
 * 	0000 <control>
 * AA29 CHAM VOWEL SIGN AA
 * 	0000 <control>
 * AA2A CHAM VOWEL SIGN I
 * 	0000 <control>
 * AA2B CHAM VOWEL SIGN II
 * 	0000 <control>
 * AA2C CHAM VOWEL SIGN EI
 * 	0000 <control>
 * AA2D CHAM VOWEL SIGN U
 * 	0000 <control>
 * AA2E CHAM VOWEL SIGN OE
 * 	0000 <control>
 * AA2F CHAM VOWEL SIGN O
 * 	0000 <control>
 * AA30 CHAM VOWEL SIGN AI
 * 	0000 <control>
 * AA31 CHAM VOWEL SIGN AU
 * 	0000 <control>
 * AA32 CHAM VOWEL SIGN UE
 * 	0000 <control>
 * AA33 CHAM CONSONANT SIGN YA
 * 	0000 <control>
 * AA34 CHAM CONSONANT SIGN RA
 * 	0000 <control>
 * AA35 CHAM CONSONANT SIGN LA
 * 	0000 <control>
 * AA36 CHAM CONSONANT SIGN WA
 * 	0000 <control>
 * AA43 CHAM CONSONANT SIGN FINAL NG
 * 	0000 <control>
 * AA4C CHAM CONSONANT SIGN FINAL M
 * 	0000 <control>
 * AA4D CHAM CONSONANT SIGN FINAL H
 * 	0000 <control>
 * F900 CJK COMPATIBILITY IDEOGRAPH-F900
 * 	8C48 ??
 * F901 CJK COMPATIBILITY IDEOGRAPH-F901
 * 	66F4 ??
 * F902 CJK COMPATIBILITY IDEOGRAPH-F902
 * 	8ECA ??
 * F903 CJK COMPATIBILITY IDEOGRAPH-F903
 * 	8CC8 ??
 * F904 CJK COMPATIBILITY IDEOGRAPH-F904
 * 	6ED1 ??
 * F905 CJK COMPATIBILITY IDEOGRAPH-F905
 * 	4E32 ??
 * F906 CJK COMPATIBILITY IDEOGRAPH-F906
 * 	53E5 ??
 * F907 CJK COMPATIBILITY IDEOGRAPH-F907
 * 	9F9C ??
 * F908 CJK COMPATIBILITY IDEOGRAPH-F908
 * 	9F9C ??
 * F909 CJK COMPATIBILITY IDEOGRAPH-F909
 * 	5951 ??
 * F90A CJK COMPATIBILITY IDEOGRAPH-F90A
 * 	91D1 ??
 * F90B CJK COMPATIBILITY IDEOGRAPH-F90B
 * 	5587 ??
 * F90C CJK COMPATIBILITY IDEOGRAPH-F90C
 * 	5948 ??
 * F90D CJK COMPATIBILITY IDEOGRAPH-F90D
 * 	61F6 ??
 * F90E CJK COMPATIBILITY IDEOGRAPH-F90E
 * 	7669 ??
 * F90F CJK COMPATIBILITY IDEOGRAPH-F90F
 * 	7F85 ??
 * F910 CJK COMPATIBILITY IDEOGRAPH-F910
 * 	863F ??
 * F911 CJK COMPATIBILITY IDEOGRAPH-F911
 * 	87BA ??
 * F912 CJK COMPATIBILITY IDEOGRAPH-F912
 * 	88F8 ??
 * F913 CJK COMPATIBILITY IDEOGRAPH-F913
 * 	908F ??
 * F914 CJK COMPATIBILITY IDEOGRAPH-F914
 * 	6A02 ??
 * F915 CJK COMPATIBILITY IDEOGRAPH-F915
 * 	6D1B ??
 * F916 CJK COMPATIBILITY IDEOGRAPH-F916
 * 	70D9 ??
 * F917 CJK COMPATIBILITY IDEOGRAPH-F917
 * 	73DE ??
 * F918 CJK COMPATIBILITY IDEOGRAPH-F918
 * 	843D ??
 * F919 CJK COMPATIBILITY IDEOGRAPH-F919
 * 	916A ??
 * F91A CJK COMPATIBILITY IDEOGRAPH-F91A
 * 	99F1 ??
 * F91B CJK COMPATIBILITY IDEOGRAPH-F91B
 * 	4E82 ??
 * F91C CJK COMPATIBILITY IDEOGRAPH-F91C
 * 	5375 ??
 * F91D CJK COMPATIBILITY IDEOGRAPH-F91D
 * 	6B04 ??
 * F91E CJK COMPATIBILITY IDEOGRAPH-F91E
 * 	721B ??
 * F91F CJK COMPATIBILITY IDEOGRAPH-F91F
 * 	862D ??
 * F920 CJK COMPATIBILITY IDEOGRAPH-F920
 * 	9E1E ??
 * F921 CJK COMPATIBILITY IDEOGRAPH-F921
 * 	5D50 ??
 * F922 CJK COMPATIBILITY IDEOGRAPH-F922
 * 	6FEB ??
 * F923 CJK COMPATIBILITY IDEOGRAPH-F923
 * 	85CD ??
 * F924 CJK COMPATIBILITY IDEOGRAPH-F924
 * 	8964 ??
 * F925 CJK COMPATIBILITY IDEOGRAPH-F925
 * 	62C9 ??
 * F926 CJK COMPATIBILITY IDEOGRAPH-F926
 * 	81D8 ??
 * F927 CJK COMPATIBILITY IDEOGRAPH-F927
 * 	881F ??
 * F928 CJK COMPATIBILITY IDEOGRAPH-F928
 * 	5ECA ??
 * F929 CJK COMPATIBILITY IDEOGRAPH-F929
 * 	6717 ??
 * F92A CJK COMPATIBILITY IDEOGRAPH-F92A
 * 	6D6A ??
 * F92B CJK COMPATIBILITY IDEOGRAPH-F92B
 * 	72FC ??
 * F92C CJK COMPATIBILITY IDEOGRAPH-F92C
 * 	90CE ??
 * F92D CJK COMPATIBILITY IDEOGRAPH-F92D
 * 	4F86 ??
 * F92E CJK COMPATIBILITY IDEOGRAPH-F92E
 * 	51B7 ??
 * F92F CJK COMPATIBILITY IDEOGRAPH-F92F
 * 	52DE ??
 * F930 CJK COMPATIBILITY IDEOGRAPH-F930
 * 	64C4 ??
 * F931 CJK COMPATIBILITY IDEOGRAPH-F931
 * 	6AD3 ??
 * F932 CJK COMPATIBILITY IDEOGRAPH-F932
 * 	7210 ??
 * F933 CJK COMPATIBILITY IDEOGRAPH-F933
 * 	76E7 ??
 * F934 CJK COMPATIBILITY IDEOGRAPH-F934
 * 	8001 ??
 * F935 CJK COMPATIBILITY IDEOGRAPH-F935
 * 	8606 ??
 * F936 CJK COMPATIBILITY IDEOGRAPH-F936
 * 	865C ??
 * F937 CJK COMPATIBILITY IDEOGRAPH-F937
 * 	8DEF ??
 * F938 CJK COMPATIBILITY IDEOGRAPH-F938
 * 	9732 ??
 * F939 CJK COMPATIBILITY IDEOGRAPH-F939
 * 	9B6F ??
 * F93A CJK COMPATIBILITY IDEOGRAPH-F93A
 * 	9DFA ??
 * F93B CJK COMPATIBILITY IDEOGRAPH-F93B
 * 	788C ??
 * F93C CJK COMPATIBILITY IDEOGRAPH-F93C
 * 	797F ??
 * F93D CJK COMPATIBILITY IDEOGRAPH-F93D
 * 	7DA0 ??
 * F93E CJK COMPATIBILITY IDEOGRAPH-F93E
 * 	83C9 ??
 * F93F CJK COMPATIBILITY IDEOGRAPH-F93F
 * 	9304 ??
 * F940 CJK COMPATIBILITY IDEOGRAPH-F940
 * 	9E7F ??
 * F941 CJK COMPATIBILITY IDEOGRAPH-F941
 * 	8AD6 ??
 * F942 CJK COMPATIBILITY IDEOGRAPH-F942
 * 	58DF ??
 * F943 CJK COMPATIBILITY IDEOGRAPH-F943
 * 	5F04 ??
 * F944 CJK COMPATIBILITY IDEOGRAPH-F944
 * 	7C60 ??
 * F945 CJK COMPATIBILITY IDEOGRAPH-F945
 * 	807E ??
 * F946 CJK COMPATIBILITY IDEOGRAPH-F946
 * 	7262 ??
 * F947 CJK COMPATIBILITY IDEOGRAPH-F947
 * 	78CA ??
 * F948 CJK COMPATIBILITY IDEOGRAPH-F948
 * 	8CC2 ??
 * F949 CJK COMPATIBILITY IDEOGRAPH-F949
 * 	96F7 ??
 * F94A CJK COMPATIBILITY IDEOGRAPH-F94A
 * 	58D8 ??
 * F94B CJK COMPATIBILITY IDEOGRAPH-F94B
 * 	5C62 ??
 * F94C CJK COMPATIBILITY IDEOGRAPH-F94C
 * 	6A13 ??
 * F94D CJK COMPATIBILITY IDEOGRAPH-F94D
 * 	6DDA ??
 * F94E CJK COMPATIBILITY IDEOGRAPH-F94E
 * 	6F0F ??
 * F94F CJK COMPATIBILITY IDEOGRAPH-F94F
 * 	7D2F ??
 * F950 CJK COMPATIBILITY IDEOGRAPH-F950
 * 	7E37 ??
 * F951 CJK COMPATIBILITY IDEOGRAPH-F951
 * 	964B ??
 * F952 CJK COMPATIBILITY IDEOGRAPH-F952
 * 	52D2 ??
 * F953 CJK COMPATIBILITY IDEOGRAPH-F953
 * 	808B ??
 * F954 CJK COMPATIBILITY IDEOGRAPH-F954
 * 	51DC ??
 * F955 CJK COMPATIBILITY IDEOGRAPH-F955
 * 	51CC ??
 * F956 CJK COMPATIBILITY IDEOGRAPH-F956
 * 	7A1C ??
 * F957 CJK COMPATIBILITY IDEOGRAPH-F957
 * 	7DBE ??
 * F958 CJK COMPATIBILITY IDEOGRAPH-F958
 * 	83F1 ??
 * F959 CJK COMPATIBILITY IDEOGRAPH-F959
 * 	9675 ??
 * F95A CJK COMPATIBILITY IDEOGRAPH-F95A
 * 	8B80 ??
 * F95B CJK COMPATIBILITY IDEOGRAPH-F95B
 * 	62CF ??
 * F95C CJK COMPATIBILITY IDEOGRAPH-F95C
 * 	6A02 ??
 * F95D CJK COMPATIBILITY IDEOGRAPH-F95D
 * 	8AFE ??
 * F95E CJK COMPATIBILITY IDEOGRAPH-F95E
 * 	4E39 ??
 * F95F CJK COMPATIBILITY IDEOGRAPH-F95F
 * 	5BE7 ??
 * F960 CJK COMPATIBILITY IDEOGRAPH-F960
 * 	6012 ??
 * F961 CJK COMPATIBILITY IDEOGRAPH-F961
 * 	7387 ??
 * F962 CJK COMPATIBILITY IDEOGRAPH-F962
 * 	7570 ??
 * F963 CJK COMPATIBILITY IDEOGRAPH-F963
 * 	5317 ??
 * F964 CJK COMPATIBILITY IDEOGRAPH-F964
 * 	78FB ??
 * F965 CJK COMPATIBILITY IDEOGRAPH-F965
 * 	4FBF ??
 * F966 CJK COMPATIBILITY IDEOGRAPH-F966
 * 	5FA9 ??
 * F967 CJK COMPATIBILITY IDEOGRAPH-F967
 * 	4E0D ??
 * F968 CJK COMPATIBILITY IDEOGRAPH-F968
 * 	6CCC ??
 * F969 CJK COMPATIBILITY IDEOGRAPH-F969
 * 	6578 ??
 * F96A CJK COMPATIBILITY IDEOGRAPH-F96A
 * 	7D22 ??
 * F96B CJK COMPATIBILITY IDEOGRAPH-F96B
 * 	53C3 ??
 * F96C CJK COMPATIBILITY IDEOGRAPH-F96C
 * 	585E ??
 * F96D CJK COMPATIBILITY IDEOGRAPH-F96D
 * 	7701 ??
 * F96E CJK COMPATIBILITY IDEOGRAPH-F96E
 * 	8449 ??
 * F96F CJK COMPATIBILITY IDEOGRAPH-F96F
 * 	8AAA ??
 * F970 CJK COMPATIBILITY IDEOGRAPH-F970
 * 	6BBA ??
 * F971 CJK COMPATIBILITY IDEOGRAPH-F971
 * 	8FB0 ??
 * F972 CJK COMPATIBILITY IDEOGRAPH-F972
 * 	6C88 ??
 * F973 CJK COMPATIBILITY IDEOGRAPH-F973
 * 	62FE ??
 * F974 CJK COMPATIBILITY IDEOGRAPH-F974
 * 	82E5 ??
 * F975 CJK COMPATIBILITY IDEOGRAPH-F975
 * 	63A0 ??
 * F976 CJK COMPATIBILITY IDEOGRAPH-F976
 * 	7565 ??
 * F977 CJK COMPATIBILITY IDEOGRAPH-F977
 * 	4EAE ??
 * F978 CJK COMPATIBILITY IDEOGRAPH-F978
 * 	5169 ??
 * F979 CJK COMPATIBILITY IDEOGRAPH-F979
 * 	51C9 ??
 * F97A CJK COMPATIBILITY IDEOGRAPH-F97A
 * 	6881 ??
 * F97B CJK COMPATIBILITY IDEOGRAPH-F97B
 * 	7CE7 ??
 * F97C CJK COMPATIBILITY IDEOGRAPH-F97C
 * 	826F ??
 * F97D CJK COMPATIBILITY IDEOGRAPH-F97D
 * 	8AD2 ??
 * F97E CJK COMPATIBILITY IDEOGRAPH-F97E
 * 	91CF ??
 * F97F CJK COMPATIBILITY IDEOGRAPH-F97F
 * 	52F5 ??
 * F980 CJK COMPATIBILITY IDEOGRAPH-F980
 * 	5442 ??
 * F981 CJK COMPATIBILITY IDEOGRAPH-F981
 * 	5973 ??
 * F982 CJK COMPATIBILITY IDEOGRAPH-F982
 * 	5EEC ??
 * F983 CJK COMPATIBILITY IDEOGRAPH-F983
 * 	65C5 ??
 * F984 CJK COMPATIBILITY IDEOGRAPH-F984
 * 	6FFE ??
 * F985 CJK COMPATIBILITY IDEOGRAPH-F985
 * 	792A ??
 * F986 CJK COMPATIBILITY IDEOGRAPH-F986
 * 	95AD ??
 * F987 CJK COMPATIBILITY IDEOGRAPH-F987
 * 	9A6A ??
 * F988 CJK COMPATIBILITY IDEOGRAPH-F988
 * 	9E97 ??
 * F989 CJK COMPATIBILITY IDEOGRAPH-F989
 * 	9ECE ??
 * F98A CJK COMPATIBILITY IDEOGRAPH-F98A
 * 	529B ??
 * F98B CJK COMPATIBILITY IDEOGRAPH-F98B
 * 	66C6 ??
 * F98C CJK COMPATIBILITY IDEOGRAPH-F98C
 * 	6B77 ??
 * F98D CJK COMPATIBILITY IDEOGRAPH-F98D
 * 	8F62 ??
 * F98E CJK COMPATIBILITY IDEOGRAPH-F98E
 * 	5E74 ??
 * F98F CJK COMPATIBILITY IDEOGRAPH-F98F
 * 	6190 ??
 * F990 CJK COMPATIBILITY IDEOGRAPH-F990
 * 	6200 ??
 * F991 CJK COMPATIBILITY IDEOGRAPH-F991
 * 	649A ??
 * F992 CJK COMPATIBILITY IDEOGRAPH-F992
 * 	6F23 ??
 * F993 CJK COMPATIBILITY IDEOGRAPH-F993
 * 	7149 ??
 * F994 CJK COMPATIBILITY IDEOGRAPH-F994
 * 	7489 ??
 * F995 CJK COMPATIBILITY IDEOGRAPH-F995
 * 	79CA ??
 * F996 CJK COMPATIBILITY IDEOGRAPH-F996
 * 	7DF4 ??
 * F997 CJK COMPATIBILITY IDEOGRAPH-F997
 * 	806F ??
 * F998 CJK COMPATIBILITY IDEOGRAPH-F998
 * 	8F26 ??
 * F999 CJK COMPATIBILITY IDEOGRAPH-F999
 * 	84EE ??
 * F99A CJK COMPATIBILITY IDEOGRAPH-F99A
 * 	9023 ??
 * F99B CJK COMPATIBILITY IDEOGRAPH-F99B
 * 	934A ??
 * F99C CJK COMPATIBILITY IDEOGRAPH-F99C
 * 	5217 ??
 * F99D CJK COMPATIBILITY IDEOGRAPH-F99D
 * 	52A3 ??
 * F99E CJK COMPATIBILITY IDEOGRAPH-F99E
 * 	54BD ??
 * F99F CJK COMPATIBILITY IDEOGRAPH-F99F
 * 	70C8 ??
 * F9A0 CJK COMPATIBILITY IDEOGRAPH-F9A0
 * 	88C2 ??
 * F9A1 CJK COMPATIBILITY IDEOGRAPH-F9A1
 * 	8AAA ??
 * F9A2 CJK COMPATIBILITY IDEOGRAPH-F9A2
 * 	5EC9 ??
 * F9A3 CJK COMPATIBILITY IDEOGRAPH-F9A3
 * 	5FF5 ??
 * F9A4 CJK COMPATIBILITY IDEOGRAPH-F9A4
 * 	637B ??
 * F9A5 CJK COMPATIBILITY IDEOGRAPH-F9A5
 * 	6BAE ??
 * F9A6 CJK COMPATIBILITY IDEOGRAPH-F9A6
 * 	7C3E ??
 * F9A7 CJK COMPATIBILITY IDEOGRAPH-F9A7
 * 	7375 ??
 * F9A8 CJK COMPATIBILITY IDEOGRAPH-F9A8
 * 	4EE4 ??
 * F9A9 CJK COMPATIBILITY IDEOGRAPH-F9A9
 * 	56F9 ??
 * F9AA CJK COMPATIBILITY IDEOGRAPH-F9AA
 * 	5BE7 ??
 * F9AB CJK COMPATIBILITY IDEOGRAPH-F9AB
 * 	5DBA ??
 * F9AC CJK COMPATIBILITY IDEOGRAPH-F9AC
 * 	601C ??
 * F9AD CJK COMPATIBILITY IDEOGRAPH-F9AD
 * 	73B2 ??
 * F9AE CJK COMPATIBILITY IDEOGRAPH-F9AE
 * 	7469 ??
 * F9AF CJK COMPATIBILITY IDEOGRAPH-F9AF
 * 	7F9A ??
 * F9B0 CJK COMPATIBILITY IDEOGRAPH-F9B0
 * 	8046 ??
 * F9B1 CJK COMPATIBILITY IDEOGRAPH-F9B1
 * 	9234 ??
 * F9B2 CJK COMPATIBILITY IDEOGRAPH-F9B2
 * 	96F6 ??
 * F9B3 CJK COMPATIBILITY IDEOGRAPH-F9B3
 * 	9748 ??
 * F9B4 CJK COMPATIBILITY IDEOGRAPH-F9B4
 * 	9818 ??
 * F9B5 CJK COMPATIBILITY IDEOGRAPH-F9B5
 * 	4F8B ??
 * F9B6 CJK COMPATIBILITY IDEOGRAPH-F9B6
 * 	79AE ??
 * F9B7 CJK COMPATIBILITY IDEOGRAPH-F9B7
 * 	91B4 ??
 * F9B8 CJK COMPATIBILITY IDEOGRAPH-F9B8
 * 	96B8 ??
 * F9B9 CJK COMPATIBILITY IDEOGRAPH-F9B9
 * 	60E1 ??
 * F9BA CJK COMPATIBILITY IDEOGRAPH-F9BA
 * 	4E86 ??
 * F9BB CJK COMPATIBILITY IDEOGRAPH-F9BB
 * 	50DA ??
 * F9BC CJK COMPATIBILITY IDEOGRAPH-F9BC
 * 	5BEE ??
 * F9BD CJK COMPATIBILITY IDEOGRAPH-F9BD
 * 	5C3F ??
 * F9BE CJK COMPATIBILITY IDEOGRAPH-F9BE
 * 	6599 ??
 * F9BF CJK COMPATIBILITY IDEOGRAPH-F9BF
 * 	6A02 ??
 * F9C0 CJK COMPATIBILITY IDEOGRAPH-F9C0
 * 	71CE ??
 * F9C1 CJK COMPATIBILITY IDEOGRAPH-F9C1
 * 	7642 ??
 * F9C2 CJK COMPATIBILITY IDEOGRAPH-F9C2
 * 	84FC ??
 * F9C3 CJK COMPATIBILITY IDEOGRAPH-F9C3
 * 	907C ??
 * F9C4 CJK COMPATIBILITY IDEOGRAPH-F9C4
 * 	9F8D ??
 * F9C5 CJK COMPATIBILITY IDEOGRAPH-F9C5
 * 	6688 ??
 * F9C6 CJK COMPATIBILITY IDEOGRAPH-F9C6
 * 	962E ??
 * F9C7 CJK COMPATIBILITY IDEOGRAPH-F9C7
 * 	5289 ??
 * F9C8 CJK COMPATIBILITY IDEOGRAPH-F9C8
 * 	677B ??
 * F9C9 CJK COMPATIBILITY IDEOGRAPH-F9C9
 * 	67F3 ??
 * F9CA CJK COMPATIBILITY IDEOGRAPH-F9CA
 * 	6D41 ??
 * F9CB CJK COMPATIBILITY IDEOGRAPH-F9CB
 * 	6E9C ??
 * F9CC CJK COMPATIBILITY IDEOGRAPH-F9CC
 * 	7409 ??
 * F9CD CJK COMPATIBILITY IDEOGRAPH-F9CD
 * 	7559 ??
 * F9CE CJK COMPATIBILITY IDEOGRAPH-F9CE
 * 	786B ??
 * F9CF CJK COMPATIBILITY IDEOGRAPH-F9CF
 * 	7D10 ??
 * F9D0 CJK COMPATIBILITY IDEOGRAPH-F9D0
 * 	985E ??
 * F9D1 CJK COMPATIBILITY IDEOGRAPH-F9D1
 * 	516D ??
 * F9D2 CJK COMPATIBILITY IDEOGRAPH-F9D2
 * 	622E ??
 * F9D3 CJK COMPATIBILITY IDEOGRAPH-F9D3
 * 	9678 ??
 * F9D4 CJK COMPATIBILITY IDEOGRAPH-F9D4
 * 	502B ??
 * F9D5 CJK COMPATIBILITY IDEOGRAPH-F9D5
 * 	5D19 ??
 * F9D6 CJK COMPATIBILITY IDEOGRAPH-F9D6
 * 	6DEA ??
 * F9D7 CJK COMPATIBILITY IDEOGRAPH-F9D7
 * 	8F2A ??
 * F9D8 CJK COMPATIBILITY IDEOGRAPH-F9D8
 * 	5F8B ??
 * F9D9 CJK COMPATIBILITY IDEOGRAPH-F9D9
 * 	6144 ??
 * F9DA CJK COMPATIBILITY IDEOGRAPH-F9DA
 * 	6817 ??
 * F9DB CJK COMPATIBILITY IDEOGRAPH-F9DB
 * 	7387 ??
 * F9DC CJK COMPATIBILITY IDEOGRAPH-F9DC
 * 	9686 ??
 * F9DD CJK COMPATIBILITY IDEOGRAPH-F9DD
 * 	5229 ??
 * F9DE CJK COMPATIBILITY IDEOGRAPH-F9DE
 * 	540F ??
 * F9DF CJK COMPATIBILITY IDEOGRAPH-F9DF
 * 	5C65 ??
 * F9E0 CJK COMPATIBILITY IDEOGRAPH-F9E0
 * 	6613 ??
 * F9E1 CJK COMPATIBILITY IDEOGRAPH-F9E1
 * 	674E ??
 * F9E2 CJK COMPATIBILITY IDEOGRAPH-F9E2
 * 	68A8 ??
 * F9E3 CJK COMPATIBILITY IDEOGRAPH-F9E3
 * 	6CE5 ??
 * F9E4 CJK COMPATIBILITY IDEOGRAPH-F9E4
 * 	7406 ??
 * F9E5 CJK COMPATIBILITY IDEOGRAPH-F9E5
 * 	75E2 ??
 * F9E6 CJK COMPATIBILITY IDEOGRAPH-F9E6
 * 	7F79 ??
 * F9E7 CJK COMPATIBILITY IDEOGRAPH-F9E7
 * 	88CF ??
 * F9E8 CJK COMPATIBILITY IDEOGRAPH-F9E8
 * 	88E1 ??
 * F9E9 CJK COMPATIBILITY IDEOGRAPH-F9E9
 * 	91CC ??
 * F9EA CJK COMPATIBILITY IDEOGRAPH-F9EA
 * 	96E2 ??
 * F9EB CJK COMPATIBILITY IDEOGRAPH-F9EB
 * 	533F ??
 * F9EC CJK COMPATIBILITY IDEOGRAPH-F9EC
 * 	6EBA ??
 * F9ED CJK COMPATIBILITY IDEOGRAPH-F9ED
 * 	541D ??
 * F9EE CJK COMPATIBILITY IDEOGRAPH-F9EE
 * 	71D0 ??
 * F9EF CJK COMPATIBILITY IDEOGRAPH-F9EF
 * 	7498 ??
 * F9F0 CJK COMPATIBILITY IDEOGRAPH-F9F0
 * 	85FA ??
 * F9F1 CJK COMPATIBILITY IDEOGRAPH-F9F1
 * 	96A3 ??
 * F9F2 CJK COMPATIBILITY IDEOGRAPH-F9F2
 * 	9C57 ??
 * F9F3 CJK COMPATIBILITY IDEOGRAPH-F9F3
 * 	9E9F ??
 * F9F4 CJK COMPATIBILITY IDEOGRAPH-F9F4
 * 	6797 ??
 * F9F5 CJK COMPATIBILITY IDEOGRAPH-F9F5
 * 	6DCB ??
 * F9F6 CJK COMPATIBILITY IDEOGRAPH-F9F6
 * 	81E8 ??
 * F9F7 CJK COMPATIBILITY IDEOGRAPH-F9F7
 * 	7ACB ??
 * F9F8 CJK COMPATIBILITY IDEOGRAPH-F9F8
 * 	7B20 ??
 * F9F9 CJK COMPATIBILITY IDEOGRAPH-F9F9
 * 	7C92 ??
 * F9FA CJK COMPATIBILITY IDEOGRAPH-F9FA
 * 	72C0 ??
 * F9FB CJK COMPATIBILITY IDEOGRAPH-F9FB
 * 	7099 ??
 * F9FC CJK COMPATIBILITY IDEOGRAPH-F9FC
 * 	8B58 ??
 * F9FD CJK COMPATIBILITY IDEOGRAPH-F9FD
 * 	4EC0 ??
 * F9FE CJK COMPATIBILITY IDEOGRAPH-F9FE
 * 	8336 ??
 * F9FF CJK COMPATIBILITY IDEOGRAPH-F9FF
 * 	523A ??
 * FA00 CJK COMPATIBILITY IDEOGRAPH-FA00
 * 	5207 ??
 * FA01 CJK COMPATIBILITY IDEOGRAPH-FA01
 * 	5EA6 ??
 * FA02 CJK COMPATIBILITY IDEOGRAPH-FA02
 * 	62D3 ??
 * FA03 CJK COMPATIBILITY IDEOGRAPH-FA03
 * 	7CD6 ??
 * FA04 CJK COMPATIBILITY IDEOGRAPH-FA04
 * 	5B85 ??
 * FA05 CJK COMPATIBILITY IDEOGRAPH-FA05
 * 	6D1E ??
 * FA06 CJK COMPATIBILITY IDEOGRAPH-FA06
 * 	66B4 ??
 * FA07 CJK COMPATIBILITY IDEOGRAPH-FA07
 * 	8F3B ??
 * FA08 CJK COMPATIBILITY IDEOGRAPH-FA08
 * 	884C ??
 * FA09 CJK COMPATIBILITY IDEOGRAPH-FA09
 * 	964D ??
 * FA0A CJK COMPATIBILITY IDEOGRAPH-FA0A
 * 	898B ??
 * FA0B CJK COMPATIBILITY IDEOGRAPH-FA0B
 * 	5ED3 ??
 * FA0C CJK COMPATIBILITY IDEOGRAPH-FA0C
 * 	5140 ??
 * FA0D CJK COMPATIBILITY IDEOGRAPH-FA0D
 * 	55C0 ??
 * FA10 CJK COMPATIBILITY IDEOGRAPH-FA10
 * 	585A ??
 * FA12 CJK COMPATIBILITY IDEOGRAPH-FA12
 * 	6674 ??
 * FA15 CJK COMPATIBILITY IDEOGRAPH-FA15
 * 	51DE ??
 * FA16 CJK COMPATIBILITY IDEOGRAPH-FA16
 * 	732A ??
 * FA17 CJK COMPATIBILITY IDEOGRAPH-FA17
 * 	76CA ??
 * FA18 CJK COMPATIBILITY IDEOGRAPH-FA18
 * 	793C ??
 * FA19 CJK COMPATIBILITY IDEOGRAPH-FA19
 * 	795E ??
 * FA1A CJK COMPATIBILITY IDEOGRAPH-FA1A
 * 	7965 ??
 * FA1B CJK COMPATIBILITY IDEOGRAPH-FA1B
 * 	798F ??
 * FA1C CJK COMPATIBILITY IDEOGRAPH-FA1C
 * 	9756 ??
 * FA1D CJK COMPATIBILITY IDEOGRAPH-FA1D
 * 	7CBE ??
 * FA1E CJK COMPATIBILITY IDEOGRAPH-FA1E
 * 	7FBD ??
 * FA20 CJK COMPATIBILITY IDEOGRAPH-FA20
 * 	8612 ??
 * FA22 CJK COMPATIBILITY IDEOGRAPH-FA22
 * 	8AF8 ??
 * FA25 CJK COMPATIBILITY IDEOGRAPH-FA25
 * 	9038 ??
 * FA26 CJK COMPATIBILITY IDEOGRAPH-FA26
 * 	90FD ??
 * FA2A CJK COMPATIBILITY IDEOGRAPH-FA2A
 * 	98EF ??
 * FA2B CJK COMPATIBILITY IDEOGRAPH-FA2B
 * 	98FC ??
 * FA2C CJK COMPATIBILITY IDEOGRAPH-FA2C
 * 	9928 ??
 * FA2D CJK COMPATIBILITY IDEOGRAPH-FA2D
 * 	9DB4 ??
 * FA30 CJK COMPATIBILITY IDEOGRAPH-FA30
 * 	4FAE ??
 * FA31 CJK COMPATIBILITY IDEOGRAPH-FA31
 * 	50E7 ??
 * FA32 CJK COMPATIBILITY IDEOGRAPH-FA32
 * 	514D ??
 * FA33 CJK COMPATIBILITY IDEOGRAPH-FA33
 * 	52C9 ??
 * FA34 CJK COMPATIBILITY IDEOGRAPH-FA34
 * 	52E4 ??
 * FA35 CJK COMPATIBILITY IDEOGRAPH-FA35
 * 	5351 ??
 * FA36 CJK COMPATIBILITY IDEOGRAPH-FA36
 * 	559D ??
 * FA37 CJK COMPATIBILITY IDEOGRAPH-FA37
 * 	5606 ??
 * FA38 CJK COMPATIBILITY IDEOGRAPH-FA38
 * 	5668 ??
 * FA39 CJK COMPATIBILITY IDEOGRAPH-FA39
 * 	5840 ??
 * FA3A CJK COMPATIBILITY IDEOGRAPH-FA3A
 * 	58A8 ??
 * FA3B CJK COMPATIBILITY IDEOGRAPH-FA3B
 * 	5C64 ??
 * FA3C CJK COMPATIBILITY IDEOGRAPH-FA3C
 * 	5C6E ??
 * FA3D CJK COMPATIBILITY IDEOGRAPH-FA3D
 * 	6094 ??
 * FA3E CJK COMPATIBILITY IDEOGRAPH-FA3E
 * 	6168 ??
 * FA3F CJK COMPATIBILITY IDEOGRAPH-FA3F
 * 	618E ??
 * FA40 CJK COMPATIBILITY IDEOGRAPH-FA40
 * 	61F2 ??
 * FA41 CJK COMPATIBILITY IDEOGRAPH-FA41
 * 	654F ??
 * FA42 CJK COMPATIBILITY IDEOGRAPH-FA42
 * 	65E2 ??
 * FA43 CJK COMPATIBILITY IDEOGRAPH-FA43
 * 	6691 ??
 * FA44 CJK COMPATIBILITY IDEOGRAPH-FA44
 * 	6885 ??
 * FA45 CJK COMPATIBILITY IDEOGRAPH-FA45
 * 	6D77 ??
 * FA46 CJK COMPATIBILITY IDEOGRAPH-FA46
 * 	6E1A ??
 * FA47 CJK COMPATIBILITY IDEOGRAPH-FA47
 * 	6F22 ??
 * FA48 CJK COMPATIBILITY IDEOGRAPH-FA48
 * 	716E ??
 * FA49 CJK COMPATIBILITY IDEOGRAPH-FA49
 * 	722B ??
 * FA4A CJK COMPATIBILITY IDEOGRAPH-FA4A
 * 	7422 ??
 * FA4B CJK COMPATIBILITY IDEOGRAPH-FA4B
 * 	7891 ??
 * FA4C CJK COMPATIBILITY IDEOGRAPH-FA4C
 * 	793E ??
 * FA4D CJK COMPATIBILITY IDEOGRAPH-FA4D
 * 	7949 ??
 * FA4E CJK COMPATIBILITY IDEOGRAPH-FA4E
 * 	7948 ??
 * FA4F CJK COMPATIBILITY IDEOGRAPH-FA4F
 * 	7950 ??
 * FA50 CJK COMPATIBILITY IDEOGRAPH-FA50
 * 	7956 ??
 * FA51 CJK COMPATIBILITY IDEOGRAPH-FA51
 * 	795D ??
 * FA52 CJK COMPATIBILITY IDEOGRAPH-FA52
 * 	798D ??
 * FA53 CJK COMPATIBILITY IDEOGRAPH-FA53
 * 	798E ??
 * FA54 CJK COMPATIBILITY IDEOGRAPH-FA54
 * 	7A40 ??
 * FA55 CJK COMPATIBILITY IDEOGRAPH-FA55
 * 	7A81 ??
 * FA56 CJK COMPATIBILITY IDEOGRAPH-FA56
 * 	7BC0 ??
 * FA57 CJK COMPATIBILITY IDEOGRAPH-FA57
 * 	7DF4 ??
 * FA58 CJK COMPATIBILITY IDEOGRAPH-FA58
 * 	7E09 ??
 * FA59 CJK COMPATIBILITY IDEOGRAPH-FA59
 * 	7E41 ??
 * FA5A CJK COMPATIBILITY IDEOGRAPH-FA5A
 * 	7F72 ??
 * FA5B CJK COMPATIBILITY IDEOGRAPH-FA5B
 * 	8005 ??
 * FA5C CJK COMPATIBILITY IDEOGRAPH-FA5C
 * 	81ED ??
 * FA5D CJK COMPATIBILITY IDEOGRAPH-FA5D
 * 	8279 ??
 * FA5E CJK COMPATIBILITY IDEOGRAPH-FA5E
 * 	8279 ??
 * FA5F CJK COMPATIBILITY IDEOGRAPH-FA5F
 * 	8457 ??
 * FA60 CJK COMPATIBILITY IDEOGRAPH-FA60
 * 	8910 ??
 * FA61 CJK COMPATIBILITY IDEOGRAPH-FA61
 * 	8996 ??
 * FA62 CJK COMPATIBILITY IDEOGRAPH-FA62
 * 	8B01 ??
 * FA63 CJK COMPATIBILITY IDEOGRAPH-FA63
 * 	8B39 ??
 * FA64 CJK COMPATIBILITY IDEOGRAPH-FA64
 * 	8CD3 ??
 * FA65 CJK COMPATIBILITY IDEOGRAPH-FA65
 * 	8D08 ??
 * FA66 CJK COMPATIBILITY IDEOGRAPH-FA66
 * 	8FB6 ??
 * FA67 CJK COMPATIBILITY IDEOGRAPH-FA67
 * 	9038 ??
 * FA68 CJK COMPATIBILITY IDEOGRAPH-FA68
 * 	96E3 ??
 * FA69 CJK COMPATIBILITY IDEOGRAPH-FA69
 * 	97FF ??
 * FA6A CJK COMPATIBILITY IDEOGRAPH-FA6A
 * 	983B ??
 * FA70 CJK COMPATIBILITY IDEOGRAPH-FA70
 * 	4E26 ??
 * FA71 CJK COMPATIBILITY IDEOGRAPH-FA71
 * 	51B5 ??
 * FA72 CJK COMPATIBILITY IDEOGRAPH-FA72
 * 	5168 ??
 * FA73 CJK COMPATIBILITY IDEOGRAPH-FA73
 * 	4F80 ??
 * FA74 CJK COMPATIBILITY IDEOGRAPH-FA74
 * 	5145 ??
 * FA75 CJK COMPATIBILITY IDEOGRAPH-FA75
 * 	5180 ??
 * FA76 CJK COMPATIBILITY IDEOGRAPH-FA76
 * 	52C7 ??
 * FA77 CJK COMPATIBILITY IDEOGRAPH-FA77
 * 	52FA ??
 * FA78 CJK COMPATIBILITY IDEOGRAPH-FA78
 * 	559D ??
 * FA79 CJK COMPATIBILITY IDEOGRAPH-FA79
 * 	5555 ??
 * FA7A CJK COMPATIBILITY IDEOGRAPH-FA7A
 * 	5599 ??
 * FA7B CJK COMPATIBILITY IDEOGRAPH-FA7B
 * 	55E2 ??
 * FA7C CJK COMPATIBILITY IDEOGRAPH-FA7C
 * 	585A ??
 * FA7D CJK COMPATIBILITY IDEOGRAPH-FA7D
 * 	58B3 ??
 * FA7E CJK COMPATIBILITY IDEOGRAPH-FA7E
 * 	5944 ??
 * FA7F CJK COMPATIBILITY IDEOGRAPH-FA7F
 * 	5954 ??
 * FA80 CJK COMPATIBILITY IDEOGRAPH-FA80
 * 	5A62 ??
 * FA81 CJK COMPATIBILITY IDEOGRAPH-FA81
 * 	5B28 ??
 * FA82 CJK COMPATIBILITY IDEOGRAPH-FA82
 * 	5ED2 ??
 * FA83 CJK COMPATIBILITY IDEOGRAPH-FA83
 * 	5ED9 ??
 * FA84 CJK COMPATIBILITY IDEOGRAPH-FA84
 * 	5F69 ??
 * FA85 CJK COMPATIBILITY IDEOGRAPH-FA85
 * 	5FAD ??
 * FA86 CJK COMPATIBILITY IDEOGRAPH-FA86
 * 	60D8 ??
 * FA87 CJK COMPATIBILITY IDEOGRAPH-FA87
 * 	614E ??
 * FA88 CJK COMPATIBILITY IDEOGRAPH-FA88
 * 	6108 ??
 * FA89 CJK COMPATIBILITY IDEOGRAPH-FA89
 * 	618E ??
 * FA8A CJK COMPATIBILITY IDEOGRAPH-FA8A
 * 	6160 ??
 * FA8B CJK COMPATIBILITY IDEOGRAPH-FA8B
 * 	61F2 ??
 * FA8C CJK COMPATIBILITY IDEOGRAPH-FA8C
 * 	6234 ??
 * FA8D CJK COMPATIBILITY IDEOGRAPH-FA8D
 * 	63C4 ??
 * FA8E CJK COMPATIBILITY IDEOGRAPH-FA8E
 * 	641C ??
 * FA8F CJK COMPATIBILITY IDEOGRAPH-FA8F
 * 	6452 ??
 * FA90 CJK COMPATIBILITY IDEOGRAPH-FA90
 * 	6556 ??
 * FA91 CJK COMPATIBILITY IDEOGRAPH-FA91
 * 	6674 ??
 * FA92 CJK COMPATIBILITY IDEOGRAPH-FA92
 * 	6717 ??
 * FA93 CJK COMPATIBILITY IDEOGRAPH-FA93
 * 	671B ??
 * FA94 CJK COMPATIBILITY IDEOGRAPH-FA94
 * 	6756 ??
 * FA95 CJK COMPATIBILITY IDEOGRAPH-FA95
 * 	6B79 ??
 * FA96 CJK COMPATIBILITY IDEOGRAPH-FA96
 * 	6BBA ??
 * FA97 CJK COMPATIBILITY IDEOGRAPH-FA97
 * 	6D41 ??
 * FA98 CJK COMPATIBILITY IDEOGRAPH-FA98
 * 	6EDB ??
 * FA99 CJK COMPATIBILITY IDEOGRAPH-FA99
 * 	6ECB ??
 * FA9A CJK COMPATIBILITY IDEOGRAPH-FA9A
 * 	6F22 ??
 * FA9B CJK COMPATIBILITY IDEOGRAPH-FA9B
 * 	701E ??
 * FA9C CJK COMPATIBILITY IDEOGRAPH-FA9C
 * 	716E ??
 * FA9D CJK COMPATIBILITY IDEOGRAPH-FA9D
 * 	77A7 ??
 * FA9E CJK COMPATIBILITY IDEOGRAPH-FA9E
 * 	7235 ??
 * FA9F CJK COMPATIBILITY IDEOGRAPH-FA9F
 * 	72AF ??
 * FAA0 CJK COMPATIBILITY IDEOGRAPH-FAA0
 * 	732A ??
 * FAA1 CJK COMPATIBILITY IDEOGRAPH-FAA1
 * 	7471 ??
 * FAA2 CJK COMPATIBILITY IDEOGRAPH-FAA2
 * 	7506 ??
 * FAA3 CJK COMPATIBILITY IDEOGRAPH-FAA3
 * 	753B ??
 * FAA4 CJK COMPATIBILITY IDEOGRAPH-FAA4
 * 	761D ??
 * FAA5 CJK COMPATIBILITY IDEOGRAPH-FAA5
 * 	761F ??
 * FAA6 CJK COMPATIBILITY IDEOGRAPH-FAA6
 * 	76CA ??
 * FAA7 CJK COMPATIBILITY IDEOGRAPH-FAA7
 * 	76DB ??
 * FAA8 CJK COMPATIBILITY IDEOGRAPH-FAA8
 * 	76F4 ??
 * FAA9 CJK COMPATIBILITY IDEOGRAPH-FAA9
 * 	774A ??
 * FAAA CJK COMPATIBILITY IDEOGRAPH-FAAA
 * 	7740 ??
 * FAAB CJK COMPATIBILITY IDEOGRAPH-FAAB
 * 	78CC ??
 * FAAC CJK COMPATIBILITY IDEOGRAPH-FAAC
 * 	7AB1 ??
 * FAAD CJK COMPATIBILITY IDEOGRAPH-FAAD
 * 	7BC0 ??
 * FAAE CJK COMPATIBILITY IDEOGRAPH-FAAE
 * 	7C7B ??
 * FAAF CJK COMPATIBILITY IDEOGRAPH-FAAF
 * 	7D5B ??
 * FAB0 CJK COMPATIBILITY IDEOGRAPH-FAB0
 * 	7DF4 ??
 * FAB1 CJK COMPATIBILITY IDEOGRAPH-FAB1
 * 	7F3E ??
 * FAB2 CJK COMPATIBILITY IDEOGRAPH-FAB2
 * 	8005 ??
 * FAB3 CJK COMPATIBILITY IDEOGRAPH-FAB3
 * 	8352 ??
 * FAB4 CJK COMPATIBILITY IDEOGRAPH-FAB4
 * 	83EF ??
 * FAB5 CJK COMPATIBILITY IDEOGRAPH-FAB5
 * 	8779 ??
 * FAB6 CJK COMPATIBILITY IDEOGRAPH-FAB6
 * 	8941 ??
 * FAB7 CJK COMPATIBILITY IDEOGRAPH-FAB7
 * 	8986 ??
 * FAB8 CJK COMPATIBILITY IDEOGRAPH-FAB8
 * 	8996 ??
 * FAB9 CJK COMPATIBILITY IDEOGRAPH-FAB9
 * 	8ABF ??
 * FABA CJK COMPATIBILITY IDEOGRAPH-FABA
 * 	8AF8 ??
 * FABB CJK COMPATIBILITY IDEOGRAPH-FABB
 * 	8ACB ??
 * FABC CJK COMPATIBILITY IDEOGRAPH-FABC
 * 	8B01 ??
 * FABD CJK COMPATIBILITY IDEOGRAPH-FABD
 * 	8AFE ??
 * FABE CJK COMPATIBILITY IDEOGRAPH-FABE
 * 	8AED ??
 * FABF CJK COMPATIBILITY IDEOGRAPH-FABF
 * 	8B39 ??
 * FAC0 CJK COMPATIBILITY IDEOGRAPH-FAC0
 * 	8B8A ??
 * FAC1 CJK COMPATIBILITY IDEOGRAPH-FAC1
 * 	8D08 ??
 * FAC2 CJK COMPATIBILITY IDEOGRAPH-FAC2
 * 	8F38 ??
 * FAC3 CJK COMPATIBILITY IDEOGRAPH-FAC3
 * 	9072 ??
 * FAC4 CJK COMPATIBILITY IDEOGRAPH-FAC4
 * 	9199 ??
 * FAC5 CJK COMPATIBILITY IDEOGRAPH-FAC5
 * 	9276 ??
 * FAC6 CJK COMPATIBILITY IDEOGRAPH-FAC6
 * 	967C ??
 * FAC7 CJK COMPATIBILITY IDEOGRAPH-FAC7
 * 	96E3 ??
 * FAC8 CJK COMPATIBILITY IDEOGRAPH-FAC8
 * 	9756 ??
 * FAC9 CJK COMPATIBILITY IDEOGRAPH-FAC9
 * 	97DB ??
 * FACA CJK COMPATIBILITY IDEOGRAPH-FACA
 * 	97FF ??
 * FACB CJK COMPATIBILITY IDEOGRAPH-FACB
 * 	980B ??
 * FACC CJK COMPATIBILITY IDEOGRAPH-FACC
 * 	983B ??
 * FACD CJK COMPATIBILITY IDEOGRAPH-FACD
 * 	9B12 ??
 * FACE CJK COMPATIBILITY IDEOGRAPH-FACE
 * 	9F9C ??
 * FAD2 CJK COMPATIBILITY IDEOGRAPH-FAD2
 * 	3B9D ??
 * FAD3 CJK COMPATIBILITY IDEOGRAPH-FAD3
 * 	4018 ??
 * FAD4 CJK COMPATIBILITY IDEOGRAPH-FAD4
 * 	4039 ??
 * FAD8 CJK COMPATIBILITY IDEOGRAPH-FAD8
 * 	9F43 ??
 * FAD9 CJK COMPATIBILITY IDEOGRAPH-FAD9
 * 	9F8E ??
 * FB00 LATIN SMALL LIGATURE FF
 * 	0066 LATIN SMALL LETTER F
 * 	0066 LATIN SMALL LETTER F
 * FB01 LATIN SMALL LIGATURE FI
 * 	0066 LATIN SMALL LETTER F
 * 	0069 LATIN SMALL LETTER I
 * FB02 LATIN SMALL LIGATURE FL
 * 	0066 LATIN SMALL LETTER F
 * 	006C LATIN SMALL LETTER L
 * FB03 LATIN SMALL LIGATURE FFI
 * 	0066 LATIN SMALL LETTER F
 * 	0066 LATIN SMALL LETTER F
 * 	0069 LATIN SMALL LETTER I
 * FB04 LATIN SMALL LIGATURE FFL
 * 	0066 LATIN SMALL LETTER F
 * 	0066 LATIN SMALL LETTER F
 * 	006C LATIN SMALL LETTER L
 * FB05 LATIN SMALL LIGATURE LONG S T
 * 	0074 LATIN SMALL LETTER T
 * 	0073 LATIN SMALL LETTER S
 * FB06 LATIN SMALL LIGATURE ST
 * 	0073 LATIN SMALL LETTER S
 * 	0074 LATIN SMALL LETTER T
 * FB13 ARMENIAN SMALL LIGATURE MEN NOW
 * 	0574 ARMENIAN SMALL LETTER MEN
 * 	0576 ARMENIAN SMALL LETTER NOW
 * FB14 ARMENIAN SMALL LIGATURE MEN ECH
 * 	0574 ARMENIAN SMALL LETTER MEN
 * 	0565 ARMENIAN SMALL LETTER ECH
 * FB15 ARMENIAN SMALL LIGATURE MEN INI
 * 	0574 ARMENIAN SMALL LETTER MEN
 * 	056B ARMENIAN SMALL LETTER INI
 * FB16 ARMENIAN SMALL LIGATURE VEW NOW
 * 	057E ARMENIAN SMALL LETTER VEW
 * 	0576 ARMENIAN SMALL LETTER NOW
 * FB17 ARMENIAN SMALL LIGATURE MEN XEH
 * 	0574 ARMENIAN SMALL LETTER MEN
 * 	056D ARMENIAN SMALL LETTER XEH
 * FB1D HEBREW LETTER YOD WITH HIRIQ
 * 	05D9 HEBREW LETTER YOD
 * FB1E HEBREW POINT JUDEO-SPANISH VARIKA
 * 	0000 <control>
 * FB1F HEBREW LIGATURE YIDDISH YOD YOD PATAH
 * 	05F2 HEBREW LIGATURE YIDDISH DOUBLE YOD
 * FB20 HEBREW LETTER ALTERNATIVE AYIN
 * 	05E2 HEBREW LETTER AYIN
 * FB21 HEBREW LETTER WIDE ALEF
 * 	05D0 HEBREW LETTER ALEF
 * FB22 HEBREW LETTER WIDE DALET
 * 	05D3 HEBREW LETTER DALET
 * FB23 HEBREW LETTER WIDE HE
 * 	05D4 HEBREW LETTER HE
 * FB24 HEBREW LETTER WIDE KAF
 * 	05DB HEBREW LETTER KAF
 * FB25 HEBREW LETTER WIDE LAMED
 * 	05DC HEBREW LETTER LAMED
 * FB26 HEBREW LETTER WIDE FINAL MEM
 * 	05DD HEBREW LETTER FINAL MEM
 * FB27 HEBREW LETTER WIDE RESH
 * 	05E8 HEBREW LETTER RESH
 * FB28 HEBREW LETTER WIDE TAV
 * 	05EA HEBREW LETTER TAV
 * FB29 HEBREW LETTER ALTERNATIVE PLUS SIGN
 * 	002B PLUS SIGN
 * FB2A HEBREW LETTER SHIN WITH SHIN DOT
 * 	05E9 HEBREW LETTER SHIN
 * FB2B HEBREW LETTER SHIN WITH SIN DOT
 * 	05E9 HEBREW LETTER SHIN
 * FB2C HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT
 * 	05E9 HEBREW LETTER SHIN
 * FB2D HEBREW LETTER SHIN WITH DAGESH AND SIN DOT
 * 	05E9 HEBREW LETTER SHIN
 * FB2E HEBREW LETTER ALEF WITH PATAH
 * 	05D0 HEBREW LETTER ALEF
 * FB2F HEBREW LETTER ALEF WITH QAMATS
 * 	05D0 HEBREW LETTER ALEF
 * FB30 HEBREW LETTER ALEF WITH MAPIQ
 * 	05D0 HEBREW LETTER ALEF
 * FB31 HEBREW LETTER BET WITH DAGESH
 * 	05D1 HEBREW LETTER BET
 * FB32 HEBREW LETTER GIMEL WITH DAGESH
 * 	05D2 HEBREW LETTER GIMEL
 * FB33 HEBREW LETTER DALET WITH DAGESH
 * 	05D3 HEBREW LETTER DALET
 * FB34 HEBREW LETTER HE WITH MAPIQ
 * 	05D4 HEBREW LETTER HE
 * FB35 HEBREW LETTER VAV WITH DAGESH
 * 	05D5 HEBREW LETTER VAV
 * FB36 HEBREW LETTER ZAYIN WITH DAGESH
 * 	05D6 HEBREW LETTER ZAYIN
 * FB38 HEBREW LETTER TET WITH DAGESH
 * 	05D8 HEBREW LETTER TET
 * FB39 HEBREW LETTER YOD WITH DAGESH
 * 	05D9 HEBREW LETTER YOD
 * FB3A HEBREW LETTER FINAL KAF WITH DAGESH
 * 	05DA HEBREW LETTER FINAL KAF
 * FB3B HEBREW LETTER KAF WITH DAGESH
 * 	05DB HEBREW LETTER KAF
 * FB3C HEBREW LETTER LAMED WITH DAGESH
 * 	05DC HEBREW LETTER LAMED
 * FB3E HEBREW LETTER MEM WITH DAGESH
 * 	05DE HEBREW LETTER MEM
 * FB40 HEBREW LETTER NUN WITH DAGESH
 * 	05E0 HEBREW LETTER NUN
 * FB41 HEBREW LETTER SAMEKH WITH DAGESH
 * 	05E1 HEBREW LETTER SAMEKH
 * FB43 HEBREW LETTER FINAL PE WITH DAGESH
 * 	05E3 HEBREW LETTER FINAL PE
 * FB44 HEBREW LETTER PE WITH DAGESH
 * 	05E4 HEBREW LETTER PE
 * FB46 HEBREW LETTER TSADI WITH DAGESH
 * 	05E6 HEBREW LETTER TSADI
 * FB47 HEBREW LETTER QOF WITH DAGESH
 * 	05E7 HEBREW LETTER QOF
 * FB48 HEBREW LETTER RESH WITH DAGESH
 * 	05E8 HEBREW LETTER RESH
 * FB49 HEBREW LETTER SHIN WITH DAGESH
 * 	05E9 HEBREW LETTER SHIN
 * FB4A HEBREW LETTER TAV WITH DAGESH
 * 	05EA HEBREW LETTER TAV
 * FB4B HEBREW LETTER VAV WITH HOLAM
 * 	05D5 HEBREW LETTER VAV
 * FB4C HEBREW LETTER BET WITH RAFE
 * 	05D1 HEBREW LETTER BET
 * FB4D HEBREW LETTER KAF WITH RAFE
 * 	05DB HEBREW LETTER KAF
 * FB4E HEBREW LETTER PE WITH RAFE
 * 	05E4 HEBREW LETTER PE
 * FB4F HEBREW LIGATURE ALEF LAMED
 * 	05D0 HEBREW LETTER ALEF
 * 	05DC HEBREW LETTER LAMED
 * FB50 ARABIC LETTER ALEF WASLA ISOLATED FORM
 * 	0671 ARABIC LETTER ALEF WASLA
 * FB51 ARABIC LETTER ALEF WASLA FINAL FORM
 * 	0671 ARABIC LETTER ALEF WASLA
 * FB52 ARABIC LETTER BEEH ISOLATED FORM
 * 	067B ARABIC LETTER BEEH
 * FB53 ARABIC LETTER BEEH FINAL FORM
 * 	067B ARABIC LETTER BEEH
 * FB54 ARABIC LETTER BEEH INITIAL FORM
 * 	067B ARABIC LETTER BEEH
 * FB55 ARABIC LETTER BEEH MEDIAL FORM
 * 	067B ARABIC LETTER BEEH
 * FB56 ARABIC LETTER PEH ISOLATED FORM
 * 	067E ARABIC LETTER PEH
 * FB57 ARABIC LETTER PEH FINAL FORM
 * 	067E ARABIC LETTER PEH
 * FB58 ARABIC LETTER PEH INITIAL FORM
 * 	067E ARABIC LETTER PEH
 * FB59 ARABIC LETTER PEH MEDIAL FORM
 * 	067E ARABIC LETTER PEH
 * FB5A ARABIC LETTER BEHEH ISOLATED FORM
 * 	0680 ARABIC LETTER BEHEH
 * FB5B ARABIC LETTER BEHEH FINAL FORM
 * 	0680 ARABIC LETTER BEHEH
 * FB5C ARABIC LETTER BEHEH INITIAL FORM
 * 	0680 ARABIC LETTER BEHEH
 * FB5D ARABIC LETTER BEHEH MEDIAL FORM
 * 	0680 ARABIC LETTER BEHEH
 * FB5E ARABIC LETTER TTEHEH ISOLATED FORM
 * 	067A ARABIC LETTER TTEHEH
 * FB5F ARABIC LETTER TTEHEH FINAL FORM
 * 	067A ARABIC LETTER TTEHEH
 * FB60 ARABIC LETTER TTEHEH INITIAL FORM
 * 	067A ARABIC LETTER TTEHEH
 * FB61 ARABIC LETTER TTEHEH MEDIAL FORM
 * 	067A ARABIC LETTER TTEHEH
 * FB62 ARABIC LETTER TEHEH ISOLATED FORM
 * 	067F ARABIC LETTER TEHEH
 * FB63 ARABIC LETTER TEHEH FINAL FORM
 * 	067F ARABIC LETTER TEHEH
 * FB64 ARABIC LETTER TEHEH INITIAL FORM
 * 	067F ARABIC LETTER TEHEH
 * FB65 ARABIC LETTER TEHEH MEDIAL FORM
 * 	067F ARABIC LETTER TEHEH
 * FB66 ARABIC LETTER TTEH ISOLATED FORM
 * 	0679 ARABIC LETTER TTEH
 * FB67 ARABIC LETTER TTEH FINAL FORM
 * 	0679 ARABIC LETTER TTEH
 * FB68 ARABIC LETTER TTEH INITIAL FORM
 * 	0679 ARABIC LETTER TTEH
 * FB69 ARABIC LETTER TTEH MEDIAL FORM
 * 	0679 ARABIC LETTER TTEH
 * FB6A ARABIC LETTER VEH ISOLATED FORM
 * 	06A4 ARABIC LETTER VEH
 * FB6B ARABIC LETTER VEH FINAL FORM
 * 	06A4 ARABIC LETTER VEH
 * FB6C ARABIC LETTER VEH INITIAL FORM
 * 	06A4 ARABIC LETTER VEH
 * FB6D ARABIC LETTER VEH MEDIAL FORM
 * 	06A4 ARABIC LETTER VEH
 * FB6E ARABIC LETTER PEHEH ISOLATED FORM
 * 	06A6 ARABIC LETTER PEHEH
 * FB6F ARABIC LETTER PEHEH FINAL FORM
 * 	06A6 ARABIC LETTER PEHEH
 * FB70 ARABIC LETTER PEHEH INITIAL FORM
 * 	06A6 ARABIC LETTER PEHEH
 * FB71 ARABIC LETTER PEHEH MEDIAL FORM
 * 	06A6 ARABIC LETTER PEHEH
 * FB72 ARABIC LETTER DYEH ISOLATED FORM
 * 	0684 ARABIC LETTER DYEH
 * FB73 ARABIC LETTER DYEH FINAL FORM
 * 	0684 ARABIC LETTER DYEH
 * FB74 ARABIC LETTER DYEH INITIAL FORM
 * 	0684 ARABIC LETTER DYEH
 * FB75 ARABIC LETTER DYEH MEDIAL FORM
 * 	0684 ARABIC LETTER DYEH
 * FB76 ARABIC LETTER NYEH ISOLATED FORM
 * 	0683 ARABIC LETTER NYEH
 * FB77 ARABIC LETTER NYEH FINAL FORM
 * 	0683 ARABIC LETTER NYEH
 * FB78 ARABIC LETTER NYEH INITIAL FORM
 * 	0683 ARABIC LETTER NYEH
 * FB79 ARABIC LETTER NYEH MEDIAL FORM
 * 	0683 ARABIC LETTER NYEH
 * FB7A ARABIC LETTER TCHEH ISOLATED FORM
 * 	0686 ARABIC LETTER TCHEH
 * FB7B ARABIC LETTER TCHEH FINAL FORM
 * 	0686 ARABIC LETTER TCHEH
 * FB7C ARABIC LETTER TCHEH INITIAL FORM
 * 	0686 ARABIC LETTER TCHEH
 * FB7D ARABIC LETTER TCHEH MEDIAL FORM
 * 	0686 ARABIC LETTER TCHEH
 * FB7E ARABIC LETTER TCHEHEH ISOLATED FORM
 * 	0687 ARABIC LETTER TCHEHEH
 * FB7F ARABIC LETTER TCHEHEH FINAL FORM
 * 	0687 ARABIC LETTER TCHEHEH
 * FB80 ARABIC LETTER TCHEHEH INITIAL FORM
 * 	0687 ARABIC LETTER TCHEHEH
 * FB81 ARABIC LETTER TCHEHEH MEDIAL FORM
 * 	0687 ARABIC LETTER TCHEHEH
 * FB82 ARABIC LETTER DDAHAL ISOLATED FORM
 * 	068D ARABIC LETTER DDAHAL
 * FB83 ARABIC LETTER DDAHAL FINAL FORM
 * 	068D ARABIC LETTER DDAHAL
 * FB84 ARABIC LETTER DAHAL ISOLATED FORM
 * 	068C ARABIC LETTER DAHAL
 * FB85 ARABIC LETTER DAHAL FINAL FORM
 * 	068C ARABIC LETTER DAHAL
 * FB86 ARABIC LETTER DUL ISOLATED FORM
 * 	068E ARABIC LETTER DUL
 * FB87 ARABIC LETTER DUL FINAL FORM
 * 	068E ARABIC LETTER DUL
 * FB88 ARABIC LETTER DDAL ISOLATED FORM
 * 	0688 ARABIC LETTER DDAL
 * FB89 ARABIC LETTER DDAL FINAL FORM
 * 	0688 ARABIC LETTER DDAL
 * FB8A ARABIC LETTER JEH ISOLATED FORM
 * 	0698 ARABIC LETTER JEH
 * FB8B ARABIC LETTER JEH FINAL FORM
 * 	0698 ARABIC LETTER JEH
 * FB8C ARABIC LETTER RREH ISOLATED FORM
 * 	0691 ARABIC LETTER RREH
 * FB8D ARABIC LETTER RREH FINAL FORM
 * 	0691 ARABIC LETTER RREH
 * FB8E ARABIC LETTER KEHEH ISOLATED FORM
 * 	06A9 ARABIC LETTER KEHEH
 * FB8F ARABIC LETTER KEHEH FINAL FORM
 * 	06A9 ARABIC LETTER KEHEH
 * FB90 ARABIC LETTER KEHEH INITIAL FORM
 * 	06A9 ARABIC LETTER KEHEH
 * FB91 ARABIC LETTER KEHEH MEDIAL FORM
 * 	06A9 ARABIC LETTER KEHEH
 * FB92 ARABIC LETTER GAF ISOLATED FORM
 * 	06AF ARABIC LETTER GAF
 * FB93 ARABIC LETTER GAF FINAL FORM
 * 	06AF ARABIC LETTER GAF
 * FB94 ARABIC LETTER GAF INITIAL FORM
 * 	06AF ARABIC LETTER GAF
 * FB95 ARABIC LETTER GAF MEDIAL FORM
 * 	06AF ARABIC LETTER GAF
 * FB96 ARABIC LETTER GUEH ISOLATED FORM
 * 	06B3 ARABIC LETTER GUEH
 * FB97 ARABIC LETTER GUEH FINAL FORM
 * 	06B3 ARABIC LETTER GUEH
 * FB98 ARABIC LETTER GUEH INITIAL FORM
 * 	06B3 ARABIC LETTER GUEH
 * FB99 ARABIC LETTER GUEH MEDIAL FORM
 * 	06B3 ARABIC LETTER GUEH
 * FB9A ARABIC LETTER NGOEH ISOLATED FORM
 * 	06B1 ARABIC LETTER NGOEH
 * FB9B ARABIC LETTER NGOEH FINAL FORM
 * 	06B1 ARABIC LETTER NGOEH
 * FB9C ARABIC LETTER NGOEH INITIAL FORM
 * 	06B1 ARABIC LETTER NGOEH
 * FB9D ARABIC LETTER NGOEH MEDIAL FORM
 * 	06B1 ARABIC LETTER NGOEH
 * FB9E ARABIC LETTER NOON GHUNNA ISOLATED FORM
 * 	06BA ARABIC LETTER NOON GHUNNA
 * FB9F ARABIC LETTER NOON GHUNNA FINAL FORM
 * 	06BA ARABIC LETTER NOON GHUNNA
 * FBA0 ARABIC LETTER RNOON ISOLATED FORM
 * 	06BB ARABIC LETTER RNOON
 * FBA1 ARABIC LETTER RNOON FINAL FORM
 * 	06BB ARABIC LETTER RNOON
 * FBA2 ARABIC LETTER RNOON INITIAL FORM
 * 	06BB ARABIC LETTER RNOON
 * FBA3 ARABIC LETTER RNOON MEDIAL FORM
 * 	06BB ARABIC LETTER RNOON
 * FBA4 ARABIC LETTER HEH WITH YEH ABOVE ISOLATED FORM
 * 	06D5 ARABIC LETTER AE
 * FBA5 ARABIC LETTER HEH WITH YEH ABOVE FINAL FORM
 * 	06D5 ARABIC LETTER AE
 * FBA6 ARABIC LETTER HEH GOAL ISOLATED FORM
 * 	06C1 ARABIC LETTER HEH GOAL
 * FBA7 ARABIC LETTER HEH GOAL FINAL FORM
 * 	06C1 ARABIC LETTER HEH GOAL
 * FBA8 ARABIC LETTER HEH GOAL INITIAL FORM
 * 	06C1 ARABIC LETTER HEH GOAL
 * FBA9 ARABIC LETTER HEH GOAL MEDIAL FORM
 * 	06C1 ARABIC LETTER HEH GOAL
 * FBAA ARABIC LETTER HEH DOACHASHMEE ISOLATED FORM
 * 	06BE ARABIC LETTER HEH DOACHASHMEE
 * FBAB ARABIC LETTER HEH DOACHASHMEE FINAL FORM
 * 	06BE ARABIC LETTER HEH DOACHASHMEE
 * FBAC ARABIC LETTER HEH DOACHASHMEE INITIAL FORM
 * 	06BE ARABIC LETTER HEH DOACHASHMEE
 * FBAD ARABIC LETTER HEH DOACHASHMEE MEDIAL FORM
 * 	06BE ARABIC LETTER HEH DOACHASHMEE
 * FBAE ARABIC LETTER YEH BARREE ISOLATED FORM
 * 	06D2 ARABIC LETTER YEH BARREE
 * FBAF ARABIC LETTER YEH BARREE FINAL FORM
 * 	06D2 ARABIC LETTER YEH BARREE
 * FBB0 ARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORM
 * 	06D2 ARABIC LETTER YEH BARREE
 * FBB1 ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
 * 	06D2 ARABIC LETTER YEH BARREE
 * FBD3 ARABIC LETTER NG ISOLATED FORM
 * 	06AD ARABIC LETTER NG
 * FBD4 ARABIC LETTER NG FINAL FORM
 * 	06AD ARABIC LETTER NG
 * FBD5 ARABIC LETTER NG INITIAL FORM
 * 	06AD ARABIC LETTER NG
 * FBD6 ARABIC LETTER NG MEDIAL FORM
 * 	06AD ARABIC LETTER NG
 * FBD7 ARABIC LETTER U ISOLATED FORM
 * 	06C7 ARABIC LETTER U
 * FBD8 ARABIC LETTER U FINAL FORM
 * 	06C7 ARABIC LETTER U
 * FBD9 ARABIC LETTER OE ISOLATED FORM
 * 	06C6 ARABIC LETTER OE
 * FBDA ARABIC LETTER OE FINAL FORM
 * 	06C6 ARABIC LETTER OE
 * FBDB ARABIC LETTER YU ISOLATED FORM
 * 	06C8 ARABIC LETTER YU
 * FBDC ARABIC LETTER YU FINAL FORM
 * 	06C8 ARABIC LETTER YU
 * FBDD ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM
 * 	06C7 ARABIC LETTER U
 * 	0674 ARABIC LETTER HIGH HAMZA
 * FBDE ARABIC LETTER VE ISOLATED FORM
 * 	06CB ARABIC LETTER VE
 * FBDF ARABIC LETTER VE FINAL FORM
 * 	06CB ARABIC LETTER VE
 * FBE0 ARABIC LETTER KIRGHIZ OE ISOLATED FORM
 * 	06C5 ARABIC LETTER KIRGHIZ OE
 * FBE1 ARABIC LETTER KIRGHIZ OE FINAL FORM
 * 	06C5 ARABIC LETTER KIRGHIZ OE
 * FBE2 ARABIC LETTER KIRGHIZ YU ISOLATED FORM
 * 	06C9 ARABIC LETTER KIRGHIZ YU
 * FBE3 ARABIC LETTER KIRGHIZ YU FINAL FORM
 * 	06C9 ARABIC LETTER KIRGHIZ YU
 * FBE4 ARABIC LETTER E ISOLATED FORM
 * 	06D0 ARABIC LETTER E
 * FBE5 ARABIC LETTER E FINAL FORM
 * 	06D0 ARABIC LETTER E
 * FBE6 ARABIC LETTER E INITIAL FORM
 * 	06D0 ARABIC LETTER E
 * FBE7 ARABIC LETTER E MEDIAL FORM
 * 	06D0 ARABIC LETTER E
 * FBE8 ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FBE9 ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FBEA ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * 	064A ARABIC LETTER YEH
 * FBEB ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORM
 * 	0627 ARABIC LETTER ALEF
 * 	064A ARABIC LETTER YEH
 * FBEC ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORM
 * 	06D5 ARABIC LETTER AE
 * 	064A ARABIC LETTER YEH
 * FBED ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM
 * 	06D5 ARABIC LETTER AE
 * 	064A ARABIC LETTER YEH
 * FBEE ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORM
 * 	0648 ARABIC LETTER WAW
 * 	064A ARABIC LETTER YEH
 * FBEF ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL FORM
 * 	0648 ARABIC LETTER WAW
 * 	064A ARABIC LETTER YEH
 * FBF0 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORM
 * 	06C7 ARABIC LETTER U
 * 	064A ARABIC LETTER YEH
 * FBF1 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORM
 * 	06C7 ARABIC LETTER U
 * 	064A ARABIC LETTER YEH
 * FBF2 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORM
 * 	06C6 ARABIC LETTER OE
 * 	064A ARABIC LETTER YEH
 * FBF3 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORM
 * 	06C6 ARABIC LETTER OE
 * 	064A ARABIC LETTER YEH
 * FBF4 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORM
 * 	06C8 ARABIC LETTER YU
 * 	064A ARABIC LETTER YEH
 * FBF5 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORM
 * 	06C8 ARABIC LETTER YU
 * 	064A ARABIC LETTER YEH
 * FBF6 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORM
 * 	06D0 ARABIC LETTER E
 * 	064A ARABIC LETTER YEH
 * FBF7 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORM
 * 	06D0 ARABIC LETTER E
 * 	064A ARABIC LETTER YEH
 * FBF8 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL FORM
 * 	06D0 ARABIC LETTER E
 * 	064A ARABIC LETTER YEH
 * FBF9 ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * 	064A ARABIC LETTER YEH
 * FBFA ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * 	064A ARABIC LETTER YEH
 * FBFB ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * 	064A ARABIC LETTER YEH
 * FBFC ARABIC LETTER FARSI YEH ISOLATED FORM
 * 	06CC ARABIC LETTER FARSI YEH
 * FBFD ARABIC LETTER FARSI YEH FINAL FORM
 * 	06CC ARABIC LETTER FARSI YEH
 * FBFE ARABIC LETTER FARSI YEH INITIAL FORM
 * 	06CC ARABIC LETTER FARSI YEH
 * FBFF ARABIC LETTER FARSI YEH MEDIAL FORM
 * 	06CC ARABIC LETTER FARSI YEH
 * FC00 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM ISOLATED FORM
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FC01 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATED FORM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FC02 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FC03 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * 	064A ARABIC LETTER YEH
 * FC04 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	064A ARABIC LETTER YEH
 * FC05 ARABIC LIGATURE BEH WITH JEEM ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * 	062C ARABIC LETTER JEEM
 * FC06 ARABIC LIGATURE BEH WITH HAH ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * 	062D ARABIC LETTER HAH
 * FC07 ARABIC LIGATURE BEH WITH KHAH ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * 	062E ARABIC LETTER KHAH
 * FC08 ARABIC LIGATURE BEH WITH MEEM ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * 	0645 ARABIC LETTER MEEM
 * FC09 ARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC0A ARABIC LIGATURE BEH WITH YEH ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * 	064A ARABIC LETTER YEH
 * FC0B ARABIC LIGATURE TEH WITH JEEM ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * 	062C ARABIC LETTER JEEM
 * FC0C ARABIC LIGATURE TEH WITH HAH ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * 	062D ARABIC LETTER HAH
 * FC0D ARABIC LIGATURE TEH WITH KHAH ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * 	062E ARABIC LETTER KHAH
 * FC0E ARABIC LIGATURE TEH WITH MEEM ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * FC0F ARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC10 ARABIC LIGATURE TEH WITH YEH ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * 	064A ARABIC LETTER YEH
 * FC11 ARABIC LIGATURE THEH WITH JEEM ISOLATED FORM
 * 	062B ARABIC LETTER THEH
 * 	062C ARABIC LETTER JEEM
 * FC12 ARABIC LIGATURE THEH WITH MEEM ISOLATED FORM
 * 	062B ARABIC LETTER THEH
 * 	0645 ARABIC LETTER MEEM
 * FC13 ARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORM
 * 	062B ARABIC LETTER THEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC14 ARABIC LIGATURE THEH WITH YEH ISOLATED FORM
 * 	062B ARABIC LETTER THEH
 * 	064A ARABIC LETTER YEH
 * FC15 ARABIC LIGATURE JEEM WITH HAH ISOLATED FORM
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * FC16 ARABIC LIGATURE JEEM WITH MEEM ISOLATED FORM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FC17 ARABIC LIGATURE HAH WITH JEEM ISOLATED FORM
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * FC18 ARABIC LIGATURE HAH WITH MEEM ISOLATED FORM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FC19 ARABIC LIGATURE KHAH WITH JEEM ISOLATED FORM
 * 	062E ARABIC LETTER KHAH
 * 	062C ARABIC LETTER JEEM
 * FC1A ARABIC LIGATURE KHAH WITH HAH ISOLATED FORM
 * 	062E ARABIC LETTER KHAH
 * 	062D ARABIC LETTER HAH
 * FC1B ARABIC LIGATURE KHAH WITH MEEM ISOLATED FORM
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FC1C ARABIC LIGATURE SEEN WITH JEEM ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062C ARABIC LETTER JEEM
 * FC1D ARABIC LIGATURE SEEN WITH HAH ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062D ARABIC LETTER HAH
 * FC1E ARABIC LIGATURE SEEN WITH KHAH ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062E ARABIC LETTER KHAH
 * FC1F ARABIC LIGATURE SEEN WITH MEEM ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * FC20 ARABIC LIGATURE SAD WITH HAH ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	062D ARABIC LETTER HAH
 * FC21 ARABIC LIGATURE SAD WITH MEEM ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	0645 ARABIC LETTER MEEM
 * FC22 ARABIC LIGATURE DAD WITH JEEM ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	062C ARABIC LETTER JEEM
 * FC23 ARABIC LIGATURE DAD WITH HAH ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	062D ARABIC LETTER HAH
 * FC24 ARABIC LIGATURE DAD WITH KHAH ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	062E ARABIC LETTER KHAH
 * FC25 ARABIC LIGATURE DAD WITH MEEM ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	0645 ARABIC LETTER MEEM
 * FC26 ARABIC LIGATURE TAH WITH HAH ISOLATED FORM
 * 	0637 ARABIC LETTER TAH
 * 	062D ARABIC LETTER HAH
 * FC27 ARABIC LIGATURE TAH WITH MEEM ISOLATED FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * FC28 ARABIC LIGATURE ZAH WITH MEEM ISOLATED FORM
 * 	0638 ARABIC LETTER ZAH
 * 	0645 ARABIC LETTER MEEM
 * FC29 ARABIC LIGATURE AIN WITH JEEM ISOLATED FORM
 * 	0639 ARABIC LETTER AIN
 * 	062C ARABIC LETTER JEEM
 * FC2A ARABIC LIGATURE AIN WITH MEEM ISOLATED FORM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * FC2B ARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORM
 * 	063A ARABIC LETTER GHAIN
 * 	062C ARABIC LETTER JEEM
 * FC2C ARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0645 ARABIC LETTER MEEM
 * FC2D ARABIC LIGATURE FEH WITH JEEM ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * 	062C ARABIC LETTER JEEM
 * FC2E ARABIC LIGATURE FEH WITH HAH ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * 	062D ARABIC LETTER HAH
 * FC2F ARABIC LIGATURE FEH WITH KHAH ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * 	062E ARABIC LETTER KHAH
 * FC30 ARABIC LIGATURE FEH WITH MEEM ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * 	0645 ARABIC LETTER MEEM
 * FC31 ARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC32 ARABIC LIGATURE FEH WITH YEH ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * 	064A ARABIC LETTER YEH
 * FC33 ARABIC LIGATURE QAF WITH HAH ISOLATED FORM
 * 	0642 ARABIC LETTER QAF
 * 	062D ARABIC LETTER HAH
 * FC34 ARABIC LIGATURE QAF WITH MEEM ISOLATED FORM
 * 	0642 ARABIC LETTER QAF
 * 	0645 ARABIC LETTER MEEM
 * FC35 ARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORM
 * 	0642 ARABIC LETTER QAF
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC36 ARABIC LIGATURE QAF WITH YEH ISOLATED FORM
 * 	0642 ARABIC LETTER QAF
 * 	064A ARABIC LETTER YEH
 * FC37 ARABIC LIGATURE KAF WITH ALEF ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	0627 ARABIC LETTER ALEF
 * FC38 ARABIC LIGATURE KAF WITH JEEM ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	062C ARABIC LETTER JEEM
 * FC39 ARABIC LIGATURE KAF WITH HAH ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	062D ARABIC LETTER HAH
 * FC3A ARABIC LIGATURE KAF WITH KHAH ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	062E ARABIC LETTER KHAH
 * FC3B ARABIC LIGATURE KAF WITH LAM ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	0644 ARABIC LETTER LAM
 * FC3C ARABIC LIGATURE KAF WITH MEEM ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * FC3D ARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC3E ARABIC LIGATURE KAF WITH YEH ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	064A ARABIC LETTER YEH
 * FC3F ARABIC LIGATURE LAM WITH JEEM ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * FC40 ARABIC LIGATURE LAM WITH HAH ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	062D ARABIC LETTER HAH
 * FC41 ARABIC LIGATURE LAM WITH KHAH ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	062E ARABIC LETTER KHAH
 * FC42 ARABIC LIGATURE LAM WITH MEEM ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * FC43 ARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC44 ARABIC LIGATURE LAM WITH YEH ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	064A ARABIC LETTER YEH
 * FC45 ARABIC LIGATURE MEEM WITH JEEM ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * FC46 ARABIC LIGATURE MEEM WITH HAH ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FC47 ARABIC LIGATURE MEEM WITH KHAH ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * FC48 ARABIC LIGATURE MEEM WITH MEEM ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FC49 ARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC4A ARABIC LIGATURE MEEM WITH YEH ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FC4B ARABIC LIGATURE NOON WITH JEEM ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * FC4C ARABIC LIGATURE NOON WITH HAH ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * 	062D ARABIC LETTER HAH
 * FC4D ARABIC LIGATURE NOON WITH KHAH ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * 	062E ARABIC LETTER KHAH
 * FC4E ARABIC LIGATURE NOON WITH MEEM ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * 	0645 ARABIC LETTER MEEM
 * FC4F ARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC50 ARABIC LIGATURE NOON WITH YEH ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * 	064A ARABIC LETTER YEH
 * FC51 ARABIC LIGATURE HEH WITH JEEM ISOLATED FORM
 * 	0647 ARABIC LETTER HEH
 * 	062C ARABIC LETTER JEEM
 * FC52 ARABIC LIGATURE HEH WITH MEEM ISOLATED FORM
 * 	0647 ARABIC LETTER HEH
 * 	0645 ARABIC LETTER MEEM
 * FC53 ARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED FORM
 * 	0647 ARABIC LETTER HEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC54 ARABIC LIGATURE HEH WITH YEH ISOLATED FORM
 * 	0647 ARABIC LETTER HEH
 * 	064A ARABIC LETTER YEH
 * FC55 ARABIC LIGATURE YEH WITH JEEM ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	062C ARABIC LETTER JEEM
 * FC56 ARABIC LIGATURE YEH WITH HAH ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	062D ARABIC LETTER HAH
 * FC57 ARABIC LIGATURE YEH WITH KHAH ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	062E ARABIC LETTER KHAH
 * FC58 ARABIC LIGATURE YEH WITH MEEM ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * FC59 ARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC5A ARABIC LIGATURE YEH WITH YEH ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	064A ARABIC LETTER YEH
 * FC5B ARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED FORM
 * 	0630 ARABIC LETTER THAL
 * FC5C ARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORM
 * 	0631 ARABIC LETTER REH
 * FC5D ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC5E ARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORM
 * 	0020 SPACE
 * FC5F ARABIC LIGATURE SHADDA WITH KASRATAN ISOLATED FORM
 * 	0020 SPACE
 * FC60 ARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM
 * 	0020 SPACE
 * FC61 ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORM
 * 	0020 SPACE
 * FC62 ARABIC LIGATURE SHADDA WITH KASRA ISOLATED FORM
 * 	0020 SPACE
 * FC63 ARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORM
 * 	0020 SPACE
 * FC64 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM
 * 	0631 ARABIC LETTER REH
 * 	064A ARABIC LETTER YEH
 * FC65 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORM
 * 	0632 ARABIC LETTER ZAIN
 * 	064A ARABIC LETTER YEH
 * FC66 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FC67 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	064A ARABIC LETTER YEH
 * FC68 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * 	064A ARABIC LETTER YEH
 * FC69 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	064A ARABIC LETTER YEH
 * FC6A ARABIC LIGATURE BEH WITH REH FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0631 ARABIC LETTER REH
 * FC6B ARABIC LIGATURE BEH WITH ZAIN FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0632 ARABIC LETTER ZAIN
 * FC6C ARABIC LIGATURE BEH WITH MEEM FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0645 ARABIC LETTER MEEM
 * FC6D ARABIC LIGATURE BEH WITH NOON FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0646 ARABIC LETTER NOON
 * FC6E ARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC6F ARABIC LIGATURE BEH WITH YEH FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	064A ARABIC LETTER YEH
 * FC70 ARABIC LIGATURE TEH WITH REH FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0631 ARABIC LETTER REH
 * FC71 ARABIC LIGATURE TEH WITH ZAIN FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0632 ARABIC LETTER ZAIN
 * FC72 ARABIC LIGATURE TEH WITH MEEM FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * FC73 ARABIC LIGATURE TEH WITH NOON FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0646 ARABIC LETTER NOON
 * FC74 ARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC75 ARABIC LIGATURE TEH WITH YEH FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	064A ARABIC LETTER YEH
 * FC76 ARABIC LIGATURE THEH WITH REH FINAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0631 ARABIC LETTER REH
 * FC77 ARABIC LIGATURE THEH WITH ZAIN FINAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0632 ARABIC LETTER ZAIN
 * FC78 ARABIC LIGATURE THEH WITH MEEM FINAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0645 ARABIC LETTER MEEM
 * FC79 ARABIC LIGATURE THEH WITH NOON FINAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0646 ARABIC LETTER NOON
 * FC7A ARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC7B ARABIC LIGATURE THEH WITH YEH FINAL FORM
 * 	062B ARABIC LETTER THEH
 * 	064A ARABIC LETTER YEH
 * FC7C ARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC7D ARABIC LIGATURE FEH WITH YEH FINAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	064A ARABIC LETTER YEH
 * FC7E ARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC7F ARABIC LIGATURE QAF WITH YEH FINAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	064A ARABIC LETTER YEH
 * FC80 ARABIC LIGATURE KAF WITH ALEF FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0627 ARABIC LETTER ALEF
 * FC81 ARABIC LIGATURE KAF WITH LAM FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0644 ARABIC LETTER LAM
 * FC82 ARABIC LIGATURE KAF WITH MEEM FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * FC83 ARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC84 ARABIC LIGATURE KAF WITH YEH FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	064A ARABIC LETTER YEH
 * FC85 ARABIC LIGATURE LAM WITH MEEM FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * FC86 ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC87 ARABIC LIGATURE LAM WITH YEH FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	064A ARABIC LETTER YEH
 * FC88 ARABIC LIGATURE MEEM WITH ALEF FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	0627 ARABIC LETTER ALEF
 * FC89 ARABIC LIGATURE MEEM WITH MEEM FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FC8A ARABIC LIGATURE NOON WITH REH FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0631 ARABIC LETTER REH
 * FC8B ARABIC LIGATURE NOON WITH ZAIN FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0632 ARABIC LETTER ZAIN
 * FC8C ARABIC LIGATURE NOON WITH MEEM FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0645 ARABIC LETTER MEEM
 * FC8D ARABIC LIGATURE NOON WITH NOON FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0646 ARABIC LETTER NOON
 * FC8E ARABIC LIGATURE NOON WITH ALEF MAKSURA FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC8F ARABIC LIGATURE NOON WITH YEH FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	064A ARABIC LETTER YEH
 * FC90 ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC91 ARABIC LIGATURE YEH WITH REH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0631 ARABIC LETTER REH
 * FC92 ARABIC LIGATURE YEH WITH ZAIN FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0632 ARABIC LETTER ZAIN
 * FC93 ARABIC LIGATURE YEH WITH MEEM FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * FC94 ARABIC LIGATURE YEH WITH NOON FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0646 ARABIC LETTER NOON
 * FC95 ARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC96 ARABIC LIGATURE YEH WITH YEH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	064A ARABIC LETTER YEH
 * FC97 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FC98 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FC99 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORM
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FC9A ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FC9B ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * 	064A ARABIC LETTER YEH
 * FC9C ARABIC LIGATURE BEH WITH JEEM INITIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	062C ARABIC LETTER JEEM
 * FC9D ARABIC LIGATURE BEH WITH HAH INITIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	062D ARABIC LETTER HAH
 * FC9E ARABIC LIGATURE BEH WITH KHAH INITIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	062E ARABIC LETTER KHAH
 * FC9F ARABIC LIGATURE BEH WITH MEEM INITIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0645 ARABIC LETTER MEEM
 * FCA0 ARABIC LIGATURE BEH WITH HEH INITIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0647 ARABIC LETTER HEH
 * FCA1 ARABIC LIGATURE TEH WITH JEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062C ARABIC LETTER JEEM
 * FCA2 ARABIC LIGATURE TEH WITH HAH INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062D ARABIC LETTER HAH
 * FCA3 ARABIC LIGATURE TEH WITH KHAH INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062E ARABIC LETTER KHAH
 * FCA4 ARABIC LIGATURE TEH WITH MEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * FCA5 ARABIC LIGATURE TEH WITH HEH INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0647 ARABIC LETTER HEH
 * FCA6 ARABIC LIGATURE THEH WITH MEEM INITIAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0645 ARABIC LETTER MEEM
 * FCA7 ARABIC LIGATURE JEEM WITH HAH INITIAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * FCA8 ARABIC LIGATURE JEEM WITH MEEM INITIAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FCA9 ARABIC LIGATURE HAH WITH JEEM INITIAL FORM
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * FCAA ARABIC LIGATURE HAH WITH MEEM INITIAL FORM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FCAB ARABIC LIGATURE KHAH WITH JEEM INITIAL FORM
 * 	062E ARABIC LETTER KHAH
 * 	062C ARABIC LETTER JEEM
 * FCAC ARABIC LIGATURE KHAH WITH MEEM INITIAL FORM
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FCAD ARABIC LIGATURE SEEN WITH JEEM INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062C ARABIC LETTER JEEM
 * FCAE ARABIC LIGATURE SEEN WITH HAH INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062D ARABIC LETTER HAH
 * FCAF ARABIC LIGATURE SEEN WITH KHAH INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062E ARABIC LETTER KHAH
 * FCB0 ARABIC LIGATURE SEEN WITH MEEM INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * FCB1 ARABIC LIGATURE SAD WITH HAH INITIAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	062D ARABIC LETTER HAH
 * FCB2 ARABIC LIGATURE SAD WITH KHAH INITIAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	062E ARABIC LETTER KHAH
 * FCB3 ARABIC LIGATURE SAD WITH MEEM INITIAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	0645 ARABIC LETTER MEEM
 * FCB4 ARABIC LIGATURE DAD WITH JEEM INITIAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062C ARABIC LETTER JEEM
 * FCB5 ARABIC LIGATURE DAD WITH HAH INITIAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062D ARABIC LETTER HAH
 * FCB6 ARABIC LIGATURE DAD WITH KHAH INITIAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062E ARABIC LETTER KHAH
 * FCB7 ARABIC LIGATURE DAD WITH MEEM INITIAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	0645 ARABIC LETTER MEEM
 * FCB8 ARABIC LIGATURE TAH WITH HAH INITIAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	062D ARABIC LETTER HAH
 * FCB9 ARABIC LIGATURE ZAH WITH MEEM INITIAL FORM
 * 	0638 ARABIC LETTER ZAH
 * 	0645 ARABIC LETTER MEEM
 * FCBA ARABIC LIGATURE AIN WITH JEEM INITIAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	062C ARABIC LETTER JEEM
 * FCBB ARABIC LIGATURE AIN WITH MEEM INITIAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * FCBC ARABIC LIGATURE GHAIN WITH JEEM INITIAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	062C ARABIC LETTER JEEM
 * FCBD ARABIC LIGATURE GHAIN WITH MEEM INITIAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0645 ARABIC LETTER MEEM
 * FCBE ARABIC LIGATURE FEH WITH JEEM INITIAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	062C ARABIC LETTER JEEM
 * FCBF ARABIC LIGATURE FEH WITH HAH INITIAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	062D ARABIC LETTER HAH
 * FCC0 ARABIC LIGATURE FEH WITH KHAH INITIAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	062E ARABIC LETTER KHAH
 * FCC1 ARABIC LIGATURE FEH WITH MEEM INITIAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	0645 ARABIC LETTER MEEM
 * FCC2 ARABIC LIGATURE QAF WITH HAH INITIAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	062D ARABIC LETTER HAH
 * FCC3 ARABIC LIGATURE QAF WITH MEEM INITIAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	0645 ARABIC LETTER MEEM
 * FCC4 ARABIC LIGATURE KAF WITH JEEM INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	062C ARABIC LETTER JEEM
 * FCC5 ARABIC LIGATURE KAF WITH HAH INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	062D ARABIC LETTER HAH
 * FCC6 ARABIC LIGATURE KAF WITH KHAH INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	062E ARABIC LETTER KHAH
 * FCC7 ARABIC LIGATURE KAF WITH LAM INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0644 ARABIC LETTER LAM
 * FCC8 ARABIC LIGATURE KAF WITH MEEM INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * FCC9 ARABIC LIGATURE LAM WITH JEEM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * FCCA ARABIC LIGATURE LAM WITH HAH INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062D ARABIC LETTER HAH
 * FCCB ARABIC LIGATURE LAM WITH KHAH INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062E ARABIC LETTER KHAH
 * FCCC ARABIC LIGATURE LAM WITH MEEM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * FCCD ARABIC LIGATURE LAM WITH HEH INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0647 ARABIC LETTER HEH
 * FCCE ARABIC LIGATURE MEEM WITH JEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * FCCF ARABIC LIGATURE MEEM WITH HAH INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FCD0 ARABIC LIGATURE MEEM WITH KHAH INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * FCD1 ARABIC LIGATURE MEEM WITH MEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FCD2 ARABIC LIGATURE NOON WITH JEEM INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * FCD3 ARABIC LIGATURE NOON WITH HAH INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062D ARABIC LETTER HAH
 * FCD4 ARABIC LIGATURE NOON WITH KHAH INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062E ARABIC LETTER KHAH
 * FCD5 ARABIC LIGATURE NOON WITH MEEM INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0645 ARABIC LETTER MEEM
 * FCD6 ARABIC LIGATURE NOON WITH HEH INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0647 ARABIC LETTER HEH
 * FCD7 ARABIC LIGATURE HEH WITH JEEM INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * 	062C ARABIC LETTER JEEM
 * FCD8 ARABIC LIGATURE HEH WITH MEEM INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * 	0645 ARABIC LETTER MEEM
 * FCD9 ARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * FCDA ARABIC LIGATURE YEH WITH JEEM INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	062C ARABIC LETTER JEEM
 * FCDB ARABIC LIGATURE YEH WITH HAH INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	062D ARABIC LETTER HAH
 * FCDC ARABIC LIGATURE YEH WITH KHAH INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	062E ARABIC LETTER KHAH
 * FCDD ARABIC LIGATURE YEH WITH MEEM INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * FCDE ARABIC LIGATURE YEH WITH HEH INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0647 ARABIC LETTER HEH
 * FCDF ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM MEDIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FCE0 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORM
 * 	0647 ARABIC LETTER HEH
 * 	064A ARABIC LETTER YEH
 * FCE1 ARABIC LIGATURE BEH WITH MEEM MEDIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0645 ARABIC LETTER MEEM
 * FCE2 ARABIC LIGATURE BEH WITH HEH MEDIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0647 ARABIC LETTER HEH
 * FCE3 ARABIC LIGATURE TEH WITH MEEM MEDIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * FCE4 ARABIC LIGATURE TEH WITH HEH MEDIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0647 ARABIC LETTER HEH
 * FCE5 ARABIC LIGATURE THEH WITH MEEM MEDIAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0645 ARABIC LETTER MEEM
 * FCE6 ARABIC LIGATURE THEH WITH HEH MEDIAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0647 ARABIC LETTER HEH
 * FCE7 ARABIC LIGATURE SEEN WITH MEEM MEDIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * FCE8 ARABIC LIGATURE SEEN WITH HEH MEDIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0647 ARABIC LETTER HEH
 * FCE9 ARABIC LIGATURE SHEEN WITH MEEM MEDIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * FCEA ARABIC LIGATURE SHEEN WITH HEH MEDIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0647 ARABIC LETTER HEH
 * FCEB ARABIC LIGATURE KAF WITH LAM MEDIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0644 ARABIC LETTER LAM
 * FCEC ARABIC LIGATURE KAF WITH MEEM MEDIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * FCED ARABIC LIGATURE LAM WITH MEEM MEDIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * FCEE ARABIC LIGATURE NOON WITH MEEM MEDIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0645 ARABIC LETTER MEEM
 * FCEF ARABIC LIGATURE NOON WITH HEH MEDIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0647 ARABIC LETTER HEH
 * FCF0 ARABIC LIGATURE YEH WITH MEEM MEDIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * FCF1 ARABIC LIGATURE YEH WITH HEH MEDIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0647 ARABIC LETTER HEH
 * FCF2 ARABIC LIGATURE SHADDA WITH FATHA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FCF3 ARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FCF4 ARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FCF5 ARABIC LIGATURE TAH WITH ALEF MAKSURA ISOLATED FORM
 * 	0637 ARABIC LETTER TAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FCF6 ARABIC LIGATURE TAH WITH YEH ISOLATED FORM
 * 	0637 ARABIC LETTER TAH
 * 	064A ARABIC LETTER YEH
 * FCF7 ARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORM
 * 	0639 ARABIC LETTER AIN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FCF8 ARABIC LIGATURE AIN WITH YEH ISOLATED FORM
 * 	0639 ARABIC LETTER AIN
 * 	064A ARABIC LETTER YEH
 * FCF9 ARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FCFA ARABIC LIGATURE GHAIN WITH YEH ISOLATED FORM
 * 	063A ARABIC LETTER GHAIN
 * 	064A ARABIC LETTER YEH
 * FCFB ARABIC LIGATURE SEEN WITH ALEF MAKSURA ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FCFC ARABIC LIGATURE SEEN WITH YEH ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	064A ARABIC LETTER YEH
 * FCFD ARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FCFE ARABIC LIGATURE SHEEN WITH YEH ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	064A ARABIC LETTER YEH
 * FCFF ARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORM
 * 	062D ARABIC LETTER HAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD00 ARABIC LIGATURE HAH WITH YEH ISOLATED FORM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FD01 ARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOLATED FORM
 * 	062C ARABIC LETTER JEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD02 ARABIC LIGATURE JEEM WITH YEH ISOLATED FORM
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FD03 ARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORM
 * 	062E ARABIC LETTER KHAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD04 ARABIC LIGATURE KHAH WITH YEH ISOLATED FORM
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FD05 ARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD06 ARABIC LIGATURE SAD WITH YEH ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	064A ARABIC LETTER YEH
 * FD07 ARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD08 ARABIC LIGATURE DAD WITH YEH ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	064A ARABIC LETTER YEH
 * FD09 ARABIC LIGATURE SHEEN WITH JEEM ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062C ARABIC LETTER JEEM
 * FD0A ARABIC LIGATURE SHEEN WITH HAH ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * FD0B ARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062E ARABIC LETTER KHAH
 * FD0C ARABIC LIGATURE SHEEN WITH MEEM ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * FD0D ARABIC LIGATURE SHEEN WITH REH ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0631 ARABIC LETTER REH
 * FD0E ARABIC LIGATURE SEEN WITH REH ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0631 ARABIC LETTER REH
 * FD0F ARABIC LIGATURE SAD WITH REH ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	0631 ARABIC LETTER REH
 * FD10 ARABIC LIGATURE DAD WITH REH ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	0631 ARABIC LETTER REH
 * FD11 ARABIC LIGATURE TAH WITH ALEF MAKSURA FINAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD12 ARABIC LIGATURE TAH WITH YEH FINAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	064A ARABIC LETTER YEH
 * FD13 ARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD14 ARABIC LIGATURE AIN WITH YEH FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	064A ARABIC LETTER YEH
 * FD15 ARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD16 ARABIC LIGATURE GHAIN WITH YEH FINAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	064A ARABIC LETTER YEH
 * FD17 ARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD18 ARABIC LIGATURE SEEN WITH YEH FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	064A ARABIC LETTER YEH
 * FD19 ARABIC LIGATURE SHEEN WITH ALEF MAKSURA FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD1A ARABIC LIGATURE SHEEN WITH YEH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	064A ARABIC LETTER YEH
 * FD1B ARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORM
 * 	062D ARABIC LETTER HAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD1C ARABIC LIGATURE HAH WITH YEH FINAL FORM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FD1D ARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD1E ARABIC LIGATURE JEEM WITH YEH FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FD1F ARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORM
 * 	062E ARABIC LETTER KHAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD20 ARABIC LIGATURE KHAH WITH YEH FINAL FORM
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FD21 ARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD22 ARABIC LIGATURE SAD WITH YEH FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	064A ARABIC LETTER YEH
 * FD23 ARABIC LIGATURE DAD WITH ALEF MAKSURA FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD24 ARABIC LIGATURE DAD WITH YEH FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	064A ARABIC LETTER YEH
 * FD25 ARABIC LIGATURE SHEEN WITH JEEM FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062C ARABIC LETTER JEEM
 * FD26 ARABIC LIGATURE SHEEN WITH HAH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * FD27 ARABIC LIGATURE SHEEN WITH KHAH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062E ARABIC LETTER KHAH
 * FD28 ARABIC LIGATURE SHEEN WITH MEEM FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * FD29 ARABIC LIGATURE SHEEN WITH REH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0631 ARABIC LETTER REH
 * FD2A ARABIC LIGATURE SEEN WITH REH FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0631 ARABIC LETTER REH
 * FD2B ARABIC LIGATURE SAD WITH REH FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	0631 ARABIC LETTER REH
 * FD2C ARABIC LIGATURE DAD WITH REH FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	0631 ARABIC LETTER REH
 * FD2D ARABIC LIGATURE SHEEN WITH JEEM INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062C ARABIC LETTER JEEM
 * FD2E ARABIC LIGATURE SHEEN WITH HAH INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * FD2F ARABIC LIGATURE SHEEN WITH KHAH INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062E ARABIC LETTER KHAH
 * FD30 ARABIC LIGATURE SHEEN WITH MEEM INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * FD31 ARABIC LIGATURE SEEN WITH HEH INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0647 ARABIC LETTER HEH
 * FD32 ARABIC LIGATURE SHEEN WITH HEH INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0647 ARABIC LETTER HEH
 * FD33 ARABIC LIGATURE TAH WITH MEEM INITIAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * FD34 ARABIC LIGATURE SEEN WITH JEEM MEDIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062C ARABIC LETTER JEEM
 * FD35 ARABIC LIGATURE SEEN WITH HAH MEDIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062D ARABIC LETTER HAH
 * FD36 ARABIC LIGATURE SEEN WITH KHAH MEDIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062E ARABIC LETTER KHAH
 * FD37 ARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062C ARABIC LETTER JEEM
 * FD38 ARABIC LIGATURE SHEEN WITH HAH MEDIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * FD39 ARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062E ARABIC LETTER KHAH
 * FD3A ARABIC LIGATURE TAH WITH MEEM MEDIAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * FD3B ARABIC LIGATURE ZAH WITH MEEM MEDIAL FORM
 * 	0638 ARABIC LETTER ZAH
 * 	0645 ARABIC LETTER MEEM
 * FD3C ARABIC LIGATURE ALEF WITH FATHATAN FINAL FORM
 * 	0627 ARABIC LETTER ALEF
 * FD3D ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * FD50 ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FD51 ARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * FD52 ARABIC LIGATURE TEH WITH HAH WITH JEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * FD53 ARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FD54 ARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD55 ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * FD56 ARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD57 ARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * FD58 ARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD59 ARABIC LIGATURE JEEM WITH MEEM WITH HAH INITIAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD5A ARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FD5B ARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD5C ARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * FD5D ARABIC LIGATURE SEEN WITH JEEM WITH HAH INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * FD5E ARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062C ARABIC LETTER JEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD5F ARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD60 ARABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD61 ARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * FD62 ARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD63 ARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD64 ARABIC LIGATURE SAD WITH HAH WITH HAH FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	062D ARABIC LETTER HAH
 * 	062D ARABIC LETTER HAH
 * FD65 ARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	062D ARABIC LETTER HAH
 * 	062D ARABIC LETTER HAH
 * FD66 ARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD67 ARABIC LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FD68 ARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FD69 ARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FD6A ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * FD6B ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * FD6C ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD6D ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD6E ARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062D ARABIC LETTER HAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD6F ARABIC LIGATURE DAD WITH KHAH WITH MEEM FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD70 ARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD71 ARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD72 ARABIC LIGATURE TAH WITH MEEM WITH HAH INITIAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD73 ARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD74 ARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FD75 ARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FD76 ARABIC LIGATURE AIN WITH MEEM WITH MEEM FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD77 ARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD78 ARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD79 ARABIC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD7A ARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FD7B ARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD7C ARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD7D ARABIC LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD7E ARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD7F ARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD80 ARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FD81 ARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FD82 ARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062D ARABIC LETTER HAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD83 ARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * 	062C ARABIC LETTER JEEM
 * FD84 ARABIC LIGATURE LAM WITH JEEM WITH JEEM FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * 	062C ARABIC LETTER JEEM
 * FD85 ARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD86 ARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD87 ARABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD88 ARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD89 ARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * FD8A ARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FD8B ARABIC LIGATURE MEEM WITH HAH WITH YEH FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FD8C ARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * FD8D ARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FD8E ARABIC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * 	062C ARABIC LETTER JEEM
 * FD8F ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD92 ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * 	062E ARABIC LETTER KHAH
 * FD93 ARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * FD94 ARABIC LIGATURE HEH WITH MEEM WITH MEEM INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD95 ARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FD96 ARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062D ARABIC LETTER HAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD97 ARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FD98 ARABIC LIGATURE NOON WITH JEEM WITH MEEM INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FD99 ARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD9A ARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FD9B ARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD9C ARABIC LIGATURE YEH WITH MEEM WITH MEEM FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD9D ARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD9E ARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FD9F ARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FDA0 ARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062C ARABIC LETTER JEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDA1 ARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FDA2 ARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062E ARABIC LETTER KHAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDA3 ARABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDA4 ARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDA5 ARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDA6 ARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDA7 ARABIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDA8 ARABIC LIGATURE SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062E ARABIC LETTER KHAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDA9 ARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDAA ARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDAB ARABIC LIGATURE DAD WITH HAH WITH YEH FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDAC ARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FDAD ARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDAE ARABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDAF ARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FDB0 ARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDB1 ARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDB2 ARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDB3 ARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDB4 ARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FDB5 ARABIC LIGATURE LAM WITH HAH WITH MEEM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FDB6 ARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDB7 ARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDB8 ARABIC LIGATURE NOON WITH JEEM WITH HAH INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * FDB9 ARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FDBA ARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FDBB ARABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FDBC ARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FDBD ARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * FDBE ARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDBF ARABIC LIGATURE HAH WITH JEEM WITH YEH FINAL FORM
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FDC0 ARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FDC1 ARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDC2 ARABIC LIGATURE BEH WITH HAH WITH YEH FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDC3 ARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FDC4 ARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FDC5 ARABIC LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FDC6 ARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FDC7 ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FDF0 ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	0644 ARABIC LETTER LAM
 * 	06D2 ARABIC LETTER YEH BARREE
 * FDF1 ARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORM
 * 	0642 ARABIC LETTER QAF
 * 	0644 ARABIC LETTER LAM
 * 	06D2 ARABIC LETTER YEH BARREE
 * FDF2 ARABIC LIGATURE ALLAH ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * 	0644 ARABIC LETTER LAM
 * 	0644 ARABIC LETTER LAM
 * 	0647 ARABIC LETTER HEH
 * FDF3 ARABIC LIGATURE AKBAR ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * 	0643 ARABIC LETTER KAF
 * 	0628 ARABIC LETTER BEH
 * 	0631 ARABIC LETTER REH
 * FDF4 ARABIC LIGATURE MOHAMMAD ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * 	062F ARABIC LETTER DAL
 * FDF5 ARABIC LIGATURE SALAM ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	0644 ARABIC LETTER LAM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * FDF6 ARABIC LIGATURE RASOUL ISOLATED FORM
 * 	0631 ARABIC LETTER REH
 * 	0633 ARABIC LETTER SEEN
 * 	0648 ARABIC LETTER WAW
 * 	0644 ARABIC LETTER LAM
 * FDF7 ARABIC LIGATURE ALAYHE ISOLATED FORM
 * 	0639 ARABIC LETTER AIN
 * 	0644 ARABIC LETTER LAM
 * 	064A ARABIC LETTER YEH
 * 	0647 ARABIC LETTER HEH
 * FDF8 ARABIC LIGATURE WASALLAM ISOLATED FORM
 * 	0648 ARABIC LETTER WAW
 * 	0633 ARABIC LETTER SEEN
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * FDF9 ARABIC LIGATURE SALLA ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	0644 ARABIC LETTER LAM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDFA ARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAM
 * 	0635 ARABIC LETTER SAD
 * 	0644 ARABIC LETTER LAM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * 	0020 SPACE
 * 	0627 ARABIC LETTER ALEF
 * 	0644 ARABIC LETTER LAM
 * 	0644 ARABIC LETTER LAM
 * 	0647 ARABIC LETTER HEH
 * 	0020 SPACE
 * 	0639 ARABIC LETTER AIN
 * 	0644 ARABIC LETTER LAM
 * 	064A ARABIC LETTER YEH
 * 	0647 ARABIC LETTER HEH
 * 	0020 SPACE
 * 	0648 ARABIC LETTER WAW
 * 	0633 ARABIC LETTER SEEN
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * FDFB ARABIC LIGATURE JALLAJALALOUHOU
 * 	062C ARABIC LETTER JEEM
 * 	0644 ARABIC LETTER LAM
 * 	0020 SPACE
 * 	062C ARABIC LETTER JEEM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * 	0644 ARABIC LETTER LAM
 * 	0647 ARABIC LETTER HEH
 * FDFC RIAL SIGN
 * 	0631 ARABIC LETTER REH
 * 	06CC ARABIC LETTER FARSI YEH
 * 	0627 ARABIC LETTER ALEF
 * 	0644 ARABIC LETTER LAM
 * FE00 VARIATION SELECTOR-1
 * 	0000 <control>
 * FE01 VARIATION SELECTOR-2
 * 	0000 <control>
 * FE02 VARIATION SELECTOR-3
 * 	0000 <control>
 * FE03 VARIATION SELECTOR-4
 * 	0000 <control>
 * FE04 VARIATION SELECTOR-5
 * 	0000 <control>
 * FE05 VARIATION SELECTOR-6
 * 	0000 <control>
 * FE06 VARIATION SELECTOR-7
 * 	0000 <control>
 * FE07 VARIATION SELECTOR-8
 * 	0000 <control>
 * FE08 VARIATION SELECTOR-9
 * 	0000 <control>
 * FE09 VARIATION SELECTOR-10
 * 	0000 <control>
 * FE0A VARIATION SELECTOR-11
 * 	0000 <control>
 * FE0B VARIATION SELECTOR-12
 * 	0000 <control>
 * FE0C VARIATION SELECTOR-13
 * 	0000 <control>
 * FE0D VARIATION SELECTOR-14
 * 	0000 <control>
 * FE0E VARIATION SELECTOR-15
 * 	0000 <control>
 * FE0F VARIATION SELECTOR-16
 * 	0000 <control>
 * FE10 PRESENTATION FORM FOR VERTICAL COMMA
 * 	002C COMMA
 * FE11 PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC COMMA
 * 	3001 IDEOGRAPHIC COMMA
 * FE12 PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC FULL STOP
 * 	3002 IDEOGRAPHIC FULL STOP
 * FE13 PRESENTATION FORM FOR VERTICAL COLON
 * 	003A COLON
 * FE14 PRESENTATION FORM FOR VERTICAL SEMICOLON
 * 	003B SEMICOLON
 * FE15 PRESENTATION FORM FOR VERTICAL EXCLAMATION MARK
 * 	0021 EXCLAMATION MARK
 * FE16 PRESENTATION FORM FOR VERTICAL QUESTION MARK
 * 	003F QUESTION MARK
 * FE17 PRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKET
 * 	3016 LEFT WHITE LENTICULAR BRACKET
 * FE18 PRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCET
 * 	3017 RIGHT WHITE LENTICULAR BRACKET
 * FE19 PRESENTATION FORM FOR VERTICAL HORIZONTAL ELLIPSIS
 * 	002E FULL STOP
 * 	002E FULL STOP
 * 	002E FULL STOP
 * FE20 COMBINING LIGATURE LEFT HALF
 * 	0000 <control>
 * FE21 COMBINING LIGATURE RIGHT HALF
 * 	0000 <control>
 * FE22 COMBINING DOUBLE TILDE LEFT HALF
 * 	0000 <control>
 * FE23 COMBINING DOUBLE TILDE RIGHT HALF
 * 	0000 <control>
 * FE24 COMBINING MACRON LEFT HALF
 * 	0000 <control>
 * FE25 COMBINING MACRON RIGHT HALF
 * 	0000 <control>
 * FE26 COMBINING CONJOINING MACRON
 * 	0000 <control>
 * FE30 PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
 * 	002E FULL STOP
 * 	002E FULL STOP
 * FE31 PRESENTATION FORM FOR VERTICAL EM DASH
 * 	2014 EM DASH
 * FE32 PRESENTATION FORM FOR VERTICAL EN DASH
 * 	2013 EN DASH
 * FE33 PRESENTATION FORM FOR VERTICAL LOW LINE
 * 	005F LOW LINE
 * FE34 PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
 * 	005F LOW LINE
 * FE35 PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
 * 	0028 LEFT PARENTHESIS
 * FE36 PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
 * 	0029 RIGHT PARENTHESIS
 * FE37 PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
 * 	007B LEFT CURLY BRACKET
 * FE38 PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
 * 	007D RIGHT CURLY BRACKET
 * FE39 PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
 * 	3014 LEFT TORTOISE SHELL BRACKET
 * FE3A PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
 * 	3015 RIGHT TORTOISE SHELL BRACKET
 * FE3B PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
 * 	3010 LEFT BLACK LENTICULAR BRACKET
 * FE3C PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
 * 	3011 RIGHT BLACK LENTICULAR BRACKET
 * FE3D PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
 * 	300A LEFT DOUBLE ANGLE BRACKET
 * FE3E PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
 * 	300B RIGHT DOUBLE ANGLE BRACKET
 * FE3F PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
 * 	3008 LEFT ANGLE BRACKET
 * FE40 PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
 * 	3009 RIGHT ANGLE BRACKET
 * FE41 PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
 * 	300C LEFT CORNER BRACKET
 * FE42 PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
 * 	300D RIGHT CORNER BRACKET
 * FE43 PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
 * 	300E LEFT WHITE CORNER BRACKET
 * FE44 PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
 * 	300F RIGHT WHITE CORNER BRACKET
 * FE47 PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET
 * 	005B LEFT SQUARE BRACKET
 * FE48 PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET
 * 	005D RIGHT SQUARE BRACKET
 * FE49 DASHED OVERLINE
 * 	0020 SPACE
 * FE4A CENTRELINE OVERLINE
 * 	0020 SPACE
 * FE4B WAVY OVERLINE
 * 	0020 SPACE
 * FE4C DOUBLE WAVY OVERLINE
 * 	0020 SPACE
 * FE4D DASHED LOW LINE
 * 	005F LOW LINE
 * FE4E CENTRELINE LOW LINE
 * 	005F LOW LINE
 * FE4F WAVY LOW LINE
 * 	005F LOW LINE
 * FE50 SMALL COMMA
 * 	002C COMMA
 * FE51 SMALL IDEOGRAPHIC COMMA
 * 	3001 IDEOGRAPHIC COMMA
 * FE52 SMALL FULL STOP
 * 	002E FULL STOP
 * FE54 SMALL SEMICOLON
 * 	003B SEMICOLON
 * FE55 SMALL COLON
 * 	003A COLON
 * FE56 SMALL QUESTION MARK
 * 	003F QUESTION MARK
 * FE57 SMALL EXCLAMATION MARK
 * 	0021 EXCLAMATION MARK
 * FE58 SMALL EM DASH
 * 	2014 EM DASH
 * FE59 SMALL LEFT PARENTHESIS
 * 	0028 LEFT PARENTHESIS
 * FE5A SMALL RIGHT PARENTHESIS
 * 	0029 RIGHT PARENTHESIS
 * FE5B SMALL LEFT CURLY BRACKET
 * 	007B LEFT CURLY BRACKET
 * FE5C SMALL RIGHT CURLY BRACKET
 * 	007D RIGHT CURLY BRACKET
 * FE5D SMALL LEFT TORTOISE SHELL BRACKET
 * 	3014 LEFT TORTOISE SHELL BRACKET
 * FE5E SMALL RIGHT TORTOISE SHELL BRACKET
 * 	3015 RIGHT TORTOISE SHELL BRACKET
 * FE5F SMALL NUMBER SIGN
 * 	0023 NUMBER SIGN
 * FE60 SMALL AMPERSAND
 * 	0026 AMPERSAND
 * FE61 SMALL ASTERISK
 * 	002A ASTERISK
 * FE62 SMALL PLUS SIGN
 * 	002B PLUS SIGN
 * FE63 SMALL HYPHEN-MINUS
 * 	002D HYPHEN-MINUS
 * FE64 SMALL LESS-THAN SIGN
 * 	003C LESS-THAN SIGN
 * FE65 SMALL GREATER-THAN SIGN
 * 	003E GREATER-THAN SIGN
 * FE66 SMALL EQUALS SIGN
 * 	003D EQUALS SIGN
 * FE68 SMALL REVERSE SOLIDUS
 * 	005C REVERSE SOLIDUS
 * FE69 SMALL DOLLAR SIGN
 * 	0024 DOLLAR SIGN
 * FE6A SMALL PERCENT SIGN
 * 	0025 PERCENT SIGN
 * FE6B SMALL COMMERCIAL AT
 * 	0040 COMMERCIAL AT
 * FE70 ARABIC FATHATAN ISOLATED FORM
 * 	0020 SPACE
 * FE71 ARABIC TATWEEL WITH FATHATAN ABOVE
 * 	0640 ARABIC TATWEEL
 * FE72 ARABIC DAMMATAN ISOLATED FORM
 * 	0020 SPACE
 * FE74 ARABIC KASRATAN ISOLATED FORM
 * 	0020 SPACE
 * FE76 ARABIC FATHA ISOLATED FORM
 * 	0020 SPACE
 * FE77 ARABIC FATHA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FE78 ARABIC DAMMA ISOLATED FORM
 * 	0020 SPACE
 * FE79 ARABIC DAMMA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FE7A ARABIC KASRA ISOLATED FORM
 * 	0020 SPACE
 * FE7B ARABIC KASRA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FE7C ARABIC SHADDA ISOLATED FORM
 * 	0020 SPACE
 * FE7D ARABIC SHADDA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FE7E ARABIC SUKUN ISOLATED FORM
 * 	0020 SPACE
 * FE7F ARABIC SUKUN MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FE80 ARABIC LETTER HAMZA ISOLATED FORM
 * 	0621 ARABIC LETTER HAMZA
 * FE81 ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * FE82 ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM
 * 	0627 ARABIC LETTER ALEF
 * FE83 ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * FE84 ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM
 * 	0627 ARABIC LETTER ALEF
 * FE85 ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM
 * 	0648 ARABIC LETTER WAW
 * FE86 ARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORM
 * 	0648 ARABIC LETTER WAW
 * FE87 ARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * FE88 ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM
 * 	0627 ARABIC LETTER ALEF
 * FE89 ARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * FE8A ARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORM
 * 	064A ARABIC LETTER YEH
 * FE8B ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * FE8C ARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORM
 * 	064A ARABIC LETTER YEH
 * FE8D ARABIC LETTER ALEF ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * FE8E ARABIC LETTER ALEF FINAL FORM
 * 	0627 ARABIC LETTER ALEF
 * FE8F ARABIC LETTER BEH ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * FE90 ARABIC LETTER BEH FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * FE91 ARABIC LETTER BEH INITIAL FORM
 * 	0628 ARABIC LETTER BEH
 * FE92 ARABIC LETTER BEH MEDIAL FORM
 * 	0628 ARABIC LETTER BEH
 * FE93 ARABIC LETTER TEH MARBUTA ISOLATED FORM
 * 	0629 ARABIC LETTER TEH MARBUTA
 * FE94 ARABIC LETTER TEH MARBUTA FINAL FORM
 * 	0629 ARABIC LETTER TEH MARBUTA
 * FE95 ARABIC LETTER TEH ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * FE96 ARABIC LETTER TEH FINAL FORM
 * 	062A ARABIC LETTER TEH
 * FE97 ARABIC LETTER TEH INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * FE98 ARABIC LETTER TEH MEDIAL FORM
 * 	062A ARABIC LETTER TEH
 * FE99 ARABIC LETTER THEH ISOLATED FORM
 * 	062B ARABIC LETTER THEH
 * FE9A ARABIC LETTER THEH FINAL FORM
 * 	062B ARABIC LETTER THEH
 * FE9B ARABIC LETTER THEH INITIAL FORM
 * 	062B ARABIC LETTER THEH
 * FE9C ARABIC LETTER THEH MEDIAL FORM
 * 	062B ARABIC LETTER THEH
 * FE9D ARABIC LETTER JEEM ISOLATED FORM
 * 	062C ARABIC LETTER JEEM
 * FE9E ARABIC LETTER JEEM FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * FE9F ARABIC LETTER JEEM INITIAL FORM
 * 	062C ARABIC LETTER JEEM
 * FEA0 ARABIC LETTER JEEM MEDIAL FORM
 * 	062C ARABIC LETTER JEEM
 * FEA1 ARABIC LETTER HAH ISOLATED FORM
 * 	062D ARABIC LETTER HAH
 * FEA2 ARABIC LETTER HAH FINAL FORM
 * 	062D ARABIC LETTER HAH
 * FEA3 ARABIC LETTER HAH INITIAL FORM
 * 	062D ARABIC LETTER HAH
 * FEA4 ARABIC LETTER HAH MEDIAL FORM
 * 	062D ARABIC LETTER HAH
 * FEA5 ARABIC LETTER KHAH ISOLATED FORM
 * 	062E ARABIC LETTER KHAH
 * FEA6 ARABIC LETTER KHAH FINAL FORM
 * 	062E ARABIC LETTER KHAH
 * FEA7 ARABIC LETTER KHAH INITIAL FORM
 * 	062E ARABIC LETTER KHAH
 * FEA8 ARABIC LETTER KHAH MEDIAL FORM
 * 	062E ARABIC LETTER KHAH
 * FEA9 ARABIC LETTER DAL ISOLATED FORM
 * 	062F ARABIC LETTER DAL
 * FEAA ARABIC LETTER DAL FINAL FORM
 * 	062F ARABIC LETTER DAL
 * FEAB ARABIC LETTER THAL ISOLATED FORM
 * 	0630 ARABIC LETTER THAL
 * FEAC ARABIC LETTER THAL FINAL FORM
 * 	0630 ARABIC LETTER THAL
 * FEAD ARABIC LETTER REH ISOLATED FORM
 * 	0631 ARABIC LETTER REH
 * FEAE ARABIC LETTER REH FINAL FORM
 * 	0631 ARABIC LETTER REH
 * FEAF ARABIC LETTER ZAIN ISOLATED FORM
 * 	0632 ARABIC LETTER ZAIN
 * FEB0 ARABIC LETTER ZAIN FINAL FORM
 * 	0632 ARABIC LETTER ZAIN
 * FEB1 ARABIC LETTER SEEN ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * FEB2 ARABIC LETTER SEEN FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * FEB3 ARABIC LETTER SEEN INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * FEB4 ARABIC LETTER SEEN MEDIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * FEB5 ARABIC LETTER SHEEN ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * FEB6 ARABIC LETTER SHEEN FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * FEB7 ARABIC LETTER SHEEN INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * FEB8 ARABIC LETTER SHEEN MEDIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * FEB9 ARABIC LETTER SAD ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * FEBA ARABIC LETTER SAD FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * FEBB ARABIC LETTER SAD INITIAL FORM
 * 	0635 ARABIC LETTER SAD
 * FEBC ARABIC LETTER SAD MEDIAL FORM
 * 	0635 ARABIC LETTER SAD
 * FEBD ARABIC LETTER DAD ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * FEBE ARABIC LETTER DAD FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * FEBF ARABIC LETTER DAD INITIAL FORM
 * 	0636 ARABIC LETTER DAD
 * FEC0 ARABIC LETTER DAD MEDIAL FORM
 * 	0636 ARABIC LETTER DAD
 * FEC1 ARABIC LETTER TAH ISOLATED FORM
 * 	0637 ARABIC LETTER TAH
 * FEC2 ARABIC LETTER TAH FINAL FORM
 * 	0637 ARABIC LETTER TAH
 * FEC3 ARABIC LETTER TAH INITIAL FORM
 * 	0637 ARABIC LETTER TAH
 * FEC4 ARABIC LETTER TAH MEDIAL FORM
 * 	0637 ARABIC LETTER TAH
 * FEC5 ARABIC LETTER ZAH ISOLATED FORM
 * 	0638 ARABIC LETTER ZAH
 * FEC6 ARABIC LETTER ZAH FINAL FORM
 * 	0638 ARABIC LETTER ZAH
 * FEC7 ARABIC LETTER ZAH INITIAL FORM
 * 	0638 ARABIC LETTER ZAH
 * FEC8 ARABIC LETTER ZAH MEDIAL FORM
 * 	0638 ARABIC LETTER ZAH
 * FEC9 ARABIC LETTER AIN ISOLATED FORM
 * 	0639 ARABIC LETTER AIN
 * FECA ARABIC LETTER AIN FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * FECB ARABIC LETTER AIN INITIAL FORM
 * 	0639 ARABIC LETTER AIN
 * FECC ARABIC LETTER AIN MEDIAL FORM
 * 	0639 ARABIC LETTER AIN
 * FECD ARABIC LETTER GHAIN ISOLATED FORM
 * 	063A ARABIC LETTER GHAIN
 * FECE ARABIC LETTER GHAIN FINAL FORM
 * 	063A ARABIC LETTER GHAIN
 * FECF ARABIC LETTER GHAIN INITIAL FORM
 * 	063A ARABIC LETTER GHAIN
 * FED0 ARABIC LETTER GHAIN MEDIAL FORM
 * 	063A ARABIC LETTER GHAIN
 * FED1 ARABIC LETTER FEH ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * FED2 ARABIC LETTER FEH FINAL FORM
 * 	0641 ARABIC LETTER FEH
 * FED3 ARABIC LETTER FEH INITIAL FORM
 * 	0641 ARABIC LETTER FEH
 * FED4 ARABIC LETTER FEH MEDIAL FORM
 * 	0641 ARABIC LETTER FEH
 * FED5 ARABIC LETTER QAF ISOLATED FORM
 * 	0642 ARABIC LETTER QAF
 * FED6 ARABIC LETTER QAF FINAL FORM
 * 	0642 ARABIC LETTER QAF
 * FED7 ARABIC LETTER QAF INITIAL FORM
 * 	0642 ARABIC LETTER QAF
 * FED8 ARABIC LETTER QAF MEDIAL FORM
 * 	0642 ARABIC LETTER QAF
 * FED9 ARABIC LETTER KAF ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * FEDA ARABIC LETTER KAF FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * FEDB ARABIC LETTER KAF INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * FEDC ARABIC LETTER KAF MEDIAL FORM
 * 	0643 ARABIC LETTER KAF
 * FEDD ARABIC LETTER LAM ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * FEDE ARABIC LETTER LAM FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * FEDF ARABIC LETTER LAM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * FEE0 ARABIC LETTER LAM MEDIAL FORM
 * 	0644 ARABIC LETTER LAM
 * FEE1 ARABIC LETTER MEEM ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * FEE2 ARABIC LETTER MEEM FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * FEE3 ARABIC LETTER MEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * FEE4 ARABIC LETTER MEEM MEDIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * FEE5 ARABIC LETTER NOON ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * FEE6 ARABIC LETTER NOON FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * FEE7 ARABIC LETTER NOON INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * FEE8 ARABIC LETTER NOON MEDIAL FORM
 * 	0646 ARABIC LETTER NOON
 * FEE9 ARABIC LETTER HEH ISOLATED FORM
 * 	0647 ARABIC LETTER HEH
 * FEEA ARABIC LETTER HEH FINAL FORM
 * 	0647 ARABIC LETTER HEH
 * FEEB ARABIC LETTER HEH INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * FEEC ARABIC LETTER HEH MEDIAL FORM
 * 	0647 ARABIC LETTER HEH
 * FEED ARABIC LETTER WAW ISOLATED FORM
 * 	0648 ARABIC LETTER WAW
 * FEEE ARABIC LETTER WAW FINAL FORM
 * 	0648 ARABIC LETTER WAW
 * FEEF ARABIC LETTER ALEF MAKSURA ISOLATED FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FEF0 ARABIC LETTER ALEF MAKSURA FINAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FEF1 ARABIC LETTER YEH ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * FEF2 ARABIC LETTER YEH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * FEF3 ARABIC LETTER YEH INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * FEF4 ARABIC LETTER YEH MEDIAL FORM
 * 	064A ARABIC LETTER YEH
 * FEF5 ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEF6 ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEF7 ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEF8 ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEF9 ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEFA ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEFB ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEFC ARABIC LIGATURE LAM WITH ALEF FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FF01 FULLWIDTH EXCLAMATION MARK
 * 	0021 EXCLAMATION MARK
 * FF02 FULLWIDTH QUOTATION MARK
 * 	0022 QUOTATION MARK
 * FF03 FULLWIDTH NUMBER SIGN
 * 	0023 NUMBER SIGN
 * FF04 FULLWIDTH DOLLAR SIGN
 * 	0024 DOLLAR SIGN
 * FF05 FULLWIDTH PERCENT SIGN
 * 	0025 PERCENT SIGN
 * FF06 FULLWIDTH AMPERSAND
 * 	0026 AMPERSAND
 * FF07 FULLWIDTH APOSTROPHE
 * 	0027 APOSTROPHE
 * FF08 FULLWIDTH LEFT PARENTHESIS
 * 	0028 LEFT PARENTHESIS
 * FF09 FULLWIDTH RIGHT PARENTHESIS
 * 	0029 RIGHT PARENTHESIS
 * FF0A FULLWIDTH ASTERISK
 * 	002A ASTERISK
 * FF0B FULLWIDTH PLUS SIGN
 * 	002B PLUS SIGN
 * FF0C FULLWIDTH COMMA
 * 	002C COMMA
 * FF0D FULLWIDTH HYPHEN-MINUS
 * 	002D HYPHEN-MINUS
 * FF0E FULLWIDTH FULL STOP
 * 	002E FULL STOP
 * FF0F FULLWIDTH SOLIDUS
 * 	002F SOLIDUS
 * FF10 FULLWIDTH DIGIT ZERO
 * 	0030 DIGIT ZERO
 * FF11 FULLWIDTH DIGIT ONE
 * 	0031 DIGIT ONE
 * FF12 FULLWIDTH DIGIT TWO
 * 	0032 DIGIT TWO
 * FF13 FULLWIDTH DIGIT THREE
 * 	0033 DIGIT THREE
 * FF14 FULLWIDTH DIGIT FOUR
 * 	0034 DIGIT FOUR
 * FF15 FULLWIDTH DIGIT FIVE
 * 	0035 DIGIT FIVE
 * FF16 FULLWIDTH DIGIT SIX
 * 	0036 DIGIT SIX
 * FF17 FULLWIDTH DIGIT SEVEN
 * 	0037 DIGIT SEVEN
 * FF18 FULLWIDTH DIGIT EIGHT
 * 	0038 DIGIT EIGHT
 * FF19 FULLWIDTH DIGIT NINE
 * 	0039 DIGIT NINE
 * FF1A FULLWIDTH COLON
 * 	003A COLON
 * FF1B FULLWIDTH SEMICOLON
 * 	003B SEMICOLON
 * FF1C FULLWIDTH LESS-THAN SIGN
 * 	003C LESS-THAN SIGN
 * FF1D FULLWIDTH EQUALS SIGN
 * 	003D EQUALS SIGN
 * FF1E FULLWIDTH GREATER-THAN SIGN
 * 	003E GREATER-THAN SIGN
 * FF1F FULLWIDTH QUESTION MARK
 * 	003F QUESTION MARK
 * FF20 FULLWIDTH COMMERCIAL AT
 * 	0040 COMMERCIAL AT
 * FF21 FULLWIDTH LATIN CAPITAL LETTER A
 * 	0041 LATIN CAPITAL LETTER A
 * FF22 FULLWIDTH LATIN CAPITAL LETTER B
 * 	0042 LATIN CAPITAL LETTER B
 * FF23 FULLWIDTH LATIN CAPITAL LETTER C
 * 	0043 LATIN CAPITAL LETTER C
 * FF24 FULLWIDTH LATIN CAPITAL LETTER D
 * 	0044 LATIN CAPITAL LETTER D
 * FF25 FULLWIDTH LATIN CAPITAL LETTER E
 * 	0045 LATIN CAPITAL LETTER E
 * FF26 FULLWIDTH LATIN CAPITAL LETTER F
 * 	0046 LATIN CAPITAL LETTER F
 * FF27 FULLWIDTH LATIN CAPITAL LETTER G
 * 	0047 LATIN CAPITAL LETTER G
 * FF28 FULLWIDTH LATIN CAPITAL LETTER H
 * 	0048 LATIN CAPITAL LETTER H
 * FF29 FULLWIDTH LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * FF2A FULLWIDTH LATIN CAPITAL LETTER J
 * 	004A LATIN CAPITAL LETTER J
 * FF2B FULLWIDTH LATIN CAPITAL LETTER K
 * 	004B LATIN CAPITAL LETTER K
 * FF2C FULLWIDTH LATIN CAPITAL LETTER L
 * 	004C LATIN CAPITAL LETTER L
 * FF2D FULLWIDTH LATIN CAPITAL LETTER M
 * 	004D LATIN CAPITAL LETTER M
 * FF2E FULLWIDTH LATIN CAPITAL LETTER N
 * 	004E LATIN CAPITAL LETTER N
 * FF2F FULLWIDTH LATIN CAPITAL LETTER O
 * 	004F LATIN CAPITAL LETTER O
 * FF30 FULLWIDTH LATIN CAPITAL LETTER P
 * 	0050 LATIN CAPITAL LETTER P
 * FF31 FULLWIDTH LATIN CAPITAL LETTER Q
 * 	0051 LATIN CAPITAL LETTER Q
 * FF32 FULLWIDTH LATIN CAPITAL LETTER R
 * 	0052 LATIN CAPITAL LETTER R
 * FF33 FULLWIDTH LATIN CAPITAL LETTER S
 * 	0053 LATIN CAPITAL LETTER S
 * FF34 FULLWIDTH LATIN CAPITAL LETTER T
 * 	0054 LATIN CAPITAL LETTER T
 * FF35 FULLWIDTH LATIN CAPITAL LETTER U
 * 	0055 LATIN CAPITAL LETTER U
 * FF36 FULLWIDTH LATIN CAPITAL LETTER V
 * 	0056 LATIN CAPITAL LETTER V
 * FF37 FULLWIDTH LATIN CAPITAL LETTER W
 * 	0057 LATIN CAPITAL LETTER W
 * FF38 FULLWIDTH LATIN CAPITAL LETTER X
 * 	0058 LATIN CAPITAL LETTER X
 * FF39 FULLWIDTH LATIN CAPITAL LETTER Y
 * 	0059 LATIN CAPITAL LETTER Y
 * FF3A FULLWIDTH LATIN CAPITAL LETTER Z
 * 	005A LATIN CAPITAL LETTER Z
 * FF3B FULLWIDTH LEFT SQUARE BRACKET
 * 	005B LEFT SQUARE BRACKET
 * FF3C FULLWIDTH REVERSE SOLIDUS
 * 	005C REVERSE SOLIDUS
 * FF3D FULLWIDTH RIGHT SQUARE BRACKET
 * 	005D RIGHT SQUARE BRACKET
 * FF3E FULLWIDTH CIRCUMFLEX ACCENT
 * 	005E CIRCUMFLEX ACCENT
 * FF3F FULLWIDTH LOW LINE
 * 	005F LOW LINE
 * FF40 FULLWIDTH GRAVE ACCENT
 * 	0060 GRAVE ACCENT
 * FF41 FULLWIDTH LATIN SMALL LETTER A
 * 	0061 LATIN SMALL LETTER A
 * FF42 FULLWIDTH LATIN SMALL LETTER B
 * 	0062 LATIN SMALL LETTER B
 * FF43 FULLWIDTH LATIN SMALL LETTER C
 * 	0063 LATIN SMALL LETTER C
 * FF44 FULLWIDTH LATIN SMALL LETTER D
 * 	0064 LATIN SMALL LETTER D
 * FF45 FULLWIDTH LATIN SMALL LETTER E
 * 	0065 LATIN SMALL LETTER E
 * FF46 FULLWIDTH LATIN SMALL LETTER F
 * 	0066 LATIN SMALL LETTER F
 * FF47 FULLWIDTH LATIN SMALL LETTER G
 * 	0067 LATIN SMALL LETTER G
 * FF48 FULLWIDTH LATIN SMALL LETTER H
 * 	0068 LATIN SMALL LETTER H
 * FF49 FULLWIDTH LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * FF4A FULLWIDTH LATIN SMALL LETTER J
 * 	006A LATIN SMALL LETTER J
 * FF4B FULLWIDTH LATIN SMALL LETTER K
 * 	006B LATIN SMALL LETTER K
 * FF4C FULLWIDTH LATIN SMALL LETTER L
 * 	006C LATIN SMALL LETTER L
 * FF4D FULLWIDTH LATIN SMALL LETTER M
 * 	006D LATIN SMALL LETTER M
 * FF4E FULLWIDTH LATIN SMALL LETTER N
 * 	006E LATIN SMALL LETTER N
 * FF4F FULLWIDTH LATIN SMALL LETTER O
 * 	006F LATIN SMALL LETTER O
 * FF50 FULLWIDTH LATIN SMALL LETTER P
 * 	0070 LATIN SMALL LETTER P
 * FF51 FULLWIDTH LATIN SMALL LETTER Q
 * 	0071 LATIN SMALL LETTER Q
 * FF52 FULLWIDTH LATIN SMALL LETTER R
 * 	0072 LATIN SMALL LETTER R
 * FF53 FULLWIDTH LATIN SMALL LETTER S
 * 	0073 LATIN SMALL LETTER S
 * FF54 FULLWIDTH LATIN SMALL LETTER T
 * 	0074 LATIN SMALL LETTER T
 * FF55 FULLWIDTH LATIN SMALL LETTER U
 * 	0075 LATIN SMALL LETTER U
 * FF56 FULLWIDTH LATIN SMALL LETTER V
 * 	0076 LATIN SMALL LETTER V
 * FF57 FULLWIDTH LATIN SMALL LETTER W
 * 	0077 LATIN SMALL LETTER W
 * FF58 FULLWIDTH LATIN SMALL LETTER X
 * 	0078 LATIN SMALL LETTER X
 * FF59 FULLWIDTH LATIN SMALL LETTER Y
 * 	0079 LATIN SMALL LETTER Y
 * FF5A FULLWIDTH LATIN SMALL LETTER Z
 * 	007A LATIN SMALL LETTER Z
 * FF5B FULLWIDTH LEFT CURLY BRACKET
 * 	007B LEFT CURLY BRACKET
 * FF5C FULLWIDTH VERTICAL LINE
 * 	007C VERTICAL LINE
 * FF5D FULLWIDTH RIGHT CURLY BRACKET
 * 	007D RIGHT CURLY BRACKET
 * FF5E FULLWIDTH TILDE
 * 	007E TILDE
 * FF5F FULLWIDTH LEFT WHITE PARENTHESIS
 * 	2985 LEFT WHITE PARENTHESIS
 * FF60 FULLWIDTH RIGHT WHITE PARENTHESIS
 * 	2986 RIGHT WHITE PARENTHESIS
 * FF61 HALFWIDTH IDEOGRAPHIC FULL STOP
 * 	3002 IDEOGRAPHIC FULL STOP
 * FF62 HALFWIDTH LEFT CORNER BRACKET
 * 	300C LEFT CORNER BRACKET
 * FF63 HALFWIDTH RIGHT CORNER BRACKET
 * 	300D RIGHT CORNER BRACKET
 * FF64 HALFWIDTH IDEOGRAPHIC COMMA
 * 	3001 IDEOGRAPHIC COMMA
 * FFA0 HALFWIDTH HANGUL FILLER
 * 	1160 HANGUL JUNGSEONG FILLER
 * FFA1 HALFWIDTH HANGUL LETTER KIYEOK
 * 	1100 HANGUL CHOSEONG KIYEOK
 * FFA2 HALFWIDTH HANGUL LETTER SSANGKIYEOK
 * 	1101 HANGUL CHOSEONG SSANGKIYEOK
 * FFA3 HALFWIDTH HANGUL LETTER KIYEOK-SIOS
 * 	11AA HANGUL JONGSEONG KIYEOK-SIOS
 * FFA4 HALFWIDTH HANGUL LETTER NIEUN
 * 	1102 HANGUL CHOSEONG NIEUN
 * FFA5 HALFWIDTH HANGUL LETTER NIEUN-CIEUC
 * 	11AC HANGUL JONGSEONG NIEUN-CIEUC
 * FFA6 HALFWIDTH HANGUL LETTER NIEUN-HIEUH
 * 	11AD HANGUL JONGSEONG NIEUN-HIEUH
 * FFA7 HALFWIDTH HANGUL LETTER TIKEUT
 * 	1103 HANGUL CHOSEONG TIKEUT
 * FFA8 HALFWIDTH HANGUL LETTER SSANGTIKEUT
 * 	1104 HANGUL CHOSEONG SSANGTIKEUT
 * FFA9 HALFWIDTH HANGUL LETTER RIEUL
 * 	1105 HANGUL CHOSEONG RIEUL
 * FFAA HALFWIDTH HANGUL LETTER RIEUL-KIYEOK
 * 	11B0 HANGUL JONGSEONG RIEUL-KIYEOK
 * FFAB HALFWIDTH HANGUL LETTER RIEUL-MIEUM
 * 	11B1 HANGUL JONGSEONG RIEUL-MIEUM
 * FFAC HALFWIDTH HANGUL LETTER RIEUL-PIEUP
 * 	11B2 HANGUL JONGSEONG RIEUL-PIEUP
 * FFAD HALFWIDTH HANGUL LETTER RIEUL-SIOS
 * 	11B3 HANGUL JONGSEONG RIEUL-SIOS
 * FFAE HALFWIDTH HANGUL LETTER RIEUL-THIEUTH
 * 	11B4 HANGUL JONGSEONG RIEUL-THIEUTH
 * FFAF HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH
 * 	11B5 HANGUL JONGSEONG RIEUL-PHIEUPH
 * FFB0 HALFWIDTH HANGUL LETTER RIEUL-HIEUH
 * 	111A HANGUL CHOSEONG RIEUL-HIEUH
 * FFB1 HALFWIDTH HANGUL LETTER MIEUM
 * 	1106 HANGUL CHOSEONG MIEUM
 * FFB2 HALFWIDTH HANGUL LETTER PIEUP
 * 	1107 HANGUL CHOSEONG PIEUP
 * FFB3 HALFWIDTH HANGUL LETTER SSANGPIEUP
 * 	1108 HANGUL CHOSEONG SSANGPIEUP
 * FFB4 HALFWIDTH HANGUL LETTER PIEUP-SIOS
 * 	1121 HANGUL CHOSEONG PIEUP-SIOS
 * FFB5 HALFWIDTH HANGUL LETTER SIOS
 * 	1109 HANGUL CHOSEONG SIOS
 * FFB6 HALFWIDTH HANGUL LETTER SSANGSIOS
 * 	110A HANGUL CHOSEONG SSANGSIOS
 * FFB7 HALFWIDTH HANGUL LETTER IEUNG
 * 	110B HANGUL CHOSEONG IEUNG
 * FFB8 HALFWIDTH HANGUL LETTER CIEUC
 * 	110C HANGUL CHOSEONG CIEUC
 * FFB9 HALFWIDTH HANGUL LETTER SSANGCIEUC
 * 	110D HANGUL CHOSEONG SSANGCIEUC
 * FFBA HALFWIDTH HANGUL LETTER CHIEUCH
 * 	110E HANGUL CHOSEONG CHIEUCH
 * FFBB HALFWIDTH HANGUL LETTER KHIEUKH
 * 	110F HANGUL CHOSEONG KHIEUKH
 * FFBC HALFWIDTH HANGUL LETTER THIEUTH
 * 	1110 HANGUL CHOSEONG THIEUTH
 * FFBD HALFWIDTH HANGUL LETTER PHIEUPH
 * 	1111 HANGUL CHOSEONG PHIEUPH
 * FFBE HALFWIDTH HANGUL LETTER HIEUH
 * 	1112 HANGUL CHOSEONG HIEUH
 * FFC2 HALFWIDTH HANGUL LETTER A
 * 	1161 HANGUL JUNGSEONG A
 * FFC3 HALFWIDTH HANGUL LETTER AE
 * 	1162 HANGUL JUNGSEONG AE
 * FFC4 HALFWIDTH HANGUL LETTER YA
 * 	1163 HANGUL JUNGSEONG YA
 * FFC5 HALFWIDTH HANGUL LETTER YAE
 * 	1164 HANGUL JUNGSEONG YAE
 * FFC6 HALFWIDTH HANGUL LETTER EO
 * 	1165 HANGUL JUNGSEONG EO
 * FFC7 HALFWIDTH HANGUL LETTER E
 * 	1166 HANGUL JUNGSEONG E
 * FFCA HALFWIDTH HANGUL LETTER YEO
 * 	1167 HANGUL JUNGSEONG YEO
 * FFCB HALFWIDTH HANGUL LETTER YE
 * 	1168 HANGUL JUNGSEONG YE
 * FFCC HALFWIDTH HANGUL LETTER O
 * 	1169 HANGUL JUNGSEONG O
 * FFCD HALFWIDTH HANGUL LETTER WA
 * 	116A HANGUL JUNGSEONG WA
 * FFCE HALFWIDTH HANGUL LETTER WAE
 * 	116B HANGUL JUNGSEONG WAE
 * FFCF HALFWIDTH HANGUL LETTER OE
 * 	116C HANGUL JUNGSEONG OE
 * FFD2 HALFWIDTH HANGUL LETTER YO
 * 	116D HANGUL JUNGSEONG YO
 * FFD3 HALFWIDTH HANGUL LETTER U
 * 	116E HANGUL JUNGSEONG U
 * FFD4 HALFWIDTH HANGUL LETTER WEO
 * 	116F HANGUL JUNGSEONG WEO
 * FFD5 HALFWIDTH HANGUL LETTER WE
 * 	1170 HANGUL JUNGSEONG WE
 * FFD6 HALFWIDTH HANGUL LETTER WI
 * 	1171 HANGUL JUNGSEONG WI
 * FFD7 HALFWIDTH HANGUL LETTER YU
 * 	1172 HANGUL JUNGSEONG YU
 * FFDA HALFWIDTH HANGUL LETTER EU
 * 	1173 HANGUL JUNGSEONG EU
 * FFDB HALFWIDTH HANGUL LETTER YI
 * 	1174 HANGUL JUNGSEONG YI
 * FFDC HALFWIDTH HANGUL LETTER I
 * 	1175 HANGUL JUNGSEONG I
 * FFE0 FULLWIDTH CENT SIGN
 * 	00A2 CENT SIGN
 * FFE1 FULLWIDTH POUND SIGN
 * 	00A3 POUND SIGN
 * FFE2 FULLWIDTH NOT SIGN
 * 	00AC NOT SIGN
 * FFE3 FULLWIDTH MACRON
 * 	0020 SPACE
 * FFE4 FULLWIDTH BROKEN BAR
 * 	00A6 BROKEN BAR
 * FFE5 FULLWIDTH YEN SIGN
 * 	00A5 YEN SIGN
 * FFE6 FULLWIDTH WON SIGN
 * 	20A9 WON SIGN
 * FFE8 HALFWIDTH FORMS LIGHT VERTICAL
 * 	2502 BOX DRAWINGS LIGHT VERTICAL
 * FFE9 HALFWIDTH LEFTWARDS ARROW
 * 	2190 LEFTWARDS ARROW
 * FFEA HALFWIDTH UPWARDS ARROW
 * 	2191 UPWARDS ARROW
 * FFEB HALFWIDTH RIGHTWARDS ARROW
 * 	2192 RIGHTWARDS ARROW
 * FFEC HALFWIDTH DOWNWARDS ARROW
 * 	2193 DOWNWARDS ARROW
 * FFED HALFWIDTH BLACK SQUARE
 * 	25A0 BLACK SQUARE
 * FFEE HALFWIDTH WHITE CIRCLE
 * 	25CB WHITE CIRCLE
*/

unsigned short unac_indexes[UNAC_INDEXES_SIZE] = {
   0,   0,   0,   0,   1,   2,   0,   0,   0,   0,   3,   4,   5,   6,   7,
   8,   9,  10,  11,  12,  13,  14,  15,  16,  17,  18,  19,  20,  21,  22,
  23,  24,  25,  26,  27,  28,  29,   0,   0,   0,   0,   0,   0,  30,   0,
  31,  32,   0,  33,  33,  33,  33,  33,  33,  33,  34,  35,  36,  37,  38,
  39,  40,  41,  42,  43,  44,  45,  46,   0,  47,  48,  49,  50,  51,  52,
  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,   0,   0,  64,  65,
  33,  66,  67,   0,   0,   0,   0,  68,  69,   0,  70,  71,   0,  72,   0,
   0,   0,   0,  73,  74,  75,   0,   0,  76,   0,  33,  68,   0,   0,   0,
   0,   0,  77,  78,   0,   0,  70,  79,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,  80,   0,  81,  82,  83,  84,
  85,   0,  80,   0,   0,  86,  87,  88,  85,   0,  80,   0,   0,  89,  90,
  91,   0,  92,  80,   0,   0,  86,  93,   0,  85,   0,  80,   0,   0,  86,
  87,  94,  85,   0,  95,  96,   0,  97,  98,  99,   0,   0,  80,   0,   0,
  97, 100, 101,  85,   0,  85,   0,   0,  86, 100, 101,  85,   0,  85,   0,
   0,  97, 100,  99,  85,   0,  85,   0,   0,   0, 102, 103,   0,  85,   0,
   0,   0, 104, 105,   0,   0,   0,   0,   0,   0, 106, 107, 108,   0,   0,
 109, 110,   0, 111, 112, 113, 114,  65, 115, 116,  33, 117, 118,   0,   0,
   0,   0,   0, 119,  71,   0, 120, 121, 122, 123,   0, 124, 125, 126,   0,
   0, 127,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 129,   0, 129,   0,  85,   0,
  85,   0,   0,   0,  77,  33, 130,   0,   0, 131,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 132,   0,   0,   0,   0,   0,   0,   0, 133, 133,   0,
   0,   0,   0,   0,   0,   0,  33, 134,   0,   0,   0,   0, 135,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 136, 137,   0,
 138, 139,   0,  70,  79, 140,   0, 141,   0,   0,   0,   0,   0,   0,   0,
 138, 142,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 143, 144, 145, 146, 147, 148,   0, 149, 150, 151,  33,  33, 152,  97,
 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167,
 168, 169, 170, 171, 172, 173, 174, 175, 176, 169, 171, 175, 177, 178, 179,
 180, 181, 182, 183, 184, 185, 186, 187,   0, 188, 189, 190, 191,   0,   0,
  33,  33,  78, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202,   0,
 203,   0,   0,   0, 204,   0, 205, 206, 207,   0, 208, 209, 210,   0, 211,
   0,   0,   0, 212,   0,   0,   0, 213,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 214, 215, 216,
 217, 218, 219, 220, 221, 222,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 223,   0,   0,
   0,   0,   0,   0, 224,   0,   0,   0,   0,   0, 225,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 226,
 227, 228,   0,   0,   0, 229, 230, 231, 232, 233, 234, 235, 236, 237,   0,
   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,   0,  33,
  33,   0,   0,   0,   0,   0,   0,   0,   0,   0, 239,   0,   0,   0,   0,
   0, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253,
 254,   0,   0, 255,   0, 256, 257,   0,   0,   0,   0,   0, 258,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 259, 260, 261, 262, 263, 264, 265,   0,
   0,   0,   0,   0,   0, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275,
 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290,
 291, 292, 293, 294, 295, 296, 297,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 298, 299, 300, 301, 302, 303,   0,   0,   0,   0,
   0,   0,   0,   0, 304, 305, 306, 307, 308, 309, 310,   0,   0,   0,   0,
   0,   0,   0, 311,   0, 312,   0,   0,   0,   0,   0, 313,   0,   0, 138,
 139,   0,   0,   0,   0,   0, 314,   0, 315,  79,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 316, 152, 317,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 318, 319, 320, 321, 322, 323,
 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338,
 339, 340, 341, 342, 343, 344, 345, 346, 347,   0,   0, 348, 349, 350, 351,
 352, 353, 354, 355, 356, 357, 358, 359,   0, 360, 361, 362, 363, 364, 365,
 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380,
 381, 382,   0, 383, 384, 385, 386, 387, 388, 389, 390,   0,   0, 391,  33,
 392, 152, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405,
 406, 407, 408, 409, 410, 411, 412,   0,   0,   0, 413, 414, 415, 416, 417,
   0
};

unsigned char unac_positions[UNAC_BLOCK_COUNT][2*UNAC_BLOCK_SIZE + 1] = {
/* 0 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 1 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 2 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 3 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 4 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 27, 30, 33, 36, 39, 42, 43, 44 },
/* 5 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 6 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33 },
/* 7 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 8 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 9 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 10 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 11 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 12 */ { 0, 1, 2, 3, 4, 6, 8, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 38 },
/* 13 */ { 0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36 },
/* 14 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 15 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 16 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 17 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 18 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 19 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 20 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 21 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 45, 46, 47, 48, 49, 50 },
/* 22 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 23 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 24 */ { 0, 1, 2, 4, 6, 8, 10, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38 },
/* 25 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 26 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 27 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 28 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 29 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 30 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 31 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 32 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 33 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 34 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 35 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 36 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 37 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 38 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 39 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 40 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 41 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 42 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 43 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 44 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 45 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 46 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 47 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 48 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 49 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 50 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 51 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 52 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 53 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 54 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 55 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 56 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 57 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 58 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 59 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 60 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 61 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 62 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 63 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 64 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 },
/* 65 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 66 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 67 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 68 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 69 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 70 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 71 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 72 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 16, 18, 20, 22, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40 },
/* 73 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 74 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 75 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 76 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 77 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 78 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 79 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 80 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 81 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 82 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 83 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 84 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 85 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 86 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 87 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 88 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 89 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 90 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 91 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 92 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 93 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 94 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 95 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 96 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 97 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 98 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 99 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 100 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 101 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 102 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 103 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 104 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 105 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 106 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 107 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 108 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 28, 30, 32, 33, 34, 35, 36 },
/* 109 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 110 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 111 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 112 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 113 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 114 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 115 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 116 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 117 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 118 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 119 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 120 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 121 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 122 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 123 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 124 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 125 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 126 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 127 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 128 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 129 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 130 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 131 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 132 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 133 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 134 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 135 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 136 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 137 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 138 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 139 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 140 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 141 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 142 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 143 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 144 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 145 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 146 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 147 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 148 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 149 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 150 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 151 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 152 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 153 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 154 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 155 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 156 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 157 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 158 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 159 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 160 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 161 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 162 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 29, 30, 31, 33, 34, 35 },
/* 163 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 164 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 165 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 166 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 167 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 168 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 169 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 170 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 171 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 172 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 173 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 174 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 175 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 176 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 177 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 178 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 179 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 180 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 181 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 182 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 183 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 184 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 17, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38 },
/* 185 */ { 0, 1, 2, 3, 4, 5, 6, 8, 10, 13, 16, 17, 18, 20, 22, 25, 28, 29, 30, 31, 32, 33, 34, 35, 36, 38, 40, 41, 42, 43, 44, 45, 46 },
/* 186 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 18, 20, 22, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38 },
/* 187 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 18, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38 },
/* 188 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 189 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 190 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 191 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 },
/* 192 */ { 0, 3, 6, 9, 12, 13, 14, 16, 18, 19, 20, 23, 26, 29, 32, 33, 34, 35, 36, 38, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52 },
/* 193 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 },
/* 194 */ { 0, 2, 4, 7, 10, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40 },
/* 195 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 25, 28, 29, 30, 31, 32, 33, 34, 35, 36 },
/* 196 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 197 */ { 0, 1, 2, 3, 4, 5, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 80, 82 },
/* 198 */ { 0, 1, 2, 4, 6, 9, 12, 14, 16, 17, 18, 20, 22, 25, 28, 32, 36, 38, 40, 41, 42, 44, 46, 49, 52, 53, 54, 55, 56, 57, 58, 59, 60 },
/* 199 */ { 0, 1, 2, 4, 6, 9, 12, 14, 16, 17, 18, 20, 22, 25, 28, 32, 36, 38, 40, 41, 42, 44, 46, 49, 52, 53, 54, 55, 56, 57, 58, 59, 60 },
/* 200 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 201 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 202 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 203 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 204 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 205 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 28, 31, 34, 35, 36, 38, 40 },
/* 206 */ { 0, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36 },
/* 207 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 208 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 209 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 210 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 211 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 212 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 213 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 214 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46 },
/* 215 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55, 58, 61, 64, 67, 70, 74, 78, 82, 86, 90, 94 },
/* 216 */ { 0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 66, 68, 70, 72, 74, 76, 78, 80, 82, 84, 86, 88, 90, 92, 94, 96 },
/* 217 */ { 0, 2, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55, 58, 61, 64, 67, 70, 73, 76, 79, 82, 85, 88, 91, 94 },
/* 218 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 219 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56 },
/* 220 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 221 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 222 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 223 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 28, 32, 33, 34, 35, 36, 37, 38 },
/* 224 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 11, 14, 16, 18, 21, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42 },
/* 225 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 226 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 227 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 228 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 229 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 230 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 231 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 232 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 233 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 234 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 235 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 236 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 237 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 238 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 239 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 240 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 241 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 242 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 243 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 244 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 245 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 246 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 247 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 248 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 249 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 250 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 251 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 252 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 253 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 254 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 255 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 256 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 257 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 258 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 259 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 260 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 261 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 262 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 263 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 264 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 265 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 266 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 88, 92, 96, 100 },
/* 267 */ { 0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92, 96, 100, 104, 111, 118, 124, 130, 131, 132 },
/* 268 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 269 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 270 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48 },
/* 271 */ { 0, 3, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64, 66 },
/* 272 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 32, 34, 36 },
/* 273 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 53, 58, 62, 66, 68, 70, 71, 72 },
/* 274 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 275 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 276 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 277 */ { 0, 1, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62 },
/* 278 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 39, 42, 45, 48, 51, 54, 56, 58, 61, 64, 66, 68, 71, 74 },
/* 279 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 280 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 281 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 282 */ { 0, 4, 8, 12, 16, 20, 24, 27, 30, 34, 38, 41, 44, 47, 50, 55, 60, 64, 68, 71, 74, 77, 80, 83, 86, 90, 94, 98, 102, 105, 108, 111, 114 },
/* 283 */ { 0, 2, 4, 7, 10, 14, 18, 22, 26, 28, 30, 35, 40, 46, 52, 57, 62, 65, 68, 73, 78, 83, 88, 92, 96, 99, 102, 105, 108, 111, 114, 118, 122 },
/* 284 */ { 0, 5, 10, 14, 18, 21, 24, 27, 30, 33, 36, 38, 40, 42, 44, 46, 48, 50, 52, 55, 58, 61, 64, 69, 74, 77, 80, 84, 88, 93, 98, 101, 104 },
/* 285 */ { 0, 2, 4, 6, 8, 13, 18, 22, 26, 31, 36, 39, 42, 47, 52, 54, 56, 59, 62, 65, 68, 71, 74, 77, 80, 83, 86, 90, 94, 97, 100, 102, 104 },
/* 286 */ { 0, 3, 6, 9, 12, 15, 18, 22, 26, 29, 32, 35, 38, 41, 44, 49, 54, 58, 62, 64, 66, 71, 76, 78, 80, 84, 88, 92, 96, 99, 102, 105, 108 },
/* 287 */ { 0, 3, 6, 10, 14, 16, 18, 21, 24, 28, 32, 34, 36, 41, 46, 49, 52, 54, 56, 58, 60, 62, 64, 66, 68, 70, 72, 74, 76, 78, 80, 82, 84 },
/* 288 */ { 0, 2, 4, 6, 8, 11, 14, 17, 20, 23, 26, 29, 32, 35, 38, 41, 44, 47, 50, 53, 56, 59, 62, 65, 68, 71, 74, 77, 80, 83, 86, 89, 92 },
/* 289 */ { 0, 3, 6, 9, 12, 14, 16, 18, 20, 23, 26, 28, 30, 32, 34, 36, 38, 41, 44, 47, 50, 52, 54, 56, 58, 60, 62, 64, 66, 68, 70, 74, 78 },
/* 290 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 35, 38, 42, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64, 66, 68, 70 },
/* 291 */ { 0, 2, 4, 7, 10, 13, 16, 19, 22, 25, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64, 66, 68, 71, 74 },
/* 292 */ { 0, 3, 6, 8, 10, 13, 16, 19, 22, 25, 28, 30, 32, 35, 38, 41, 44, 48, 52, 54, 56, 59, 62, 65, 68, 71, 74, 77, 80, 85, 90, 96, 102 },
/* 293 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 294 */ { 0, 2, 4, 6, 8, 12, 16, 18, 20, 22, 24, 26, 28, 32, 36, 39, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64, 66, 68, 70, 72, 74 },
/* 295 */ { 0, 2, 4, 6, 8, 11, 14, 16, 18, 20, 22, 25, 28, 31, 34, 36, 38, 42, 46, 49, 52, 54, 56, 58, 60, 62, 64, 66, 68, 71, 74, 77, 80 },
/* 296 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78 },
/* 297 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 298 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 299 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 300 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 301 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 302 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 303 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 304 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 305 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 306 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 307 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 308 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 309 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 310 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 311 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 312 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 313 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 314 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 315 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 316 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 317 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 318 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 319 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 320 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 321 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 322 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 323 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 324 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 325 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 326 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 327 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 328 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 329 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 330 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 331 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 332 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 333 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 334 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 335 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 336 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 337 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 338 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 339 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 340 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 341 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 342 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 343 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 344 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 345 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 346 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 347 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 348 */ { 0, 2, 4, 6, 8, 10, 12, 15, 18, 21, 24, 26, 28, 30, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50 },
/* 349 */ { 0, 1, 2, 3, 4, 5, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42 },
/* 350 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 351 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 352 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 34 },
/* 353 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 354 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 355 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 356 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 357 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 358 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 359 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 360 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 30, 31, 32, 33, 34 },
/* 361 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44 },
/* 362 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56 },
/* 363 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 364 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 365 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 366 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 367 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 368 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54 },
/* 369 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56 },
/* 370 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 371 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 372 */ { 0, 1, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62 },
/* 373 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 374 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 375 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 376 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 37, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62 },
/* 377 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 378 */ { 0, 2, 4, 6, 8, 9, 10, 11, 12, 13, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58 },
/* 379 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 380 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 381 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 382 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56 },
/* 383 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 384 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 385 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 386 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 387 */ { 0, 1, 2, 3, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55, 58, 61, 64, 67, 70, 73, 76, 79, 82, 85, 88 },
/* 388 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 389 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 390 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64 },
/* 391 */ { 0, 3, 6, 9, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 71, 74, 92, 110, 118, 126, 130, 134, 135, 136, 137, 138, 139, 140 },
/* 392 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 21, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36 },
/* 393 */ { 0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 },
/* 394 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 395 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 396 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 397 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 398 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 399 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 400 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 401 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 402 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 403 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 404 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 405 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 43, 44, 45, 46, 47, 48 },
/* 406 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 407 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 408 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 409 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 410 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 411 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 412 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 413 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 414 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 415 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 416 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 417 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 }
};

unsigned short unac_data0[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data1[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0x0061, 0xFFFF, 0x0062, 0xFFFF, 0x0063, 0xFFFF, 0x0064, 0xFFFF, 0x0065, 0xFFFF, 0x0066, 0xFFFF, 0x0067, 0xFFFF, 0x0068, 0xFFFF, 0x0069, 0xFFFF, 0x006A, 0xFFFF, 0x006B, 0xFFFF, 0x006C, 0xFFFF, 0x006D, 0xFFFF, 0x006E, 0xFFFF, 0x006F };
unsigned short unac_data2[] = { 0xFFFF, 0x0070, 0xFFFF, 0x0071, 0xFFFF, 0x0072, 0xFFFF, 0x0073, 0xFFFF, 0x0074, 0xFFFF, 0x0075, 0xFFFF, 0x0076, 0xFFFF, 0x0077, 0xFFFF, 0x0078, 0xFFFF, 0x0079, 0xFFFF, 0x007A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data3[] = { 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0x0061, 0x0061, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020 };
unsigned short unac_data4[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0032, 0x0032, 0x0033, 0x0033, 0x0020, 0x0020, 0x03BC, 0x03BC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0031, 0x0031, 0x006F, 0x006F, 0xFFFF, 0xFFFF, 0x0031, 0x2044, 0x0034, 0x0031, 0x2044, 0x0034, 0x0031, 0x2044, 0x0032, 0x0031, 0x2044, 0x0032, 0x0033, 0x2044, 0x0034, 0x0033, 0x2044, 0x0034, 0xFFFF, 0xFFFF };
unsigned short unac_data5[] = { 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0xFFFF, 0x00E6, 0x0043, 0x0063, 0x0045, 0x0065, 0x0045, 0x0065, 0x0045, 0x0065, 0x0045, 0x0065, 0x0049, 0x0069, 0x0049, 0x0069, 0x0049, 0x0069, 0x0049, 0x0069 };
unsigned short unac_data6[] = { 0xFFFF, 0x00F0, 0x004E, 0x006E, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0xFFFF, 0xFFFF, 0xFFFF, 0x00F8, 0x0055, 0x0075, 0x0055, 0x0075, 0x0055, 0x0075, 0x0055, 0x0075, 0x0059, 0x0079, 0xFFFF, 0x00FE, 0xFFFF, 0x0073, 0x0073 };
unsigned short unac_data7[] = { 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0xFFFF, 0xFFFF, 0x0063, 0x0063, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069 };
unsigned short unac_data8[] = { 0xFFFF, 0xFFFF, 0x006E, 0x006E, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0079, 0x0079, 0xFFFF, 0xFFFF, 0x0079, 0x0079 };
unsigned short unac_data9[] = { 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0063, 0x0063, 0x0063, 0x0044, 0x0064, 0x0064, 0x0064 };
unsigned short unac_data10[] = { 0xFFFF, 0x0111, 0xFFFF, 0xFFFF, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0047, 0x0067, 0x0067, 0x0067, 0x0047, 0x0067, 0x0067, 0x0067 };
unsigned short unac_data11[] = { 0x0047, 0x0067, 0x0067, 0x0067, 0x0047, 0x0067, 0x0067, 0x0067, 0x0048, 0x0068, 0x0068, 0x0068, 0xFFFF, 0x0127, 0xFFFF, 0xFFFF, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0069, 0x0069, 0x0069 };
unsigned short unac_data12[] = { 0x0049, 0x0069, 0xFFFF, 0xFFFF, 0x0049, 0x004A, 0x0069, 0x006A, 0x0069, 0x006A, 0x0069, 0x006A, 0x004A, 0x006A, 0x006A, 0x006A, 0x004B, 0x006B, 0x006B, 0x006B, 0xFFFF, 0xFFFF, 0x004C, 0x006C, 0x006C, 0x006C, 0x004C, 0x006C, 0x006C, 0x006C, 0x004C, 0x006C, 0x006C, 0x006C, 0x004C, 0x00B7, 0x006C, 0x00B7 };
unsigned short unac_data13[] = { 0x006C, 0x00B7, 0x006C, 0x00B7, 0xFFFF, 0x0142, 0xFFFF, 0xFFFF, 0x004E, 0x006E, 0x006E, 0x006E, 0x004E, 0x006E, 0x006E, 0x006E, 0x004E, 0x006E, 0x006E, 0x006E, 0x02BC, 0x006E, 0x02BC, 0x006E, 0xFFFF, 0x014B, 0xFFFF, 0xFFFF, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F };
unsigned short unac_data14[] = { 0x004F, 0x006F, 0x006F, 0x006F, 0xFFFF, 0x0153, 0xFFFF, 0xFFFF, 0x0052, 0x0072, 0x0072, 0x0072, 0x0052, 0x0072, 0x0072, 0x0072, 0x0052, 0x0072, 0x0072, 0x0072, 0x0053, 0x0073, 0x0073, 0x0073, 0x0053, 0x0073, 0x0073, 0x0073, 0x0053, 0x0073, 0x0073, 0x0073 };
unsigned short unac_data15[] = { 0x0053, 0x0073, 0x0073, 0x0073, 0x0054, 0x0074, 0x0074, 0x0074, 0x0054, 0x0074, 0x0074, 0x0074, 0xFFFF, 0x0167, 0xFFFF, 0xFFFF, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075 };
unsigned short unac_data16[] = { 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0057, 0x0077, 0x0077, 0x0077, 0x0059, 0x0079, 0x0079, 0x0079, 0x0059, 0x0079, 0x005A, 0x007A, 0x007A, 0x007A, 0x005A, 0x007A, 0x007A, 0x007A, 0x005A, 0x007A, 0x007A, 0x007A, 0x0073, 0x0073 };
unsigned short unac_data17[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0x0253, 0xFFFF, 0x0183, 0xFFFF, 0xFFFF, 0xFFFF, 0x0185, 0xFFFF, 0xFFFF, 0xFFFF, 0x0254, 0xFFFF, 0x0188, 0xFFFF, 0xFFFF, 0xFFFF, 0x0256, 0xFFFF, 0x0257, 0xFFFF, 0x018C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01DD, 0xFFFF, 0x0259 };
unsigned short unac_data18[] = { 0xFFFF, 0x025B, 0xFFFF, 0x0192, 0xFFFF, 0xFFFF, 0xFFFF, 0x0260, 0xFFFF, 0x0263, 0xFFFF, 0xFFFF, 0xFFFF, 0x0269, 0xFFFF, 0x0268, 0xFFFF, 0x0199, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x026F, 0xFFFF, 0x0272, 0xFFFF, 0xFFFF, 0xFFFF, 0x0275 };
unsigned short unac_data19[] = { 0x004F, 0x006F, 0x006F, 0x006F, 0xFFFF, 0x01A3, 0xFFFF, 0xFFFF, 0xFFFF, 0x01A5, 0xFFFF, 0xFFFF, 0xFFFF, 0x0280, 0xFFFF, 0x01A8, 0xFFFF, 0xFFFF, 0xFFFF, 0x0283, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01AD, 0xFFFF, 0xFFFF, 0xFFFF, 0x0288, 0x0055, 0x0075 };
unsigned short unac_data20[] = { 0x0075, 0x0075, 0xFFFF, 0x028A, 0xFFFF, 0x028B, 0xFFFF, 0x01B4, 0xFFFF, 0xFFFF, 0xFFFF, 0x01B6, 0xFFFF, 0xFFFF, 0xFFFF, 0x0292, 0xFFFF, 0x01B9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01BD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data21[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0044, 0x005A, 0x0064, 0x007A, 0x0044, 0x007A, 0x0064, 0x007A, 0x0064, 0x007A, 0x0064, 0x007A, 0x004C, 0x004A, 0x006C, 0x006A, 0x004C, 0x006A, 0x006C, 0x006A, 0x006C, 0x006A, 0x006C, 0x006A, 0x004E, 0x004A, 0x006E, 0x006A, 0x004E, 0x006A, 0x006E, 0x006A, 0x006E, 0x006A, 0x006E, 0x006A, 0x0041, 0x0061, 0x0061, 0x0061, 0x0049, 0x0069 };
unsigned short unac_data22[] = { 0x0069, 0x0069, 0x004F, 0x006F, 0x006F, 0x006F, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0xFFFF, 0xFFFF, 0x0041, 0x0061, 0x0061, 0x0061 };
unsigned short unac_data23[] = { 0x0041, 0x0061, 0x0061, 0x0061, 0x00C6, 0x00E6, 0x00E6, 0x00E6, 0xFFFF, 0x01E5, 0xFFFF, 0xFFFF, 0x0047, 0x0067, 0x0067, 0x0067, 0x004B, 0x006B, 0x006B, 0x006B, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x01B7, 0x0292, 0x0292, 0x0292 };
unsigned short unac_data24[] = { 0x006A, 0x006A, 0x0044, 0x005A, 0x0064, 0x007A, 0x0044, 0x007A, 0x0064, 0x007A, 0x0064, 0x007A, 0x0064, 0x007A, 0x0047, 0x0067, 0x0067, 0x0067, 0xFFFF, 0x0195, 0xFFFF, 0x01BF, 0x004E, 0x006E, 0x006E, 0x006E, 0x0041, 0x0061, 0x0061, 0x0061, 0x00C6, 0x00E6, 0x00E6, 0x00E6, 0x00D8, 0x00F8, 0x00F8, 0x00F8 };
unsigned short unac_data25[] = { 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0069, 0x0069, 0x0069, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F };
unsigned short unac_data26[] = { 0x0052, 0x0072, 0x0072, 0x0072, 0x0052, 0x0072, 0x0072, 0x0072, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0053, 0x0073, 0x0073, 0x0073, 0x0054, 0x0074, 0x0074, 0x0074, 0xFFFF, 0x021D, 0xFFFF, 0xFFFF, 0x0048, 0x0068, 0x0068, 0x0068 };
unsigned short unac_data27[] = { 0xFFFF, 0x019E, 0xFFFF, 0xFFFF, 0xFFFF, 0x0223, 0xFFFF, 0xFFFF, 0xFFFF, 0x0225, 0xFFFF, 0xFFFF, 0x0041, 0x0061, 0x0061, 0x0061, 0x0045, 0x0065, 0x0065, 0x0065, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F };
unsigned short unac_data28[] = { 0x004F, 0x006F, 0x006F, 0x006F, 0x0059, 0x0079, 0x0079, 0x0079, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C65, 0xFFFF, 0x023C, 0xFFFF, 0xFFFF, 0xFFFF, 0x019A, 0xFFFF, 0x2C66, 0xFFFF, 0xFFFF };
unsigned short unac_data29[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0x0242, 0xFFFF, 0xFFFF, 0xFFFF, 0x0180, 0xFFFF, 0x0289, 0xFFFF, 0x028C, 0xFFFF, 0x0247, 0xFFFF, 0xFFFF, 0xFFFF, 0x0249, 0xFFFF, 0xFFFF, 0xFFFF, 0x024B, 0xFFFF, 0xFFFF, 0xFFFF, 0x024D, 0xFFFF, 0xFFFF, 0xFFFF, 0x024F, 0xFFFF, 0xFFFF };
unsigned short unac_data30[] = { 0x0068, 0x0068, 0x0266, 0x0266, 0x006A, 0x006A, 0x0072, 0x0072, 0x0279, 0x0279, 0x027B, 0x027B, 0x0281, 0x0281, 0x0077, 0x0077, 0x0079, 0x0079, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data31[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data32[] = { 0x0263, 0x0263, 0x006C, 0x006C, 0x0073, 0x0073, 0x0078, 0x0078, 0x0295, 0x0295, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data33[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data34[] = { 0xFFFF, 0x0371, 0xFFFF, 0xFFFF, 0xFFFF, 0x0373, 0xFFFF, 0xFFFF, 0x02B9, 0x02B9, 0xFFFF, 0xFFFF, 0xFFFF, 0x0377, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x003B, 0x003B, 0xFFFF, 0xFFFF };
unsigned short unac_data35[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0020, 0x0020, 0x0391, 0x03B1, 0x00B7, 0x00B7, 0x0395, 0x03B5, 0x0397, 0x03B7, 0x0399, 0x03B9, 0xFFFF, 0xFFFF, 0x039F, 0x03BF, 0xFFFF, 0xFFFF, 0x03A5, 0x03C5, 0x03A9, 0x03C9 };
unsigned short unac_data36[] = { 0x03B9, 0x03B9, 0xFFFF, 0x03B1, 0xFFFF, 0x03B2, 0xFFFF, 0x03B3, 0xFFFF, 0x03B4, 0xFFFF, 0x03B5, 0xFFFF, 0x03B6, 0xFFFF, 0x03B7, 0xFFFF, 0x03B8, 0xFFFF, 0x03B9, 0xFFFF, 0x03BA, 0xFFFF, 0x03BB, 0xFFFF, 0x03BC, 0xFFFF, 0x03BD, 0xFFFF, 0x03BE, 0xFFFF, 0x03BF };
unsigned short unac_data37[] = { 0xFFFF, 0x03C0, 0xFFFF, 0x03C1, 0xFFFF, 0xFFFF, 0xFFFF, 0x03C3, 0xFFFF, 0x03C4, 0xFFFF, 0x03C5, 0xFFFF, 0x03C6, 0xFFFF, 0x03C7, 0xFFFF, 0x03C8, 0xFFFF, 0x03C9, 0x0399, 0x03B9, 0x03A5, 0x03C5, 0x03B1, 0x03B1, 0x03B5, 0x03B5, 0x03B7, 0x03B7, 0x03B9, 0x03B9 };
unsigned short unac_data38[] = { 0x03C5, 0x03C5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data39[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03C3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03B9, 0x03B9, 0x03C5, 0x03C5, 0x03BF, 0x03BF, 0x03C5, 0x03C5, 0x03C9, 0x03C9, 0xFFFF, 0x03D7 };
unsigned short unac_data40[] = { 0x03B2, 0x03B2, 0x03B8, 0x03B8, 0x03A5, 0x03C5, 0x03A5, 0x03C5, 0x03A5, 0x03C5, 0x03C6, 0x03C6, 0x03C0, 0x03C0, 0xFFFF, 0xFFFF, 0xFFFF, 0x03D9, 0xFFFF, 0xFFFF, 0xFFFF, 0x03DB, 0xFFFF, 0xFFFF, 0xFFFF, 0x03DD, 0xFFFF, 0xFFFF, 0xFFFF, 0x03DF, 0xFFFF, 0xFFFF };
unsigned short unac_data41[] = { 0xFFFF, 0x03E1, 0xFFFF, 0xFFFF, 0xFFFF, 0x03E3, 0xFFFF, 0xFFFF, 0xFFFF, 0x03E5, 0xFFFF, 0xFFFF, 0xFFFF, 0x03E7, 0xFFFF, 0xFFFF, 0xFFFF, 0x03E9, 0xFFFF, 0xFFFF, 0xFFFF, 0x03EB, 0xFFFF, 0xFFFF, 0xFFFF, 0x03ED, 0xFFFF, 0xFFFF, 0xFFFF, 0x03EF, 0xFFFF, 0xFFFF };
unsigned short unac_data42[] = { 0x03BA, 0x03BA, 0x03C1, 0x03C1, 0x03C2, 0x03C3, 0xFFFF, 0xFFFF, 0x0398, 0x03B8, 0x03B5, 0x03B5, 0xFFFF, 0xFFFF, 0xFFFF, 0x03F8, 0xFFFF, 0xFFFF, 0x03A3, 0x03C3, 0xFFFF, 0x03FB, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x037B, 0xFFFF, 0x037C, 0xFFFF, 0x037D };
unsigned short unac_data43[] = { 0x0415, 0x0435, 0x0415, 0x0435, 0xFFFF, 0x0452, 0x0413, 0x0433, 0xFFFF, 0x0454, 0xFFFF, 0x0455, 0xFFFF, 0x0456, 0x0406, 0x0456, 0xFFFF, 0x0458, 0xFFFF, 0x0459, 0xFFFF, 0x045A, 0xFFFF, 0x045B, 0x041A, 0x043A, 0x0418, 0x0438, 0x0423, 0x0443, 0xFFFF, 0x045F };
unsigned short unac_data44[] = { 0xFFFF, 0x0430, 0xFFFF, 0x0431, 0xFFFF, 0x0432, 0xFFFF, 0x0433, 0xFFFF, 0x0434, 0xFFFF, 0x0435, 0xFFFF, 0x0436, 0xFFFF, 0x0437, 0xFFFF, 0x0438, 0x0418, 0x0438, 0xFFFF, 0x043A, 0xFFFF, 0x043B, 0xFFFF, 0x043C, 0xFFFF, 0x043D, 0xFFFF, 0x043E, 0xFFFF, 0x043F };
unsigned short unac_data45[] = { 0xFFFF, 0x0440, 0xFFFF, 0x0441, 0xFFFF, 0x0442, 0xFFFF, 0x0443, 0xFFFF, 0x0444, 0xFFFF, 0x0445, 0xFFFF, 0x0446, 0xFFFF, 0x0447, 0xFFFF, 0x0448, 0xFFFF, 0x0449, 0xFFFF, 0x044A, 0xFFFF, 0x044B, 0xFFFF, 0x044C, 0xFFFF, 0x044D, 0xFFFF, 0x044E, 0xFFFF, 0x044F };
unsigned short unac_data46[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0438, 0x0438, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data47[] = { 0x0435, 0x0435, 0x0435, 0x0435, 0xFFFF, 0xFFFF, 0x0433, 0x0433, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0456, 0x0456, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x043A, 0x043A, 0x0438, 0x0438, 0x0443, 0x0443, 0xFFFF, 0xFFFF };
unsigned short unac_data48[] = { 0xFFFF, 0x0461, 0xFFFF, 0xFFFF, 0xFFFF, 0x0463, 0xFFFF, 0xFFFF, 0xFFFF, 0x0465, 0xFFFF, 0xFFFF, 0xFFFF, 0x0467, 0xFFFF, 0xFFFF, 0xFFFF, 0x0469, 0xFFFF, 0xFFFF, 0xFFFF, 0x046B, 0xFFFF, 0xFFFF, 0xFFFF, 0x046D, 0xFFFF, 0xFFFF, 0xFFFF, 0x046F, 0xFFFF, 0xFFFF };
unsigned short unac_data49[] = { 0xFFFF, 0x0471, 0xFFFF, 0xFFFF, 0xFFFF, 0x0473, 0xFFFF, 0xFFFF, 0xFFFF, 0x0475, 0xFFFF, 0xFFFF, 0x0474, 0x0475, 0x0475, 0x0475, 0xFFFF, 0x0479, 0xFFFF, 0xFFFF, 0xFFFF, 0x047B, 0xFFFF, 0xFFFF, 0xFFFF, 0x047D, 0xFFFF, 0xFFFF, 0xFFFF, 0x047F, 0xFFFF, 0xFFFF };
unsigned short unac_data50[] = { 0xFFFF, 0x0481, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x048B, 0xFFFF, 0xFFFF, 0xFFFF, 0x048D, 0xFFFF, 0xFFFF, 0xFFFF, 0x048F, 0xFFFF, 0xFFFF };
unsigned short unac_data51[] = { 0xFFFF, 0x0491, 0xFFFF, 0xFFFF, 0xFFFF, 0x0493, 0xFFFF, 0xFFFF, 0xFFFF, 0x0495, 0xFFFF, 0xFFFF, 0xFFFF, 0x0497, 0xFFFF, 0xFFFF, 0xFFFF, 0x0499, 0xFFFF, 0xFFFF, 0xFFFF, 0x049B, 0xFFFF, 0xFFFF, 0xFFFF, 0x049D, 0xFFFF, 0xFFFF, 0xFFFF, 0x049F, 0xFFFF, 0xFFFF };
unsigned short unac_data52[] = { 0xFFFF, 0x04A1, 0xFFFF, 0xFFFF, 0xFFFF, 0x04A3, 0xFFFF, 0xFFFF, 0xFFFF, 0x04A5, 0xFFFF, 0xFFFF, 0xFFFF, 0x04A7, 0xFFFF, 0xFFFF, 0xFFFF, 0x04A9, 0xFFFF, 0xFFFF, 0xFFFF, 0x04AB, 0xFFFF, 0xFFFF, 0xFFFF, 0x04AD, 0xFFFF, 0xFFFF, 0xFFFF, 0x04AF, 0xFFFF, 0xFFFF };
unsigned short unac_data53[] = { 0xFFFF, 0x04B1, 0xFFFF, 0xFFFF, 0xFFFF, 0x04B3, 0xFFFF, 0xFFFF, 0xFFFF, 0x04B5, 0xFFFF, 0xFFFF, 0xFFFF, 0x04B7, 0xFFFF, 0xFFFF, 0xFFFF, 0x04B9, 0xFFFF, 0xFFFF, 0xFFFF, 0x04BB, 0xFFFF, 0xFFFF, 0xFFFF, 0x04BD, 0xFFFF, 0xFFFF, 0xFFFF, 0x04BF, 0xFFFF, 0xFFFF };
unsigned short unac_data54[] = { 0xFFFF, 0x04CF, 0x0416, 0x0436, 0x0436, 0x0436, 0xFFFF, 0x04C4, 0xFFFF, 0xFFFF, 0xFFFF, 0x04C6, 0xFFFF, 0xFFFF, 0xFFFF, 0x04C8, 0xFFFF, 0xFFFF, 0xFFFF, 0x04CA, 0xFFFF, 0xFFFF, 0xFFFF, 0x04CC, 0xFFFF, 0xFFFF, 0xFFFF, 0x04CE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data55[] = { 0x0410, 0x0430, 0x0430, 0x0430, 0x0410, 0x0430, 0x0430, 0x0430, 0xFFFF, 0x04D5, 0xFFFF, 0xFFFF, 0x0415, 0x0435, 0x0435, 0x0435, 0xFFFF, 0x04D9, 0xFFFF, 0xFFFF, 0x04D8, 0x04D9, 0x04D9, 0x04D9, 0x0416, 0x0436, 0x0436, 0x0436, 0x0417, 0x0437, 0x0437, 0x0437 };
unsigned short unac_data56[] = { 0xFFFF, 0x04E1, 0xFFFF, 0xFFFF, 0x0418, 0x0438, 0x0438, 0x0438, 0x0418, 0x0438, 0x0438, 0x0438, 0x041E, 0x043E, 0x043E, 0x043E, 0xFFFF, 0x04E9, 0xFFFF, 0xFFFF, 0x04E8, 0x04E9, 0x04E9, 0x04E9, 0x042D, 0x044D, 0x044D, 0x044D, 0x0423, 0x0443, 0x0443, 0x0443 };
unsigned short unac_data57[] = { 0x0423, 0x0443, 0x0443, 0x0443, 0x0423, 0x0443, 0x0443, 0x0443, 0x0427, 0x0447, 0x0447, 0x0447, 0xFFFF, 0x04F7, 0xFFFF, 0xFFFF, 0x042B, 0x044B, 0x044B, 0x044B, 0xFFFF, 0x04FB, 0xFFFF, 0xFFFF, 0xFFFF, 0x04FD, 0xFFFF, 0xFFFF, 0xFFFF, 0x04FF, 0xFFFF, 0xFFFF };
unsigned short unac_data58[] = { 0xFFFF, 0x0501, 0xFFFF, 0xFFFF, 0xFFFF, 0x0503, 0xFFFF, 0xFFFF, 0xFFFF, 0x0505, 0xFFFF, 0xFFFF, 0xFFFF, 0x0507, 0xFFFF, 0xFFFF, 0xFFFF, 0x0509, 0xFFFF, 0xFFFF, 0xFFFF, 0x050B, 0xFFFF, 0xFFFF, 0xFFFF, 0x050D, 0xFFFF, 0xFFFF, 0xFFFF, 0x050F, 0xFFFF, 0xFFFF };
unsigned short unac_data59[] = { 0xFFFF, 0x0511, 0xFFFF, 0xFFFF, 0xFFFF, 0x0513, 0xFFFF, 0xFFFF, 0xFFFF, 0x0515, 0xFFFF, 0xFFFF, 0xFFFF, 0x0517, 0xFFFF, 0xFFFF, 0xFFFF, 0x0519, 0xFFFF, 0xFFFF, 0xFFFF, 0x051B, 0xFFFF, 0xFFFF, 0xFFFF, 0x051D, 0xFFFF, 0xFFFF, 0xFFFF, 0x051F, 0xFFFF, 0xFFFF };
unsigned short unac_data60[] = { 0xFFFF, 0x0521, 0xFFFF, 0xFFFF, 0xFFFF, 0x0523, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data61[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0x0561, 0xFFFF, 0x0562, 0xFFFF, 0x0563, 0xFFFF, 0x0564, 0xFFFF, 0x0565, 0xFFFF, 0x0566, 0xFFFF, 0x0567, 0xFFFF, 0x0568, 0xFFFF, 0x0569, 0xFFFF, 0x056A, 0xFFFF, 0x056B, 0xFFFF, 0x056C, 0xFFFF, 0x056D, 0xFFFF, 0x056E, 0xFFFF, 0x056F };
unsigned short unac_data62[] = { 0xFFFF, 0x0570, 0xFFFF, 0x0571, 0xFFFF, 0x0572, 0xFFFF, 0x0573, 0xFFFF, 0x0574, 0xFFFF, 0x0575, 0xFFFF, 0x0576, 0xFFFF, 0x0577, 0xFFFF, 0x0578, 0xFFFF, 0x0579, 0xFFFF, 0x057A, 0xFFFF, 0x057B, 0xFFFF, 0x057C, 0xFFFF, 0x057D, 0xFFFF, 0x057E, 0xFFFF, 0x057F };
unsigned short unac_data63[] = { 0xFFFF, 0x0580, 0xFFFF, 0x0581, 0xFFFF, 0x0582, 0xFFFF, 0x0583, 0xFFFF, 0x0584, 0xFFFF, 0x0585, 0xFFFF, 0x0586, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data64[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0565, 0x0582, 0x0565, 0x0582, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data65[] = { 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data66[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000 };
unsigned short unac_data67[] = { 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data68[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data69[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0627, 0x0627, 0x0627, 0x0627, 0x0648, 0x0648, 0x0627, 0x0627, 0x064A, 0x064A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data70[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data71[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF };
unsigned short unac_data72[] = { 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0627, 0x0674, 0x0627, 0x0674, 0x0648, 0x0674, 0x0648, 0x0674, 0x06C7, 0x0674, 0x06C7, 0x0674, 0x064A, 0x0674, 0x064A, 0x0674, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data73[] = { 0x06D5, 0x06D5, 0xFFFF, 0xFFFF, 0x06C1, 0x06C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data74[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x06D2, 0x06D2, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data75[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data76[] = { 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data77[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data78[] = { 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data79[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data80[] = { 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data81[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0928, 0x0928, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data82[] = { 0xFFFF, 0xFFFF, 0x0930, 0x0930, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0933, 0x0933, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data83[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data84[] = { 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0915, 0x0915, 0x0916, 0x0916, 0x0917, 0x0917, 0x091C, 0x091C, 0x0921, 0x0921, 0x0922, 0x0922, 0x092B, 0x092B, 0x092F, 0x092F };
unsigned short unac_data85[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data86[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data87[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data88[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x09A1, 0x09A1, 0x09A2, 0x09A2, 0xFFFF, 0xFFFF, 0x09AF, 0x09AF };
unsigned short unac_data89[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0A32, 0x0A32, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0A38, 0x0A38, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data90[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data91[] = { 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0A16, 0x0A16, 0x0A17, 0x0A17, 0x0A1C, 0x0A1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0A2B, 0x0A2B, 0xFFFF, 0xFFFF };
unsigned short unac_data92[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data93[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data94[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0B21, 0x0B21, 0x0B22, 0x0B22, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data95[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data96[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0B92, 0x0B92, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data97[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data98[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data99[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data100[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data101[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data102[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000 };
unsigned short unac_data103[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data104[] = { 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0E32, 0x0E32, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data105[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF };
unsigned short unac_data106[] = { 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0EB2, 0x0EB2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data107[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data108[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0EAB, 0x0E99, 0x0EAB, 0x0E99, 0x0EAB, 0x0EA1, 0x0EAB, 0x0EA1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data109[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F0B, 0x0F0B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data110[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data111[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data112[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F42, 0x0F42, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F4C, 0x0F4C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data113[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F51, 0x0F51, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F56, 0x0F56, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F5B, 0x0F5B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data114[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F40, 0x0F40, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data115[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data116[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data117[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data118[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data119[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1025, 0x1025, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data120[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data121[] = { 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data122[] = { 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data123[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000 };
unsigned short unac_data124[] = { 0xFFFF, 0x2D00, 0xFFFF, 0x2D01, 0xFFFF, 0x2D02, 0xFFFF, 0x2D03, 0xFFFF, 0x2D04, 0xFFFF, 0x2D05, 0xFFFF, 0x2D06, 0xFFFF, 0x2D07, 0xFFFF, 0x2D08, 0xFFFF, 0x2D09, 0xFFFF, 0x2D0A, 0xFFFF, 0x2D0B, 0xFFFF, 0x2D0C, 0xFFFF, 0x2D0D, 0xFFFF, 0x2D0E, 0xFFFF, 0x2D0F };
unsigned short unac_data125[] = { 0xFFFF, 0x2D10, 0xFFFF, 0x2D11, 0xFFFF, 0x2D12, 0xFFFF, 0x2D13, 0xFFFF, 0x2D14, 0xFFFF, 0x2D15, 0xFFFF, 0x2D16, 0xFFFF, 0x2D17, 0xFFFF, 0x2D18, 0xFFFF, 0x2D19, 0xFFFF, 0x2D1A, 0xFFFF, 0x2D1B, 0xFFFF, 0x2D1C, 0xFFFF, 0x2D1D, 0xFFFF, 0x2D1E, 0xFFFF, 0x2D1F };
unsigned short unac_data126[] = { 0xFFFF, 0x2D20, 0xFFFF, 0x2D21, 0xFFFF, 0x2D22, 0xFFFF, 0x2D23, 0xFFFF, 0x2D24, 0xFFFF, 0x2D25, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data127[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x10DC, 0x10DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data128[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000 };
unsigned short unac_data129[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data130[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data131[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data132[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data133[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data134[] = { 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data135[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data136[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x1B05, 0x1B05, 0xFFFF, 0xFFFF, 0x1B07, 0x1B07, 0xFFFF, 0xFFFF, 0x1B09, 0x1B09, 0xFFFF, 0xFFFF, 0x1B0B, 0x1B0B, 0xFFFF, 0xFFFF, 0x1B0D, 0x1B0D, 0xFFFF, 0xFFFF };
unsigned short unac_data137[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1B11, 0x1B11, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data138[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data139[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data140[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data141[] = { 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data142[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data143[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0041, 0x0061, 0x00C6, 0x00E6, 0x0042, 0x0062, 0xFFFF, 0xFFFF };
unsigned short unac_data144[] = { 0x0044, 0x0064, 0x0045, 0x0065, 0x018E, 0x01DD, 0x0047, 0x0067, 0x0048, 0x0068, 0x0049, 0x0069, 0x004A, 0x006A, 0x004B, 0x006B, 0x004C, 0x006C, 0x004D, 0x006D, 0x004E, 0x006E, 0xFFFF, 0xFFFF, 0x004F, 0x006F, 0x0222, 0x0223, 0x0050, 0x0070, 0x0052, 0x0072 };
unsigned short unac_data145[] = { 0x0054, 0x0074, 0x0055, 0x0075, 0x0057, 0x0077, 0x0061, 0x0061, 0x0250, 0x0250, 0x0251, 0x0251, 0x1D02, 0x1D02, 0x0062, 0x0062, 0x0064, 0x0064, 0x0065, 0x0065, 0x0259, 0x0259, 0x025B, 0x025B, 0x025C, 0x025C, 0x0067, 0x0067, 0xFFFF, 0xFFFF, 0x006B, 0x006B };
unsigned short unac_data146[] = { 0x006D, 0x006D, 0x014B, 0x014B, 0x006F, 0x006F, 0x0254, 0x0254, 0x1D16, 0x1D16, 0x1D17, 0x1D17, 0x0070, 0x0070, 0x0074, 0x0074, 0x0075, 0x0075, 0x1D1D, 0x1D1D, 0x026F, 0x026F, 0x0076, 0x0076, 0x1D25, 0x1D25, 0x03B2, 0x03B2, 0x03B3, 0x03B3, 0x03B4, 0x03B4 };
unsigned short unac_data147[] = { 0x03C6, 0x03C6, 0x03C7, 0x03C7, 0x0069, 0x0069, 0x0072, 0x0072, 0x0075, 0x0075, 0x0076, 0x0076, 0x03B2, 0x03B2, 0x03B3, 0x03B3, 0x03C1, 0x03C1, 0x03C6, 0x03C6, 0x03C7, 0x03C7, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data148[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x043D, 0x043D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data149[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0252, 0x0252, 0x0063, 0x0063, 0x0255, 0x0255, 0x00F0, 0x00F0, 0x025C, 0x025C };
unsigned short unac_data150[] = { 0x0066, 0x0066, 0x025F, 0x025F, 0x0261, 0x0261, 0x0265, 0x0265, 0x0268, 0x0268, 0x0269, 0x0269, 0x026A, 0x026A, 0x1D7B, 0x1D7B, 0x029D, 0x029D, 0x026D, 0x026D, 0x1D85, 0x1D85, 0x029F, 0x029F, 0x0271, 0x0271, 0x0270, 0x0270, 0x0272, 0x0272, 0x0273, 0x0273 };
unsigned short unac_data151[] = { 0x0274, 0x0274, 0x0275, 0x0275, 0x0278, 0x0278, 0x0282, 0x0282, 0x0283, 0x0283, 0x01AB, 0x01AB, 0x0289, 0x0289, 0x028A, 0x028A, 0x1D1C, 0x1D1C, 0x028B, 0x028B, 0x028C, 0x028C, 0x007A, 0x007A, 0x0290, 0x0290, 0x0291, 0x0291, 0x0292, 0x0292, 0x03B8, 0x03B8 };
unsigned short unac_data152[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data153[] = { 0x0041, 0x0061, 0x0061, 0x0061, 0x0042, 0x0062, 0x0062, 0x0062, 0x0042, 0x0062, 0x0062, 0x0062, 0x0042, 0x0062, 0x0062, 0x0062, 0x0043, 0x0063, 0x0063, 0x0063, 0x0044, 0x0064, 0x0064, 0x0064, 0x0044, 0x0064, 0x0064, 0x0064, 0x0044, 0x0064, 0x0064, 0x0064 };
unsigned short unac_data154[] = { 0x0044, 0x0064, 0x0064, 0x0064, 0x0044, 0x0064, 0x0064, 0x0064, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0046, 0x0066, 0x0066, 0x0066 };
unsigned short unac_data155[] = { 0x0047, 0x0067, 0x0067, 0x0067, 0x0048, 0x0068, 0x0068, 0x0068, 0x0048, 0x0068, 0x0068, 0x0068, 0x0048, 0x0068, 0x0068, 0x0068, 0x0048, 0x0068, 0x0068, 0x0068, 0x0048, 0x0068, 0x0068, 0x0068, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0069, 0x0069, 0x0069 };
unsigned short unac_data156[] = { 0x004B, 0x006B, 0x006B, 0x006B, 0x004B, 0x006B, 0x006B, 0x006B, 0x004B, 0x006B, 0x006B, 0x006B, 0x004C, 0x006C, 0x006C, 0x006C, 0x004C, 0x006C, 0x006C, 0x006C, 0x004C, 0x006C, 0x006C, 0x006C, 0x004C, 0x006C, 0x006C, 0x006C, 0x004D, 0x006D, 0x006D, 0x006D };
unsigned short unac_data157[] = { 0x004D, 0x006D, 0x006D, 0x006D, 0x004D, 0x006D, 0x006D, 0x006D, 0x004E, 0x006E, 0x006E, 0x006E, 0x004E, 0x006E, 0x006E, 0x006E, 0x004E, 0x006E, 0x006E, 0x006E, 0x004E, 0x006E, 0x006E, 0x006E, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F };
unsigned short unac_data158[] = { 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x0050, 0x0070, 0x0070, 0x0070, 0x0050, 0x0070, 0x0070, 0x0070, 0x0052, 0x0072, 0x0072, 0x0072, 0x0052, 0x0072, 0x0072, 0x0072, 0x0052, 0x0072, 0x0072, 0x0072, 0x0052, 0x0072, 0x0072, 0x0072 };
unsigned short unac_data159[] = { 0x0053, 0x0073, 0x0073, 0x0073, 0x0053, 0x0073, 0x0073, 0x0073, 0x0053, 0x0073, 0x0073, 0x0073, 0x0053, 0x0073, 0x0073, 0x0073, 0x0053, 0x0073, 0x0073, 0x0073, 0x0054, 0x0074, 0x0074, 0x0074, 0x0054, 0x0074, 0x0074, 0x0074, 0x0054, 0x0074, 0x0074, 0x0074 };
unsigned short unac_data160[] = { 0x0054, 0x0074, 0x0074, 0x0074, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0056, 0x0076, 0x0076, 0x0076, 0x0056, 0x0076, 0x0076, 0x0076 };
unsigned short unac_data161[] = { 0x0057, 0x0077, 0x0077, 0x0077, 0x0057, 0x0077, 0x0077, 0x0077, 0x0057, 0x0077, 0x0077, 0x0077, 0x0057, 0x0077, 0x0077, 0x0077, 0x0057, 0x0077, 0x0077, 0x0077, 0x0058, 0x0078, 0x0078, 0x0078, 0x0058, 0x0078, 0x0078, 0x0078, 0x0059, 0x0079, 0x0079, 0x0079 };
unsigned short unac_data162[] = { 0x005A, 0x007A, 0x007A, 0x007A, 0x005A, 0x007A, 0x007A, 0x007A, 0x005A, 0x007A, 0x007A, 0x007A, 0x0068, 0x0068, 0x0074, 0x0074, 0x0077, 0x0077, 0x0079, 0x0079, 0x0061, 0x02BE, 0x0061, 0x02BE, 0x0073, 0x0073, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0073, 0x0073, 0xFFFF, 0xFFFF };
unsigned short unac_data163[] = { 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061 };
unsigned short unac_data164[] = { 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065 };
unsigned short unac_data165[] = { 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0069, 0x0069, 0x0069, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F };
unsigned short unac_data166[] = { 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F };
unsigned short unac_data167[] = { 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075 };
unsigned short unac_data168[] = { 0x0055, 0x0075, 0x0075, 0x0075, 0x0059, 0x0079, 0x0079, 0x0079, 0x0059, 0x0079, 0x0079, 0x0079, 0x0059, 0x0079, 0x0079, 0x0079, 0x0059, 0x0079, 0x0079, 0x0079, 0xFFFF, 0x1EFB, 0xFFFF, 0xFFFF, 0xFFFF, 0x1EFD, 0xFFFF, 0xFFFF, 0xFFFF, 0x1EFF, 0xFFFF, 0xFFFF };
unsigned short unac_data169[] = { 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1 };
unsigned short unac_data170[] = { 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0395, 0x03B5, 0x0395, 0x03B5, 0x0395, 0x03B5, 0x0395, 0x03B5, 0x0395, 0x03B5, 0x0395, 0x03B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data171[] = { 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7 };
unsigned short unac_data172[] = { 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9 };
unsigned short unac_data173[] = { 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x039F, 0x03BF, 0x039F, 0x03BF, 0x039F, 0x03BF, 0x039F, 0x03BF, 0x039F, 0x03BF, 0x039F, 0x03BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data174[] = { 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0xFFFF, 0xFFFF, 0x03A5, 0x03C5, 0xFFFF, 0xFFFF, 0x03A5, 0x03C5, 0xFFFF, 0xFFFF, 0x03A5, 0x03C5, 0xFFFF, 0xFFFF, 0x03A5, 0x03C5 };
unsigned short unac_data175[] = { 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9 };
unsigned short unac_data176[] = { 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data177[] = { 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0xFFFF, 0xFFFF, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0020, 0x0020, 0x03B9, 0x03B9, 0x0020, 0x0020 };
unsigned short unac_data178[] = { 0x0020, 0x0020, 0x0020, 0x0020, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0xFFFF, 0xFFFF, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x0395, 0x03B5, 0x0395, 0x03B5, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020 };
unsigned short unac_data179[] = { 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020 };
unsigned short unac_data180[] = { 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C1, 0x03C1, 0x03C1, 0x03C1, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03A5, 0x03C5, 0x03A5, 0x03C5, 0x03A5, 0x03C5, 0x03A5, 0x03C5, 0x03A1, 0x03C1, 0x0020, 0x0020, 0x0020, 0x0020, 0x0060, 0x0060 };
unsigned short unac_data181[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0xFFFF, 0xFFFF, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x039F, 0x03BF, 0x039F, 0x03BF, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x0020, 0x0020, 0x0020, 0x0020, 0xFFFF, 0xFFFF };
unsigned short unac_data182[] = { 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data183[] = { 0xFFFF, 0xFFFF, 0x2010, 0x2010, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data184[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020 };
unsigned short unac_data185[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0xFFFF, 0xFFFF, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0021, 0x0021, 0x0021, 0x0021, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0xFFFF, 0xFFFF };
unsigned short unac_data186[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x0021, 0x003F, 0x0021, 0x0021, 0x003F, 0x0021, 0x003F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data187[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020 };
unsigned short unac_data188[] = { 0x0030, 0x0030, 0x0069, 0x0069, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0034, 0x0034, 0x0035, 0x0035, 0x0036, 0x0036, 0x0037, 0x0037, 0x0038, 0x0038, 0x0039, 0x0039, 0x002B, 0x002B, 0x2212, 0x2212, 0x003D, 0x003D, 0x0028, 0x0028, 0x0029, 0x0029, 0x006E, 0x006E };
unsigned short unac_data189[] = { 0x0030, 0x0030, 0x0031, 0x0031, 0x0032, 0x0032, 0x0033, 0x0033, 0x0034, 0x0034, 0x0035, 0x0035, 0x0036, 0x0036, 0x0037, 0x0037, 0x0038, 0x0038, 0x0039, 0x0039, 0x002B, 0x002B, 0x2212, 0x2212, 0x003D, 0x003D, 0x0028, 0x0028, 0x0029, 0x0029, 0xFFFF, 0xFFFF };
unsigned short unac_data190[] = { 0x0061, 0x0061, 0x0065, 0x0065, 0x006F, 0x006F, 0x0078, 0x0078, 0x0259, 0x0259, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data191[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0052, 0x0073, 0x0072, 0x0073, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data192[] = { 0x0061, 0x002F, 0x0063, 0x0061, 0x002F, 0x0063, 0x0061, 0x002F, 0x0073, 0x0061, 0x002F, 0x0073, 0x0043, 0x0063, 0x00B0, 0x0043, 0x00B0, 0x0063, 0xFFFF, 0xFFFF, 0x0063, 0x002F, 0x006F, 0x0063, 0x002F, 0x006F, 0x0063, 0x002F, 0x0075, 0x0063, 0x002F, 0x0075, 0x0190, 0x025B, 0xFFFF, 0xFFFF, 0x00B0, 0x0046, 0x00B0, 0x0066, 0x0067, 0x0067, 0x0048, 0x0068, 0x0048, 0x0068, 0x0048, 0x0068, 0x0068, 0x0068, 0x0127, 0x0127 };
unsigned short unac_data193[] = { 0x0049, 0x0069, 0x0049, 0x0069, 0x004C, 0x006C, 0x006C, 0x006C, 0xFFFF, 0xFFFF, 0x004E, 0x006E, 0x004E, 0x006F, 0x006E, 0x006F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0050, 0x0070, 0x0051, 0x0071, 0x0052, 0x0072, 0x0052, 0x0072, 0x0052, 0x0072, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data194[] = { 0x0053, 0x004D, 0x0073, 0x006D, 0x0054, 0x0045, 0x004C, 0x0074, 0x0065, 0x006C, 0x0054, 0x004D, 0x0074, 0x006D, 0xFFFF, 0xFFFF, 0x005A, 0x007A, 0xFFFF, 0xFFFF, 0x03A9, 0x03C9, 0xFFFF, 0xFFFF, 0x005A, 0x007A, 0xFFFF, 0xFFFF, 0x004B, 0x006B, 0x0041, 0x0061, 0x0042, 0x0062, 0x0043, 0x0063, 0xFFFF, 0xFFFF, 0x0065, 0x0065 };
unsigned short unac_data195[] = { 0x0045, 0x0065, 0x0046, 0x0066, 0xFFFF, 0x214E, 0x004D, 0x006D, 0x006F, 0x006F, 0x05D0, 0x05D0, 0x05D1, 0x05D1, 0x05D2, 0x05D2, 0x05D3, 0x05D3, 0x0069, 0x0069, 0xFFFF, 0xFFFF, 0x0046, 0x0041, 0x0058, 0x0066, 0x0061, 0x0078, 0x03C0, 0x03C0, 0x03B3, 0x03B3, 0x0393, 0x03B3, 0x03A0, 0x03C0 };
unsigned short unac_data196[] = { 0x2211, 0x2211, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0044, 0x0064, 0x0064, 0x0064, 0x0065, 0x0065, 0x0069, 0x0069, 0x006A, 0x006A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data197[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0031, 0x2044, 0x0033, 0x0031, 0x2044, 0x0033, 0x0032, 0x2044, 0x0033, 0x0032, 0x2044, 0x0033, 0x0031, 0x2044, 0x0035, 0x0031, 0x2044, 0x0035, 0x0032, 0x2044, 0x0035, 0x0032, 0x2044, 0x0035, 0x0033, 0x2044, 0x0035, 0x0033, 0x2044, 0x0035, 0x0034, 0x2044, 0x0035, 0x0034, 0x2044, 0x0035, 0x0031, 0x2044, 0x0036, 0x0031, 0x2044, 0x0036, 0x0035, 0x2044, 0x0036, 0x0035, 0x2044, 0x0036, 0x0031, 0x2044, 0x0038, 0x0031, 0x2044, 0x0038, 0x0033, 0x2044, 0x0038, 0x0033, 0x2044, 0x0038, 0x0035, 0x2044, 0x0038, 0x0035, 0x2044, 0x0038, 0x0037, 0x2044, 0x0038, 0x0037, 0x2044, 0x0038, 0x0031, 0x2044, 0x0031, 0x2044 };
unsigned short unac_data198[] = { 0x0049, 0x0069, 0x0049, 0x0049, 0x0069, 0x0069, 0x0049, 0x0049, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0056, 0x0069, 0x0076, 0x0056, 0x0076, 0x0056, 0x0049, 0x0076, 0x0069, 0x0056, 0x0049, 0x0049, 0x0076, 0x0069, 0x0069, 0x0056, 0x0049, 0x0049, 0x0049, 0x0076, 0x0069, 0x0069, 0x0069, 0x0049, 0x0058, 0x0069, 0x0078, 0x0058, 0x0078, 0x0058, 0x0049, 0x0078, 0x0069, 0x0058, 0x0049, 0x0049, 0x0078, 0x0069, 0x0069, 0x004C, 0x006C, 0x0043, 0x0063, 0x0044, 0x0064, 0x004D, 0x006D };
unsigned short unac_data199[] = { 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0076, 0x0069, 0x0076, 0x0076, 0x0076, 0x0076, 0x0069, 0x0076, 0x0069, 0x0076, 0x0069, 0x0069, 0x0076, 0x0069, 0x0069, 0x0076, 0x0069, 0x0069, 0x0069, 0x0076, 0x0069, 0x0069, 0x0069, 0x0069, 0x0078, 0x0069, 0x0078, 0x0078, 0x0078, 0x0078, 0x0069, 0x0078, 0x0069, 0x0078, 0x0069, 0x0069, 0x0078, 0x0069, 0x0069, 0x006C, 0x006C, 0x0063, 0x0063, 0x0064, 0x0064, 0x006D, 0x006D };
unsigned short unac_data200[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2184, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data201[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2190, 0x2190, 0x2192, 0x2192, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data202[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2194, 0x2194, 0xFFFF, 0xFFFF };
unsigned short unac_data203[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x21D0, 0x21D0, 0x21D4, 0x21D4, 0x21D2, 0x21D2 };
unsigned short unac_data204[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2203, 0x2203, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2208, 0x2208, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x220B, 0x220B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data205[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2223, 0x2223, 0xFFFF, 0xFFFF, 0x2225, 0x2225, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0xFFFF, 0xFFFF, 0x222E, 0x222E, 0x222E, 0x222E };
unsigned short unac_data206[] = { 0x222E, 0x222E, 0x222E, 0x222E, 0x222E, 0x222E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data207[] = { 0xFFFF, 0xFFFF, 0x223C, 0x223C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2243, 0x2243, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2245, 0x2245, 0xFFFF, 0xFFFF, 0x2248, 0x2248, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data208[] = { 0x003D, 0x003D, 0xFFFF, 0xFFFF, 0x2261, 0x2261, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x224D, 0x224D, 0x003C, 0x003C, 0x003E, 0x003E };
unsigned short unac_data209[] = { 0x2264, 0x2264, 0x2265, 0x2265, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2272, 0x2272, 0x2273, 0x2273, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2276, 0x2276, 0x2277, 0x2277, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data210[] = { 0x227A, 0x227A, 0x227B, 0x227B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2282, 0x2282, 0x2283, 0x2283, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2286, 0x2286, 0x2287, 0x2287, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data211[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x22A2, 0x22A2, 0x22A8, 0x22A8, 0x22A9, 0x22A9, 0x22AB, 0x22AB };
unsigned short unac_data212[] = { 0x227C, 0x227C, 0x227D, 0x227D, 0x2291, 0x2291, 0x2292, 0x2292, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x22B2, 0x22B2, 0x22B3, 0x22B3, 0x22B4, 0x22B4, 0x22B5, 0x22B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data213[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x3008, 0x3008, 0x3009, 0x3009, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data214[] = { 0x0031, 0x0031, 0x0032, 0x0032, 0x0033, 0x0033, 0x0034, 0x0034, 0x0035, 0x0035, 0x0036, 0x0036, 0x0037, 0x0037, 0x0038, 0x0038, 0x0039, 0x0039, 0x0031, 0x0030, 0x0031, 0x0030, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0032, 0x0031, 0x0032, 0x0031, 0x0033, 0x0031, 0x0033, 0x0031, 0x0034, 0x0031, 0x0034, 0x0031, 0x0035, 0x0031, 0x0035, 0x0031, 0x0036, 0x0031, 0x0036 };
unsigned short unac_data215[] = { 0x0031, 0x0037, 0x0031, 0x0037, 0x0031, 0x0038, 0x0031, 0x0038, 0x0031, 0x0039, 0x0031, 0x0039, 0x0032, 0x0030, 0x0032, 0x0030, 0x0028, 0x0031, 0x0029, 0x0028, 0x0031, 0x0029, 0x0028, 0x0032, 0x0029, 0x0028, 0x0032, 0x0029, 0x0028, 0x0033, 0x0029, 0x0028, 0x0033, 0x0029, 0x0028, 0x0034, 0x0029, 0x0028, 0x0034, 0x0029, 0x0028, 0x0035, 0x0029, 0x0028, 0x0035, 0x0029, 0x0028, 0x0036, 0x0029, 0x0028, 0x0036, 0x0029, 0x0028, 0x0037, 0x0029, 0x0028, 0x0037, 0x0029, 0x0028, 0x0038, 0x0029, 0x0028, 0x0038, 0x0029, 0x0028, 0x0039, 0x0029, 0x0028, 0x0039, 0x0029, 0x0028, 0x0031, 0x0030, 0x0029, 0x0028, 0x0031, 0x0030, 0x0029, 0x0028, 0x0031, 0x0031, 0x0029, 0x0028, 0x0031, 0x0031, 0x0029, 0x0028, 0x0031, 0x0032, 0x0029, 0x0028, 0x0031, 0x0032, 0x0029 };
unsigned short unac_data216[] = { 0x0028, 0x0031, 0x0033, 0x0029, 0x0028, 0x0031, 0x0033, 0x0029, 0x0028, 0x0031, 0x0034, 0x0029, 0x0028, 0x0031, 0x0034, 0x0029, 0x0028, 0x0031, 0x0035, 0x0029, 0x0028, 0x0031, 0x0035, 0x0029, 0x0028, 0x0031, 0x0036, 0x0029, 0x0028, 0x0031, 0x0036, 0x0029, 0x0028, 0x0031, 0x0037, 0x0029, 0x0028, 0x0031, 0x0037, 0x0029, 0x0028, 0x0031, 0x0038, 0x0029, 0x0028, 0x0031, 0x0038, 0x0029, 0x0028, 0x0031, 0x0039, 0x0029, 0x0028, 0x0031, 0x0039, 0x0029, 0x0028, 0x0032, 0x0030, 0x0029, 0x0028, 0x0032, 0x0030, 0x0029, 0x0031, 0x002E, 0x0031, 0x002E, 0x0032, 0x002E, 0x0032, 0x002E, 0x0033, 0x002E, 0x0033, 0x002E, 0x0034, 0x002E, 0x0034, 0x002E, 0x0035, 0x002E, 0x0035, 0x002E, 0x0036, 0x002E, 0x0036, 0x002E, 0x0037, 0x002E, 0x0037, 0x002E, 0x0038, 0x002E, 0x0038, 0x002E };
unsigned short unac_data217[] = { 0x0039, 0x002E, 0x0039, 0x002E, 0x0031, 0x0030, 0x002E, 0x0031, 0x0030, 0x002E, 0x0031, 0x0031, 0x002E, 0x0031, 0x0031, 0x002E, 0x0031, 0x0032, 0x002E, 0x0031, 0x0032, 0x002E, 0x0031, 0x0033, 0x002E, 0x0031, 0x0033, 0x002E, 0x0031, 0x0034, 0x002E, 0x0031, 0x0034, 0x002E, 0x0031, 0x0035, 0x002E, 0x0031, 0x0035, 0x002E, 0x0031, 0x0036, 0x002E, 0x0031, 0x0036, 0x002E, 0x0031, 0x0037, 0x002E, 0x0031, 0x0037, 0x002E, 0x0031, 0x0038, 0x002E, 0x0031, 0x0038, 0x002E, 0x0031, 0x0039, 0x002E, 0x0031, 0x0039, 0x002E, 0x0032, 0x0030, 0x002E, 0x0032, 0x0030, 0x002E, 0x0028, 0x0061, 0x0029, 0x0028, 0x0061, 0x0029, 0x0028, 0x0062, 0x0029, 0x0028, 0x0062, 0x0029, 0x0028, 0x0063, 0x0029, 0x0028, 0x0063, 0x0029, 0x0028, 0x0064, 0x0029, 0x0028, 0x0064, 0x0029 };
unsigned short unac_data218[] = { 0x0028, 0x0065, 0x0029, 0x0028, 0x0065, 0x0029, 0x0028, 0x0066, 0x0029, 0x0028, 0x0066, 0x0029, 0x0028, 0x0067, 0x0029, 0x0028, 0x0067, 0x0029, 0x0028, 0x0068, 0x0029, 0x0028, 0x0068, 0x0029, 0x0028, 0x0069, 0x0029, 0x0028, 0x0069, 0x0029, 0x0028, 0x006A, 0x0029, 0x0028, 0x006A, 0x0029, 0x0028, 0x006B, 0x0029, 0x0028, 0x006B, 0x0029, 0x0028, 0x006C, 0x0029, 0x0028, 0x006C, 0x0029, 0x0028, 0x006D, 0x0029, 0x0028, 0x006D, 0x0029, 0x0028, 0x006E, 0x0029, 0x0028, 0x006E, 0x0029, 0x0028, 0x006F, 0x0029, 0x0028, 0x006F, 0x0029, 0x0028, 0x0070, 0x0029, 0x0028, 0x0070, 0x0029, 0x0028, 0x0071, 0x0029, 0x0028, 0x0071, 0x0029, 0x0028, 0x0072, 0x0029, 0x0028, 0x0072, 0x0029, 0x0028, 0x0073, 0x0029, 0x0028, 0x0073, 0x0029, 0x0028, 0x0074, 0x0029, 0x0028, 0x0074, 0x0029 };
unsigned short unac_data219[] = { 0x0028, 0x0075, 0x0029, 0x0028, 0x0075, 0x0029, 0x0028, 0x0076, 0x0029, 0x0028, 0x0076, 0x0029, 0x0028, 0x0077, 0x0029, 0x0028, 0x0077, 0x0029, 0x0028, 0x0078, 0x0029, 0x0028, 0x0078, 0x0029, 0x0028, 0x0079, 0x0029, 0x0028, 0x0079, 0x0029, 0x0028, 0x007A, 0x0029, 0x0028, 0x007A, 0x0029, 0x0041, 0x0061, 0x0042, 0x0062, 0x0043, 0x0063, 0x0044, 0x0064, 0x0045, 0x0065, 0x0046, 0x0066, 0x0047, 0x0067, 0x0048, 0x0068, 0x0049, 0x0069, 0x004A, 0x006A };
unsigned short unac_data220[] = { 0x004B, 0x006B, 0x004C, 0x006C, 0x004D, 0x006D, 0x004E, 0x006E, 0x004F, 0x006F, 0x0050, 0x0070, 0x0051, 0x0071, 0x0052, 0x0072, 0x0053, 0x0073, 0x0054, 0x0074, 0x0055, 0x0075, 0x0056, 0x0076, 0x0057, 0x0077, 0x0058, 0x0078, 0x0059, 0x0079, 0x005A, 0x007A };
unsigned short unac_data221[] = { 0x0061, 0x0061, 0x0062, 0x0062, 0x0063, 0x0063, 0x0064, 0x0064, 0x0065, 0x0065, 0x0066, 0x0066, 0x0067, 0x0067, 0x0068, 0x0068, 0x0069, 0x0069, 0x006A, 0x006A, 0x006B, 0x006B, 0x006C, 0x006C, 0x006D, 0x006D, 0x006E, 0x006E, 0x006F, 0x006F, 0x0070, 0x0070 };
unsigned short unac_data222[] = { 0x0071, 0x0071, 0x0072, 0x0072, 0x0073, 0x0073, 0x0074, 0x0074, 0x0075, 0x0075, 0x0076, 0x0076, 0x0077, 0x0077, 0x0078, 0x0078, 0x0079, 0x0079, 0x007A, 0x007A, 0x0030, 0x0030, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data223[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data224[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x003A, 0x003A, 0x003D, 0x003A, 0x003A, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data225[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2ADD, 0x2ADD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data226[] = { 0xFFFF, 0x2C30, 0xFFFF, 0x2C31, 0xFFFF, 0x2C32, 0xFFFF, 0x2C33, 0xFFFF, 0x2C34, 0xFFFF, 0x2C35, 0xFFFF, 0x2C36, 0xFFFF, 0x2C37, 0xFFFF, 0x2C38, 0xFFFF, 0x2C39, 0xFFFF, 0x2C3A, 0xFFFF, 0x2C3B, 0xFFFF, 0x2C3C, 0xFFFF, 0x2C3D, 0xFFFF, 0x2C3E, 0xFFFF, 0x2C3F };
unsigned short unac_data227[] = { 0xFFFF, 0x2C40, 0xFFFF, 0x2C41, 0xFFFF, 0x2C42, 0xFFFF, 0x2C43, 0xFFFF, 0x2C44, 0xFFFF, 0x2C45, 0xFFFF, 0x2C46, 0xFFFF, 0x2C47, 0xFFFF, 0x2C48, 0xFFFF, 0x2C49, 0xFFFF, 0x2C4A, 0xFFFF, 0x2C4B, 0xFFFF, 0x2C4C, 0xFFFF, 0x2C4D, 0xFFFF, 0x2C4E, 0xFFFF, 0x2C4F };
unsigned short unac_data228[] = { 0xFFFF, 0x2C50, 0xFFFF, 0x2C51, 0xFFFF, 0x2C52, 0xFFFF, 0x2C53, 0xFFFF, 0x2C54, 0xFFFF, 0x2C55, 0xFFFF, 0x2C56, 0xFFFF, 0x2C57, 0xFFFF, 0x2C58, 0xFFFF, 0x2C59, 0xFFFF, 0x2C5A, 0xFFFF, 0x2C5B, 0xFFFF, 0x2C5C, 0xFFFF, 0x2C5D, 0xFFFF, 0x2C5E, 0xFFFF, 0xFFFF };
unsigned short unac_data229[] = { 0xFFFF, 0x2C61, 0xFFFF, 0xFFFF, 0xFFFF, 0x026B, 0xFFFF, 0x1D7D, 0xFFFF, 0x027D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C68, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C6A, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C6C, 0xFFFF, 0xFFFF, 0xFFFF, 0x0251, 0xFFFF, 0x0271, 0xFFFF, 0x0250 };
unsigned short unac_data230[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C73, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C76, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x006A, 0x006A, 0x0056, 0x0076, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data231[] = { 0xFFFF, 0x2C81, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C83, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C85, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C87, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C89, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C8B, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C8D, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C8F, 0xFFFF, 0xFFFF };
unsigned short unac_data232[] = { 0xFFFF, 0x2C91, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C93, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C95, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C97, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C99, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C9B, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C9D, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C9F, 0xFFFF, 0xFFFF };
unsigned short unac_data233[] = { 0xFFFF, 0x2CA1, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CA3, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CA5, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CA7, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CA9, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CAB, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CAD, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CAF, 0xFFFF, 0xFFFF };
unsigned short unac_data234[] = { 0xFFFF, 0x2CB1, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CB3, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CB5, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CB7, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CB9, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CBB, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CBD, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CBF, 0xFFFF, 0xFFFF };
unsigned short unac_data235[] = { 0xFFFF, 0x2CC1, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CC3, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CC5, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CC7, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CC9, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CCB, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CCD, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CCF, 0xFFFF, 0xFFFF };
unsigned short unac_data236[] = { 0xFFFF, 0x2CD1, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CD3, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CD5, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CD7, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CD9, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CDB, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CDD, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CDF, 0xFFFF, 0xFFFF };
unsigned short unac_data237[] = { 0xFFFF, 0x2CE1, 0xFFFF, 0xFFFF, 0xFFFF, 0x2CE3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data238[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2D61, 0x2D61 };
unsigned short unac_data239[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x6BCD, 0x6BCD };
unsigned short unac_data240[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x9F9F, 0x9F9F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data241[] = { 0x4E00, 0x4E00, 0x4E28, 0x4E28, 0x4E36, 0x4E36, 0x4E3F, 0x4E3F, 0x4E59, 0x4E59, 0x4E85, 0x4E85, 0x4E8C, 0x4E8C, 0x4EA0, 0x4EA0, 0x4EBA, 0x4EBA, 0x513F, 0x513F, 0x5165, 0x5165, 0x516B, 0x516B, 0x5182, 0x5182, 0x5196, 0x5196, 0x51AB, 0x51AB, 0x51E0, 0x51E0 };
unsigned short unac_data242[] = { 0x51F5, 0x51F5, 0x5200, 0x5200, 0x529B, 0x529B, 0x52F9, 0x52F9, 0x5315, 0x5315, 0x531A, 0x531A, 0x5338, 0x5338, 0x5341, 0x5341, 0x535C, 0x535C, 0x5369, 0x5369, 0x5382, 0x5382, 0x53B6, 0x53B6, 0x53C8, 0x53C8, 0x53E3, 0x53E3, 0x56D7, 0x56D7, 0x571F, 0x571F };
unsigned short unac_data243[] = { 0x58EB, 0x58EB, 0x5902, 0x5902, 0x590A, 0x590A, 0x5915, 0x5915, 0x5927, 0x5927, 0x5973, 0x5973, 0x5B50, 0x5B50, 0x5B80, 0x5B80, 0x5BF8, 0x5BF8, 0x5C0F, 0x5C0F, 0x5C22, 0x5C22, 0x5C38, 0x5C38, 0x5C6E, 0x5C6E, 0x5C71, 0x5C71, 0x5DDB, 0x5DDB, 0x5DE5, 0x5DE5 };
unsigned short unac_data244[] = { 0x5DF1, 0x5DF1, 0x5DFE, 0x5DFE, 0x5E72, 0x5E72, 0x5E7A, 0x5E7A, 0x5E7F, 0x5E7F, 0x5EF4, 0x5EF4, 0x5EFE, 0x5EFE, 0x5F0B, 0x5F0B, 0x5F13, 0x5F13, 0x5F50, 0x5F50, 0x5F61, 0x5F61, 0x5F73, 0x5F73, 0x5FC3, 0x5FC3, 0x6208, 0x6208, 0x6236, 0x6236, 0x624B, 0x624B };
unsigned short unac_data245[] = { 0x652F, 0x652F, 0x6534, 0x6534, 0x6587, 0x6587, 0x6597, 0x6597, 0x65A4, 0x65A4, 0x65B9, 0x65B9, 0x65E0, 0x65E0, 0x65E5, 0x65E5, 0x66F0, 0x66F0, 0x6708, 0x6708, 0x6728, 0x6728, 0x6B20, 0x6B20, 0x6B62, 0x6B62, 0x6B79, 0x6B79, 0x6BB3, 0x6BB3, 0x6BCB, 0x6BCB };
unsigned short unac_data246[] = { 0x6BD4, 0x6BD4, 0x6BDB, 0x6BDB, 0x6C0F, 0x6C0F, 0x6C14, 0x6C14, 0x6C34, 0x6C34, 0x706B, 0x706B, 0x722A, 0x722A, 0x7236, 0x7236, 0x723B, 0x723B, 0x723F, 0x723F, 0x7247, 0x7247, 0x7259, 0x7259, 0x725B, 0x725B, 0x72AC, 0x72AC, 0x7384, 0x7384, 0x7389, 0x7389 };
unsigned short unac_data247[] = { 0x74DC, 0x74DC, 0x74E6, 0x74E6, 0x7518, 0x7518, 0x751F, 0x751F, 0x7528, 0x7528, 0x7530, 0x7530, 0x758B, 0x758B, 0x7592, 0x7592, 0x7676, 0x7676, 0x767D, 0x767D, 0x76AE, 0x76AE, 0x76BF, 0x76BF, 0x76EE, 0x76EE, 0x77DB, 0x77DB, 0x77E2, 0x77E2, 0x77F3, 0x77F3 };
unsigned short unac_data248[] = { 0x793A, 0x793A, 0x79B8, 0x79B8, 0x79BE, 0x79BE, 0x7A74, 0x7A74, 0x7ACB, 0x7ACB, 0x7AF9, 0x7AF9, 0x7C73, 0x7C73, 0x7CF8, 0x7CF8, 0x7F36, 0x7F36, 0x7F51, 0x7F51, 0x7F8A, 0x7F8A, 0x7FBD, 0x7FBD, 0x8001, 0x8001, 0x800C, 0x800C, 0x8012, 0x8012, 0x8033, 0x8033 };
unsigned short unac_data249[] = { 0x807F, 0x807F, 0x8089, 0x8089, 0x81E3, 0x81E3, 0x81EA, 0x81EA, 0x81F3, 0x81F3, 0x81FC, 0x81FC, 0x820C, 0x820C, 0x821B, 0x821B, 0x821F, 0x821F, 0x826E, 0x826E, 0x8272, 0x8272, 0x8278, 0x8278, 0x864D, 0x864D, 0x866B, 0x866B, 0x8840, 0x8840, 0x884C, 0x884C };
unsigned short unac_data250[] = { 0x8863, 0x8863, 0x897E, 0x897E, 0x898B, 0x898B, 0x89D2, 0x89D2, 0x8A00, 0x8A00, 0x8C37, 0x8C37, 0x8C46, 0x8C46, 0x8C55, 0x8C55, 0x8C78, 0x8C78, 0x8C9D, 0x8C9D, 0x8D64, 0x8D64, 0x8D70, 0x8D70, 0x8DB3, 0x8DB3, 0x8EAB, 0x8EAB, 0x8ECA, 0x8ECA, 0x8F9B, 0x8F9B };
unsigned short unac_data251[] = { 0x8FB0, 0x8FB0, 0x8FB5, 0x8FB5, 0x9091, 0x9091, 0x9149, 0x9149, 0x91C6, 0x91C6, 0x91CC, 0x91CC, 0x91D1, 0x91D1, 0x9577, 0x9577, 0x9580, 0x9580, 0x961C, 0x961C, 0x96B6, 0x96B6, 0x96B9, 0x96B9, 0x96E8, 0x96E8, 0x9751, 0x9751, 0x975E, 0x975E, 0x9762, 0x9762 };
unsigned short unac_data252[] = { 0x9769, 0x9769, 0x97CB, 0x97CB, 0x97ED, 0x97ED, 0x97F3, 0x97F3, 0x9801, 0x9801, 0x98A8, 0x98A8, 0x98DB, 0x98DB, 0x98DF, 0x98DF, 0x9996, 0x9996, 0x9999, 0x9999, 0x99AC, 0x99AC, 0x9AA8, 0x9AA8, 0x9AD8, 0x9AD8, 0x9ADF, 0x9ADF, 0x9B25, 0x9B25, 0x9B2F, 0x9B2F };
unsigned short unac_data253[] = { 0x9B32, 0x9B32, 0x9B3C, 0x9B3C, 0x9B5A, 0x9B5A, 0x9CE5, 0x9CE5, 0x9E75, 0x9E75, 0x9E7F, 0x9E7F, 0x9EA5, 0x9EA5, 0x9EBB, 0x9EBB, 0x9EC3, 0x9EC3, 0x9ECD, 0x9ECD, 0x9ED1, 0x9ED1, 0x9EF9, 0x9EF9, 0x9EFD, 0x9EFD, 0x9F0E, 0x9F0E, 0x9F13, 0x9F13, 0x9F20, 0x9F20 };
unsigned short unac_data254[] = { 0x9F3B, 0x9F3B, 0x9F4A, 0x9F4A, 0x9F52, 0x9F52, 0x9F8D, 0x9F8D, 0x9F9C, 0x9F9C, 0x9FA0, 0x9FA0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data255[] = { 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data256[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data257[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x3012, 0x3012, 0xFFFF, 0xFFFF, 0x5341, 0x5341, 0x5344, 0x5344, 0x5345, 0x5345, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data258[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data259[] = { 0xFFFF, 0xFFFF, 0x1100, 0x1100, 0x1101, 0x1101, 0x11AA, 0x11AA, 0x1102, 0x1102, 0x11AC, 0x11AC, 0x11AD, 0x11AD, 0x1103, 0x1103, 0x1104, 0x1104, 0x1105, 0x1105, 0x11B0, 0x11B0, 0x11B1, 0x11B1, 0x11B2, 0x11B2, 0x11B3, 0x11B3, 0x11B4, 0x11B4, 0x11B5, 0x11B5 };
unsigned short unac_data260[] = { 0x111A, 0x111A, 0x1106, 0x1106, 0x1107, 0x1107, 0x1108, 0x1108, 0x1121, 0x1121, 0x1109, 0x1109, 0x110A, 0x110A, 0x110B, 0x110B, 0x110C, 0x110C, 0x110D, 0x110D, 0x110E, 0x110E, 0x110F, 0x110F, 0x1110, 0x1110, 0x1111, 0x1111, 0x1112, 0x1112, 0x1161, 0x1161 };
unsigned short unac_data261[] = { 0x1162, 0x1162, 0x1163, 0x1163, 0x1164, 0x1164, 0x1165, 0x1165, 0x1166, 0x1166, 0x1167, 0x1167, 0x1168, 0x1168, 0x1169, 0x1169, 0x116A, 0x116A, 0x116B, 0x116B, 0x116C, 0x116C, 0x116D, 0x116D, 0x116E, 0x116E, 0x116F, 0x116F, 0x1170, 0x1170, 0x1171, 0x1171 };
unsigned short unac_data262[] = { 0x1172, 0x1172, 0x1173, 0x1173, 0x1174, 0x1174, 0x1175, 0x1175, 0x1160, 0x1160, 0x1114, 0x1114, 0x1115, 0x1115, 0x11C7, 0x11C7, 0x11C8, 0x11C8, 0x11CC, 0x11CC, 0x11CE, 0x11CE, 0x11D3, 0x11D3, 0x11D7, 0x11D7, 0x11D9, 0x11D9, 0x111C, 0x111C, 0x11DD, 0x11DD };
unsigned short unac_data263[] = { 0x11DF, 0x11DF, 0x111D, 0x111D, 0x111E, 0x111E, 0x1120, 0x1120, 0x1122, 0x1122, 0x1123, 0x1123, 0x1127, 0x1127, 0x1129, 0x1129, 0x112B, 0x112B, 0x112C, 0x112C, 0x112D, 0x112D, 0x112E, 0x112E, 0x112F, 0x112F, 0x1132, 0x1132, 0x1136, 0x1136, 0x1140, 0x1140 };
unsigned short unac_data264[] = { 0x1147, 0x1147, 0x114C, 0x114C, 0x11F1, 0x11F1, 0x11F2, 0x11F2, 0x1157, 0x1157, 0x1158, 0x1158, 0x1159, 0x1159, 0x1184, 0x1184, 0x1185, 0x1185, 0x1188, 0x1188, 0x1191, 0x1191, 0x1192, 0x1192, 0x1194, 0x1194, 0x119E, 0x119E, 0x11A1, 0x11A1, 0xFFFF, 0xFFFF };
unsigned short unac_data265[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x4E00, 0x4E00, 0x4E8C, 0x4E8C, 0x4E09, 0x4E09, 0x56DB, 0x56DB, 0x4E0A, 0x4E0A, 0x4E2D, 0x4E2D, 0x4E0B, 0x4E0B, 0x7532, 0x7532, 0x4E59, 0x4E59, 0x4E19, 0x4E19, 0x4E01, 0x4E01, 0x5929, 0x5929, 0x5730, 0x5730, 0x4EBA, 0x4EBA };
unsigned short unac_data266[] = { 0x0028, 0x1100, 0x0029, 0x0028, 0x1100, 0x0029, 0x0028, 0x1102, 0x0029, 0x0028, 0x1102, 0x0029, 0x0028, 0x1103, 0x0029, 0x0028, 0x1103, 0x0029, 0x0028, 0x1105, 0x0029, 0x0028, 0x1105, 0x0029, 0x0028, 0x1106, 0x0029, 0x0028, 0x1106, 0x0029, 0x0028, 0x1107, 0x0029, 0x0028, 0x1107, 0x0029, 0x0028, 0x1109, 0x0029, 0x0028, 0x1109, 0x0029, 0x0028, 0x110B, 0x0029, 0x0028, 0x110B, 0x0029, 0x0028, 0x110C, 0x0029, 0x0028, 0x110C, 0x0029, 0x0028, 0x110E, 0x0029, 0x0028, 0x110E, 0x0029, 0x0028, 0x110F, 0x0029, 0x0028, 0x110F, 0x0029, 0x0028, 0x1110, 0x0029, 0x0028, 0x1110, 0x0029, 0x0028, 0x1111, 0x0029, 0x0028, 0x1111, 0x0029, 0x0028, 0x1112, 0x0029, 0x0028, 0x1112, 0x0029, 0x0028, 0x1100, 0x1161, 0x0029, 0x0028, 0x1100, 0x1161, 0x0029, 0x0028, 0x1102, 0x1161, 0x0029, 0x0028, 0x1102, 0x1161, 0x0029 };
unsigned short unac_data267[] = { 0x0028, 0x1103, 0x1161, 0x0029, 0x0028, 0x1103, 0x1161, 0x0029, 0x0028, 0x1105, 0x1161, 0x0029, 0x0028, 0x1105, 0x1161, 0x0029, 0x0028, 0x1106, 0x1161, 0x0029, 0x0028, 0x1106, 0x1161, 0x0029, 0x0028, 0x1107, 0x1161, 0x0029, 0x0028, 0x1107, 0x1161, 0x0029, 0x0028, 0x1109, 0x1161, 0x0029, 0x0028, 0x1109, 0x1161, 0x0029, 0x0028, 0x110B, 0x1161, 0x0029, 0x0028, 0x110B, 0x1161, 0x0029, 0x0028, 0x110C, 0x1161, 0x0029, 0x0028, 0x110C, 0x1161, 0x0029, 0x0028, 0x110E, 0x1161, 0x0029, 0x0028, 0x110E, 0x1161, 0x0029, 0x0028, 0x110F, 0x1161, 0x0029, 0x0028, 0x110F, 0x1161, 0x0029, 0x0028, 0x1110, 0x1161, 0x0029, 0x0028, 0x1110, 0x1161, 0x0029, 0x0028, 0x1111, 0x1161, 0x0029, 0x0028, 0x1111, 0x1161, 0x0029, 0x0028, 0x1112, 0x1161, 0x0029, 0x0028, 0x1112, 0x1161, 0x0029, 0x0028, 0x110C, 0x116E, 0x0029, 0x0028, 0x110C, 0x116E, 0x0029, 0x0028, 0x110B, 0x1169, 0x110C, 0x1165, 0x11AB, 0x0029, 0x0028, 0x110B, 0x1169, 0x110C, 0x1165, 0x11AB, 0x0029, 0x0028, 0x110B, 0x1169, 0x1112, 0x116E, 0x0029, 0x0028, 0x110B, 0x1169, 0x1112, 0x116E, 0x0029, 0xFFFF, 0xFFFF };
unsigned short unac_data268[] = { 0x0028, 0x4E00, 0x0029, 0x0028, 0x4E00, 0x0029, 0x0028, 0x4E8C, 0x0029, 0x0028, 0x4E8C, 0x0029, 0x0028, 0x4E09, 0x0029, 0x0028, 0x4E09, 0x0029, 0x0028, 0x56DB, 0x0029, 0x0028, 0x56DB, 0x0029, 0x0028, 0x4E94, 0x0029, 0x0028, 0x4E94, 0x0029, 0x0028, 0x516D, 0x0029, 0x0028, 0x516D, 0x0029, 0x0028, 0x4E03, 0x0029, 0x0028, 0x4E03, 0x0029, 0x0028, 0x516B, 0x0029, 0x0028, 0x516B, 0x0029, 0x0028, 0x4E5D, 0x0029, 0x0028, 0x4E5D, 0x0029, 0x0028, 0x5341, 0x0029, 0x0028, 0x5341, 0x0029, 0x0028, 0x6708, 0x0029, 0x0028, 0x6708, 0x0029, 0x0028, 0x706B, 0x0029, 0x0028, 0x706B, 0x0029, 0x0028, 0x6C34, 0x0029, 0x0028, 0x6C34, 0x0029, 0x0028, 0x6728, 0x0029, 0x0028, 0x6728, 0x0029, 0x0028, 0x91D1, 0x0029, 0x0028, 0x91D1, 0x0029, 0x0028, 0x571F, 0x0029, 0x0028, 0x571F, 0x0029 };
unsigned short unac_data269[] = { 0x0028, 0x65E5, 0x0029, 0x0028, 0x65E5, 0x0029, 0x0028, 0x682A, 0x0029, 0x0028, 0x682A, 0x0029, 0x0028, 0x6709, 0x0029, 0x0028, 0x6709, 0x0029, 0x0028, 0x793E, 0x0029, 0x0028, 0x793E, 0x0029, 0x0028, 0x540D, 0x0029, 0x0028, 0x540D, 0x0029, 0x0028, 0x7279, 0x0029, 0x0028, 0x7279, 0x0029, 0x0028, 0x8CA1, 0x0029, 0x0028, 0x8CA1, 0x0029, 0x0028, 0x795D, 0x0029, 0x0028, 0x795D, 0x0029, 0x0028, 0x52B4, 0x0029, 0x0028, 0x52B4, 0x0029, 0x0028, 0x4EE3, 0x0029, 0x0028, 0x4EE3, 0x0029, 0x0028, 0x547C, 0x0029, 0x0028, 0x547C, 0x0029, 0x0028, 0x5B66, 0x0029, 0x0028, 0x5B66, 0x0029, 0x0028, 0x76E3, 0x0029, 0x0028, 0x76E3, 0x0029, 0x0028, 0x4F01, 0x0029, 0x0028, 0x4F01, 0x0029, 0x0028, 0x8CC7, 0x0029, 0x0028, 0x8CC7, 0x0029, 0x0028, 0x5354, 0x0029, 0x0028, 0x5354, 0x0029 };
unsigned short unac_data270[] = { 0x0028, 0x796D, 0x0029, 0x0028, 0x796D, 0x0029, 0x0028, 0x4F11, 0x0029, 0x0028, 0x4F11, 0x0029, 0x0028, 0x81EA, 0x0029, 0x0028, 0x81EA, 0x0029, 0x0028, 0x81F3, 0x0029, 0x0028, 0x81F3, 0x0029, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data271[] = { 0x0050, 0x0054, 0x0045, 0x0070, 0x0074, 0x0065, 0x0032, 0x0031, 0x0032, 0x0031, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0033, 0x0032, 0x0033, 0x0032, 0x0034, 0x0032, 0x0034, 0x0032, 0x0035, 0x0032, 0x0035, 0x0032, 0x0036, 0x0032, 0x0036, 0x0032, 0x0037, 0x0032, 0x0037, 0x0032, 0x0038, 0x0032, 0x0038, 0x0032, 0x0039, 0x0032, 0x0039, 0x0033, 0x0030, 0x0033, 0x0030, 0x0033, 0x0031, 0x0033, 0x0031, 0x0033, 0x0032, 0x0033, 0x0032, 0x0033, 0x0033, 0x0033, 0x0033, 0x0033, 0x0034, 0x0033, 0x0034, 0x0033, 0x0035, 0x0033, 0x0035 };
unsigned short unac_data272[] = { 0x1100, 0x1100, 0x1102, 0x1102, 0x1103, 0x1103, 0x1105, 0x1105, 0x1106, 0x1106, 0x1107, 0x1107, 0x1109, 0x1109, 0x110B, 0x110B, 0x110C, 0x110C, 0x110E, 0x110E, 0x110F, 0x110F, 0x1110, 0x1110, 0x1111, 0x1111, 0x1112, 0x1112, 0x1100, 0x1161, 0x1100, 0x1161, 0x1102, 0x1161, 0x1102, 0x1161 };
unsigned short unac_data273[] = { 0x1103, 0x1161, 0x1103, 0x1161, 0x1105, 0x1161, 0x1105, 0x1161, 0x1106, 0x1161, 0x1106, 0x1161, 0x1107, 0x1161, 0x1107, 0x1161, 0x1109, 0x1161, 0x1109, 0x1161, 0x110B, 0x1161, 0x110B, 0x1161, 0x110C, 0x1161, 0x110C, 0x1161, 0x110E, 0x1161, 0x110E, 0x1161, 0x110F, 0x1161, 0x110F, 0x1161, 0x1110, 0x1161, 0x1110, 0x1161, 0x1111, 0x1161, 0x1111, 0x1161, 0x1112, 0x1161, 0x1112, 0x1161, 0x110E, 0x1161, 0x11B7, 0x1100, 0x1169, 0x110E, 0x1161, 0x11B7, 0x1100, 0x1169, 0x110C, 0x116E, 0x110B, 0x1174, 0x110C, 0x116E, 0x110B, 0x1174, 0x110B, 0x116E, 0x110B, 0x116E, 0xFFFF, 0xFFFF };
unsigned short unac_data274[] = { 0x4E00, 0x4E00, 0x4E8C, 0x4E8C, 0x4E09, 0x4E09, 0x56DB, 0x56DB, 0x4E94, 0x4E94, 0x516D, 0x516D, 0x4E03, 0x4E03, 0x516B, 0x516B, 0x4E5D, 0x4E5D, 0x5341, 0x5341, 0x6708, 0x6708, 0x706B, 0x706B, 0x6C34, 0x6C34, 0x6728, 0x6728, 0x91D1, 0x91D1, 0x571F, 0x571F };
unsigned short unac_data275[] = { 0x65E5, 0x65E5, 0x682A, 0x682A, 0x6709, 0x6709, 0x793E, 0x793E, 0x540D, 0x540D, 0x7279, 0x7279, 0x8CA1, 0x8CA1, 0x795D, 0x795D, 0x52B4, 0x52B4, 0x79D8, 0x79D8, 0x7537, 0x7537, 0x5973, 0x5973, 0x9069, 0x9069, 0x512A, 0x512A, 0x5370, 0x5370, 0x6CE8, 0x6CE8 };
unsigned short unac_data276[] = { 0x9805, 0x9805, 0x4F11, 0x4F11, 0x5199, 0x5199, 0x6B63, 0x6B63, 0x4E0A, 0x4E0A, 0x4E2D, 0x4E2D, 0x4E0B, 0x4E0B, 0x5DE6, 0x5DE6, 0x53F3, 0x53F3, 0x533B, 0x533B, 0x5B97, 0x5B97, 0x5B66, 0x5B66, 0x76E3, 0x76E3, 0x4F01, 0x4F01, 0x8CC7, 0x8CC7, 0x5354, 0x5354 };
unsigned short unac_data277[] = { 0x591C, 0x591C, 0x0033, 0x0036, 0x0033, 0x0036, 0x0033, 0x0037, 0x0033, 0x0037, 0x0033, 0x0038, 0x0033, 0x0038, 0x0033, 0x0039, 0x0033, 0x0039, 0x0034, 0x0030, 0x0034, 0x0030, 0x0034, 0x0031, 0x0034, 0x0031, 0x0034, 0x0032, 0x0034, 0x0032, 0x0034, 0x0033, 0x0034, 0x0033, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0035, 0x0034, 0x0035, 0x0034, 0x0036, 0x0034, 0x0036, 0x0034, 0x0037, 0x0034, 0x0037, 0x0034, 0x0038, 0x0034, 0x0038, 0x0034, 0x0039, 0x0034, 0x0039, 0x0035, 0x0030, 0x0035, 0x0030 };
unsigned short unac_data278[] = { 0x0031, 0x6708, 0x0031, 0x6708, 0x0032, 0x6708, 0x0032, 0x6708, 0x0033, 0x6708, 0x0033, 0x6708, 0x0034, 0x6708, 0x0034, 0x6708, 0x0035, 0x6708, 0x0035, 0x6708, 0x0036, 0x6708, 0x0036, 0x6708, 0x0037, 0x6708, 0x0037, 0x6708, 0x0038, 0x6708, 0x0038, 0x6708, 0x0039, 0x6708, 0x0039, 0x6708, 0x0031, 0x0030, 0x6708, 0x0031, 0x0030, 0x6708, 0x0031, 0x0031, 0x6708, 0x0031, 0x0031, 0x6708, 0x0031, 0x0032, 0x6708, 0x0031, 0x0032, 0x6708, 0x0048, 0x0067, 0x0068, 0x0067, 0x0065, 0x0072, 0x0067, 0x0065, 0x0072, 0x0067, 0x0065, 0x0056, 0x0065, 0x0076, 0x004C, 0x0054, 0x0044, 0x006C, 0x0074, 0x0064 };
unsigned short unac_data279[] = { 0x30A2, 0x30A2, 0x30A4, 0x30A4, 0x30A6, 0x30A6, 0x30A8, 0x30A8, 0x30AA, 0x30AA, 0x30AB, 0x30AB, 0x30AD, 0x30AD, 0x30AF, 0x30AF, 0x30B1, 0x30B1, 0x30B3, 0x30B3, 0x30B5, 0x30B5, 0x30B7, 0x30B7, 0x30B9, 0x30B9, 0x30BB, 0x30BB, 0x30BD, 0x30BD, 0x30BF, 0x30BF };
unsigned short unac_data280[] = { 0x30C1, 0x30C1, 0x30C4, 0x30C4, 0x30C6, 0x30C6, 0x30C8, 0x30C8, 0x30CA, 0x30CA, 0x30CB, 0x30CB, 0x30CC, 0x30CC, 0x30CD, 0x30CD, 0x30CE, 0x30CE, 0x30CF, 0x30CF, 0x30D2, 0x30D2, 0x30D5, 0x30D5, 0x30D8, 0x30D8, 0x30DB, 0x30DB, 0x30DE, 0x30DE, 0x30DF, 0x30DF };
unsigned short unac_data281[] = { 0x30E0, 0x30E0, 0x30E1, 0x30E1, 0x30E2, 0x30E2, 0x30E4, 0x30E4, 0x30E6, 0x30E6, 0x30E8, 0x30E8, 0x30E9, 0x30E9, 0x30EA, 0x30EA, 0x30EB, 0x30EB, 0x30EC, 0x30EC, 0x30ED, 0x30ED, 0x30EF, 0x30EF, 0x30F0, 0x30F0, 0x30F1, 0x30F1, 0x30F2, 0x30F2, 0xFFFF, 0xFFFF };
unsigned short unac_data282[] = { 0x30A2, 0x30D1, 0x30FC, 0x30C8, 0x30A2, 0x30D1, 0x30FC, 0x30C8, 0x30A2, 0x30EB, 0x30D5, 0x30A1, 0x30A2, 0x30EB, 0x30D5, 0x30A1, 0x30A2, 0x30F3, 0x30DA, 0x30A2, 0x30A2, 0x30F3, 0x30DA, 0x30A2, 0x30A2, 0x30FC, 0x30EB, 0x30A2, 0x30FC, 0x30EB, 0x30A4, 0x30CB, 0x30F3, 0x30B0, 0x30A4, 0x30CB, 0x30F3, 0x30B0, 0x30A4, 0x30F3, 0x30C1, 0x30A4, 0x30F3, 0x30C1, 0x30A6, 0x30A9, 0x30F3, 0x30A6, 0x30A9, 0x30F3, 0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C9, 0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C9, 0x30A8, 0x30FC, 0x30AB, 0x30FC, 0x30A8, 0x30FC, 0x30AB, 0x30FC, 0x30AA, 0x30F3, 0x30B9, 0x30AA, 0x30F3, 0x30B9, 0x30AA, 0x30FC, 0x30E0, 0x30AA, 0x30FC, 0x30E0, 0x30AB, 0x30A4, 0x30EA, 0x30AB, 0x30A4, 0x30EA, 0x30AB, 0x30E9, 0x30C3, 0x30C8, 0x30AB, 0x30E9, 0x30C3, 0x30C8, 0x30AB, 0x30ED, 0x30EA, 0x30FC, 0x30AB, 0x30ED, 0x30EA, 0x30FC, 0x30AC, 0x30ED, 0x30F3, 0x30AC, 0x30ED, 0x30F3, 0x30AC, 0x30F3, 0x30DE, 0x30AC, 0x30F3, 0x30DE };
unsigned short unac_data283[] = { 0x30AE, 0x30AC, 0x30AE, 0x30AC, 0x30AE, 0x30CB, 0x30FC, 0x30AE, 0x30CB, 0x30FC, 0x30AD, 0x30E5, 0x30EA, 0x30FC, 0x30AD, 0x30E5, 0x30EA, 0x30FC, 0x30AE, 0x30EB, 0x30C0, 0x30FC, 0x30AE, 0x30EB, 0x30C0, 0x30FC, 0x30AD, 0x30ED, 0x30AD, 0x30ED, 0x30AD, 0x30ED, 0x30B0, 0x30E9, 0x30E0, 0x30AD, 0x30ED, 0x30B0, 0x30E9, 0x30E0, 0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8, 0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8, 0x30B0, 0x30E9, 0x30E0, 0x30B0, 0x30E9, 0x30E0, 0x30B0, 0x30E9, 0x30E0, 0x30C8, 0x30F3, 0x30B0, 0x30E9, 0x30E0, 0x30C8, 0x30F3, 0x30AF, 0x30EB, 0x30BC, 0x30A4, 0x30ED, 0x30AF, 0x30EB, 0x30BC, 0x30A4, 0x30ED, 0x30AF, 0x30ED, 0x30FC, 0x30CD, 0x30AF, 0x30ED, 0x30FC, 0x30CD, 0x30B1, 0x30FC, 0x30B9, 0x30B1, 0x30FC, 0x30B9, 0x30B3, 0x30EB, 0x30CA, 0x30B3, 0x30EB, 0x30CA, 0x30B3, 0x30FC, 0x30DD, 0x30B3, 0x30FC, 0x30DD, 0x30B5, 0x30A4, 0x30AF, 0x30EB, 0x30B5, 0x30A4, 0x30AF, 0x30EB };
unsigned short unac_data284[] = { 0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0, 0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0, 0x30B7, 0x30EA, 0x30F3, 0x30B0, 0x30B7, 0x30EA, 0x30F3, 0x30B0, 0x30BB, 0x30F3, 0x30C1, 0x30BB, 0x30F3, 0x30C1, 0x30BB, 0x30F3, 0x30C8, 0x30BB, 0x30F3, 0x30C8, 0x30C0, 0x30FC, 0x30B9, 0x30C0, 0x30FC, 0x30B9, 0x30C7, 0x30B7, 0x30C7, 0x30B7, 0x30C9, 0x30EB, 0x30C9, 0x30EB, 0x30C8, 0x30F3, 0x30C8, 0x30F3, 0x30CA, 0x30CE, 0x30CA, 0x30CE, 0x30CE, 0x30C3, 0x30C8, 0x30CE, 0x30C3, 0x30C8, 0x30CF, 0x30A4, 0x30C4, 0x30CF, 0x30A4, 0x30C4, 0x30D1, 0x30FC, 0x30BB, 0x30F3, 0x30C8, 0x30D1, 0x30FC, 0x30BB, 0x30F3, 0x30C8, 0x30D1, 0x30FC, 0x30C4, 0x30D1, 0x30FC, 0x30C4, 0x30D0, 0x30FC, 0x30EC, 0x30EB, 0x30D0, 0x30FC, 0x30EC, 0x30EB, 0x30D4, 0x30A2, 0x30B9, 0x30C8, 0x30EB, 0x30D4, 0x30A2, 0x30B9, 0x30C8, 0x30EB, 0x30D4, 0x30AF, 0x30EB, 0x30D4, 0x30AF, 0x30EB };
unsigned short unac_data285[] = { 0x30D4, 0x30B3, 0x30D4, 0x30B3, 0x30D3, 0x30EB, 0x30D3, 0x30EB, 0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C9, 0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C9, 0x30D5, 0x30A3, 0x30FC, 0x30C8, 0x30D5, 0x30A3, 0x30FC, 0x30C8, 0x30D6, 0x30C3, 0x30B7, 0x30A7, 0x30EB, 0x30D6, 0x30C3, 0x30B7, 0x30A7, 0x30EB, 0x30D5, 0x30E9, 0x30F3, 0x30D5, 0x30E9, 0x30F3, 0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB, 0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB, 0x30DA, 0x30BD, 0x30DA, 0x30BD, 0x30DA, 0x30CB, 0x30D2, 0x30DA, 0x30CB, 0x30D2, 0x30D8, 0x30EB, 0x30C4, 0x30D8, 0x30EB, 0x30C4, 0x30DA, 0x30F3, 0x30B9, 0x30DA, 0x30F3, 0x30B9, 0x30DA, 0x30FC, 0x30B8, 0x30DA, 0x30FC, 0x30B8, 0x30D9, 0x30FC, 0x30BF, 0x30D9, 0x30FC, 0x30BF, 0x30DD, 0x30A4, 0x30F3, 0x30C8, 0x30DD, 0x30A4, 0x30F3, 0x30C8, 0x30DC, 0x30EB, 0x30C8, 0x30DC, 0x30EB, 0x30C8, 0x30DB, 0x30F3, 0x30DB, 0x30F3 };
unsigned short unac_data286[] = { 0x30DD, 0x30F3, 0x30C9, 0x30DD, 0x30F3, 0x30C9, 0x30DB, 0x30FC, 0x30EB, 0x30DB, 0x30FC, 0x30EB, 0x30DB, 0x30FC, 0x30F3, 0x30DB, 0x30FC, 0x30F3, 0x30DE, 0x30A4, 0x30AF, 0x30ED, 0x30DE, 0x30A4, 0x30AF, 0x30ED, 0x30DE, 0x30A4, 0x30EB, 0x30DE, 0x30A4, 0x30EB, 0x30DE, 0x30C3, 0x30CF, 0x30DE, 0x30C3, 0x30CF, 0x30DE, 0x30EB, 0x30AF, 0x30DE, 0x30EB, 0x30AF, 0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3, 0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3, 0x30DF, 0x30AF, 0x30ED, 0x30F3, 0x30DF, 0x30AF, 0x30ED, 0x30F3, 0x30DF, 0x30EA, 0x30DF, 0x30EA, 0x30DF, 0x30EA, 0x30D0, 0x30FC, 0x30EB, 0x30DF, 0x30EA, 0x30D0, 0x30FC, 0x30EB, 0x30E1, 0x30AC, 0x30E1, 0x30AC, 0x30E1, 0x30AC, 0x30C8, 0x30F3, 0x30E1, 0x30AC, 0x30C8, 0x30F3, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0x30E4, 0x30FC, 0x30C9, 0x30E4, 0x30FC, 0x30C9, 0x30E4, 0x30FC, 0x30EB, 0x30E4, 0x30FC, 0x30EB };
unsigned short unac_data287[] = { 0x30E6, 0x30A2, 0x30F3, 0x30E6, 0x30A2, 0x30F3, 0x30EA, 0x30C3, 0x30C8, 0x30EB, 0x30EA, 0x30C3, 0x30C8, 0x30EB, 0x30EA, 0x30E9, 0x30EA, 0x30E9, 0x30EB, 0x30D4, 0x30FC, 0x30EB, 0x30D4, 0x30FC, 0x30EB, 0x30FC, 0x30D6, 0x30EB, 0x30EB, 0x30FC, 0x30D6, 0x30EB, 0x30EC, 0x30E0, 0x30EC, 0x30E0, 0x30EC, 0x30F3, 0x30C8, 0x30B2, 0x30F3, 0x30EC, 0x30F3, 0x30C8, 0x30B2, 0x30F3, 0x30EF, 0x30C3, 0x30C8, 0x30EF, 0x30C3, 0x30C8, 0x0030, 0x70B9, 0x0030, 0x70B9, 0x0031, 0x70B9, 0x0031, 0x70B9, 0x0032, 0x70B9, 0x0032, 0x70B9, 0x0033, 0x70B9, 0x0033, 0x70B9, 0x0034, 0x70B9, 0x0034, 0x70B9, 0x0035, 0x70B9, 0x0035, 0x70B9, 0x0036, 0x70B9, 0x0036, 0x70B9, 0x0037, 0x70B9, 0x0037, 0x70B9 };
unsigned short unac_data288[] = { 0x0038, 0x70B9, 0x0038, 0x70B9, 0x0039, 0x70B9, 0x0039, 0x70B9, 0x0031, 0x0030, 0x70B9, 0x0031, 0x0030, 0x70B9, 0x0031, 0x0031, 0x70B9, 0x0031, 0x0031, 0x70B9, 0x0031, 0x0032, 0x70B9, 0x0031, 0x0032, 0x70B9, 0x0031, 0x0033, 0x70B9, 0x0031, 0x0033, 0x70B9, 0x0031, 0x0034, 0x70B9, 0x0031, 0x0034, 0x70B9, 0x0031, 0x0035, 0x70B9, 0x0031, 0x0035, 0x70B9, 0x0031, 0x0036, 0x70B9, 0x0031, 0x0036, 0x70B9, 0x0031, 0x0037, 0x70B9, 0x0031, 0x0037, 0x70B9, 0x0031, 0x0038, 0x70B9, 0x0031, 0x0038, 0x70B9, 0x0031, 0x0039, 0x70B9, 0x0031, 0x0039, 0x70B9, 0x0032, 0x0030, 0x70B9, 0x0032, 0x0030, 0x70B9, 0x0032, 0x0031, 0x70B9, 0x0032, 0x0031, 0x70B9, 0x0032, 0x0032, 0x70B9, 0x0032, 0x0032, 0x70B9, 0x0032, 0x0033, 0x70B9, 0x0032, 0x0033, 0x70B9 };
unsigned short unac_data289[] = { 0x0032, 0x0034, 0x70B9, 0x0032, 0x0034, 0x70B9, 0x0068, 0x0050, 0x0061, 0x0068, 0x0070, 0x0061, 0x0064, 0x0061, 0x0064, 0x0061, 0x0041, 0x0055, 0x0061, 0x0075, 0x0062, 0x0061, 0x0072, 0x0062, 0x0061, 0x0072, 0x006F, 0x0056, 0x006F, 0x0076, 0x0070, 0x0063, 0x0070, 0x0063, 0x0064, 0x006D, 0x0064, 0x006D, 0x0064, 0x006D, 0x0032, 0x0064, 0x006D, 0x0032, 0x0064, 0x006D, 0x0033, 0x0064, 0x006D, 0x0033, 0x0049, 0x0055, 0x0069, 0x0075, 0x5E73, 0x6210, 0x5E73, 0x6210, 0x662D, 0x548C, 0x662D, 0x548C, 0x5927, 0x6B63, 0x5927, 0x6B63, 0x660E, 0x6CBB, 0x660E, 0x6CBB, 0x682A, 0x5F0F, 0x4F1A, 0x793E, 0x682A, 0x5F0F, 0x4F1A, 0x793E };
unsigned short unac_data290[] = { 0x0070, 0x0041, 0x0070, 0x0061, 0x006E, 0x0041, 0x006E, 0x0061, 0x03BC, 0x0041, 0x03BC, 0x0061, 0x006D, 0x0041, 0x006D, 0x0061, 0x006B, 0x0041, 0x006B, 0x0061, 0x004B, 0x0042, 0x006B, 0x0062, 0x004D, 0x0042, 0x006D, 0x0062, 0x0047, 0x0042, 0x0067, 0x0062, 0x0063, 0x0061, 0x006C, 0x0063, 0x0061, 0x006C, 0x006B, 0x0063, 0x0061, 0x006C, 0x006B, 0x0063, 0x0061, 0x006C, 0x0070, 0x0046, 0x0070, 0x0066, 0x006E, 0x0046, 0x006E, 0x0066, 0x03BC, 0x0046, 0x03BC, 0x0066, 0x03BC, 0x0067, 0x03BC, 0x0067, 0x006D, 0x0067, 0x006D, 0x0067, 0x006B, 0x0067, 0x006B, 0x0067 };
unsigned short unac_data291[] = { 0x0048, 0x007A, 0x0068, 0x007A, 0x006B, 0x0048, 0x007A, 0x006B, 0x0068, 0x007A, 0x004D, 0x0048, 0x007A, 0x006D, 0x0068, 0x007A, 0x0047, 0x0048, 0x007A, 0x0067, 0x0068, 0x007A, 0x0054, 0x0048, 0x007A, 0x0074, 0x0068, 0x007A, 0x03BC, 0x006C, 0x03BC, 0x006C, 0x006D, 0x006C, 0x006D, 0x006C, 0x0064, 0x006C, 0x0064, 0x006C, 0x006B, 0x006C, 0x006B, 0x006C, 0x0066, 0x006D, 0x0066, 0x006D, 0x006E, 0x006D, 0x006E, 0x006D, 0x03BC, 0x006D, 0x03BC, 0x006D, 0x006D, 0x006D, 0x006D, 0x006D, 0x0063, 0x006D, 0x0063, 0x006D, 0x006B, 0x006D, 0x006B, 0x006D, 0x006D, 0x006D, 0x0032, 0x006D, 0x006D, 0x0032 };
unsigned short unac_data292[] = { 0x0063, 0x006D, 0x0032, 0x0063, 0x006D, 0x0032, 0x006D, 0x0032, 0x006D, 0x0032, 0x006B, 0x006D, 0x0032, 0x006B, 0x006D, 0x0032, 0x006D, 0x006D, 0x0033, 0x006D, 0x006D, 0x0033, 0x0063, 0x006D, 0x0033, 0x0063, 0x006D, 0x0033, 0x006D, 0x0033, 0x006D, 0x0033, 0x006B, 0x006D, 0x0033, 0x006B, 0x006D, 0x0033, 0x006D, 0x2215, 0x0073, 0x006D, 0x2215, 0x0073, 0x006D, 0x2215, 0x0073, 0x0032, 0x006D, 0x2215, 0x0073, 0x0032, 0x0050, 0x0061, 0x0070, 0x0061, 0x006B, 0x0050, 0x0061, 0x006B, 0x0070, 0x0061, 0x004D, 0x0050, 0x0061, 0x006D, 0x0070, 0x0061, 0x0047, 0x0050, 0x0061, 0x0067, 0x0070, 0x0061, 0x0072, 0x0061, 0x0064, 0x0072, 0x0061, 0x0064, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0032, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0032 };
unsigned short unac_data293[] = { 0x0070, 0x0073, 0x0070, 0x0073, 0x006E, 0x0073, 0x006E, 0x0073, 0x03BC, 0x0073, 0x03BC, 0x0073, 0x006D, 0x0073, 0x006D, 0x0073, 0x0070, 0x0056, 0x0070, 0x0076, 0x006E, 0x0056, 0x006E, 0x0076, 0x03BC, 0x0056, 0x03BC, 0x0076, 0x006D, 0x0056, 0x006D, 0x0076, 0x006B, 0x0056, 0x006B, 0x0076, 0x004D, 0x0056, 0x006D, 0x0076, 0x0070, 0x0057, 0x0070, 0x0077, 0x006E, 0x0057, 0x006E, 0x0077, 0x03BC, 0x0057, 0x03BC, 0x0077, 0x006D, 0x0057, 0x006D, 0x0077, 0x006B, 0x0057, 0x006B, 0x0077, 0x004D, 0x0057, 0x006D, 0x0077 };
unsigned short unac_data294[] = { 0x006B, 0x03A9, 0x006B, 0x03C9, 0x004D, 0x03A9, 0x006D, 0x03C9, 0x0061, 0x002E, 0x006D, 0x002E, 0x0061, 0x002E, 0x006D, 0x002E, 0x0042, 0x0071, 0x0062, 0x0071, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0064, 0x0063, 0x0064, 0x0043, 0x2215, 0x006B, 0x0067, 0x0063, 0x2215, 0x006B, 0x0067, 0x0043, 0x006F, 0x002E, 0x0063, 0x006F, 0x002E, 0x0064, 0x0042, 0x0064, 0x0062, 0x0047, 0x0079, 0x0067, 0x0079, 0x0068, 0x0061, 0x0068, 0x0061, 0x0048, 0x0050, 0x0068, 0x0070, 0x0069, 0x006E, 0x0069, 0x006E, 0x004B, 0x004B, 0x006B, 0x006B, 0x004B, 0x004D, 0x006B, 0x006D, 0x006B, 0x0074, 0x006B, 0x0074 };
unsigned short unac_data295[] = { 0x006C, 0x006D, 0x006C, 0x006D, 0x006C, 0x006E, 0x006C, 0x006E, 0x006C, 0x006F, 0x0067, 0x006C, 0x006F, 0x0067, 0x006C, 0x0078, 0x006C, 0x0078, 0x006D, 0x0062, 0x006D, 0x0062, 0x006D, 0x0069, 0x006C, 0x006D, 0x0069, 0x006C, 0x006D, 0x006F, 0x006C, 0x006D, 0x006F, 0x006C, 0x0050, 0x0048, 0x0070, 0x0068, 0x0070, 0x002E, 0x006D, 0x002E, 0x0070, 0x002E, 0x006D, 0x002E, 0x0050, 0x0050, 0x004D, 0x0070, 0x0070, 0x006D, 0x0050, 0x0052, 0x0070, 0x0072, 0x0073, 0x0072, 0x0073, 0x0072, 0x0053, 0x0076, 0x0073, 0x0076, 0x0057, 0x0062, 0x0077, 0x0062, 0x0056, 0x2215, 0x006D, 0x0076, 0x2215, 0x006D, 0x0041, 0x2215, 0x006D, 0x0061, 0x2215, 0x006D };
unsigned short unac_data296[] = { 0x0031, 0x65E5, 0x0031, 0x65E5, 0x0032, 0x65E5, 0x0032, 0x65E5, 0x0033, 0x65E5, 0x0033, 0x65E5, 0x0034, 0x65E5, 0x0034, 0x65E5, 0x0035, 0x65E5, 0x0035, 0x65E5, 0x0036, 0x65E5, 0x0036, 0x65E5, 0x0037, 0x65E5, 0x0037, 0x65E5, 0x0038, 0x65E5, 0x0038, 0x65E5, 0x0039, 0x65E5, 0x0039, 0x65E5, 0x0031, 0x0030, 0x65E5, 0x0031, 0x0030, 0x65E5, 0x0031, 0x0031, 0x65E5, 0x0031, 0x0031, 0x65E5, 0x0031, 0x0032, 0x65E5, 0x0031, 0x0032, 0x65E5, 0x0031, 0x0033, 0x65E5, 0x0031, 0x0033, 0x65E5, 0x0031, 0x0034, 0x65E5, 0x0031, 0x0034, 0x65E5, 0x0031, 0x0035, 0x65E5, 0x0031, 0x0035, 0x65E5, 0x0031, 0x0036, 0x65E5, 0x0031, 0x0036, 0x65E5 };
unsigned short unac_data297[] = { 0x0031, 0x0037, 0x65E5, 0x0031, 0x0037, 0x65E5, 0x0031, 0x0038, 0x65E5, 0x0031, 0x0038, 0x65E5, 0x0031, 0x0039, 0x65E5, 0x0031, 0x0039, 0x65E5, 0x0032, 0x0030, 0x65E5, 0x0032, 0x0030, 0x65E5, 0x0032, 0x0031, 0x65E5, 0x0032, 0x0031, 0x65E5, 0x0032, 0x0032, 0x65E5, 0x0032, 0x0032, 0x65E5, 0x0032, 0x0033, 0x65E5, 0x0032, 0x0033, 0x65E5, 0x0032, 0x0034, 0x65E5, 0x0032, 0x0034, 0x65E5, 0x0032, 0x0035, 0x65E5, 0x0032, 0x0035, 0x65E5, 0x0032, 0x0036, 0x65E5, 0x0032, 0x0036, 0x65E5, 0x0032, 0x0037, 0x65E5, 0x0032, 0x0037, 0x65E5, 0x0032, 0x0038, 0x65E5, 0x0032, 0x0038, 0x65E5, 0x0032, 0x0039, 0x65E5, 0x0032, 0x0039, 0x65E5, 0x0033, 0x0030, 0x65E5, 0x0033, 0x0030, 0x65E5, 0x0033, 0x0031, 0x65E5, 0x0033, 0x0031, 0x65E5, 0x0067, 0x0061, 0x006C, 0x0067, 0x0061, 0x006C };
unsigned short unac_data298[] = { 0xFFFF, 0xA641, 0xFFFF, 0xFFFF, 0xFFFF, 0xA643, 0xFFFF, 0xFFFF, 0xFFFF, 0xA645, 0xFFFF, 0xFFFF, 0xFFFF, 0xA647, 0xFFFF, 0xFFFF, 0xFFFF, 0xA649, 0xFFFF, 0xFFFF, 0xFFFF, 0xA64B, 0xFFFF, 0xFFFF, 0xFFFF, 0xA64D, 0xFFFF, 0xFFFF, 0xFFFF, 0xA64F, 0xFFFF, 0xFFFF };
unsigned short unac_data299[] = { 0xFFFF, 0xA651, 0xFFFF, 0xFFFF, 0xFFFF, 0xA653, 0xFFFF, 0xFFFF, 0xFFFF, 0xA655, 0xFFFF, 0xFFFF, 0xFFFF, 0xA657, 0xFFFF, 0xFFFF, 0xFFFF, 0xA659, 0xFFFF, 0xFFFF, 0xFFFF, 0xA65B, 0xFFFF, 0xFFFF, 0xFFFF, 0xA65D, 0xFFFF, 0xFFFF, 0xFFFF, 0xA65F, 0xFFFF, 0xFFFF };
unsigned short unac_data300[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xA663, 0xFFFF, 0xFFFF, 0xFFFF, 0xA665, 0xFFFF, 0xFFFF, 0xFFFF, 0xA667, 0xFFFF, 0xFFFF, 0xFFFF, 0xA669, 0xFFFF, 0xFFFF, 0xFFFF, 0xA66B, 0xFFFF, 0xFFFF, 0xFFFF, 0xA66D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000 };
unsigned short unac_data301[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data302[] = { 0xFFFF, 0xA681, 0xFFFF, 0xFFFF, 0xFFFF, 0xA683, 0xFFFF, 0xFFFF, 0xFFFF, 0xA685, 0xFFFF, 0xFFFF, 0xFFFF, 0xA687, 0xFFFF, 0xFFFF, 0xFFFF, 0xA689, 0xFFFF, 0xFFFF, 0xFFFF, 0xA68B, 0xFFFF, 0xFFFF, 0xFFFF, 0xA68D, 0xFFFF, 0xFFFF, 0xFFFF, 0xA68F, 0xFFFF, 0xFFFF };
unsigned short unac_data303[] = { 0xFFFF, 0xA691, 0xFFFF, 0xFFFF, 0xFFFF, 0xA693, 0xFFFF, 0xFFFF, 0xFFFF, 0xA695, 0xFFFF, 0xFFFF, 0xFFFF, 0xA697, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data304[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xA723, 0xFFFF, 0xFFFF, 0xFFFF, 0xA725, 0xFFFF, 0xFFFF, 0xFFFF, 0xA727, 0xFFFF, 0xFFFF, 0xFFFF, 0xA729, 0xFFFF, 0xFFFF, 0xFFFF, 0xA72B, 0xFFFF, 0xFFFF, 0xFFFF, 0xA72D, 0xFFFF, 0xFFFF, 0xFFFF, 0xA72F, 0xFFFF, 0xFFFF };
unsigned short unac_data305[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xA733, 0xFFFF, 0xFFFF, 0xFFFF, 0xA735, 0xFFFF, 0xFFFF, 0xFFFF, 0xA737, 0xFFFF, 0xFFFF, 0xFFFF, 0xA739, 0xFFFF, 0xFFFF, 0xFFFF, 0xA73B, 0xFFFF, 0xFFFF, 0xFFFF, 0xA73D, 0xFFFF, 0xFFFF, 0xFFFF, 0xA73F, 0xFFFF, 0xFFFF };
unsigned short unac_data306[] = { 0xFFFF, 0xA741, 0xFFFF, 0xFFFF, 0xFFFF, 0xA743, 0xFFFF, 0xFFFF, 0xFFFF, 0xA745, 0xFFFF, 0xFFFF, 0xFFFF, 0xA747, 0xFFFF, 0xFFFF, 0xFFFF, 0xA749, 0xFFFF, 0xFFFF, 0xFFFF, 0xA74B, 0xFFFF, 0xFFFF, 0xFFFF, 0xA74D, 0xFFFF, 0xFFFF, 0xFFFF, 0xA74F, 0xFFFF, 0xFFFF };
unsigned short unac_data307[] = { 0xFFFF, 0xA751, 0xFFFF, 0xFFFF, 0xFFFF, 0xA753, 0xFFFF, 0xFFFF, 0xFFFF, 0xA755, 0xFFFF, 0xFFFF, 0xFFFF, 0xA757, 0xFFFF, 0xFFFF, 0xFFFF, 0xA759, 0xFFFF, 0xFFFF, 0xFFFF, 0xA75B, 0xFFFF, 0xFFFF, 0xFFFF, 0xA75D, 0xFFFF, 0xFFFF, 0xFFFF, 0xA75F, 0xFFFF, 0xFFFF };
unsigned short unac_data308[] = { 0xFFFF, 0xA761, 0xFFFF, 0xFFFF, 0xFFFF, 0xA763, 0xFFFF, 0xFFFF, 0xFFFF, 0xA765, 0xFFFF, 0xFFFF, 0xFFFF, 0xA767, 0xFFFF, 0xFFFF, 0xFFFF, 0xA769, 0xFFFF, 0xFFFF, 0xFFFF, 0xA76B, 0xFFFF, 0xFFFF, 0xFFFF, 0xA76D, 0xFFFF, 0xFFFF, 0xFFFF, 0xA76F, 0xFFFF, 0xFFFF };
unsigned short unac_data309[] = { 0xA76F, 0xA76F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xA77A, 0xFFFF, 0xFFFF, 0xFFFF, 0xA77C, 0xFFFF, 0xFFFF, 0xFFFF, 0x1D79, 0xFFFF, 0xA77F, 0xFFFF, 0xFFFF };
unsigned short unac_data310[] = { 0xFFFF, 0xA781, 0xFFFF, 0xFFFF, 0xFFFF, 0xA783, 0xFFFF, 0xFFFF, 0xFFFF, 0xA785, 0xFFFF, 0xFFFF, 0xFFFF, 0xA787, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xA78C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data311[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data312[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data313[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data314[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data315[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data316[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 };
unsigned short unac_data317[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data318[] = { 0x8C48, 0x8C48, 0x66F4, 0x66F4, 0x8ECA, 0x8ECA, 0x8CC8, 0x8CC8, 0x6ED1, 0x6ED1, 0x4E32, 0x4E32, 0x53E5, 0x53E5, 0x9F9C, 0x9F9C, 0x9F9C, 0x9F9C, 0x5951, 0x5951, 0x91D1, 0x91D1, 0x5587, 0x5587, 0x5948, 0x5948, 0x61F6, 0x61F6, 0x7669, 0x7669, 0x7F85, 0x7F85 };
unsigned short unac_data319[] = { 0x863F, 0x863F, 0x87BA, 0x87BA, 0x88F8, 0x88F8, 0x908F, 0x908F, 0x6A02, 0x6A02, 0x6D1B, 0x6D1B, 0x70D9, 0x70D9, 0x73DE, 0x73DE, 0x843D, 0x843D, 0x916A, 0x916A, 0x99F1, 0x99F1, 0x4E82, 0x4E82, 0x5375, 0x5375, 0x6B04, 0x6B04, 0x721B, 0x721B, 0x862D, 0x862D };
unsigned short unac_data320[] = { 0x9E1E, 0x9E1E, 0x5D50, 0x5D50, 0x6FEB, 0x6FEB, 0x85CD, 0x85CD, 0x8964, 0x8964, 0x62C9, 0x62C9, 0x81D8, 0x81D8, 0x881F, 0x881F, 0x5ECA, 0x5ECA, 0x6717, 0x6717, 0x6D6A, 0x6D6A, 0x72FC, 0x72FC, 0x90CE, 0x90CE, 0x4F86, 0x4F86, 0x51B7, 0x51B7, 0x52DE, 0x52DE };
unsigned short unac_data321[] = { 0x64C4, 0x64C4, 0x6AD3, 0x6AD3, 0x7210, 0x7210, 0x76E7, 0x76E7, 0x8001, 0x8001, 0x8606, 0x8606, 0x865C, 0x865C, 0x8DEF, 0x8DEF, 0x9732, 0x9732, 0x9B6F, 0x9B6F, 0x9DFA, 0x9DFA, 0x788C, 0x788C, 0x797F, 0x797F, 0x7DA0, 0x7DA0, 0x83C9, 0x83C9, 0x9304, 0x9304 };
unsigned short unac_data322[] = { 0x9E7F, 0x9E7F, 0x8AD6, 0x8AD6, 0x58DF, 0x58DF, 0x5F04, 0x5F04, 0x7C60, 0x7C60, 0x807E, 0x807E, 0x7262, 0x7262, 0x78CA, 0x78CA, 0x8CC2, 0x8CC2, 0x96F7, 0x96F7, 0x58D8, 0x58D8, 0x5C62, 0x5C62, 0x6A13, 0x6A13, 0x6DDA, 0x6DDA, 0x6F0F, 0x6F0F, 0x7D2F, 0x7D2F };
unsigned short unac_data323[] = { 0x7E37, 0x7E37, 0x964B, 0x964B, 0x52D2, 0x52D2, 0x808B, 0x808B, 0x51DC, 0x51DC, 0x51CC, 0x51CC, 0x7A1C, 0x7A1C, 0x7DBE, 0x7DBE, 0x83F1, 0x83F1, 0x9675, 0x9675, 0x8B80, 0x8B80, 0x62CF, 0x62CF, 0x6A02, 0x6A02, 0x8AFE, 0x8AFE, 0x4E39, 0x4E39, 0x5BE7, 0x5BE7 };
unsigned short unac_data324[] = { 0x6012, 0x6012, 0x7387, 0x7387, 0x7570, 0x7570, 0x5317, 0x5317, 0x78FB, 0x78FB, 0x4FBF, 0x4FBF, 0x5FA9, 0x5FA9, 0x4E0D, 0x4E0D, 0x6CCC, 0x6CCC, 0x6578, 0x6578, 0x7D22, 0x7D22, 0x53C3, 0x53C3, 0x585E, 0x585E, 0x7701, 0x7701, 0x8449, 0x8449, 0x8AAA, 0x8AAA };
unsigned short unac_data325[] = { 0x6BBA, 0x6BBA, 0x8FB0, 0x8FB0, 0x6C88, 0x6C88, 0x62FE, 0x62FE, 0x82E5, 0x82E5, 0x63A0, 0x63A0, 0x7565, 0x7565, 0x4EAE, 0x4EAE, 0x5169, 0x5169, 0x51C9, 0x51C9, 0x6881, 0x6881, 0x7CE7, 0x7CE7, 0x826F, 0x826F, 0x8AD2, 0x8AD2, 0x91CF, 0x91CF, 0x52F5, 0x52F5 };
unsigned short unac_data326[] = { 0x5442, 0x5442, 0x5973, 0x5973, 0x5EEC, 0x5EEC, 0x65C5, 0x65C5, 0x6FFE, 0x6FFE, 0x792A, 0x792A, 0x95AD, 0x95AD, 0x9A6A, 0x9A6A, 0x9E97, 0x9E97, 0x9ECE, 0x9ECE, 0x529B, 0x529B, 0x66C6, 0x66C6, 0x6B77, 0x6B77, 0x8F62, 0x8F62, 0x5E74, 0x5E74, 0x6190, 0x6190 };
unsigned short unac_data327[] = { 0x6200, 0x6200, 0x649A, 0x649A, 0x6F23, 0x6F23, 0x7149, 0x7149, 0x7489, 0x7489, 0x79CA, 0x79CA, 0x7DF4, 0x7DF4, 0x806F, 0x806F, 0x8F26, 0x8F26, 0x84EE, 0x84EE, 0x9023, 0x9023, 0x934A, 0x934A, 0x5217, 0x5217, 0x52A3, 0x52A3, 0x54BD, 0x54BD, 0x70C8, 0x70C8 };
unsigned short unac_data328[] = { 0x88C2, 0x88C2, 0x8AAA, 0x8AAA, 0x5EC9, 0x5EC9, 0x5FF5, 0x5FF5, 0x637B, 0x637B, 0x6BAE, 0x6BAE, 0x7C3E, 0x7C3E, 0x7375, 0x7375, 0x4EE4, 0x4EE4, 0x56F9, 0x56F9, 0x5BE7, 0x5BE7, 0x5DBA, 0x5DBA, 0x601C, 0x601C, 0x73B2, 0x73B2, 0x7469, 0x7469, 0x7F9A, 0x7F9A };
unsigned short unac_data329[] = { 0x8046, 0x8046, 0x9234, 0x9234, 0x96F6, 0x96F6, 0x9748, 0x9748, 0x9818, 0x9818, 0x4F8B, 0x4F8B, 0x79AE, 0x79AE, 0x91B4, 0x91B4, 0x96B8, 0x96B8, 0x60E1, 0x60E1, 0x4E86, 0x4E86, 0x50DA, 0x50DA, 0x5BEE, 0x5BEE, 0x5C3F, 0x5C3F, 0x6599, 0x6599, 0x6A02, 0x6A02 };
unsigned short unac_data330[] = { 0x71CE, 0x71CE, 0x7642, 0x7642, 0x84FC, 0x84FC, 0x907C, 0x907C, 0x9F8D, 0x9F8D, 0x6688, 0x6688, 0x962E, 0x962E, 0x5289, 0x5289, 0x677B, 0x677B, 0x67F3, 0x67F3, 0x6D41, 0x6D41, 0x6E9C, 0x6E9C, 0x7409, 0x7409, 0x7559, 0x7559, 0x786B, 0x786B, 0x7D10, 0x7D10 };
unsigned short unac_data331[] = { 0x985E, 0x985E, 0x516D, 0x516D, 0x622E, 0x622E, 0x9678, 0x9678, 0x502B, 0x502B, 0x5D19, 0x5D19, 0x6DEA, 0x6DEA, 0x8F2A, 0x8F2A, 0x5F8B, 0x5F8B, 0x6144, 0x6144, 0x6817, 0x6817, 0x7387, 0x7387, 0x9686, 0x9686, 0x5229, 0x5229, 0x540F, 0x540F, 0x5C65, 0x5C65 };
unsigned short unac_data332[] = { 0x6613, 0x6613, 0x674E, 0x674E, 0x68A8, 0x68A8, 0x6CE5, 0x6CE5, 0x7406, 0x7406, 0x75E2, 0x75E2, 0x7F79, 0x7F79, 0x88CF, 0x88CF, 0x88E1, 0x88E1, 0x91CC, 0x91CC, 0x96E2, 0x96E2, 0x533F, 0x533F, 0x6EBA, 0x6EBA, 0x541D, 0x541D, 0x71D0, 0x71D0, 0x7498, 0x7498 };
unsigned short unac_data333[] = { 0x85FA, 0x85FA, 0x96A3, 0x96A3, 0x9C57, 0x9C57, 0x9E9F, 0x9E9F, 0x6797, 0x6797, 0x6DCB, 0x6DCB, 0x81E8, 0x81E8, 0x7ACB, 0x7ACB, 0x7B20, 0x7B20, 0x7C92, 0x7C92, 0x72C0, 0x72C0, 0x7099, 0x7099, 0x8B58, 0x8B58, 0x4EC0, 0x4EC0, 0x8336, 0x8336, 0x523A, 0x523A };
unsigned short unac_data334[] = { 0x5207, 0x5207, 0x5EA6, 0x5EA6, 0x62D3, 0x62D3, 0x7CD6, 0x7CD6, 0x5B85, 0x5B85, 0x6D1E, 0x6D1E, 0x66B4, 0x66B4, 0x8F3B, 0x8F3B, 0x884C, 0x884C, 0x964D, 0x964D, 0x898B, 0x898B, 0x5ED3, 0x5ED3, 0x5140, 0x5140, 0x55C0, 0x55C0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data335[] = { 0x585A, 0x585A, 0xFFFF, 0xFFFF, 0x6674, 0x6674, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x51DE, 0x51DE, 0x732A, 0x732A, 0x76CA, 0x76CA, 0x793C, 0x793C, 0x795E, 0x795E, 0x7965, 0x7965, 0x798F, 0x798F, 0x9756, 0x9756, 0x7CBE, 0x7CBE, 0x7FBD, 0x7FBD, 0xFFFF, 0xFFFF };
unsigned short unac_data336[] = { 0x8612, 0x8612, 0xFFFF, 0xFFFF, 0x8AF8, 0x8AF8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x9038, 0x9038, 0x90FD, 0x90FD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x98EF, 0x98EF, 0x98FC, 0x98FC, 0x9928, 0x9928, 0x9DB4, 0x9DB4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data337[] = { 0x4FAE, 0x4FAE, 0x50E7, 0x50E7, 0x514D, 0x514D, 0x52C9, 0x52C9, 0x52E4, 0x52E4, 0x5351, 0x5351, 0x559D, 0x559D, 0x5606, 0x5606, 0x5668, 0x5668, 0x5840, 0x5840, 0x58A8, 0x58A8, 0x5C64, 0x5C64, 0x5C6E, 0x5C6E, 0x6094, 0x6094, 0x6168, 0x6168, 0x618E, 0x618E };
unsigned short unac_data338[] = { 0x61F2, 0x61F2, 0x654F, 0x654F, 0x65E2, 0x65E2, 0x6691, 0x6691, 0x6885, 0x6885, 0x6D77, 0x6D77, 0x6E1A, 0x6E1A, 0x6F22, 0x6F22, 0x716E, 0x716E, 0x722B, 0x722B, 0x7422, 0x7422, 0x7891, 0x7891, 0x793E, 0x793E, 0x7949, 0x7949, 0x7948, 0x7948, 0x7950, 0x7950 };
unsigned short unac_data339[] = { 0x7956, 0x7956, 0x795D, 0x795D, 0x798D, 0x798D, 0x798E, 0x798E, 0x7A40, 0x7A40, 0x7A81, 0x7A81, 0x7BC0, 0x7BC0, 0x7DF4, 0x7DF4, 0x7E09, 0x7E09, 0x7E41, 0x7E41, 0x7F72, 0x7F72, 0x8005, 0x8005, 0x81ED, 0x81ED, 0x8279, 0x8279, 0x8279, 0x8279, 0x8457, 0x8457 };
unsigned short unac_data340[] = { 0x8910, 0x8910, 0x8996, 0x8996, 0x8B01, 0x8B01, 0x8B39, 0x8B39, 0x8CD3, 0x8CD3, 0x8D08, 0x8D08, 0x8FB6, 0x8FB6, 0x9038, 0x9038, 0x96E3, 0x96E3, 0x97FF, 0x97FF, 0x983B, 0x983B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data341[] = { 0x4E26, 0x4E26, 0x51B5, 0x51B5, 0x5168, 0x5168, 0x4F80, 0x4F80, 0x5145, 0x5145, 0x5180, 0x5180, 0x52C7, 0x52C7, 0x52FA, 0x52FA, 0x559D, 0x559D, 0x5555, 0x5555, 0x5599, 0x5599, 0x55E2, 0x55E2, 0x585A, 0x585A, 0x58B3, 0x58B3, 0x5944, 0x5944, 0x5954, 0x5954 };
unsigned short unac_data342[] = { 0x5A62, 0x5A62, 0x5B28, 0x5B28, 0x5ED2, 0x5ED2, 0x5ED9, 0x5ED9, 0x5F69, 0x5F69, 0x5FAD, 0x5FAD, 0x60D8, 0x60D8, 0x614E, 0x614E, 0x6108, 0x6108, 0x618E, 0x618E, 0x6160, 0x6160, 0x61F2, 0x61F2, 0x6234, 0x6234, 0x63C4, 0x63C4, 0x641C, 0x641C, 0x6452, 0x6452 };
unsigned short unac_data343[] = { 0x6556, 0x6556, 0x6674, 0x6674, 0x6717, 0x6717, 0x671B, 0x671B, 0x6756, 0x6756, 0x6B79, 0x6B79, 0x6BBA, 0x6BBA, 0x6D41, 0x6D41, 0x6EDB, 0x6EDB, 0x6ECB, 0x6ECB, 0x6F22, 0x6F22, 0x701E, 0x701E, 0x716E, 0x716E, 0x77A7, 0x77A7, 0x7235, 0x7235, 0x72AF, 0x72AF };
unsigned short unac_data344[] = { 0x732A, 0x732A, 0x7471, 0x7471, 0x7506, 0x7506, 0x753B, 0x753B, 0x761D, 0x761D, 0x761F, 0x761F, 0x76CA, 0x76CA, 0x76DB, 0x76DB, 0x76F4, 0x76F4, 0x774A, 0x774A, 0x7740, 0x7740, 0x78CC, 0x78CC, 0x7AB1, 0x7AB1, 0x7BC0, 0x7BC0, 0x7C7B, 0x7C7B, 0x7D5B, 0x7D5B };
unsigned short unac_data345[] = { 0x7DF4, 0x7DF4, 0x7F3E, 0x7F3E, 0x8005, 0x8005, 0x8352, 0x8352, 0x83EF, 0x83EF, 0x8779, 0x8779, 0x8941, 0x8941, 0x8986, 0x8986, 0x8996, 0x8996, 0x8ABF, 0x8ABF, 0x8AF8, 0x8AF8, 0x8ACB, 0x8ACB, 0x8B01, 0x8B01, 0x8AFE, 0x8AFE, 0x8AED, 0x8AED, 0x8B39, 0x8B39 };
unsigned short unac_data346[] = { 0x8B8A, 0x8B8A, 0x8D08, 0x8D08, 0x8F38, 0x8F38, 0x9072, 0x9072, 0x9199, 0x9199, 0x9276, 0x9276, 0x967C, 0x967C, 0x96E3, 0x96E3, 0x9756, 0x9756, 0x97DB, 0x97DB, 0x97FF, 0x97FF, 0x980B, 0x980B, 0x983B, 0x983B, 0x9B12, 0x9B12, 0x9F9C, 0x9F9C, 0xFFFF, 0xFFFF };
unsigned short unac_data347[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x3B9D, 0x3B9D, 0x4018, 0x4018, 0x4039, 0x4039, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x9F43, 0x9F43, 0x9F8E, 0x9F8E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data348[] = { 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0069, 0x0066, 0x0069, 0x0066, 0x006C, 0x0066, 0x006C, 0x0066, 0x0066, 0x0069, 0x0066, 0x0066, 0x0069, 0x0066, 0x0066, 0x006C, 0x0066, 0x0066, 0x006C, 0x0074, 0x0073, 0x0074, 0x0073, 0x0073, 0x0074, 0x0073, 0x0074, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data349[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0574, 0x0576, 0x0574, 0x0576, 0x0574, 0x0565, 0x0574, 0x0565, 0x0574, 0x056B, 0x0574, 0x056B, 0x057E, 0x0576, 0x057E, 0x0576, 0x0574, 0x056D, 0x0574, 0x056D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x05D9, 0x05D9, 0x0000, 0x0000, 0x05F2, 0x05F2 };
unsigned short unac_data350[] = { 0x05E2, 0x05E2, 0x05D0, 0x05D0, 0x05D3, 0x05D3, 0x05D4, 0x05D4, 0x05DB, 0x05DB, 0x05DC, 0x05DC, 0x05DD, 0x05DD, 0x05E8, 0x05E8, 0x05EA, 0x05EA, 0x002B, 0x002B, 0x05E9, 0x05E9, 0x05E9, 0x05E9, 0x05E9, 0x05E9, 0x05E9, 0x05E9, 0x05D0, 0x05D0, 0x05D0, 0x05D0 };
unsigned short unac_data351[] = { 0x05D0, 0x05D0, 0x05D1, 0x05D1, 0x05D2, 0x05D2, 0x05D3, 0x05D3, 0x05D4, 0x05D4, 0x05D5, 0x05D5, 0x05D6, 0x05D6, 0xFFFF, 0xFFFF, 0x05D8, 0x05D8, 0x05D9, 0x05D9, 0x05DA, 0x05DA, 0x05DB, 0x05DB, 0x05DC, 0x05DC, 0xFFFF, 0xFFFF, 0x05DE, 0x05DE, 0xFFFF, 0xFFFF };
unsigned short unac_data352[] = { 0x05E0, 0x05E0, 0x05E1, 0x05E1, 0xFFFF, 0xFFFF, 0x05E3, 0x05E3, 0x05E4, 0x05E4, 0xFFFF, 0xFFFF, 0x05E6, 0x05E6, 0x05E7, 0x05E7, 0x05E8, 0x05E8, 0x05E9, 0x05E9, 0x05EA, 0x05EA, 0x05D5, 0x05D5, 0x05D1, 0x05D1, 0x05DB, 0x05DB, 0x05E4, 0x05E4, 0x05D0, 0x05DC, 0x05D0, 0x05DC };
unsigned short unac_data353[] = { 0x0671, 0x0671, 0x0671, 0x0671, 0x067B, 0x067B, 0x067B, 0x067B, 0x067B, 0x067B, 0x067B, 0x067B, 0x067E, 0x067E, 0x067E, 0x067E, 0x067E, 0x067E, 0x067E, 0x067E, 0x0680, 0x0680, 0x0680, 0x0680, 0x0680, 0x0680, 0x0680, 0x0680, 0x067A, 0x067A, 0x067A, 0x067A };
unsigned short unac_data354[] = { 0x067A, 0x067A, 0x067A, 0x067A, 0x067F, 0x067F, 0x067F, 0x067F, 0x067F, 0x067F, 0x067F, 0x067F, 0x0679, 0x0679, 0x0679, 0x0679, 0x0679, 0x0679, 0x0679, 0x0679, 0x06A4, 0x06A4, 0x06A4, 0x06A4, 0x06A4, 0x06A4, 0x06A4, 0x06A4, 0x06A6, 0x06A6, 0x06A6, 0x06A6 };
unsigned short unac_data355[] = { 0x06A6, 0x06A6, 0x06A6, 0x06A6, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0683, 0x0683, 0x0683, 0x0683, 0x0683, 0x0683, 0x0683, 0x0683, 0x0686, 0x0686, 0x0686, 0x0686, 0x0686, 0x0686, 0x0686, 0x0686, 0x0687, 0x0687, 0x0687, 0x0687 };
unsigned short unac_data356[] = { 0x0687, 0x0687, 0x0687, 0x0687, 0x068D, 0x068D, 0x068D, 0x068D, 0x068C, 0x068C, 0x068C, 0x068C, 0x068E, 0x068E, 0x068E, 0x068E, 0x0688, 0x0688, 0x0688, 0x0688, 0x0698, 0x0698, 0x0698, 0x0698, 0x0691, 0x0691, 0x0691, 0x0691, 0x06A9, 0x06A9, 0x06A9, 0x06A9 };
unsigned short unac_data357[] = { 0x06A9, 0x06A9, 0x06A9, 0x06A9, 0x06AF, 0x06AF, 0x06AF, 0x06AF, 0x06AF, 0x06AF, 0x06AF, 0x06AF, 0x06B3, 0x06B3, 0x06B3, 0x06B3, 0x06B3, 0x06B3, 0x06B3, 0x06B3, 0x06B1, 0x06B1, 0x06B1, 0x06B1, 0x06B1, 0x06B1, 0x06B1, 0x06B1, 0x06BA, 0x06BA, 0x06BA, 0x06BA };
unsigned short unac_data358[] = { 0x06BB, 0x06BB, 0x06BB, 0x06BB, 0x06BB, 0x06BB, 0x06BB, 0x06BB, 0x06D5, 0x06D5, 0x06D5, 0x06D5, 0x06C1, 0x06C1, 0x06C1, 0x06C1, 0x06C1, 0x06C1, 0x06C1, 0x06C1, 0x06BE, 0x06BE, 0x06BE, 0x06BE, 0x06BE, 0x06BE, 0x06BE, 0x06BE, 0x06D2, 0x06D2, 0x06D2, 0x06D2 };
unsigned short unac_data359[] = { 0x06D2, 0x06D2, 0x06D2, 0x06D2, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data360[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x06AD, 0x06AD, 0x06AD, 0x06AD, 0x06AD, 0x06AD, 0x06AD, 0x06AD, 0x06C7, 0x06C7, 0x06C7, 0x06C7, 0x06C6, 0x06C6, 0x06C6, 0x06C6, 0x06C8, 0x06C8, 0x06C8, 0x06C8, 0x06C7, 0x0674, 0x06C7, 0x0674, 0x06CB, 0x06CB, 0x06CB, 0x06CB };
unsigned short unac_data361[] = { 0x06C5, 0x06C5, 0x06C5, 0x06C5, 0x06C9, 0x06C9, 0x06C9, 0x06C9, 0x06D0, 0x06D0, 0x06D0, 0x06D0, 0x06D0, 0x06D0, 0x06D0, 0x06D0, 0x0649, 0x0649, 0x0649, 0x0649, 0x0627, 0x064A, 0x0627, 0x064A, 0x0627, 0x064A, 0x0627, 0x064A, 0x06D5, 0x064A, 0x06D5, 0x064A, 0x06D5, 0x064A, 0x06D5, 0x064A, 0x0648, 0x064A, 0x0648, 0x064A, 0x0648, 0x064A, 0x0648, 0x064A };
unsigned short unac_data362[] = { 0x06C7, 0x064A, 0x06C7, 0x064A, 0x06C7, 0x064A, 0x06C7, 0x064A, 0x06C6, 0x064A, 0x06C6, 0x064A, 0x06C6, 0x064A, 0x06C6, 0x064A, 0x06C8, 0x064A, 0x06C8, 0x064A, 0x06C8, 0x064A, 0x06C8, 0x064A, 0x06D0, 0x064A, 0x06D0, 0x064A, 0x06D0, 0x064A, 0x06D0, 0x064A, 0x06D0, 0x064A, 0x06D0, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x06CC, 0x06CC, 0x06CC, 0x06CC, 0x06CC, 0x06CC, 0x06CC, 0x06CC };
unsigned short unac_data363[] = { 0x062C, 0x064A, 0x062C, 0x064A, 0x062D, 0x064A, 0x062D, 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x0628, 0x062C, 0x0628, 0x062C, 0x0628, 0x062D, 0x0628, 0x062D, 0x0628, 0x062E, 0x0628, 0x062E, 0x0628, 0x0645, 0x0628, 0x0645, 0x0628, 0x0649, 0x0628, 0x0649, 0x0628, 0x064A, 0x0628, 0x064A, 0x062A, 0x062C, 0x062A, 0x062C, 0x062A, 0x062D, 0x062A, 0x062D, 0x062A, 0x062E, 0x062A, 0x062E, 0x062A, 0x0645, 0x062A, 0x0645, 0x062A, 0x0649, 0x062A, 0x0649 };
unsigned short unac_data364[] = { 0x062A, 0x064A, 0x062A, 0x064A, 0x062B, 0x062C, 0x062B, 0x062C, 0x062B, 0x0645, 0x062B, 0x0645, 0x062B, 0x0649, 0x062B, 0x0649, 0x062B, 0x064A, 0x062B, 0x064A, 0x062C, 0x062D, 0x062C, 0x062D, 0x062C, 0x0645, 0x062C, 0x0645, 0x062D, 0x062C, 0x062D, 0x062C, 0x062D, 0x0645, 0x062D, 0x0645, 0x062E, 0x062C, 0x062E, 0x062C, 0x062E, 0x062D, 0x062E, 0x062D, 0x062E, 0x0645, 0x062E, 0x0645, 0x0633, 0x062C, 0x0633, 0x062C, 0x0633, 0x062D, 0x0633, 0x062D, 0x0633, 0x062E, 0x0633, 0x062E, 0x0633, 0x0645, 0x0633, 0x0645 };
unsigned short unac_data365[] = { 0x0635, 0x062D, 0x0635, 0x062D, 0x0635, 0x0645, 0x0635, 0x0645, 0x0636, 0x062C, 0x0636, 0x062C, 0x0636, 0x062D, 0x0636, 0x062D, 0x0636, 0x062E, 0x0636, 0x062E, 0x0636, 0x0645, 0x0636, 0x0645, 0x0637, 0x062D, 0x0637, 0x062D, 0x0637, 0x0645, 0x0637, 0x0645, 0x0638, 0x0645, 0x0638, 0x0645, 0x0639, 0x062C, 0x0639, 0x062C, 0x0639, 0x0645, 0x0639, 0x0645, 0x063A, 0x062C, 0x063A, 0x062C, 0x063A, 0x0645, 0x063A, 0x0645, 0x0641, 0x062C, 0x0641, 0x062C, 0x0641, 0x062D, 0x0641, 0x062D, 0x0641, 0x062E, 0x0641, 0x062E };
unsigned short unac_data366[] = { 0x0641, 0x0645, 0x0641, 0x0645, 0x0641, 0x0649, 0x0641, 0x0649, 0x0641, 0x064A, 0x0641, 0x064A, 0x0642, 0x062D, 0x0642, 0x062D, 0x0642, 0x0645, 0x0642, 0x0645, 0x0642, 0x0649, 0x0642, 0x0649, 0x0642, 0x064A, 0x0642, 0x064A, 0x0643, 0x0627, 0x0643, 0x0627, 0x0643, 0x062C, 0x0643, 0x062C, 0x0643, 0x062D, 0x0643, 0x062D, 0x0643, 0x062E, 0x0643, 0x062E, 0x0643, 0x0644, 0x0643, 0x0644, 0x0643, 0x0645, 0x0643, 0x0645, 0x0643, 0x0649, 0x0643, 0x0649, 0x0643, 0x064A, 0x0643, 0x064A, 0x0644, 0x062C, 0x0644, 0x062C };
unsigned short unac_data367[] = { 0x0644, 0x062D, 0x0644, 0x062D, 0x0644, 0x062E, 0x0644, 0x062E, 0x0644, 0x0645, 0x0644, 0x0645, 0x0644, 0x0649, 0x0644, 0x0649, 0x0644, 0x064A, 0x0644, 0x064A, 0x0645, 0x062C, 0x0645, 0x062C, 0x0645, 0x062D, 0x0645, 0x062D, 0x0645, 0x062E, 0x0645, 0x062E, 0x0645, 0x0645, 0x0645, 0x0645, 0x0645, 0x0649, 0x0645, 0x0649, 0x0645, 0x064A, 0x0645, 0x064A, 0x0646, 0x062C, 0x0646, 0x062C, 0x0646, 0x062D, 0x0646, 0x062D, 0x0646, 0x062E, 0x0646, 0x062E, 0x0646, 0x0645, 0x0646, 0x0645, 0x0646, 0x0649, 0x0646, 0x0649 };
unsigned short unac_data368[] = { 0x0646, 0x064A, 0x0646, 0x064A, 0x0647, 0x062C, 0x0647, 0x062C, 0x0647, 0x0645, 0x0647, 0x0645, 0x0647, 0x0649, 0x0647, 0x0649, 0x0647, 0x064A, 0x0647, 0x064A, 0x064A, 0x062C, 0x064A, 0x062C, 0x064A, 0x062D, 0x064A, 0x062D, 0x064A, 0x062E, 0x064A, 0x062E, 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x064A, 0x064A, 0x064A, 0x0630, 0x0630, 0x0631, 0x0631, 0x0649, 0x0649, 0x0020, 0x0020, 0x0020, 0x0020 };
unsigned short unac_data369[] = { 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0631, 0x064A, 0x0631, 0x064A, 0x0632, 0x064A, 0x0632, 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0646, 0x064A, 0x0646, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x0628, 0x0631, 0x0628, 0x0631, 0x0628, 0x0632, 0x0628, 0x0632, 0x0628, 0x0645, 0x0628, 0x0645, 0x0628, 0x0646, 0x0628, 0x0646, 0x0628, 0x0649, 0x0628, 0x0649, 0x0628, 0x064A, 0x0628, 0x064A };
unsigned short unac_data370[] = { 0x062A, 0x0631, 0x062A, 0x0631, 0x062A, 0x0632, 0x062A, 0x0632, 0x062A, 0x0645, 0x062A, 0x0645, 0x062A, 0x0646, 0x062A, 0x0646, 0x062A, 0x0649, 0x062A, 0x0649, 0x062A, 0x064A, 0x062A, 0x064A, 0x062B, 0x0631, 0x062B, 0x0631, 0x062B, 0x0632, 0x062B, 0x0632, 0x062B, 0x0645, 0x062B, 0x0645, 0x062B, 0x0646, 0x062B, 0x0646, 0x062B, 0x0649, 0x062B, 0x0649, 0x062B, 0x064A, 0x062B, 0x064A, 0x0641, 0x0649, 0x0641, 0x0649, 0x0641, 0x064A, 0x0641, 0x064A, 0x0642, 0x0649, 0x0642, 0x0649, 0x0642, 0x064A, 0x0642, 0x064A };
unsigned short unac_data371[] = { 0x0643, 0x0627, 0x0643, 0x0627, 0x0643, 0x0644, 0x0643, 0x0644, 0x0643, 0x0645, 0x0643, 0x0645, 0x0643, 0x0649, 0x0643, 0x0649, 0x0643, 0x064A, 0x0643, 0x064A, 0x0644, 0x0645, 0x0644, 0x0645, 0x0644, 0x0649, 0x0644, 0x0649, 0x0644, 0x064A, 0x0644, 0x064A, 0x0645, 0x0627, 0x0645, 0x0627, 0x0645, 0x0645, 0x0645, 0x0645, 0x0646, 0x0631, 0x0646, 0x0631, 0x0646, 0x0632, 0x0646, 0x0632, 0x0646, 0x0645, 0x0646, 0x0645, 0x0646, 0x0646, 0x0646, 0x0646, 0x0646, 0x0649, 0x0646, 0x0649, 0x0646, 0x064A, 0x0646, 0x064A };
unsigned short unac_data372[] = { 0x0649, 0x0649, 0x064A, 0x0631, 0x064A, 0x0631, 0x064A, 0x0632, 0x064A, 0x0632, 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0646, 0x064A, 0x0646, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x064A, 0x064A, 0x064A, 0x062C, 0x064A, 0x062C, 0x064A, 0x062D, 0x064A, 0x062D, 0x064A, 0x062E, 0x064A, 0x062E, 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0647, 0x064A, 0x0647, 0x064A, 0x0628, 0x062C, 0x0628, 0x062C, 0x0628, 0x062D, 0x0628, 0x062D, 0x0628, 0x062E, 0x0628, 0x062E, 0x0628, 0x0645, 0x0628, 0x0645 };
unsigned short unac_data373[] = { 0x0628, 0x0647, 0x0628, 0x0647, 0x062A, 0x062C, 0x062A, 0x062C, 0x062A, 0x062D, 0x062A, 0x062D, 0x062A, 0x062E, 0x062A, 0x062E, 0x062A, 0x0645, 0x062A, 0x0645, 0x062A, 0x0647, 0x062A, 0x0647, 0x062B, 0x0645, 0x062B, 0x0645, 0x062C, 0x062D, 0x062C, 0x062D, 0x062C, 0x0645, 0x062C, 0x0645, 0x062D, 0x062C, 0x062D, 0x062C, 0x062D, 0x0645, 0x062D, 0x0645, 0x062E, 0x062C, 0x062E, 0x062C, 0x062E, 0x0645, 0x062E, 0x0645, 0x0633, 0x062C, 0x0633, 0x062C, 0x0633, 0x062D, 0x0633, 0x062D, 0x0633, 0x062E, 0x0633, 0x062E };
unsigned short unac_data374[] = { 0x0633, 0x0645, 0x0633, 0x0645, 0x0635, 0x062D, 0x0635, 0x062D, 0x0635, 0x062E, 0x0635, 0x062E, 0x0635, 0x0645, 0x0635, 0x0645, 0x0636, 0x062C, 0x0636, 0x062C, 0x0636, 0x062D, 0x0636, 0x062D, 0x0636, 0x062E, 0x0636, 0x062E, 0x0636, 0x0645, 0x0636, 0x0645, 0x0637, 0x062D, 0x0637, 0x062D, 0x0638, 0x0645, 0x0638, 0x0645, 0x0639, 0x062C, 0x0639, 0x062C, 0x0639, 0x0645, 0x0639, 0x0645, 0x063A, 0x062C, 0x063A, 0x062C, 0x063A, 0x0645, 0x063A, 0x0645, 0x0641, 0x062C, 0x0641, 0x062C, 0x0641, 0x062D, 0x0641, 0x062D };
unsigned short unac_data375[] = { 0x0641, 0x062E, 0x0641, 0x062E, 0x0641, 0x0645, 0x0641, 0x0645, 0x0642, 0x062D, 0x0642, 0x062D, 0x0642, 0x0645, 0x0642, 0x0645, 0x0643, 0x062C, 0x0643, 0x062C, 0x0643, 0x062D, 0x0643, 0x062D, 0x0643, 0x062E, 0x0643, 0x062E, 0x0643, 0x0644, 0x0643, 0x0644, 0x0643, 0x0645, 0x0643, 0x0645, 0x0644, 0x062C, 0x0644, 0x062C, 0x0644, 0x062D, 0x0644, 0x062D, 0x0644, 0x062E, 0x0644, 0x062E, 0x0644, 0x0645, 0x0644, 0x0645, 0x0644, 0x0647, 0x0644, 0x0647, 0x0645, 0x062C, 0x0645, 0x062C, 0x0645, 0x062D, 0x0645, 0x062D };
unsigned short unac_data376[] = { 0x0645, 0x062E, 0x0645, 0x062E, 0x0645, 0x0645, 0x0645, 0x0645, 0x0646, 0x062C, 0x0646, 0x062C, 0x0646, 0x062D, 0x0646, 0x062D, 0x0646, 0x062E, 0x0646, 0x062E, 0x0646, 0x0645, 0x0646, 0x0645, 0x0646, 0x0647, 0x0646, 0x0647, 0x0647, 0x062C, 0x0647, 0x062C, 0x0647, 0x0645, 0x0647, 0x0645, 0x0647, 0x0647, 0x064A, 0x062C, 0x064A, 0x062C, 0x064A, 0x062D, 0x064A, 0x062D, 0x064A, 0x062E, 0x064A, 0x062E, 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0647, 0x064A, 0x0647, 0x0645, 0x064A, 0x0645, 0x064A };
unsigned short unac_data377[] = { 0x0647, 0x064A, 0x0647, 0x064A, 0x0628, 0x0645, 0x0628, 0x0645, 0x0628, 0x0647, 0x0628, 0x0647, 0x062A, 0x0645, 0x062A, 0x0645, 0x062A, 0x0647, 0x062A, 0x0647, 0x062B, 0x0645, 0x062B, 0x0645, 0x062B, 0x0647, 0x062B, 0x0647, 0x0633, 0x0645, 0x0633, 0x0645, 0x0633, 0x0647, 0x0633, 0x0647, 0x0634, 0x0645, 0x0634, 0x0645, 0x0634, 0x0647, 0x0634, 0x0647, 0x0643, 0x0644, 0x0643, 0x0644, 0x0643, 0x0645, 0x0643, 0x0645, 0x0644, 0x0645, 0x0644, 0x0645, 0x0646, 0x0645, 0x0646, 0x0645, 0x0646, 0x0647, 0x0646, 0x0647 };
unsigned short unac_data378[] = { 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0647, 0x064A, 0x0647, 0x0640, 0x0640, 0x0640, 0x0640, 0x0640, 0x0640, 0x0637, 0x0649, 0x0637, 0x0649, 0x0637, 0x064A, 0x0637, 0x064A, 0x0639, 0x0649, 0x0639, 0x0649, 0x0639, 0x064A, 0x0639, 0x064A, 0x063A, 0x0649, 0x063A, 0x0649, 0x063A, 0x064A, 0x063A, 0x064A, 0x0633, 0x0649, 0x0633, 0x0649, 0x0633, 0x064A, 0x0633, 0x064A, 0x0634, 0x0649, 0x0634, 0x0649, 0x0634, 0x064A, 0x0634, 0x064A, 0x062D, 0x0649, 0x062D, 0x0649 };
unsigned short unac_data379[] = { 0x062D, 0x064A, 0x062D, 0x064A, 0x062C, 0x0649, 0x062C, 0x0649, 0x062C, 0x064A, 0x062C, 0x064A, 0x062E, 0x0649, 0x062E, 0x0649, 0x062E, 0x064A, 0x062E, 0x064A, 0x0635, 0x0649, 0x0635, 0x0649, 0x0635, 0x064A, 0x0635, 0x064A, 0x0636, 0x0649, 0x0636, 0x0649, 0x0636, 0x064A, 0x0636, 0x064A, 0x0634, 0x062C, 0x0634, 0x062C, 0x0634, 0x062D, 0x0634, 0x062D, 0x0634, 0x062E, 0x0634, 0x062E, 0x0634, 0x0645, 0x0634, 0x0645, 0x0634, 0x0631, 0x0634, 0x0631, 0x0633, 0x0631, 0x0633, 0x0631, 0x0635, 0x0631, 0x0635, 0x0631 };
unsigned short unac_data380[] = { 0x0636, 0x0631, 0x0636, 0x0631, 0x0637, 0x0649, 0x0637, 0x0649, 0x0637, 0x064A, 0x0637, 0x064A, 0x0639, 0x0649, 0x0639, 0x0649, 0x0639, 0x064A, 0x0639, 0x064A, 0x063A, 0x0649, 0x063A, 0x0649, 0x063A, 0x064A, 0x063A, 0x064A, 0x0633, 0x0649, 0x0633, 0x0649, 0x0633, 0x064A, 0x0633, 0x064A, 0x0634, 0x0649, 0x0634, 0x0649, 0x0634, 0x064A, 0x0634, 0x064A, 0x062D, 0x0649, 0x062D, 0x0649, 0x062D, 0x064A, 0x062D, 0x064A, 0x062C, 0x0649, 0x062C, 0x0649, 0x062C, 0x064A, 0x062C, 0x064A, 0x062E, 0x0649, 0x062E, 0x0649 };
unsigned short unac_data381[] = { 0x062E, 0x064A, 0x062E, 0x064A, 0x0635, 0x0649, 0x0635, 0x0649, 0x0635, 0x064A, 0x0635, 0x064A, 0x0636, 0x0649, 0x0636, 0x0649, 0x0636, 0x064A, 0x0636, 0x064A, 0x0634, 0x062C, 0x0634, 0x062C, 0x0634, 0x062D, 0x0634, 0x062D, 0x0634, 0x062E, 0x0634, 0x062E, 0x0634, 0x0645, 0x0634, 0x0645, 0x0634, 0x0631, 0x0634, 0x0631, 0x0633, 0x0631, 0x0633, 0x0631, 0x0635, 0x0631, 0x0635, 0x0631, 0x0636, 0x0631, 0x0636, 0x0631, 0x0634, 0x062C, 0x0634, 0x062C, 0x0634, 0x062D, 0x0634, 0x062D, 0x0634, 0x062E, 0x0634, 0x062E };
unsigned short unac_data382[] = { 0x0634, 0x0645, 0x0634, 0x0645, 0x0633, 0x0647, 0x0633, 0x0647, 0x0634, 0x0647, 0x0634, 0x0647, 0x0637, 0x0645, 0x0637, 0x0645, 0x0633, 0x062C, 0x0633, 0x062C, 0x0633, 0x062D, 0x0633, 0x062D, 0x0633, 0x062E, 0x0633, 0x062E, 0x0634, 0x062C, 0x0634, 0x062C, 0x0634, 0x062D, 0x0634, 0x062D, 0x0634, 0x062E, 0x0634, 0x062E, 0x0637, 0x0645, 0x0637, 0x0645, 0x0638, 0x0645, 0x0638, 0x0645, 0x0627, 0x0627, 0x0627, 0x0627, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data383[] = { 0x062A, 0x062C, 0x0645, 0x062A, 0x062C, 0x0645, 0x062A, 0x062D, 0x062C, 0x062A, 0x062D, 0x062C, 0x062A, 0x062D, 0x062C, 0x062A, 0x062D, 0x062C, 0x062A, 0x062D, 0x0645, 0x062A, 0x062D, 0x0645, 0x062A, 0x062E, 0x0645, 0x062A, 0x062E, 0x0645, 0x062A, 0x0645, 0x062C, 0x062A, 0x0645, 0x062C, 0x062A, 0x0645, 0x062D, 0x062A, 0x0645, 0x062D, 0x062A, 0x0645, 0x062E, 0x062A, 0x0645, 0x062E, 0x062C, 0x0645, 0x062D, 0x062C, 0x0645, 0x062D, 0x062C, 0x0645, 0x062D, 0x062C, 0x0645, 0x062D, 0x062D, 0x0645, 0x064A, 0x062D, 0x0645, 0x064A, 0x062D, 0x0645, 0x0649, 0x062D, 0x0645, 0x0649, 0x0633, 0x062D, 0x062C, 0x0633, 0x062D, 0x062C, 0x0633, 0x062C, 0x062D, 0x0633, 0x062C, 0x062D, 0x0633, 0x062C, 0x0649, 0x0633, 0x062C, 0x0649, 0x0633, 0x0645, 0x062D, 0x0633, 0x0645, 0x062D };
unsigned short unac_data384[] = { 0x0633, 0x0645, 0x062D, 0x0633, 0x0645, 0x062D, 0x0633, 0x0645, 0x062C, 0x0633, 0x0645, 0x062C, 0x0633, 0x0645, 0x0645, 0x0633, 0x0645, 0x0645, 0x0633, 0x0645, 0x0645, 0x0633, 0x0645, 0x0645, 0x0635, 0x062D, 0x062D, 0x0635, 0x062D, 0x062D, 0x0635, 0x062D, 0x062D, 0x0635, 0x062D, 0x062D, 0x0635, 0x0645, 0x0645, 0x0635, 0x0645, 0x0645, 0x0634, 0x062D, 0x0645, 0x0634, 0x062D, 0x0645, 0x0634, 0x062D, 0x0645, 0x0634, 0x062D, 0x0645, 0x0634, 0x062C, 0x064A, 0x0634, 0x062C, 0x064A, 0x0634, 0x0645, 0x062E, 0x0634, 0x0645, 0x062E, 0x0634, 0x0645, 0x062E, 0x0634, 0x0645, 0x062E, 0x0634, 0x0645, 0x0645, 0x0634, 0x0645, 0x0645, 0x0634, 0x0645, 0x0645, 0x0634, 0x0645, 0x0645, 0x0636, 0x062D, 0x0649, 0x0636, 0x062D, 0x0649, 0x0636, 0x062E, 0x0645, 0x0636, 0x062E, 0x0645 };
unsigned short unac_data385[] = { 0x0636, 0x062E, 0x0645, 0x0636, 0x062E, 0x0645, 0x0637, 0x0645, 0x062D, 0x0637, 0x0645, 0x062D, 0x0637, 0x0645, 0x062D, 0x0637, 0x0645, 0x062D, 0x0637, 0x0645, 0x0645, 0x0637, 0x0645, 0x0645, 0x0637, 0x0645, 0x064A, 0x0637, 0x0645, 0x064A, 0x0639, 0x062C, 0x0645, 0x0639, 0x062C, 0x0645, 0x0639, 0x0645, 0x0645, 0x0639, 0x0645, 0x0645, 0x0639, 0x0645, 0x0645, 0x0639, 0x0645, 0x0645, 0x0639, 0x0645, 0x0649, 0x0639, 0x0645, 0x0649, 0x063A, 0x0645, 0x0645, 0x063A, 0x0645, 0x0645, 0x063A, 0x0645, 0x064A, 0x063A, 0x0645, 0x064A, 0x063A, 0x0645, 0x0649, 0x063A, 0x0645, 0x0649, 0x0641, 0x062E, 0x0645, 0x0641, 0x062E, 0x0645, 0x0641, 0x062E, 0x0645, 0x0641, 0x062E, 0x0645, 0x0642, 0x0645, 0x062D, 0x0642, 0x0645, 0x062D, 0x0642, 0x0645, 0x0645, 0x0642, 0x0645, 0x0645 };
unsigned short unac_data386[] = { 0x0644, 0x062D, 0x0645, 0x0644, 0x062D, 0x0645, 0x0644, 0x062D, 0x064A, 0x0644, 0x062D, 0x064A, 0x0644, 0x062D, 0x0649, 0x0644, 0x062D, 0x0649, 0x0644, 0x062C, 0x062C, 0x0644, 0x062C, 0x062C, 0x0644, 0x062C, 0x062C, 0x0644, 0x062C, 0x062C, 0x0644, 0x062E, 0x0645, 0x0644, 0x062E, 0x0645, 0x0644, 0x062E, 0x0645, 0x0644, 0x062E, 0x0645, 0x0644, 0x0645, 0x062D, 0x0644, 0x0645, 0x062D, 0x0644, 0x0645, 0x062D, 0x0644, 0x0645, 0x062D, 0x0645, 0x062D, 0x062C, 0x0645, 0x062D, 0x062C, 0x0645, 0x062D, 0x0645, 0x0645, 0x062D, 0x0645, 0x0645, 0x062D, 0x064A, 0x0645, 0x062D, 0x064A, 0x0645, 0x062C, 0x062D, 0x0645, 0x062C, 0x062D, 0x0645, 0x062C, 0x0645, 0x0645, 0x062C, 0x0645, 0x0645, 0x062E, 0x062C, 0x0645, 0x062E, 0x062C, 0x0645, 0x062E, 0x0645, 0x0645, 0x062E, 0x0645 };
unsigned short unac_data387[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0645, 0x062C, 0x062E, 0x0645, 0x062C, 0x062E, 0x0647, 0x0645, 0x062C, 0x0647, 0x0645, 0x062C, 0x0647, 0x0645, 0x0645, 0x0647, 0x0645, 0x0645, 0x0646, 0x062D, 0x0645, 0x0646, 0x062D, 0x0645, 0x0646, 0x062D, 0x0649, 0x0646, 0x062D, 0x0649, 0x0646, 0x062C, 0x0645, 0x0646, 0x062C, 0x0645, 0x0646, 0x062C, 0x0645, 0x0646, 0x062C, 0x0645, 0x0646, 0x062C, 0x0649, 0x0646, 0x062C, 0x0649, 0x0646, 0x0645, 0x064A, 0x0646, 0x0645, 0x064A, 0x0646, 0x0645, 0x0649, 0x0646, 0x0645, 0x0649, 0x064A, 0x0645, 0x0645, 0x064A, 0x0645, 0x0645, 0x064A, 0x0645, 0x0645, 0x064A, 0x0645, 0x0645, 0x0628, 0x062E, 0x064A, 0x0628, 0x062E, 0x064A, 0x062A, 0x062C, 0x064A, 0x062A, 0x062C, 0x064A };
unsigned short unac_data388[] = { 0x062A, 0x062C, 0x0649, 0x062A, 0x062C, 0x0649, 0x062A, 0x062E, 0x064A, 0x062A, 0x062E, 0x064A, 0x062A, 0x062E, 0x0649, 0x062A, 0x062E, 0x0649, 0x062A, 0x0645, 0x064A, 0x062A, 0x0645, 0x064A, 0x062A, 0x0645, 0x0649, 0x062A, 0x0645, 0x0649, 0x062C, 0x0645, 0x064A, 0x062C, 0x0645, 0x064A, 0x062C, 0x062D, 0x0649, 0x062C, 0x062D, 0x0649, 0x062C, 0x0645, 0x0649, 0x062C, 0x0645, 0x0649, 0x0633, 0x062E, 0x0649, 0x0633, 0x062E, 0x0649, 0x0635, 0x062D, 0x064A, 0x0635, 0x062D, 0x064A, 0x0634, 0x062D, 0x064A, 0x0634, 0x062D, 0x064A, 0x0636, 0x062D, 0x064A, 0x0636, 0x062D, 0x064A, 0x0644, 0x062C, 0x064A, 0x0644, 0x062C, 0x064A, 0x0644, 0x0645, 0x064A, 0x0644, 0x0645, 0x064A, 0x064A, 0x062D, 0x064A, 0x064A, 0x062D, 0x064A, 0x064A, 0x062C, 0x064A, 0x064A, 0x062C, 0x064A };
unsigned short unac_data389[] = { 0x064A, 0x0645, 0x064A, 0x064A, 0x0645, 0x064A, 0x0645, 0x0645, 0x064A, 0x0645, 0x0645, 0x064A, 0x0642, 0x0645, 0x064A, 0x0642, 0x0645, 0x064A, 0x0646, 0x062D, 0x064A, 0x0646, 0x062D, 0x064A, 0x0642, 0x0645, 0x062D, 0x0642, 0x0645, 0x062D, 0x0644, 0x062D, 0x0645, 0x0644, 0x062D, 0x0645, 0x0639, 0x0645, 0x064A, 0x0639, 0x0645, 0x064A, 0x0643, 0x0645, 0x064A, 0x0643, 0x0645, 0x064A, 0x0646, 0x062C, 0x062D, 0x0646, 0x062C, 0x062D, 0x0645, 0x062E, 0x064A, 0x0645, 0x062E, 0x064A, 0x0644, 0x062C, 0x0645, 0x0644, 0x062C, 0x0645, 0x0643, 0x0645, 0x0645, 0x0643, 0x0645, 0x0645, 0x0644, 0x062C, 0x0645, 0x0644, 0x062C, 0x0645, 0x0646, 0x062C, 0x062D, 0x0646, 0x062C, 0x062D, 0x062C, 0x062D, 0x064A, 0x062C, 0x062D, 0x064A, 0x062D, 0x062C, 0x064A, 0x062D, 0x062C, 0x064A };
unsigned short unac_data390[] = { 0x0645, 0x062C, 0x064A, 0x0645, 0x062C, 0x064A, 0x0641, 0x0645, 0x064A, 0x0641, 0x0645, 0x064A, 0x0628, 0x062D, 0x064A, 0x0628, 0x062D, 0x064A, 0x0643, 0x0645, 0x0645, 0x0643, 0x0645, 0x0645, 0x0639, 0x062C, 0x0645, 0x0639, 0x062C, 0x0645, 0x0635, 0x0645, 0x0645, 0x0635, 0x0645, 0x0645, 0x0633, 0x062E, 0x064A, 0x0633, 0x062E, 0x064A, 0x0646, 0x062C, 0x064A, 0x0646, 0x062C, 0x064A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data391[] = { 0x0635, 0x0644, 0x06D2, 0x0635, 0x0644, 0x06D2, 0x0642, 0x0644, 0x06D2, 0x0642, 0x0644, 0x06D2, 0x0627, 0x0644, 0x0644, 0x0647, 0x0627, 0x0644, 0x0644, 0x0647, 0x0627, 0x0643, 0x0628, 0x0631, 0x0627, 0x0643, 0x0628, 0x0631, 0x0645, 0x062D, 0x0645, 0x062F, 0x0645, 0x062D, 0x0645, 0x062F, 0x0635, 0x0644, 0x0639, 0x0645, 0x0635, 0x0644, 0x0639, 0x0645, 0x0631, 0x0633, 0x0648, 0x0644, 0x0631, 0x0633, 0x0648, 0x0644, 0x0639, 0x0644, 0x064A, 0x0647, 0x0639, 0x0644, 0x064A, 0x0647, 0x0648, 0x0633, 0x0644, 0x0645, 0x0648, 0x0633, 0x0644, 0x0645, 0x0635, 0x0644, 0x0649, 0x0635, 0x0644, 0x0649, 0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645, 0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645, 0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647, 0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647, 0x0631, 0x06CC, 0x0627, 0x0644, 0x0631, 0x06CC, 0x0627, 0x0644, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data392[] = { 0x002C, 0x002C, 0x3001, 0x3001, 0x3002, 0x3002, 0x003A, 0x003A, 0x003B, 0x003B, 0x0021, 0x0021, 0x003F, 0x003F, 0x3016, 0x3016, 0x3017, 0x3017, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data393[] = { 0x002E, 0x002E, 0x002E, 0x002E, 0x2014, 0x2014, 0x2013, 0x2013, 0x005F, 0x005F, 0x005F, 0x005F, 0x0028, 0x0028, 0x0029, 0x0029, 0x007B, 0x007B, 0x007D, 0x007D, 0x3014, 0x3014, 0x3015, 0x3015, 0x3010, 0x3010, 0x3011, 0x3011, 0x300A, 0x300A, 0x300B, 0x300B, 0x3008, 0x3008 };
unsigned short unac_data394[] = { 0x3009, 0x3009, 0x300C, 0x300C, 0x300D, 0x300D, 0x300E, 0x300E, 0x300F, 0x300F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x005B, 0x005B, 0x005D, 0x005D, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x005F, 0x005F, 0x005F, 0x005F, 0x005F, 0x005F };
unsigned short unac_data395[] = { 0x002C, 0x002C, 0x3001, 0x3001, 0x002E, 0x002E, 0xFFFF, 0xFFFF, 0x003B, 0x003B, 0x003A, 0x003A, 0x003F, 0x003F, 0x0021, 0x0021, 0x2014, 0x2014, 0x0028, 0x0028, 0x0029, 0x0029, 0x007B, 0x007B, 0x007D, 0x007D, 0x3014, 0x3014, 0x3015, 0x3015, 0x0023, 0x0023 };
unsigned short unac_data396[] = { 0x0026, 0x0026, 0x002A, 0x002A, 0x002B, 0x002B, 0x002D, 0x002D, 0x003C, 0x003C, 0x003E, 0x003E, 0x003D, 0x003D, 0xFFFF, 0xFFFF, 0x005C, 0x005C, 0x0024, 0x0024, 0x0025, 0x0025, 0x0040, 0x0040, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data397[] = { 0x0020, 0x0020, 0x0640, 0x0640, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0640, 0x0640, 0x0020, 0x0020, 0x0640, 0x0640, 0x0020, 0x0020, 0x0640, 0x0640, 0x0020, 0x0020, 0x0640, 0x0640, 0x0020, 0x0020, 0x0640, 0x0640 };
unsigned short unac_data398[] = { 0x0621, 0x0621, 0x0627, 0x0627, 0x0627, 0x0627, 0x0627, 0x0627, 0x0627, 0x0627, 0x0648, 0x0648, 0x0648, 0x0648, 0x0627, 0x0627, 0x0627, 0x0627, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x0627, 0x0627, 0x0627, 0x0627, 0x0628, 0x0628 };
unsigned short unac_data399[] = { 0x0628, 0x0628, 0x0628, 0x0628, 0x0628, 0x0628, 0x0629, 0x0629, 0x0629, 0x0629, 0x062A, 0x062A, 0x062A, 0x062A, 0x062A, 0x062A, 0x062A, 0x062A, 0x062B, 0x062B, 0x062B, 0x062B, 0x062B, 0x062B, 0x062B, 0x062B, 0x062C, 0x062C, 0x062C, 0x062C, 0x062C, 0x062C };
unsigned short unac_data400[] = { 0x062C, 0x062C, 0x062D, 0x062D, 0x062D, 0x062D, 0x062D, 0x062D, 0x062D, 0x062D, 0x062E, 0x062E, 0x062E, 0x062E, 0x062E, 0x062E, 0x062E, 0x062E, 0x062F, 0x062F, 0x062F, 0x062F, 0x0630, 0x0630, 0x0630, 0x0630, 0x0631, 0x0631, 0x0631, 0x0631, 0x0632, 0x0632 };
unsigned short unac_data401[] = { 0x0632, 0x0632, 0x0633, 0x0633, 0x0633, 0x0633, 0x0633, 0x0633, 0x0633, 0x0633, 0x0634, 0x0634, 0x0634, 0x0634, 0x0634, 0x0634, 0x0634, 0x0634, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0636, 0x0636, 0x0636, 0x0636, 0x0636, 0x0636 };
unsigned short unac_data402[] = { 0x0636, 0x0636, 0x0637, 0x0637, 0x0637, 0x0637, 0x0637, 0x0637, 0x0637, 0x0637, 0x0638, 0x0638, 0x0638, 0x0638, 0x0638, 0x0638, 0x0638, 0x0638, 0x0639, 0x0639, 0x0639, 0x0639, 0x0639, 0x0639, 0x0639, 0x0639, 0x063A, 0x063A, 0x063A, 0x063A, 0x063A, 0x063A };
unsigned short unac_data403[] = { 0x063A, 0x063A, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0642, 0x0642, 0x0642, 0x0642, 0x0642, 0x0642, 0x0642, 0x0642, 0x0643, 0x0643, 0x0643, 0x0643, 0x0643, 0x0643, 0x0643, 0x0643, 0x0644, 0x0644, 0x0644, 0x0644, 0x0644, 0x0644 };
unsigned short unac_data404[] = { 0x0644, 0x0644, 0x0645, 0x0645, 0x0645, 0x0645, 0x0645, 0x0645, 0x0645, 0x0645, 0x0646, 0x0646, 0x0646, 0x0646, 0x0646, 0x0646, 0x0646, 0x0646, 0x0647, 0x0647, 0x0647, 0x0647, 0x0647, 0x0647, 0x0647, 0x0647, 0x0648, 0x0648, 0x0648, 0x0648, 0x0649, 0x0649 };
unsigned short unac_data405[] = { 0x0649, 0x0649, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data406[] = { 0xFFFF, 0xFFFF, 0x0021, 0x0021, 0x0022, 0x0022, 0x0023, 0x0023, 0x0024, 0x0024, 0x0025, 0x0025, 0x0026, 0x0026, 0x0027, 0x0027, 0x0028, 0x0028, 0x0029, 0x0029, 0x002A, 0x002A, 0x002B, 0x002B, 0x002C, 0x002C, 0x002D, 0x002D, 0x002E, 0x002E, 0x002F, 0x002F };
unsigned short unac_data407[] = { 0x0030, 0x0030, 0x0031, 0x0031, 0x0032, 0x0032, 0x0033, 0x0033, 0x0034, 0x0034, 0x0035, 0x0035, 0x0036, 0x0036, 0x0037, 0x0037, 0x0038, 0x0038, 0x0039, 0x0039, 0x003A, 0x003A, 0x003B, 0x003B, 0x003C, 0x003C, 0x003D, 0x003D, 0x003E, 0x003E, 0x003F, 0x003F };
unsigned short unac_data408[] = { 0x0040, 0x0040, 0x0041, 0x0061, 0x0042, 0x0062, 0x0043, 0x0063, 0x0044, 0x0064, 0x0045, 0x0065, 0x0046, 0x0066, 0x0047, 0x0067, 0x0048, 0x0068, 0x0049, 0x0069, 0x004A, 0x006A, 0x004B, 0x006B, 0x004C, 0x006C, 0x004D, 0x006D, 0x004E, 0x006E, 0x004F, 0x006F };
unsigned short unac_data409[] = { 0x0050, 0x0070, 0x0051, 0x0071, 0x0052, 0x0072, 0x0053, 0x0073, 0x0054, 0x0074, 0x0055, 0x0075, 0x0056, 0x0076, 0x0057, 0x0077, 0x0058, 0x0078, 0x0059, 0x0079, 0x005A, 0x007A, 0x005B, 0x005B, 0x005C, 0x005C, 0x005D, 0x005D, 0x005E, 0x005E, 0x005F, 0x005F };
unsigned short unac_data410[] = { 0x0060, 0x0060, 0x0061, 0x0061, 0x0062, 0x0062, 0x0063, 0x0063, 0x0064, 0x0064, 0x0065, 0x0065, 0x0066, 0x0066, 0x0067, 0x0067, 0x0068, 0x0068, 0x0069, 0x0069, 0x006A, 0x006A, 0x006B, 0x006B, 0x006C, 0x006C, 0x006D, 0x006D, 0x006E, 0x006E, 0x006F, 0x006F };
unsigned short unac_data411[] = { 0x0070, 0x0070, 0x0071, 0x0071, 0x0072, 0x0072, 0x0073, 0x0073, 0x0074, 0x0074, 0x0075, 0x0075, 0x0076, 0x0076, 0x0077, 0x0077, 0x0078, 0x0078, 0x0079, 0x0079, 0x007A, 0x007A, 0x007B, 0x007B, 0x007C, 0x007C, 0x007D, 0x007D, 0x007E, 0x007E, 0x2985, 0x2985 };
unsigned short unac_data412[] = { 0x2986, 0x2986, 0x3002, 0x3002, 0x300C, 0x300C, 0x300D, 0x300D, 0x3001, 0x3001, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data413[] = { 0x1160, 0x1160, 0x1100, 0x1100, 0x1101, 0x1101, 0x11AA, 0x11AA, 0x1102, 0x1102, 0x11AC, 0x11AC, 0x11AD, 0x11AD, 0x1103, 0x1103, 0x1104, 0x1104, 0x1105, 0x1105, 0x11B0, 0x11B0, 0x11B1, 0x11B1, 0x11B2, 0x11B2, 0x11B3, 0x11B3, 0x11B4, 0x11B4, 0x11B5, 0x11B5 };
unsigned short unac_data414[] = { 0x111A, 0x111A, 0x1106, 0x1106, 0x1107, 0x1107, 0x1108, 0x1108, 0x1121, 0x1121, 0x1109, 0x1109, 0x110A, 0x110A, 0x110B, 0x110B, 0x110C, 0x110C, 0x110D, 0x110D, 0x110E, 0x110E, 0x110F, 0x110F, 0x1110, 0x1110, 0x1111, 0x1111, 0x1112, 0x1112, 0xFFFF, 0xFFFF };
unsigned short unac_data415[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1161, 0x1161, 0x1162, 0x1162, 0x1163, 0x1163, 0x1164, 0x1164, 0x1165, 0x1165, 0x1166, 0x1166, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1167, 0x1167, 0x1168, 0x1168, 0x1169, 0x1169, 0x116A, 0x116A, 0x116B, 0x116B, 0x116C, 0x116C };
unsigned short unac_data416[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x116D, 0x116D, 0x116E, 0x116E, 0x116F, 0x116F, 0x1170, 0x1170, 0x1171, 0x1171, 0x1172, 0x1172, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1173, 0x1173, 0x1174, 0x1174, 0x1175, 0x1175, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data417[] = { 0x00A2, 0x00A2, 0x00A3, 0x00A3, 0x00AC, 0x00AC, 0x0020, 0x0020, 0x00A6, 0x00A6, 0x00A5, 0x00A5, 0x20A9, 0x20A9, 0xFFFF, 0xFFFF, 0x2502, 0x2502, 0x2190, 0x2190, 0x2191, 0x2191, 0x2192, 0x2192, 0x2193, 0x2193, 0x25A0, 0x25A0, 0x25CB, 0x25CB, 0xFFFF, 0xFFFF };

unsigned short* unac_data_table[UNAC_BLOCK_COUNT] = {
unac_data0,
unac_data1,
unac_data2,
unac_data3,
unac_data4,
unac_data5,
unac_data6,
unac_data7,
unac_data8,
unac_data9,
unac_data10,
unac_data11,
unac_data12,
unac_data13,
unac_data14,
unac_data15,
unac_data16,
unac_data17,
unac_data18,
unac_data19,
unac_data20,
unac_data21,
unac_data22,
unac_data23,
unac_data24,
unac_data25,
unac_data26,
unac_data27,
unac_data28,
unac_data29,
unac_data30,
unac_data31,
unac_data32,
unac_data33,
unac_data34,
unac_data35,
unac_data36,
unac_data37,
unac_data38,
unac_data39,
unac_data40,
unac_data41,
unac_data42,
unac_data43,
unac_data44,
unac_data45,
unac_data46,
unac_data47,
unac_data48,
unac_data49,
unac_data50,
unac_data51,
unac_data52,
unac_data53,
unac_data54,
unac_data55,
unac_data56,
unac_data57,
unac_data58,
unac_data59,
unac_data60,
unac_data61,
unac_data62,
unac_data63,
unac_data64,
unac_data65,
unac_data66,
unac_data67,
unac_data68,
unac_data69,
unac_data70,
unac_data71,
unac_data72,
unac_data73,
unac_data74,
unac_data75,
unac_data76,
unac_data77,
unac_data78,
unac_data79,
unac_data80,
unac_data81,
unac_data82,
unac_data83,
unac_data84,
unac_data85,
unac_data86,
unac_data87,
unac_data88,
unac_data89,
unac_data90,
unac_data91,
unac_data92,
unac_data93,
unac_data94,
unac_data95,
unac_data96,
unac_data97,
unac_data98,
unac_data99,
unac_data100,
unac_data101,
unac_data102,
unac_data103,
unac_data104,
unac_data105,
unac_data106,
unac_data107,
unac_data108,
unac_data109,
unac_data110,
unac_data111,
unac_data112,
unac_data113,
unac_data114,
unac_data115,
unac_data116,
unac_data117,
unac_data118,
unac_data119,
unac_data120,
unac_data121,
unac_data122,
unac_data123,
unac_data124,
unac_data125,
unac_data126,
unac_data127,
unac_data128,
unac_data129,
unac_data130,
unac_data131,
unac_data132,
unac_data133,
unac_data134,
unac_data135,
unac_data136,
unac_data137,
unac_data138,
unac_data139,
unac_data140,
unac_data141,
unac_data142,
unac_data143,
unac_data144,
unac_data145,
unac_data146,
unac_data147,
unac_data148,
unac_data149,
unac_data150,
unac_data151,
unac_data152,
unac_data153,
unac_data154,
unac_data155,
unac_data156,
unac_data157,
unac_data158,
unac_data159,
unac_data160,
unac_data161,
unac_data162,
unac_data163,
unac_data164,
unac_data165,
unac_data166,
unac_data167,
unac_data168,
unac_data169,
unac_data170,
unac_data171,
unac_data172,
unac_data173,
unac_data174,
unac_data175,
unac_data176,
unac_data177,
unac_data178,
unac_data179,
unac_data180,
unac_data181,
unac_data182,
unac_data183,
unac_data184,
unac_data185,
unac_data186,
unac_data187,
unac_data188,
unac_data189,
unac_data190,
unac_data191,
unac_data192,
unac_data193,
unac_data194,
unac_data195,
unac_data196,
unac_data197,
unac_data198,
unac_data199,
unac_data200,
unac_data201,
unac_data202,
unac_data203,
unac_data204,
unac_data205,
unac_data206,
unac_data207,
unac_data208,
unac_data209,
unac_data210,
unac_data211,
unac_data212,
unac_data213,
unac_data214,
unac_data215,
unac_data216,
unac_data217,
unac_data218,
unac_data219,
unac_data220,
unac_data221,
unac_data222,
unac_data223,
unac_data224,
unac_data225,
unac_data226,
unac_data227,
unac_data228,
unac_data229,
unac_data230,
unac_data231,
unac_data232,
unac_data233,
unac_data234,
unac_data235,
unac_data236,
unac_data237,
unac_data238,
unac_data239,
unac_data240,
unac_data241,
unac_data242,
unac_data243,
unac_data244,
unac_data245,
unac_data246,
unac_data247,
unac_data248,
unac_data249,
unac_data250,
unac_data251,
unac_data252,
unac_data253,
unac_data254,
unac_data255,
unac_data256,
unac_data257,
unac_data258,
unac_data259,
unac_data260,
unac_data261,
unac_data262,
unac_data263,
unac_data264,
unac_data265,
unac_data266,
unac_data267,
unac_data268,
unac_data269,
unac_data270,
unac_data271,
unac_data272,
unac_data273,
unac_data274,
unac_data275,
unac_data276,
unac_data277,
unac_data278,
unac_data279,
unac_data280,
unac_data281,
unac_data282,
unac_data283,
unac_data284,
unac_data285,
unac_data286,
unac_data287,
unac_data288,
unac_data289,
unac_data290,
unac_data291,
unac_data292,
unac_data293,
unac_data294,
unac_data295,
unac_data296,
unac_data297,
unac_data298,
unac_data299,
unac_data300,
unac_data301,
unac_data302,
unac_data303,
unac_data304,
unac_data305,
unac_data306,
unac_data307,
unac_data308,
unac_data309,
unac_data310,
unac_data311,
unac_data312,
unac_data313,
unac_data314,
unac_data315,
unac_data316,
unac_data317,
unac_data318,
unac_data319,
unac_data320,
unac_data321,
unac_data322,
unac_data323,
unac_data324,
unac_data325,
unac_data326,
unac_data327,
unac_data328,
unac_data329,
unac_data330,
unac_data331,
unac_data332,
unac_data333,
unac_data334,
unac_data335,
unac_data336,
unac_data337,
unac_data338,
unac_data339,
unac_data340,
unac_data341,
unac_data342,
unac_data343,
unac_data344,
unac_data345,
unac_data346,
unac_data347,
unac_data348,
unac_data349,
unac_data350,
unac_data351,
unac_data352,
unac_data353,
unac_data354,
unac_data355,
unac_data356,
unac_data357,
unac_data358,
unac_data359,
unac_data360,
unac_data361,
unac_data362,
unac_data363,
unac_data364,
unac_data365,
unac_data366,
unac_data367,
unac_data368,
unac_data369,
unac_data370,
unac_data371,
unac_data372,
unac_data373,
unac_data374,
unac_data375,
unac_data376,
unac_data377,
unac_data378,
unac_data379,
unac_data380,
unac_data381,
unac_data382,
unac_data383,
unac_data384,
unac_data385,
unac_data386,
unac_data387,
unac_data388,
unac_data389,
unac_data390,
unac_data391,
unac_data392,
unac_data393,
unac_data394,
unac_data395,
unac_data396,
unac_data397,
unac_data398,
unac_data399,
unac_data400,
unac_data401,
unac_data402,
unac_data403,
unac_data404,
unac_data405,
unac_data406,
unac_data407,
unac_data408,
unac_data409,
unac_data410,
unac_data411,
unac_data412,
unac_data413,
unac_data414,
unac_data415,
unac_data416,
unac_data417
};
/* Generated by builder. Do not modify. End tables */

/*
 * Debug level. See unac.h for a detailed discussion of the
 * values.
 */
static int debug_level = UNAC_DEBUG_LOW;

#ifdef UNAC_DEBUG_AVAILABLE

/*
 * Default debug function, printing on stderr.
 */
static void debug_doprint_default(const char* message, void* data)
{
  fprintf(stderr, "%s", message);
}

/*
 * Default doprint handler is debug_doprint.
 */
static unac_debug_print_t debug_doprint = debug_doprint_default;
/*
 * Default app data is null.
 */
static void* debug_appdata = (void*)0;

/*
 * Generate a debug message (arguments ala printf) and
 * send it to the doprint handler.
 */
#define DEBUG debug_print("%s:%d: ", __FILE__, __LINE__), debug_print
#define DEBUG_APPEND debug_print
static void debug_print(const char* message, ...)
{
#define UNAC_MAXIMUM_MESSAGE_SIZE 512
  /*
   * UNAC_MAXIMUM_MESSAGE_SIZE is supposedly enough but I
   * do trust some vsnprintf implementations to be bugous.
   */
  char unac_message_buffer[UNAC_MAXIMUM_MESSAGE_SIZE+1] = { '\0' };
  va_list args;
  va_start(args, message);
  if(vsnprintf(unac_message_buffer, UNAC_MAXIMUM_MESSAGE_SIZE, message, args) < 0) {
    char tmp[UNAC_MAXIMUM_MESSAGE_SIZE];
    sprintf(tmp, "[message larger than %d, truncated]", UNAC_MAXIMUM_MESSAGE_SIZE);
    debug_doprint(tmp, debug_appdata);
  }
  va_end(args);
  unac_message_buffer[UNAC_MAXIMUM_MESSAGE_SIZE] = '\0';

  debug_doprint(unac_message_buffer, debug_appdata);
}

void unac_debug_callback(int level, unac_debug_print_t function, void* data)
{
  debug_level = level;
  if(function)
    debug_doprint = function;
  debug_appdata = data;
}

#else /* UNAC_DEBUG_AVAILABLE */
#define DEBUG 
#define DEBUG_APPEND
#endif /* UNAC_DEBUG_AVAILABLE */

int unacmaybefold_string_utf16(const char* in, size_t in_length,
		      char** outp, size_t* out_lengthp, int dofold)
{
  char* out;
  int out_size;
  int out_length;
  unsigned int i;

  out_size = in_length > 0 ? in_length : 1024;

  out = *outp;
  out = (char*)realloc(out, out_size + 1);
  if(out == 0) {
      if(debug_level >= UNAC_DEBUG_LOW)
	  DEBUG("realloc %d bytes failed\n", out_size+1);
      /* *outp is still valid. Let the caller free it */
      return -1;
  }

  out_length = 0;

  for(i = 0; i < in_length; i += 2) {
    unsigned short c;
    unsigned short* p;
    int l;
    int k;
    c = (in[i] << 8) | (in[i + 1] & 0xff);
    /*
     * Lookup the tables for decomposition information
     */
#ifdef RECOLL_DATADIR
    size_t idx;
    if (except_chars.size() != 0 && (idx=is_except_char(c)) != (size_t)-1) {
	p = (unsigned short *)(except_trans[idx].c_str() + 2);
	l = (except_trans[idx].size() - 2) / 2;
	/* unsigned char *cp = (unsigned char *)p;
	   fprintf(stderr, "l %d cp[0] %x cp[1] %x\n", l, (unsigned int)cp[0], 
	   (unsigned int)cp[1]);*/
    } else {
#endif /* RECOLL_DATADIR */
	if (dofold) {
	    unacfold_char_utf16(c, p, l);
	} else {
	    unac_char_utf16(c, p, l);
	}
#ifdef RECOLL_DATADIR
    }
#endif /* RECOLL_DATADIR */

    /*
     * Explain what's done in great detail
     */
    if(debug_level == UNAC_DEBUG_HIGH) {
      unsigned short index = unac_indexes[(c) >> UNAC_BLOCK_SHIFT];
      unsigned char position = (c) & UNAC_BLOCK_MASK;
      DEBUG("unac_data%d[%d] & unac_positions[%d][%d]: ", index, unac_positions[index][position], index, position+1);
      DEBUG_APPEND("0x%04x => ", (c));
      if(l == 0) {
	DEBUG_APPEND("untouched\n");
      } else {
	int i;
	for(i = 0; i < l; i++)
	  DEBUG_APPEND("0x%04x ", p[i]);
	DEBUG_APPEND("\n");
      }
    }

    /*
     * Make sure there is enough space to hold the decomposition
     * Note: a previous realloc may have succeeded, which means that *outp 
     * is not valid any more. We have to do the freeing and zero out *outp
     */
    if(out_length + ((l + 1) * 2) > out_size) {
      char *saved;
      out_size += ((l + 1) * 2) + 1024;
      saved = out;
      out = (char *)realloc(out, out_size);
      if(out == 0) {
	if(debug_level >= UNAC_DEBUG_LOW)
	  DEBUG("realloc %d bytes failed\n", out_size);
        free(saved);
	*outp = 0;
	return -1;
      }
    }
    if(l > 0) {
	/* l == 1 && *p == 0 is the special case generated for
	   mark characters (which may be found if the input is
	   already in decomposed form. Output nothing */
	if (l != 1 || *p != 0) {
	    /*
	     * If there is a decomposition, insert it in the output 
	     * string.
	     */
	    for(k = 0; k < l; k++) {
		out[out_length++] = (p[k] >> 8) & 0xff;
		out[out_length++] = (p[k] & 0xff);
	    }
	}
    } else {
      /*
       * If there is no decomposition leave it unchanged
       */
      out[out_length++] = in[i];
      out[out_length++] = in[i + 1];
    }
  }

  *outp = out;
  *out_lengthp = out_length;
  (*outp)[*out_lengthp] = '\0';

  return 0;
}
int unac_string_utf16(const char* in, size_t in_length,
		      char** outp, size_t* out_lengthp)
{
    return unacmaybefold_string_utf16(in, in_length,
				      outp, out_lengthp, 0);
}
int unacfold_string_utf16(const char* in, size_t in_length,
		      char** outp, size_t* out_lengthp)
{
    return unacmaybefold_string_utf16(in, in_length,
				      outp, out_lengthp, 1);
}

static int convert(const char* from, const char* to,
		   const char* in, size_t in_length,
		   char** outp, size_t* out_lengthp);

static const char *utf16be = "UTF-16BE";
static iconv_t u8tou16_cd = (iconv_t)-1;
static iconv_t u16tou8_cd = (iconv_t)-1;
static pthread_mutex_t o_unac_mutex;
static int unac_mutex_is_init;
// Call this or take your chances with the auto init.
void unac_init_mt()
{
    pthread_mutex_init(&o_unac_mutex, 0);
    unac_mutex_is_init = 1;
}

/*
 * Convert buffer <in> containing string encoded in charset <from> into
 * a string in charset <to> and return it in buffer <outp>. The <outp>
 * points to a malloced string large enough to hold the conversion result.
 * It is the responsibility of the caller to free this array.
 * The out string is always null terminated.
 */
static int convert(const char* from, const char* to,
		   const char* in, size_t in_length,
		   char** outp, size_t* out_lengthp)
{
  int ret = -1;
  iconv_t cd;
  char* out;
  size_t out_remain;
  size_t out_size;
  char* out_base;
  int from_utf16, from_utf8, to_utf16, to_utf8, u8tou16, u16tou8;
  const char space[] = { 0x00, 0x20 };

  /* Note: better call explicit unac_init_mt() before starting threads than
     rely on this.
   */
  if (unac_mutex_is_init == 0) {
      pthread_mutex_init(&o_unac_mutex, 0);
      unac_mutex_is_init = 1;
  }
  pthread_mutex_lock(&o_unac_mutex);

  if (!strcmp(utf16be, from)) {
      from_utf8 = 0;
      from_utf16 = 1;
  } else if (!strcasecmp("UTF-8", from)) {
      from_utf8 = 1;
      from_utf16 = 0;
  } else {
      from_utf8 = from_utf16 = 0;
  }
  if (!strcmp(utf16be, to)) {
      to_utf8 = 0;
      to_utf16 = 1;
  } else if (!strcasecmp("UTF-8", to)) {
      to_utf8 = 1;
      to_utf16 = 0;
  } else {
      to_utf8 = to_utf16 = 0;
  }
  u16tou8 = from_utf16 && to_utf8;
  u8tou16 = from_utf8 && to_utf16;

  out_size = in_length > 0 ? in_length : 1024;

  out = *outp;
  out = (char *)realloc(out, out_size + 1);
  if(out == 0) {
      /* *outp still valid, no freeing */
      if(debug_level >= UNAC_DEBUG_LOW)
	  DEBUG("realloc %d bytes failed\n", out_size+1);
      goto out;
  }

  out_remain = out_size;
  out_base = out;

  if (u8tou16) {
      if (u8tou16_cd == (iconv_t)-1) {
	  if((u8tou16_cd = iconv_open(to, from)) == (iconv_t)-1) {
	      goto out;
	  }
      } else {
	  iconv(u8tou16_cd, 0, 0, 0, 0);
      }
      cd = u8tou16_cd;
  } else if (u16tou8) {
      if (u16tou8_cd == (iconv_t)-1) {
	  if((u16tou8_cd = iconv_open(to, from)) == (iconv_t)-1) {
	      goto out;
	  }
      } else {
	  iconv(u16tou8_cd, 0, 0, 0, 0);
      }
      cd = u16tou8_cd;
  } else {
      if((cd = iconv_open(to, from)) == (iconv_t)-1) {
	  goto out;
      }
  }

  do {
    if(iconv(cd, (ICONV_CONST char **) &in, &in_length, &out, &out_remain) == (size_t)-1) {
      switch(errno) {
      case EILSEQ:
	/*
	 * If an illegal sequence is found in the context of unac_string
	 * it means the unaccented version of a character contains
	 * a sequence that cannot be mapped back to the original charset.
	 * For instance, the 1/4 character in ISO-8859-1 is decomposed
	 * in three characters including the FRACTION SLASH (2044) which
	 * have no equivalent in the ISO-8859-1 map. One can argue that
	 * the conversions tables should map it to the regular / character
	 * or that a <compat> entry should be associated with it. 
	 *
	 * To cope with this situation, convert silently transform all
	 * illegal sequences (EILSEQ) into a SPACE character 0x0020.
	 *
	 * In the general conversion case this behaviour is not desirable.
	 * However, it is not the responsibility of this program to cope
	 * with inconsistencies of the Unicode description and a bug report
	 * should be submited to Unicode so that they can fix the problem.
	 * 
	 */
	if(from_utf16) {
	  const char* tmp = space;
	  size_t tmp_length = 2;
	  if(iconv(cd, (ICONV_CONST char **) &tmp, &tmp_length, &out, &out_remain) == (size_t)-1) {
	    if(errno == E2BIG)
	      /* fall thru to the E2BIG case below */;
	    else
	      goto out;
	  } else {
	    /* The offending character was replaced by a SPACE, skip it. */
	    in += 2;
	    in_length -= 2;
	    /* And continue conversion. */
	    break;
	  }
	} else {
	  goto out;
	}
      case E2BIG:
	{
	  /*
	   * The output does not fit in the current out buffer, enlarge it.
	   */
	  int length = out - out_base;
	  out_size *= 2;
	  {
	      char *saved = out_base;
	      /* +1 for null */
	      out_base = (char *)realloc(out_base, out_size + 1);
	      if (out_base == 0) {
		  /* *outp potentially not valid any more. Free here,
		   * and zero out */
		  if(debug_level >= UNAC_DEBUG_LOW)
		      DEBUG("realloc %d bytes failed\n", out_size+1);
		  free(saved);
		  *outp = 0;
		  goto out;
	      }
	  }
	  out = out_base + length;
	  out_remain = out_size - length;
	}
	break;
      default:
	goto out;
	break;
      }
    }
  } while(in_length > 0);

  if (!u8tou16 && !u16tou8)
      iconv_close(cd);

  *outp = out_base;
  *out_lengthp = out - out_base;
  (*outp)[*out_lengthp] = '\0';

  ret = 0;
out:
  pthread_mutex_unlock(&o_unac_mutex);
  return ret;
}

int unacmaybefold_string(const char* charset,
			 const char* in, size_t in_length,
			 char** outp, size_t* out_lengthp, int dofold)
{
  /*
   * When converting an empty string, skip everything but alloc the
   * buffer if NULL pointer.
   */
  if (in_length <= 0) {
      if(!*outp) {
	  if ((*outp = (char*)malloc(32)) == 0)
	      return -1;
      }
      (*outp)[0] = '\0';
      *out_lengthp = 0;
  } else {
    char* utf16 = 0;
    size_t utf16_length = 0;
    char* utf16_unaccented = 0;
    size_t utf16_unaccented_length = 0;
  
    if(convert(charset, utf16be, in, in_length, &utf16, &utf16_length) < 0) {
      return -1;
    }

    unacmaybefold_string_utf16(utf16, utf16_length, &utf16_unaccented, &utf16_unaccented_length, dofold);
    free(utf16);

    if(convert(utf16be, charset, utf16_unaccented, utf16_unaccented_length, outp, out_lengthp) < 0) {
      return -1;
    }
    free(utf16_unaccented);
  }

  return 0;
}

int unac_string(const char* charset,
		const char* in, size_t in_length,
		char** outp, size_t* out_lengthp)
{
    return unacmaybefold_string(charset, in, in_length,
				outp, out_lengthp, 0);
}
int unacfold_string(const char* charset,
		const char* in, size_t in_length,
		char** outp, size_t* out_lengthp)
{
    return unacmaybefold_string(charset, in, in_length,
				outp, out_lengthp, 1);
}
const char* unac_version(void)
{
  return UNAC_VERSION;
}

#ifdef RECOLL_DATADIR
void unac_set_except_translations(const char *spectrans)
{
    except_chars.clear();
    except_trans.clear();
    if (!spectrans || !spectrans[0])
	return;

    // The translation tables out of Unicode are in machine byte order (we
    // just let the compiler read the values). 
    // For the translation part, we need to choose our encoding in accordance )
    // (16BE or 16LE depending on processor)
    // On the contrary, the source char is always to be compared to
    // the input text, which is encoded in UTF-16BE ... What a mess.
    static const char *machinecoding = 0;
    bool littleendian = true;
    if (machinecoding == 0) {
	const char*  charshort = "\001\002";
	short *ip = (short *)charshort;
	if (*ip == 0x0102) {
	    littleendian = false;
	    machinecoding = "UTF-16BE";
	} else {
	    littleendian = true;
	    machinecoding = "UTF-16LE";
	}
    }

    vector<string> vtrans;
    stringToStrings(spectrans, vtrans);

    for (vector<string>::iterator it = vtrans.begin();
	 it != vtrans.end(); it++) {

	/* Convert the whole thing to utf-16be/le according to endianness */
	char *out = 0;
	size_t outsize;
	if (convert("UTF-8", machinecoding,
		    it->c_str(), it->size(),
		    &out, &outsize) != 0 || outsize < 2)
	    continue;

	/* The source char must be utf-16be as this is what we convert the
	   input text to for internal processing */
	unsigned short ch;
	if (littleendian)
	    ch = (out[1] << 8) | (out[0] & 0xff);
	else
	    ch = (out[0] << 8) | (out[1] & 0xff);

	/* fprintf(stderr, "outsize %d Ch is 0x%hx\n", int(outsize), ch);*/
	except_chars.push_back(ch);
	// We keep ch as the first 2 bytes in the translation so that 
	// both vectors sort identically
	except_trans.push_back(string((const char *)out, outsize));
	free(out);
    }
    std::sort(except_chars.begin(), except_chars.end());
    std::sort(except_trans.begin(), except_trans.end());
}
#endif /* RECOLL_DATADIR */
