#! /bin/sh

# Test upload of a CSV file.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g')

DB_DIR=db
DB_FILE=${DB_DIR}/test1.db
TMP_DB_FILE=${DB_DIR}/${TMP_TEST_DB}.db

cp ${DB_FILE} ${TMP_DB_FILE}

test_input () {
    cat <<EOF
{
   "data" : [
      {
         "attributes" : {
            "id" : 5,
            "authors" : "Me",
            "title" : "My First Book",
            "year" : 2019
         },
         "type" : "bibliography"
      }
   ]
}
EOF
}

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}.db/bibliography/5"
export HTTP_HOST=restfuldb.domain.net
export REQUEST_METHOD=PUT
export CONTENT_TYPE="application/json"
export CONTENT_LENGTH=$(test_input | wc -c)
export REMOTE_USER=writer

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

echo "==="

test_input \
    | ${INPUT_SCRIPT} \
    | tools/scripts/prettyprint-inner-json \
    | perl -lpe "s/'\S+tmp\w+\d+sh\d+(\.db)?'/'<database>'/"

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

rm -f ${TMP_DB_FILE}
