#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "torus.icc"
int main (int argc, char**argv) {
  environment rheolef (argc, argv);
  geo gamma (argv[1]);
  size_t d = gamma.dimension();
  space Wh (gamma, argv[2]);
  trial u (Wh); test v (Wh);
  form m = integrate (u*v);
  form a = integrate (dot(grad_s(u),grad_s(v)));
  field b = m*field(Wh,1);
  field lh = integrate (f(d)*v);
  csr<Float> A = {{  a.uu(),     b.u()},
                  {trans(b.u()),  0   }};
  vec<Float> B =  {  lh.u(),      0   };
  solver sa (A);
  vec<Float> U = sa.solve (B);
  field uh(Wh);
  uh.set_u() = U [range(0,uh.u().size())];
  dout << uh;
}
