% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\name{dbWriteTable,MySQLConnection,character,data.frame-method}
\alias{dbWriteTable,MySQLConnection,character,data.frame-method}
\alias{dbWriteTable,MySQLConnection,character,character-method}
\title{Write a local data frame or file to the database.}
\usage{
\S4method{dbWriteTable}{MySQLConnection,character,data.frame}(
  conn,
  name,
  value,
  field.types = NULL,
  row.names = TRUE,
  overwrite = FALSE,
  append = FALSE,
  ...,
  allow.keywords = FALSE
)

\S4method{dbWriteTable}{MySQLConnection,character,character}(
  conn,
  name,
  value,
  field.types = NULL,
  overwrite = FALSE,
  append = FALSE,
  header = TRUE,
  row.names = FALSE,
  nrows = 50,
  sep = ",",
  eol = "\\n",
  skip = 0,
  quote = "\\"",
  ...
)
}
\arguments{
\item{conn}{a \code{\linkS4class{MySQLConnection}} object, produced by
\code{\link[DBI]{dbConnect}}}

\item{name}{a character string specifying a table name.}

\item{value}{a data.frame (or coercible to data.frame) object or a
file name (character).  In the first case, the data.frame is
written to a temporary file and then imported to SQLite; when \code{value}
is a character, it is interpreted as a file name and its contents imported
to SQLite.}

\item{field.types}{character vector of named  SQL field types where
the names are the names of new table's columns. If missing, types inferred
with \code{\link[DBI]{dbDataType}}).}

\item{row.names}{A logical specifying whether the \code{row.names} should be
output to the output DBMS table; if \code{TRUE}, an extra field whose name
will be whatever the R identifier \code{"row.names"} maps to the DBMS (see
\code{\link[DBI]{make.db.names}}). If \code{NA} will add rows names if
they are characters, otherwise will ignore.}

\item{overwrite}{a logical specifying whether to overwrite an existing table
or not. Its default is \code{FALSE}. (See the BUGS section below)}

\item{append}{a logical specifying whether to append to an existing table
in the DBMS.  Its default is \code{FALSE}.}

\item{...}{Unused, needs for compatibility with generic.}

\item{allow.keywords}{logical indicating whether column names that happen to
be MySQL keywords be used as column names in the resulting relation (table)
being written. Defaults to FALSE, forcing mysqlWriteTable to modify column
names to make them legal MySQL identifiers.}

\item{header}{logical, does the input file have a header line? Default is the
same heuristic used by \code{read.table}, i.e., \code{TRUE} if the first
line has one fewer column that the second line.}

\item{nrows}{number of lines to rows to import using \code{read.table} from
the input file to create the proper table definition. Default is 50.}

\item{sep}{field separator character}

\item{eol}{End-of-line separator}

\item{skip}{number of lines to skip before reading data in the input file.}

\item{quote}{the quote character used in the input file (defaults to
\code{\"}.)}
}
\description{
Write a local data frame or file to the database.
}
