/* automatically generated by rust-bindgen 0.64.0 */

#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(transparent)]
#[derive(Default)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
#[repr(C)]
pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub const fn new() -> Self {
        __BindgenUnionField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::std::mem::transmute(self)
    }
}
impl<T> ::std::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
    fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
}
impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
    fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
        true
    }
}
impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
pub const __BITS_PER_LONG: u32 = 64;
pub const __BITS_PER_LONG_LONG: u32 = 64;
pub const __FD_SETSIZE: u32 = 1024;
pub const _IOC_NRBITS: u32 = 8;
pub const _IOC_TYPEBITS: u32 = 8;
pub const _IOC_SIZEBITS: u32 = 14;
pub const _IOC_DIRBITS: u32 = 2;
pub const _IOC_NRMASK: u32 = 255;
pub const _IOC_TYPEMASK: u32 = 255;
pub const _IOC_SIZEMASK: u32 = 16383;
pub const _IOC_DIRMASK: u32 = 3;
pub const _IOC_NRSHIFT: u32 = 0;
pub const _IOC_TYPESHIFT: u32 = 8;
pub const _IOC_SIZESHIFT: u32 = 16;
pub const _IOC_DIRSHIFT: u32 = 30;
pub const _IOC_NONE: u32 = 0;
pub const _IOC_WRITE: u32 = 1;
pub const _IOC_READ: u32 = 2;
pub const IOC_IN: u32 = 1073741824;
pub const IOC_OUT: u32 = 2147483648;
pub const IOC_INOUT: u32 = 3221225472;
pub const IOCSIZE_MASK: u32 = 1073676288;
pub const IOCSIZE_SHIFT: u32 = 16;
pub const KVM_PIO_PAGE_OFFSET: u32 = 1;
pub const KVM_COALESCED_MMIO_PAGE_OFFSET: u32 = 2;
pub const KVM_DIRTY_LOG_PAGE_OFFSET: u32 = 64;
pub const DE_VECTOR: u32 = 0;
pub const DB_VECTOR: u32 = 1;
pub const BP_VECTOR: u32 = 3;
pub const OF_VECTOR: u32 = 4;
pub const BR_VECTOR: u32 = 5;
pub const UD_VECTOR: u32 = 6;
pub const NM_VECTOR: u32 = 7;
pub const DF_VECTOR: u32 = 8;
pub const TS_VECTOR: u32 = 10;
pub const NP_VECTOR: u32 = 11;
pub const SS_VECTOR: u32 = 12;
pub const GP_VECTOR: u32 = 13;
pub const PF_VECTOR: u32 = 14;
pub const MF_VECTOR: u32 = 16;
pub const AC_VECTOR: u32 = 17;
pub const MC_VECTOR: u32 = 18;
pub const XM_VECTOR: u32 = 19;
pub const VE_VECTOR: u32 = 20;
pub const KVM_NR_INTERRUPTS: u32 = 256;
pub const KVM_IOAPIC_NUM_PINS: u32 = 24;
pub const KVM_IRQCHIP_PIC_MASTER: u32 = 0;
pub const KVM_IRQCHIP_PIC_SLAVE: u32 = 1;
pub const KVM_IRQCHIP_IOAPIC: u32 = 2;
pub const KVM_NR_IRQCHIPS: u32 = 3;
pub const KVM_RUN_X86_SMM: u32 = 1;
pub const KVM_RUN_X86_BUS_LOCK: u32 = 2;
pub const KVM_APIC_REG_SIZE: u32 = 1024;
pub const KVM_SREGS2_FLAGS_PDPTRS_VALID: u32 = 1;
pub const KVM_MSR_FILTER_MAX_BITMAP_SIZE: u32 = 1536;
pub const KVM_MSR_FILTER_READ: u32 = 1;
pub const KVM_MSR_FILTER_WRITE: u32 = 2;
pub const KVM_MSR_FILTER_RANGE_VALID_MASK: u32 = 3;
pub const KVM_MSR_FILTER_MAX_RANGES: u32 = 16;
pub const KVM_MSR_FILTER_DEFAULT_ALLOW: u32 = 0;
pub const KVM_MSR_FILTER_DEFAULT_DENY: u32 = 1;
pub const KVM_MSR_FILTER_VALID_MASK: u32 = 1;
pub const KVM_CPUID_FLAG_SIGNIFCANT_INDEX: u32 = 1;
pub const KVM_CPUID_FLAG_STATEFUL_FUNC: u32 = 2;
pub const KVM_CPUID_FLAG_STATE_READ_NEXT: u32 = 4;
pub const KVM_GUESTDBG_USE_SW_BP: u32 = 65536;
pub const KVM_GUESTDBG_USE_HW_BP: u32 = 131072;
pub const KVM_GUESTDBG_INJECT_DB: u32 = 262144;
pub const KVM_GUESTDBG_INJECT_BP: u32 = 524288;
pub const KVM_GUESTDBG_BLOCKIRQ: u32 = 1048576;
pub const KVM_PIT_FLAGS_HPET_LEGACY: u32 = 1;
pub const KVM_PIT_FLAGS_SPEAKER_DATA_ON: u32 = 2;
pub const KVM_VCPUEVENT_VALID_NMI_PENDING: u32 = 1;
pub const KVM_VCPUEVENT_VALID_SIPI_VECTOR: u32 = 2;
pub const KVM_VCPUEVENT_VALID_SHADOW: u32 = 4;
pub const KVM_VCPUEVENT_VALID_SMM: u32 = 8;
pub const KVM_VCPUEVENT_VALID_PAYLOAD: u32 = 16;
pub const KVM_VCPUEVENT_VALID_TRIPLE_FAULT: u32 = 32;
pub const KVM_X86_SHADOW_INT_MOV_SS: u32 = 1;
pub const KVM_X86_SHADOW_INT_STI: u32 = 2;
pub const KVM_MAX_XCRS: u32 = 16;
pub const KVM_SYNC_X86_REGS: u32 = 1;
pub const KVM_SYNC_X86_SREGS: u32 = 2;
pub const KVM_SYNC_X86_EVENTS: u32 = 4;
pub const KVM_SYNC_X86_VALID_FIELDS: u32 = 7;
pub const KVM_X86_QUIRK_LINT0_REENABLED: u32 = 1;
pub const KVM_X86_QUIRK_CD_NW_CLEARED: u32 = 2;
pub const KVM_X86_QUIRK_LAPIC_MMIO_HOLE: u32 = 4;
pub const KVM_X86_QUIRK_OUT_7E_INC_RIP: u32 = 8;
pub const KVM_X86_QUIRK_MISC_ENABLE_NO_MWAIT: u32 = 16;
pub const KVM_X86_QUIRK_FIX_HYPERCALL_INSN: u32 = 32;
pub const KVM_X86_QUIRK_MWAIT_NEVER_UD_FAULTS: u32 = 64;
pub const KVM_STATE_NESTED_FORMAT_VMX: u32 = 0;
pub const KVM_STATE_NESTED_FORMAT_SVM: u32 = 1;
pub const KVM_STATE_NESTED_GUEST_MODE: u32 = 1;
pub const KVM_STATE_NESTED_RUN_PENDING: u32 = 2;
pub const KVM_STATE_NESTED_EVMCS: u32 = 4;
pub const KVM_STATE_NESTED_MTF_PENDING: u32 = 8;
pub const KVM_STATE_NESTED_GIF_SET: u32 = 256;
pub const KVM_STATE_NESTED_SMM_GUEST_MODE: u32 = 1;
pub const KVM_STATE_NESTED_SMM_VMXON: u32 = 2;
pub const KVM_STATE_NESTED_VMX_VMCS_SIZE: u32 = 4096;
pub const KVM_STATE_NESTED_SVM_VMCB_SIZE: u32 = 4096;
pub const KVM_STATE_VMX_PREEMPTION_TIMER_DEADLINE: u32 = 1;
pub const KVM_X86_XCOMP_GUEST_SUPP: u32 = 0;
pub const KVM_PMU_EVENT_ALLOW: u32 = 0;
pub const KVM_PMU_EVENT_DENY: u32 = 1;
pub const KVM_XEN_HVM_CONFIG_HYPERCALL_MSR: u32 = 1;
pub const KVM_XEN_HVM_CONFIG_INTERCEPT_HCALL: u32 = 2;
pub const KVM_XEN_HVM_CONFIG_SHARED_INFO: u32 = 4;
pub const KVM_XEN_HVM_CONFIG_RUNSTATE: u32 = 8;
pub const KVM_XEN_HVM_CONFIG_EVTCHN_2LEVEL: u32 = 16;
pub const KVM_XEN_HVM_CONFIG_EVTCHN_SEND: u32 = 32;
pub const KVM_XEN_HVM_CONFIG_RUNSTATE_UPDATE_FLAG: u32 = 64;
pub const KVM_XEN_HVM_CONFIG_PVCLOCK_TSC_UNSTABLE: u32 = 128;
pub const KVM_XEN_HVM_CONFIG_SHARED_INFO_HVA: u32 = 256;
pub const KVM_XEN_EVTCHN_DEASSIGN: u32 = 1;
pub const KVM_XEN_EVTCHN_UPDATE: u32 = 2;
pub const KVM_XEN_EVTCHN_RESET: u32 = 4;
pub const KVM_XEN_ATTR_TYPE_LONG_MODE: u32 = 0;
pub const KVM_XEN_ATTR_TYPE_SHARED_INFO: u32 = 1;
pub const KVM_XEN_ATTR_TYPE_UPCALL_VECTOR: u32 = 2;
pub const KVM_XEN_ATTR_TYPE_EVTCHN: u32 = 3;
pub const KVM_XEN_ATTR_TYPE_XEN_VERSION: u32 = 4;
pub const KVM_XEN_ATTR_TYPE_RUNSTATE_UPDATE_FLAG: u32 = 5;
pub const KVM_XEN_ATTR_TYPE_SHARED_INFO_HVA: u32 = 6;
pub const KVM_XEN_VCPU_ATTR_TYPE_VCPU_INFO: u32 = 0;
pub const KVM_XEN_VCPU_ATTR_TYPE_VCPU_TIME_INFO: u32 = 1;
pub const KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_ADDR: u32 = 2;
pub const KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_CURRENT: u32 = 3;
pub const KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_DATA: u32 = 4;
pub const KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_ADJUST: u32 = 5;
pub const KVM_XEN_VCPU_ATTR_TYPE_VCPU_ID: u32 = 6;
pub const KVM_XEN_VCPU_ATTR_TYPE_TIMER: u32 = 7;
pub const KVM_XEN_VCPU_ATTR_TYPE_UPCALL_VECTOR: u32 = 8;
pub const KVM_XEN_VCPU_ATTR_TYPE_VCPU_INFO_HVA: u32 = 9;
pub const KVM_X2APIC_API_USE_32BIT_IDS: u32 = 1;
pub const KVM_X2APIC_API_DISABLE_BROADCAST_QUIRK: u32 = 2;
pub const KVM_HYPERV_CONN_ID_MASK: u32 = 16777215;
pub const KVM_HYPERV_EVENTFD_DEASSIGN: u32 = 1;
pub const KVM_PMU_MASKED_ENTRY_UMASK_MASK_SHIFT: u32 = 56;
pub const KVM_VCPU_TSC_CTRL: u32 = 0;
pub const KVM_VCPU_TSC_OFFSET: u32 = 0;
pub const KVM_X86_DEFAULT_VM: u32 = 0;
pub const KVM_X86_SW_PROTECTED_VM: u32 = 1;
pub const KVM_API_VERSION: u32 = 12;
pub const KVM_MEM_LOG_DIRTY_PAGES: u32 = 1;
pub const KVM_MEM_READONLY: u32 = 2;
pub const KVM_MEM_GUEST_MEMFD: u32 = 4;
pub const KVM_PIT_SPEAKER_DUMMY: u32 = 1;
pub const KVM_EXIT_HYPERV_SYNIC: u32 = 1;
pub const KVM_EXIT_HYPERV_HCALL: u32 = 2;
pub const KVM_EXIT_HYPERV_SYNDBG: u32 = 3;
pub const KVM_EXIT_XEN_HCALL: u32 = 1;
pub const KVM_S390_GET_SKEYS_NONE: u32 = 1;
pub const KVM_S390_SKEYS_MAX: u32 = 1048576;
pub const KVM_EXIT_UNKNOWN: u32 = 0;
pub const KVM_EXIT_EXCEPTION: u32 = 1;
pub const KVM_EXIT_IO: u32 = 2;
pub const KVM_EXIT_HYPERCALL: u32 = 3;
pub const KVM_EXIT_DEBUG: u32 = 4;
pub const KVM_EXIT_HLT: u32 = 5;
pub const KVM_EXIT_MMIO: u32 = 6;
pub const KVM_EXIT_IRQ_WINDOW_OPEN: u32 = 7;
pub const KVM_EXIT_SHUTDOWN: u32 = 8;
pub const KVM_EXIT_FAIL_ENTRY: u32 = 9;
pub const KVM_EXIT_INTR: u32 = 10;
pub const KVM_EXIT_SET_TPR: u32 = 11;
pub const KVM_EXIT_TPR_ACCESS: u32 = 12;
pub const KVM_EXIT_S390_SIEIC: u32 = 13;
pub const KVM_EXIT_S390_RESET: u32 = 14;
pub const KVM_EXIT_DCR: u32 = 15;
pub const KVM_EXIT_NMI: u32 = 16;
pub const KVM_EXIT_INTERNAL_ERROR: u32 = 17;
pub const KVM_EXIT_OSI: u32 = 18;
pub const KVM_EXIT_PAPR_HCALL: u32 = 19;
pub const KVM_EXIT_S390_UCONTROL: u32 = 20;
pub const KVM_EXIT_WATCHDOG: u32 = 21;
pub const KVM_EXIT_S390_TSCH: u32 = 22;
pub const KVM_EXIT_EPR: u32 = 23;
pub const KVM_EXIT_SYSTEM_EVENT: u32 = 24;
pub const KVM_EXIT_S390_STSI: u32 = 25;
pub const KVM_EXIT_IOAPIC_EOI: u32 = 26;
pub const KVM_EXIT_HYPERV: u32 = 27;
pub const KVM_EXIT_ARM_NISV: u32 = 28;
pub const KVM_EXIT_X86_RDMSR: u32 = 29;
pub const KVM_EXIT_X86_WRMSR: u32 = 30;
pub const KVM_EXIT_DIRTY_RING_FULL: u32 = 31;
pub const KVM_EXIT_AP_RESET_HOLD: u32 = 32;
pub const KVM_EXIT_X86_BUS_LOCK: u32 = 33;
pub const KVM_EXIT_XEN: u32 = 34;
pub const KVM_EXIT_RISCV_SBI: u32 = 35;
pub const KVM_EXIT_RISCV_CSR: u32 = 36;
pub const KVM_EXIT_NOTIFY: u32 = 37;
pub const KVM_EXIT_LOONGARCH_IOCSR: u32 = 38;
pub const KVM_EXIT_MEMORY_FAULT: u32 = 39;
pub const KVM_INTERNAL_ERROR_EMULATION: u32 = 1;
pub const KVM_INTERNAL_ERROR_SIMUL_EX: u32 = 2;
pub const KVM_INTERNAL_ERROR_DELIVERY_EV: u32 = 3;
pub const KVM_INTERNAL_ERROR_UNEXPECTED_EXIT_REASON: u32 = 4;
pub const KVM_INTERNAL_ERROR_EMULATION_FLAG_INSTRUCTION_BYTES: u32 = 1;
pub const KVM_EXIT_IO_IN: u32 = 0;
pub const KVM_EXIT_IO_OUT: u32 = 1;
pub const KVM_SYSTEM_EVENT_SHUTDOWN: u32 = 1;
pub const KVM_SYSTEM_EVENT_RESET: u32 = 2;
pub const KVM_SYSTEM_EVENT_CRASH: u32 = 3;
pub const KVM_SYSTEM_EVENT_WAKEUP: u32 = 4;
pub const KVM_SYSTEM_EVENT_SUSPEND: u32 = 5;
pub const KVM_SYSTEM_EVENT_SEV_TERM: u32 = 6;
pub const KVM_MSR_EXIT_REASON_INVAL: u32 = 1;
pub const KVM_MSR_EXIT_REASON_UNKNOWN: u32 = 2;
pub const KVM_MSR_EXIT_REASON_FILTER: u32 = 4;
pub const KVM_MSR_EXIT_REASON_VALID_MASK: u32 = 7;
pub const KVM_NOTIFY_CONTEXT_INVALID: u32 = 1;
pub const KVM_MEMORY_EXIT_FLAG_PRIVATE: u32 = 8;
pub const SYNC_REGS_SIZE_BYTES: u32 = 2048;
pub const KVM_MP_STATE_RUNNABLE: u32 = 0;
pub const KVM_MP_STATE_UNINITIALIZED: u32 = 1;
pub const KVM_MP_STATE_INIT_RECEIVED: u32 = 2;
pub const KVM_MP_STATE_HALTED: u32 = 3;
pub const KVM_MP_STATE_SIPI_RECEIVED: u32 = 4;
pub const KVM_MP_STATE_STOPPED: u32 = 5;
pub const KVM_MP_STATE_CHECK_STOP: u32 = 6;
pub const KVM_MP_STATE_OPERATING: u32 = 7;
pub const KVM_MP_STATE_LOAD: u32 = 8;
pub const KVM_MP_STATE_AP_RESET_HOLD: u32 = 9;
pub const KVM_MP_STATE_SUSPENDED: u32 = 10;
pub const KVM_GUESTDBG_ENABLE: u32 = 1;
pub const KVM_GUESTDBG_SINGLESTEP: u32 = 2;
pub const KVM_X86_DISABLE_EXITS_MWAIT: u32 = 1;
pub const KVM_X86_DISABLE_EXITS_HLT: u32 = 2;
pub const KVM_X86_DISABLE_EXITS_PAUSE: u32 = 4;
pub const KVM_X86_DISABLE_EXITS_CSTATE: u32 = 8;
pub const KVM_X86_DISABLE_VALID_EXITS: u32 = 15;
pub const KVMIO: u32 = 174;
pub const KVM_VM_S390_UCONTROL: u32 = 1;
pub const KVM_VM_PPC_HV: u32 = 1;
pub const KVM_VM_PPC_PR: u32 = 2;
pub const KVM_VM_MIPS_AUTO: u32 = 0;
pub const KVM_VM_MIPS_VZ: u32 = 1;
pub const KVM_VM_MIPS_TE: u32 = 2;
pub const KVM_S390_SIE_PAGE_OFFSET: u32 = 1;
pub const KVM_VM_TYPE_ARM_IPA_SIZE_MASK: u32 = 255;
pub const KVM_CAP_IRQCHIP: u32 = 0;
pub const KVM_CAP_HLT: u32 = 1;
pub const KVM_CAP_MMU_SHADOW_CACHE_CONTROL: u32 = 2;
pub const KVM_CAP_USER_MEMORY: u32 = 3;
pub const KVM_CAP_SET_TSS_ADDR: u32 = 4;
pub const KVM_CAP_VAPIC: u32 = 6;
pub const KVM_CAP_EXT_CPUID: u32 = 7;
pub const KVM_CAP_CLOCKSOURCE: u32 = 8;
pub const KVM_CAP_NR_VCPUS: u32 = 9;
pub const KVM_CAP_NR_MEMSLOTS: u32 = 10;
pub const KVM_CAP_PIT: u32 = 11;
pub const KVM_CAP_NOP_IO_DELAY: u32 = 12;
pub const KVM_CAP_PV_MMU: u32 = 13;
pub const KVM_CAP_MP_STATE: u32 = 14;
pub const KVM_CAP_COALESCED_MMIO: u32 = 15;
pub const KVM_CAP_SYNC_MMU: u32 = 16;
pub const KVM_CAP_IOMMU: u32 = 18;
pub const KVM_CAP_DESTROY_MEMORY_REGION_WORKS: u32 = 21;
pub const KVM_CAP_USER_NMI: u32 = 22;
pub const KVM_CAP_SET_GUEST_DEBUG: u32 = 23;
pub const KVM_CAP_REINJECT_CONTROL: u32 = 24;
pub const KVM_CAP_IRQ_ROUTING: u32 = 25;
pub const KVM_CAP_IRQ_INJECT_STATUS: u32 = 26;
pub const KVM_CAP_ASSIGN_DEV_IRQ: u32 = 29;
pub const KVM_CAP_JOIN_MEMORY_REGIONS_WORKS: u32 = 30;
pub const KVM_CAP_MCE: u32 = 31;
pub const KVM_CAP_IRQFD: u32 = 32;
pub const KVM_CAP_PIT2: u32 = 33;
pub const KVM_CAP_SET_BOOT_CPU_ID: u32 = 34;
pub const KVM_CAP_PIT_STATE2: u32 = 35;
pub const KVM_CAP_IOEVENTFD: u32 = 36;
pub const KVM_CAP_SET_IDENTITY_MAP_ADDR: u32 = 37;
pub const KVM_CAP_XEN_HVM: u32 = 38;
pub const KVM_CAP_ADJUST_CLOCK: u32 = 39;
pub const KVM_CAP_INTERNAL_ERROR_DATA: u32 = 40;
pub const KVM_CAP_VCPU_EVENTS: u32 = 41;
pub const KVM_CAP_S390_PSW: u32 = 42;
pub const KVM_CAP_PPC_SEGSTATE: u32 = 43;
pub const KVM_CAP_HYPERV: u32 = 44;
pub const KVM_CAP_HYPERV_VAPIC: u32 = 45;
pub const KVM_CAP_HYPERV_SPIN: u32 = 46;
pub const KVM_CAP_PCI_SEGMENT: u32 = 47;
pub const KVM_CAP_PPC_PAIRED_SINGLES: u32 = 48;
pub const KVM_CAP_INTR_SHADOW: u32 = 49;
pub const KVM_CAP_DEBUGREGS: u32 = 50;
pub const KVM_CAP_X86_ROBUST_SINGLESTEP: u32 = 51;
pub const KVM_CAP_PPC_OSI: u32 = 52;
pub const KVM_CAP_PPC_UNSET_IRQ: u32 = 53;
pub const KVM_CAP_ENABLE_CAP: u32 = 54;
pub const KVM_CAP_XSAVE: u32 = 55;
pub const KVM_CAP_XCRS: u32 = 56;
pub const KVM_CAP_PPC_GET_PVINFO: u32 = 57;
pub const KVM_CAP_PPC_IRQ_LEVEL: u32 = 58;
pub const KVM_CAP_ASYNC_PF: u32 = 59;
pub const KVM_CAP_TSC_CONTROL: u32 = 60;
pub const KVM_CAP_GET_TSC_KHZ: u32 = 61;
pub const KVM_CAP_PPC_BOOKE_SREGS: u32 = 62;
pub const KVM_CAP_SPAPR_TCE: u32 = 63;
pub const KVM_CAP_PPC_SMT: u32 = 64;
pub const KVM_CAP_PPC_RMA: u32 = 65;
pub const KVM_CAP_MAX_VCPUS: u32 = 66;
pub const KVM_CAP_PPC_HIOR: u32 = 67;
pub const KVM_CAP_PPC_PAPR: u32 = 68;
pub const KVM_CAP_SW_TLB: u32 = 69;
pub const KVM_CAP_ONE_REG: u32 = 70;
pub const KVM_CAP_S390_GMAP: u32 = 71;
pub const KVM_CAP_TSC_DEADLINE_TIMER: u32 = 72;
pub const KVM_CAP_S390_UCONTROL: u32 = 73;
pub const KVM_CAP_SYNC_REGS: u32 = 74;
pub const KVM_CAP_PCI_2_3: u32 = 75;
pub const KVM_CAP_KVMCLOCK_CTRL: u32 = 76;
pub const KVM_CAP_SIGNAL_MSI: u32 = 77;
pub const KVM_CAP_PPC_GET_SMMU_INFO: u32 = 78;
pub const KVM_CAP_S390_COW: u32 = 79;
pub const KVM_CAP_PPC_ALLOC_HTAB: u32 = 80;
pub const KVM_CAP_READONLY_MEM: u32 = 81;
pub const KVM_CAP_IRQFD_RESAMPLE: u32 = 82;
pub const KVM_CAP_PPC_BOOKE_WATCHDOG: u32 = 83;
pub const KVM_CAP_PPC_HTAB_FD: u32 = 84;
pub const KVM_CAP_S390_CSS_SUPPORT: u32 = 85;
pub const KVM_CAP_PPC_EPR: u32 = 86;
pub const KVM_CAP_ARM_PSCI: u32 = 87;
pub const KVM_CAP_ARM_SET_DEVICE_ADDR: u32 = 88;
pub const KVM_CAP_DEVICE_CTRL: u32 = 89;
pub const KVM_CAP_IRQ_MPIC: u32 = 90;
pub const KVM_CAP_PPC_RTAS: u32 = 91;
pub const KVM_CAP_IRQ_XICS: u32 = 92;
pub const KVM_CAP_ARM_EL1_32BIT: u32 = 93;
pub const KVM_CAP_SPAPR_MULTITCE: u32 = 94;
pub const KVM_CAP_EXT_EMUL_CPUID: u32 = 95;
pub const KVM_CAP_HYPERV_TIME: u32 = 96;
pub const KVM_CAP_IOAPIC_POLARITY_IGNORED: u32 = 97;
pub const KVM_CAP_ENABLE_CAP_VM: u32 = 98;
pub const KVM_CAP_S390_IRQCHIP: u32 = 99;
pub const KVM_CAP_IOEVENTFD_NO_LENGTH: u32 = 100;
pub const KVM_CAP_VM_ATTRIBUTES: u32 = 101;
pub const KVM_CAP_ARM_PSCI_0_2: u32 = 102;
pub const KVM_CAP_PPC_FIXUP_HCALL: u32 = 103;
pub const KVM_CAP_PPC_ENABLE_HCALL: u32 = 104;
pub const KVM_CAP_CHECK_EXTENSION_VM: u32 = 105;
pub const KVM_CAP_S390_USER_SIGP: u32 = 106;
pub const KVM_CAP_S390_VECTOR_REGISTERS: u32 = 107;
pub const KVM_CAP_S390_MEM_OP: u32 = 108;
pub const KVM_CAP_S390_USER_STSI: u32 = 109;
pub const KVM_CAP_S390_SKEYS: u32 = 110;
pub const KVM_CAP_MIPS_FPU: u32 = 111;
pub const KVM_CAP_MIPS_MSA: u32 = 112;
pub const KVM_CAP_S390_INJECT_IRQ: u32 = 113;
pub const KVM_CAP_S390_IRQ_STATE: u32 = 114;
pub const KVM_CAP_PPC_HWRNG: u32 = 115;
pub const KVM_CAP_DISABLE_QUIRKS: u32 = 116;
pub const KVM_CAP_X86_SMM: u32 = 117;
pub const KVM_CAP_MULTI_ADDRESS_SPACE: u32 = 118;
pub const KVM_CAP_GUEST_DEBUG_HW_BPS: u32 = 119;
pub const KVM_CAP_GUEST_DEBUG_HW_WPS: u32 = 120;
pub const KVM_CAP_SPLIT_IRQCHIP: u32 = 121;
pub const KVM_CAP_IOEVENTFD_ANY_LENGTH: u32 = 122;
pub const KVM_CAP_HYPERV_SYNIC: u32 = 123;
pub const KVM_CAP_S390_RI: u32 = 124;
pub const KVM_CAP_SPAPR_TCE_64: u32 = 125;
pub const KVM_CAP_ARM_PMU_V3: u32 = 126;
pub const KVM_CAP_VCPU_ATTRIBUTES: u32 = 127;
pub const KVM_CAP_MAX_VCPU_ID: u32 = 128;
pub const KVM_CAP_X2APIC_API: u32 = 129;
pub const KVM_CAP_S390_USER_INSTR0: u32 = 130;
pub const KVM_CAP_MSI_DEVID: u32 = 131;
pub const KVM_CAP_PPC_HTM: u32 = 132;
pub const KVM_CAP_SPAPR_RESIZE_HPT: u32 = 133;
pub const KVM_CAP_PPC_MMU_RADIX: u32 = 134;
pub const KVM_CAP_PPC_MMU_HASH_V3: u32 = 135;
pub const KVM_CAP_IMMEDIATE_EXIT: u32 = 136;
pub const KVM_CAP_MIPS_VZ: u32 = 137;
pub const KVM_CAP_MIPS_TE: u32 = 138;
pub const KVM_CAP_MIPS_64BIT: u32 = 139;
pub const KVM_CAP_S390_GS: u32 = 140;
pub const KVM_CAP_S390_AIS: u32 = 141;
pub const KVM_CAP_SPAPR_TCE_VFIO: u32 = 142;
pub const KVM_CAP_X86_DISABLE_EXITS: u32 = 143;
pub const KVM_CAP_ARM_USER_IRQ: u32 = 144;
pub const KVM_CAP_S390_CMMA_MIGRATION: u32 = 145;
pub const KVM_CAP_PPC_FWNMI: u32 = 146;
pub const KVM_CAP_PPC_SMT_POSSIBLE: u32 = 147;
pub const KVM_CAP_HYPERV_SYNIC2: u32 = 148;
pub const KVM_CAP_HYPERV_VP_INDEX: u32 = 149;
pub const KVM_CAP_S390_AIS_MIGRATION: u32 = 150;
pub const KVM_CAP_PPC_GET_CPU_CHAR: u32 = 151;
pub const KVM_CAP_S390_BPB: u32 = 152;
pub const KVM_CAP_GET_MSR_FEATURES: u32 = 153;
pub const KVM_CAP_HYPERV_EVENTFD: u32 = 154;
pub const KVM_CAP_HYPERV_TLBFLUSH: u32 = 155;
pub const KVM_CAP_S390_HPAGE_1M: u32 = 156;
pub const KVM_CAP_NESTED_STATE: u32 = 157;
pub const KVM_CAP_ARM_INJECT_SERROR_ESR: u32 = 158;
pub const KVM_CAP_MSR_PLATFORM_INFO: u32 = 159;
pub const KVM_CAP_PPC_NESTED_HV: u32 = 160;
pub const KVM_CAP_HYPERV_SEND_IPI: u32 = 161;
pub const KVM_CAP_COALESCED_PIO: u32 = 162;
pub const KVM_CAP_HYPERV_ENLIGHTENED_VMCS: u32 = 163;
pub const KVM_CAP_EXCEPTION_PAYLOAD: u32 = 164;
pub const KVM_CAP_ARM_VM_IPA_SIZE: u32 = 165;
pub const KVM_CAP_MANUAL_DIRTY_LOG_PROTECT: u32 = 166;
pub const KVM_CAP_HYPERV_CPUID: u32 = 167;
pub const KVM_CAP_MANUAL_DIRTY_LOG_PROTECT2: u32 = 168;
pub const KVM_CAP_PPC_IRQ_XIVE: u32 = 169;
pub const KVM_CAP_ARM_SVE: u32 = 170;
pub const KVM_CAP_ARM_PTRAUTH_ADDRESS: u32 = 171;
pub const KVM_CAP_ARM_PTRAUTH_GENERIC: u32 = 172;
pub const KVM_CAP_PMU_EVENT_FILTER: u32 = 173;
pub const KVM_CAP_ARM_IRQ_LINE_LAYOUT_2: u32 = 174;
pub const KVM_CAP_HYPERV_DIRECT_TLBFLUSH: u32 = 175;
pub const KVM_CAP_PPC_GUEST_DEBUG_SSTEP: u32 = 176;
pub const KVM_CAP_ARM_NISV_TO_USER: u32 = 177;
pub const KVM_CAP_ARM_INJECT_EXT_DABT: u32 = 178;
pub const KVM_CAP_S390_VCPU_RESETS: u32 = 179;
pub const KVM_CAP_S390_PROTECTED: u32 = 180;
pub const KVM_CAP_PPC_SECURE_GUEST: u32 = 181;
pub const KVM_CAP_HALT_POLL: u32 = 182;
pub const KVM_CAP_ASYNC_PF_INT: u32 = 183;
pub const KVM_CAP_LAST_CPU: u32 = 184;
pub const KVM_CAP_SMALLER_MAXPHYADDR: u32 = 185;
pub const KVM_CAP_S390_DIAG318: u32 = 186;
pub const KVM_CAP_STEAL_TIME: u32 = 187;
pub const KVM_CAP_X86_USER_SPACE_MSR: u32 = 188;
pub const KVM_CAP_X86_MSR_FILTER: u32 = 189;
pub const KVM_CAP_ENFORCE_PV_FEATURE_CPUID: u32 = 190;
pub const KVM_CAP_SYS_HYPERV_CPUID: u32 = 191;
pub const KVM_CAP_DIRTY_LOG_RING: u32 = 192;
pub const KVM_CAP_X86_BUS_LOCK_EXIT: u32 = 193;
pub const KVM_CAP_PPC_DAWR1: u32 = 194;
pub const KVM_CAP_SET_GUEST_DEBUG2: u32 = 195;
pub const KVM_CAP_SGX_ATTRIBUTE: u32 = 196;
pub const KVM_CAP_VM_COPY_ENC_CONTEXT_FROM: u32 = 197;
pub const KVM_CAP_PTP_KVM: u32 = 198;
pub const KVM_CAP_HYPERV_ENFORCE_CPUID: u32 = 199;
pub const KVM_CAP_SREGS2: u32 = 200;
pub const KVM_CAP_EXIT_HYPERCALL: u32 = 201;
pub const KVM_CAP_PPC_RPT_INVALIDATE: u32 = 202;
pub const KVM_CAP_BINARY_STATS_FD: u32 = 203;
pub const KVM_CAP_EXIT_ON_EMULATION_FAILURE: u32 = 204;
pub const KVM_CAP_ARM_MTE: u32 = 205;
pub const KVM_CAP_VM_MOVE_ENC_CONTEXT_FROM: u32 = 206;
pub const KVM_CAP_VM_GPA_BITS: u32 = 207;
pub const KVM_CAP_XSAVE2: u32 = 208;
pub const KVM_CAP_SYS_ATTRIBUTES: u32 = 209;
pub const KVM_CAP_PPC_AIL_MODE_3: u32 = 210;
pub const KVM_CAP_S390_MEM_OP_EXTENSION: u32 = 211;
pub const KVM_CAP_PMU_CAPABILITY: u32 = 212;
pub const KVM_CAP_DISABLE_QUIRKS2: u32 = 213;
pub const KVM_CAP_VM_TSC_CONTROL: u32 = 214;
pub const KVM_CAP_SYSTEM_EVENT_DATA: u32 = 215;
pub const KVM_CAP_ARM_SYSTEM_SUSPEND: u32 = 216;
pub const KVM_CAP_S390_PROTECTED_DUMP: u32 = 217;
pub const KVM_CAP_X86_TRIPLE_FAULT_EVENT: u32 = 218;
pub const KVM_CAP_X86_NOTIFY_VMEXIT: u32 = 219;
pub const KVM_CAP_VM_DISABLE_NX_HUGE_PAGES: u32 = 220;
pub const KVM_CAP_S390_ZPCI_OP: u32 = 221;
pub const KVM_CAP_S390_CPU_TOPOLOGY: u32 = 222;
pub const KVM_CAP_DIRTY_LOG_RING_ACQ_REL: u32 = 223;
pub const KVM_CAP_S390_PROTECTED_ASYNC_DISABLE: u32 = 224;
pub const KVM_CAP_DIRTY_LOG_RING_WITH_BITMAP: u32 = 225;
pub const KVM_CAP_PMU_EVENT_MASKED_EVENTS: u32 = 226;
pub const KVM_CAP_COUNTER_OFFSET: u32 = 227;
pub const KVM_CAP_ARM_EAGER_SPLIT_CHUNK_SIZE: u32 = 228;
pub const KVM_CAP_ARM_SUPPORTED_BLOCK_SIZES: u32 = 229;
pub const KVM_CAP_ARM_SUPPORTED_REG_MASK_RANGES: u32 = 230;
pub const KVM_CAP_USER_MEMORY2: u32 = 231;
pub const KVM_CAP_MEMORY_FAULT_INFO: u32 = 232;
pub const KVM_CAP_MEMORY_ATTRIBUTES: u32 = 233;
pub const KVM_CAP_GUEST_MEMFD: u32 = 234;
pub const KVM_CAP_VM_TYPES: u32 = 235;
pub const KVM_IRQ_ROUTING_IRQCHIP: u32 = 1;
pub const KVM_IRQ_ROUTING_MSI: u32 = 2;
pub const KVM_IRQ_ROUTING_S390_ADAPTER: u32 = 3;
pub const KVM_IRQ_ROUTING_HV_SINT: u32 = 4;
pub const KVM_IRQ_ROUTING_XEN_EVTCHN: u32 = 5;
pub const KVM_IRQFD_FLAG_DEASSIGN: u32 = 1;
pub const KVM_IRQFD_FLAG_RESAMPLE: u32 = 2;
pub const KVM_CLOCK_TSC_STABLE: u32 = 2;
pub const KVM_CLOCK_REALTIME: u32 = 4;
pub const KVM_CLOCK_HOST_TSC: u32 = 8;
pub const KVM_MMU_FSL_BOOKE_NOHV: u32 = 0;
pub const KVM_MMU_FSL_BOOKE_HV: u32 = 1;
pub const KVM_REG_ARCH_MASK: i64 = -72057594037927936;
pub const KVM_REG_GENERIC: u32 = 0;
pub const KVM_REG_PPC: u64 = 1152921504606846976;
pub const KVM_REG_X86: u64 = 2305843009213693952;
pub const KVM_REG_IA64: u64 = 3458764513820540928;
pub const KVM_REG_ARM: u64 = 4611686018427387904;
pub const KVM_REG_S390: u64 = 5764607523034234880;
pub const KVM_REG_ARM64: u64 = 6917529027641081856;
pub const KVM_REG_MIPS: u64 = 8070450532247928832;
pub const KVM_REG_RISCV: i64 = -9223372036854775808;
pub const KVM_REG_LOONGARCH: i64 = -8070450532247928832;
pub const KVM_REG_SIZE_SHIFT: u32 = 52;
pub const KVM_REG_SIZE_MASK: u64 = 67553994410557440;
pub const KVM_REG_SIZE_U8: u32 = 0;
pub const KVM_REG_SIZE_U16: u64 = 4503599627370496;
pub const KVM_REG_SIZE_U32: u64 = 9007199254740992;
pub const KVM_REG_SIZE_U64: u64 = 13510798882111488;
pub const KVM_REG_SIZE_U128: u64 = 18014398509481984;
pub const KVM_REG_SIZE_U256: u64 = 22517998136852480;
pub const KVM_REG_SIZE_U512: u64 = 27021597764222976;
pub const KVM_REG_SIZE_U1024: u64 = 31525197391593472;
pub const KVM_REG_SIZE_U2048: u64 = 36028797018963968;
pub const KVM_MSI_VALID_DEVID: u32 = 1;
pub const KVM_CREATE_DEVICE_TEST: u32 = 1;
pub const KVM_DEV_VFIO_FILE: u32 = 1;
pub const KVM_DEV_VFIO_FILE_ADD: u32 = 1;
pub const KVM_DEV_VFIO_FILE_DEL: u32 = 2;
pub const KVM_DEV_VFIO_GROUP: u32 = 1;
pub const KVM_DEV_VFIO_GROUP_ADD: u32 = 1;
pub const KVM_DEV_VFIO_GROUP_DEL: u32 = 2;
pub const KVM_DEV_VFIO_GROUP_SET_SPAPR_TCE: u32 = 3;
pub const KVM_S390_STORE_STATUS_NOADDR: i32 = -1;
pub const KVM_S390_STORE_STATUS_PREFIXED: i32 = -2;
pub const KVM_DIRTY_LOG_MANUAL_PROTECT_ENABLE: u32 = 1;
pub const KVM_DIRTY_LOG_INITIALLY_SET: u32 = 2;
pub const KVM_DIRTY_GFN_F_MASK: u32 = 3;
pub const KVM_BUS_LOCK_DETECTION_OFF: u32 = 1;
pub const KVM_BUS_LOCK_DETECTION_EXIT: u32 = 2;
pub const KVM_PMU_CAP_DISABLE: u32 = 1;
pub const KVM_STATS_TYPE_SHIFT: u32 = 0;
pub const KVM_STATS_TYPE_MASK: u32 = 15;
pub const KVM_STATS_TYPE_CUMULATIVE: u32 = 0;
pub const KVM_STATS_TYPE_INSTANT: u32 = 1;
pub const KVM_STATS_TYPE_PEAK: u32 = 2;
pub const KVM_STATS_TYPE_LINEAR_HIST: u32 = 3;
pub const KVM_STATS_TYPE_LOG_HIST: u32 = 4;
pub const KVM_STATS_TYPE_MAX: u32 = 4;
pub const KVM_STATS_UNIT_SHIFT: u32 = 4;
pub const KVM_STATS_UNIT_MASK: u32 = 240;
pub const KVM_STATS_UNIT_NONE: u32 = 0;
pub const KVM_STATS_UNIT_BYTES: u32 = 16;
pub const KVM_STATS_UNIT_SECONDS: u32 = 32;
pub const KVM_STATS_UNIT_CYCLES: u32 = 48;
pub const KVM_STATS_UNIT_BOOLEAN: u32 = 64;
pub const KVM_STATS_UNIT_MAX: u32 = 64;
pub const KVM_STATS_BASE_SHIFT: u32 = 8;
pub const KVM_STATS_BASE_MASK: u32 = 3840;
pub const KVM_STATS_BASE_POW10: u32 = 0;
pub const KVM_STATS_BASE_POW2: u32 = 256;
pub const KVM_STATS_BASE_MAX: u32 = 256;
pub const KVM_X86_NOTIFY_VMEXIT_ENABLED: u32 = 1;
pub const KVM_X86_NOTIFY_VMEXIT_USER: u32 = 2;
pub const KVM_MEMORY_ATTRIBUTE_PRIVATE: u32 = 8;
pub type __s8 = ::std::os::raw::c_schar;
pub type __u8 = ::std::os::raw::c_uchar;
pub type __s16 = ::std::os::raw::c_short;
pub type __u16 = ::std::os::raw::c_ushort;
pub type __s32 = ::std::os::raw::c_int;
pub type __u32 = ::std::os::raw::c_uint;
pub type __s64 = ::std::os::raw::c_longlong;
pub type __u64 = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __kernel_fd_set {
    pub fds_bits: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___kernel_fd_set() {
    const UNINIT: ::std::mem::MaybeUninit<__kernel_fd_set> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__kernel_fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fds_bits) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_fd_set),
            "::",
            stringify!(fds_bits)
        )
    );
}
pub type __kernel_sighandler_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type __kernel_key_t = ::std::os::raw::c_int;
pub type __kernel_mqd_t = ::std::os::raw::c_int;
pub type __kernel_old_uid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_gid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_dev_t = ::std::os::raw::c_ulong;
pub type __kernel_long_t = ::std::os::raw::c_long;
pub type __kernel_ulong_t = ::std::os::raw::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_mode_t = ::std::os::raw::c_uint;
pub type __kernel_pid_t = ::std::os::raw::c_int;
pub type __kernel_ipc_pid_t = ::std::os::raw::c_int;
pub type __kernel_uid_t = ::std::os::raw::c_uint;
pub type __kernel_gid_t = ::std::os::raw::c_uint;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::std::os::raw::c_int;
pub type __kernel_uid32_t = ::std::os::raw::c_uint;
pub type __kernel_gid32_t = ::std::os::raw::c_uint;
pub type __kernel_size_t = __kernel_ulong_t;
pub type __kernel_ssize_t = __kernel_long_t;
pub type __kernel_ptrdiff_t = __kernel_long_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __kernel_fsid_t {
    pub val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___kernel_fsid_t() {
    const UNINIT: ::std::mem::MaybeUninit<__kernel_fsid_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__kernel_fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).val) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_fsid_t),
            "::",
            stringify!(val)
        )
    );
}
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::std::os::raw::c_longlong;
pub type __kernel_old_time_t = __kernel_long_t;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_time64_t = ::std::os::raw::c_longlong;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::std::os::raw::c_int;
pub type __kernel_clockid_t = ::std::os::raw::c_int;
pub type __kernel_caddr_t = *mut ::std::os::raw::c_char;
pub type __kernel_uid16_t = ::std::os::raw::c_ushort;
pub type __kernel_gid16_t = ::std::os::raw::c_ushort;
pub type __s128 = i128;
pub type __u128 = u128;
pub type __le16 = __u16;
pub type __be16 = __u16;
pub type __le32 = __u32;
pub type __be32 = __u32;
pub type __le64 = __u64;
pub type __be64 = __u64;
pub type __sum16 = __u16;
pub type __wsum = __u32;
pub type __poll_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_pic_state {
    pub last_irr: __u8,
    pub irr: __u8,
    pub imr: __u8,
    pub isr: __u8,
    pub priority_add: __u8,
    pub irq_base: __u8,
    pub read_reg_select: __u8,
    pub poll: __u8,
    pub special_mask: __u8,
    pub init_state: __u8,
    pub auto_eoi: __u8,
    pub rotate_on_auto_eoi: __u8,
    pub special_fully_nested_mode: __u8,
    pub init4: __u8,
    pub elcr: __u8,
    pub elcr_mask: __u8,
}
#[test]
fn bindgen_test_layout_kvm_pic_state() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_pic_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_pic_state>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_pic_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_pic_state>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_pic_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_irr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(last_irr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).irr) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(irr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).imr) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(imr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).isr) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(isr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).priority_add) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(priority_add)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).irq_base) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(irq_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_reg_select) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(read_reg_select)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).poll) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(poll)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).special_mask) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(special_mask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).init_state) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(init_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).auto_eoi) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(auto_eoi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rotate_on_auto_eoi) as usize - ptr as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(rotate_on_auto_eoi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).special_fully_nested_mode) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(special_fully_nested_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).init4) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(init4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).elcr) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(elcr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).elcr_mask) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pic_state),
            "::",
            stringify!(elcr_mask)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_ioapic_state {
    pub base_address: __u64,
    pub ioregsel: __u32,
    pub id: __u32,
    pub irr: __u32,
    pub pad: __u32,
    pub redirtbl: [kvm_ioapic_state__bindgen_ty_1; 24usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub union kvm_ioapic_state__bindgen_ty_1 {
    pub bits: __u64,
    pub fields: kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1 {
    pub vector: __u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub reserved: [__u8; 4usize],
    pub dest_id: __u8,
}
#[test]
fn bindgen_test_layout_kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vector) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(vector)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dest_id) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dest_id)
        )
    );
}
impl kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn delivery_mode(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_delivery_mode(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn dest_mode(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_dest_mode(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn delivery_status(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_delivery_status(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn polarity(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_polarity(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn remote_irr(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_remote_irr(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn trig_mode(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_trig_mode(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mask(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_mask(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserve(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 7u8) as u8) }
    }
    #[inline]
    pub fn set_reserve(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        delivery_mode: __u8,
        dest_mode: __u8,
        delivery_status: __u8,
        polarity: __u8,
        remote_irr: __u8,
        trig_mode: __u8,
        mask: __u8,
        reserve: __u8,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let delivery_mode: u8 = unsafe { ::std::mem::transmute(delivery_mode) };
            delivery_mode as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let dest_mode: u8 = unsafe { ::std::mem::transmute(dest_mode) };
            dest_mode as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let delivery_status: u8 = unsafe { ::std::mem::transmute(delivery_status) };
            delivery_status as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let polarity: u8 = unsafe { ::std::mem::transmute(polarity) };
            polarity as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let remote_irr: u8 = unsafe { ::std::mem::transmute(remote_irr) };
            remote_irr as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let trig_mode: u8 = unsafe { ::std::mem::transmute(trig_mode) };
            trig_mode as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let mask: u8 = unsafe { ::std::mem::transmute(mask) };
            mask as u64
        });
        __bindgen_bitfield_unit.set(9usize, 7u8, {
            let reserve: u8 = unsafe { ::std::mem::transmute(reserve) };
            reserve as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_kvm_ioapic_state__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_ioapic_state__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_ioapic_state__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_ioapic_state__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ioapic_state__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_ioapic_state__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bits) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioapic_state__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fields) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioapic_state__bindgen_ty_1),
            "::",
            stringify!(fields)
        )
    );
}
impl Default for kvm_ioapic_state__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_ioapic_state__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_ioapic_state__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_ioapic_state() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_ioapic_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_ioapic_state>(),
        216usize,
        concat!("Size of: ", stringify!(kvm_ioapic_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ioapic_state>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_ioapic_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).base_address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioapic_state),
            "::",
            stringify!(base_address)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ioregsel) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioapic_state),
            "::",
            stringify!(ioregsel)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioapic_state),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).irr) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioapic_state),
            "::",
            stringify!(irr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioapic_state),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).redirtbl) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioapic_state),
            "::",
            stringify!(redirtbl)
        )
    );
}
impl Default for kvm_ioapic_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_ioapic_state {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_ioapic_state {{ base_address: {:?}, ioregsel: {:?}, id: {:?}, irr: {:?}, pad: {:?}, redirtbl: {:?} }}" , self . base_address , self . ioregsel , self . id , self . irr , self . pad , self . redirtbl)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_regs {
    pub rax: __u64,
    pub rbx: __u64,
    pub rcx: __u64,
    pub rdx: __u64,
    pub rsi: __u64,
    pub rdi: __u64,
    pub rsp: __u64,
    pub rbp: __u64,
    pub r8: __u64,
    pub r9: __u64,
    pub r10: __u64,
    pub r11: __u64,
    pub r12: __u64,
    pub r13: __u64,
    pub r14: __u64,
    pub r15: __u64,
    pub rip: __u64,
    pub rflags: __u64,
}
#[test]
fn bindgen_test_layout_kvm_regs() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_regs> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_regs>(),
        144usize,
        concat!("Size of: ", stringify!(kvm_regs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_regs>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_regs))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rax) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(rax)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rbx) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(rbx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rcx) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(rcx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rdx) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(rdx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rsi) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(rsi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rdi) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(rdi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rsp) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(rsp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rbp) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(rbp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r8) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(r8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r9) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(r9)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r10) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(r10)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r11) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(r11)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r12) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(r12)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r13) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(r13)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r14) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(r14)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r15) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(r15)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rip) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rflags) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(rflags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_lapic_state {
    pub regs: [::std::os::raw::c_char; 1024usize],
}
#[test]
fn bindgen_test_layout_kvm_lapic_state() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_lapic_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_lapic_state>(),
        1024usize,
        concat!("Size of: ", stringify!(kvm_lapic_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_lapic_state>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_lapic_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).regs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_lapic_state),
            "::",
            stringify!(regs)
        )
    );
}
impl Default for kvm_lapic_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_segment {
    pub base: __u64,
    pub limit: __u32,
    pub selector: __u16,
    pub type_: __u8,
    pub present: __u8,
    pub dpl: __u8,
    pub db: __u8,
    pub s: __u8,
    pub l: __u8,
    pub g: __u8,
    pub avl: __u8,
    pub unusable: __u8,
    pub padding: __u8,
}
#[test]
fn bindgen_test_layout_kvm_segment() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_segment> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_segment>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_segment))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_segment>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_segment))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).base) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_segment),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).limit) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_segment),
            "::",
            stringify!(limit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).selector) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_segment),
            "::",
            stringify!(selector)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_segment),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).present) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_segment),
            "::",
            stringify!(present)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dpl) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_segment),
            "::",
            stringify!(dpl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).db) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_segment),
            "::",
            stringify!(db)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_segment),
            "::",
            stringify!(s)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).l) as usize - ptr as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_segment),
            "::",
            stringify!(l)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).g) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_segment),
            "::",
            stringify!(g)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).avl) as usize - ptr as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_segment),
            "::",
            stringify!(avl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unusable) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_segment),
            "::",
            stringify!(unusable)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding) as usize - ptr as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_segment),
            "::",
            stringify!(padding)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_dtable {
    pub base: __u64,
    pub limit: __u16,
    pub padding: [__u16; 3usize],
}
#[test]
fn bindgen_test_layout_kvm_dtable() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_dtable> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_dtable>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_dtable))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_dtable>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_dtable))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).base) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dtable),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).limit) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dtable),
            "::",
            stringify!(limit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dtable),
            "::",
            stringify!(padding)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_sregs {
    pub cs: kvm_segment,
    pub ds: kvm_segment,
    pub es: kvm_segment,
    pub fs: kvm_segment,
    pub gs: kvm_segment,
    pub ss: kvm_segment,
    pub tr: kvm_segment,
    pub ldt: kvm_segment,
    pub gdt: kvm_dtable,
    pub idt: kvm_dtable,
    pub cr0: __u64,
    pub cr2: __u64,
    pub cr3: __u64,
    pub cr4: __u64,
    pub cr8: __u64,
    pub efer: __u64,
    pub apic_base: __u64,
    pub interrupt_bitmap: [__u64; 4usize],
}
#[test]
fn bindgen_test_layout_kvm_sregs() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sregs> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sregs>(),
        312usize,
        concat!("Size of: ", stringify!(kvm_sregs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sregs>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sregs))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(cs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ds) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(ds)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).es) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(es)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fs) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(fs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gs) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(gs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ss) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(ss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tr) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(tr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ldt) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(ldt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdt) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(gdt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).idt) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(idt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cr0) as usize - ptr as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(cr0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cr2) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(cr2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cr3) as usize - ptr as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(cr3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cr4) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(cr4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cr8) as usize - ptr as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(cr8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).efer) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(efer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).apic_base) as usize - ptr as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(apic_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).interrupt_bitmap) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs),
            "::",
            stringify!(interrupt_bitmap)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sregs2 {
    pub cs: kvm_segment,
    pub ds: kvm_segment,
    pub es: kvm_segment,
    pub fs: kvm_segment,
    pub gs: kvm_segment,
    pub ss: kvm_segment,
    pub tr: kvm_segment,
    pub ldt: kvm_segment,
    pub gdt: kvm_dtable,
    pub idt: kvm_dtable,
    pub cr0: __u64,
    pub cr2: __u64,
    pub cr3: __u64,
    pub cr4: __u64,
    pub cr8: __u64,
    pub efer: __u64,
    pub apic_base: __u64,
    pub flags: __u64,
    pub pdptrs: [__u64; 4usize],
}
#[test]
fn bindgen_test_layout_kvm_sregs2() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sregs2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sregs2>(),
        320usize,
        concat!("Size of: ", stringify!(kvm_sregs2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sregs2>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sregs2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(cs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ds) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(ds)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).es) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(es)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fs) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(fs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gs) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(gs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ss) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(ss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tr) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(tr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ldt) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(ldt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdt) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(gdt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).idt) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(idt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cr0) as usize - ptr as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(cr0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cr2) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(cr2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cr3) as usize - ptr as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(cr3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cr4) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(cr4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cr8) as usize - ptr as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(cr8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).efer) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(efer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).apic_base) as usize - ptr as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(apic_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pdptrs) as usize - ptr as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sregs2),
            "::",
            stringify!(pdptrs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_fpu {
    pub fpr: [[__u8; 16usize]; 8usize],
    pub fcw: __u16,
    pub fsw: __u16,
    pub ftwx: __u8,
    pub pad1: __u8,
    pub last_opcode: __u16,
    pub last_ip: __u64,
    pub last_dp: __u64,
    pub xmm: [[__u8; 16usize]; 16usize],
    pub mxcsr: __u32,
    pub pad2: __u32,
}
#[test]
fn bindgen_test_layout_kvm_fpu() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_fpu> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_fpu>(),
        416usize,
        concat!("Size of: ", stringify!(kvm_fpu))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_fpu>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_fpu))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_fpu),
            "::",
            stringify!(fpr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fcw) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_fpu),
            "::",
            stringify!(fcw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fsw) as usize - ptr as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_fpu),
            "::",
            stringify!(fsw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ftwx) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_fpu),
            "::",
            stringify!(ftwx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad1) as usize - ptr as usize },
        133usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_fpu),
            "::",
            stringify!(pad1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_opcode) as usize - ptr as usize },
        134usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_fpu),
            "::",
            stringify!(last_opcode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_ip) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_fpu),
            "::",
            stringify!(last_ip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_dp) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_fpu),
            "::",
            stringify!(last_dp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xmm) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_fpu),
            "::",
            stringify!(xmm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mxcsr) as usize - ptr as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_fpu),
            "::",
            stringify!(mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad2) as usize - ptr as usize },
        412usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_fpu),
            "::",
            stringify!(pad2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_msr_entry {
    pub index: __u32,
    pub reserved: __u32,
    pub data: __u64,
}
#[test]
fn bindgen_test_layout_kvm_msr_entry() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_msr_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_msr_entry>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_msr_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_msr_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_msr_entry))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msr_entry),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msr_entry),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msr_entry),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_msrs {
    pub nmsrs: __u32,
    pub pad: __u32,
    pub entries: __IncompleteArrayField<kvm_msr_entry>,
}
#[test]
fn bindgen_test_layout_kvm_msrs() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_msrs> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_msrs>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_msrs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_msrs>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_msrs))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nmsrs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msrs),
            "::",
            stringify!(nmsrs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msrs),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msrs),
            "::",
            stringify!(entries)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_msr_list {
    pub nmsrs: __u32,
    pub indices: __IncompleteArrayField<__u32>,
}
#[test]
fn bindgen_test_layout_kvm_msr_list() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_msr_list> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_msr_list>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_msr_list))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_msr_list>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_msr_list))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nmsrs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msr_list),
            "::",
            stringify!(nmsrs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).indices) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msr_list),
            "::",
            stringify!(indices)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct kvm_msr_filter_range {
    pub flags: __u32,
    pub nmsrs: __u32,
    pub base: __u32,
    pub bitmap: *mut __u8,
}
#[test]
fn bindgen_test_layout_kvm_msr_filter_range() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_msr_filter_range> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_msr_filter_range>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_msr_filter_range))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_msr_filter_range>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_msr_filter_range))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msr_filter_range),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nmsrs) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msr_filter_range),
            "::",
            stringify!(nmsrs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).base) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msr_filter_range),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bitmap) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msr_filter_range),
            "::",
            stringify!(bitmap)
        )
    );
}
impl Default for kvm_msr_filter_range {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct kvm_msr_filter {
    pub flags: __u32,
    pub ranges: [kvm_msr_filter_range; 16usize],
}
#[test]
fn bindgen_test_layout_kvm_msr_filter() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_msr_filter> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_msr_filter>(),
        392usize,
        concat!("Size of: ", stringify!(kvm_msr_filter))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_msr_filter>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_msr_filter))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msr_filter),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ranges) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msr_filter),
            "::",
            stringify!(ranges)
        )
    );
}
impl Default for kvm_msr_filter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_cpuid_entry {
    pub function: __u32,
    pub eax: __u32,
    pub ebx: __u32,
    pub ecx: __u32,
    pub edx: __u32,
    pub padding: __u32,
}
#[test]
fn bindgen_test_layout_kvm_cpuid_entry() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_cpuid_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_cpuid_entry>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_cpuid_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_cpuid_entry>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_cpuid_entry))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).function) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry),
            "::",
            stringify!(function)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eax) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry),
            "::",
            stringify!(eax)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ebx) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry),
            "::",
            stringify!(ebx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecx) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry),
            "::",
            stringify!(ecx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).edx) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry),
            "::",
            stringify!(edx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry),
            "::",
            stringify!(padding)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_cpuid {
    pub nent: __u32,
    pub padding: __u32,
    pub entries: __IncompleteArrayField<kvm_cpuid_entry>,
}
#[test]
fn bindgen_test_layout_kvm_cpuid() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_cpuid> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_cpuid>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_cpuid))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_cpuid>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_cpuid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nent) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid),
            "::",
            stringify!(nent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid),
            "::",
            stringify!(padding)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid),
            "::",
            stringify!(entries)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_cpuid_entry2 {
    pub function: __u32,
    pub index: __u32,
    pub flags: __u32,
    pub eax: __u32,
    pub ebx: __u32,
    pub ecx: __u32,
    pub edx: __u32,
    pub padding: [__u32; 3usize],
}
#[test]
fn bindgen_test_layout_kvm_cpuid_entry2() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_cpuid_entry2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_cpuid_entry2>(),
        40usize,
        concat!("Size of: ", stringify!(kvm_cpuid_entry2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_cpuid_entry2>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_cpuid_entry2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).function) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry2),
            "::",
            stringify!(function)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry2),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry2),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eax) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry2),
            "::",
            stringify!(eax)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ebx) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry2),
            "::",
            stringify!(ebx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecx) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry2),
            "::",
            stringify!(ecx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).edx) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry2),
            "::",
            stringify!(edx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid_entry2),
            "::",
            stringify!(padding)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_cpuid2 {
    pub nent: __u32,
    pub padding: __u32,
    pub entries: __IncompleteArrayField<kvm_cpuid_entry2>,
}
#[test]
fn bindgen_test_layout_kvm_cpuid2() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_cpuid2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_cpuid2>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_cpuid2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_cpuid2>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_cpuid2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nent) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid2),
            "::",
            stringify!(nent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid2),
            "::",
            stringify!(padding)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_cpuid2),
            "::",
            stringify!(entries)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_pit_channel_state {
    pub count: __u32,
    pub latched_count: __u16,
    pub count_latched: __u8,
    pub status_latched: __u8,
    pub status: __u8,
    pub read_state: __u8,
    pub write_state: __u8,
    pub write_latch: __u8,
    pub rw_mode: __u8,
    pub mode: __u8,
    pub bcd: __u8,
    pub gate: __u8,
    pub count_load_time: __s64,
}
#[test]
fn bindgen_test_layout_kvm_pit_channel_state() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_pit_channel_state> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_pit_channel_state>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_pit_channel_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_pit_channel_state>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_pit_channel_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_channel_state),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).latched_count) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_channel_state),
            "::",
            stringify!(latched_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).count_latched) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_channel_state),
            "::",
            stringify!(count_latched)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).status_latched) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_channel_state),
            "::",
            stringify!(status_latched)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).status) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_channel_state),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_state) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_channel_state),
            "::",
            stringify!(read_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_state) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_channel_state),
            "::",
            stringify!(write_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_latch) as usize - ptr as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_channel_state),
            "::",
            stringify!(write_latch)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rw_mode) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_channel_state),
            "::",
            stringify!(rw_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mode) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_channel_state),
            "::",
            stringify!(mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bcd) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_channel_state),
            "::",
            stringify!(bcd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gate) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_channel_state),
            "::",
            stringify!(gate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).count_load_time) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_channel_state),
            "::",
            stringify!(count_load_time)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_debug_exit_arch {
    pub exception: __u32,
    pub pad: __u32,
    pub pc: __u64,
    pub dr6: __u64,
    pub dr7: __u64,
}
#[test]
fn bindgen_test_layout_kvm_debug_exit_arch() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_debug_exit_arch> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_debug_exit_arch>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_debug_exit_arch))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_debug_exit_arch>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_debug_exit_arch))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exception) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debug_exit_arch),
            "::",
            stringify!(exception)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debug_exit_arch),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pc) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debug_exit_arch),
            "::",
            stringify!(pc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dr6) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debug_exit_arch),
            "::",
            stringify!(dr6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dr7) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debug_exit_arch),
            "::",
            stringify!(dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_guest_debug_arch {
    pub debugreg: [__u64; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_guest_debug_arch() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_guest_debug_arch> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_guest_debug_arch>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_guest_debug_arch))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_guest_debug_arch>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_guest_debug_arch))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).debugreg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_guest_debug_arch),
            "::",
            stringify!(debugreg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_pit_state {
    pub channels: [kvm_pit_channel_state; 3usize],
}
#[test]
fn bindgen_test_layout_kvm_pit_state() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_pit_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_pit_state>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_pit_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_pit_state>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_pit_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).channels) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_state),
            "::",
            stringify!(channels)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_pit_state2 {
    pub channels: [kvm_pit_channel_state; 3usize],
    pub flags: __u32,
    pub reserved: [__u32; 9usize],
}
#[test]
fn bindgen_test_layout_kvm_pit_state2() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_pit_state2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_pit_state2>(),
        112usize,
        concat!("Size of: ", stringify!(kvm_pit_state2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_pit_state2>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_pit_state2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).channels) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_state2),
            "::",
            stringify!(channels)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_state2),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_state2),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_reinject_control {
    pub pit_reinject: __u8,
    pub reserved: [__u8; 31usize],
}
#[test]
fn bindgen_test_layout_kvm_reinject_control() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_reinject_control> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_reinject_control>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_reinject_control))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_reinject_control>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_reinject_control))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pit_reinject) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_reinject_control),
            "::",
            stringify!(pit_reinject)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_reinject_control),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_vcpu_events {
    pub exception: kvm_vcpu_events__bindgen_ty_1,
    pub interrupt: kvm_vcpu_events__bindgen_ty_2,
    pub nmi: kvm_vcpu_events__bindgen_ty_3,
    pub sipi_vector: __u32,
    pub flags: __u32,
    pub smi: kvm_vcpu_events__bindgen_ty_4,
    pub triple_fault: kvm_vcpu_events__bindgen_ty_5,
    pub reserved: [__u8; 26usize],
    pub exception_has_payload: __u8,
    pub exception_payload: __u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_vcpu_events__bindgen_ty_1 {
    pub injected: __u8,
    pub nr: __u8,
    pub has_error_code: __u8,
    pub pending: __u8,
    pub error_code: __u32,
}
#[test]
fn bindgen_test_layout_kvm_vcpu_events__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_vcpu_events__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_vcpu_events__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_events__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).injected) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_1),
            "::",
            stringify!(injected)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_1),
            "::",
            stringify!(nr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_error_code) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_1),
            "::",
            stringify!(has_error_code)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pending) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_1),
            "::",
            stringify!(pending)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).error_code) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_1),
            "::",
            stringify!(error_code)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_vcpu_events__bindgen_ty_2 {
    pub injected: __u8,
    pub nr: __u8,
    pub soft: __u8,
    pub shadow: __u8,
}
#[test]
fn bindgen_test_layout_kvm_vcpu_events__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_vcpu_events__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_vcpu_events__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_2>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_events__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).injected) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_2),
            "::",
            stringify!(injected)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_2),
            "::",
            stringify!(nr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).soft) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_2),
            "::",
            stringify!(soft)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shadow) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_2),
            "::",
            stringify!(shadow)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_vcpu_events__bindgen_ty_3 {
    pub injected: __u8,
    pub pending: __u8,
    pub masked: __u8,
    pub pad: __u8,
}
#[test]
fn bindgen_test_layout_kvm_vcpu_events__bindgen_ty_3() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_vcpu_events__bindgen_ty_3> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_3>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_vcpu_events__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_3>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_events__bindgen_ty_3))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).injected) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_3),
            "::",
            stringify!(injected)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pending) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_3),
            "::",
            stringify!(pending)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).masked) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_3),
            "::",
            stringify!(masked)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_3),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_vcpu_events__bindgen_ty_4 {
    pub smm: __u8,
    pub pending: __u8,
    pub smm_inside_nmi: __u8,
    pub latched_init: __u8,
}
#[test]
fn bindgen_test_layout_kvm_vcpu_events__bindgen_ty_4() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_vcpu_events__bindgen_ty_4> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_4>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_vcpu_events__bindgen_ty_4))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_4>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_events__bindgen_ty_4))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).smm) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_4),
            "::",
            stringify!(smm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pending) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_4),
            "::",
            stringify!(pending)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).smm_inside_nmi) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_4),
            "::",
            stringify!(smm_inside_nmi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).latched_init) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_4),
            "::",
            stringify!(latched_init)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_vcpu_events__bindgen_ty_5 {
    pub pending: __u8,
}
#[test]
fn bindgen_test_layout_kvm_vcpu_events__bindgen_ty_5() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_vcpu_events__bindgen_ty_5> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_5>(),
        1usize,
        concat!("Size of: ", stringify!(kvm_vcpu_events__bindgen_ty_5))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_5>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_events__bindgen_ty_5))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pending) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_5),
            "::",
            stringify!(pending)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_vcpu_events() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_vcpu_events> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_events>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_vcpu_events))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_events>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_events))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exception) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events),
            "::",
            stringify!(exception)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).interrupt) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events),
            "::",
            stringify!(interrupt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nmi) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events),
            "::",
            stringify!(nmi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sipi_vector) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events),
            "::",
            stringify!(sipi_vector)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).smi) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events),
            "::",
            stringify!(smi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).triple_fault) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events),
            "::",
            stringify!(triple_fault)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exception_has_payload) as usize - ptr as usize },
        55usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events),
            "::",
            stringify!(exception_has_payload)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exception_payload) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events),
            "::",
            stringify!(exception_payload)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_debugregs {
    pub db: [__u64; 4usize],
    pub dr6: __u64,
    pub dr7: __u64,
    pub flags: __u64,
    pub reserved: [__u64; 9usize],
}
#[test]
fn bindgen_test_layout_kvm_debugregs() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_debugregs> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_debugregs>(),
        128usize,
        concat!("Size of: ", stringify!(kvm_debugregs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_debugregs>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_debugregs))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).db) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debugregs),
            "::",
            stringify!(db)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dr6) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debugregs),
            "::",
            stringify!(dr6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dr7) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debugregs),
            "::",
            stringify!(dr7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debugregs),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debugregs),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_xsave {
    pub region: [__u32; 1024usize],
    pub extra: __IncompleteArrayField<__u32>,
}
#[test]
fn bindgen_test_layout_kvm_xsave() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xsave> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xsave>(),
        4096usize,
        concat!("Size of: ", stringify!(kvm_xsave))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xsave>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_xsave))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).region) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xsave),
            "::",
            stringify!(region)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extra) as usize - ptr as usize },
        4096usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xsave),
            "::",
            stringify!(extra)
        )
    );
}
impl Default for kvm_xsave {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_xcr {
    pub xcr: __u32,
    pub reserved: __u32,
    pub value: __u64,
}
#[test]
fn bindgen_test_layout_kvm_xcr() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xcr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xcr>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_xcr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xcr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_xcr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xcr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xcr),
            "::",
            stringify!(xcr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xcr),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).value) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xcr),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_xcrs {
    pub nr_xcrs: __u32,
    pub flags: __u32,
    pub xcrs: [kvm_xcr; 16usize],
    pub padding: [__u64; 16usize],
}
#[test]
fn bindgen_test_layout_kvm_xcrs() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xcrs> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xcrs>(),
        392usize,
        concat!("Size of: ", stringify!(kvm_xcrs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xcrs>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_xcrs))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_xcrs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xcrs),
            "::",
            stringify!(nr_xcrs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xcrs),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xcrs) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xcrs),
            "::",
            stringify!(xcrs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xcrs),
            "::",
            stringify!(padding)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sync_regs {
    pub regs: kvm_regs,
    pub sregs: kvm_sregs,
    pub events: kvm_vcpu_events,
}
#[test]
fn bindgen_test_layout_kvm_sync_regs() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sync_regs> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sync_regs>(),
        520usize,
        concat!("Size of: ", stringify!(kvm_sync_regs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sync_regs>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sync_regs))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).regs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sync_regs),
            "::",
            stringify!(regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sregs) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sync_regs),
            "::",
            stringify!(sregs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).events) as usize - ptr as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sync_regs),
            "::",
            stringify!(events)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct kvm_vmx_nested_state_data {
    pub vmcs12: [__u8; 4096usize],
    pub shadow_vmcs12: [__u8; 4096usize],
}
#[test]
fn bindgen_test_layout_kvm_vmx_nested_state_data() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_vmx_nested_state_data> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_vmx_nested_state_data>(),
        8192usize,
        concat!("Size of: ", stringify!(kvm_vmx_nested_state_data))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vmx_nested_state_data>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_vmx_nested_state_data))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vmcs12) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vmx_nested_state_data),
            "::",
            stringify!(vmcs12)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shadow_vmcs12) as usize - ptr as usize },
        4096usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vmx_nested_state_data),
            "::",
            stringify!(shadow_vmcs12)
        )
    );
}
impl Default for kvm_vmx_nested_state_data {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_vmx_nested_state_hdr {
    pub vmxon_pa: __u64,
    pub vmcs12_pa: __u64,
    pub smm: kvm_vmx_nested_state_hdr__bindgen_ty_1,
    pub pad: __u16,
    pub flags: __u32,
    pub preemption_timer_deadline: __u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_vmx_nested_state_hdr__bindgen_ty_1 {
    pub flags: __u16,
}
#[test]
fn bindgen_test_layout_kvm_vmx_nested_state_hdr__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_vmx_nested_state_hdr__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_vmx_nested_state_hdr__bindgen_ty_1>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(kvm_vmx_nested_state_hdr__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vmx_nested_state_hdr__bindgen_ty_1>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_vmx_nested_state_hdr__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vmx_nested_state_hdr__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_vmx_nested_state_hdr() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_vmx_nested_state_hdr> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_vmx_nested_state_hdr>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_vmx_nested_state_hdr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vmx_nested_state_hdr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_vmx_nested_state_hdr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vmxon_pa) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vmx_nested_state_hdr),
            "::",
            stringify!(vmxon_pa)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vmcs12_pa) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vmx_nested_state_hdr),
            "::",
            stringify!(vmcs12_pa)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).smm) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vmx_nested_state_hdr),
            "::",
            stringify!(smm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vmx_nested_state_hdr),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vmx_nested_state_hdr),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preemption_timer_deadline) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vmx_nested_state_hdr),
            "::",
            stringify!(preemption_timer_deadline)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct kvm_svm_nested_state_data {
    pub vmcb12: [__u8; 4096usize],
}
#[test]
fn bindgen_test_layout_kvm_svm_nested_state_data() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_svm_nested_state_data> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_svm_nested_state_data>(),
        4096usize,
        concat!("Size of: ", stringify!(kvm_svm_nested_state_data))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_svm_nested_state_data>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_svm_nested_state_data))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vmcb12) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_svm_nested_state_data),
            "::",
            stringify!(vmcb12)
        )
    );
}
impl Default for kvm_svm_nested_state_data {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_svm_nested_state_hdr {
    pub vmcb_pa: __u64,
}
#[test]
fn bindgen_test_layout_kvm_svm_nested_state_hdr() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_svm_nested_state_hdr> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_svm_nested_state_hdr>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_svm_nested_state_hdr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_svm_nested_state_hdr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_svm_nested_state_hdr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vmcb_pa) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_svm_nested_state_hdr),
            "::",
            stringify!(vmcb_pa)
        )
    );
}
#[repr(C)]
pub struct kvm_nested_state {
    pub flags: __u16,
    pub format: __u16,
    pub size: __u32,
    pub hdr: kvm_nested_state__bindgen_ty_1,
    pub data: kvm_nested_state__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_nested_state__bindgen_ty_1 {
    pub vmx: kvm_vmx_nested_state_hdr,
    pub svm: kvm_svm_nested_state_hdr,
    pub pad: [__u8; 120usize],
}
#[test]
fn bindgen_test_layout_kvm_nested_state__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_nested_state__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_nested_state__bindgen_ty_1>(),
        120usize,
        concat!("Size of: ", stringify!(kvm_nested_state__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_nested_state__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_nested_state__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vmx) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_nested_state__bindgen_ty_1),
            "::",
            stringify!(vmx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).svm) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_nested_state__bindgen_ty_1),
            "::",
            stringify!(svm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_nested_state__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
}
impl Default for kvm_nested_state__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_nested_state__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_nested_state__bindgen_ty_1 {{ union }}")
    }
}
#[repr(C)]
pub struct kvm_nested_state__bindgen_ty_2 {
    pub __bindgen_anon_1: __BindgenUnionField<kvm_nested_state__bindgen_ty_2__bindgen_ty_1>,
    pub __bindgen_anon_2: __BindgenUnionField<kvm_nested_state__bindgen_ty_2__bindgen_ty_2>,
    pub bindgen_union_field: [u8; 0usize],
}
#[repr(C)]
#[derive(Debug)]
pub struct kvm_nested_state__bindgen_ty_2__bindgen_ty_1 {
    pub __empty_vmx: kvm_nested_state__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
    pub vmx: __IncompleteArrayField<kvm_vmx_nested_state_data>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_nested_state__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1 {}
#[test]
fn bindgen_test_layout_kvm_nested_state__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_nested_state__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1>(),
        0usize,
        concat!(
            "Size of: ",
            stringify!(kvm_nested_state__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_nested_state__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_nested_state__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_nested_state__bindgen_ty_2__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_nested_state__bindgen_ty_2__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_nested_state__bindgen_ty_2__bindgen_ty_1>(),
        0usize,
        concat!(
            "Size of: ",
            stringify!(kvm_nested_state__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_nested_state__bindgen_ty_2__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_nested_state__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__empty_vmx) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_nested_state__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__empty_vmx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vmx) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_nested_state__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(vmx)
        )
    );
}
impl Default for kvm_nested_state__bindgen_ty_2__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct kvm_nested_state__bindgen_ty_2__bindgen_ty_2 {
    pub __empty_svm: kvm_nested_state__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1,
    pub svm: __IncompleteArrayField<kvm_svm_nested_state_data>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_nested_state__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1 {}
#[test]
fn bindgen_test_layout_kvm_nested_state__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_nested_state__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1>(),
        0usize,
        concat!(
            "Size of: ",
            stringify!(kvm_nested_state__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_nested_state__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_nested_state__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_nested_state__bindgen_ty_2__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_nested_state__bindgen_ty_2__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_nested_state__bindgen_ty_2__bindgen_ty_2>(),
        0usize,
        concat!(
            "Size of: ",
            stringify!(kvm_nested_state__bindgen_ty_2__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_nested_state__bindgen_ty_2__bindgen_ty_2>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_nested_state__bindgen_ty_2__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__empty_svm) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_nested_state__bindgen_ty_2__bindgen_ty_2),
            "::",
            stringify!(__empty_svm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).svm) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_nested_state__bindgen_ty_2__bindgen_ty_2),
            "::",
            stringify!(svm)
        )
    );
}
impl Default for kvm_nested_state__bindgen_ty_2__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_kvm_nested_state__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<kvm_nested_state__bindgen_ty_2>(),
        0usize,
        concat!("Size of: ", stringify!(kvm_nested_state__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_nested_state__bindgen_ty_2>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_nested_state__bindgen_ty_2))
    );
}
impl Default for kvm_nested_state__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_nested_state__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_nested_state__bindgen_ty_2 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_nested_state() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_nested_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_nested_state>(),
        128usize,
        concat!("Size of: ", stringify!(kvm_nested_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_nested_state>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_nested_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_nested_state),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).format) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_nested_state),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_nested_state),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hdr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_nested_state),
            "::",
            stringify!(hdr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_nested_state),
            "::",
            stringify!(data)
        )
    );
}
impl Default for kvm_nested_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_nested_state {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_nested_state {{ flags: {:?}, format: {:?}, size: {:?}, hdr: {:?}, data: {:?} }}",
            self.flags, self.format, self.size, self.hdr, self.data
        )
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_pmu_event_filter {
    pub action: __u32,
    pub nevents: __u32,
    pub fixed_counter_bitmap: __u32,
    pub flags: __u32,
    pub pad: [__u32; 4usize],
    pub events: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_kvm_pmu_event_filter() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_pmu_event_filter> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_pmu_event_filter>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_pmu_event_filter))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_pmu_event_filter>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_pmu_event_filter))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).action) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pmu_event_filter),
            "::",
            stringify!(action)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nevents) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pmu_event_filter),
            "::",
            stringify!(nevents)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fixed_counter_bitmap) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pmu_event_filter),
            "::",
            stringify!(fixed_counter_bitmap)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pmu_event_filter),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pmu_event_filter),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).events) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pmu_event_filter),
            "::",
            stringify!(events)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_x86_mce {
    pub status: __u64,
    pub addr: __u64,
    pub misc: __u64,
    pub mcg_status: __u64,
    pub bank: __u8,
    pub pad1: [__u8; 7usize],
    pub pad2: [__u64; 3usize],
}
#[test]
fn bindgen_test_layout_kvm_x86_mce() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_x86_mce> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_x86_mce>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_x86_mce))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_x86_mce>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_x86_mce))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).status) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_x86_mce),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_x86_mce),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).misc) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_x86_mce),
            "::",
            stringify!(misc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mcg_status) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_x86_mce),
            "::",
            stringify!(mcg_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bank) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_x86_mce),
            "::",
            stringify!(bank)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad1) as usize - ptr as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_x86_mce),
            "::",
            stringify!(pad1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad2) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_x86_mce),
            "::",
            stringify!(pad2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_xen_hvm_config {
    pub flags: __u32,
    pub msr: __u32,
    pub blob_addr_32: __u64,
    pub blob_addr_64: __u64,
    pub blob_size_32: __u8,
    pub blob_size_64: __u8,
    pub pad2: [__u8; 30usize],
}
#[test]
fn bindgen_test_layout_kvm_xen_hvm_config() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xen_hvm_config> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_hvm_config>(),
        56usize,
        concat!("Size of: ", stringify!(kvm_xen_hvm_config))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_hvm_config>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_xen_hvm_config))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_config),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_config),
            "::",
            stringify!(msr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).blob_addr_32) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_config),
            "::",
            stringify!(blob_addr_32)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).blob_addr_64) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_config),
            "::",
            stringify!(blob_addr_64)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).blob_size_32) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_config),
            "::",
            stringify!(blob_size_32)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).blob_size_64) as usize - ptr as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_config),
            "::",
            stringify!(blob_size_64)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad2) as usize - ptr as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_config),
            "::",
            stringify!(pad2)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_xen_hvm_attr {
    pub type_: __u16,
    pub pad: [__u16; 3usize],
    pub u: kvm_xen_hvm_attr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_xen_hvm_attr__bindgen_ty_1 {
    pub long_mode: __u8,
    pub vector: __u8,
    pub runstate_update_flag: __u8,
    pub shared_info: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1,
    pub evtchn: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2,
    pub xen_version: __u32,
    pub pad: [__u64; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1 {
    pub gfn: __u64,
    pub hva: __u64,
}
#[test]
fn bindgen_test_layout_kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gfn) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(gfn)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hva) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hva)
        )
    );
}
impl Default for kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1 {{ union }}"
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2 {
    pub send_port: __u32,
    pub type_: __u32,
    pub flags: __u32,
    pub deliver: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {
    pub port: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
    pub eventfd: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2,
    pub padding: [__u32; 4usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1 {
    pub port: __u32,
    pub vcpu: __u32,
    pub priority: __u32,
}
#[test]
fn bindgen_test_layout_kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<
        kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
    > = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<
            kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
        >(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<
            kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
        >(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vcpu) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(vcpu)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).priority) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priority)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2 {
    pub port: __u32,
    pub fd: __s32,
}
#[test]
fn bindgen_test_layout_kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<
        kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2,
    > = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<
            kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2,
        >(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<
            kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2,
        >(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fd) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(fd)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<
        kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
    > = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eventfd) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(eventfd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(padding)
        )
    );
}
impl Default for kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {{ union }}"
        )
    }
}
#[test]
fn bindgen_test_layout_kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2>(),
        28usize,
        concat!(
            "Size of: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).send_port) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(send_port)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deliver) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(deliver)
        )
    );
}
impl Default for kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2 {{ send_port: {:?}, type: {:?}, flags: {:?}, deliver: {:?} }}" , self . send_port , self . type_ , self . flags , self . deliver)
    }
}
#[test]
fn bindgen_test_layout_kvm_xen_hvm_attr__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xen_hvm_attr__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_hvm_attr__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_xen_hvm_attr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_hvm_attr__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_xen_hvm_attr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).long_mode) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1),
            "::",
            stringify!(long_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vector) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1),
            "::",
            stringify!(vector)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).runstate_update_flag) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1),
            "::",
            stringify!(runstate_update_flag)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shared_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1),
            "::",
            stringify!(shared_info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).evtchn) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1),
            "::",
            stringify!(evtchn)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xen_version) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1),
            "::",
            stringify!(xen_version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
}
impl Default for kvm_xen_hvm_attr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_hvm_attr__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_xen_hvm_attr__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_xen_hvm_attr() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xen_hvm_attr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_hvm_attr>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_xen_hvm_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_hvm_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_xen_hvm_attr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_hvm_attr),
            "::",
            stringify!(u)
        )
    );
}
impl Default for kvm_xen_hvm_attr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_hvm_attr {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_xen_hvm_attr {{ type: {:?}, pad: {:?}, u: {:?} }}",
            self.type_, self.pad, self.u
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_xen_vcpu_attr {
    pub type_: __u16,
    pub pad: [__u16; 3usize],
    pub u: kvm_xen_vcpu_attr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_xen_vcpu_attr__bindgen_ty_1 {
    pub gpa: __u64,
    pub hva: __u64,
    pub pad: [__u64; 8usize],
    pub runstate: kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1,
    pub vcpu_id: __u32,
    pub timer: kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2,
    pub vector: __u8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1 {
    pub state: __u64,
    pub state_entry_time: __u64,
    pub time_running: __u64,
    pub time_runnable: __u64,
    pub time_blocked: __u64,
    pub time_offline: __u64,
}
#[test]
fn bindgen_test_layout_kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1>(),
        48usize,
        concat!(
            "Size of: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state_entry_time) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(state_entry_time)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).time_running) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(time_running)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).time_runnable) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(time_runnable)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).time_blocked) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(time_blocked)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).time_offline) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(time_offline)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2 {
    pub port: __u32,
    pub priority: __u32,
    pub expires_ns: __u64,
}
#[test]
fn bindgen_test_layout_kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).priority) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(priority)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).expires_ns) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(expires_ns)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_xen_vcpu_attr__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xen_vcpu_attr__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_vcpu_attr__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_xen_vcpu_attr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_vcpu_attr__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_xen_vcpu_attr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gpa) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1),
            "::",
            stringify!(gpa)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hva) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1),
            "::",
            stringify!(hva)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).runstate) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1),
            "::",
            stringify!(runstate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vcpu_id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1),
            "::",
            stringify!(vcpu_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timer) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1),
            "::",
            stringify!(timer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vector) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr__bindgen_ty_1),
            "::",
            stringify!(vector)
        )
    );
}
impl Default for kvm_xen_vcpu_attr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_vcpu_attr__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_xen_vcpu_attr__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_xen_vcpu_attr() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xen_vcpu_attr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_vcpu_attr>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_xen_vcpu_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_vcpu_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_xen_vcpu_attr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_vcpu_attr),
            "::",
            stringify!(u)
        )
    );
}
impl Default for kvm_xen_vcpu_attr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_vcpu_attr {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_xen_vcpu_attr {{ type: {:?}, pad: {:?}, u: {:?} }}",
            self.type_, self.pad, self.u
        )
    }
}
pub const sev_cmd_id_KVM_SEV_INIT: sev_cmd_id = 0;
pub const sev_cmd_id_KVM_SEV_ES_INIT: sev_cmd_id = 1;
pub const sev_cmd_id_KVM_SEV_LAUNCH_START: sev_cmd_id = 2;
pub const sev_cmd_id_KVM_SEV_LAUNCH_UPDATE_DATA: sev_cmd_id = 3;
pub const sev_cmd_id_KVM_SEV_LAUNCH_UPDATE_VMSA: sev_cmd_id = 4;
pub const sev_cmd_id_KVM_SEV_LAUNCH_SECRET: sev_cmd_id = 5;
pub const sev_cmd_id_KVM_SEV_LAUNCH_MEASURE: sev_cmd_id = 6;
pub const sev_cmd_id_KVM_SEV_LAUNCH_FINISH: sev_cmd_id = 7;
pub const sev_cmd_id_KVM_SEV_SEND_START: sev_cmd_id = 8;
pub const sev_cmd_id_KVM_SEV_SEND_UPDATE_DATA: sev_cmd_id = 9;
pub const sev_cmd_id_KVM_SEV_SEND_UPDATE_VMSA: sev_cmd_id = 10;
pub const sev_cmd_id_KVM_SEV_SEND_FINISH: sev_cmd_id = 11;
pub const sev_cmd_id_KVM_SEV_RECEIVE_START: sev_cmd_id = 12;
pub const sev_cmd_id_KVM_SEV_RECEIVE_UPDATE_DATA: sev_cmd_id = 13;
pub const sev_cmd_id_KVM_SEV_RECEIVE_UPDATE_VMSA: sev_cmd_id = 14;
pub const sev_cmd_id_KVM_SEV_RECEIVE_FINISH: sev_cmd_id = 15;
pub const sev_cmd_id_KVM_SEV_GUEST_STATUS: sev_cmd_id = 16;
pub const sev_cmd_id_KVM_SEV_DBG_DECRYPT: sev_cmd_id = 17;
pub const sev_cmd_id_KVM_SEV_DBG_ENCRYPT: sev_cmd_id = 18;
pub const sev_cmd_id_KVM_SEV_CERT_EXPORT: sev_cmd_id = 19;
pub const sev_cmd_id_KVM_SEV_GET_ATTESTATION_REPORT: sev_cmd_id = 20;
pub const sev_cmd_id_KVM_SEV_SEND_CANCEL: sev_cmd_id = 21;
pub const sev_cmd_id_KVM_SEV_NR_MAX: sev_cmd_id = 22;
pub type sev_cmd_id = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_cmd {
    pub id: __u32,
    pub pad0: __u32,
    pub data: __u64,
    pub error: __u32,
    pub sev_fd: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_cmd() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sev_cmd> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_cmd>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_sev_cmd))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_cmd>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_cmd))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_cmd),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad0) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_cmd),
            "::",
            stringify!(pad0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_cmd),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).error) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_cmd),
            "::",
            stringify!(error)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sev_fd) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_cmd),
            "::",
            stringify!(sev_fd)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_launch_start {
    pub handle: __u32,
    pub policy: __u32,
    pub dh_uaddr: __u64,
    pub dh_len: __u32,
    pub pad0: __u32,
    pub session_uaddr: __u64,
    pub session_len: __u32,
    pub pad1: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_launch_start() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sev_launch_start> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_launch_start>(),
        40usize,
        concat!("Size of: ", stringify!(kvm_sev_launch_start))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_launch_start>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_launch_start))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).handle) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).policy) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(policy)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dh_uaddr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(dh_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dh_len) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(dh_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad0) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(pad0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).session_uaddr) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(session_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).session_len) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(session_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad1) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(pad1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_launch_update_data {
    pub uaddr: __u64,
    pub len: __u32,
    pub pad0: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_launch_update_data() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sev_launch_update_data> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_launch_update_data>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_sev_launch_update_data))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_launch_update_data>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_launch_update_data))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uaddr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_update_data),
            "::",
            stringify!(uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_update_data),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad0) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_update_data),
            "::",
            stringify!(pad0)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_launch_secret {
    pub hdr_uaddr: __u64,
    pub hdr_len: __u32,
    pub pad0: __u32,
    pub guest_uaddr: __u64,
    pub guest_len: __u32,
    pub pad1: __u32,
    pub trans_uaddr: __u64,
    pub trans_len: __u32,
    pub pad2: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_launch_secret() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sev_launch_secret> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_launch_secret>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_sev_launch_secret))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_launch_secret>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_launch_secret))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hdr_uaddr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(hdr_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hdr_len) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(hdr_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad0) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(pad0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).guest_uaddr) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(guest_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).guest_len) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(guest_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad1) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(pad1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trans_uaddr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(trans_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trans_len) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(trans_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad2) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(pad2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_launch_measure {
    pub uaddr: __u64,
    pub len: __u32,
    pub pad0: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_launch_measure() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sev_launch_measure> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_launch_measure>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_sev_launch_measure))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_launch_measure>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_launch_measure))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uaddr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_measure),
            "::",
            stringify!(uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_measure),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad0) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_measure),
            "::",
            stringify!(pad0)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_guest_status {
    pub handle: __u32,
    pub policy: __u32,
    pub state: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_guest_status() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sev_guest_status> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_guest_status>(),
        12usize,
        concat!("Size of: ", stringify!(kvm_sev_guest_status))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_guest_status>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_sev_guest_status))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).handle) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_guest_status),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).policy) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_guest_status),
            "::",
            stringify!(policy)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_guest_status),
            "::",
            stringify!(state)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_dbg {
    pub src_uaddr: __u64,
    pub dst_uaddr: __u64,
    pub len: __u32,
    pub pad0: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_dbg() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sev_dbg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_dbg>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_sev_dbg))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_dbg>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_dbg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src_uaddr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_dbg),
            "::",
            stringify!(src_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dst_uaddr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_dbg),
            "::",
            stringify!(dst_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_dbg),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad0) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_dbg),
            "::",
            stringify!(pad0)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_attestation_report {
    pub mnonce: [__u8; 16usize],
    pub uaddr: __u64,
    pub len: __u32,
    pub pad0: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_attestation_report() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sev_attestation_report> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_attestation_report>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_sev_attestation_report))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_attestation_report>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_attestation_report))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mnonce) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_attestation_report),
            "::",
            stringify!(mnonce)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uaddr) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_attestation_report),
            "::",
            stringify!(uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_attestation_report),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad0) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_attestation_report),
            "::",
            stringify!(pad0)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_send_start {
    pub policy: __u32,
    pub pad0: __u32,
    pub pdh_cert_uaddr: __u64,
    pub pdh_cert_len: __u32,
    pub pad1: __u32,
    pub plat_certs_uaddr: __u64,
    pub plat_certs_len: __u32,
    pub pad2: __u32,
    pub amd_certs_uaddr: __u64,
    pub amd_certs_len: __u32,
    pub pad3: __u32,
    pub session_uaddr: __u64,
    pub session_len: __u32,
    pub pad4: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_send_start() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sev_send_start> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_send_start>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_sev_send_start))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_send_start>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_send_start))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).policy) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(policy)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad0) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(pad0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pdh_cert_uaddr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(pdh_cert_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pdh_cert_len) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(pdh_cert_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad1) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(pad1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).plat_certs_uaddr) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(plat_certs_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).plat_certs_len) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(plat_certs_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad2) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(pad2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).amd_certs_uaddr) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(amd_certs_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).amd_certs_len) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(amd_certs_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad3) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(pad3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).session_uaddr) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(session_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).session_len) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(session_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad4) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_start),
            "::",
            stringify!(pad4)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_send_update_data {
    pub hdr_uaddr: __u64,
    pub hdr_len: __u32,
    pub pad0: __u32,
    pub guest_uaddr: __u64,
    pub guest_len: __u32,
    pub pad1: __u32,
    pub trans_uaddr: __u64,
    pub trans_len: __u32,
    pub pad2: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_send_update_data() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sev_send_update_data> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_send_update_data>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_sev_send_update_data))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_send_update_data>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_send_update_data))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hdr_uaddr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_update_data),
            "::",
            stringify!(hdr_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hdr_len) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_update_data),
            "::",
            stringify!(hdr_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad0) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_update_data),
            "::",
            stringify!(pad0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).guest_uaddr) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_update_data),
            "::",
            stringify!(guest_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).guest_len) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_update_data),
            "::",
            stringify!(guest_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad1) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_update_data),
            "::",
            stringify!(pad1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trans_uaddr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_update_data),
            "::",
            stringify!(trans_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trans_len) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_update_data),
            "::",
            stringify!(trans_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad2) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_send_update_data),
            "::",
            stringify!(pad2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_receive_start {
    pub handle: __u32,
    pub policy: __u32,
    pub pdh_uaddr: __u64,
    pub pdh_len: __u32,
    pub pad0: __u32,
    pub session_uaddr: __u64,
    pub session_len: __u32,
    pub pad1: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_receive_start() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sev_receive_start> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_receive_start>(),
        40usize,
        concat!("Size of: ", stringify!(kvm_sev_receive_start))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_receive_start>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_receive_start))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).handle) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_start),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).policy) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_start),
            "::",
            stringify!(policy)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pdh_uaddr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_start),
            "::",
            stringify!(pdh_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pdh_len) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_start),
            "::",
            stringify!(pdh_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad0) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_start),
            "::",
            stringify!(pad0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).session_uaddr) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_start),
            "::",
            stringify!(session_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).session_len) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_start),
            "::",
            stringify!(session_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad1) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_start),
            "::",
            stringify!(pad1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_receive_update_data {
    pub hdr_uaddr: __u64,
    pub hdr_len: __u32,
    pub pad0: __u32,
    pub guest_uaddr: __u64,
    pub guest_len: __u32,
    pub pad1: __u32,
    pub trans_uaddr: __u64,
    pub trans_len: __u32,
    pub pad2: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_receive_update_data() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_sev_receive_update_data> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_receive_update_data>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_sev_receive_update_data))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_receive_update_data>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_receive_update_data))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hdr_uaddr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_update_data),
            "::",
            stringify!(hdr_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hdr_len) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_update_data),
            "::",
            stringify!(hdr_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad0) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_update_data),
            "::",
            stringify!(pad0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).guest_uaddr) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_update_data),
            "::",
            stringify!(guest_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).guest_len) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_update_data),
            "::",
            stringify!(guest_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad1) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_update_data),
            "::",
            stringify!(pad1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trans_uaddr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_update_data),
            "::",
            stringify!(trans_uaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trans_len) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_update_data),
            "::",
            stringify!(trans_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad2) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_receive_update_data),
            "::",
            stringify!(pad2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_hyperv_eventfd {
    pub conn_id: __u32,
    pub fd: __s32,
    pub flags: __u32,
    pub padding: [__u32; 3usize],
}
#[test]
fn bindgen_test_layout_kvm_hyperv_eventfd() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_hyperv_eventfd> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_eventfd>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_hyperv_eventfd))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_eventfd>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_hyperv_eventfd))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).conn_id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_eventfd),
            "::",
            stringify!(conn_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fd) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_eventfd),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_eventfd),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_eventfd),
            "::",
            stringify!(padding)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_userspace_memory_region {
    pub slot: __u32,
    pub flags: __u32,
    pub guest_phys_addr: __u64,
    pub memory_size: __u64,
    pub userspace_addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_userspace_memory_region() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_userspace_memory_region> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_userspace_memory_region>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_userspace_memory_region))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_userspace_memory_region>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_userspace_memory_region))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).slot) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region),
            "::",
            stringify!(slot)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).guest_phys_addr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region),
            "::",
            stringify!(guest_phys_addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).memory_size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region),
            "::",
            stringify!(memory_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).userspace_addr) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region),
            "::",
            stringify!(userspace_addr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_userspace_memory_region2 {
    pub slot: __u32,
    pub flags: __u32,
    pub guest_phys_addr: __u64,
    pub memory_size: __u64,
    pub userspace_addr: __u64,
    pub guest_memfd_offset: __u64,
    pub guest_memfd: __u32,
    pub pad1: __u32,
    pub pad2: [__u64; 14usize],
}
#[test]
fn bindgen_test_layout_kvm_userspace_memory_region2() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_userspace_memory_region2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_userspace_memory_region2>(),
        160usize,
        concat!("Size of: ", stringify!(kvm_userspace_memory_region2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_userspace_memory_region2>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_userspace_memory_region2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).slot) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region2),
            "::",
            stringify!(slot)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region2),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).guest_phys_addr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region2),
            "::",
            stringify!(guest_phys_addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).memory_size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region2),
            "::",
            stringify!(memory_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).userspace_addr) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region2),
            "::",
            stringify!(userspace_addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).guest_memfd_offset) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region2),
            "::",
            stringify!(guest_memfd_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).guest_memfd) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region2),
            "::",
            stringify!(guest_memfd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad1) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region2),
            "::",
            stringify!(pad1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad2) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region2),
            "::",
            stringify!(pad2)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irq_level {
    pub __bindgen_anon_1: kvm_irq_level__bindgen_ty_1,
    pub level: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irq_level__bindgen_ty_1 {
    pub irq: __u32,
    pub status: __s32,
}
#[test]
fn bindgen_test_layout_kvm_irq_level__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irq_level__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_level__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_irq_level__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_level__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_level__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).irq) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_level__bindgen_ty_1),
            "::",
            stringify!(irq)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).status) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_level__bindgen_ty_1),
            "::",
            stringify!(status)
        )
    );
}
impl Default for kvm_irq_level__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_level__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_irq_level__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_irq_level() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irq_level> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_level>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_irq_level))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_level>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_level))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_level),
            "::",
            stringify!(level)
        )
    );
}
impl Default for kvm_irq_level {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_level {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_irq_level {{ __bindgen_anon_1: {:?}, level: {:?} }}",
            self.__bindgen_anon_1, self.level
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_irqchip {
    pub chip_id: __u32,
    pub pad: __u32,
    pub chip: kvm_irqchip__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irqchip__bindgen_ty_1 {
    pub dummy: [::std::os::raw::c_char; 512usize],
    pub pic: kvm_pic_state,
    pub ioapic: kvm_ioapic_state,
}
#[test]
fn bindgen_test_layout_kvm_irqchip__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irqchip__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irqchip__bindgen_ty_1>(),
        512usize,
        concat!("Size of: ", stringify!(kvm_irqchip__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irqchip__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_irqchip__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dummy) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqchip__bindgen_ty_1),
            "::",
            stringify!(dummy)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pic) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqchip__bindgen_ty_1),
            "::",
            stringify!(pic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ioapic) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqchip__bindgen_ty_1),
            "::",
            stringify!(ioapic)
        )
    );
}
impl Default for kvm_irqchip__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irqchip__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_irqchip__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_irqchip() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irqchip> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irqchip>(),
        520usize,
        concat!("Size of: ", stringify!(kvm_irqchip))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irqchip>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_irqchip))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).chip_id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqchip),
            "::",
            stringify!(chip_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqchip),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).chip) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqchip),
            "::",
            stringify!(chip)
        )
    );
}
impl Default for kvm_irqchip {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irqchip {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_irqchip {{ chip_id: {:?}, pad: {:?}, chip: {:?} }}",
            self.chip_id, self.pad, self.chip
        )
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_pit_config {
    pub flags: __u32,
    pub pad: [__u32; 15usize],
}
#[test]
fn bindgen_test_layout_kvm_pit_config() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_pit_config> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_pit_config>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_pit_config))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_pit_config>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_pit_config))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_config),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_config),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_hyperv_exit {
    pub type_: __u32,
    pub pad1: __u32,
    pub u: kvm_hyperv_exit__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_hyperv_exit__bindgen_ty_1 {
    pub synic: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1,
    pub hcall: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2,
    pub syndbg: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1 {
    pub msr: __u32,
    pub pad2: __u32,
    pub control: __u64,
    pub evt_page: __u64,
    pub msg_page: __u64,
}
#[test]
fn bindgen_test_layout_kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(msr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad2) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(pad2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).control) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(control)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).evt_page) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(evt_page)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_page) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(msg_page)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2 {
    pub input: __u64,
    pub result: __u64,
    pub params: [__u64; 2usize],
}
#[test]
fn bindgen_test_layout_kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).input) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(input)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).result) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(result)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).params) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(params)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3 {
    pub msr: __u32,
    pub pad2: __u32,
    pub control: __u64,
    pub status: __u64,
    pub send_page: __u64,
    pub recv_page: __u64,
    pub pending_page: __u64,
}
#[test]
fn bindgen_test_layout_kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3>(),
        48usize,
        concat!(
            "Size of: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(msr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad2) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(pad2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).control) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(control)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).status) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).send_page) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(send_page)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).recv_page) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(recv_page)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pending_page) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(pending_page)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_hyperv_exit__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_hyperv_exit__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_hyperv_exit__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_hyperv_exit__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).synic) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1),
            "::",
            stringify!(synic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hcall) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1),
            "::",
            stringify!(hcall)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).syndbg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1),
            "::",
            stringify!(syndbg)
        )
    );
}
impl Default for kvm_hyperv_exit__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_hyperv_exit__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_hyperv_exit__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_hyperv_exit() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_hyperv_exit> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_exit>(),
        56usize,
        concat!("Size of: ", stringify!(kvm_hyperv_exit))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_exit>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_hyperv_exit))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad1) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit),
            "::",
            stringify!(pad1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit),
            "::",
            stringify!(u)
        )
    );
}
impl Default for kvm_hyperv_exit {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_hyperv_exit {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_hyperv_exit {{ type: {:?}, pad1: {:?}, u: {:?} }}",
            self.type_, self.pad1, self.u
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_xen_exit {
    pub type_: __u32,
    pub u: kvm_xen_exit__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_xen_exit__bindgen_ty_1 {
    pub hcall: kvm_xen_exit__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_xen_exit__bindgen_ty_1__bindgen_ty_1 {
    pub longmode: __u32,
    pub cpl: __u32,
    pub input: __u64,
    pub result: __u64,
    pub params: [__u64; 6usize],
}
#[test]
fn bindgen_test_layout_kvm_xen_exit__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xen_exit__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_exit__bindgen_ty_1__bindgen_ty_1>(),
        72usize,
        concat!(
            "Size of: ",
            stringify!(kvm_xen_exit__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_exit__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_xen_exit__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).longmode) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(longmode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpl) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(cpl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).input) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(input)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).result) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(result)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).params) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(params)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_xen_exit__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xen_exit__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_exit__bindgen_ty_1>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_xen_exit__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_exit__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_xen_exit__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hcall) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_exit__bindgen_ty_1),
            "::",
            stringify!(hcall)
        )
    );
}
impl Default for kvm_xen_exit__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_exit__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_xen_exit__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_xen_exit() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_xen_exit> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_exit>(),
        80usize,
        concat!("Size of: ", stringify!(kvm_xen_exit))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_exit>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_xen_exit))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_exit),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_xen_exit),
            "::",
            stringify!(u)
        )
    );
}
impl Default for kvm_xen_exit {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_exit {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_xen_exit {{ type: {:?}, u: {:?} }}",
            self.type_, self.u
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_run {
    pub request_interrupt_window: __u8,
    pub immediate_exit: __u8,
    pub padding1: [__u8; 6usize],
    pub exit_reason: __u32,
    pub ready_for_interrupt_injection: __u8,
    pub if_flag: __u8,
    pub flags: __u16,
    pub cr8: __u64,
    pub apic_base: __u64,
    pub __bindgen_anon_1: kvm_run__bindgen_ty_1,
    pub kvm_valid_regs: __u64,
    pub kvm_dirty_regs: __u64,
    pub s: kvm_run__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_1 {
    pub hw: kvm_run__bindgen_ty_1__bindgen_ty_1,
    pub fail_entry: kvm_run__bindgen_ty_1__bindgen_ty_2,
    pub ex: kvm_run__bindgen_ty_1__bindgen_ty_3,
    pub io: kvm_run__bindgen_ty_1__bindgen_ty_4,
    pub debug: kvm_run__bindgen_ty_1__bindgen_ty_5,
    pub mmio: kvm_run__bindgen_ty_1__bindgen_ty_6,
    pub iocsr_io: kvm_run__bindgen_ty_1__bindgen_ty_7,
    pub hypercall: kvm_run__bindgen_ty_1__bindgen_ty_8,
    pub tpr_access: kvm_run__bindgen_ty_1__bindgen_ty_9,
    pub s390_sieic: kvm_run__bindgen_ty_1__bindgen_ty_10,
    pub s390_reset_flags: __u64,
    pub s390_ucontrol: kvm_run__bindgen_ty_1__bindgen_ty_11,
    pub dcr: kvm_run__bindgen_ty_1__bindgen_ty_12,
    pub internal: kvm_run__bindgen_ty_1__bindgen_ty_13,
    pub emulation_failure: kvm_run__bindgen_ty_1__bindgen_ty_14,
    pub osi: kvm_run__bindgen_ty_1__bindgen_ty_15,
    pub papr_hcall: kvm_run__bindgen_ty_1__bindgen_ty_16,
    pub s390_tsch: kvm_run__bindgen_ty_1__bindgen_ty_17,
    pub epr: kvm_run__bindgen_ty_1__bindgen_ty_18,
    pub system_event: kvm_run__bindgen_ty_1__bindgen_ty_19,
    pub s390_stsi: kvm_run__bindgen_ty_1__bindgen_ty_20,
    pub eoi: kvm_run__bindgen_ty_1__bindgen_ty_21,
    pub hyperv: kvm_hyperv_exit,
    pub arm_nisv: kvm_run__bindgen_ty_1__bindgen_ty_22,
    pub msr: kvm_run__bindgen_ty_1__bindgen_ty_23,
    pub xen: kvm_xen_exit,
    pub riscv_sbi: kvm_run__bindgen_ty_1__bindgen_ty_24,
    pub riscv_csr: kvm_run__bindgen_ty_1__bindgen_ty_25,
    pub notify: kvm_run__bindgen_ty_1__bindgen_ty_26,
    pub memory_fault: kvm_run__bindgen_ty_1__bindgen_ty_27,
    pub padding: [::std::os::raw::c_char; 256usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_1 {
    pub hardware_exit_reason: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hardware_exit_reason) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hardware_exit_reason)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_2 {
    pub hardware_entry_failure_reason: __u64,
    pub cpu: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_2>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).hardware_entry_failure_reason) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(hardware_entry_failure_reason)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpu) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(cpu)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_3 {
    pub exception: __u32,
    pub error_code: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_3() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_3> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_3>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exception) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(exception)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).error_code) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(error_code)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_4 {
    pub direction: __u8,
    pub size: __u8,
    pub port: __u16,
    pub count: __u32,
    pub data_offset: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_4() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_4> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_4>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_4>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).direction) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(direction)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_offset) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(data_offset)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_5 {
    pub arch: kvm_debug_exit_arch,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_5() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_5> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_5>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_5))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_5>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arch) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_5),
            "::",
            stringify!(arch)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_6 {
    pub phys_addr: __u64,
    pub data: [__u8; 8usize],
    pub len: __u32,
    pub is_write: __u8,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_6() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_6> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_6>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_6>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).phys_addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(phys_addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_write) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(is_write)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_7 {
    pub phys_addr: __u64,
    pub data: [__u8; 8usize],
    pub len: __u32,
    pub is_write: __u8,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_7() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_7> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_7>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_7>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).phys_addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(phys_addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_write) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(is_write)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_8 {
    pub nr: __u64,
    pub args: [__u64; 6usize],
    pub ret: __u64,
    pub __bindgen_anon_1: kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1 {
    pub longmode: __u32,
    pub flags: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).longmode) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1),
            "::",
            stringify!(longmode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1 {{ union }}"
        )
    }
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_8() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_8> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_8>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_8>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8),
            "::",
            stringify!(nr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).args) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ret) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8),
            "::",
            stringify!(ret)
        )
    );
}
impl Default for kvm_run__bindgen_ty_1__bindgen_ty_8 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1__bindgen_ty_8 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_run__bindgen_ty_1__bindgen_ty_8 {{ nr: {:?}, args: {:?}, ret: {:?}, __bindgen_anon_1: {:?} }}" , self . nr , self . args , self . ret , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_9 {
    pub rip: __u64,
    pub is_write: __u32,
    pub pad: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_9() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_9> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_9>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_9))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_9>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_9)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rip) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_9),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_write) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_9),
            "::",
            stringify!(is_write)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_9),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_10 {
    pub icptcode: __u8,
    pub ipa: __u16,
    pub ipb: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_10() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_10> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_10>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_10)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_10>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_10)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).icptcode) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_10),
            "::",
            stringify!(icptcode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ipa) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_10),
            "::",
            stringify!(ipa)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ipb) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_10),
            "::",
            stringify!(ipb)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_11 {
    pub trans_exc_code: __u64,
    pub pgm_code: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_11() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_11> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_11>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_11)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_11>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_11)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trans_exc_code) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_11),
            "::",
            stringify!(trans_exc_code)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pgm_code) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_11),
            "::",
            stringify!(pgm_code)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_12 {
    pub dcrn: __u32,
    pub data: __u32,
    pub is_write: __u8,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_12() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_12> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_12>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_12)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_12>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_12)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dcrn) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_12),
            "::",
            stringify!(dcrn)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_12),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_write) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_12),
            "::",
            stringify!(is_write)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_13 {
    pub suberror: __u32,
    pub ndata: __u32,
    pub data: [__u64; 16usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_13() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_13> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_13>(),
        136usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_13)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_13>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_13)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).suberror) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_13),
            "::",
            stringify!(suberror)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ndata) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_13),
            "::",
            stringify!(ndata)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_13),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_14 {
    pub suberror: __u32,
    pub ndata: __u32,
    pub flags: __u64,
    pub __bindgen_anon_1: kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1 {
    pub __bindgen_anon_1: kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1 {
    pub insn_size: __u8,
    pub insn_bytes: [__u8; 15usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<
        kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1,
    > = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).insn_size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(insn_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).insn_bytes) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(insn_bytes)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1)
        )
    );
}
impl Default for kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1 {{ union }}"
        )
    }
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_14() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_14> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_14>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_14>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).suberror) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14),
            "::",
            stringify!(suberror)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ndata) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14),
            "::",
            stringify!(ndata)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for kvm_run__bindgen_ty_1__bindgen_ty_14 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1__bindgen_ty_14 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_run__bindgen_ty_1__bindgen_ty_14 {{ suberror: {:?}, ndata: {:?}, flags: {:?}, __bindgen_anon_1: {:?} }}" , self . suberror , self . ndata , self . flags , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_15 {
    pub gprs: [__u64; 32usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_15() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_15> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_15>(),
        256usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_15)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_15>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_15)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gprs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_15),
            "::",
            stringify!(gprs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_16 {
    pub nr: __u64,
    pub ret: __u64,
    pub args: [__u64; 9usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_16() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_16> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_16>(),
        88usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_16)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_16>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_16),
            "::",
            stringify!(nr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ret) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_16),
            "::",
            stringify!(ret)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).args) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_16),
            "::",
            stringify!(args)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_17 {
    pub subchannel_id: __u16,
    pub subchannel_nr: __u16,
    pub io_int_parm: __u32,
    pub io_int_word: __u32,
    pub ipb: __u32,
    pub dequeued: __u8,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_17() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_17> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_17>(),
        20usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_17>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subchannel_id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17),
            "::",
            stringify!(subchannel_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subchannel_nr) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17),
            "::",
            stringify!(subchannel_nr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).io_int_parm) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17),
            "::",
            stringify!(io_int_parm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).io_int_word) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17),
            "::",
            stringify!(io_int_word)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ipb) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17),
            "::",
            stringify!(ipb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dequeued) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17),
            "::",
            stringify!(dequeued)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_18 {
    pub epr: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_18() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_18> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_18>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_18)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_18>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_18)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).epr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_18),
            "::",
            stringify!(epr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_19 {
    pub type_: __u32,
    pub ndata: __u32,
    pub __bindgen_anon_1: kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1 {
    pub flags: __u64,
    pub data: [__u64; 16usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1>(),
        128usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1),
            "::",
            stringify!(data)
        )
    );
}
impl Default for kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1 {{ union }}"
        )
    }
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_19() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_19> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_19>(),
        136usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_19)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_19>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_19)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_19),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ndata) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_19),
            "::",
            stringify!(ndata)
        )
    );
}
impl Default for kvm_run__bindgen_ty_1__bindgen_ty_19 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1__bindgen_ty_19 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_run__bindgen_ty_1__bindgen_ty_19 {{ type: {:?}, ndata: {:?}, __bindgen_anon_1: {:?} }}" , self . type_ , self . ndata , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_20 {
    pub addr: __u64,
    pub ar: __u8,
    pub reserved: __u8,
    pub fc: __u8,
    pub sel1: __u8,
    pub sel2: __u16,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_20() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_20> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_20>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_20)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_20>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_20)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_20),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ar) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_20),
            "::",
            stringify!(ar)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_20),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fc) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_20),
            "::",
            stringify!(fc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sel1) as usize - ptr as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_20),
            "::",
            stringify!(sel1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sel2) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_20),
            "::",
            stringify!(sel2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_21 {
    pub vector: __u8,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_21() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_21> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_21>(),
        1usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_21)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_21>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_21)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vector) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_21),
            "::",
            stringify!(vector)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_22 {
    pub esr_iss: __u64,
    pub fault_ipa: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_22() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_22> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_22>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_22)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_22>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_22)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).esr_iss) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_22),
            "::",
            stringify!(esr_iss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fault_ipa) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_22),
            "::",
            stringify!(fault_ipa)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_23 {
    pub error: __u8,
    pub pad: [__u8; 7usize],
    pub reason: __u32,
    pub index: __u32,
    pub data: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_23() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_23> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_23>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_23)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_23>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_23)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).error) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_23),
            "::",
            stringify!(error)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_23),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reason) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_23),
            "::",
            stringify!(reason)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_23),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_23),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_24 {
    pub extension_id: ::std::os::raw::c_ulong,
    pub function_id: ::std::os::raw::c_ulong,
    pub args: [::std::os::raw::c_ulong; 6usize],
    pub ret: [::std::os::raw::c_ulong; 2usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_24() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_24> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_24>(),
        80usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_24)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_24>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_24)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extension_id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_24),
            "::",
            stringify!(extension_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).function_id) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_24),
            "::",
            stringify!(function_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).args) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_24),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ret) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_24),
            "::",
            stringify!(ret)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_25 {
    pub csr_num: ::std::os::raw::c_ulong,
    pub new_value: ::std::os::raw::c_ulong,
    pub write_mask: ::std::os::raw::c_ulong,
    pub ret_value: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_25() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_25> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_25>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_25)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_25>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_25)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csr_num) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_25),
            "::",
            stringify!(csr_num)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).new_value) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_25),
            "::",
            stringify!(new_value)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_mask) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_25),
            "::",
            stringify!(write_mask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ret_value) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_25),
            "::",
            stringify!(ret_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_26 {
    pub flags: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_26() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_26> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_26>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_26)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_26>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_26)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_26),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_27 {
    pub flags: __u64,
    pub gpa: __u64,
    pub size: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_27() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1__bindgen_ty_27> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_27>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_27)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_27>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_27)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_27),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gpa) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_27),
            "::",
            stringify!(gpa)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_27),
            "::",
            stringify!(size)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1>(),
        256usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_run__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hw) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(hw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fail_entry) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(fail_entry)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ex) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(ex)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).io) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(io)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).debug) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(debug)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mmio) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(mmio)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).iocsr_io) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(iocsr_io)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hypercall) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(hypercall)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tpr_access) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(tpr_access)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s390_sieic) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(s390_sieic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s390_reset_flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(s390_reset_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s390_ucontrol) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(s390_ucontrol)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dcr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(dcr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).internal) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(internal)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).emulation_failure) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(emulation_failure)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).osi) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(osi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).papr_hcall) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(papr_hcall)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s390_tsch) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(s390_tsch)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).epr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(epr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).system_event) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(system_event)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s390_stsi) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(s390_stsi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eoi) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(eoi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(hyperv)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_nisv) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(arm_nisv)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(msr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xen) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(xen)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).riscv_sbi) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(riscv_sbi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).riscv_csr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(riscv_csr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).notify) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(notify)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).memory_fault) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(memory_fault)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(padding)
        )
    );
}
impl Default for kvm_run__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_run__bindgen_ty_1 {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_2 {
    pub regs: kvm_sync_regs,
    pub padding: [::std::os::raw::c_char; 2048usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_2>(),
        2048usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_run__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).regs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_2),
            "::",
            stringify!(regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_2),
            "::",
            stringify!(padding)
        )
    );
}
impl Default for kvm_run__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_run__bindgen_ty_2 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_run() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_run> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_run>(),
        2352usize,
        concat!("Size of: ", stringify!(kvm_run))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_run))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).request_interrupt_window) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(request_interrupt_window)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).immediate_exit) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(immediate_exit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding1) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(padding1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exit_reason) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(exit_reason)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).ready_for_interrupt_injection) as usize - ptr as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(ready_for_interrupt_injection)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).if_flag) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(if_flag)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cr8) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(cr8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).apic_base) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(apic_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kvm_valid_regs) as usize - ptr as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(kvm_valid_regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kvm_dirty_regs) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(kvm_dirty_regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s) as usize - ptr as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(s)
        )
    );
}
impl Default for kvm_run {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_run {{ request_interrupt_window: {:?}, immediate_exit: {:?}, padding1: {:?}, exit_reason: {:?}, ready_for_interrupt_injection: {:?}, if_flag: {:?}, flags: {:?}, cr8: {:?}, apic_base: {:?}, __bindgen_anon_1: {:?}, kvm_valid_regs: {:?}, kvm_dirty_regs: {:?}, s: {:?} }}" , self . request_interrupt_window , self . immediate_exit , self . padding1 , self . exit_reason , self . ready_for_interrupt_injection , self . if_flag , self . flags , self . cr8 , self . apic_base , self . __bindgen_anon_1 , self . kvm_valid_regs , self . kvm_dirty_regs , self . s)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_coalesced_mmio_zone {
    pub addr: __u64,
    pub size: __u32,
    pub __bindgen_anon_1: kvm_coalesced_mmio_zone__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_coalesced_mmio_zone__bindgen_ty_1 {
    pub pad: __u32,
    pub pio: __u32,
}
#[test]
fn bindgen_test_layout_kvm_coalesced_mmio_zone__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_coalesced_mmio_zone__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_coalesced_mmio_zone__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(kvm_coalesced_mmio_zone__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_coalesced_mmio_zone__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_coalesced_mmio_zone__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_zone__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pio) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_zone__bindgen_ty_1),
            "::",
            stringify!(pio)
        )
    );
}
impl Default for kvm_coalesced_mmio_zone__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_coalesced_mmio_zone__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_coalesced_mmio_zone__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_coalesced_mmio_zone() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_coalesced_mmio_zone> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_coalesced_mmio_zone>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_coalesced_mmio_zone))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_coalesced_mmio_zone>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_coalesced_mmio_zone))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_zone),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_zone),
            "::",
            stringify!(size)
        )
    );
}
impl Default for kvm_coalesced_mmio_zone {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_coalesced_mmio_zone {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_coalesced_mmio_zone {{ addr: {:?}, size: {:?}, __bindgen_anon_1: {:?} }}",
            self.addr, self.size, self.__bindgen_anon_1
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_coalesced_mmio {
    pub phys_addr: __u64,
    pub len: __u32,
    pub __bindgen_anon_1: kvm_coalesced_mmio__bindgen_ty_1,
    pub data: [__u8; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_coalesced_mmio__bindgen_ty_1 {
    pub pad: __u32,
    pub pio: __u32,
}
#[test]
fn bindgen_test_layout_kvm_coalesced_mmio__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_coalesced_mmio__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_coalesced_mmio__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_coalesced_mmio__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_coalesced_mmio__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_coalesced_mmio__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pio) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio__bindgen_ty_1),
            "::",
            stringify!(pio)
        )
    );
}
impl Default for kvm_coalesced_mmio__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_coalesced_mmio__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_coalesced_mmio__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_coalesced_mmio() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_coalesced_mmio> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_coalesced_mmio>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_coalesced_mmio))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_coalesced_mmio>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_coalesced_mmio))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).phys_addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio),
            "::",
            stringify!(phys_addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio),
            "::",
            stringify!(data)
        )
    );
}
impl Default for kvm_coalesced_mmio {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_coalesced_mmio {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_coalesced_mmio {{ phys_addr: {:?}, len: {:?}, __bindgen_anon_1: {:?}, data: {:?} }}" , self . phys_addr , self . len , self . __bindgen_anon_1 , self . data)
    }
}
#[repr(C)]
pub struct kvm_coalesced_mmio_ring {
    pub first: __u32,
    pub last: __u32,
    pub coalesced_mmio: __IncompleteArrayField<kvm_coalesced_mmio>,
}
#[test]
fn bindgen_test_layout_kvm_coalesced_mmio_ring() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_coalesced_mmio_ring> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_coalesced_mmio_ring>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_coalesced_mmio_ring))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_coalesced_mmio_ring>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_coalesced_mmio_ring))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).first) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_ring),
            "::",
            stringify!(first)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_ring),
            "::",
            stringify!(last)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).coalesced_mmio) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_ring),
            "::",
            stringify!(coalesced_mmio)
        )
    );
}
impl Default for kvm_coalesced_mmio_ring {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_coalesced_mmio_ring {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_coalesced_mmio_ring {{ first: {:?}, last: {:?}, coalesced_mmio: {:?} }}",
            self.first, self.last, self.coalesced_mmio
        )
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_translation {
    pub linear_address: __u64,
    pub physical_address: __u64,
    pub valid: __u8,
    pub writeable: __u8,
    pub usermode: __u8,
    pub pad: [__u8; 5usize],
}
#[test]
fn bindgen_test_layout_kvm_translation() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_translation> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_translation>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_translation))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_translation>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_translation))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).linear_address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_translation),
            "::",
            stringify!(linear_address)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).physical_address) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_translation),
            "::",
            stringify!(physical_address)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).valid) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_translation),
            "::",
            stringify!(valid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).writeable) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_translation),
            "::",
            stringify!(writeable)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).usermode) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_translation),
            "::",
            stringify!(usermode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_translation),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_interrupt {
    pub irq: __u32,
}
#[test]
fn bindgen_test_layout_kvm_interrupt() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_interrupt> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_interrupt>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_interrupt))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_interrupt>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_interrupt))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).irq) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_interrupt),
            "::",
            stringify!(irq)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_dirty_log {
    pub slot: __u32,
    pub padding1: __u32,
    pub __bindgen_anon_1: kvm_dirty_log__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_dirty_log__bindgen_ty_1 {
    pub dirty_bitmap: *mut ::std::os::raw::c_void,
    pub padding2: __u64,
}
#[test]
fn bindgen_test_layout_kvm_dirty_log__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_dirty_log__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_dirty_log__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_dirty_log__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_dirty_log__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_dirty_log__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dirty_bitmap) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_log__bindgen_ty_1),
            "::",
            stringify!(dirty_bitmap)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding2) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_log__bindgen_ty_1),
            "::",
            stringify!(padding2)
        )
    );
}
impl Default for kvm_dirty_log__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_dirty_log__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_dirty_log__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_dirty_log() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_dirty_log> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_dirty_log>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_dirty_log))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_dirty_log>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_dirty_log))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).slot) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_log),
            "::",
            stringify!(slot)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding1) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_log),
            "::",
            stringify!(padding1)
        )
    );
}
impl Default for kvm_dirty_log {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_dirty_log {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_dirty_log {{ slot: {:?}, padding1: {:?}, __bindgen_anon_1: {:?} }}",
            self.slot, self.padding1, self.__bindgen_anon_1
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_clear_dirty_log {
    pub slot: __u32,
    pub num_pages: __u32,
    pub first_page: __u64,
    pub __bindgen_anon_1: kvm_clear_dirty_log__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_clear_dirty_log__bindgen_ty_1 {
    pub dirty_bitmap: *mut ::std::os::raw::c_void,
    pub padding2: __u64,
}
#[test]
fn bindgen_test_layout_kvm_clear_dirty_log__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_clear_dirty_log__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_clear_dirty_log__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_clear_dirty_log__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_clear_dirty_log__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_clear_dirty_log__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dirty_bitmap) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clear_dirty_log__bindgen_ty_1),
            "::",
            stringify!(dirty_bitmap)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding2) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clear_dirty_log__bindgen_ty_1),
            "::",
            stringify!(padding2)
        )
    );
}
impl Default for kvm_clear_dirty_log__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_clear_dirty_log__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_clear_dirty_log__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_clear_dirty_log() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_clear_dirty_log> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_clear_dirty_log>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_clear_dirty_log))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_clear_dirty_log>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_clear_dirty_log))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).slot) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clear_dirty_log),
            "::",
            stringify!(slot)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_pages) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clear_dirty_log),
            "::",
            stringify!(num_pages)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).first_page) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clear_dirty_log),
            "::",
            stringify!(first_page)
        )
    );
}
impl Default for kvm_clear_dirty_log {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_clear_dirty_log {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_clear_dirty_log {{ slot: {:?}, num_pages: {:?}, first_page: {:?}, __bindgen_anon_1: {:?} }}" , self . slot , self . num_pages , self . first_page , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_signal_mask {
    pub len: __u32,
    pub sigset: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_kvm_signal_mask() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_signal_mask> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_signal_mask>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_signal_mask))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_signal_mask>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_signal_mask))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_signal_mask),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sigset) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_signal_mask),
            "::",
            stringify!(sigset)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_tpr_access_ctl {
    pub enabled: __u32,
    pub flags: __u32,
    pub reserved: [__u32; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_tpr_access_ctl() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_tpr_access_ctl> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_tpr_access_ctl>(),
        40usize,
        concat!("Size of: ", stringify!(kvm_tpr_access_ctl))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_tpr_access_ctl>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_tpr_access_ctl))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enabled) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_tpr_access_ctl),
            "::",
            stringify!(enabled)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_tpr_access_ctl),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_tpr_access_ctl),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_vapic_addr {
    pub vapic_addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_vapic_addr() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_vapic_addr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_vapic_addr>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_vapic_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vapic_addr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_vapic_addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vapic_addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vapic_addr),
            "::",
            stringify!(vapic_addr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_mp_state {
    pub mp_state: __u32,
}
#[test]
fn bindgen_test_layout_kvm_mp_state() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_mp_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_mp_state>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_mp_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_mp_state>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_mp_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mp_state) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_mp_state),
            "::",
            stringify!(mp_state)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_guest_debug {
    pub control: __u32,
    pub pad: __u32,
    pub arch: kvm_guest_debug_arch,
}
#[test]
fn bindgen_test_layout_kvm_guest_debug() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_guest_debug> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_guest_debug>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_guest_debug))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_guest_debug>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_guest_debug))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).control) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_guest_debug),
            "::",
            stringify!(control)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_guest_debug),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arch) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_guest_debug),
            "::",
            stringify!(arch)
        )
    );
}
pub const kvm_ioeventfd_flag_nr_datamatch: _bindgen_ty_1 = 0;
pub const kvm_ioeventfd_flag_nr_pio: _bindgen_ty_1 = 1;
pub const kvm_ioeventfd_flag_nr_deassign: _bindgen_ty_1 = 2;
pub const kvm_ioeventfd_flag_nr_virtio_ccw_notify: _bindgen_ty_1 = 3;
pub const kvm_ioeventfd_flag_nr_fast_mmio: _bindgen_ty_1 = 4;
pub const kvm_ioeventfd_flag_nr_max: _bindgen_ty_1 = 5;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct kvm_ioeventfd {
    pub datamatch: __u64,
    pub addr: __u64,
    pub len: __u32,
    pub fd: __s32,
    pub flags: __u32,
    pub pad: [__u8; 36usize],
}
#[test]
fn bindgen_test_layout_kvm_ioeventfd() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_ioeventfd> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_ioeventfd>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_ioeventfd))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ioeventfd>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_ioeventfd))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).datamatch) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioeventfd),
            "::",
            stringify!(datamatch)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioeventfd),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioeventfd),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fd) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioeventfd),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioeventfd),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioeventfd),
            "::",
            stringify!(pad)
        )
    );
}
impl Default for kvm_ioeventfd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct kvm_enable_cap {
    pub cap: __u32,
    pub flags: __u32,
    pub args: [__u64; 4usize],
    pub pad: [__u8; 64usize],
}
#[test]
fn bindgen_test_layout_kvm_enable_cap() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_enable_cap> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_enable_cap>(),
        104usize,
        concat!("Size of: ", stringify!(kvm_enable_cap))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_enable_cap>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_enable_cap))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cap) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_enable_cap),
            "::",
            stringify!(cap)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_enable_cap),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).args) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_enable_cap),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_enable_cap),
            "::",
            stringify!(pad)
        )
    );
}
impl Default for kvm_enable_cap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irq_routing_irqchip {
    pub irqchip: __u32,
    pub pin: __u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_irqchip() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irq_routing_irqchip> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_irqchip>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_irqchip))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_irqchip>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_irqchip))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).irqchip) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_irqchip),
            "::",
            stringify!(irqchip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pin) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_irqchip),
            "::",
            stringify!(pin)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irq_routing_msi {
    pub address_lo: __u32,
    pub address_hi: __u32,
    pub data: __u32,
    pub __bindgen_anon_1: kvm_irq_routing_msi__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irq_routing_msi__bindgen_ty_1 {
    pub pad: __u32,
    pub devid: __u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_msi__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irq_routing_msi__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_msi__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_msi__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_msi__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_irq_routing_msi__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_msi__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).devid) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_msi__bindgen_ty_1),
            "::",
            stringify!(devid)
        )
    );
}
impl Default for kvm_irq_routing_msi__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_routing_msi__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_irq_routing_msi__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_msi() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irq_routing_msi> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_msi>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_msi))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_msi>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_msi))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).address_lo) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_msi),
            "::",
            stringify!(address_lo)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).address_hi) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_msi),
            "::",
            stringify!(address_hi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_msi),
            "::",
            stringify!(data)
        )
    );
}
impl Default for kvm_irq_routing_msi {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_routing_msi {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_irq_routing_msi {{ address_lo: {:?}, address_hi: {:?}, data: {:?}, __bindgen_anon_1: {:?} }}" , self . address_lo , self . address_hi , self . data , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irq_routing_s390_adapter {
    pub ind_addr: __u64,
    pub summary_addr: __u64,
    pub ind_offset: __u64,
    pub summary_offset: __u32,
    pub adapter_id: __u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_s390_adapter() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irq_routing_s390_adapter> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_s390_adapter>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_s390_adapter))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_s390_adapter>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_s390_adapter))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ind_addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_s390_adapter),
            "::",
            stringify!(ind_addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).summary_addr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_s390_adapter),
            "::",
            stringify!(summary_addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ind_offset) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_s390_adapter),
            "::",
            stringify!(ind_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).summary_offset) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_s390_adapter),
            "::",
            stringify!(summary_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).adapter_id) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_s390_adapter),
            "::",
            stringify!(adapter_id)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irq_routing_hv_sint {
    pub vcpu: __u32,
    pub sint: __u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_hv_sint() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irq_routing_hv_sint> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_hv_sint>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_hv_sint))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_hv_sint>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_hv_sint))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vcpu) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_hv_sint),
            "::",
            stringify!(vcpu)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sint) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_hv_sint),
            "::",
            stringify!(sint)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irq_routing_xen_evtchn {
    pub port: __u32,
    pub vcpu: __u32,
    pub priority: __u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_xen_evtchn() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irq_routing_xen_evtchn> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_xen_evtchn>(),
        12usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_xen_evtchn))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_xen_evtchn>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_xen_evtchn))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_xen_evtchn),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vcpu) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_xen_evtchn),
            "::",
            stringify!(vcpu)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).priority) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_xen_evtchn),
            "::",
            stringify!(priority)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irq_routing_entry {
    pub gsi: __u32,
    pub type_: __u32,
    pub flags: __u32,
    pub pad: __u32,
    pub u: kvm_irq_routing_entry__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irq_routing_entry__bindgen_ty_1 {
    pub irqchip: kvm_irq_routing_irqchip,
    pub msi: kvm_irq_routing_msi,
    pub adapter: kvm_irq_routing_s390_adapter,
    pub hv_sint: kvm_irq_routing_hv_sint,
    pub xen_evtchn: kvm_irq_routing_xen_evtchn,
    pub pad: [__u32; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_entry__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irq_routing_entry__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_entry__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_entry__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_entry__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).irqchip) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1),
            "::",
            stringify!(irqchip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msi) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1),
            "::",
            stringify!(msi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).adapter) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1),
            "::",
            stringify!(adapter)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hv_sint) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1),
            "::",
            stringify!(hv_sint)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xen_evtchn) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1),
            "::",
            stringify!(xen_evtchn)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
}
impl Default for kvm_irq_routing_entry__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_routing_entry__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_irq_routing_entry__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_entry() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irq_routing_entry> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_entry>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_entry))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gsi) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry),
            "::",
            stringify!(gsi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry),
            "::",
            stringify!(u)
        )
    );
}
impl Default for kvm_irq_routing_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_routing_entry {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_irq_routing_entry {{ gsi: {:?}, type: {:?}, flags: {:?}, pad: {:?}, u: {:?} }}",
            self.gsi, self.type_, self.flags, self.pad, self.u
        )
    }
}
#[repr(C)]
pub struct kvm_irq_routing {
    pub nr: __u32,
    pub flags: __u32,
    pub entries: __IncompleteArrayField<kvm_irq_routing_entry>,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irq_routing> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_irq_routing))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing),
            "::",
            stringify!(nr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing),
            "::",
            stringify!(entries)
        )
    );
}
impl Default for kvm_irq_routing {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_routing {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_irq_routing {{ nr: {:?}, flags: {:?}, entries: {:?} }}",
            self.nr, self.flags, self.entries
        )
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irqfd {
    pub fd: __u32,
    pub gsi: __u32,
    pub flags: __u32,
    pub resamplefd: __u32,
    pub pad: [__u8; 16usize],
}
#[test]
fn bindgen_test_layout_kvm_irqfd() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_irqfd> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_irqfd>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_irqfd))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irqfd>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irqfd))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fd) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqfd),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gsi) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqfd),
            "::",
            stringify!(gsi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqfd),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).resamplefd) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqfd),
            "::",
            stringify!(resamplefd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqfd),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_clock_data {
    pub clock: __u64,
    pub flags: __u32,
    pub pad0: __u32,
    pub realtime: __u64,
    pub host_tsc: __u64,
    pub pad: [__u32; 4usize],
}
#[test]
fn bindgen_test_layout_kvm_clock_data() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_clock_data> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_clock_data>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_clock_data))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_clock_data>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_clock_data))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clock) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clock_data),
            "::",
            stringify!(clock)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clock_data),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad0) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clock_data),
            "::",
            stringify!(pad0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).realtime) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clock_data),
            "::",
            stringify!(realtime)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).host_tsc) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clock_data),
            "::",
            stringify!(host_tsc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clock_data),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_config_tlb {
    pub params: __u64,
    pub array: __u64,
    pub mmu_type: __u32,
    pub array_len: __u32,
}
#[test]
fn bindgen_test_layout_kvm_config_tlb() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_config_tlb> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_config_tlb>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_config_tlb))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_config_tlb>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_config_tlb))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).params) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_config_tlb),
            "::",
            stringify!(params)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).array) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_config_tlb),
            "::",
            stringify!(array)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mmu_type) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_config_tlb),
            "::",
            stringify!(mmu_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).array_len) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_config_tlb),
            "::",
            stringify!(array_len)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_dirty_tlb {
    pub bitmap: __u64,
    pub num_dirty: __u32,
}
#[test]
fn bindgen_test_layout_kvm_dirty_tlb() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_dirty_tlb> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_dirty_tlb>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_dirty_tlb))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_dirty_tlb>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_dirty_tlb))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bitmap) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_tlb),
            "::",
            stringify!(bitmap)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_dirty) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_tlb),
            "::",
            stringify!(num_dirty)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_reg_list {
    pub n: __u64,
    pub reg: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_kvm_reg_list() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_reg_list> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_reg_list>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_reg_list))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_reg_list>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_reg_list))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).n) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_reg_list),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reg) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_reg_list),
            "::",
            stringify!(reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_one_reg {
    pub id: __u64,
    pub addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_one_reg() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_one_reg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_one_reg>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_one_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_one_reg>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_one_reg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_one_reg),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_one_reg),
            "::",
            stringify!(addr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_msi {
    pub address_lo: __u32,
    pub address_hi: __u32,
    pub data: __u32,
    pub flags: __u32,
    pub devid: __u32,
    pub pad: [__u8; 12usize],
}
#[test]
fn bindgen_test_layout_kvm_msi() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_msi> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_msi>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_msi))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_msi>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_msi))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).address_lo) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msi),
            "::",
            stringify!(address_lo)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).address_hi) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msi),
            "::",
            stringify!(address_hi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msi),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msi),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).devid) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msi),
            "::",
            stringify!(devid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msi),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_arm_device_addr {
    pub id: __u64,
    pub addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_arm_device_addr() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_arm_device_addr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_arm_device_addr>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_arm_device_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_arm_device_addr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_arm_device_addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_arm_device_addr),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_arm_device_addr),
            "::",
            stringify!(addr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_create_device {
    pub type_: __u32,
    pub fd: __u32,
    pub flags: __u32,
}
#[test]
fn bindgen_test_layout_kvm_create_device() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_create_device> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_create_device>(),
        12usize,
        concat!("Size of: ", stringify!(kvm_create_device))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_create_device>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_create_device))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_create_device),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fd) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_create_device),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_create_device),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_device_attr {
    pub flags: __u32,
    pub group: __u32,
    pub attr: __u64,
    pub addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_device_attr() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_device_attr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_device_attr>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_device_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_device_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_device_attr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_device_attr),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).group) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_device_attr),
            "::",
            stringify!(group)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).attr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_device_attr),
            "::",
            stringify!(attr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_device_attr),
            "::",
            stringify!(addr)
        )
    );
}
pub const kvm_device_type_KVM_DEV_TYPE_FSL_MPIC_20: kvm_device_type = 1;
pub const kvm_device_type_KVM_DEV_TYPE_FSL_MPIC_42: kvm_device_type = 2;
pub const kvm_device_type_KVM_DEV_TYPE_XICS: kvm_device_type = 3;
pub const kvm_device_type_KVM_DEV_TYPE_VFIO: kvm_device_type = 4;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_VGIC_V2: kvm_device_type = 5;
pub const kvm_device_type_KVM_DEV_TYPE_FLIC: kvm_device_type = 6;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_VGIC_V3: kvm_device_type = 7;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_VGIC_ITS: kvm_device_type = 8;
pub const kvm_device_type_KVM_DEV_TYPE_XIVE: kvm_device_type = 9;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_PV_TIME: kvm_device_type = 10;
pub const kvm_device_type_KVM_DEV_TYPE_RISCV_AIA: kvm_device_type = 11;
pub const kvm_device_type_KVM_DEV_TYPE_MAX: kvm_device_type = 12;
pub type kvm_device_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_vfio_spapr_tce {
    pub groupfd: __s32,
    pub tablefd: __s32,
}
#[test]
fn bindgen_test_layout_kvm_vfio_spapr_tce() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_vfio_spapr_tce> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_vfio_spapr_tce>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_vfio_spapr_tce))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vfio_spapr_tce>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_vfio_spapr_tce))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).groupfd) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vfio_spapr_tce),
            "::",
            stringify!(groupfd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tablefd) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vfio_spapr_tce),
            "::",
            stringify!(tablefd)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_enc_region {
    pub addr: __u64,
    pub size: __u64,
}
#[test]
fn bindgen_test_layout_kvm_enc_region() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_enc_region> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_enc_region>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_enc_region))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_enc_region>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_enc_region))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_enc_region),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_enc_region),
            "::",
            stringify!(size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_dirty_gfn {
    pub flags: __u32,
    pub slot: __u32,
    pub offset: __u64,
}
#[test]
fn bindgen_test_layout_kvm_dirty_gfn() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_dirty_gfn> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_dirty_gfn>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_dirty_gfn))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_dirty_gfn>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_dirty_gfn))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_gfn),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).slot) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_gfn),
            "::",
            stringify!(slot)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_gfn),
            "::",
            stringify!(offset)
        )
    );
}
#[doc = " struct kvm_stats_header - Header of per vm/vcpu binary statistics data.\n @flags: Some extra information for header, always 0 for now.\n @name_size: The size in bytes of the memory which contains statistics\n             name string including trailing '\\0'. The memory is allocated\n             at the send of statistics descriptor.\n @num_desc: The number of statistics the vm or vcpu has.\n @id_offset: The offset of the vm/vcpu stats' id string in the file pointed\n             by vm/vcpu stats fd.\n @desc_offset: The offset of the vm/vcpu stats' descriptor block in the file\n               pointd by vm/vcpu stats fd.\n @data_offset: The offset of the vm/vcpu stats' data block in the file\n               pointed by vm/vcpu stats fd.\n\n This is the header userspace needs to read from stats fd before any other\n readings. It is used by userspace to discover all the information about the\n vm/vcpu's binary statistics.\n Userspace reads this header from the start of the vm/vcpu's stats fd."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_stats_header {
    pub flags: __u32,
    pub name_size: __u32,
    pub num_desc: __u32,
    pub id_offset: __u32,
    pub desc_offset: __u32,
    pub data_offset: __u32,
}
#[test]
fn bindgen_test_layout_kvm_stats_header() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_stats_header> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_stats_header>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_stats_header))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_stats_header>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_stats_header))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_stats_header),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_stats_header),
            "::",
            stringify!(name_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_desc) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_stats_header),
            "::",
            stringify!(num_desc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id_offset) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_stats_header),
            "::",
            stringify!(id_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).desc_offset) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_stats_header),
            "::",
            stringify!(desc_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_offset) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_stats_header),
            "::",
            stringify!(data_offset)
        )
    );
}
#[doc = " struct kvm_stats_desc - Descriptor of a KVM statistics.\n @flags: Annotations of the stats, like type, unit, etc.\n @exponent: Used together with @flags to determine the unit.\n @size: The number of data items for this stats.\n        Every data item is of type __u64.\n @offset: The offset of the stats to the start of stat structure in\n          structure kvm or kvm_vcpu.\n @bucket_size: A parameter value used for histogram stats. It is only used\n\t\tfor linear histogram stats, specifying the size of the bucket;\n @name: The name string for the stats. Its size is indicated by the\n        &kvm_stats_header->name_size."]
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_stats_desc {
    pub flags: __u32,
    pub exponent: __s16,
    pub size: __u16,
    pub offset: __u32,
    pub bucket_size: __u32,
    pub name: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[test]
fn bindgen_test_layout_kvm_stats_desc() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_stats_desc> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_stats_desc>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_stats_desc))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_stats_desc>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_stats_desc))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_stats_desc),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exponent) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_stats_desc),
            "::",
            stringify!(exponent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_stats_desc),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_stats_desc),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bucket_size) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_stats_desc),
            "::",
            stringify!(bucket_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_stats_desc),
            "::",
            stringify!(name)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_memory_attributes {
    pub address: __u64,
    pub size: __u64,
    pub attributes: __u64,
    pub flags: __u64,
}
#[test]
fn bindgen_test_layout_kvm_memory_attributes() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_memory_attributes> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_memory_attributes>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_memory_attributes))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_memory_attributes>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_memory_attributes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_memory_attributes),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_memory_attributes),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).attributes) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_memory_attributes),
            "::",
            stringify!(attributes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_memory_attributes),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_create_guest_memfd {
    pub size: __u64,
    pub flags: __u64,
    pub reserved: [__u64; 6usize],
}
#[test]
fn bindgen_test_layout_kvm_create_guest_memfd() {
    const UNINIT: ::std::mem::MaybeUninit<kvm_create_guest_memfd> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kvm_create_guest_memfd>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_create_guest_memfd))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_create_guest_memfd>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_create_guest_memfd))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_create_guest_memfd),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_create_guest_memfd),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_create_guest_memfd),
            "::",
            stringify!(reserved)
        )
    );
}
