# Guards

A `match` *guard* can be added to filter the arm.

```rust,editable
fn main() {
    let pair = (2, -2);
    // TODO ^ Try different values for `pair`

    println!("Tell me about {:?}", pair);
    match pair {
        (x, y) if x == y => println!("These are twins"),
        // The ^ `if condition` part is a guard
        (x, y) if x + y == 0 => println!("Antimatter, kaboom!"),
        (x, _) if x % 2 == 1 => println!("The first one is odd"),
        _ => println!("No correlation..."),
    }
}
```

Note that the compiler does not check arbitrary expressions for whether all
possible conditions have been checked.  Therefore, you must use the `_` pattern
at the end.

```rust,editable
fn main() {
    let number: u8 = 4;

    match number {
        i if i == 0 => println!("Zero"),
        i if i > 0 => println!("Greater than zero"),
        _ => println!("Fell through"), // This should not be possible to reach
    }
}
```

### See also:

[Tuples](../../primitives/tuples.md)
