/* rygel-tracker-category-all-container.c generated by valac 0.36.6, the Vala compiler
 * generated from rygel-tracker-category-all-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2012 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;
typedef struct _RygelTrackerSearchContainerPrivate RygelTrackerSearchContainerPrivate;

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;

#define RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER (rygel_tracker_category_all_container_get_type ())
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainer))
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainerClass))
#define RYGEL_TRACKER_IS_CATEGORY_ALL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER))
#define RYGEL_TRACKER_IS_CATEGORY_ALL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER))
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainerClass))

typedef struct _RygelTrackerCategoryAllContainer RygelTrackerCategoryAllContainer;
typedef struct _RygelTrackerCategoryAllContainerClass RygelTrackerCategoryAllContainerClass;
typedef struct _RygelTrackerCategoryAllContainerPrivate RygelTrackerCategoryAllContainerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_CATEGORY_CONTAINER (rygel_tracker_category_container_get_type ())
#define RYGEL_TRACKER_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_CATEGORY_CONTAINER, RygelTrackerCategoryContainer))
#define RYGEL_TRACKER_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_CATEGORY_CONTAINER, RygelTrackerCategoryContainerClass))
#define RYGEL_TRACKER_IS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_CATEGORY_CONTAINER))
#define RYGEL_TRACKER_IS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_CATEGORY_CONTAINER))
#define RYGEL_TRACKER_CATEGORY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_CATEGORY_CONTAINER, RygelTrackerCategoryContainerClass))

typedef struct _RygelTrackerCategoryContainer RygelTrackerCategoryContainer;
typedef struct _RygelTrackerCategoryContainerClass RygelTrackerCategoryContainerClass;
typedef struct _RygelTrackerCategoryContainerPrivate RygelTrackerCategoryContainerPrivate;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TRACKER_TYPE_CLEANUP_QUERY (rygel_tracker_cleanup_query_get_type ())
#define RYGEL_TRACKER_CLEANUP_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_CLEANUP_QUERY, RygelTrackerCleanupQuery))
#define RYGEL_TRACKER_CLEANUP_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_CLEANUP_QUERY, RygelTrackerCleanupQueryClass))
#define RYGEL_TRACKER_IS_CLEANUP_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_CLEANUP_QUERY))
#define RYGEL_TRACKER_IS_CLEANUP_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_CLEANUP_QUERY))
#define RYGEL_TRACKER_CLEANUP_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_CLEANUP_QUERY, RygelTrackerCleanupQueryClass))

typedef struct _RygelTrackerCleanupQuery RygelTrackerCleanupQuery;
typedef struct _RygelTrackerCleanupQueryClass RygelTrackerCleanupQueryClass;
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
typedef struct _RygelTrackerCategoryAllContainerAddItemData RygelTrackerCategoryAllContainerAddItemData;
typedef struct _RygelTrackerCategoryAllContainerAddContainerData RygelTrackerCategoryAllContainerAddContainerData;
typedef struct _RygelTrackerCategoryAllContainerRemoveItemData RygelTrackerCategoryAllContainerRemoveItemData;
typedef struct _RygelTrackerCategoryAllContainerRemoveContainerData RygelTrackerCategoryAllContainerRemoveContainerData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelTrackerCategoryAllContainerSearchData RygelTrackerCategoryAllContainerSearchData;

#define RYGEL_TRACKER_TYPE_INSERTION_QUERY (rygel_tracker_insertion_query_get_type ())
#define RYGEL_TRACKER_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQuery))
#define RYGEL_TRACKER_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))
#define RYGEL_TRACKER_IS_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_IS_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_INSERTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))

typedef struct _RygelTrackerInsertionQuery RygelTrackerInsertionQuery;
typedef struct _RygelTrackerInsertionQueryClass RygelTrackerInsertionQueryClass;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;
typedef struct _RygelTrackerInsertionQueryPrivate RygelTrackerInsertionQueryPrivate;
typedef struct _RygelTrackerCategoryAllContainerCreateEntryInStoreData RygelTrackerCategoryAllContainerCreateEntryInStoreData;

#define RYGEL_TRACKER_TYPE_DELETION_QUERY (rygel_tracker_deletion_query_get_type ())
#define RYGEL_TRACKER_DELETION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_DELETION_QUERY, RygelTrackerDeletionQuery))
#define RYGEL_TRACKER_DELETION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_DELETION_QUERY, RygelTrackerDeletionQueryClass))
#define RYGEL_TRACKER_IS_DELETION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_DELETION_QUERY))
#define RYGEL_TRACKER_IS_DELETION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_DELETION_QUERY))
#define RYGEL_TRACKER_DELETION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_DELETION_QUERY, RygelTrackerDeletionQueryClass))

typedef struct _RygelTrackerDeletionQuery RygelTrackerDeletionQuery;
typedef struct _RygelTrackerDeletionQueryClass RygelTrackerDeletionQueryClass;
typedef struct _RygelTrackerCategoryAllContainerRemoveEntryFromStoreData RygelTrackerCategoryAllContainerRemoveEntryFromStoreData;

struct _RygelTrackerSearchContainer {
	RygelSimpleContainer parent_instance;
	RygelTrackerSearchContainerPrivate * priv;
	RygelTrackerSelectionQuery* query;
	RygelTrackerItemFactory* item_factory;
};

struct _RygelTrackerSearchContainerClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelTrackerCategoryAllContainer {
	RygelTrackerSearchContainer parent_instance;
	RygelTrackerCategoryAllContainerPrivate * priv;
};

struct _RygelTrackerCategoryAllContainerClass {
	RygelTrackerSearchContainerClass parent_class;
};

struct _RygelTrackerCategoryAllContainerPrivate {
	GeeArrayList* _create_classes;
	GeeArrayList* _search_classes;
	TrackerSparqlConnection* resources;
};

struct _RygelTrackerCategoryContainer {
	RygelSimpleContainer parent_instance;
	RygelTrackerCategoryContainerPrivate * priv;
	RygelTrackerItemFactory* item_factory;
};

struct _RygelTrackerCategoryContainerClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* category_iri;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaFileItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaFileItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
	void (*add_resources) (RygelTrackerItemFactory* self, RygelMediaFileItem* item, GError** error);
};

struct _RygelTrackerCategoryAllContainerAddItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelTrackerCategoryAllContainer* self;
	RygelMediaFileItem* item;
	GCancellable* cancellable;
	gchar* urn;
	RygelMediaFileItem* _tmp0_;
	gchar* _tmp1_;
	RygelMediaFileItem* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	RygelMediaFileItem* _tmp5_;
	GError * _inner_error_;
};

struct _RygelTrackerCategoryAllContainerAddContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelTrackerCategoryAllContainer* self;
	RygelMediaContainer* container;
	GCancellable* cancellable;
	GError* _tmp0_;
	GError * _inner_error_;
};

struct _RygelTrackerCategoryAllContainerRemoveItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelTrackerCategoryAllContainer* self;
	gchar* id;
	GCancellable* cancellable;
	gchar* parent_id;
	gchar* urn;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_;
};

struct _RygelTrackerCategoryAllContainerRemoveContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelTrackerCategoryAllContainer* self;
	gchar* id;
	GCancellable* cancellable;
	GError* _tmp0_;
	GError * _inner_error_;
};

struct _RygelTrackerCategoryAllContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelTrackerCategoryAllContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelSearchExpression* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	GCancellable* _tmp5_;
	guint _tmp6_;
	RygelMediaObjects* _tmp7_;
	RygelMediaObjects* _tmp8_;
	GError * _inner_error_;
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerInsertionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerInsertionQueryPrivate * priv;
	gchar* id;
};

struct _RygelTrackerInsertionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerCategoryAllContainerCreateEntryInStoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelTrackerCategoryAllContainer* self;
	RygelMediaFileItem* item;
	gchar* result;
	gchar* category;
	RygelTrackerItemFactory* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	RygelTrackerInsertionQuery* query;
	RygelMediaFileItem* _tmp3_;
	RygelTrackerInsertionQuery* _tmp4_;
	TrackerSparqlConnection* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_;
};

struct _RygelTrackerCategoryAllContainerRemoveEntryFromStoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelTrackerCategoryAllContainer* self;
	gchar* id;
	RygelTrackerDeletionQuery* query;
	const gchar* _tmp0_;
	RygelTrackerDeletionQuery* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_category_all_container_parent_class = NULL;
static RygelWritableContainerIface * rygel_tracker_category_all_container_rygel_writable_container_parent_iface = NULL;
static RygelSearchableContainerIface * rygel_tracker_category_all_container_rygel_searchable_container_parent_iface = NULL;

GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_tracker_category_all_container_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainerPrivate))
enum  {
	RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_DUMMY_PROPERTY,
	RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY,
	RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY
};
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_TRACKER_SERVICE "org.freedesktop.Tracker1"
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
GType rygel_tracker_category_container_get_type (void) G_GNUC_CONST;
RygelTrackerCategoryAllContainer* rygel_tracker_category_all_container_new (RygelTrackerCategoryContainer* parent);
RygelTrackerCategoryAllContainer* rygel_tracker_category_all_container_construct (GType object_type, RygelTrackerCategoryContainer* parent);
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
static void rygel_tracker_category_all_container_on_graph_updated (RygelTrackerCategoryAllContainer* self, GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* signal_path, GVariant* parameters);
static void _rygel_tracker_category_all_container_on_graph_updated_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self);
GType rygel_tracker_cleanup_query_get_type (void) G_GNUC_CONST;
RygelTrackerCleanupQuery* rygel_tracker_cleanup_query_new (const gchar* category);
RygelTrackerCleanupQuery* rygel_tracker_cleanup_query_construct (GType object_type, const gchar* category);
void rygel_tracker_query_execute (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_category_all_container_real_add_item_data_free (gpointer _data);
static void rygel_tracker_category_all_container_real_add_item_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void rygel_tracker_category_all_container_real_add_item (RygelWritableContainer* base, RygelMediaFileItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_category_all_container_real_add_item_co (RygelTrackerCategoryAllContainerAddItemData* _data_);
static void rygel_tracker_category_all_container_create_entry_in_store (RygelTrackerCategoryAllContainer* self, RygelMediaFileItem* item, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* rygel_tracker_category_all_container_create_entry_in_store_finish (RygelTrackerCategoryAllContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_category_all_container_add_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const gchar* urn);
static void rygel_tracker_category_all_container_real_add_container_data_free (gpointer _data);
static void rygel_tracker_category_all_container_real_add_container_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void rygel_tracker_category_all_container_real_add_container (RygelWritableContainer* base, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_category_all_container_real_add_container_co (RygelTrackerCategoryAllContainerAddContainerData* _data_);
static void rygel_tracker_category_all_container_real_remove_item_data_free (gpointer _data);
static void rygel_tracker_category_all_container_real_remove_item_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void rygel_tracker_category_all_container_real_remove_item (RygelWritableContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_category_all_container_real_remove_item_co (RygelTrackerCategoryAllContainerRemoveItemData* _data_);
gchar* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const gchar* item_id, gchar* * parent_id);
static void rygel_tracker_category_all_container_remove_entry_from_store (RygelTrackerCategoryAllContainer* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_category_all_container_remove_entry_from_store_finish (RygelTrackerCategoryAllContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_category_all_container_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_tracker_category_all_container_real_remove_container_data_free (gpointer _data);
static void rygel_tracker_category_all_container_real_remove_container_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void rygel_tracker_category_all_container_real_remove_container (RygelWritableContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_category_all_container_real_remove_container_co (RygelTrackerCategoryAllContainerRemoveContainerData* _data_);
static void rygel_tracker_category_all_container_real_search_data_free (gpointer _data);
static void rygel_tracker_category_all_container_real_search_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void rygel_tracker_category_all_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_category_all_container_real_search_co (RygelTrackerCategoryAllContainerSearchData* _data_);
static void rygel_tracker_category_all_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_);
static void rygel_tracker_category_all_container_create_entry_in_store_data_free (gpointer _data);
static void rygel_tracker_category_all_container_create_entry_in_store_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean rygel_tracker_category_all_container_create_entry_in_store_co (RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_);
GType rygel_tracker_insertion_query_get_type (void) G_GNUC_CONST;
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_new (RygelMediaFileItem* item, const gchar* category);
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_construct (GType object_type, RygelMediaFileItem* item, const gchar* category);
static void rygel_tracker_category_all_container_create_entry_in_store_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_tracker_category_all_container_remove_entry_from_store_data_free (gpointer _data);
static void rygel_tracker_category_all_container_remove_entry_from_store_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean rygel_tracker_category_all_container_remove_entry_from_store_co (RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_);
GType rygel_tracker_deletion_query_get_type (void) G_GNUC_CONST;
RygelTrackerDeletionQuery* rygel_tracker_deletion_query_new (const gchar* id);
RygelTrackerDeletionQuery* rygel_tracker_deletion_query_construct (GType object_type, const gchar* id);
static void rygel_tracker_category_all_container_remove_entry_from_store_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_tracker_category_all_container_finalize (GObject * obj);
static void _vala_rygel_tracker_category_all_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_tracker_category_all_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _rygel_tracker_category_all_container_on_graph_updated_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self) {
	rygel_tracker_category_all_container_on_graph_updated ((RygelTrackerCategoryAllContainer*) self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}


RygelTrackerCategoryAllContainer* rygel_tracker_category_all_container_construct (GType object_type, RygelTrackerCategoryContainer* parent) {
	RygelTrackerCategoryAllContainer * self = NULL;
	RygelTrackerCategoryContainer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	RygelTrackerCategoryContainer* _tmp5_;
	RygelTrackerCategoryContainer* _tmp6_;
	RygelTrackerItemFactory* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	RygelTrackerItemFactory* _tmp12_;
	const gchar* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	RygelTrackerItemFactory* _tmp21_;
	const gchar* _tmp22_;
	RygelTrackerCleanupQuery* cleanup_query = NULL;
	RygelTrackerItemFactory* _tmp36_;
	const gchar* _tmp37_;
	RygelTrackerCleanupQuery* _tmp38_;
	TrackerSparqlConnection* _tmp39_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = parent;
	_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("All", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = parent;
	_tmp6_ = parent;
	_tmp7_ = _tmp6_->item_factory;
	self = (RygelTrackerCategoryAllContainer*) rygel_tracker_search_container_construct (object_type, _tmp4_, (RygelMediaContainer*) _tmp5_, "All", _tmp7_, NULL, NULL);
	_g_free0 (_tmp4_);
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_tmp9_ = _tmp8_;
	rygel_writable_container_set_create_classes ((RygelWritableContainer*) self, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = rygel_writable_container_get_create_classes ((RygelWritableContainer*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = ((RygelTrackerSearchContainer*) self)->item_factory;
	_tmp13_ = _tmp12_->upnp_class;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp13_);
	_tmp14_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_tmp15_ = _tmp14_;
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp15_);
	_g_object_unref0 (_tmp15_);
	{
		TrackerSparqlConnection* _tmp16_ = NULL;
		TrackerSparqlConnection* _tmp17_;
		TrackerSparqlConnection* _tmp18_;
		_tmp17_ = tracker_sparql_connection_get (NULL, &_inner_error_);
		_tmp16_ = _tmp17_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp18_ = _tmp16_;
		_tmp16_ = NULL;
		_g_object_unref0 (self->priv->resources);
		self->priv->resources = _tmp18_;
		_g_object_unref0 (_tmp16_);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* io_error = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		io_error = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = io_error;
		_tmp20_ = _tmp19_->message;
		g_critical (_ ("Failed to create a Tracker connection: %s"), _tmp20_);
		_g_error_free0 (io_error);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp21_ = ((RygelTrackerSearchContainer*) self)->item_factory;
	_tmp22_ = _tmp21_->upload_dir;
	if (_tmp22_ != NULL) {
		{
			gchar* uri = NULL;
			RygelTrackerItemFactory* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			const gchar* _tmp26_;
			_tmp23_ = ((RygelTrackerSearchContainer*) self)->item_factory;
			_tmp24_ = _tmp23_->upload_dir;
			_tmp25_ = g_filename_to_uri (_tmp24_, NULL, &_inner_error_);
			uri = _tmp25_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch7_g_convert_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp26_ = uri;
			rygel_media_object_add_uri ((RygelMediaObject*) self, _tmp26_);
			_g_free0 (uri);
		}
		goto __finally7;
		__catch7_g_convert_error:
		{
			GError* _error_ = NULL;
			RygelTrackerItemFactory* _tmp27_;
			const gchar* _tmp28_;
			GError* _tmp29_;
			const gchar* _tmp30_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp27_ = ((RygelTrackerSearchContainer*) self)->item_factory;
			_tmp28_ = _tmp27_->upload_dir;
			_tmp29_ = _error_;
			_tmp30_ = _tmp29_->message;
			g_warning (_ ("Failed to construct URI for folder “%s”: %s"), _tmp28_, _tmp30_);
			_g_error_free0 (_error_);
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp31_;
		RygelTrackerItemFactory* _tmp32_;
		const gchar* _tmp33_;
		_tmp31_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp31_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
		_tmp32_ = ((RygelTrackerSearchContainer*) self)->item_factory;
		_tmp33_ = _tmp32_->category_iri;
		g_dbus_connection_signal_subscribe (connection, RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_TRACKER_SERVICE, RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_TRACKER_SERVICE ".Resources", "GraphUpdated", RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_RESOURCES_PATH, _tmp33_, G_DBUS_SIGNAL_FLAGS_NONE, _rygel_tracker_category_all_container_on_graph_updated_gd_bus_signal_callback, g_object_ref (self), g_object_unref);
		_g_object_unref0 (connection);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp34_ = _error_;
		_tmp35_ = _tmp34_->message;
		g_critical (_ ("Could not subscribe to Tracker signals: %s"), _tmp35_);
		_g_error_free0 (_error_);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp36_ = ((RygelTrackerSearchContainer*) self)->item_factory;
	_tmp37_ = _tmp36_->category;
	_tmp38_ = rygel_tracker_cleanup_query_new (_tmp37_);
	cleanup_query = _tmp38_;
	_tmp39_ = self->priv->resources;
	rygel_tracker_query_execute ((RygelTrackerQuery*) cleanup_query, _tmp39_, NULL, NULL);
	_rygel_tracker_query_unref0 (cleanup_query);
	return self;
}


RygelTrackerCategoryAllContainer* rygel_tracker_category_all_container_new (RygelTrackerCategoryContainer* parent) {
	return rygel_tracker_category_all_container_construct (RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, parent);
}


static void rygel_tracker_category_all_container_real_add_item_data_free (gpointer _data) {
	RygelTrackerCategoryAllContainerAddItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->item);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerAddItemData, _data_);
}


static void rygel_tracker_category_all_container_real_add_item_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelTrackerCategoryAllContainerAddItemData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_tracker_category_all_container_real_add_item (RygelWritableContainer* base, RygelMediaFileItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainer * self;
	RygelTrackerCategoryAllContainerAddItemData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	RygelMediaFileItem* _tmp1_;
	RygelMediaFileItem* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	self = (RygelTrackerCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerAddItemData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_tracker_category_all_container_real_add_item_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_real_add_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = item;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->item);
	_data_->item = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_tracker_category_all_container_real_add_item_co (_data_);
}


static void rygel_tracker_category_all_container_real_add_item_finish (RygelWritableContainer* base, GAsyncResult* _res_, GError** error) {
	RygelTrackerCategoryAllContainerAddItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static void rygel_tracker_category_all_container_add_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerAddItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_tracker_category_all_container_real_add_item_co (_data_);
}


static gboolean rygel_tracker_category_all_container_real_add_item_co (RygelTrackerCategoryAllContainerAddItemData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->item;
	_data_->_state_ = 1;
	rygel_tracker_category_all_container_create_entry_in_store (_data_->self, _data_->_tmp0_, rygel_tracker_category_all_container_add_item_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = rygel_tracker_category_all_container_create_entry_in_store_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->urn = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->item;
	_data_->_tmp3_ = rygel_tracker_search_container_create_child_id_for_urn ((RygelTrackerSearchContainer*) _data_->self, _data_->urn);
	_data_->_tmp4_ = _data_->_tmp3_;
	rygel_media_object_set_id ((RygelMediaObject*) _data_->_tmp2_, _data_->_tmp4_);
	_g_free0 (_data_->_tmp4_);
	_data_->_tmp5_ = _data_->item;
	rygel_media_object_set_parent ((RygelMediaObject*) _data_->_tmp5_, (RygelMediaContainer*) _data_->self);
	_g_free0 (_data_->urn);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_tracker_category_all_container_real_add_container_data_free (gpointer _data) {
	RygelTrackerCategoryAllContainerAddContainerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerAddContainerData, _data_);
}


static void rygel_tracker_category_all_container_real_add_container_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelTrackerCategoryAllContainerAddContainerData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_tracker_category_all_container_real_add_container (RygelWritableContainer* base, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainer * self;
	RygelTrackerCategoryAllContainerAddContainerData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	self = (RygelTrackerCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerAddContainerData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_tracker_category_all_container_real_add_container_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_real_add_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_tracker_category_all_container_real_add_container_co (_data_);
}


static void rygel_tracker_category_all_container_real_add_container_finish (RygelWritableContainer* base, GAsyncResult* _res_, GError** error) {
	RygelTrackerCategoryAllContainerAddContainerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static gboolean rygel_tracker_category_all_container_real_add_container_co (RygelTrackerCategoryAllContainerAddContainerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (RYGEL_WRITABLE_CONTAINER_ERROR, RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED, _ ("Not supported"));
	_data_->_inner_error_ = _data_->_tmp0_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error_);
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_tracker_category_all_container_real_remove_item_data_free (gpointer _data) {
	RygelTrackerCategoryAllContainerRemoveItemData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerRemoveItemData, _data_);
}


static void rygel_tracker_category_all_container_real_remove_item_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelTrackerCategoryAllContainerRemoveItemData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_tracker_category_all_container_real_remove_item (RygelWritableContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainer * self;
	RygelTrackerCategoryAllContainerRemoveItemData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	self = (RygelTrackerCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerRemoveItemData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_tracker_category_all_container_real_remove_item_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_real_remove_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_tracker_category_all_container_real_remove_item_co (_data_);
}


static void rygel_tracker_category_all_container_real_remove_item_finish (RygelWritableContainer* base, GAsyncResult* _res_, GError** error) {
	RygelTrackerCategoryAllContainerRemoveItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static void rygel_tracker_category_all_container_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerRemoveItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_tracker_category_all_container_real_remove_item_co (_data_);
}


static gboolean rygel_tracker_category_all_container_real_remove_item_co (RygelTrackerCategoryAllContainerRemoveItemData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = NULL;
	_data_->_tmp2_ = rygel_tracker_search_container_get_item_info ((RygelTrackerSearchContainer*) _data_->self, _data_->_tmp0_, &_data_->_tmp1_);
	_g_free0 (_data_->parent_id);
	_data_->parent_id = _data_->_tmp1_;
	_data_->urn = _data_->_tmp2_;
	_data_->_state_ = 1;
	rygel_tracker_category_all_container_remove_entry_from_store (_data_->self, _data_->urn, rygel_tracker_category_all_container_remove_item_ready, _data_);
	return FALSE;
	_state_1:
	rygel_tracker_category_all_container_remove_entry_from_store_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_free0 (_data_->urn);
		_g_free0 (_data_->parent_id);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->urn);
	_g_free0 (_data_->parent_id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_tracker_category_all_container_real_remove_container_data_free (gpointer _data) {
	RygelTrackerCategoryAllContainerRemoveContainerData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerRemoveContainerData, _data_);
}


static void rygel_tracker_category_all_container_real_remove_container_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelTrackerCategoryAllContainerRemoveContainerData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_tracker_category_all_container_real_remove_container (RygelWritableContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainer * self;
	RygelTrackerCategoryAllContainerRemoveContainerData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	self = (RygelTrackerCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerRemoveContainerData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_tracker_category_all_container_real_remove_container_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_real_remove_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_tracker_category_all_container_real_remove_container_co (_data_);
}


static void rygel_tracker_category_all_container_real_remove_container_finish (RygelWritableContainer* base, GAsyncResult* _res_, GError** error) {
	RygelTrackerCategoryAllContainerRemoveContainerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static gboolean rygel_tracker_category_all_container_real_remove_container_co (RygelTrackerCategoryAllContainerRemoveContainerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (RYGEL_WRITABLE_CONTAINER_ERROR, RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED, "Not supported");
	_data_->_inner_error_ = _data_->_tmp0_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error_);
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_tracker_category_all_container_real_search_data_free (gpointer _data) {
	RygelTrackerCategoryAllContainerSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerSearchData, _data_);
}


static void rygel_tracker_category_all_container_real_search_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelTrackerCategoryAllContainerSearchData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_tracker_category_all_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainer * self;
	RygelTrackerCategoryAllContainerSearchData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
	self = (RygelTrackerCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerSearchData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_tracker_category_all_container_real_search_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp2_;
	_tmp3_ = offset;
	_data_->offset = _tmp3_;
	_tmp4_ = max_count;
	_data_->max_count = _tmp4_;
	_tmp5_ = sort_criteria;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp6_;
	_tmp7_ = cancellable;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp8_;
	rygel_tracker_category_all_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_tracker_category_all_container_real_search_finish (RygelSearchableContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelTrackerCategoryAllContainerSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_category_all_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_tracker_category_all_container_real_search_co (_data_);
}


static gboolean rygel_tracker_category_all_container_real_search_co (RygelTrackerCategoryAllContainerSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->expression;
	_data_->_tmp2_ = _data_->offset;
	_data_->_tmp3_ = _data_->max_count;
	_data_->_tmp4_ = _data_->sort_criteria;
	_data_->_tmp5_ = _data_->cancellable;
	_data_->_tmp6_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, _data_->_tmp5_, rygel_tracker_category_all_container_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
	_data_->total_matches = _data_->_tmp6_;
	_data_->_tmp0_ = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp8_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_tracker_category_all_container_on_graph_updated (RygelTrackerCategoryAllContainer* self, GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* signal_path, GVariant* parameters) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_path != NULL);
	g_return_if_fail (parameters != NULL);
	rygel_tracker_search_container_get_children_count ((RygelTrackerSearchContainer*) self, NULL, NULL);
}


static void rygel_tracker_category_all_container_create_entry_in_store_data_free (gpointer _data) {
	RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->item);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerCreateEntryInStoreData, _data_);
}


static void rygel_tracker_category_all_container_create_entry_in_store_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelTrackerCategoryAllContainerCreateEntryInStoreData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_tracker_category_all_container_create_entry_in_store (RygelTrackerCategoryAllContainer* self, RygelMediaFileItem* item, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	RygelMediaFileItem* _tmp1_;
	RygelMediaFileItem* _tmp2_;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerCreateEntryInStoreData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_tracker_category_all_container_create_entry_in_store_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_create_entry_in_store_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = item;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->item);
	_data_->item = _tmp2_;
	rygel_tracker_category_all_container_create_entry_in_store_co (_data_);
}


static gchar* rygel_tracker_category_all_container_create_entry_in_store_finish (RygelTrackerCategoryAllContainer* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_category_all_container_create_entry_in_store_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_tracker_category_all_container_create_entry_in_store_co (_data_);
}


static gboolean rygel_tracker_category_all_container_create_entry_in_store_co (RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((RygelTrackerSearchContainer*) _data_->self)->item_factory;
	_data_->_tmp1_ = _data_->_tmp0_->category;
	_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
	_data_->category = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->item;
	_data_->_tmp4_ = rygel_tracker_insertion_query_new (_data_->_tmp3_, _data_->category);
	_data_->query = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->resources;
	_data_->_state_ = 1;
	rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->query, _data_->_tmp5_, rygel_tracker_category_all_container_create_entry_in_store_ready, _data_);
	return FALSE;
	_state_1:
	rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->query, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_rygel_tracker_query_unref0 (_data_->query);
		_g_free0 (_data_->category);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->query->id;
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_data_->result = _data_->_tmp7_;
	_rygel_tracker_query_unref0 (_data_->query);
	_g_free0 (_data_->category);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_tracker_category_all_container_remove_entry_from_store_data_free (gpointer _data) {
	RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerRemoveEntryFromStoreData, _data_);
}


static void rygel_tracker_category_all_container_remove_entry_from_store_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_tracker_category_all_container_remove_entry_from_store (RygelTrackerCategoryAllContainer* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerRemoveEntryFromStoreData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_tracker_category_all_container_remove_entry_from_store_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_remove_entry_from_store_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	rygel_tracker_category_all_container_remove_entry_from_store_co (_data_);
}


static void rygel_tracker_category_all_container_remove_entry_from_store_finish (RygelTrackerCategoryAllContainer* self, GAsyncResult* _res_, GError** error) {
	RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static void rygel_tracker_category_all_container_remove_entry_from_store_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_tracker_category_all_container_remove_entry_from_store_co (_data_);
}


static gboolean rygel_tracker_category_all_container_remove_entry_from_store_co (RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = rygel_tracker_deletion_query_new (_data_->_tmp0_);
	_data_->query = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->resources;
	_data_->_state_ = 1;
	rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->query, _data_->_tmp2_, rygel_tracker_category_all_container_remove_entry_from_store_ready, _data_);
	return FALSE;
	_state_1:
	rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->query, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_rygel_tracker_query_unref0 (_data_->query);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_rygel_tracker_query_unref0 (_data_->query);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static GeeArrayList* rygel_tracker_category_all_container_real_get_create_classes (RygelWritableContainer* base) {
	GeeArrayList* result;
	RygelTrackerCategoryAllContainer* self;
	GeeArrayList* _tmp0_;
	self = (RygelTrackerCategoryAllContainer*) base;
	_tmp0_ = self->priv->_create_classes;
	result = _tmp0_;
	return result;
}


static void rygel_tracker_category_all_container_real_set_create_classes (RygelWritableContainer* base, GeeArrayList* value) {
	RygelTrackerCategoryAllContainer* self;
	self = (RygelTrackerCategoryAllContainer*) base;
	if (rygel_tracker_category_all_container_real_get_create_classes (base) != value) {
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_create_classes);
		self->priv->_create_classes = _tmp1_;
		g_object_notify ((GObject *) self, "create-classes");
	}
}


static GeeArrayList* rygel_tracker_category_all_container_real_get_search_classes (RygelSearchableContainer* base) {
	GeeArrayList* result;
	RygelTrackerCategoryAllContainer* self;
	GeeArrayList* _tmp0_;
	self = (RygelTrackerCategoryAllContainer*) base;
	_tmp0_ = self->priv->_search_classes;
	result = _tmp0_;
	return result;
}


static void rygel_tracker_category_all_container_real_set_search_classes (RygelSearchableContainer* base, GeeArrayList* value) {
	RygelTrackerCategoryAllContainer* self;
	self = (RygelTrackerCategoryAllContainer*) base;
	if (rygel_tracker_category_all_container_real_get_search_classes (base) != value) {
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_search_classes);
		self->priv->_search_classes = _tmp1_;
		g_object_notify ((GObject *) self, "search-classes");
	}
}


static void rygel_tracker_category_all_container_class_init (RygelTrackerCategoryAllContainerClass * klass) {
	rygel_tracker_category_all_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerCategoryAllContainerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_tracker_category_all_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_tracker_category_all_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_category_all_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY, g_param_spec_object ("create-classes", "create-classes", "create-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_tracker_category_all_container_rygel_writable_container_interface_init (RygelWritableContainerIface * iface) {
	rygel_tracker_category_all_container_rygel_writable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_item = (void (*) (RygelWritableContainer *, RygelMediaFileItem*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_tracker_category_all_container_real_add_item;
	iface->add_item_finish = (void (*) (RygelWritableContainer *, GAsyncResult*, GError**)) rygel_tracker_category_all_container_real_add_item_finish;
	iface->add_container = (void (*) (RygelWritableContainer *, RygelMediaContainer*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_tracker_category_all_container_real_add_container;
	iface->add_container_finish = (void (*) (RygelWritableContainer *, GAsyncResult*, GError**)) rygel_tracker_category_all_container_real_add_container_finish;
	iface->remove_item = (void (*) (RygelWritableContainer *, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_tracker_category_all_container_real_remove_item;
	iface->remove_item_finish = (void (*) (RygelWritableContainer *, GAsyncResult*, GError**)) rygel_tracker_category_all_container_real_remove_item_finish;
	iface->remove_container = (void (*) (RygelWritableContainer *, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_tracker_category_all_container_real_remove_container;
	iface->remove_container_finish = (void (*) (RygelWritableContainer *, GAsyncResult*, GError**)) rygel_tracker_category_all_container_real_remove_container_finish;
	iface->get_create_classes = rygel_tracker_category_all_container_real_get_create_classes;
	iface->set_create_classes = rygel_tracker_category_all_container_real_set_create_classes;
}


static void rygel_tracker_category_all_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface) {
	rygel_tracker_category_all_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (RygelSearchableContainer *, RygelSearchExpression*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_tracker_category_all_container_real_search;
	iface->search_finish = (RygelMediaObjects* (*) (RygelSearchableContainer *, GAsyncResult*, guint*, GError**)) rygel_tracker_category_all_container_real_search_finish;
	iface->get_search_classes = rygel_tracker_category_all_container_real_get_search_classes;
	iface->set_search_classes = rygel_tracker_category_all_container_real_set_search_classes;
}


static void rygel_tracker_category_all_container_instance_init (RygelTrackerCategoryAllContainer * self) {
	self->priv = RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_GET_PRIVATE (self);
}


static void rygel_tracker_category_all_container_finalize (GObject * obj) {
	RygelTrackerCategoryAllContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainer);
	_g_object_unref0 (self->priv->_create_classes);
	_g_object_unref0 (self->priv->_search_classes);
	_g_object_unref0 (self->priv->resources);
	G_OBJECT_CLASS (rygel_tracker_category_all_container_parent_class)->finalize (obj);
}


/**
 * A search container that contains all the items in a category.
 */
GType rygel_tracker_category_all_container_get_type (void) {
	static volatile gsize rygel_tracker_category_all_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_category_all_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerCategoryAllContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_category_all_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerCategoryAllContainer), 0, (GInstanceInitFunc) rygel_tracker_category_all_container_instance_init, NULL };
		static const GInterfaceInfo rygel_writable_container_info = { (GInterfaceInitFunc) rygel_tracker_category_all_container_rygel_writable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_tracker_category_all_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_tracker_category_all_container_type_id;
		rygel_tracker_category_all_container_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, "RygelTrackerCategoryAllContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_tracker_category_all_container_type_id, RYGEL_TYPE_WRITABLE_CONTAINER, &rygel_writable_container_info);
		g_type_add_interface_static (rygel_tracker_category_all_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		g_once_init_leave (&rygel_tracker_category_all_container_type_id__volatile, rygel_tracker_category_all_container_type_id);
	}
	return rygel_tracker_category_all_container_type_id__volatile;
}


static void _vala_rygel_tracker_category_all_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelTrackerCategoryAllContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainer);
	switch (property_id) {
		case RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY:
		g_value_set_object (value, rygel_writable_container_get_create_classes ((RygelWritableContainer*) self));
		break;
		case RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY:
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_tracker_category_all_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelTrackerCategoryAllContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainer);
	switch (property_id) {
		case RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY:
		rygel_writable_container_set_create_classes ((RygelWritableContainer*) self, g_value_get_object (value));
		break;
		case RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY:
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



