#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc PlotPSPrint {varname} {
    upvar #0 $varname var
    global $varname

    if {[PlotPrintDialog]} {
	if [catch {PlotPostScript $varname} printError] {
	    Error "[msgcat::mc {An error has occurred while printing}] $printError"
	}
    }
}

proc PlotPostScript {varname} {
    upvar #0 $varname var
    global $varname

    global ps
    global ds9

    global debug
    if {$debug(tcl,idletasks)} {
	puts stderr "PlotPostScript"
    }
    update idletasks

    # set postscript fonts
    $var(graph) configure \
	-font "$var(titleFont) $var(titleSize) $var(titleWeight) $var(titleSlant)"
    $var(graph) xaxis configure \
	-tickfont "$var(numlabFont) $var(numlabSize) $var(numlabWeight) $var(numlabSlant)" \
	-titlefont "$var(textlabFont) $var(textlabSize) $var(textlabWeight) $var(textlabSlant)"
    $var(graph) yaxis configure \
	-tickfont "$var(numlabFont) $var(numlabSize) $var(numlabWeight) $var(numlabSlant)" \
	-titlefont "$var(textlabFont) $var(textlabSize) $var(textlabWeight) $var(textlabSlant)"

    set options "-decorations false"

    # Color
    switch -- $ps(color) {
	rgb -
	cmyk {append options " -greyscale no"}
	gray {append options " -greyscale yes"}
    }

    # Size
    set ww [expr [winfo width $var(top)]*$ps(scale)/100./[tk scaling]]
    set hh [expr [winfo height $var(top)]*$ps(scale)/100./[tk scaling]]
    append options " -width $ww -height $hh"

    # Page size
    switch -- $ps(size) {
 	letter {append options " -paperwidth 8.5i -paperheight 11.i"}
 	legal {append options " -paperwidth 8.5i -paperheight 14.i"}
 	tabloid {append options " -paperwidth 11i -paperheight 17.i"}
 	poster {append options " -paperwidth 36.i -paperheight 48.i"}
 	a4 {append options " -paperwidth 195m -paperheight 282m"}
 	other {
 	    if {$ps(width) != {} && $ps(height) != {}} {
 		set w [expr $ps(width)]
 		set h [expr $ps(height)]
 		append options \
 		    " -paperwidth [append $w i] -paperheight [append $h i]"
 	    }
 	}
 	othermm {
 	    if {$ps(width) != {} && $ps(height) != {}} {
 		set w [expr $ps(width)]
 		set h [expr $ps(height)]
 		append options \
 		    " -paperwidth [append $w m] -paperheight [append $h m]"
 	    }
 	}
    }

    # Orientation
    switch -- $ps(orient) {
	portrait {append options " -landscape false"}
	landscape {append options " -landscape true"}
    }

    if {$ps(dest) == "file" && $ps(filename) != {}} {
	eval $var(graph) postscript output $ps(filename) $options
    } else {
	set ch [open "| $ps(cmd)" w]
	puts $ch [eval $var(graph) postscript output $options]
	close $ch
    }

    # reset fonts
    $var(graph) configure \
	-font "{$ds9($var(titleFont))} $var(titleSize) $var(titleWeight) $var(titleSlant)"
    $var(graph) xaxis configure \
	-tickfont "{$ds9($var(numlabFont))} $var(numlabSize) $var(numlabWeight) $var(numlabSlant)" \
	-titlefont "{$ds9($var(textlabFont))} $var(textlabSize) $var(textlabWeight) $var(textlabSlant)"
    $var(graph) yaxis configure \
	-tickfont "{$ds9($var(numlabFont))} $var(numlabSize) $var(numlabWeight) $var(numlabSlant)" \
	-titlefont "{$ds9($var(textlabFont))} $var(textlabSize) $var(textlabWeight) $var(textlabSlant)"

}
