#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    se
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/sisu>
#    <https://git.sisudoc.org/projects/sisu-markup>
module SiSU_Info_Remote_Host
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  class InfoRemoteHost
    def initialize
      @rc=SiSU_Env::GetInit.new.sisu_yaml.rc
    end
    def remote_host #see InfoRemote remote_host_base_general
      r=[]
      r=if (defined? @rc['remote'] \
      and @rc['remote'].is_a?(Array))
        r_array=@rc['remote']
        r_array.each_with_index do |renv,i|
          r[i]={}
          if defined? renv['user'] \
          and defined? renv['host']
          end
          r[i][:user]=renv['user']
          r[i][:host]=renv['host']
          r[i][:path]=if defined? renv['path']
            renv['path']
          else ''
          end
          r[i][:name]="#{r[i][:user]}@#{r[i][:host]}:#{r[i][:path]}"
        end
        r
      elsif (defined? @rc['remote'] \
      and @rc['remote'].is_a?(Hash) \
      and defined? @rc['remote']['user'] \
      and defined? @rc['remote']['host'])
        r[0]={}
        r[0][:user]=@rc['remote']['user']
        r[0][:host]=@rc['remote']['host']
        r[0][:path]=if defined? @rc['remote']['path']
          @rc['remote']['path']
        else ''
        end
        r[0][:name]="#{r[0][:user]}@#{r[0][:host]}:#{r[0][:path]}"
        r
      else
        r[0]={}
        r[0][:name]='.'
        r[0][:user]=''
        r[0][:host]=''
        r[0][:path]=''
        #puts "no remote host or user"
        r
      end
    end
    def rhost
      def r1
        (defined? SiSU_Env::InfoRemoteHost.new.remote_host[0][:name]) \
        ? (SiSU_Env::InfoRemoteHost.new.remote_host[0][:name])
        : nil
      end
      def r2
        (defined? SiSU_Env::InfoRemoteHost.new.remote_host[1][:name]) \
        ? (SiSU_Env::InfoRemoteHost.new.remote_host[1][:name])
        : nil
      end
      def r3
        (defined? SiSU_Env::InfoRemoteHost.new.remote_host[2][:name]) \
        ? (SiSU_Env::InfoRemoteHost.new.remote_host[2][:name])
        : nil
      end
      def r4
        (defined? SiSU_Env::InfoRemoteHost.new.remote_host[3][:name]) \
        ? (SiSU_Env::InfoRemoteHost.new.remote_host[3][:name])
        : nil
      end
      def r5
        (defined? SiSU_Env::InfoRemoteHost.new.remote_host[4][:name]) \
        ? (SiSU_Env::InfoRemoteHost.new.remote_host[4][:name])
        : nil
      end
      def r6
        (defined? SiSU_Env::InfoRemoteHost.new.remote_host[5][:name]) \
        ? (@ls + SiSU_Env::InfoRemoteHost.new.remote_host[5][:name])
         : nil
      end
      self
    end
  end
end
module SiSU_Info_Remote
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  require_relative 'se_filemap'                            # se_filemap.rb
  begin
    require 'fileutils'
      include FileUtils::Verbose
  rescue LoadError
    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
      error('fileutils NOT FOUND (LoadError)')
  end
  class InfoRemote < SiSU_File_Map::FileMap                # se_filemap.rb
    @@flag_remote=false
    begin
      require 'socket'
    rescue LoadError
      SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
        error('socket NOT FOUND (LoadError)')
    end
    def initialize(opt)
      super(opt) #
      @opt=opt
      @rc=GetInit.new.sisu_yaml.rc
    end
    def remote_host_base_general
      SiSU_Env::InfoRemoteHost.new.remote_host
    end
    def remote_host_base
      remote_host_base_general.each do |remote_conn|
        @@flag_remote=true if remote_conn[:name] =~/\S+?@\S+/
      end
      remote_host_base_general
    end
    def scp                            #sort out later using ruby libraries #not ideal, first time each file is sent, -r must be called separately for subdir to be built
      def document
        self.remote_host_base.each do |remote_conn|
          local_gen=@source_path
          remote_gen=case @opt.cmd
          when /u/
            remote_conn[:name] + '/' \
              + @env.path.base_markup_dir_stub + '/.'             #creates remote directory tree, this is not the usual function of u
          when /[abhHNopwxXy]/
            remote_conn[:name] + '/' \
              + @env.path.base_markup_dir_stub + '/' \
              + @fnb + '/.'
          else
            remote_conn[:name] + '/' \
              + @env.path.base_markup_dir_stub \
              + '/.'
          end
          local_epub=@source_path_epub
          local_src=@source_path_src
          local_pod=@source_path_pod
          remote_epub=
            remote_conn[:name] + '/' + @env.path.stub_epub + '/.'
          remote_src=
            remote_conn[:name] + '/' + @env.path.stub_src + '/.'
          remote_pod=
            remote_conn[:name] + '/' + @env.path.stub_pod + '/.'
          src_txt=@opt.fnc
          src_pod=@opt.fncb.gsub(/(\.ss[mt])(?:\.sst)?$/,'\1.txz')
          if (local_gen =~/\S/ \
          and local_gen !~/\/\//) \
          and (remote_gen =~/\S/ \
          and remote_gen !~/\/\//) \
          and @@flag_remote==true \
          and @opt.cmd !~/U/
            SiSU_Env::SystemCall.new(local_gen,remote_gen).scp
            if FileTest.file?("#{local_src}/#{src_txt}")
              SiSU_Env::SystemCall.new("#{local_src}/#{src_txt}",remote_src).scp
            end
            if FileTest.file?("#{local_pod}/#{src_pod}")
              SiSU_Env::SystemCall.new("#{local_src}/#{src_pod}",remote_pod).scp
            end
            if FileTest.file?("#{local_epub}/#{@opt.fnb}.epub")
              SiSU_Env::SystemCall.new(
                "#{local_epub}/#{@opt.fnb}.epub",
                remote_epub,@opt.cmd
              ).scp
            end
          elsif  @opt.cmd =~/U/
            puts "#{__FILE__} #{__LINE__}" if @opt.cmd =~/M/
            puts "#{local_gen} -> #{remote_gen}"
            if FileTest.file?("#{local_src}/#{src_doc}")
              puts "#{local_src}/#{src_doc}* -> #{remote_src}"
            end
            if FileTest.file?("#{local_pod}/#{src_doc}.txz")
              puts "#{local_pod}/#{src_doc}* -> #{remote_pod}"
            end
          else
            puts 'suspect scp request, ignored'
            puts "#{local_gen} -> #{remote_gen} remote flag: #{@@flag_remote}"
            puts "permission not granted #{__FILE__} #{__LINE__}" if @opt.cmd =~/M/
          end
        end
      end
      def site_base                    #base site
        self.remote_host_base.each do |remote_conn|
          local=@source_path
          remote="#{remote_conn[:name]}/#{@env.path.base_markup_dir_stub}/."
          if defined? @rc['permission_set']['remote_base_site'] \
          and @rc['permission_set']['remote_base_site'] \
          and @@flag_remote==true \
          and @opt.cmd !~/U/
            puts "begin scp_base: #{local} -> #{remote}"
            SiSU_Env::SystemCall.new("#{local}/#{@env.path.style}/",remote).scp
          elsif @opt.cmd =~/U/
            puts "#{__FILE__} #{__LINE__}" if @opt.cmd =~/M/
            puts "begin scp_base: #{local} -> #{remote}"
            puts "#{local}/#{@env.path.style}/ -> #{remote}"
          else  puts "permission not granted #{__FILE__} #{__LINE__}" if @opt.cmd =~/M/
          end
        end
      end
      def site_base_all                #base site
        self.remote_host_base.each do |remote_conn|
          local=@source_path
          remote=
            remote_conn[:name] + '/' \
              + @env.path.base_markup_dir_stub + '/.'
          if defined? @rc['permission_set']['remote_base_site'] \
          and @rc['permission_set']['remote_base_site'] \
          and @@flag_remote==true \
          and @opt.cmd !~/U/
            puts "begin scp_base_all: #{local} -> #{remote}"
            SiSU_Env::SystemCall.new("#{local}/_sisu/image_sys/",remote).scp
            SiSU_Env::SystemCall.new("#{local}/_sisu/image/",remote).scp
            SiSU_Env::SystemCall.new("#{local}/#{@env.path.style}/",remote).scp
          elsif @opt.cmd =~/U/
            puts "#{__FILE__} #{__LINE__}" if @opt.cmd =~/M/
            puts "scp_base_all: #{local} -> #{remote}"
            puts "#{local}/_sisu/image_sys/ -> #{remote}"
            puts "#{local}/_sisu/image/ -> #{remote}"
            puts "#{local}/#{@env.path.style}/ -> #{remote}"
          else
            puts "permission not granted #{__FILE__} #{__LINE__}" \
              if @opt.cmd =~/M/
          end
        end
      end
      self
    end
    def rsync
      def document
        f=(@opt.act[:ao][:set]==:on) \
        ? SiSU_Env::FileOp.new(@md)
        : nil
        if f
          self.remote_host_base.each do |remote_conn|
            local_gen=@source_path
            #local_gen_image="#{@env.path.webserv}/#{@env.path.base_markup_dir_stub}/_sisu/image"
            #local_gen_image_external="#{@env.path.webserv}/#{@env.path.base_markup_dir_stub}/_sisu/image_external"
            remote_gen=
              remote_conn[:name] + '/' \
                + @env.path.base_markup_dir_stub + '/.'
            remote_rel=
              remote_conn[:name] + '/' \
                + f.output_path.stub.rcp
            @opt.fnc
            if (local_gen =~/\S/ \
            and local_gen !~/\/\//) \
            and (remote_gen =~/\S/ \
            and remote_gen !~/\/\//) \
            and @@flag_remote==true \
            and @opt.cmd !~/U/
#             SiSU_Env::SystemCall.new("#{local_src}/#{src_txt}",remote_src,@opt.cmd).rsync
              #delete_extra_files='--delete' # '--delete-after'
              inp=[]
              if (@opt.act[:html][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.html_scroll.dir)
                inp \
                  << f.output_path.html_seg.rel \
                  << f.place_file.html_scroll.rel
              end
              if (@opt.act[:concordance][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.html_concordance.dir)
                inp << f.place_file.html_concordance.rel
              end
              if (@opt.act[:epub][:set]==:on \
              || @opt.cmd =~/^-R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.epub.dir)
                inp << f.place_file.epub.rel
              end
              if (@opt.act[:odt][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.odt.dir)
                inp << f.place_file.odt.rel
              end
              if (@opt.act[:xhtml][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.xhtml.dir)
                inp << f.place_file.xhtml.rel
              end
              if (@opt.act[:xml_sax][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.xml_sax.dir)
                inp << f.place_file.xml_sax.rel
              end
              if (@opt.act[:xml_dom][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.xml_dom.dir)
                inp << f.place_file.xml_dom.rel
              end
              if (@opt.act[:xml_scaffold_structure_sisu][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.xml_scaffold_structure_sisu.dir)
                inp << f.place_file.xml_scaffold_structure_sisu.rel
              end
              if (@opt.act[:xml_scaffold_structure_collapse][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.xml_scaffold_structure_collapse.dir)
                inp << f.place_file.xml_scaffold_structure_collapse.rel
              end
              if (@opt.act[:txt][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.txt.dir)
                inp << f.place_file.txt.rel
              end
              if (@opt.act[:manpage][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*i[mqvVM]*$/) \
              && FileTest.file?(f.place_file.manpage.dir)
                inp << f.place_file.manpage.rel
              end
              if (@opt.act[:texinfo][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*I[mqvVM]*$/) \
              && FileTest.file?(f.place_file.info.dir)
                inp << f.place_file.info.rel
              end
              if (@opt.act[:hash_digests][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.hash_digest.dir)
                inp << f.place_file.hash_digest.rel
              end
              if (@opt.act[:share_source][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.src.dir)
                inp << f.place_file.src.rel
              end
              if (@opt.act[:sisupod][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.sisupod.dir)
                inp << f.place_file.sisupod.rel
              end
              if (@opt.act[:pdf][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/)
                inp <<=(@opt.dir_structure_by == :filename) \
                ? (f.output_path.pdf.rel + '/*.pdf')
                : (f.output_path.pdf.rel + '/' + @opt.fnb + '*.pdf')
              end
              if (@opt.act[:sqlite_discrete][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.sqlite_discrete.dir)
                inp << f.place_file.sqlite_discrete.rel
              end
              if (@opt.act[:qrcode][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.qrcode_md.dir)
                inp \
                  << f.place_file.qrcode_md.rel \
                  << f.place_file.qrcode_title.rel
              end
              if (@opt.act[:manifest][:set]==:on \
              || @opt.cmd =~/^-[mqvVM]*R[mqvVM]*$/) \
              && FileTest.file?(f.place_file.manifest.dir)
                inp << f.place_file.manifest.rel
              end
              local_gen=if inp.length > 0
                inp.join(' ')
              else ''
              end
              local_css,images,images_system='','',''
              images=images_skin=images_system=local_css=''
              if @opt.cmd =~/[hwbxX]/ \
              && (defined? @md.ec[:image]) \
              && (@md.ec[:image].length > 0)
                images=
                  f.place_file.images.rel + '/' \
                    + @md.ec[:image].join(" #{f.output_path.images.rel}/")
              end
              if @opt.cmd =~/[yhwbxX]/ \
              && (defined? @md.ec[:image]) \
              && (@md.ec[:image].length > 0)
                local_css=f.output_path.css.rel
                images_system='_sisu/image_sys'
              end
              begin
                ##create file structure without copying files?:
                ##rsync -av -f"+ */" -f"- *" f.output_path.base.dir remote:./path/.
                #local_dirs=%{-f"+ */" -f"- *" #{f.output_path.base.dir}/*}
                #SiSU_Env::SystemCall.new(local_dirs,remote_gen,@opt.cmd).rsync
                local=local_gen + ' ' + images + ' ' + images_skin + ' ' + images_system + ' ' + local_css
                SiSU_Env::SystemCall.new(local,remote_rel,@opt.cmd).
                  rsync('--relative',f.output_path.base.dir)
              rescue
                p __LINE__.to_s + ':' + __FILE__
                local_dirs=%{--include='*/' --exclude='*' #{f.output_path.base.dir}}
                SiSU_Env::SystemCall.new(local_dirs,remote_gen,@opt.cmd).rsync
              end
            elsif @opt.cmd =~/U/
              puts "#{__FILE__} #{__LINE__}" if @opt.cmd =~/M/
              puts "#{local_gen} -> #{remote_gen}"
              if FileTest.file?("#{local_src}/#{src_doc}") \
              or FileTest.file?("#{local_src}/#{src_doc}.txz")
                puts "#{local_src}/#{src_doc}* -> #{remote_src}"
              end
            else
              puts 'suspect rsync request, ignored'
              puts "#{local_gen} -> #{remote_gen} remote flag: #{@@flag_remote}"
              puts "permission not granted #{__FILE__} #{__LINE__}" \
                if @opt.cmd =~/M/
            end
          end
        end
      end
      def site_harvest
        self.remote_host_base.each do |remote_conn|
          local=@source_path_harvest
          l_rel="#{@env.path.webserv}/#{@env.path.base_markup_dir_stub}"
          lng='en'
          if @env.output_dir_structure.by? == :language
            ldest=lng + '/manifest'
            files=
              ldest + '/authors.html' + ' ' \
                + ldest + '/topics.html'
          elsif @env.output_dir_structure.by? == :filetype
            ldest="manifest"
            files=
              ldest + '/authors.' + lng + '.html' + ' ' \
                + ldest + '/topics.' + lng + '.html'
          elsif @env.output_dir_structure.by? == :filename
            files=
              l_rel + '/authors.' + lng + '.html' + ' ' \
                + l_rel + '/topics.' + lng + '.html'
          end
          remote="#{remote_conn[:name]}/#{@opt.base_stub}"
          if @opt.act[:harvest][:set] \
          && @opt.act[:rsync][:set]
            (@env.output_dir_structure.by? == :filename) \
            ? (SiSU_Env::SystemCall.new(files,remote).rsync)
            : (SiSU_Env::SystemCall.new(ldest,remote).
                rsync('--relative',l_rel))
          elsif @opt.cmd =~/U/
            puts "#{__FILE__} #{__LINE__}" if @opt.cmd =~/M/
            puts "rsync_harvest: #{local} -> #{remote}"
          else
            puts "permission not granted #{__FILE__} #{__LINE__}" \
              if @opt.cmd =~/M/
          end
        end
      end
      def site_base                    #base site
        ldest='_sisu/*'
        l_rel="#{@env.path.webserv}/#{@env.path.base_markup_dir_stub}"
        image_sys="#{@env.path.webserv}/_sisu/image_sys"
        self.remote_host_base.each do |remote_conn|
          remote="#{remote_conn[:name]}/#{@env.path.base_markup_dir_stub}"
          remote_conf="#{remote_conn[:name]}/_sisu"
            SiSU_Env::SystemCall.new(image_sys,remote_conf).rsync
            SiSU_Env::SystemCall.new(ldest,remote).rsync('--relative',l_rel)
        end
      end
      def site_base_sync
        self.remote_host_base.each do |remote_conn|
          local=@source_path
          remote="#{remote_conn[:name]}/#{@env.path.base_markup_dir_stub}/."
          if defined? @rc['permission_set']['remote_base_site'] \
          and @rc['permission_set']['remote_base_site'] \
          and @@flag_remote==true \
          and @opt.cmd !~/U/
            delete_extra_files='--delete' # '--delete-after'
            puts "begin rsync_base_sync: #{local} -> #{remote}"
            SiSU_Env::SystemCall.new("#{local}/_sisu/image_sys/",remote).
              rsync(delete_extra_files)
            SiSU_Env::SystemCall.new("#{local}/_sisu/image/",remote).
              rsync(delete_extra_files)
            SiSU_Env::SystemCall.new("#{local}/#{@env.path.style}/",remote).
              rsync(delete_extra_files)
          elsif @opt.cmd =~/U/
            puts "#{__FILE__} #{__LINE__}" if @opt.cmd =~/M/
            puts "rsync_base_sync: #{local} -> #{remote}"
            puts "#{local}/_sisu/image_sys/ -> #{remote}"
            puts "#{local}/_sisu/image/ -> #{remote}"
            puts "#{local}/#{@env.path.style}/ -> #{remote}"
          else
            puts "permission not granted #{__FILE__} #{__LINE__}" \
              if @opt.cmd =~/M/
          end
        end
      end
      self
    end
    def rsync_sitemaps                 #sitemap directory
      self.remote_host_base.each do |remote_conn|
        local=
          @source_path + '/sitemapindex.xml'
        remote="#{remote_conn[:name]}/#{@env.path.base_markup_dir_stub}/."
        if @@flag_remote
          delete_extra_files='--delete' # '--delete-after'
          SiSU_Env::SystemCall.new(local,remote).rsync(delete_extra_files)
        elsif @opt.cmd =~/U/
          puts "#{__FILE__} #{__LINE__}" if @opt.cmd =~/M/
          puts "rsync_sitemaps: #{local} -> #{remote}"
        else
          puts "permission not granted #{__FILE__} #{__LINE__}" \
            if @opt.cmd =~/M/
        end
      end
    end
  end
end
__END__
