# 
# boilerplate to be included for writing test programs
#
# Copyright (c) 2009-2011 Centro Svizzero di Calcolo Scientifico (CSCS)
# Licensed under the GPLv2.
#
# NAMES
MAIN   ?= $(wildcard *.c)
TARGETS	= $(MAIN:.c=)
TARGET  = $(firstword $(TARGETS))	
SRCS	= $(filter-out $(MAIN),$(wildcard *.c))
OBJS   += $(SRCS:.c=.o)

# PROGRAMS
CC    = gcc
RM    = rm -vf
SHELL = /bin/bash
STRIP = strip --strip-all 

# PATHS
INCDIR = ../../include
LIBDIR = ../..

HEADERS	= $(wildcard $(INCDIR)/*.h)
BASILIB= $(LIBDIR)/libalps/libalps.a
SDBLIB = $(LIBDIR)/libsdb/libsdb.a

# FLAGS
CFLAGS  = -I$(INCDIR) -g -Wall -Werror -pedantic

# add C99 here, since mysql uses 'long long'
CFLAGS += $(shell mysql_config --include) -std=c99
LDLIBS  = $(shell mysql_config --libs)

.PHONY: all clean check

all: $(TARGETS)

%.o : %.c $(HEADERS)
	$(CC) $(CFLAGS) -c $< -o $@

% : %.c	# cancel built-in rule first
% : %.c $(OBJS) $(SDBLIB) $(BASILIB)
	$(CC) $(CFLAGS) $^ $(LDLIBS) -o $@
	@$(STRIP) $@

$(MAIN): $(HEADERS)

$(BASILIB) $(SDBLIB): $(wildcard $(@D)/*.c) $(HEADERS)
	$(MAKE) -C $(@D) clean $(@F)

tags: $(wildcard *.c *.h) $(wildcard $(LIBDIR)/lib*/*.c) $(HEADERS)
	ctags $^ > $@

clean: 
	@$(RM) ? *~ *.o a.out core tags $(TARGETS)
