-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Package providing data structure to store running totals, and a procedure   --
--to print them.                                                              --
--                                                                            --
--------------------------------------------------------------------------------
with SPARK_IO;

--# inherit Banner,
--#         CommandLine,
--#         E_Strings,
--#         FatalErrors,
--#         Heap,
--#         SPARK_IO,
--#         VCDetails,
--#         VCHeap;

package Total
--# own State;
--# initializes State;
is

   procedure Update_Totals (VCG : in Boolean;
                            DPC : in Boolean);
   --# global in     VCHeap.State;
   --#        in out State;
   --# derives State from *,
   --#                    DPC,
   --#                    VCG,
   --#                    VCHeap.State;

   procedure Output
     (Report_File             : in     SPARK_IO.File_Type;
      Temp_File               : in out SPARK_IO.File_Type;
      Temp_False_File         : in out SPARK_IO.File_Type;
      Temp_Contra_File        : in out SPARK_IO.File_Type;
      Temp_Victor_File        : in out SPARK_IO.File_Type;
      Temp_Riposte_File       : in out SPARK_IO.File_Type;
      Temp_User_File          : in out SPARK_IO.File_Type;
      Temp_Rlu_Error_File     : in out SPARK_IO.File_Type;
      Temp_Rlu_Used_File      : in out SPARK_IO.File_Type;
      Temp_PR_Verr_File       : in out SPARK_IO.File_Type;
      Temp_Warn_Error_File    : in out SPARK_IO.File_Type;
      Temp_SDP_Error_File     : in out SPARK_IO.File_Type;
      Temp_DPC_Error_File     : in out SPARK_IO.File_Type;
      Temp_Victor_Error_File  : in out SPARK_IO.File_Type;
      Temp_Riposte_Error_File : in out SPARK_IO.File_Type);
   --# global in     CommandLine.Data;
   --#        in     State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys       from *,
   --#                                      CommandLine.Data,
   --#                                      Report_File,
   --#                                      State,
   --#                                      Temp_Contra_File,
   --#                                      Temp_DPC_Error_File,
   --#                                      Temp_False_File,
   --#                                      Temp_File,
   --#                                      Temp_PR_Verr_File,
   --#                                      Temp_Riposte_Error_File,
   --#                                      Temp_Riposte_File,
   --#                                      Temp_Rlu_Error_File,
   --#                                      Temp_Rlu_Used_File,
   --#                                      Temp_SDP_Error_File,
   --#                                      Temp_User_File,
   --#                                      Temp_Victor_Error_File,
   --#                                      Temp_Victor_File,
   --#                                      Temp_Warn_Error_File &
   --#         Temp_Contra_File,
   --#         Temp_DPC_Error_File,
   --#         Temp_False_File,
   --#         Temp_File,
   --#         Temp_PR_Verr_File,
   --#         Temp_Riposte_Error_File,
   --#         Temp_Riposte_File,
   --#         Temp_Rlu_Error_File,
   --#         Temp_Rlu_Used_File,
   --#         Temp_SDP_Error_File,
   --#         Temp_User_File,
   --#         Temp_Victor_Error_File,
   --#         Temp_Victor_File,
   --#         Temp_Warn_Error_File    from *;

end Total;
