CREATE TABLE t1 (
    year_col  INT,
    some_data INT
)
PARTITION BY RANGE (year_col) (
    PARTITION p0 VALUES LESS THAN (1991),
    PARTITION p1 VALUES LESS THAN (1995),
    PARTITION p2 VALUES LESS THAN (1999),
    PARTITION p3 VALUES LESS THAN (2002),
    PARTITION p4 VALUES LESS THAN (2006),
    PARTITION p5 VALUES LESS THAN MAXVALUE
);

CREATE TABLE tbl_name (
    id INT PRIMARY KEY AUTO_INCREMENT,
    c DATETIME NOT NULL,
    INDEX(col)
)
    ENGINE = InnoDB
    AUTO_INCREMENT = 1
    AVG_ROW_LENGTH = 10
    DEFAULT CHARACTER SET = utf8_unicode_ci
    CHECKSUM = 1
    DEFAULT COLLATE = utf8mb4_unicode_ci
    COMMENT = 'comment'
    CONNECTION = 'connection_string'
    DATA_DIRECTORY = 'path/to/dir'
    DELAY_KEY_WRITE = 0
    ENCRYPTED = NO
    ENCRYPTION_KEY_ID = 1234
    IETF_QUOTES = YES
    INDEX DIRECTORY = 'path/to/dir'
    INSERT_METHOD = LAST
    KEY_BLOCK_SIZE = 1024
    MAX_ROWS = 100000
    MIN_ROWS = 1
    PACK_KEYS = 1
    PAGE_CHECKSUM = 1
    PAGE_COMPRESSED = 0
    PAGE_COMPRESSION_LEVEL = 9
    PASSWORD = 'password'
    ROW_FORMAT = DYNAMIC
    SEQUENCE = 1
    STATS_AUTO_RECALC = 1
    STATS_PERSISTENT = 1
    STATS_SAMPLE_PAGES = 4
    TABLESPACE tablespace_name
    TRANSACTIONAL = 1
    UNION = (tbl1,tbl2)
    WITH SYSTEM VERSIONING
PARTITION BY LINEAR HASH(YEAR(c))
PARTITIONS 1
SUBPARTITION BY KEY(id, c)
    SUBPARTITIONS 1
PARTITION first_name VALUES LESS THAN 50 ENGINE = InnoDB COMMENT='comment'
;
