/* sqlheavy-transaction.c generated by valac 0.16.0, the Vala compiler
 * generated from sqlheavy-transaction.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_mutex_free0(var) ((var == NULL) ? NULL : (var = (sqlite3_mutex_free (var), NULL)))
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SqlHeavyTransactionResolveAsyncData SqlHeavyTransactionResolveAsyncData;
typedef struct _SqlHeavyTransactionCommitAsyncData SqlHeavyTransactionCommitAsyncData;
typedef struct _SqlHeavyTransactionRollbackAsyncData SqlHeavyTransactionRollbackAsyncData;

struct _SQLHeavyTransactionPrivate {
	SQLHeavyTransactionStatus _status;
	SQLHeavyQueryable* _parent;
	sqlite3_mutex* _transaction_lock;
	GSequence* _queue;
	GStaticRecMutex __lock__queue;
	GError* err;
};

struct _SqlHeavyTransactionResolveAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyTransaction* self;
	gboolean commit;
	SQLHeavyTransactionStatus _tmp0_;
	GError* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	SQLHeavyQuery* _tmp7_;
	SQLHeavyQuery* _tmp8_;
	SQLHeavyQuery* query;
	SQLHeavyQuery* _tmp9_;
	SQLHeavyQueryResult* _tmp10_;
	SQLHeavyQueryResult* _tmp11_;
	SQLHeavyTransactionStatus _tmp12_;
	gboolean _tmp13_;
	SQLHeavyTransactionStatus _tmp14_;
	SQLHeavyQueryable* _tmp15_;
	SQLHeavyTransactionStatus _tmp16_;
	GError * _inner_error_;
};

struct _SqlHeavyTransactionCommitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyTransaction* self;
	GError * _inner_error_;
};

struct _SqlHeavyTransactionRollbackAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyTransaction* self;
	GError * _inner_error_;
};


static gpointer sql_heavy_transaction_parent_class = NULL;
static SQLHeavyQueryableIface* sql_heavy_transaction_sql_heavy_queryable_parent_iface = NULL;

#define SQL_HEAVY_TRANSACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_HEAVY_TYPE_TRANSACTION, SQLHeavyTransactionPrivate))
enum  {
	SQL_HEAVY_TRANSACTION_DUMMY_PROPERTY,
	SQL_HEAVY_TRANSACTION_STATUS,
	SQL_HEAVY_TRANSACTION_PARENT,
	SQL_HEAVY_TRANSACTION_DATABASE
};
static void sql_heavy_transaction_real_lock (SQLHeavyQueryable* base);
static void sql_heavy_transaction_real_unlock (SQLHeavyQueryable* base);
SQLHeavyQueryResult* sql_heavy_query_result_new_no_exec (SQLHeavyQuery* query, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_construct_no_exec (GType object_type, SQLHeavyQuery* query, GError** error);
gboolean sql_heavy_query_result_next_internal (SQLHeavyQueryResult* self, GError** error);
static void sql_heavy_transaction_real_queue (SQLHeavyQueryable* base, SQLHeavyQuery* query, GError** error);
static void _g_object_unref0_ (gpointer var);
static void sql_heavy_transaction_resolve (SQLHeavyTransaction* self, gboolean commit, GError** error);
static void sql_heavy_transaction_set_status (SQLHeavyTransaction* self, SQLHeavyTransactionStatus value);
static void sql_heavy_transaction_resolve_async_data_free (gpointer _data);
static void sql_heavy_transaction_resolve_async (SQLHeavyTransaction* self, gboolean commit, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void sql_heavy_transaction_resolve_finish (SQLHeavyTransaction* self, GAsyncResult* _res_, GError** error);
static gboolean sql_heavy_transaction_resolve_async_co (SqlHeavyTransactionResolveAsyncData* _data_);
static void sql_heavy_transaction_resolve_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void sql_heavy_transaction_commit_async_data_free (gpointer _data);
static gboolean sql_heavy_transaction_commit_async_co (SqlHeavyTransactionCommitAsyncData* _data_);
static void sql_heavy_transaction_commit_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void sql_heavy_transaction_rollback_async_data_free (gpointer _data);
static gboolean sql_heavy_transaction_rollback_async_co (SqlHeavyTransactionRollbackAsyncData* _data_);
static void sql_heavy_transaction_rollback_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GObject * sql_heavy_transaction_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void sql_heavy_transaction_finalize (GObject* obj);
static void _vala_sql_heavy_transaction_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sql_heavy_transaction_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * {@inheritDoc}
     */
static void sql_heavy_transaction_real_lock (SQLHeavyQueryable* base) {
	SQLHeavyTransaction * self;
	sqlite3_mutex* _tmp0_;
	self = (SQLHeavyTransaction*) base;
	_tmp0_ = self->priv->_transaction_lock;
	sqlite3_mutex_enter (_tmp0_);
}


/**
     * {@inheritDoc}
     */
static void sql_heavy_transaction_real_unlock (SQLHeavyQueryable* base) {
	SQLHeavyTransaction * self;
	sqlite3_mutex* _tmp26_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyTransaction*) base;
	{
		GSequence* _tmp0_;
		_tmp0_ = self->priv->_queue;
		g_static_rec_mutex_lock (&self->priv->__lock__queue);
		{
			gboolean _tmp1_ = FALSE;
			GSequence* _tmp2_;
			gboolean _tmp5_;
			_tmp2_ = self->priv->_queue;
			if (_tmp2_ != NULL) {
				GSequence* _tmp3_;
				gint _tmp4_ = 0;
				_tmp3_ = self->priv->_queue;
				_tmp4_ = g_sequence_get_length (_tmp3_);
				_tmp1_ = _tmp4_ > 0;
			} else {
				_tmp1_ = FALSE;
			}
			_tmp5_ = _tmp1_;
			if (_tmp5_) {
				{
					{
						GSequence* _tmp6_;
						GSequenceIter* _tmp7_ = NULL;
						GSequenceIter* iter;
						_tmp6_ = self->priv->_queue;
						_tmp7_ = g_sequence_get_begin_iter (_tmp6_);
						iter = _tmp7_;
						{
							gboolean _tmp8_;
							_tmp8_ = TRUE;
							while (TRUE) {
								gboolean _tmp9_;
								GSequenceIter* _tmp12_;
								gboolean _tmp13_ = FALSE;
								GSequenceIter* _tmp14_;
								gconstpointer _tmp15_ = NULL;
								SQLHeavyQueryResult* _tmp16_;
								SQLHeavyQueryResult* _result_;
								SQLHeavyQueryResult* _tmp18_;
								GSequence* _tmp20_;
								GSequenceIter* _tmp21_;
								_tmp9_ = _tmp8_;
								if (!_tmp9_) {
									GSequenceIter* _tmp10_;
									GSequenceIter* _tmp11_ = NULL;
									_tmp10_ = iter;
									_tmp11_ = g_sequence_iter_next (_tmp10_);
									iter = _tmp11_;
								}
								_tmp8_ = FALSE;
								_tmp12_ = iter;
								_tmp13_ = g_sequence_iter_is_end (_tmp12_);
								if (!(!_tmp13_)) {
									break;
								}
								_tmp14_ = iter;
								_tmp15_ = g_sequence_get (_tmp14_);
								_tmp16_ = sql_heavy_query_result_new_no_exec ((SQLHeavyQuery*) _tmp15_, &_inner_error_);
								_result_ = _tmp16_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										goto __catch44_sql_heavy_error;
									}
									{
										GSequence* _tmp17_;
										_tmp17_ = self->priv->_queue;
										g_static_rec_mutex_unlock (&self->priv->__lock__queue);
									}
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
								_tmp18_ = _result_;
								sql_heavy_query_result_next_internal (_tmp18_, &_inner_error_);
								if (_inner_error_ != NULL) {
									_g_object_unref0 (_result_);
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										goto __catch44_sql_heavy_error;
									}
									_g_object_unref0 (_result_);
									{
										GSequence* _tmp19_;
										_tmp19_ = self->priv->_queue;
										g_static_rec_mutex_unlock (&self->priv->__lock__queue);
									}
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
								_tmp20_ = self->priv->_queue;
								_tmp21_ = iter;
								g_sequence_remove (_tmp21_);
								_g_object_unref0 (_result_);
							}
						}
					}
				}
				goto __finally44;
				__catch44_sql_heavy_error:
				{
					GError* e = NULL;
					GError* _tmp22_;
					const gchar* _tmp23_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp22_ = e;
					_tmp23_ = _tmp22_->message;
					g_critical ("sqlheavy-transaction.vala:53: Unable to execute queued query: %s", _tmp23_);
					_g_error_free0 (e);
				}
				__finally44:
				if (_inner_error_ != NULL) {
					{
						GSequence* _tmp24_;
						_tmp24_ = self->priv->_queue;
						g_static_rec_mutex_unlock (&self->priv->__lock__queue);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		__finally43:
		{
			GSequence* _tmp25_;
			_tmp25_ = self->priv->_queue;
			g_static_rec_mutex_unlock (&self->priv->__lock__queue);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp26_ = self->priv->_transaction_lock;
	sqlite3_mutex_leave (_tmp26_);
}


/**
     * {@inheritDoc}
     */
static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void sql_heavy_transaction_real_queue (SQLHeavyQueryable* base, SQLHeavyQuery* query, GError** error) {
	SQLHeavyTransaction * self;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyTransaction*) base;
	g_return_if_fail (query != NULL);
	{
		GSequence* _tmp0_;
		_tmp0_ = self->priv->_queue;
		g_static_rec_mutex_lock (&self->priv->__lock__queue);
		{
			GSequence* _tmp1_;
			GSequence* _tmp3_;
			SQLHeavyQuery* _tmp4_;
			SQLHeavyQuery* _tmp5_;
			GSequenceIter* _tmp6_ = NULL;
			_tmp1_ = self->priv->_queue;
			if (_tmp1_ == NULL) {
				GSequence* _tmp2_;
				_tmp2_ = g_sequence_new (_g_object_unref0_);
				_g_sequence_free0 (self->priv->_queue);
				self->priv->_queue = _tmp2_;
			}
			_tmp3_ = self->priv->_queue;
			_tmp4_ = query;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_tmp6_ = g_sequence_append (_tmp3_, _tmp5_);
		}
		__finally45:
		{
			GSequence* _tmp7_;
			_tmp7_ = self->priv->_queue;
			g_static_rec_mutex_unlock (&self->priv->__lock__queue);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


/**
     * Resolve the transaction
     *
     * @param commit whether to commit the transaction or roll it back
     */
static void sql_heavy_transaction_resolve (SQLHeavyTransaction* self, gboolean commit, GError** error) {
	SQLHeavyTransactionStatus _tmp0_;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	SQLHeavyQueryable* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	SQLHeavyQuery* _tmp8_ = NULL;
	SQLHeavyQuery* _tmp9_;
	SQLHeavyQuery* query;
	SQLHeavyQueryable* _tmp10_;
	SQLHeavyQuery* _tmp11_;
	SQLHeavyTransactionStatus _tmp12_ = 0;
	gboolean _tmp13_;
	SQLHeavyTransactionStatus _tmp14_;
	SQLHeavyQueryable* _tmp15_;
	SQLHeavyTransactionStatus _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_status;
	if (_tmp0_ != SQL_HEAVY_TRANSACTION_STATUS_UNRESOLVED) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_TRANSACTION, "Refusing to resolve an already resolved transaction.");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = commit;
	if (_tmp3_) {
		_tmp2_ = "RELEASE";
	} else {
		_tmp2_ = "ROLLBACK TRANSACTION TO";
	}
	_tmp4_ = self->priv->_parent;
	_tmp5_ = _tmp2_;
	_tmp6_ = g_strdup_printf ("%s SAVEPOINT 'SQLHeavy-0x%x';", _tmp5_, (guint) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = sql_heavy_queryable_prepare (_tmp4_, _tmp7_, &_inner_error_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	query = _tmp9_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp10_ = self->priv->_parent;
	_tmp11_ = query;
	sql_heavy_queryable_queue (_tmp10_, _tmp11_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (query);
			return;
		} else {
			_g_object_unref0 (query);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = commit;
	if (_tmp13_) {
		_tmp12_ = SQL_HEAVY_TRANSACTION_STATUS_COMMITTED;
	} else {
		_tmp12_ = SQL_HEAVY_TRANSACTION_STATUS_ROLLED_BACK;
	}
	_tmp14_ = _tmp12_;
	sql_heavy_transaction_set_status (self, _tmp14_);
	_tmp15_ = self->priv->_parent;
	sql_heavy_queryable_unlock (_tmp15_);
	_tmp16_ = self->priv->_status;
	g_signal_emit_by_name (self, "resolved", _tmp16_);
	_g_object_unref0 (query);
}


static void sql_heavy_transaction_resolve_async_data_free (gpointer _data) {
	SqlHeavyTransactionResolveAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SqlHeavyTransactionResolveAsyncData, _data_);
}


static void sql_heavy_transaction_resolve_async (SQLHeavyTransaction* self, gboolean commit, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyTransactionResolveAsyncData* _data_;
	SQLHeavyTransaction* _tmp0_;
	gboolean _tmp1_;
	_data_ = g_slice_new0 (SqlHeavyTransactionResolveAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_transaction_resolve_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_transaction_resolve_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = commit;
	_data_->commit = _tmp1_;
	sql_heavy_transaction_resolve_async_co (_data_);
}


static void sql_heavy_transaction_resolve_finish (SQLHeavyTransaction* self, GAsyncResult* _res_, GError** error) {
	SqlHeavyTransactionResolveAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Resolve the transaction asychronously
     *
     * @param commit whether to commit the transaction or roll it back
     */
static void sql_heavy_transaction_resolve_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SqlHeavyTransactionResolveAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sql_heavy_transaction_resolve_async_co (_data_);
}


static gboolean sql_heavy_transaction_resolve_async_co (SqlHeavyTransactionResolveAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_status;
	if (_data_->_tmp0_ != SQL_HEAVY_TRANSACTION_STATUS_UNRESOLVED) {
		_data_->_tmp1_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_TRANSACTION, "Refusing to resolve an already resolved transaction.");
		_data_->_inner_error_ = _data_->_tmp1_;
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp3_ = _data_->commit;
	if (_data_->_tmp3_) {
		_data_->_tmp2_ = "RELEASE";
	} else {
		_data_->_tmp2_ = "ROLLBACK TRANSACTION TO";
	}
	_data_->_tmp4_ = _data_->_tmp2_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_strdup_printf ("%s SAVEPOINT 'SQLHeavy-0x%x';", _data_->_tmp4_, (guint) _data_->self);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = sql_heavy_queryable_prepare ((SQLHeavyQueryable*) _data_->self, _data_->_tmp6_, &_data_->_inner_error_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_g_free0 (_data_->_tmp6_);
	_data_->query = _data_->_tmp8_;
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp9_ = _data_->query;
	_data_->_state_ = 1;
	sql_heavy_query_execute_async (_data_->_tmp9_, NULL, sql_heavy_transaction_resolve_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = sql_heavy_query_execute_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp11_ = _data_->_tmp10_;
	_g_object_unref0 (_data_->_tmp11_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->query);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->query);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp13_ = _data_->commit;
	if (_data_->_tmp13_) {
		_data_->_tmp12_ = SQL_HEAVY_TRANSACTION_STATUS_COMMITTED;
	} else {
		_data_->_tmp12_ = SQL_HEAVY_TRANSACTION_STATUS_ROLLED_BACK;
	}
	_data_->_tmp14_ = _data_->_tmp12_;
	sql_heavy_transaction_set_status (_data_->self, _data_->_tmp14_);
	_data_->_tmp15_ = _data_->self->priv->_parent;
	sql_heavy_queryable_unlock (_data_->_tmp15_);
	_data_->_tmp16_ = _data_->self->priv->_status;
	g_signal_emit_by_name (_data_->self, "resolved", _data_->_tmp16_);
	_g_object_unref0 (_data_->query);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Commit the transaction to the database
     */
void sql_heavy_transaction_commit (SQLHeavyTransaction* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	sql_heavy_transaction_resolve (self, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void sql_heavy_transaction_commit_async_data_free (gpointer _data) {
	SqlHeavyTransactionCommitAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SqlHeavyTransactionCommitAsyncData, _data_);
}


void sql_heavy_transaction_commit_async (SQLHeavyTransaction* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyTransactionCommitAsyncData* _data_;
	SQLHeavyTransaction* _tmp0_;
	_data_ = g_slice_new0 (SqlHeavyTransactionCommitAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_transaction_commit_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_transaction_commit_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sql_heavy_transaction_commit_async_co (_data_);
}


void sql_heavy_transaction_commit_finish (SQLHeavyTransaction* self, GAsyncResult* _res_, GError** error) {
	SqlHeavyTransactionCommitAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Commit the transaction to the database asynchronously
     */
static void sql_heavy_transaction_commit_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SqlHeavyTransactionCommitAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sql_heavy_transaction_commit_async_co (_data_);
}


static gboolean sql_heavy_transaction_commit_async_co (SqlHeavyTransactionCommitAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	sql_heavy_transaction_resolve_async (_data_->self, TRUE, sql_heavy_transaction_commit_async_ready, _data_);
	return FALSE;
	_state_1:
	sql_heavy_transaction_resolve_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Rollback the transaction
     */
void sql_heavy_transaction_rollback (SQLHeavyTransaction* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	sql_heavy_transaction_resolve (self, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void sql_heavy_transaction_rollback_async_data_free (gpointer _data) {
	SqlHeavyTransactionRollbackAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SqlHeavyTransactionRollbackAsyncData, _data_);
}


void sql_heavy_transaction_rollback_async (SQLHeavyTransaction* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyTransactionRollbackAsyncData* _data_;
	SQLHeavyTransaction* _tmp0_;
	_data_ = g_slice_new0 (SqlHeavyTransactionRollbackAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_transaction_rollback_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_transaction_rollback_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sql_heavy_transaction_rollback_async_co (_data_);
}


void sql_heavy_transaction_rollback_finish (SQLHeavyTransaction* self, GAsyncResult* _res_, GError** error) {
	SqlHeavyTransactionRollbackAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Rollback the transaction asynchronously
     */
static void sql_heavy_transaction_rollback_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SqlHeavyTransactionRollbackAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sql_heavy_transaction_rollback_async_co (_data_);
}


static gboolean sql_heavy_transaction_rollback_async_co (SqlHeavyTransactionRollbackAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	sql_heavy_transaction_resolve_async (_data_->self, FALSE, sql_heavy_transaction_rollback_async_ready, _data_);
	return FALSE;
	_state_1:
	sql_heavy_transaction_resolve_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Create a new transaction.
     *
     * @param parent The queryable to create the transaction on top of
     */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


SQLHeavyTransaction* sql_heavy_transaction_construct (GType object_type, SQLHeavyQueryable* parent, GError** error) {
	SQLHeavyTransaction * self = NULL;
	SQLHeavyQueryable* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = parent;
	self = (SQLHeavyTransaction*) g_object_new (object_type, "parent", _tmp0_, NULL);
	_tmp1_ = self->priv->err;
	if (_tmp1_ != NULL) {
		GError* _tmp2_;
		GError* _tmp3_;
		_tmp2_ = self->priv->err;
		_tmp3_ = _g_error_copy0 (_tmp2_);
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


SQLHeavyTransaction* sql_heavy_transaction_new (SQLHeavyQueryable* parent, GError** error) {
	return sql_heavy_transaction_construct (SQL_HEAVY_TYPE_TRANSACTION, parent, error);
}


SQLHeavyTransactionStatus sql_heavy_transaction_get_status (SQLHeavyTransaction* self) {
	SQLHeavyTransactionStatus result;
	SQLHeavyTransactionStatus _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_status;
	result = _tmp0_;
	return result;
}


static void sql_heavy_transaction_set_status (SQLHeavyTransaction* self, SQLHeavyTransactionStatus value) {
	SQLHeavyTransactionStatus _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_status = _tmp0_;
	g_object_notify ((GObject *) self, "status");
}


SQLHeavyQueryable* sql_heavy_transaction_get_parent (SQLHeavyTransaction* self) {
	SQLHeavyQueryable* result;
	SQLHeavyQueryable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent;
	result = _tmp0_;
	return result;
}


static void sql_heavy_transaction_set_parent (SQLHeavyTransaction* self, SQLHeavyQueryable* value) {
	SQLHeavyQueryable* _tmp0_;
	SQLHeavyQueryable* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_parent);
	self->priv->_parent = _tmp1_;
	g_object_notify ((GObject *) self, "parent");
}


static SQLHeavyDatabase* sql_heavy_transaction_real_get_database (SQLHeavyQueryable* base) {
	SQLHeavyDatabase* result;
	SQLHeavyTransaction* self;
	SQLHeavyQueryable* _tmp0_;
	SQLHeavyDatabase* _tmp1_;
	SQLHeavyDatabase* _tmp2_;
	self = (SQLHeavyTransaction*) base;
	_tmp0_ = self->priv->_parent;
	_tmp1_ = sql_heavy_queryable_get_database (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static GObject * sql_heavy_transaction_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SQLHeavyTransaction * self;
	SQLHeavyQueryable* _tmp0_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (sql_heavy_transaction_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SQL_HEAVY_TRANSACTION (obj);
	_tmp0_ = self->priv->_parent;
	sql_heavy_queryable_lock (_tmp0_);
	{
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		SQLHeavyQuery* _tmp3_ = NULL;
		SQLHeavyQuery* _tmp4_;
		SQLHeavyQuery* _tmp5_;
		SQLHeavyQuery* _tmp6_;
		SQLHeavyQueryResult* _tmp7_ = NULL;
		SQLHeavyQueryResult* _tmp8_;
		_tmp1_ = g_strdup_printf ("SAVEPOINT 'SQLHeavy-0x%x';", (guint) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = sql_heavy_queryable_prepare ((SQLHeavyQueryable*) self, _tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch46_sql_heavy_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp6_ = _tmp5_;
		_tmp7_ = sql_heavy_query_execute (_tmp6_, NULL, &_inner_error_, NULL);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (_tmp6_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch46_sql_heavy_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	goto __finally46;
	__catch46_sql_heavy_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp13_;
		gint _tmp14_;
		SQLHeavyQueryable* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _g_error_copy0 (_tmp9_);
		_g_error_free0 (self->priv->err);
		self->priv->err = _tmp10_;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->code;
		g_critical ("sqlheavy-transaction.vala:160: Unable to create transaction: %s (%d)", _tmp12_, _tmp14_);
		_tmp15_ = self->priv->_parent;
		sql_heavy_queryable_unlock (_tmp15_);
		_g_error_free0 (e);
	}
	__finally46:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void sql_heavy_transaction_class_init (SQLHeavyTransactionClass * klass) {
	sql_heavy_transaction_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SQLHeavyTransactionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sql_heavy_transaction_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sql_heavy_transaction_set_property;
	G_OBJECT_CLASS (klass)->constructor = sql_heavy_transaction_constructor;
	G_OBJECT_CLASS (klass)->finalize = sql_heavy_transaction_finalize;
	/**
	     * Status of the transaction.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_TRANSACTION_STATUS, g_param_spec_enum ("status", "status", "status", SQL_HEAVY_TYPE_TRANSACTION_STATUS, SQL_HEAVY_TRANSACTION_STATUS_UNRESOLVED, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Parent querayble
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_TRANSACTION_PARENT, g_param_spec_object ("parent", "parent", "parent", SQL_HEAVY_TYPE_QUERYABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * {@inheritDoc}
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_TRANSACTION_DATABASE, g_param_spec_object ("database", "database", "database", SQL_HEAVY_TYPE_DATABASE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The transaction has been resolved (committed or rolled back)
	     *
	     * @param status whether the transaction was committed or rolled back
	     */
	g_signal_new ("resolved", SQL_HEAVY_TYPE_TRANSACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, SQL_HEAVY_TYPE_TRANSACTION_STATUS);
}


static void sql_heavy_transaction_sql_heavy_queryable_interface_init (SQLHeavyQueryableIface * iface) {
	sql_heavy_transaction_sql_heavy_queryable_parent_iface = g_type_interface_peek_parent (iface);
	iface->lock = (void (*)(SQLHeavyQueryable*)) sql_heavy_transaction_real_lock;
	iface->unlock = (void (*)(SQLHeavyQueryable*)) sql_heavy_transaction_real_unlock;
	iface->queue = (void (*)(SQLHeavyQueryable*, SQLHeavyQuery*, GError**)) sql_heavy_transaction_real_queue;
	iface->get_database = sql_heavy_transaction_real_get_database;
}


static void sql_heavy_transaction_instance_init (SQLHeavyTransaction * self) {
	sqlite3_mutex* _tmp0_;
	self->priv = SQL_HEAVY_TRANSACTION_GET_PRIVATE (self);
	self->priv->_status = SQL_HEAVY_TRANSACTION_STATUS_UNRESOLVED;
	_tmp0_ = sqlite3_mutex_alloc (SQLITE_MUTEX_FAST);
	self->priv->_transaction_lock = _tmp0_;
	g_static_rec_mutex_init (&self->priv->__lock__queue);
	self->priv->_queue = NULL;
	self->priv->err = NULL;
}


static void sql_heavy_transaction_finalize (GObject* obj) {
	SQLHeavyTransaction * self;
	SQLHeavyTransactionStatus _tmp0_;
	GError * _inner_error_ = NULL;
	self = SQL_HEAVY_TRANSACTION (obj);
	_tmp0_ = self->priv->_status;
	if (_tmp0_ == SQL_HEAVY_TRANSACTION_STATUS_UNRESOLVED) {
		sql_heavy_transaction_rollback (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	_g_object_unref0 (self->priv->_parent);
	_sqlite3_mutex_free0 (self->priv->_transaction_lock);
	g_static_rec_mutex_free (&self->priv->__lock__queue);
	_g_sequence_free0 (self->priv->_queue);
	_g_error_free0 (self->priv->err);
	G_OBJECT_CLASS (sql_heavy_transaction_parent_class)->finalize (obj);
}


/**
   * Object representing an SQLite transaction
   *
   * Note that this is implemented using SQLite's
   * [[http://sqlite.org/lang_savepoint.html|SAVEPOINT]] feature,
   * meaning that by default it is like that of a
   * {@link TransactionType.DEFERRED} transaction. This behaviour may
   * be modified by first manually running a
   * [[http://sqlite.org/lang_transaction.html|transaction]] in SQL,
   * but remember that such transactions cannot be nested.
   */
GType sql_heavy_transaction_get_type (void) {
	static volatile gsize sql_heavy_transaction_type_id__volatile = 0;
	if (g_once_init_enter (&sql_heavy_transaction_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SQLHeavyTransactionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_heavy_transaction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SQLHeavyTransaction), 0, (GInstanceInitFunc) sql_heavy_transaction_instance_init, NULL };
		static const GInterfaceInfo sql_heavy_queryable_info = { (GInterfaceInitFunc) sql_heavy_transaction_sql_heavy_queryable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType sql_heavy_transaction_type_id;
		sql_heavy_transaction_type_id = g_type_register_static (G_TYPE_OBJECT, "SQLHeavyTransaction", &g_define_type_info, 0);
		g_type_add_interface_static (sql_heavy_transaction_type_id, SQL_HEAVY_TYPE_QUERYABLE, &sql_heavy_queryable_info);
		g_once_init_leave (&sql_heavy_transaction_type_id__volatile, sql_heavy_transaction_type_id);
	}
	return sql_heavy_transaction_type_id__volatile;
}


static void _vala_sql_heavy_transaction_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SQLHeavyTransaction * self;
	self = SQL_HEAVY_TRANSACTION (object);
	switch (property_id) {
		case SQL_HEAVY_TRANSACTION_STATUS:
		g_value_set_enum (value, sql_heavy_transaction_get_status (self));
		break;
		case SQL_HEAVY_TRANSACTION_PARENT:
		g_value_set_object (value, sql_heavy_transaction_get_parent (self));
		break;
		case SQL_HEAVY_TRANSACTION_DATABASE:
		g_value_take_object (value, sql_heavy_queryable_get_database ((SQLHeavyQueryable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sql_heavy_transaction_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SQLHeavyTransaction * self;
	self = SQL_HEAVY_TRANSACTION (object);
	switch (property_id) {
		case SQL_HEAVY_TRANSACTION_STATUS:
		sql_heavy_transaction_set_status (self, g_value_get_enum (value));
		break;
		case SQL_HEAVY_TRANSACTION_PARENT:
		sql_heavy_transaction_set_parent (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



