enum Version {
	HTTP_0_9,
	HTTP_1_0,
	HTTP_1_1
}

enum Status {
	none = 0,

	//Informational 1xx
	Continue = 100,
	Switching_Protocol = 101,

	//Successful 2xx
	OK = 200,
	Created = 201,
	Accepted = 202,
	Non_Authorative_Information = 203,
	No_Content = 204,
	Reset_Content = 205,
	Partial_Content = 206,

	//Redirectional 3xx
	Multiple_Choice = 300,
	Moved_Permanently = 301,
	Found = 302,
	See_Other = 303,
	Not_Modified = 304,
	Use_Proxy = 305,
	//306 (Unused), not used anymore
	Temporary_Redirect = 307,

	//Client Error 4xx
	Bad_Request = 400,
	Unauthorized = 401,
	Payment_Required = 402,
	Forbidden = 403,
	Not_Found = 404,
	Method_Not_Allowed = 405,
	Not_Acceptable = 406,
	Proxy_Authentication_Required = 407,
	Request_Timeout = 408,
	Conflict = 409,
	Gone = 410,
	Length_Required = 411,
	Prediction_Failed = 412,
	Request_Entity_Too_Large = 413,
	Request_URI_Too_Long = 414,
	Unsupported_Media_Type = 415,
	Request_Range_Not_Satisfiable = 416,
	Expectation_Failed = 417,

	//Server Error 5xx
	Internal_Server_Error = 500,
	Not_Implemented = 501,
	Bad_Gateway = 502,
	Service_Unavailable = 503,
	Gateway_Timeout = 504,
	HTTP_Version_Not_Supported = 505
}

enum Method {
	none,
	OPTIONS,
	GET,
	HEAD,
	POST,
	PUT,
	DELETE,
	TRACE,
	CONNECT,
	BAD_METHOD
}

