/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_STATUSCMD_H
#define _SC_STATUSCMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class StatusParam;

/**
 * Command for getting status information of a working copy.
 */
class StatusCmd : public ScCmd
{
public:
  /**
   * Construct a StatusCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  StatusCmd( StatusParam* param, CmdResultCallback* cb );
  ~StatusCmd();

  void run();

private:
  // in
  StatusParam*       _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_STATUSCMD_H

