/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_COMMITBATON_H
#define _SVN_COMMITBATON_H

// sc
#include "CommitItemTypes.h"
#include "util/String.h"

namespace svn
{

/**
 * This interface combines subversions void* log_msg_baton and
 * svn_client_get_commit_log_t.
 */
class CommitBaton
{
public:
  virtual ~CommitBaton() {}

  virtual bool getLogMsg( sc::String& logMsg, sc::String& tmpFile, const CommitItems& items ) = 0;
};

} // namespace

#endif // _SVN_COMMITBATON_H

