# - Try to find FFmpeg libraries
# Once done this will define
#  FFMPEG_FOUND - System has FFmpeg
#  FFMPEG_INCLUDE_DIRS - The FFmpeg include directories
#  FFMPEG_LIBRARIES - The libraries needed to use FFmpeg

find_package(PkgConfig REQUIRED)
pkg_check_modules(PC_FFMPEG_AVCODEC QUIET libavcodec)
pkg_check_modules(PC_FFMPEG_AVFORMAT QUIET libavformat)
pkg_check_modules(PC_FFMPEG_AVUTIL QUIET libavutil)
pkg_check_modules(PC_FFMPEG_SWRESAMPLE QUIET libswresample)
set(FFMPEG_DEFINITIONS ${PC_FFMPEG_CFLAGS_OTHER})
set(FFMPEG_VERSION ${PC_FFMPEG_VERSION})

find_path(FFMPEG_INCLUDE_DIR libavcodec/avcodec.h
	HINTS
		${PC_FFMPEG_AVCODEC_INCLUDEDIR} ${PC_FFMPEG_AVCODEC_INCLUDE_DIRS}
		${PC_FFMPEG_AVFORMAT_INCLUDEDIR} ${PC_FFMPEG_AVFORMAT_INCLUDE_DIRS}
		${PC_FFMPEG_AVUTIL_INCLUDEDIR} ${PC_FFMPEG_AVUTIL_INCLUDE_DIRS}
	PATH_SUFFIXES ffmpeg)

find_library(FFMPEG_AVCODEC_LIBRARY
	NAMES avcodec
	HINTS
		${PC_FFMPEG_AVCODEC_LIBDIR} ${PC_FFMPEG_AVCODEC_LIBRARY_DIRS})

find_library(FFMPEG_AVFORMAT_LIBRARY
	NAMES avformat
	HINTS
		${PC_FFMPEG_AVFORMAT_LIBDIR} ${PC_FFMPEG_AVFORMAT_LIBRARY_DIRS})

find_library(FFMPEG_AVUTIL_LIBRARY
	NAMES avutil
	HINTS
		${PC_FFMPEG_AVUTIL_LIBDIR} ${PC_FFMPEG_AVUTIL_LIBRARY_DIRS})

find_library(FFMPEG_SWRESAMPLE_LIBRARY
	NAMES swresample
	HINTS
		${PC_FFMPEG_SWRESAMPLE_LIBDIR} ${PC_FFMPEG_SWRESAMPLE_LIBRARY_DIRS})

set(FFMPEG_LIBRARIES ${FFMPEG_AVCODEC_LIBRARY} ${FFMPEG_AVFORMAT_LIBRARY} ${FFMPEG_AVUTIL_LIBRARY} ${FFMPEG_SWRESAMPLE_LIBRARY})
set(FFMPEG_INCLUDE_DIRS ${FFMPEG_INCLUDE_DIR})

include(FindPackageHandleStandardArgs)
# handle the QUIETLY and REQUIRED arguments and set FFMPEG_FOUND to TRUE if all listed variables are TRUE
find_package_handle_standard_args(FFMPEG
	REQUIRED_VARS FFMPEG_AVCODEC_LIBRARY FFMPEG_AVFORMAT_LIBRARY FFMPEG_AVUTIL_LIBRARY FFMPEG_SWRESAMPLE_LIBRARY FFMPEG_INCLUDE_DIR)

if(FFMPEG_FOUND)
	if(NOT FFmpeg_FIND_QUIETLY)
		message(STATUS "Found FFmpeg: "
			"\n\tinclude dir: ${FFMPEG_INCLUDE_DIR}"
			"\n\t${FFMPEG_AVCODEC_LIBRARY} (version ${PC_FFMPEG_AVCODEC_VERSION})"
			"\n\t${FFMPEG_AVFORMAT_LIBRARY} (version ${PC_FFMPEG_AVFORMAT_VERSION})"
			"\n\t${FFMPEG_AVUTIL_LIBRARY} (version ${PC_FFMPEG_AVUTIL_VERSION})"
			"\n\t${FFMPEG_SWRESAMPLE_LIBRARY} (version ${PC_FFMPEG_SWRESAMPLE_VERSION})")
	endif(NOT FFmpeg_FIND_QUIETLY)
else(FFMPEG_FOUND)
	if(Fmpeg_FIND_REQUIRED)
		message(FATAL_ERROR "FFmpeg was not found.")
	endif(Fmpeg_FIND_REQUIRED)
endif(FFMPEG_FOUND)

mark_as_advanced(FFMPEG_INCLUDE_DIR FFMPEG_LIBRARY)
