/*
 *   Copyright (C) 2008, 2009 Nicolas Vion <nico@yojik.eu>
 *
 *   This file is part of Swac-scan.
 * 
 *   Swac-scan is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   Swac-scan is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Swac-scan.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ogg/ogg.h>
#include <iostream>
#include "speex.hh"


#define readint(buf) \
	(((buf[3] << 24) & 0xff000000)| \
	((buf[2] << 16) & 0xff0000)| \
	((buf[1] << 8) & 0xff00)| \
	(buf[0] & 0xff))

#define translate(cursor, step, limit) \
	if (cursor + step > limit) \
		return false; \
	cursor += step; 

#define get_int(result, cursor, limit) \
	if (cursor + 4 > limit) \
		return false; \
	result = readint(cursor); \
	translate(cursor, 4, limit); 


#define get_string(result, cursor, limit) \
	get_int(len, cursor, limit);  \
	if (cursor + len > limit) \
		return false; \
	std::string result(cursor, len); \
	translate(cursor, len, limit);


bool TagSpeex::extract_comments(char *comments, int length, bool const ignore_standards_fields) {
	char *cursor = comments;
	int len;
	char *end;
	end = cursor + length;

	//vendor
	get_string(vendor, cursor, end);

	//vectors
	int nb;
	get_int(nb, cursor, end); 
	for (int i = 0; i < nb; i++) {
		get_string(vector, cursor, end);
		add_vector(vector, ignore_standards_fields);
	}
	return true;
}

bool TagSpeex::extract_from_file(std::string const path, bool const ignore_standards_fields) {
	Tag::extract_from_file(path);

	ogg_sync_state   oy;
	ogg_page         og;
	ogg_packet       op;
	ogg_stream_state os;

	FILE *f = fopen(path.c_str(), "rb");

	//Init Ogg data struct
	ogg_sync_init(&oy);

	int packet_count = 0;
	int stream_init = 0;
	
	//Main decoding loop
	while (!feof(f)) {
		char *data;
		int nb_read;

		//Get the ogg buffer for writing
		data = ogg_sync_buffer(&oy, 1024);

		//Read bitstream from input file
		nb_read = fread(data, sizeof(char), 1024, f);
		ogg_sync_wrote(&oy, nb_read);

		//Loop for all complete pages we got (most likely only one)
		while (ogg_sync_pageout(&oy, &og) == 1) {
			if (stream_init == 0) {
				ogg_stream_init(&os, ogg_page_serialno(&og));
				stream_init = 1;
			}

			//Add page to the bitstream
			ogg_stream_pagein(&os, &og);

			//Extract all available packets
			while (!feof(f) && ogg_stream_packetout(&os, &op) == 1) {

				//second packet contains the vorbis comment tag
				if (packet_count == 1) {
					return extract_comments((char*) op.packet, op.bytes, ignore_standards_fields);
				}
				packet_count++;
			}
		}
	}
	return false;
}


