#!/bin/sh
#
# tardy - a tar post-processor
# Copyright (C) 2011 Peter Miller
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#

TEST_SUBJECT="read ar(1) long names, second kind"
. test_prelude

sed 's|$$||' > test.ok << 'fubar'
00000000: 61 62 63 64 65 66 67 68 69 6A 6B 6C 6D 6E 6F 70  abcdefghijklmnop$
00000010: 71 72 73 74 75 76 77 78 79 7A 00 00 00 00 00 00  qrstuvwxyz......$
00000020: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000030: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000040: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000050: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000060: 00 00 00 00 20 20 20 20 36 34 34 00 20 20 20 20  ....    644.    $
00000070: 20 20 30 00 20 20 20 20 20 20 30 00 20 20 20 20    0.      0.    $
00000080: 20 20 20 20 20 33 33 00 20 20 20 20 20 32 35 30       33.     250$
00000090: 36 30 30 00 20 20 31 34 32 32 37 00 30 00 00 00  600.  14227.0...$
000000A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000000B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000000C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000000D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000000E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000000F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000100: 00 75 73 74 61 72 20 20 00 72 6F 6F 74 00 00 00  .ustar  .root...$
00000110: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000120: 00 00 00 00 00 00 00 00 00 72 6F 6F 74 00 00 00  .........root...$
00000130: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000140: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000150: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000160: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000170: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000180: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000190: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000001A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000001B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000001C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000001D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000001E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000001F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000200: 61 62 63 64 65 66 67 68 69 6A 6B 6C 6D 6E 6F 70  abcdefghijklmnop$
00000210: 71 72 73 74 75 76 77 78 79 7A 0A 00 00 00 00 00  qrstuvwxyz......$
00000220: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000230: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000240: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000250: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000260: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000270: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000280: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000290: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000002A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000002B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000002C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000002D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000002E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000002F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000300: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000310: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000320: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000330: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000340: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000350: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000360: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000370: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000380: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000390: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000003A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000003B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000003C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000003D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000003E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000003F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000400: 6A 6B 6C 6D 6E 6F 70 71 72 73 74 75 76 77 78 79  jklmnopqrstuvwxy$
00000410: 7A 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  z...............$
00000420: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000430: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000440: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000450: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000460: 00 00 00 00 20 20 20 20 36 34 34 00 20 20 20 20  ....    644.    $
00000470: 20 20 30 00 20 20 20 20 20 20 30 00 20 20 20 20    0.      0.    $
00000480: 20 20 20 20 20 32 32 00 20 20 20 20 20 32 35 30       22.     250$
00000490: 36 30 30 00 20 20 31 32 34 31 30 00 30 00 00 00  600.  12410.0...$
000004A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000004B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000004C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000004D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000004E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000004F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000500: 00 75 73 74 61 72 20 20 00 72 6F 6F 74 00 00 00  .ustar  .root...$
00000510: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000520: 00 00 00 00 00 00 00 00 00 72 6F 6F 74 00 00 00  .........root...$
00000530: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000540: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000550: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000560: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000570: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000580: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000590: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000005A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000005B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000005C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000005D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000005E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000005F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000600: 6A 6B 6C 6D 6E 6F 70 71 72 73 74 75 76 77 78 79  jklmnopqrstuvwxy$
00000610: 7A 0A 00 00 00 00 00 00 00 00 00 00 00 00 00 00  z...............$
00000620: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000630: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000640: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000650: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000660: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000670: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000680: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000690: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000006A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000006B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000006C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000006D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000006E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000006F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000700: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000710: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000720: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000730: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000740: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000750: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000760: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000770: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000780: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000790: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000007A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000007B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000007C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000007D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000007E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000007F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000800: 78 79 7A 00 00 00 00 00 00 00 00 00 00 00 00 00  xyz.............$
00000810: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000820: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000830: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000840: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000850: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000860: 00 00 00 00 20 20 20 20 36 34 34 00 20 20 20 20  ....    644.    $
00000870: 20 20 30 00 20 20 20 20 20 20 30 00 20 20 20 20    0.      0.    $
00000880: 20 20 20 20 20 20 34 00 20 20 20 20 20 32 35 30        4.     250$
00000890: 36 30 30 00 20 20 20 37 33 32 31 00 30 00 00 00  600.   7321.0...$
000008A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000008B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000008C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000008D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000008E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000008F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000900: 00 75 73 74 61 72 20 20 00 72 6F 6F 74 00 00 00  .ustar  .root...$
00000910: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000920: 00 00 00 00 00 00 00 00 00 72 6F 6F 74 00 00 00  .........root...$
00000930: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000940: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000950: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000960: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000970: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000980: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000990: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000009A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000009B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000009C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000009D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000009E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
000009F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000A00: 78 79 7A 0A 00 00 00 00 00 00 00 00 00 00 00 00  xyz.............$
00000A10: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000A20: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000A30: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000A40: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000A50: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000A60: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000A70: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000A80: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000A90: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000AA0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000AB0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000AC0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000AD0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000AE0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000AF0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000B00: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000B10: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000B20: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000B30: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000B40: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000B50: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000B60: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000B70: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000B80: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000B90: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000BA0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000BB0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000BC0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000BD0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000BE0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
00000BF0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................$
fubar
if test $? -ne 0 ; then no_result; fi

# make an archive with files with mostly long names
mkdir junk
if test $? -ne 0 ; then no_result; fi
echo xyz > junk/xyz
if test $? -ne 0 ; then no_result; fi
echo jklmnopqrstuvwxyz > junk/jklmnopqrstuvwxyz
if test $? -ne 0 ; then no_result; fi
echo abcdefghijklmnopqrstuvwxyz > junk/abcdefghijklmnopqrstuvwxyz
if test $? -ne 0 ; then no_result; fi
find junk -type f | sort > junk.list
if test $? -ne 0 ; then no_result; fi
tardy -ifmt=list junk.list -ofmt=ar-bsd-l2 junk.a
if test $? -ne 0 ; then no_result; fi

# run the command
tardy -auto-test junk.a -ofmt=tar test.out -hexdump
if test $? -ne 0 ; then fail; fi

# make sure we get the expected results
diff test.ok test.out || fail

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
