package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTLSCipherPolicies invokes the slb.ListTLSCipherPolicies API synchronously
func (client *Client) ListTLSCipherPolicies(request *ListTLSCipherPoliciesRequest) (response *ListTLSCipherPoliciesResponse, err error) {
	response = CreateListTLSCipherPoliciesResponse()
	err = client.DoAction(request, response)
	return
}

// ListTLSCipherPoliciesWithChan invokes the slb.ListTLSCipherPolicies API asynchronously
func (client *Client) ListTLSCipherPoliciesWithChan(request *ListTLSCipherPoliciesRequest) (<-chan *ListTLSCipherPoliciesResponse, <-chan error) {
	responseChan := make(chan *ListTLSCipherPoliciesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTLSCipherPolicies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTLSCipherPoliciesWithCallback invokes the slb.ListTLSCipherPolicies API asynchronously
func (client *Client) ListTLSCipherPoliciesWithCallback(request *ListTLSCipherPoliciesRequest, callback func(response *ListTLSCipherPoliciesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTLSCipherPoliciesResponse
		var err error
		defer close(result)
		response, err = client.ListTLSCipherPolicies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTLSCipherPoliciesRequest is the request struct for api ListTLSCipherPolicies
type ListTLSCipherPoliciesRequest struct {
	*requests.RpcRequest
	AccessKeyId          string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	IncludeListener      requests.Boolean `position:"Query" name:"IncludeListener"`
	TLSCipherPolicyId    string           `position:"Query" name:"TLSCipherPolicyId"`
	NextToken            string           `position:"Query" name:"NextToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Name                 string           `position:"Query" name:"Name"`
	MaxItems             requests.Integer `position:"Query" name:"MaxItems"`
}

// ListTLSCipherPoliciesResponse is the response struct for api ListTLSCipherPolicies
type ListTLSCipherPoliciesResponse struct {
	*responses.BaseResponse
	NextToken         string            `json:"NextToken" xml:"NextToken"`
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	TotalCount        int               `json:"TotalCount" xml:"TotalCount"`
	IsTruncated       bool              `json:"IsTruncated" xml:"IsTruncated"`
	TLSCipherPolicies []TLSCipherPolicy `json:"TLSCipherPolicies" xml:"TLSCipherPolicies"`
}

// CreateListTLSCipherPoliciesRequest creates a request to invoke ListTLSCipherPolicies API
func CreateListTLSCipherPoliciesRequest() (request *ListTLSCipherPoliciesRequest) {
	request = &ListTLSCipherPoliciesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "ListTLSCipherPolicies", "Slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTLSCipherPoliciesResponse creates a response to parse from ListTLSCipherPolicies response
func CreateListTLSCipherPoliciesResponse() (response *ListTLSCipherPoliciesResponse) {
	response = &ListTLSCipherPoliciesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
