## TFSA-2022-164: `CHECK_EQ` fail via input in `SparseMatrixNNZ`

### CVE Number
CVE-2022-41901

### Impact
An input `sparse_matrix` that is not a matrix with a shape with rank 0 will trigger a `CHECK` fail in [`tf.raw_ops.SparseMatrixNNZ`](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/kernels/sparse/sparse_matrix.h).

```python
import tensorflow as tf
tf.raw_ops.SparseMatrixNNZ(sparse_matrix=[])
```

### Patches
We have patched the issue in GitHub commits [f856d02e5322821aad155dad9b3acab1e9f5d693](https://github.com/tensorflow/tensorflow/commit/f856d02e5322821aad155dad9b3acab1e9f5d693).

The fix will be included in TensorFlow 2.11. We will also cherrypick this commit on TensorFlow 2.10.1, 2.9.3, and TensorFlow 2.8.4, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Kang Hong Jin
