---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, communication, correspondance
              mailing, liste de diffusion, courrier, communication d'entreprise
---

# Comment mettre en forme un courrier interne (newsletter) ?

## Avec l'extension <ctanpkg:newspaper>

L'extension <ctanpkg:newspaper>, de Matthew Allen, permet d'obtenir quelques 
commandes pour faire une mise en forme ressemblant à celle d'un journal 
(en l'occurrence, une première page ressemblant à celle du 
*[New York Times](https://www.nytimes.com/)*).

Malheureusement, cette extension impose, pour le nom du journal,
l'utilisation d'une fonte gothique fournie par <ctanpkg:yfonts>
dont le chargement peut causer des erreurs sur des installations récentes.
En outre, cette fonte ne semble pas inclure de caractères accentués.
L'exemple ci-dessous montre comment imposer l'utilisation d'une autre fonte.

```
%!TEX engine=lualatex
\documentclass[french]{article}
  \usepackage{lmodern}
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lipsum}         % Du faux texte
  \usepackage{multicol}
  \usepackage{yfonts-otf}     % Évite les erreurs causées par yfonts
  \usepackage{newspaper}
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \makeatletter
    % Permet de mettre en forme le nom du journal avec la fonte
    % que l'on souhaite. Remplacez \huge\sffamily selon votre désir.
    % \renewcommand\textgoth[1]{\huge\sffamily \@papername}
  \makeatother
  % Réglages pour le titre 
  \date{\today}
  \currentvolume{12}
  \currentissue{1}
  \SetPaperName{Le sporadique}
  \SetHeaderName{Le sporadique}
  \SetPaperLocation{}
  \SetPaperSlogan{\og{}Vous ne le verrez pas venir !\fg{}}
  \SetPaperPrice{Gratuit}

\begin{document}
\maketitle %  génération du bandeau de titre
\begin{multicols}{3}
  \headline{Ciel, mon Lipsum !}
  \lipsum[1-5]
  \closearticle
  \headline{Faux-texte, quand tu nous tiens.}
  \lipsum[6-7]
  \closearticle
\end{multicols}
\end{document}
```


## Avec l'extension <ctanpkg:letgut>

Cette extension de [l'association GUTenberg](https://www.gutenberg-asso.fr/) 
permet de mettre en forme son bulletin irrégulomestriel, 
la [Lettre de GuTenberg](https://publications.gutenberg-asso.fr/lettre). Elle
pourrait donc être librement utilisée et adaptée pour d'autres parutions.

:::{todo} Ajouter un exemple
:::


## Avec l'extension <ctanpkg:newsletr>

L'extension <ctanpkg:newsletr> offre un ensemble de commandes pour mettre 
en page des *newsletters*. Il est destiné à TeX (et pas LaTeX). Le résultat 
est très satisfaisant (multicolonnages, cadres simples, etc.).


## Avec des canevas

Des [canevas](https://www.latextemplates.com/cat/newsletters) sont proposés 
sur le site de [LaTeX Templates](https://www.latextemplates.com/).
