/*
 * Copyright 2013-2014 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef PURCHASECLIENT_H
#define PURCHASECLIENT_H

#include <QQuickItem>
#include <QVariant>
#include "purchase_service_client.h"

namespace UbuntuPurchases {

class PurchaseClient : public QQuickItem
{
    Q_OBJECT

public:
    PurchaseClient(QQuickItem *parent = 0);
    ~PurchaseClient();

    Q_INVOKABLE void purchaseItem(const QVariantMap id);

Q_SIGNALS:
    void failed(QString packageName);
    void succeeded(QString packageName);

private Q_SLOTS:
    void purchaseFailed(const QString &packageName);
    void purchaseSucceeded(const QString &packageName);

private:
    PurchaseServiceClient* m_client;

};

}

QML_DECLARE_TYPE(UbuntuPurchases::PurchaseClient)

#endif // PURCHASECLIENT_H
