c###noisy.for
      SUBROUTINE NOISY (KJ, XLA, CEG, ANOS)
C--------------------------------
C     NOISY IS A GENERAL PURPOSE ROUTINE USED TO EVALUATE A FOURIER
C     SERIES IN TWO VARIABLES.
C     KJ --- NUMBER OF FOURIER COEFFICIENT ARRAY TO BE USED
C     XLA --- GEOGRAPHIC LATITUDE, DEGREES,
C     CEG --- GEOGRAPHIC EAST LONGITUDE, DEGREES
C     ANOS --- NOISE VALUE, MEDIAN POWER DB ABOVE KTB
C     ABP --- NORMALIZING FACTORS FOR FOURIER SERIES
C     KJ = 1 TO 6 IS ATMOSPHERIC NOISE, KJ = 7 IS LAND MASS MAP AND
C     KJ = 8 IS RATIO OF F2 HEIGHT OF MAXIMUM TO SEMITHICKNESS
C
C     * NOTE - XLA, CEG, ANOS, ABP ARE NOT ALWAYS AS PREVIOUSLY DEFINED
C     FOURIER VARIABLES AND ATMOSPHERIC RADIO NOISE
C
      COMMON / TWO / F2D(16,6,6), P(29,16,8), ABP(2,9), DUD(5,12,5),
     A FAM(14,12), SYS(9,16,6), PERR(9,4,6)
      DIMENSION SX (15), ZZ (29)
      ALF = ABP (1, KJ)
      BET = ABP (2, KJ)
      IF (KJ - 8)105, 100, 105
C.....LIMITS OF FOURIER SERIES
  100 LM = 15
      LN = 10
      GO TO 110
C.....LIMITS OF FOURIER SERIES
  105 LM = 29
      LN = 15
C.....HALF ANGLE (IN RADIANS)
  110 Q = .0087266466 * CEG
C.....LONGITUDE SINES
      C1 = COS (Q)
      S1 = SIN (Q)
      SX (1) = S1
      CX = C1
      IF (LN .LT. 2) GO TO 140
      DO 115 K = 2, LN
      TX = SX (K - 1)
      SX (K) = TX * C1 + CX * S1
  115 CX = CX * C1 - TX * S1
  140 CONTINUE
      IF (LM .LT. 1) GO TO 145
C.....LONGITUDE SERIES
      DO 125 J = 1, LM
      R = 0.
      IF (LN .LT. 1) GO TO 160
      DO 120 K = 1, LN
  120 R = R + SX (K) * P (J, K, KJ)
  160 CONTINUE
  125 ZZ (J) = R + P (J, 16, KJ)
  145 CONTINUE
C.....ANGLE PLUS 90 DEGREES (IN RADIANS)
      Q = .01745329252 * (XLA + 90.)
C.....LATITUDE SERIES
      S1 = SIN (Q)
      C1 = COS (Q)
      SX (1) = S1
      CX = C1
      R = 0.
      IF (LM .LT. 1) GO TO 165
      DO 130 K = 1, LM
      R = R + SX (1) * ZZ (K)
      SS = SX (1) * C1 + CX * S1
      CX = CX * C1 - SX (1) * S1
  130 SX (1) = SS
  165 CONTINUE
C.....FINAL FOURIER SERIES EVALUATION (NOTE LINEAR NORMALIZATION)
      ANOS = R + ALF + BET * Q
      RETURN
      END
C--------------------------------
