/* vim: set ts=2 et sw=2 tw=80: */
/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

const TESTCASE_URI = TEST_BASE + "simple.html";


function test()
{
  waitForExplicitFinish();

  launchStyleEditorChrome(function(aChrome) {
    aChrome.addChromeListener({
      onEditorAdded: testEditorAdded
    });
    run(aChrome);
  });
  content.location = TESTCASE_URI;
}

function run(aChrome)
{
  is(aChrome.contentWindow.document.readyState, "complete",
     "content document is complete");

  let SEC = gChromeWindow.styleEditorChrome;
  is(SEC, aChrome, "StyleEditorChrome object exists as new window property");

  // check editors are instantiated
  is(SEC.editors.length, 2,
     "there is two StyleEditor instances managed");
  ok(SEC.editors[0].styleSheetIndex < SEC.editors[1].styleSheetIndex,
     "editors are ordered by styleSheetIndex");
}

let gEditorAddedCount = 0;
function testEditorAdded(aChrome, aEditor)
{
  if (aEditor.styleSheetIndex == 0) {
    gEditorAddedCount++;
    testFirstStyleSheetEditor(aChrome, aEditor);
  }
  if (aEditor.styleSheetIndex == 1) {
    gEditorAddedCount++;
    testSecondStyleSheetEditor(aChrome, aEditor);
  }

  if (gEditorAddedCount == 2) {
    finish();
  }
}

function testFirstStyleSheetEditor(aChrome, aEditor)
{
  // Note: the html <link> contains charset="UTF-8".
  ok(aEditor._state.text.indexOf("\u263a") >= 0,
     "stylesheet is unicode-aware.");

  //testing TESTCASE's simple.css stylesheet
  is(aEditor.styleSheetIndex, 0,
     "first stylesheet is at index 0");

  is(aEditor, aChrome.editors[0],
     "first stylesheet corresponds to StyleEditorChrome.editors[0]");

  ok(!aEditor.hasFlag("inline"),
     "first stylesheet does not have INLINE flag");

  let summary = aChrome.getSummaryElementForEditor(aEditor);
  ok(!summary.classList.contains("inline"),
     "first stylesheet UI does not have INLINE class");

  let name = summary.querySelector(".stylesheet-name > label").getAttribute("value");
  is(name, "simple.css",
     "first stylesheet's name is `simple.css`");

  let ruleCount = summary.querySelector(".stylesheet-rule-count").textContent;
  is(parseInt(ruleCount), 1,
     "first stylesheet UI shows rule count as 1");

  ok(summary.classList.contains("splitview-active"),
     "first stylesheet UI is focused/active");
}

function testSecondStyleSheetEditor(aChrome, aEditor)
{
  //testing TESTCASE's inline stylesheet
  is(aEditor.styleSheetIndex, 1,
     "second stylesheet is at index 1");

  is(aEditor, aChrome.editors[1],
     "second stylesheet corresponds to StyleEditorChrome.editors[1]");

  ok(aEditor.hasFlag("inline"),
     "second stylesheet has INLINE flag");

  let summary = aChrome.getSummaryElementForEditor(aEditor);
  ok(summary.classList.contains("inline"),
     "second stylesheet UI has INLINE class");

  let name = summary.querySelector(".stylesheet-name > label").getAttribute("value");
  ok(/^<.*>$/.test(name),
     "second stylesheet's name is surrounded by `<>`");

  let ruleCount = summary.querySelector(".stylesheet-rule-count").textContent;
  is(parseInt(ruleCount), 3,
     "second stylesheet UI shows rule count as 3");

  ok(!summary.classList.contains("splitview-active"),
     "second stylesheet UI is NOT focused/active");
}
