;;; liece-config.el --- Installation settings.
;; Copyright (C) 1999 Daiki Ueno

;; Author: Daiki Ueno <ueno@unixuser.org>
;; Created: 1999-04-12
;; Revised: 1999-04-12
;; Keywords: IRC, liece, APEL

;; This file is part of Liece.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.


;;; Commentary:
;; 

;;; Code:

(setq load-path (cons (expand-file-name "../apel") load-path))

(defvar default-load-path load-path)

(and (expand-file-name "../../site-lisp/apel" data-directory)
     (setq load-path (cons
		      (expand-file-name "../../site-lisp/apel" data-directory)
		      load-path )))

(when (and (boundp 'LISPDIR) LISPDIR)
  (or (member LISPDIR default-load-path)
      (setq default-load-path (cons LISPDIR default-load-path)) )
  (or (member LISPDIR load-path) (setq load-path (cons LISPDIR load-path)))
  (or (member (expand-file-name "apel" LISPDIR) load-path)
      (setq load-path (cons (expand-file-name "apel" LISPDIR) load-path))))

(setq load-path (cons (expand-file-name ".") load-path))

(defvar VERSION_SPECIFIC_LISPDIR nil)
(if (and VERSION_SPECIFIC_LISPDIR
	 (null (member VERSION_SPECIFIC_LISPDIR load-path)) )
    (setq load-path (cons VERSION_SPECIFIC_LISPDIR load-path)) )

(require 'install)


;;; @ Please specify prefix of install directory.
;;;

;; Please specify install path prefix.
;; If it is omitted, shared directory (maybe /usr/local is used).
(defvar PREFIX install-prefix)
;;(setq PREFIX "~/")



;;; @ optional settings
;;;

(defvar VERSION_SPECIFIC_LISPDIR
  (install-detect-elisp-directory PREFIX nil 'version-specific))

;; It is generated by automatically. Please set variable `PREFIX'.
;; If you don't like default directory tree, please set it.
(defvar LISPDIR (install-detect-elisp-directory PREFIX))
;; (setq install-default-elisp-directory "~/lib/emacs/lisp")

(defvar PACKAGEDIR
  (if (boundp 'early-packages)
      (let ((dirs (append (if early-package-load-path
			      early-packages)
			  (if late-package-load-path
			      late-packages)
			  (if last-package-load-path
			      last-packages)))
	    dir)
	(while (and dirs (not (file-exists-p (setq dir (car dirs)))))
	  (setq dirs (cdr dirs)) )
	dir )))

(defconst liece-config-info-file-regexp
  (concat "^liece-faq\\.info\\(-[0-9]+\\)?$"))

;;; liece-config.el ends here
