#!/usr/bin/perl

# This cushion helps oggdec out because it's command-line tagging options do not like
# funky characters (such as the '' ("ae") character).  However vorbiscomment -does-
# work, if given the -R switch.  Both tools default to replacing your funky characters
# with a '#' (pound) character.
#
# You need a line in your ~/.yaretrc file like this:
# command my_ogg="oggdec_vorbiscomment_cushion.pl FILE_IN FILE_OUT QUALITY TRACK ALBUM TRACKNUM ARTIST GENRE YEAR"

if( @ARGV != 9 ) {
	print "You must specify all of the fields in this order to run this command:\n\n";
	print "input_filename, output_filename, quality, track, album, track_number,\n";
	print "artist, genre and year.\n";
	exit 1;
}

($fin, $fout, $qual, $track,
 $album, $tracknum, $artist, $genre, $year) = @ARGV;
system "oggenc", "-q", $qual, "-o", $fout, $fin;
unless ($?) {
  $fout =~ s/\'/\'\\\'\'/g;
  system "vorbiscomment -R -w '$fout' <<EOF
title=$track
album=$album
artist=$artist
tracknumber=$tracknum
gerne=$genre
year=$year
EOF";
	exit 0;
}

exit 2;

