/* Generated by re2j 0.13.6.dev on Sun Jul 26 12:04:22 2009 */
package org.yecht;

import java.io.IOException;

// Equivalent to token.re
public class TokenScanner implements DefaultYAMLParser.yyInput {
   public final static int QUOTELEN = 1024;
   private Parser parser;

   private Object lval;
   private int currentToken = -1;

   public static void error(String msg, Parser parser) {
       if(parser.error_handler == null) {
           parser.error_handler = new ErrorHandler.Default();
       }
       parser.root = parser.root_on_error;
       parser.error_handler.handle(parser, msg);
   }

   public static DefaultYAMLParser.yyInput createScanner(Parser parser) {
     switch(parser.input_type) {
       case YAML_UTF8:
         return new TokenScanner(parser);
       case Bytecode_UTF8:
         return new BytecodeScanner(parser);
       case YAML_UTF16:
         error("UTF-16 is not currently supported in Yecht.\nPlease contribute code to help this happen!", parser);
         return null;
       case YAML_UTF32:
         error("UTF-32 is not currently supported in Yecht.\nPlease contribute code to help this happen!", parser);
         return null;
     }
     return null;
   }

   public TokenScanner(Parser parser) {
     this.parser = parser;
   }

   public Object value() {
     return lval;
   }

   public int token() {
     return currentToken;
   }

   public boolean advance() throws java.io.IOException {
     currentToken = real_yylex();
     return currentToken == 0 ? false : true;
   }

   private int isNewline(int ptr) {
     return newlineLen(ptr);
   }

   private int newlineLen(int ptr) {
     if(parser.buffer.buffer[ptr] == '\n')
       return 1;

     if(parser.buffer.buffer[ptr] == '\r' && parser.buffer.buffer[ptr+1] == '\n')
       return 2;
       
     return 0;
   }

   private int isNewline(byte[] buff, int ptr) {
     return newlineLen(buff, ptr);
   }

   private int newlineLen(byte[] buff, int ptr) {
     if(buff[ptr] == '\n')
       return 1;

     if(buff[ptr] == '\r' && buff[ptr+1] == '\n')
       return 2;
       
     return 0;
   }

   private void NEWLINE(int ptr) {
     parser.lineptr = ptr + newlineLen(ptr);
     if(parser.lineptr > parser.linectptr) {
       parser.linect++;
       parser.linectptr = parser.lineptr;
     }
   }

   private void RETURN_YAML_BLOCK(QuotedString q, int blockType, int nlDoWhat) {
       Node n = Node.allocStr();
       if(parser.taguri_expansion) {
           n.type_id = Parser.taguri(YAML.DOMAIN, "str");
       } else {
           n.type_id = "str";
       }

       Data.Str dd = (Data.Str)n.data;
       dd.ptr = Pointer.create(q.str, 0);
       dd.len = q.idx;
       if(blockType == YAML.BLOCK_LIT) {
           dd.style = ScalarStyle.Literal;
       } else {
           dd.style = ScalarStyle.Fold;
       }
       if(q.idx > 0) {
           if(nlDoWhat != YAML.NL_KEEP) {
               int fc = dd.len - 1;
               while(isNewline(dd.ptr.buffer, fc) > 0) {
                   fc--;
               }
               if(nlDoWhat != YAML.NL_CHOMP && fc < (dd.len-1)) {
                   fc += 1;
               }
               dd.len = fc + 1;
           }
       }
       lval = n;
   }

   private int GET_TRUE_YAML_INDENT() {
       Level lvl_deep = parser.currentLevel();
       int indt_len = lvl_deep.spaces;
       if(lvl_deep.status == LevelStatus.seq || (indt_len == parser.cursor - parser.lineptr && lvl_deep.status != LevelStatus.map)) {
            parser.lvl_idx--;
            Level lvl_over = parser.currentLevel();
            indt_len = lvl_over.spaces;
            parser.lvl_idx++;
        }

        return indt_len;       
   }
   
   public final static String[] tnames = new String[269];
   static {
       tnames[0] = "ENDINPUT";
       tnames[256] = "error";
       tnames[44] = "COMMA";
       tnames[45] = "DASH";
       tnames[58] = "COLON";
       tnames[63] = "QUESTION";
       tnames[91] = "SQUAREO";
       tnames[93] = "SQUAREC";
       tnames[123] = "CURLYO";
       tnames[125] = "CURLYC";
       tnames[257] = "ANCHOR";
       tnames[258] = "ALIAS";
       tnames[264] = "BLOCK";
       tnames[265] = "DOCSEP";
       tnames[268] = "IEND";
       tnames[267] = "INDENT";
       tnames[266] = "IOPEN";
       tnames[261] = "ITRANSFER";
       tnames[263] = "PLAIN";
       tnames[260] = "TAGURI";
       tnames[259] = "TRANSFER";
       tnames[262] = "WORD";
   }

   private void YYPOS(int n) {
       parser.cursor = parser.token + n;
   }

   private static class QuotedString {
       public int idx = 0;
       public int capa = 100;
       public byte[] str;

       public QuotedString() {
           str = new byte[100];
       }

       public void cat(char l) {
           cat((byte)l);
       }
      
       public void cat(byte l) {
           if(idx + 1 >= capa) {
               capa += QUOTELEN;
               str = YAML.realloc(str, capa);
           }
           str[idx++] = l;
           str[idx] = 0;
       }

       public void cat(byte[] l, int cs, int cl) {
           while(idx + cl >= capa) {
               capa += QUOTELEN;
               str = YAML.realloc(str, capa);
           }
           System.arraycopy(l, cs, str, idx, cl);
           idx += cl;
           str[idx] = 0;
       }

       public void plain_is_inl() {
           int walker = idx - 1;
           while(walker > 0 && (str[walker] == '\n' || str[walker] == ' ' || str[walker] == '\t')) {
               idx--;
               str[walker] = 0;
               walker--;
          }
       }
   }

   public void RETURN_IMPLICIT(QuotedString q) {
       Node n = Node.allocStr();
       parser.cursor = parser.token;
       Data.Str dd = (Data.Str)n.data;
       dd.ptr = Pointer.create(q.str, 0);
       dd.len = q.idx;
       dd.style = ScalarStyle.Plain;                            
       lval = n;
       if(parser.implicit_typing) {
           ImplicitScanner2.tryTagImplicit(n, parser.taguri_expansion);
       }
   }

    private int real_yylex() throws IOException {
        if(parser.cursor == -1) {
            parser.read();
        }

//     System.err.println("real_yylex(" + new String(parser.buffer.buffer, parser.buffer.start, parser.bufsize) + ")");
//        System.out.println("real_yylex()");
        if(parser.force_token != 0) {
            int t = parser.force_token;
            parser.force_token = 0;
            return t;
        }



        if(parser.lineptr != parser.cursor) {
            return document(0);
        } else {
            return header();
        }
    }

    private int header() throws java.io.IOException {
//        System.out.println("header()");
        Level lvl;
        int doc_level = 0;
        while(true) {
            parser.token = parser.cursor;

        int gotoPoint = -1;
        byte yych = (byte) 0;
        int yyaccept = 0;
        gotoNext: while(gotoPoint != -2) {
            int currentGoto = gotoPoint; gotoPoint = -2;
            switch(currentGoto) {
            case -1: 

                if ((parser.limit - parser.cursor) < 5) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case 0x00:    {gotoPoint = 7; continue gotoNext;}
                case '\t':
                case ' ':    {gotoPoint = 12; continue gotoNext;}
                case '\n':    {gotoPoint = 9; continue gotoNext;}
                case '\r':    {gotoPoint = 11; continue gotoNext;}
                case '#':    {gotoPoint = 5; continue gotoNext;}
                case '-':    {gotoPoint = 2; continue gotoNext;}
                case '.':    {gotoPoint = 4; continue gotoNext;}
                default:    {gotoPoint = 14; continue gotoNext;}
                }
            case 2:
                yyaccept = 0;
                yych = parser.buffer.buffer[(parser.marker = ++parser.cursor)];
                switch (yych) {
                case '-':    {gotoPoint = 28; continue gotoNext;}
                default:    {gotoPoint = 3; continue gotoNext;}
                }
            case 3:
                {   YYPOS(0);
                        return document(doc_level);
                    }
            case 4:
                yyaccept = 0;
                yych = parser.buffer.buffer[(parser.marker = ++parser.cursor)];
                switch (yych) {
                case '.':    {gotoPoint = 21; continue gotoNext;}
                default:    {gotoPoint = 3; continue gotoNext;}
                }
            case 5:
                ++parser.cursor;
                {   
                        eatComments(); 
                        break;
                    }
            case 7:
                ++parser.cursor;
                {   lvl = parser.currentLevel();
                        if(lvl.spaces > -1) {
                            parser.popLevel();
                            YYPOS(0);
                            return DefaultYAMLParser.YAML_IEND;
                        }
                        YYPOS(0);
                        return 0; 
                    }
            case 9:
                yyaccept = 1;
                yych = parser.buffer.buffer[(parser.marker = ++parser.cursor)];
                {gotoPoint = 18; continue gotoNext;}
            case 10:
                {
                        int indent = parser.token;
                        NEWLINE(indent);
                        while(indent < parser.cursor) {
                            // these pieces commented out to be compatible with Syck 0.60. 
//                          if(parser.buffer.buffer[indent] == '\t') {
//                            error("TAB found in your indentation, please remove",parser);
//                          } else if(isNewline(++indent) != 0) {
//                            NEWLINE(indent);
//                          }

                          if(isNewline(++indent) != 0) {
                            NEWLINE(indent);
                          }
                        }
                        doc_level = 0;
                        if(parser.buffer.buffer[parser.cursor] == 0) {
                          doc_level = -1;
                          parser.token = parser.cursor-1;
                        } else if(parser.buffer.buffer[parser.lineptr] == ' ') {
                          doc_level = parser.cursor - parser.lineptr;
                        }
                        break;
                    }
            case 11:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '\n':    {gotoPoint = 17; continue gotoNext;}
                default:    {gotoPoint = 3; continue gotoNext;}
                }
            case 12:
                ++parser.cursor;
                yych = parser.buffer.buffer[parser.cursor];
                {gotoPoint = 16; continue gotoNext;}
            case 13:
                {   doc_level = parser.cursor - parser.lineptr;
                        break;
                    }
            case 14:
                yych = parser.buffer.buffer[++parser.cursor];
                {gotoPoint = 3; continue gotoNext;}
            case 15:
                ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
            case 16:
                switch (yych) {
                case '\t':
                case ' ':    {gotoPoint = 15; continue gotoNext;}
                default:    {gotoPoint = 13; continue gotoNext;}
                }
            case 17:
                yyaccept = 1;
                parser.marker = ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
            case 18:
                switch (yych) {
                case '\n':
                case ' ':    {gotoPoint = 17; continue gotoNext;}
                case '\r':    {gotoPoint = 19; continue gotoNext;}
                default:    {gotoPoint = 10; continue gotoNext;}
                }
            case 19:
                ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case '\n':    {gotoPoint = 17; continue gotoNext;}
                default:    {gotoPoint = 20; continue gotoNext;}
                }
            case 20:
                parser.cursor = parser.marker;
                if (yyaccept == 0) {
                    {gotoPoint = 3; continue gotoNext;}
                } else {
                    {gotoPoint = 10; continue gotoNext;}
                }
            case 21:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '.':    {gotoPoint = 22; continue gotoNext;}
                default:    {gotoPoint = 20; continue gotoNext;}
                }
            case 22:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '\n':    {gotoPoint = 23; continue gotoNext;}
                case '\r':    {gotoPoint = 27; continue gotoNext;}
                case ' ':    {gotoPoint = 25; continue gotoNext;}
                default:    {gotoPoint = 20; continue gotoNext;}
                }
            case 23:
                ++parser.cursor;
            case 24:
                {   lvl = parser.currentLevel();
                        if(lvl.status != LevelStatus.header) {
                          if(lvl.spaces > -1) {
                            parser.popLevel();
                            YYPOS(0);
                            return DefaultYAMLParser.YAML_IEND;
                          }
                          YYPOS(0);
                          return 0; 
                        }
                        break;
                    }
            case 25:
                ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case ' ':    {gotoPoint = 25; continue gotoNext;}
                default:    {gotoPoint = 24; continue gotoNext;}
                }
            case 27:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '\n':    {gotoPoint = 23; continue gotoNext;}
                default:    {gotoPoint = 20; continue gotoNext;}
                }
            case 28:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '-':    {gotoPoint = 29; continue gotoNext;}
                default:    {gotoPoint = 20; continue gotoNext;}
                }
            case 29:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '\n':    {gotoPoint = 30; continue gotoNext;}
                case '\r':    {gotoPoint = 34; continue gotoNext;}
                case ' ':    {gotoPoint = 32; continue gotoNext;}
                default:    {gotoPoint = 20; continue gotoNext;}
                }
            case 30:
                ++parser.cursor;
            case 31:
                { lvl = parser.currentLevel();
                      if(lvl.status == LevelStatus.header) {
                          YYPOS(3);
                          return directive();
                      } else {
                          if(lvl.spaces > -1) {
                              parser.popLevel();
                              YYPOS(0);
                              return DefaultYAMLParser.YAML_IEND;
                          }
                          YYPOS(0);
                          return 0;
                      }
                    }
            case 32:
                ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case ' ':    {gotoPoint = 32; continue gotoNext;}
                default:    {gotoPoint = 31; continue gotoNext;}
                }
            case 34:
                ++parser.cursor;
                switch ((yych = parser.buffer.buffer[parser.cursor])) {
                case '\n':    {gotoPoint = 30; continue gotoNext;}
                default:    {gotoPoint = 20; continue gotoNext;}
                }
            }
        }

        }
    }

    private final static boolean[] YWORDC = new boolean[256];
    private final static boolean[] DIGIT_OR_SIGN = new boolean[256];
    static {
        for(char c = 'a'; c<='z'; c++) {
            YWORDC[c] = true;
        }
        for(char c = 'A'; c<='Z'; c++) {
            YWORDC[c] = true;
        }
        for(char c = '0'; c<='9'; c++) {
            YWORDC[c] = true;
            DIGIT_OR_SIGN[c] = true;
        }
        YWORDC['_'] = true;
        YWORDC['-'] = true;
        DIGIT_OR_SIGN['-'] = true;
        DIGIT_OR_SIGN['+'] = true;
    }

    // (SPC | LF)*
    private void spcOrLfStar() throws IOException {
        byte ych;
        while(true) {
            if(parser.cursor+3 >= parser.limit) parser.read();
            ych = parser.buffer.buffer[parser.cursor];
            switch(ych) {
            case ' ':
            case '\n':
              parser.cursor++;
              break;
            case '\r':
              if(parser.buffer.buffer[parser.cursor+1] == '\n') {
                  parser.cursor+=2;
                  break;
              } else {
                  return;
              }
            default:
              return;            
            }
        }
    }

    // YWORDC+
    private boolean ywordc() throws IOException {
        if(!YWORDC[parser.buffer.buffer[parser.cursor] & 0xFF]) return false;
        parser.cursor++;
        while(true) {
            if(parser.cursor == parser.limit) parser.read();
            if(!YWORDC[parser.buffer.buffer[parser.cursor] & 0xFF]) return true;
            parser.cursor++;
        }
    }

    // ( SPC+ | LF )
    private boolean endspc() throws IOException {
        byte ych = parser.buffer.buffer[parser.cursor];
        switch(ych) {
        case ' ':
          parser.cursor++;
          while(true) {
              if(parser.cursor == parser.limit) parser.read();
              if(parser.buffer.buffer[parser.cursor] != ' ') return true;
              parser.cursor++;
          }
        case '\r':
          if(parser.buffer.buffer[parser.cursor+1] != '\n') {
              return false;
          }
          parser.cursor++;
        case '\n':
          parser.cursor++;
          return true;
        default:
          return false;
        } 
    }

    // [-+0-9]* ENDSPC
    private boolean yblock() throws IOException {
        int plus = 0;
        int ych = parser.buffer.buffer[parser.cursor + plus] & 0xFF;
        while(DIGIT_OR_SIGN[ych]) {
            plus++;
            if((parser.limit - parser.cursor) < plus) parser.read();
            ych = parser.buffer.buffer[parser.cursor + plus] & 0xFF;
        }        

        switch(ych) {
        case ' ':
          plus++;
          while(true) {
              if((parser.limit - parser.cursor) < plus) parser.read();
              if(parser.buffer.buffer[parser.cursor + plus] != ' ') {
                  parser.cursor += plus;
                  return true;
              }
              plus++;
          }
        case '\r':
          if(parser.buffer.buffer[parser.cursor+plus+1] != '\n') {
              return false;
          }
          plus++;
        case '\n':
          plus++;
          parser.cursor += plus;
          return true;
        default:
          return false;
        } 
    }

    private int document(int doc_level) throws java.io.IOException {
//        System.out.println("document()");
        boolean do_any = false;

        while(true) {
            Level lvl = parser.currentLevel();
            if(lvl.status == LevelStatus.header) {
                lvl.status = LevelStatus.doc;
            }

            parser.token = parser.cursor;

            if ((parser.limit - parser.cursor) < 3) parser.read();
            byte yych = parser.buffer.buffer[parser.cursor];

            switch (yych) {
            case 0x00:
                parser.cursor++;
                if(lvl.spaces > -1) {
                    parser.popLevel();
                    YYPOS(0);
                    return DefaultYAMLParser.YAML_IEND;
                }
                YYPOS(0);
                return 0; 
            case '\t':
            case ' ':
                parser.cursor++;
                while((yych = parser.buffer.buffer[parser.cursor]) == '\t' || yych == ' ') {
                    parser.cursor++;
                    if(parser.cursor == parser.limit) parser.read();
                }
                break;
            case '\r':
                if(parser.buffer.buffer[parser.cursor+1] != '\n') {
                    do_any = true;
                    break;
                } else {
                    parser.cursor++;
                }
            case '\n':
                parser.cursor++;
                spcOrLfStar();
                        /* Isolate spaces */
                        int indt_len;
                        int indent = parser.token;
                        NEWLINE(indent);
                        while(indent < parser.cursor) {
                            // these pieces commented out to be compatible with Syck 0.60. 
//                          if(parser.buffer.buffer[indent] == '\t') {
//                            error("TAB found in your indentation, please remove",parser);
//                          } else if(isNewline(++indent) != 0) {
//                            NEWLINE(indent);
//                          }

                          if(isNewline(++indent) != 0) {
                            NEWLINE(indent);
                          }
                        }
                        indt_len = 0;
                        if(parser.buffer.buffer[parser.cursor] == 0) {
                          indt_len = -1;
                          parser.token = parser.cursor-1;
                        } else if(parser.buffer.buffer[parser.lineptr] == ' ') {
                          indt_len = parser.cursor - parser.lineptr;
                        }

                        lvl = parser.currentLevel();
                        doc_level = 0;

                        /* XXX: Comment lookahead */
                        /* Ignore indentation inside inlines */
                        if(parser.buffer.buffer[parser.cursor] != '#' && lvl.status != LevelStatus.iseq && lvl.status != LevelStatus.imap) {
                            /* Check for open indent */
                            if(lvl.spaces > indt_len) {
                                parser.popLevel();
                                YYPOS(0);
                                return DefaultYAMLParser.YAML_IEND;
                            }
                            if(lvl.spaces < indt_len) {
                                if(lvl.status != LevelStatus.iseq && lvl.status != LevelStatus.imap) {
                                    parser.addLevel(indt_len, LevelStatus.doc);
                                    return DefaultYAMLParser.YAML_IOPEN;
                                }
                            } else {
                                if(indt_len == -1) {
                                    return 0;
                                }
                                return DefaultYAMLParser.YAML_INDENT;
                            }
                        }
                        break;

            case '!': 
                parser.cursor++;
                return transferMethod();
            case '"':
                parser.cursor++;
                if(lvl.spaces < doc_level) {
                    if(lvl.status != LevelStatus.iseq && lvl.status != LevelStatus.imap) {
                        parser.addLevel(doc_level, LevelStatus.doc);
                        YYPOS(0);
                        return DefaultYAMLParser.YAML_IOPEN;
                    }
                } else {
                    return doubleQuote();
                }
                break;
            case '#':
                parser.cursor++;
                eatComments(); 
                break;
            case '&':
                parser.cursor++;
                if(ywordc()) {
                    lval = new String(parser.buffer.buffer, parser.token + 1, parser.cursor - (parser.token + 1), "ISO-8859-1");

                    /*
                     * Remove previous anchors of the same name.  Since the parser will likely
                     * construct deeper nodes first, we want those nodes to be placed in the
                     * queue for matching at a higher level of indentation.
                     */
                    parser.removeAnchor((String)lval);
                    return DefaultYAMLParser.YAML_ANCHOR;
                } else {
                    parser.cursor--;
                    do_any = true;
                    break;
                }
            case '\'':
                parser.cursor++;
                if(lvl.spaces < doc_level) {
                    if(lvl.status != LevelStatus.iseq && lvl.status != LevelStatus.imap) {
                        parser.addLevel(doc_level, LevelStatus.doc);
                        YYPOS(0);
                        return DefaultYAMLParser.YAML_IOPEN;
                    }
                } else {
                    return singleQuote(); 
                }
                break;
            case '*':
                parser.cursor++;
                if(ywordc()) {
                    if(lvl.spaces < doc_level) {
                        if(lvl.status != LevelStatus.iseq && lvl.status != LevelStatus.imap) {
                            parser.addLevel(doc_level, LevelStatus.doc);
                            YYPOS(0);
                            return DefaultYAMLParser.YAML_IOPEN;
                        }
                    } else {
                        lval = new String(parser.buffer.buffer, parser.token + 1, parser.cursor - (parser.token + 1), "ISO-8859-1");
                        return DefaultYAMLParser.YAML_ALIAS;
                    }
                } else {
                    parser.cursor--;
                    do_any = true;
                }
                break;
            case ',':
            case ':':
                parser.cursor++;
                if(endspc()) {
                    if( parser.buffer.buffer[parser.token] == ':' && lvl.status != LevelStatus.imap && lvl.status != LevelStatus.iseq ) {
                        lvl.status = LevelStatus.map;
                    }
                    YYPOS(1); 
                    return parser.buffer.buffer[parser.token];
                } else {
                    parser.cursor--;
                    do_any = true;
                    break;
                }
            case '-':
            case '?':
                parser.cursor++;
                if(endspc()) {
                    if(lvl.spaces < (parser.token - parser.lineptr)) {
                        if(lvl.status != LevelStatus.iseq && lvl.status != LevelStatus.imap) {
                            parser.addLevel((parser.token - parser.lineptr), LevelStatus.doc);
                            YYPOS(0);
                            return DefaultYAMLParser.YAML_IOPEN;
                        }
                    } else {
                        parser.force_token = DefaultYAMLParser.YAML_IOPEN;
                        if( parser.buffer.buffer[parser.cursor] == '#' || isNewline(parser.cursor) != 0 || isNewline(parser.cursor-1) != 0) {
                            parser.cursor--;
                            parser.addLevel(parser.token + 1 - parser.lineptr, LevelStatus.seq);
                        } else /* spaces followed by content uses the space as indentation */
                        {
                            parser.addLevel(parser.cursor - parser.lineptr, LevelStatus.seq);
                        }
                        return parser.buffer.buffer[parser.token];
                    }
                } else {
                    parser.cursor--;
                    do_any = true;
                }
                break;
            case '>':
            case '|':
                parser.cursor++;
                if(yblock()) {
                    if(isNewline(parser.cursor - 1) != 0) {
                        parser.cursor--;
                    }
                    return scalarBlock();
                } else {
                    parser.cursor--;
                    do_any = true;
                }
                break;
            case '[':
                parser.cursor++;
                if(lvl.spaces < doc_level) {
                    if(lvl.status != LevelStatus.iseq && lvl.status != LevelStatus.imap) {
                        parser.addLevel(doc_level, LevelStatus.doc);
                        YYPOS(0);
                        return DefaultYAMLParser.YAML_IOPEN;
                    }
                } else {
                    lvl = parser.currentLevel();
                    parser.addLevel(lvl.spaces + 1, LevelStatus.iseq);
                    return parser.buffer.buffer[parser.token];
                }
                break;                    
            case ']':
            case '}':
                parser.cursor++;
                parser.popLevel();
                return parser.buffer.buffer[parser.token];
            case '{':
                parser.cursor++;
                if(lvl.spaces < doc_level) {
                    if(lvl.status != LevelStatus.iseq && lvl.status != LevelStatus.imap) {
                        parser.addLevel(doc_level, LevelStatus.doc);
                        YYPOS(0);
                        return DefaultYAMLParser.YAML_IOPEN;
                    }
                } else {
                    lvl = parser.currentLevel();
                    parser.addLevel(lvl.spaces + 1, LevelStatus.imap);
                    return parser.buffer.buffer[parser.token];
                }
                break;
            default:
                do_any = true;
                break;
            }

            if(do_any) {
                if(lvl.spaces < doc_level) {
                    if(lvl.status != LevelStatus.iseq && lvl.status != LevelStatus.imap) {
                        parser.addLevel(doc_level, LevelStatus.doc);
                        YYPOS(0);
                        return DefaultYAMLParser.YAML_IOPEN;
                    }
                } else {
                    return plain();
                }
                do_any = false;
            }
        }
    }


   private int directive() throws java.io.IOException {
//        System.out.println("directive()");
       while(true) {
           parser.toktmp = parser.cursor;

        int gotoPoint = -1;
        byte yych = (byte) 0;
        gotoNext: while(gotoPoint != -2) {
            int currentGoto = gotoPoint; gotoPoint = -2;
            switch(currentGoto) {
            case -1: 
                if ((parser.limit - parser.cursor) < 2) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case 0x00:    {gotoPoint = 37; continue gotoNext;}
                case '\t':
                case ' ':    {gotoPoint = 40; continue gotoNext;}
                case '%':    {gotoPoint = 38; continue gotoNext;}
                default:    {gotoPoint = 42; continue gotoNext;}
                }
            case 37:
                parser.cursor = parser.marker;
                {gotoPoint = 39; continue gotoNext;}
            case 38:
                yych = parser.buffer.buffer[(parser.marker = ++parser.cursor)];
                switch (yych) {
                case '.':
                case '/':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case ':':
                case ';':
                case '<':
                case '=':
                case '>':
                case '?':
                case '@':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '[':
                case '\\':
                case ']':
                case '^':
                case '_':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':    {gotoPoint = 45; continue gotoNext;}
                default:    {gotoPoint = 39; continue gotoNext;}
                }
            case 39:
                {   parser.cursor = parser.toktmp;
                        return DefaultYAMLParser.YAML_DOCSEP;
                    }
            case 40:
                ++parser.cursor;
                yych = parser.buffer.buffer[parser.cursor];
                {gotoPoint = 44; continue gotoNext;}
            case 41:
                {  break; }
            case 42:
                yych = parser.buffer.buffer[++parser.cursor];
                {gotoPoint = 39; continue gotoNext;}
            case 43:
                ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
            case 44:
                switch (yych) {
                case '\t':
                case ' ':    {gotoPoint = 43; continue gotoNext;}
                default:    {gotoPoint = 41; continue gotoNext;}
                }
            case 45:
                ++parser.cursor;
                if ((parser.limit - parser.cursor) < 2) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case '.':
                case '/':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case ';':
                case '<':
                case '=':
                case '>':
                case '?':
                case '@':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '[':
                case '\\':
                case ']':
                case '^':
                case '_':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':    {gotoPoint = 45; continue gotoNext;}
                case ':':    {gotoPoint = 47; continue gotoNext;}
                default:    {gotoPoint = 37; continue gotoNext;}
                }
            case 47:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '.':
                case '/':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case ':':
                case ';':
                case '<':
                case '=':
                case '>':
                case '?':
                case '@':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '[':
                case '\\':
                case ']':
                case '^':
                case '_':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':    {gotoPoint = 48; continue gotoNext;}
                default:    {gotoPoint = 37; continue gotoNext;}
                }
            case 48:
                ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case '.':
                case '/':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case ':':
                case ';':
                case '<':
                case '=':
                case '>':
                case '?':
                case '@':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '[':
                case '\\':
                case ']':
                case '^':
                case '_':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':    {gotoPoint = 48; continue gotoNext;}
                default:    {gotoPoint = 50; continue gotoNext;}
                }
            case 50:
                {  break; }
            }
        }

       }
   }

   private int getAndCheckIndentLength() {
       int indt_len;
       int indent = parser.token;
       NEWLINE(indent);
       while(indent < parser.cursor) {
                            // these pieces commented out to be compatible with Syck 0.60. 
//                          if(parser.buffer.buffer[indent] == '\t') {
//                            error("TAB found in your indentation, please remove",parser);
//                          } else if(isNewline(++indent) != 0) {
//                            NEWLINE(indent);
//                          }

           if(isNewline(++indent) != 0) {
               NEWLINE(indent);
           }
       }
       indt_len = 0;
       if(parser.buffer.buffer[parser.cursor] == 0) {
           indt_len = -1;
       } else if(parser.buffer.buffer[parser.lineptr] == ' ') {
           indt_len = parser.cursor - parser.lineptr;
       }

       return indt_len;
   }                 

   private void countAndAddNewlines(QuotedString q) {
       int nl_count = 0;
       while(parser.token < parser.cursor) {
           int nl_len = newlineLen(parser.token++);
           if(nl_len > 0) {
               nl_count++;
               parser.token += (nl_len - 1);
           }
       }

       if(nl_count <= 1) {
           q.cat(' ');
       } else {
           for(int i = 0; i < nl_count - 1; i++) {
               q.cat('\n');
           }
       }
   }

   private int plain() throws java.io.IOException {
//        System.out.println("plain()");
       QuotedString q = new QuotedString();

       parser.cursor = parser.token;
       Level plvl = parser.currentLevel();

       Level lvl_deep = parser.currentLevel();
       int parentIndent = lvl_deep.spaces;
       if(lvl_deep.status == LevelStatus.seq || ((parentIndent == parser.cursor - parser.lineptr) && lvl_deep.status != LevelStatus.map)) {
           parser.lvl_idx--;
           Level lvl_over = parser.currentLevel();
           parentIndent = lvl_over.spaces;
           parser.lvl_idx++;
       }

       boolean plain3 = false;
       boolean do_any = false;

       while(true) {
           parser.token = parser.cursor;
           do {
               plain3 = false;

               if ((parser.limit - parser.cursor) < 3) parser.read();
               byte yych = parser.buffer.buffer[parser.cursor];
               switch(yych) {
               // YINDENT
               case '\r':
                   if(parser.buffer.buffer[parser.cursor+1] != '\n') {
                       do_any = true;
                       break;
                   } else {
                       parser.cursor++;
                   }
               case '\n':
                   parser.cursor++;
                   spcOrLfStar();
                   int indt_len = getAndCheckIndentLength();
                   if(indt_len <= parentIndent) {
                       RETURN_IMPLICIT(q);
                       return DefaultYAMLParser.YAML_PLAIN;
                   }

                   countAndAddNewlines(q);
                   break;

               case 0x00:
                   parser.cursor++;
                   RETURN_IMPLICIT(q);
                   return DefaultYAMLParser.YAML_PLAIN;

               case ' ':
                   if(parser.buffer.buffer[parser.cursor+1] == '#') {
                       parser.cursor+=2;
                       eatComments(); 
                       RETURN_IMPLICIT(q);
                       return DefaultYAMLParser.YAML_PLAIN;
                   }
               case '\t':
                   parser.cursor++;
                   if(q.idx != 0) {
                       plain3 = true;
                   }
                   break;
               case '}':
                   parser.cursor++;
                        if(plvl.status != LevelStatus.imap) {
                            // PLAIN_NOT_INL
                            if(parser.buffer.buffer[parser.cursor-1] == ' ' || isNewline(parser.cursor-1) > 0) {
                                parser.cursor--;
                            }
                            q.cat(parser.buffer.buffer, parser.token, parser.cursor - parser.token);
                        } else {
                            q.plain_is_inl();
                            RETURN_IMPLICIT(q);
                            return DefaultYAMLParser.YAML_PLAIN;
                        }
                        break;
               case ']':
                   parser.cursor++;                                                     
                        if(plvl.status != LevelStatus.iseq) {
                            // PLAIN_NOT_INL
                            if(parser.buffer.buffer[parser.cursor-1] == ' ' || isNewline(parser.cursor-1) > 0) {
                                parser.cursor--;
                            }
                            q.cat(parser.buffer.buffer, parser.token, parser.cursor - parser.token);
                        } else {
                            q.plain_is_inl();
                            RETURN_IMPLICIT(q);
                            return DefaultYAMLParser.YAML_PLAIN;
                        }
                        break;
               // ALLX
               case ':':
                   parser.cursor++;
                   if(endspc()) {
                       RETURN_IMPLICIT(q);
                       return DefaultYAMLParser.YAML_PLAIN;
                   } else {
                       parser.cursor--;
                       do_any = true;
                       break;
                   }

               // ICOMMA
               case ',':
                   parser.cursor++;
                   if(endspc()) {
                        if(plvl.status != LevelStatus.iseq && plvl.status != LevelStatus.imap) {
                            // PLAIN_NOT_INL
                            if(parser.buffer.buffer[parser.cursor-1] == ' ' || isNewline(parser.cursor-1) > 0) {
                                parser.cursor--;
                            }
                            q.cat(parser.buffer.buffer, parser.token, parser.cursor - parser.token);
                        } else {
                            q.plain_is_inl();
                            RETURN_IMPLICIT(q);
                            return DefaultYAMLParser.YAML_PLAIN;
                        }

                        break;
                   } else {
                       parser.cursor--;
                       do_any = true;
                       break;
                   }

               default:
                   do_any = true;
                   break;                   
               }

               if(do_any) {
                   parser.cursor++;
                   q.cat(parser.buffer.buffer, parser.token, parser.cursor - parser.token);
                   do_any = false;
               }
           } while(plain3);
       }
   }

   private int doubleQuote() throws java.io.IOException {
//        System.out.println("doubleQuote()");
       int keep_nl = 1;
       QuotedString q = new QuotedString();
       while(true) {
           parser.token = parser.cursor;

        int gotoPoint = -1;
        byte yych = (byte) 0;
        int yyaccept = 0;
        gotoNext: while(gotoPoint != -2) {
            int currentGoto = gotoPoint; gotoPoint = -2;
            switch(currentGoto) {
            case -1: 
                if ((parser.limit - parser.cursor) < 4) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case 0x00:    {gotoPoint = 58; continue gotoNext;}
                case '\n':    {gotoPoint = 53; continue gotoNext;}
                case '\r':    {gotoPoint = 55; continue gotoNext;}
                case '"':    {gotoPoint = 60; continue gotoNext;}
                case '\\':    {gotoPoint = 57; continue gotoNext;}
                default:    {gotoPoint = 61; continue gotoNext;}
                }
            case 53:
                yyaccept = 0;
                yych = parser.buffer.buffer[(parser.marker = ++parser.cursor)];
                {gotoPoint = 75; continue gotoNext;}
            case 54:
                {
                        // GOBBLE_UP_YAML_INDENT( indt_len, YYTOKEN )
                        int indent = parser.token;
                        NEWLINE(indent);
                        while(indent < parser.cursor) {
                            // these pieces commented out to be compatible with Syck 0.60. 
//                          if(parser.buffer.buffer[indent] == '\t') {
//                            error("TAB found in your indentation, please remove",parser);
//                          } else if(isNewline(++indent) != 0) {
//                            NEWLINE(indent);
//                          }

                          if(isNewline(++indent) != 0) {
                            NEWLINE(indent);
                          }
                        }
                        int indt_len = 0;
                        if(parser.buffer.buffer[parser.cursor] == 0) {
                          indt_len = -1;
                          parser.token = parser.cursor-1;
                        } else if(parser.buffer.buffer[parser.lineptr] == ' ') {
                          indt_len = parser.cursor - parser.lineptr;
                        }

                        int nl_count = 0;
                        Level lvl = parser.currentLevel();
                        if(lvl.status != LevelStatus.str) {
                            parser.addLevel(indt_len, LevelStatus.str);
                        } else if(indt_len < lvl.spaces) {
                            // Error!
                        }

                        if(keep_nl == 1) {
                            countAndAddNewlines(q);
                        }

                        keep_nl = 1;
                        break;
                    }
            case 55:
                ++parser.cursor;
                switch ((yych = parser.buffer.buffer[parser.cursor])) {
                case '\n':    {gotoPoint = 74; continue gotoNext;}
                default:    {gotoPoint = 56; continue gotoNext;}
                }
            case 56:
                {   q.cat(parser.buffer.buffer[parser.cursor-1]);
                        break;
                    }
            case 57:
                yyaccept = 1;
                yych = parser.buffer.buffer[(parser.marker = ++parser.cursor)];
                switch (yych) {
                case '\n':    {gotoPoint = 65; continue gotoNext;}
                case '\r':    {gotoPoint = 67; continue gotoNext;}
                case ' ':    {gotoPoint = 62; continue gotoNext;}
                case '"':
                case '0':
                case '\\':
                case 'a':
                case 'b':
                case 'e':
                case 'f':
                case 'n':
                case 'r':
                case 't':
                case 'v':    {gotoPoint = 69; continue gotoNext;}
                case 'x':    {gotoPoint = 68; continue gotoNext;}
                default:    {gotoPoint = 56; continue gotoNext;}
                }
            case 58:
                ++parser.cursor;
            case 59:
                {   
                        Node n = Node.allocStr();
                        Level lvl = parser.currentLevel();

                        if(lvl.status == LevelStatus.str) {
                            parser.popLevel();
                        }

                        if(parser.taguri_expansion) {
                            n.type_id = Parser.taguri(YAML.DOMAIN, "str");
                        } else {
                            n.type_id = "str";
                        }
                        Data.Str dd = (Data.Str)n.data;
                        dd.ptr = Pointer.create(q.str, 0);
                        dd.len = q.idx;
                        dd.style = ScalarStyle.TwoQuote;
                        lval = n;
                        return DefaultYAMLParser.YAML_PLAIN;
                    }
            case 60:
                yych = parser.buffer.buffer[++parser.cursor];
                {gotoPoint = 59; continue gotoNext;}
            case 61:
                yych = parser.buffer.buffer[++parser.cursor];
                {gotoPoint = 56; continue gotoNext;}
            case 62:
                ++parser.cursor;
                if ((parser.limit - parser.cursor) < 2) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case '\n':    {gotoPoint = 65; continue gotoNext;}
                case '\r':    {gotoPoint = 67; continue gotoNext;}
                case ' ':    {gotoPoint = 62; continue gotoNext;}
                default:    {gotoPoint = 64; continue gotoNext;}
                }
            case 64:
                parser.cursor = parser.marker;
                if (yyaccept == 0) {
                    {gotoPoint = 54; continue gotoNext;}
                } else {
                    {gotoPoint = 56; continue gotoNext;}
                }
            case 65:
                ++parser.cursor;
                {   keep_nl = 0;
                        parser.cursor--;
                        break;
                    }
            case 67:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '\n':    {gotoPoint = 65; continue gotoNext;}
                default:    {gotoPoint = 64; continue gotoNext;}
                }
            case 68:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':    {gotoPoint = 71; continue gotoNext;}
                default:    {gotoPoint = 64; continue gotoNext;}
                }
            case 69:
                ++parser.cursor;
                {   
                        byte ch = parser.buffer.buffer[parser.cursor-1];
                        q.cat(escapeSeq(ch));
                        break;
                    }
            case 71:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':    {gotoPoint = 72; continue gotoNext;}
                default:    {gotoPoint = 64; continue gotoNext;}
                }
            case 72:
                ++parser.cursor;
                {    
                        q.cat((byte)Integer.valueOf(new String(parser.buffer.buffer, parser.token+2, 2, "ISO-8859-1"), 16).intValue());
                        break;
                    }
            case 74:
                yyaccept = 0;
                parser.marker = ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
            case 75:
                switch (yych) {
                case '\n':
                case ' ':    {gotoPoint = 74; continue gotoNext;}
                case '\r':    {gotoPoint = 76; continue gotoNext;}
                default:    {gotoPoint = 54; continue gotoNext;}
                }
            case 76:
                ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case '\n':    {gotoPoint = 74; continue gotoNext;}
                default:    {gotoPoint = 64; continue gotoNext;}
                }
            }
        }

       }
   }

   private int singleQuote() throws java.io.IOException {
//        System.out.println("singleQuote()");
       QuotedString q = new QuotedString();
       while(true) {
           parser.token = parser.cursor;

        int gotoPoint = -1;
        byte yych = (byte) 0;
        gotoNext: while(gotoPoint != -2) {
            int currentGoto = gotoPoint; gotoPoint = -2;
            switch(currentGoto) {
            case -1: 
                if ((parser.limit - parser.cursor) < 2) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case 0x00:    {gotoPoint = 85; continue gotoNext;}
                case '\n':    {gotoPoint = 79; continue gotoNext;}
                case '\r':    {gotoPoint = 81; continue gotoNext;}
                case '\'':    {gotoPoint = 83; continue gotoNext;}
                default:    {gotoPoint = 86; continue gotoNext;}
                }
            case 79:
                yych = parser.buffer.buffer[(parser.marker = ++parser.cursor)];
                {gotoPoint = 90; continue gotoNext;}
            case 80:
                {
                        // GOBBLE_UP_YAML_INDENT( indt_len, YYTOKEN )
                        int indent = parser.token;
                        NEWLINE(indent);
                        while(indent < parser.cursor) {
                            // these pieces commented out to be compatible with Syck 0.60. 
//                          if(parser.buffer.buffer[indent] == '\t') {
//                            error("TAB found in your indentation, please remove",parser);
//                          } else if(isNewline(++indent) != 0) {
//                            NEWLINE(indent);
//                          }

                          if(isNewline(++indent) != 0) {
                            NEWLINE(indent);
                          }
                        }
                        int indt_len = 0;
                        if(parser.buffer.buffer[parser.cursor] == 0) {
                          indt_len = -1;
                          parser.token = parser.cursor-1;
                        } else if(parser.buffer.buffer[parser.lineptr] == ' ') {
                          indt_len = parser.cursor - parser.lineptr;
                        }

                        int nl_count = 0;
                        Level lvl = parser.currentLevel();
                        if(lvl.status != LevelStatus.str) {
                            parser.addLevel(indt_len, LevelStatus.str);
                        } else if(indt_len < lvl.spaces) {
                            // Error!
                        }

                        while(parser.token < parser.cursor) {
                          int nl_len = newlineLen(parser.token++);
                          if(nl_len > 0) {
                            nl_count++;
                            parser.token += (nl_len - 1);
                          }
                        }
                        if(nl_count <= 1) {
                            q.cat(' ');
                        } else {
                            for(int i = 0; i < nl_count - 1; i++) {
                                q.cat('\n');
                            }
                        }
                        break;
                    }
            case 81:
                ++parser.cursor;
                switch ((yych = parser.buffer.buffer[parser.cursor])) {
                case '\n':    {gotoPoint = 89; continue gotoNext;}
                default:    {gotoPoint = 82; continue gotoNext;}
                }
            case 82:
                {   q.cat(parser.buffer.buffer[parser.cursor-1]);
                        break;
                    }
            case 83:
                ++parser.cursor;
                switch ((yych = parser.buffer.buffer[parser.cursor])) {
                case '\'':    {gotoPoint = 87; continue gotoNext;}
                default:    {gotoPoint = 84; continue gotoNext;}
                }
            case 84:
                {   
                        Node n = Node.allocStr();
                        Level lvl = parser.currentLevel();
                        if(lvl.status == LevelStatus.str) {
                            parser.popLevel();
                        }
                        if(parser.taguri_expansion) {
                            n.type_id = Parser.taguri(YAML.DOMAIN, "str");
                        } else {
                            n.type_id = "str";
                        }
                        Data.Str dd = (Data.Str)n.data;
                        dd.ptr = Pointer.create(q.str, 0);
                        dd.len = q.idx;
                        dd.style = ScalarStyle.OneQuote;
                        lval = n;
                        return DefaultYAMLParser.YAML_PLAIN; 
                    }
            case 85:
                yych = parser.buffer.buffer[++parser.cursor];
                {gotoPoint = 84; continue gotoNext;}
            case 86:
                yych = parser.buffer.buffer[++parser.cursor];
                {gotoPoint = 82; continue gotoNext;}
            case 87:
                ++parser.cursor;
                {   q.cat('\'');
                        break;
                    }
            case 89:
                parser.marker = ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
            case 90:
                switch (yych) {
                case '\n':
                case ' ':    {gotoPoint = 89; continue gotoNext;}
                case '\r':    {gotoPoint = 91; continue gotoNext;}
                default:    {gotoPoint = 80; continue gotoNext;}
                }
            case 91:
                ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case '\n':    {gotoPoint = 89; continue gotoNext;}
                default:    {gotoPoint = 92; continue gotoNext;}
                }
            case 92:
                parser.cursor = parser.marker;
                {gotoPoint = 80; continue gotoNext;}
            }
        }

       }
   }

   private int transferMethod() throws java.io.IOException {
//        System.out.println("transferMethod()");
       QuotedString q = new QuotedString();
       while(true) {
           parser.toktmp = parser.cursor;

        int gotoPoint = -1;
        byte yych = (byte) 0;
        gotoNext: while(gotoPoint != -2) {
            int currentGoto = gotoPoint; gotoPoint = -2;
            switch(currentGoto) {
            case -1: 
                if ((parser.limit - parser.cursor) < 4) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case 0x00:    {gotoPoint = 95; continue gotoNext;}
                case '\n':    {gotoPoint = 97; continue gotoNext;}
                case '\r':    {gotoPoint = 99; continue gotoNext;}
                case ' ':    {gotoPoint = 98; continue gotoNext;}
                case '\\':    {gotoPoint = 101; continue gotoNext;}
                default:    {gotoPoint = 102; continue gotoNext;}
                }
            case 95:
                ++parser.cursor;
            case 96:
                {   
                        parser.cursor = parser.toktmp;
                        if(parser.cursor == parser.token + 1) {
                            return DefaultYAMLParser.YAML_ITRANSFER;
                        }

                        Level lvl = parser.currentLevel();

                        /*
                         * URL Prefixing
                         */
                        if(q.str[0] == '^') {
                            lval = lvl.domain + new String(q.str, 1, q.idx - 1, "ISO-8859-1");
                        } else {
                            int carat = 0;
                            int qend = q.idx;
                            while((++carat) < qend) {
                              if(q.str[carat] == '^') {
                                break;
                              }
                            }

                            if(carat < qend) {
                                lvl.domain = new String(q.str, 0, carat, "ISO-8859-1");
                                lval = lvl.domain + new String(q.str, carat + 1, (qend - carat) - 1, "ISO-8859-1");
                            } else {
                                lval = new String(q.str, 0, qend, "ISO-8859-1");
                            }
                        }

                        return DefaultYAMLParser.YAML_TRANSFER; 
                    }
            case 97:
                yych = parser.buffer.buffer[++parser.cursor];
                {gotoPoint = 96; continue gotoNext;}
            case 98:
                yych = parser.buffer.buffer[++parser.cursor];
                {gotoPoint = 111; continue gotoNext;}
            case 99:
                ++parser.cursor;
                switch ((yych = parser.buffer.buffer[parser.cursor])) {
                case '\n':    {gotoPoint = 95; continue gotoNext;}
                default:    {gotoPoint = 100; continue gotoNext;}
                }
            case 100:
                {   
                        q.cat(parser.buffer.buffer[parser.cursor-1]);
                        break;
                    }
            case 101:
                yych = parser.buffer.buffer[(parser.marker = ++parser.cursor)];
                switch (yych) {
                case '"':
                case '0':
                case '\\':
                case 'a':
                case 'b':
                case 'e':
                case 'f':
                case 'n':
                case 'r':
                case 't':
                case 'v':    {gotoPoint = 105; continue gotoNext;}
                case 'x':    {gotoPoint = 103; continue gotoNext;}
                default:    {gotoPoint = 100; continue gotoNext;}
                }
            case 102:
                yych = parser.buffer.buffer[++parser.cursor];
                {gotoPoint = 100; continue gotoNext;}
            case 103:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':    {gotoPoint = 107; continue gotoNext;}
                default:    {gotoPoint = 104; continue gotoNext;}
                }
            case 104:
                parser.cursor = parser.marker;
                {gotoPoint = 100; continue gotoNext;}
            case 105:
                ++parser.cursor;
                {  
                        byte ch = parser.buffer.buffer[parser.cursor-1];
                        q.cat(escapeSeq(ch));
                        break;
                    }
            case 107:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':    {gotoPoint = 108; continue gotoNext;}
                default:    {gotoPoint = 104; continue gotoNext;}
                }
            case 108:
                ++parser.cursor;
                {   
                        q.cat((byte)Integer.valueOf(new String(parser.buffer.buffer, parser.toktmp+2, 2, "ISO-8859-1"), 16).intValue());
                        break;
                    }
            case 110:
                ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
            case 111:
                switch (yych) {
                case ' ':    {gotoPoint = 110; continue gotoNext;}
                default:    {gotoPoint = 96; continue gotoNext;}
                }
            }
        }

       }
   }

   private int scalarBlock() throws java.io.IOException {
//        System.out.println("scalarBlock()");
       QuotedString q = new QuotedString();
       q.str[0] = 0;

       int lastIndent = 0;
       int parentIndent = -1;
       int blockType = 0;
       int nlDoWhat = 0;
       int forceIndent = -1;
       int yyt = parser.token;
       Level lvl = parser.currentLevel();

       switch(parser.buffer.buffer[yyt]) {
           case '|': blockType = YAML.BLOCK_LIT; break;
           case '>': blockType = YAML.BLOCK_FOLD; break;
       }

       while( ++yyt <= parser.cursor ) {
           if(parser.buffer.buffer[yyt] == '-') {
               nlDoWhat = YAML.NL_CHOMP;
           } else if(parser.buffer.buffer[yyt] == '+' ) {
               nlDoWhat = YAML.NL_KEEP;
           } else if(Character.isDigit((char)parser.buffer.buffer[yyt])) {
               forceIndent = (char)parser.buffer.buffer[yyt] - '0';
           }
       }

       while(true) {
           parser.token = parser.cursor;

        int gotoPoint = -1;
        byte yych = (byte) 0;
        int yyaccept = 0;
        gotoNext: while(gotoPoint != -2) {
            int currentGoto = gotoPoint; gotoPoint = -2;
            switch(currentGoto) {
            case -1: 
                if ((parser.limit - parser.cursor) < 5) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case 0x00:    {gotoPoint = 120; continue gotoNext;}
                case '\n':    {gotoPoint = 114; continue gotoNext;}
                case '\r':    {gotoPoint = 116; continue gotoNext;}
                case '#':    {gotoPoint = 118; continue gotoNext;}
                case '-':    {gotoPoint = 122; continue gotoNext;}
                default:    {gotoPoint = 123; continue gotoNext;}
                }
            case 114:
                yyaccept = 0;
                yych = parser.buffer.buffer[(parser.marker = ++parser.cursor)];
                {gotoPoint = 133; continue gotoNext;}
            case 115:
                {   
                        int tok = parser.token;
                        int nl_count = 0, fold_nl = 0, nl_begin = 0;
                        int indt_len = getAndCheckIndentLength();

                        lvl = parser.currentLevel();
                        if(lvl.status != LevelStatus.block) {
                            parentIndent = GET_TRUE_YAML_INDENT();
                            if(forceIndent > 0) forceIndent += parentIndent;
                            if(indt_len > parentIndent) {
                                int new_spaces = forceIndent > 0 ? forceIndent : indt_len;
                                parser.addLevel(new_spaces, LevelStatus.block);
                                lastIndent = indt_len - new_spaces;
                                nl_begin = 1;
                                lvl = parser.currentLevel();
                            } else {
                                parser.cursor = parser.token;
                                RETURN_YAML_BLOCK(q, blockType, nlDoWhat);
                                return DefaultYAMLParser.YAML_BLOCK;
                            }
                        }

                        /*
                         * Fold only in the event of two lines being on the leftmost
                         * indentation.
                         */
                        if(blockType == YAML.BLOCK_FOLD && lastIndent == 0 && (indt_len - lvl.spaces) == 0) {
                            fold_nl = 1;
                        }

                        int pacer = parser.token;
                        while(pacer < parser.cursor) {
                            int nl_len = newlineLen(pacer++);
                            if(nl_len>0) {
                                nl_count++;
                                pacer += (nl_len - 1);
                            }
                        }

                        if(fold_nl == 1 || nl_begin == 1) {
                            nl_count--;
                        }

                        if(nl_count < 1 && nl_begin == 0) {
                            q.cat(' ');
                        } else {
                            for(int i = 0; i < nl_count; i++) {
                                q.cat('\n');
                            }
                        }

                        lastIndent = indt_len - lvl.spaces;
                        parser.cursor -= lastIndent;

                        if(indt_len < lvl.spaces) {
                            parser.popLevel();
                            parser.cursor = parser.token;
                            RETURN_YAML_BLOCK(q, blockType, nlDoWhat);
                            return DefaultYAMLParser.YAML_BLOCK;
                        }
                        break;
                    }
            case 116:
                ++parser.cursor;
                switch ((yych = parser.buffer.buffer[parser.cursor])) {
                case '\n':    {gotoPoint = 132; continue gotoNext;}
                default:    {gotoPoint = 117; continue gotoNext;}
                }
            case 117:
                {   q.cat(parser.buffer.buffer[parser.token]);
                        break;
                    }
            case 118:
                ++parser.cursor;
                {   lvl = parser.currentLevel();
                        if(lvl.status != LevelStatus.block) {
                            eatComments();
                            parser.token = parser.cursor;
                        } else {
                            q.cat(parser.buffer.buffer[parser.token]);
                        }
                        break;
                    }
            case 120:
                ++parser.cursor;
                {   parser.cursor--;
                        parser.popLevel();
                        RETURN_YAML_BLOCK(q, blockType, nlDoWhat); 
                        return DefaultYAMLParser.YAML_BLOCK;
                    }
            case 122:
                yyaccept = 1;
                yych = parser.buffer.buffer[(parser.marker = ++parser.cursor)];
                switch (yych) {
                case '-':    {gotoPoint = 124; continue gotoNext;}
                default:    {gotoPoint = 117; continue gotoNext;}
                }
            case 123:
                yych = parser.buffer.buffer[++parser.cursor];
                {gotoPoint = 117; continue gotoNext;}
            case 124:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '-':    {gotoPoint = 126; continue gotoNext;}
                default:    {gotoPoint = 125; continue gotoNext;}
                }
            case 125:
                parser.cursor = parser.marker;
                if (yyaccept == 0) {
                    {gotoPoint = 115; continue gotoNext;}
                } else {
                    {gotoPoint = 117; continue gotoNext;}
                }
            case 126:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '\n':    {gotoPoint = 127; continue gotoNext;}
                case '\r':    {gotoPoint = 131; continue gotoNext;}
                case ' ':    {gotoPoint = 129; continue gotoNext;}
                default:    {gotoPoint = 125; continue gotoNext;}
                }
            case 127:
                ++parser.cursor;
            case 128:
                {   if(parser.token == parser.lineptr) {
                            if(blockType == YAML.BLOCK_FOLD && q.idx > 0) {
                                q.idx--;
                            }
                            q.cat('\n');
                            parser.popLevel();
                            parser.cursor = parser.token;
                            RETURN_YAML_BLOCK(q, blockType, nlDoWhat);
                            return DefaultYAMLParser.YAML_BLOCK;
                        } else {
                            q.cat(parser.buffer.buffer[parser.token]);
                            parser.cursor = parser.token + 1;
                        }
                        break;
                    }
            case 129:
                ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case ' ':    {gotoPoint = 129; continue gotoNext;}
                default:    {gotoPoint = 128; continue gotoNext;}
                }
            case 131:
                yych = parser.buffer.buffer[++parser.cursor];
                switch (yych) {
                case '\n':    {gotoPoint = 127; continue gotoNext;}
                default:    {gotoPoint = 125; continue gotoNext;}
                }
            case 132:
                yyaccept = 0;
                parser.marker = ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
            case 133:
                switch (yych) {
                case '\n':
                case ' ':    {gotoPoint = 132; continue gotoNext;}
                case '\r':    {gotoPoint = 134; continue gotoNext;}
                default:    {gotoPoint = 115; continue gotoNext;}
                }
            case 134:
                ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case '\n':    {gotoPoint = 132; continue gotoNext;}
                default:    {gotoPoint = 125; continue gotoNext;}
                }
            }
        }

       }
   }

   private byte escapeSeq(byte ch) {
       switch(ch) {
        case '0': return '\0';
        case 'a': return 7;
        case 'b': return '\010';
        case 'e': return '\033';
        case 'f': return '\014';
        case 'n': return '\n';
        case 'r': return '\015';
        case 't': return '\t';
        case 'v': return '\013';
        default: return ch;
      }
   }

   private void eatComments() throws IOException {
     while(true) {
       parser.token = parser.cursor;

        int gotoPoint = -1;
        byte yych = (byte) 0;
        gotoNext: while(gotoPoint != -2) {
            int currentGoto = gotoPoint; gotoPoint = -2;
            switch(currentGoto) {
            case -1: 
                if ((parser.limit - parser.cursor) < 2) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case 0x00:    {gotoPoint = 137; continue gotoNext;}
                case '\n':    {gotoPoint = 139; continue gotoNext;}
                case '\r':    {gotoPoint = 140; continue gotoNext;}
                default:    {gotoPoint = 142; continue gotoNext;}
                }
            case 137:
                ++parser.cursor;
            case 138:
                {   parser.cursor = parser.token;
                        return;
                    }
            case 139:
                yych = parser.buffer.buffer[(parser.marker = ++parser.cursor)];
                {gotoPoint = 144; continue gotoNext;}
            case 140:
                ++parser.cursor;
                switch ((yych = parser.buffer.buffer[parser.cursor])) {
                case '\n':    {gotoPoint = 143; continue gotoNext;}
                default:    {gotoPoint = 141; continue gotoNext;}
                }
            case 141:
                { break; }
            case 142:
                yych = parser.buffer.buffer[++parser.cursor];
                {gotoPoint = 141; continue gotoNext;}
            case 143:
                parser.marker = ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
            case 144:
                switch (yych) {
                case '\n':    {gotoPoint = 143; continue gotoNext;}
                case '\r':    {gotoPoint = 145; continue gotoNext;}
                default:    {gotoPoint = 138; continue gotoNext;}
                }
            case 145:
                ++parser.cursor;
                if (parser.limit <= parser.cursor) parser.read();
                yych = parser.buffer.buffer[parser.cursor];
                switch (yych) {
                case '\n':    {gotoPoint = 143; continue gotoNext;}
                default:    {gotoPoint = 146; continue gotoNext;}
                }
            case 146:
                parser.cursor = parser.marker;
                {gotoPoint = 138; continue gotoNext;}
            }
        }

    }
  }
}
