// Copyright John Maddock 2008.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const std::array<std::array<T, 4>, 255> hypergeometric_0F2 = {{
      { SC_(-4.8646093750000000000000000000000000000000e+02), SC_(4.2926367187500000000000000000000000000000e+02), SC_(-2.8276220703125000000000000000000000000000e+02), SC_(1.0013550123274012503281643629835481621491e+00) }, 
      { SC_(-4.6555395507812500000000000000000000000000e+02), SC_(1.6360552978515625000000000000000000000000e+02), SC_(-6.1255645751953125000000000000000000000000e+01), SC_(1.0008045482288008613878905914537628888437e+00) }, 
      { SC_(-4.6428833007812500000000000000000000000000e+02), SC_(-1.3870599365234375000000000000000000000000e+02), SC_(3.4912927246093750000000000000000000000000e+02), SC_(1.0054361590960244514317052562813343972063e+00) }, 
      { SC_(-4.6355883789062500000000000000000000000000e+02), SC_(-3.1312744140625000000000000000000000000000e+02), SC_(-9.1268829345703125000000000000000000000000e+01), SC_(9.9937142193458336300712662386851304924744e-01) }, 
      { SC_(-4.5382861328125000000000000000000000000000e+02), SC_(-3.5088610839843750000000000000000000000000e+02), SC_(-4.0286828613281250000000000000000000000000e+02), SC_(9.9747330394796032410538209647331764537338e-01) }, 
      { SC_(-3.8753552246093750000000000000000000000000e+02), SC_(4.1573547363281250000000000000000000000000e+02), SC_(1.3976336669921875000000000000000000000000e+02), SC_(9.9913288567800670560465376832731165310591e-01) }, 
      { SC_(-3.8100231933593750000000000000000000000000e+02), SC_(-4.3967193603515625000000000000000000000000e+01), SC_(-1.6359252929687500000000000000000000000000e+00), SC_(9.9990234705498153808404610903859529590335e-01) }, 
      { SC_(-3.7410339355468750000000000000000000000000e+02), SC_(-1.1844155883789062500000000000000000000000e+02), SC_(-2.8979101562500000000000000000000000000000e+02), SC_(9.9348140693863510115749506422371573420155e-01) }, 
      { SC_(-3.5811364746093750000000000000000000000000e+02), SC_(-4.9521655273437500000000000000000000000000e+02), SC_(-7.8238739013671875000000000000000000000000e+01), SC_(9.9955892792802478635575395801641016109872e-01) }, 
      { SC_(-3.2613488769531250000000000000000000000000e+02), SC_(-3.2881335449218750000000000000000000000000e+02), SC_(-1.9808691406250000000000000000000000000000e+02), SC_(9.9815453602218599515426271662441282707593e-01) }, 
      { SC_(-2.8807568359375000000000000000000000000000e+02), SC_(4.3399316406250000000000000000000000000000e+02), SC_(1.8135955810546875000000000000000000000000e+02), SC_(9.9855044188853804894946990947110500188253e-01) }, 
      { SC_(-2.4249176025390625000000000000000000000000e+02), SC_(3.0973449707031250000000000000000000000000e+02), SC_(3.4071728515625000000000000000000000000000e+02), SC_(9.9547392211818475702670044866243182131780e-01) }, 
      { SC_(-2.2150177001953125000000000000000000000000e+02), SC_(-3.1161804199218750000000000000000000000000e+02), SC_(4.6881469726562500000000000000000000000000e+01), SC_(1.0006794383636374608834847128496473193998e+00) }, 
      { SC_(-1.9183294677734375000000000000000000000000e+02), SC_(-4.0245959472656250000000000000000000000000e+02), SC_(4.7220581054687500000000000000000000000000e+01), SC_(1.0006118143959052029406077900452398537572e+00) }, 
      { SC_(-1.8344958496093750000000000000000000000000e+02), SC_(-2.2307702636718750000000000000000000000000e+02), SC_(3.7242883300781250000000000000000000000000e+02), SC_(1.0091425903971098776250072125842027790700e+00) }, 
      { SC_(-1.5961425781250000000000000000000000000000e+02), SC_(3.7675744628906250000000000000000000000000e+02), SC_(8.5267700195312500000000000000000000000000e+01), SC_(9.9858309073053077899790756504828564947261e-01) }, 
      { SC_(-1.5001623535156250000000000000000000000000e+02), SC_(4.0736474609375000000000000000000000000000e+02), SC_(-3.0340478515625000000000000000000000000000e+02), SC_(1.0049771857160769715415635506383574939497e+00) }, 
      { SC_(-1.0777297973632812500000000000000000000000e+02), SC_(-7.7912322998046875000000000000000000000000e+01), SC_(1.5547790527343750000000000000000000000000e+02), SC_(1.0186926506384631817121334358716076224150e+00) }, 
      { SC_(-7.6834899902343750000000000000000000000000e+01), SC_(4.5929138183593750000000000000000000000000e+02), SC_(8.0956726074218750000000000000000000000000e+01), SC_(9.9770859113172567045095290396207748713121e-01) }, 
      { SC_(-1.9458435058593750000000000000000000000000e+01), SC_(1.7170547485351562500000000000000000000000e+01), SC_(-5.6552429199218750000000000000000000000000e+01), SC_(1.1843708637562542794889169551315847867164e+00) }, 
      { SC_(-1.8622161865234375000000000000000000000000e+01), SC_(6.5442199707031250000000000000000000000000e+00), SC_(-1.2251129150390625000000000000000000000000e+01), SC_(1.1052961337782846547617500779699305041287e+00) }, 
      { SC_(-1.8571533203125000000000000000000000000000e+01), SC_(-5.5482406616210937500000000000000000000000e+00), SC_(6.9825866699218750000000000000000000000000e+01), SC_(2.1709699265294645468109432587150419519616e+00) }, 
      { SC_(-1.8542350769042968750000000000000000000000e+01), SC_(-1.2525096893310546875000000000000000000000e+01), SC_(-1.8253768920898437500000000000000000000000e+01), SC_(9.2483070051031126644961165795654718381906e-01) }, 
      { SC_(-1.8153144836425781250000000000000000000000e+01), SC_(-1.4035442352294921875000000000000000000000e+01), SC_(-8.0573669433593750000000000000000000000000e+01), SC_(7.3371925642946384664229703773889948055531e-01) }, 
      { SC_(-1.5501419067382812500000000000000000000000e+01), SC_(1.6629417419433593750000000000000000000000e+01), SC_(2.7952667236328125000000000000000000000000e+01), SC_(8.9727834112725954814592158721591001531270e-01) }, 
      { SC_(-1.5240093231201171875000000000000000000000e+01), SC_(-1.7586879730224609375000000000000000000000e+00), SC_(-3.2718658447265625000000000000000000000000e-01), SC_(9.8798390454175472844979515494836456136983e-01) }, 
      { SC_(-1.4964134216308593750000000000000000000000e+01), SC_(-4.7376632690429687500000000000000000000000e+00), SC_(-5.7958190917968750000000000000000000000000e+01), SC_(-1.6307154809189961783800358984496085912050e+00) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(-1.9808662414550781250000000000000000000000e+01), SC_(-1.5647743225097656250000000000000000000000e+01), SC_(9.4653528197910165241384386830302720544485e-01) }, 
      { SC_(-1.3045394897460937500000000000000000000000e+01), SC_(-1.3152534484863281250000000000000000000000e+01), SC_(-3.9617385864257812500000000000000000000000e+01), SC_(7.9729506879938767419504797215381191262438e-01) }, 
      { SC_(-1.2431091308593750000000000000000000000000e+01), SC_(1.4631298828125000000000000000000000000000e+02), SC_(2.9397497558593750000000000000000000000000e+02), SC_(8.5163048830387097953496533791624327293711e-01) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(1.7359725952148437500000000000000000000000e+01), SC_(3.6271911621093750000000000000000000000000e+01), SC_(8.3463455244679145149454273225637625080044e-01) }, 
      { SC_(-1.0235595703125000000000000000000000000000e+01), SC_(-4.2010833740234375000000000000000000000000e+01), SC_(-5.4413787841796875000000000000000000000000e+01), SC_(8.8207047103340533881092961234370287124678e-01) }, 
      { SC_(-9.6996726989746093750000000000000000000000e+00), SC_(1.2389381408691406250000000000000000000000e+01), SC_(6.8143432617187500000000000000000000000000e+01), SC_(5.6971226882974825102327326343955088655941e-01) }, 
      { SC_(-8.8600730895996093750000000000000000000000e+00), SC_(-1.2464721679687500000000000000000000000000e+01), SC_(9.3762969970703125000000000000000000000000e+00), SC_(1.0895185083879982269540444508574348779709e+00) }, 
      { SC_(-7.6733188629150390625000000000000000000000e+00), SC_(-1.6098388671875000000000000000000000000000e+01), SC_(9.4441146850585937500000000000000000000000e+00), SC_(1.0801829563303742714796062386840372944152e+00) }, 
      { SC_(-7.3379821777343750000000000000000000000000e+00), SC_(-8.9230842590332031250000000000000000000000e+00), SC_(7.4485748291015625000000000000000000000000e+01), SC_(-9.7375683797737559231310591870347355470131e+04) }, 
      { SC_(-6.3845710754394531250000000000000000000000e+00), SC_(1.5070297241210937500000000000000000000000e+01), SC_(1.7053543090820312500000000000000000000000e+01), SC_(8.3898488099816853847904405648254326769818e-01) }, 
      { SC_(-6.0006504058837890625000000000000000000000e+00), SC_(1.6294586181640625000000000000000000000000e+01), SC_(-6.0680953979492187500000000000000000000000e+01), SC_(2.8785236681083962893832262874724843440580e+00) }, 
      { SC_(-4.3109188079833984375000000000000000000000e+00), SC_(-3.1164932250976562500000000000000000000000e+00), SC_(3.1095581054687500000000000000000000000000e+01), SC_(-2.4338784712090861161103813511742621752907e+05) }, 
      { SC_(-3.0733947753906250000000000000000000000000e+00), SC_(1.8371650695800781250000000000000000000000e+01), SC_(1.6191337585449218750000000000000000000000e+01), SC_(7.9969594372684567479200044534448737112353e-01) }, 
      { SC_(-9.7292184829711914062500000000000000000000e-01), SC_(8.5852718353271484375000000000000000000000e-01), SC_(-5.6552429199218750000000000000000000000000e+01), SC_(-3.8479643557626853493282070912407630508011e+03) }, 
      { SC_(-9.3110799789428710937500000000000000000000e-01), SC_(3.2721102237701416015625000000000000000000e-01), SC_(-1.2251129150390625000000000000000000000000e+01), SC_(1.3274006715855418802747314856512628074356e+02) }, 
      { SC_(-9.2857670783996582031250000000000000000000e-01), SC_(-2.7741205692291259765625000000000000000000e-01), SC_(6.9825866699218750000000000000000000000000e+01), SC_(2.5957327900372311760684559064565560425989e+07) }, 
      { SC_(-9.2711758613586425781250000000000000000000e-01), SC_(-6.2625479698181152343750000000000000000000e-01), SC_(-1.8253768920898437500000000000000000000000e+01), SC_(-4.6481448511821567942224413485705877737751e+03) }, 
      { SC_(-9.0765738487243652343750000000000000000000e-01), SC_(-7.0177221298217773437500000000000000000000e-01), SC_(-8.0573669433593750000000000000000000000000e+01), SC_(-2.9128274990676818556608864647623770251180e+03) }, 
      { SC_(-7.7507114410400390625000000000000000000000e-01), SC_(8.3147096633911132812500000000000000000000e-01), SC_(2.7952667236328125000000000000000000000000e+01), SC_(-1.0117101938884752665856634793174177451829e+04) }, 
      { SC_(-7.6200461387634277343750000000000000000000e-01), SC_(-8.7934374809265136718750000000000000000000e-02), SC_(-3.2718658447265625000000000000000000000000e-01), SC_(-3.7033113793470643167656496040611055767304e-01) }, 
      { SC_(-7.4820685386657714843750000000000000000000e-01), SC_(-2.3688310384750366210937500000000000000000e-01), SC_(-5.7958190917968750000000000000000000000000e+01), SC_(1.9319431967800207473506144425283470401615e+04) }, 
      { SC_(-7.1622729301452636718750000000000000000000e-01), SC_(-9.9043321609497070312500000000000000000000e-01), SC_(-1.5647743225097656250000000000000000000000e+01), SC_(-3.3628263866410287728387295371785295757993e+04) }, 
      { SC_(-6.5226984024047851562500000000000000000000e-01), SC_(-6.5762662887573242187500000000000000000000e-01), SC_(-3.9617385864257812500000000000000000000000e+01), SC_(3.3169191367622573936844112940010935451687e+03) }, 
      { SC_(-5.7615137100219726562500000000000000000000e-01), SC_(8.6798644065856933593750000000000000000000e-01), SC_(3.6271911621093750000000000000000000000000e+01), SC_(-1.4036374022754311606447155203103898229226e+04) }, 
      { SC_(-4.9724388122558593750000000000000000000000e-01), SC_(5.8525199890136718750000000000000000000000e+00), SC_(5.8794998168945312500000000000000000000000e+01), SC_(-7.4740521421705398588809627080752902584409e+02) }, 
      { SC_(-4.8498356342315673828125000000000000000000e-01), SC_(6.1946892738342285156250000000000000000000e-01), SC_(6.8143432617187500000000000000000000000000e+01), SC_(-2.9423363385064323397108774744926829548419e+05) }, 
      { SC_(-4.4300353527069091796875000000000000000000e-01), SC_(-6.2323617935180664062500000000000000000000e-01), SC_(9.3762969970703125000000000000000000000000e+00), SC_(2.3984966130592016791972025137424348979093e+03) }, 
      { SC_(-4.0942382812500000000000000000000000000000e-01), SC_(-1.6804332733154296875000000000000000000000e+00), SC_(-1.0882759094238281250000000000000000000000e+01), SC_(3.6544312817005565101925778445295506072267e+02) }, 
      { SC_(-3.8366591930389404296875000000000000000000e-01), SC_(-8.0491924285888671875000000000000000000000e-01), SC_(9.4441146850585937500000000000000000000000e+00), SC_(4.1373931861772866189071974403747292693210e+03) }, 
      { SC_(-3.6689913272857666015625000000000000000000e-01), SC_(-4.4615411758422851562500000000000000000000e-01), SC_(7.4485748291015625000000000000000000000000e+01), SC_(4.6084954714223594122960231171187570977682e+06) }, 
      { SC_(-3.1922852993011474609375000000000000000000e-01), SC_(7.5351476669311523437500000000000000000000e-01), SC_(1.7053543090820312500000000000000000000000e+01), SC_(-1.5189960576357276764846511052193798221294e+03) }, 
      { SC_(-3.0003249645233154296875000000000000000000e-01), SC_(8.1472945213317871093750000000000000000000e-01), SC_(-6.0680953979492187500000000000000000000000e+01), SC_(1.1425397218870863052081420295537529676230e+02) }, 
      { SC_(-2.1554595232009887695312500000000000000000e-01), SC_(-1.5582466125488281250000000000000000000000e-01), SC_(3.1095581054687500000000000000000000000000e+01), SC_(1.9440499950444617144099384945685593834293e+05) }, 
      { SC_(-1.5366977453231811523437500000000000000000e-01), SC_(9.1858267784118652343750000000000000000000e-01), SC_(1.6191337585449218750000000000000000000000e+01), SC_(-1.5053688726396640756231727371601312898225e+03) }, 
      { SC_(-2.4862170219421386718750000000000000000000e-02), SC_(2.9262602329254150390625000000000000000000e-01), SC_(5.8794998168945312500000000000000000000000e+01), SC_(-3.4749896984152523485508001907364134791527e+06) }, 
      { SC_(-2.0471215248107910156250000000000000000000e-02), SC_(-8.4021687507629394531250000000000000000000e-02), SC_(-1.0882759094238281250000000000000000000000e+01), SC_(5.3461492782359630199105276366982841464942e+03) }, 
      { SC_(-9.7292195277987048029899597167968750000000e-07), SC_(8.5852730080659966915845870971679687500000e-07), SC_(-5.6552429199218750000000000000000000000000e+01), SC_(-1.9271103726166962938510569511179961586516e+13) }, 
      { SC_(-9.3110793386586010456085205078125000000000e-07), SC_(3.2721106890676310285925865173339843750000e-07), SC_(-1.2251129150390625000000000000000000000000e+01), SC_(-2.8126605131038490797267494038927727182371e+13) }, 
      { SC_(-9.2857681011082604527473449707031250000000e-07), SC_(-2.7741202757169958204030990600585937500000e-07), SC_(6.9825866699218750000000000000000000000000e+01), SC_(3.2268478919705029323884116452244203327000e+17) }, 
      { SC_(-9.2711752586183138191699981689453125000000e-07), SC_(-6.2625485952594317495822906494140625000000e-07), SC_(-1.8253768920898437500000000000000000000000e+01), SC_(-4.4392155307412519401105138508294446700414e+12) }, 
      { SC_(-9.0765729510167147964239120483398437500000e-07), SC_(-7.0177202360355295240879058837890625000000e-07), SC_(-8.0573669433593750000000000000000000000000e+01), SC_(7.6544067945091930530356731058579290758979e+14) }, 
      { SC_(-7.7507093010353855788707733154296875000000e-07), SC_(8.3147097029723227024078369140625000000000e-07), SC_(2.7952667236328125000000000000000000000000e+01), SC_(-3.6211762821896067613320830313261896618602e+15) }, 
      { SC_(-7.6200467447051778435707092285156250000000e-07), SC_(-8.7934381554077845066785812377929687500000e-08), SC_(-3.2718658447265625000000000000000000000000e-01), SC_(-4.1056848804321189047544136704129419095110e+12) }, 
      { SC_(-7.4820673034992069005966186523437500000000e-07), SC_(-2.3688312467129435390233993530273437500000e-07), SC_(-5.7958190917968750000000000000000000000000e+01), SC_(2.0080747879640587194562579450431000362773e+14) }, 
      { SC_(-7.1622730501985643059015274047851562500000e-07), SC_(-9.9043336376780644059181213378906250000000e-07), SC_(-1.5647743225097656250000000000000000000000e+01), SC_(6.0416000724638822195707249315021459452952e+12) }, 
      { SC_(-6.5226981860178057104349136352539062500000e-07), SC_(-6.5762674239522311836481094360351562500000e-07), SC_(-3.9617385864257812500000000000000000000000e+01), SC_(-2.0199869670530172182787566553911441703018e+14) }, 
      { SC_(-5.7615147852629888802766799926757812500000e-07), SC_(8.6798627307871356606483459472656250000000e-07), SC_(3.6271911621093750000000000000000000000000e+01), SC_(-1.1695061128266791798094905778237240774796e+16) }, 
      { SC_(-4.8498350224690511822700500488281250000000e-07), SC_(6.1946889218233991414308547973632812500000e-07), SC_(6.8143432617187500000000000000000000000000e+01), SC_(-2.4820721181133432525728355038272265081430e+17) }, 
      { SC_(-4.4300361423665890470147132873535156250000e-07), SC_(-6.2323601923708338290452957153320312500000e-07), SC_(9.3762969970703125000000000000000000000000e+00), SC_(3.5401682639779261781455942285698959288172e+14) }, 
      { SC_(-3.8366590615623863413929939270019531250000e-07), SC_(-8.0491918197367340326309204101562500000000e-07), SC_(9.4441146850585937500000000000000000000000e+00), SC_(3.2220181618469867084434326831857832507200e+14) }, 
      { SC_(-3.6689914395537925884127616882324218750000e-07), SC_(-4.4615410388360032811760902404785156250000e-07), SC_(7.4485748291015625000000000000000000000000e+01), SC_(6.7970424303966198880037212409823672361687e+17) }, 
      { SC_(-3.1922854759613983333110809326171875000000e-07), SC_(7.5351476880314294248819351196289062500000e-07), SC_(1.7053543090820312500000000000000000000000e+01), SC_(-2.0387697384015538763129051381854518202058e+15) }, 
      { SC_(-3.0003252504684496670961380004882812500000e-07), SC_(8.1472944657434709370136260986328125000000e-07), SC_(-6.0680953979492187500000000000000000000000e+01), SC_(-3.1805999648356634895599624901391402290975e+14) }, 
      { SC_(-2.1554592422035057097673416137695312500000e-07), SC_(-1.5582463674945756793022155761718750000000e-07), SC_(3.1095581054687500000000000000000000000000e+01), SC_(1.0030511650399026216269508869206697861543e+17) }, 
      { SC_(-1.5366975958386319689452648162841796875000e-07), SC_(9.1858260020671878010034561157226562500000e-07), SC_(1.6191337585449218750000000000000000000000e+01), SC_(-2.9869499707072794942586603211042643253053e+15) }, 
      { SC_(-2.4862174541340209543704986572265625000000e-08), SC_(2.9262605494295712560415267944335937500000e-07), SC_(5.8794998168945312500000000000000000000000e+01), SC_(-5.4045667308253995922835755248306334625698e+18) }, 
      { SC_(-2.0471247808018233627080917358398437500000e-08), SC_(-8.4021678503631846979260444641113281250000e-08), SC_(-1.0882759094238281250000000000000000000000e+01), SC_(5.1221368248059083280594747946762194141304e+15) }, 
      { SC_(-9.7292187954282303063548735725735096905845e-31), SC_(8.5852728321910516794400051740318495311654e-31), SC_(-5.6552429199218750000000000000000000000000e+01), SC_(-1.9271068181504199233782822208535432161009e+61) }, 
      { SC_(-9.3110813489085327723202983614451102360362e-31), SC_(3.2721098365308421385018005249687621799622e-31), SC_(-1.2251129150390625000000000000000000000000e+01), SC_(-2.8126605770611150728936085352273563313542e+61) }, 
      { SC_(-9.2857696641511466198687091513364110643049e-31), SC_(-2.7741205885620462851359058533722406876215e-31), SC_(6.9825866699218750000000000000000000000000e+01), SC_(3.2268395441987645116852065871138985007905e+65) }, 
      { SC_(-9.2711747262913370981697693184902596619691e-31), SC_(-6.2625486571131284021741387758775596284020e-31), SC_(-1.8253768920898437500000000000000000000000e+01), SC_(-4.4391314827118519369869053426997014538135e+60) }, 
      { SC_(-9.0765730471059283879705545472369615567010e-31), SC_(-7.0177200823186695791734846270014022525083e-31), SC_(-8.0573669433593750000000000000000000000000e+01), SC_(7.6543786760387080941447834665613701443679e+62) }, 
      { SC_(-7.7507094589264538619824572321732462117758e-31), SC_(8.3147097676600260926458442727540201324001e-31), SC_(2.7952667236328125000000000000000000000000e+01), SC_(-3.6211765026664811524642208105687300059249e+63) }, 
      { SC_(-7.6200471492619323295766907286310000490087e-31), SC_(-8.7934406565804302453111855399139221293520e-32), SC_(-3.2718658447265625000000000000000000000000e-01), SC_(-4.1056841461338244256995645916581315505253e+60) }, 
      { SC_(-7.4820685627578928797213268088810826291429e-31), SC_(-2.3688308250990960246484257451010654894335e-31), SC_(-5.7958190917968750000000000000000000000000e+01), SC_(2.0080569493359921562294133317249051331419e+62) }, 
      { SC_(-7.1622739140234685764334224714459260257975e-31), SC_(-9.9043317186724861475019730670288927403108e-31), SC_(-1.5647743225097656250000000000000000000000e+01), SC_(6.0416367727759052394373073418232636758588e+60) }, 
      { SC_(-6.5226977820913491794777030464248297082584e-31), SC_(-6.5762664702515418079608479329098921104914e-31), SC_(-3.9617385864257812500000000000000000000000e+01), SC_(-2.0199845224435120349450660954283438613398e+62) }, 
      { SC_(-5.7615134681824818374175955141657878530610e-31), SC_(8.6798653327994614841212525906767385297577e-31), SC_(3.6271911621093750000000000000000000000000e+01), SC_(-1.1695066010548508093546365727741889404313e+64) }, 
      { SC_(-4.8498357847129806437772857054869456616134e-31), SC_(6.1946897192288593889141195530567938299129e-31), SC_(6.8143432617187500000000000000000000000000e+01), SC_(-2.4820720438120044564067118525404026953919e+65) }, 
      { SC_(-4.4300357189834800662914395134002990627785e-31), SC_(-6.2323619621840120589695016216016923593957e-31), SC_(9.3762969970703125000000000000000000000000e+00), SC_(3.5401631860934228931355185732594264236519e+62) }, 
      { SC_(-3.8366593362251185418889105592597263337672e-31), SC_(-8.0491947460691717373259043136616379454737e-31), SC_(9.4441146850585937500000000000000000000000e+00), SC_(3.2220122740817507598720951759989393820706e+62) }, 
      { SC_(-3.6689915240012307409022818545364940992659e-31), SC_(-4.4615408483764786871650144025763148025371e-31), SC_(7.4485748291015625000000000000000000000000e+01), SC_(6.7970318692176883033192694700737924516216e+65) }, 
      { SC_(-3.1922853065506828962406659391883036982694e-31), SC_(7.5351482452681434366011567009666605771740e-31), SC_(1.7053543090820312500000000000000000000000e+01), SC_(-2.0387709310247978098262773584412354214332e+63) }, 
      { SC_(-3.0003251982704420305293585126814514234886e-31), SC_(8.1472930410294739322709176901551385695756e-31), SC_(-6.0680953979492187500000000000000000000000e+01), SC_(-3.1806094167857736988417842535889831588023e+62) }, 
      { SC_(-2.1554597925152376853519725638106323429786e-31), SC_(-1.5582465961957922145234336536125662040749e-31), SC_(3.1095581054687500000000000000000000000000e+01), SC_(1.0030501590598931416560736949671711946213e+65) }, 
      { SC_(-1.5366974337565180399273507754122079963092e-31), SC_(9.1858281940487550781112007959525459589802e-31), SC_(1.6191337585449218750000000000000000000000e+01), SC_(-2.9869527159177628820831940896877207038463e+63) }, 
      { SC_(-2.4862175717631709708541965256865384984136e-32), SC_(2.9262605906093119970572707359333819456171e-31), SC_(5.8794998168945312500000000000000000000000e+01), SC_(-5.4045690763116786994392966471452867478014e+66) }, 
      { SC_(-2.0471187099796104059775228046263919589385e-32), SC_(-8.4021703089431269145587437710802743220160e-32), SC_(-1.0882759094238281250000000000000000000000e+01), SC_(5.1221502623965941291429932271275865452617e+63) }, 
      { SC_(7.3253986756802984006592536032001017252032e-33), SC_(3.1148136460631295446554815764607492635254e-31), SC_(5.9585723876953125000000000000000000000000e+01), SC_(1.8239063272472639823825344640949401781972e+67) }, 
      { SC_(9.4431034704380855269152830994136150926034e-32), SC_(-6.8388493387337050493209106755838271277991e-31), SC_(-7.2275115966796875000000000000000000000000e+01), SC_(-4.7471294715855741238447862500543189843562e+63) }, 
      { SC_(3.5747027711330734153130935594128233289567e-31), SC_(-2.0252291243763380969191321803248541888244e-31), SC_(5.1548034667968750000000000000000000000000e+01), SC_(-3.1435838069640823331527643972111502482126e+65) }, 
      { SC_(3.5940542293340502411842780877831908262032e-31), SC_(-9.9436327266001381791283966169197664134048e-31), SC_(3.1019607543945312500000000000000000000000e+01), SC_(-9.3465500364854136852805479521948150463505e+63) }, 
      { SC_(3.8965728726933095494250674980780995292708e-31), SC_(-7.4963456469452400548781118953675691362474e-31), SC_(-3.6580108642578125000000000000000000000000e+01), SC_(2.7994579843575804174909759797949396520405e+62) }, 
      { SC_(3.9815329023933412013510159000423745578808e-31), SC_(-1.7466698770732789815807647456262241860604e-31), SC_(7.8180633544921875000000000000000000000000e+01), SC_(-1.9982241865008898311268142613780604206399e+66) }, 
      { SC_(4.1209220821183673962159423036369586725600e-31), SC_(5.9455977643122133768255124058732510818004e-31), SC_(-9.3633453369140625000000000000000000000000e+01), SC_(2.8636746811015060135086080189586276300220e+63) }, 
      { SC_(4.1872970759341583537259017934531351081055e-31), SC_(8.4174949936959269123426305955687332944686e-31), SC_(5.0937332153320312500000000000000000000000e+01), SC_(6.1513646646856287221845432202939682406358e+64) }, 
      { SC_(4.2140757776413707209874359867602876424427e-31), SC_(-6.7477663940591102662234547187444688659024e-31), SC_(2.8792190551757812500000000000000000000000e+01), SC_(-9.0772916121748359654323938967762859575717e+63) }, 
      { SC_(4.5167777981193583060794685199550030158361e-31), SC_(9.4118541286158258358034422073080989135043e-31), SC_(9.6221923828125000000000000000000000000000e+01), SC_(8.8142768821416978939939800299299757119488e+65) }, 
      { SC_(4.8129440700067739726271948780027627032607e-31), SC_(4.8626496135324242354441513087318979172982e-31), SC_(-5.0482635498046875000000000000000000000000e+00), SC_(1.2987059897829037497604624359874025104661e+61) }, 
      { SC_(5.0253417932681514578670499454403758302944e-31), SC_(6.4249192215944706467348571662694535349809e-31), SC_(-4.8980987548828125000000000000000000000000e+01), SC_(-1.8557850179467650844289584761348776614150e+62) }, 
      { SC_(5.2346230459066288944657782985705053395871e-31), SC_(-7.0141202484187114059090811682298128473445e-31), SC_(-5.3968795776367187500000000000000000000000e+01), SC_(4.2051045938786957109028238203944130074378e+61) }, 
      { SC_(5.2749998662641534836194948361402448119254e-31), SC_(9.0044409521575501951615673733560854507239e-31), SC_(-1.8821868896484375000000000000000000000000e+00), SC_(-7.8847574863153477914053735916087423477126e+59) }, 
      { SC_(5.3103361668453521039390414314383752947971e-31), SC_(-8.9756723736132658596065437028387230989032e-31), SC_(5.9039993286132812500000000000000000000000e+01), SC_(-8.3962817618382072690450303036191297746931e+64) }, 
      { SC_(5.4783415810467960658979587572950977582572e-31), SC_(9.1948785601546060340925536922999274729029e-31), SC_(1.4750930786132812500000000000000000000000e+01), SC_(6.4169191173350629509113849872326750749408e+62) }, 
      { SC_(5.8441460190678853600777658177863628352289e-31), SC_(7.5686131588428329752080170676975332449266e-31), SC_(9.1898468017578125000000000000000000000000e+01), SC_(6.7636946359247469005893750754812401072224e+65) }, 
      { SC_(5.9621167513254488187174954666835278558617e-31), SC_(6.0056081615149121408523259685822913903479e-31), SC_(-4.0594116210937500000000000000000000000000e+01), SC_(-2.4293360528329447309572088207270727326885e+62) }, 
      { SC_(6.1506209062142721591553748077709467283498e-31), SC_(-4.4794986404751206089667511969081516053080e-31), SC_(4.1154846191406250000000000000000000000000e+01), SC_(-3.4025073618580215709302688195572466871990e+64) }, 
      { SC_(6.1635099666721683772227504101542812077579e-31), SC_(-5.5237626827625692552058707370933653312481e-31), SC_(-9.6445220947265625000000000000000000000000e+01), SC_(-2.1260441741582203605316994145296675955201e+63) }, 
      { SC_(6.2856955514740402299510527607793103124931e-31), SC_(-4.0033670046632546984390303999793554379989e-31), SC_(-5.1295013427734375000000000000000000000000e+01), SC_(1.6692238758844283351374673159182264394982e+62) }, 
      { SC_(6.2944732028905004152305569102500562654185e-31), SC_(-7.2904611027828987002624100033353970280654e-31), SC_(8.1158386230468750000000000000000000000000e+01), SC_(-3.6035325666978797126086429365447828937609e+65) }, 
      { SC_(6.4168148933421614677399175090872284843797e-31), SC_(1.1914152463098245699766651048823837732790e-32), SC_(8.8014801025390625000000000000000000000000e+01), SC_(3.1766092117691277192234514772024281065993e+67) }, 
      { SC_(6.7001710979920561739408037638469550273058e-31), SC_(-7.4602645531433604331935163085994546385142e-31), SC_(9.3773559570312500000000000000000000000000e+01), SC_(-6.6049004330557223900372236114864618841013e+65) }, 
      { SC_(8.2675169608586935516059218132468511907236e-31), SC_(-5.5793193669688725363224923508101779953714e-31), SC_(2.6471855163574218750000000000000000000000e+01), SC_(-4.2125713258029490897661567196053721537858e+63) }, 
      { SC_(9.1433373646507116871031532825942660000150e-31), SC_(-7.8027659911537486998153511359768259171689e-31), SC_(-2.9248733520507812500000000000000000000000e+00), SC_(-5.4897384913406521146487403457807730905897e+59) }, 
      { SC_(9.2977691104843405307500540139083757481841e-31), SC_(9.3538994359338450881705643710553528681982e-31), SC_(-6.8477386474609375000000000000000000000000e+01), SC_(2.5885632291730848701474651936831939628491e+62) }, 
      { SC_(9.7704306869725790485542511005792918462522e-31), SC_(-4.9143563186409143605146737165420002823775e-31), SC_(-3.3510345458984375000000000000000000000000e+01), SC_(1.4983049143774025309584899024760318076525e+62) }, 
      { SC_(9.8576241559391730467453401019642891416501e-31), SC_(9.1501345431849064823892317047470999134224e-31), SC_(9.9292266845703125000000000000000000000000e+01), SC_(4.8539223899681869236400744701070573873698e+65) }, 
      { SC_(9.8813710226167445700663213299946380599351e-31), SC_(6.4691573057955762858947494096166606399216e-31), SC_(6.4380645751953125000000000000000000000000e+01), SC_(9.0869460353192324296392092038224195585453e+64) }, 
      { SC_(7.3254113885923288762569427490234375000000e-09), SC_(3.1148135803960030898451805114746093750000e-07), SC_(5.9585723876953125000000000000000000000000e+01), SC_(1.8239021218547294411482974628258880799164e+19) }, 
      { SC_(9.4431015895679593086242675781250000000000e-08), SC_(-6.8388499130378477275371551513671875000000e-07), SC_(-7.2275115966796875000000000000000000000000e+01), SC_(-4.7471378920508698919864532752319025221816e+15) }, 
      { SC_(3.5747029869526159018278121948242187500000e-07), SC_(-2.0252292642908287234604358673095703125000e-07), SC_(5.1548034667968750000000000000000000000000e+01), SC_(-3.1435825220650539057683771538205325992747e+17) }, 
      { SC_(3.5940536236012121662497520446777343750000e-07), SC_(-9.9436329037416726350784301757812500000000e-07), SC_(3.1019607543945312500000000000000000000000e+01), SC_(-9.3465610416137672156160862265250027702078e+15) }, 
      { SC_(3.8965720250416779890656471252441406250000e-07), SC_(-7.4963463703170418739318847656250000000000e-07), SC_(-3.6580108642578125000000000000000000000000e+01), SC_(2.7994597028134863825220414677377288801984e+14) }, 
      { SC_(3.9815347463445505127310752868652343750000e-07), SC_(-1.7466692270318162627518177032470703125000e-07), SC_(7.8180633544921875000000000000000000000000e+01), SC_(-1.9982231327297284039276179729150528612431e+18) }, 
      { SC_(4.1209216306015150621533393859863281250000e-07), SC_(5.9455965129018295556306838989257812500000e-07), SC_(-9.3633453369140625000000000000000000000000e+01), SC_(2.8636707426620698619883374472744164680923e+15) }, 
      { SC_(4.1872965539369033649563789367675781250000e-07), SC_(8.4174939729564357548952102661132812500000e-07), SC_(5.0937332153320312500000000000000000000000e+01), SC_(6.1513522357760022943348749460634409947869e+16) }, 
      { SC_(4.2140766254306072369217872619628906250000e-07), SC_(-6.7477662923920433968305587768554687500000e-07), SC_(2.8792190551757812500000000000000000000000e+01), SC_(-9.0772935786561437105825313570674387095630e+15) }, 
      { SC_(4.5167791995481820777058601379394531250000e-07), SC_(9.4118558990885503590106964111328125000000e-07), SC_(9.6221923828125000000000000000000000000000e+01), SC_(8.8142476037697580759463039004589506118197e+17) }, 
      { SC_(4.8129436436283867806196212768554687500000e-07), SC_(4.8626498028170317411422729492187500000000e-07), SC_(-5.0482635498046875000000000000000000000000e+00), SC_(1.2987035801792289708931885811259542475091e+13) }, 
      { SC_(5.0253402150701731443405151367187500000000e-07), SC_(6.4249184106301981955766677856445312500000e-07), SC_(-4.8980987548828125000000000000000000000000e+01), SC_(-1.8557877755696109820651092549183523784669e+14) }, 
      { SC_(5.2346240408951416611671447753906250000000e-07), SC_(-7.0141209107532631605863571166992187500000e-07), SC_(-5.3968795776367187500000000000000000000000e+01), SC_(4.2050941912008437799611250386550245675508e+13) }, 
      { SC_(5.2749987844435963779687881469726562500000e-07), SC_(9.0044409262191038578748703002929687500000e-07), SC_(-1.8821868896484375000000000000000000000000e+00), SC_(-7.8848006279337538103197079420096712306435e+11) }, 
      { SC_(5.3103349273442290723323822021484375000000e-07), SC_(-8.9756713350652717053890228271484375000000e-07), SC_(5.9039993286132812500000000000000000000000e+01), SC_(-8.3962903912407510804298991247183326157720e+16) }, 
      { SC_(5.4783413361292332410812377929687500000000e-07), SC_(9.1948777480865828692913055419921875000000e-07), SC_(1.4750930786132812500000000000000000000000e+01), SC_(6.4169073483977184850748953444054687298781e+14) }, 
      { SC_(5.8441446526558138430118560791015625000000e-07), SC_(7.5686125455831643193960189819335937500000e-07), SC_(9.1898468017578125000000000000000000000000e+01), SC_(6.7636785256526348070927885806333066814550e+17) }, 
      { SC_(5.9621152104227803647518157958984375000000e-07), SC_(6.0056095207983162254095077514648437500000e-07), SC_(-4.0594116210937500000000000000000000000000e+01), SC_(-2.4293332933648005453267555419378512965619e+14) }, 
      { SC_(6.1506193560489919036626815795898437500000e-07), SC_(-4.4794990117225097492337226867675781250000e-07), SC_(4.1154846191406250000000000000000000000000e+01), SC_(-3.4025069591290943626269449758572619738524e+16) }, 
      { SC_(6.1635091697098687291145324707031250000000e-07), SC_(-5.5237615015357732772827148437500000000000e-07), SC_(-9.6445220947265625000000000000000000000000e+01), SC_(-2.1260446936406846629607441644415981335344e+15) }, 
      { SC_(6.2856952354195527732372283935546875000000e-07), SC_(-4.0033660297922324389219284057617187500000e-07), SC_(-5.1295013427734375000000000000000000000000e+01), SC_(1.6692253911657694000542731766822773384502e+14) }, 
      { SC_(6.2944718592916615307331085205078125000000e-07), SC_(-7.2904595072031952440738677978515625000000e-07), SC_(8.1158386230468750000000000000000000000000e+01), SC_(-3.6035348301941865225413767550994620368696e+17) }, 
      { SC_(6.4168148128374014049768447875976562500000e-07), SC_(1.1914153219549916684627532958984375000000e-08), SC_(8.8014801025390625000000000000000000000000e+01), SC_(3.1766049076559494103765778754649874481706e+19) }, 
      { SC_(6.7001701609115116298198699951171875000000e-07), SC_(-7.4602644417609553784132003784179687500000e-07), SC_(9.3773559570312500000000000000000000000000e+01), SC_(-6.6049024684244178800056342875528555065302e+17) }, 
      { SC_(8.2675160228973254561424255371093750000000e-07), SC_(-5.5793202591303270310163497924804687500000e-07), SC_(2.6471855163574218750000000000000000000000e+01), SC_(-4.2125693651374922862041778761602681214639e+15) }, 
      { SC_(9.1433389570738654583692550659179687500000e-07), SC_(-7.8027665040281135588884353637695312500000e-07), SC_(-2.9248733520507812500000000000000000000000e+00), SC_(-5.4897317955644623438744858914407450555119e+11) }, 
      { SC_(9.2977688836981542408466339111328125000000e-07), SC_(9.3538983492180705070495605468750000000000e-07), SC_(-6.8477386474609375000000000000000000000000e+01), SC_(2.5885481468591170687471865020580975496796e+14) }, 
      { SC_(9.7704287327360361814498901367187500000000e-07), SC_(-4.9143568503495771437883377075195312500000e-07), SC_(-3.3510345458984375000000000000000000000000e+01), SC_(1.4983038668105218355926456266311675993770e+14) }, 
      { SC_(9.8576219897950068116188049316406250000000e-07), SC_(9.1501351562328636646270751953125000000000e-07), SC_(9.9292266845703125000000000000000000000000e+01), SC_(4.8539043264529098665728877052317148396833e+17) }, 
      { SC_(9.8813688964582979679107666015625000000000e-07), SC_(6.4691562329244334250688552856445312500000e-07), SC_(6.4380645751953125000000000000000000000000e+01), SC_(9.0869215240147819516390701919339941131575e+16) }, 
      { SC_(7.3254108428955078125000000000000000000000e-03), SC_(3.1148135662078857421875000000000000000000e-01), SC_(5.9585723876953125000000000000000000000000e+01), SC_(1.0732325580249125394816235123779984439423e+07) }, 
      { SC_(9.4431042671203613281250000000000000000000e-02), SC_(-6.8388485908508300781250000000000000000000e-01), SC_(-7.2275115966796875000000000000000000000000e+01), SC_(-3.5767026726015232268725324811055081156289e+04) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(6.2296276092529296875000000000000000000000e+00), SC_(5.9585723876953125000000000000000000000000e+01), SC_(7.4548794788284688384202240080966824132400e+02) }, 
      { SC_(3.5747027397155761718750000000000000000000e-01), SC_(-2.0252293348312377929687500000000000000000e-01), SC_(5.1548034667968750000000000000000000000000e+01), SC_(-2.6360191832189761910637564711884531996497e+05) }, 
      { SC_(3.5940539836883544921875000000000000000000e-01), SC_(-9.9436330795288085937500000000000000000000e-01), SC_(3.1019607543945312500000000000000000000000e+01), SC_(-2.3555825510831623578668403325748767745162e+06) }, 
      { SC_(3.8965725898742675781250000000000000000000e-01), SC_(-7.4963450431823730468750000000000000000000e-01), SC_(-3.6580108642578125000000000000000000000000e+01), SC_(9.4095106820256680053759282814230969182804e+02) }, 
      { SC_(3.9815342426300048828125000000000000000000e-01), SC_(-1.7466694116592407226562500000000000000000e-01), SC_(7.8180633544921875000000000000000000000000e+01), SC_(-1.4495278740793887117408400376473147341114e+06) }, 
      { SC_(4.1209220886230468750000000000000000000000e-01), SC_(5.9455966949462890625000000000000000000000e-01), SC_(-9.3633453369140625000000000000000000000000e+01), SC_(3.8037593637225235624362242798799015941285e+02) }, 
      { SC_(4.1872966289520263671875000000000000000000e-01), SC_(8.4174942970275878906250000000000000000000e-01), SC_(5.0937332153320312500000000000000000000000e+01), SC_(1.0524822363595218455338193121798336701814e+04) }, 
      { SC_(4.2140769958496093750000000000000000000000e-01), SC_(-6.7477655410766601562500000000000000000000e-01), SC_(2.8792190551757812500000000000000000000000e+01), SC_(-2.5332292227947991578987460961881686796240e+04) }, 
      { SC_(4.5167791843414306640625000000000000000000e-01), SC_(9.4118547439575195312500000000000000000000e-01), SC_(9.6221923828125000000000000000000000000000e+01), SC_(9.6425701194710076809511411717634396429222e+04) }, 
      { SC_(4.8129451274871826171875000000000000000000e-01), SC_(4.8626494407653808593750000000000000000000e-01), SC_(-5.0482635498046875000000000000000000000000e+00), SC_(-1.9184176615842473686353008549658185499983e+00) }, 
      { SC_(5.0253415107727050781250000000000000000000e-01), SC_(6.4249181747436523437500000000000000000000e-01), SC_(-4.8980987548828125000000000000000000000000e+01), SC_(-9.1087147053030720616061030453398319186680e+01) }, 
      { SC_(5.2346229553222656250000000000000000000000e-01), SC_(-7.0141196250915527343750000000000000000000e-01), SC_(-5.3968795776367187500000000000000000000000e+01), SC_(-3.7190647942495343098134976882248843486844e+02) }, 
      { SC_(5.2749991416931152343750000000000000000000e-01), SC_(9.0044403076171875000000000000000000000000e-01), SC_(-1.8821868896484375000000000000000000000000e+00), SC_(-1.7842406968122617752297487730334775870513e+00) }, 
      { SC_(5.3103351593017578125000000000000000000000e-01), SC_(-8.9756727218627929687500000000000000000000e-01), SC_(5.9039993286132812500000000000000000000000e+01), SC_(-9.4413147512704930671221016324294432606915e+05) }, 
      { SC_(5.4783415794372558593750000000000000000000e-01), SC_(9.1948795318603515625000000000000000000000e-01), SC_(1.4750930786132812500000000000000000000000e+01), SC_(1.6558770127256692929600817901508107573553e+02) }, 
      { SC_(5.8441448211669921875000000000000000000000e-01), SC_(7.5686120986938476562500000000000000000000e-01), SC_(9.1898468017578125000000000000000000000000e+01), SC_(7.8495075050235499185550720080959607725604e+04) }, 
      { SC_(5.9621167182922363281250000000000000000000e-01), SC_(6.0056090354919433593750000000000000000000e-01), SC_(-4.0594116210937500000000000000000000000000e+01), SC_(-4.2297050952177685895293009611123892213832e+01) }, 
      { SC_(6.1506199836730957031250000000000000000000e-01), SC_(-4.4794988632202148437500000000000000000000e-01), SC_(4.1154846191406250000000000000000000000000e+01), SC_(-3.6829548935439152740004748457488922937882e+04) }, 
      { SC_(6.1635088920593261718750000000000000000000e-01), SC_(-5.5237627029418945312500000000000000000000e-01), SC_(-9.6445220947265625000000000000000000000000e+01), SC_(-3.3156945866171191273529082128010008691427e+03) }, 
      { SC_(6.2856960296630859375000000000000000000000e-01), SC_(-4.0033662319183349609375000000000000000000e-01), SC_(-5.1295013427734375000000000000000000000000e+01), SC_(2.8042052921467594768362697024694032732561e+02) }, 
      { SC_(6.2944722175598144531250000000000000000000e-01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(8.1158386230468750000000000000000000000000e+01), SC_(-1.0952177495348192536017535516063218828883e+06) }, 
      { SC_(6.4168143272399902343750000000000000000000e-01), SC_(1.1914134025573730468750000000000000000000e-02), SC_(8.8014801025390625000000000000000000000000e+01), SC_(1.0871257655093711991818114057205447747014e+07) }, 
      { SC_(6.7001700401306152343750000000000000000000e-01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(9.3773559570312500000000000000000000000000e+01), SC_(-2.0956480343797977382629608350161628368610e+06) }, 
      { SC_(8.2675170898437500000000000000000000000000e-01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.6471855163574218750000000000000000000000e+01), SC_(-5.0213830279399564094429560819789297274966e+03) }, 
      { SC_(9.1433382034301757812500000000000000000000e-01), SC_(-7.8027653694152832031250000000000000000000e-01), SC_(-2.9248733520507812500000000000000000000000e+00), SC_(-5.5618604070682692983965481884458426651443e+00) }, 
      { SC_(9.2977690696716308593750000000000000000000e-01), SC_(9.3538975715637207031250000000000000000000e-01), SC_(-6.8477386474609375000000000000000000000000e+01), SC_(-2.6685726492964694297784993909029343954793e+01) }, 
      { SC_(9.7704315185546875000000000000000000000000e-01), SC_(-4.9143564701080322265625000000000000000000e-01), SC_(-3.3510345458984375000000000000000000000000e+01), SC_(1.3268447121545709222120371332705766296633e+02) }, 
      { SC_(9.8576259613037109375000000000000000000000e-01), SC_(9.1501355171203613281250000000000000000000e-01), SC_(9.9292266845703125000000000000000000000000e+01), SC_(2.7231258268650511333426677132547588530732e+04) }, 
      { SC_(9.8813700675964355468750000000000000000000e-01), SC_(6.4691567420959472656250000000000000000000e-01), SC_(6.4380645751953125000000000000000000000000e+01), SC_(9.0456754397281598411963323256112518612515e+03) }, 
      { SC_(1.8886203765869140625000000000000000000000e+00), SC_(-1.3677696228027343750000000000000000000000e+01), SC_(-7.2275115966796875000000000000000000000000e+01), SC_(8.6903972682645821806410358881963870370739e+00) }, 
      { SC_(3.6627197265625000000000000000000000000000e+00), SC_(1.5574066162109375000000000000000000000000e+02), SC_(2.9792858886718750000000000000000000000000e+02), SC_(1.6414502438194959834822284645504633148411e+00) }, 
      { SC_(7.1494064331054687500000000000000000000000e+00), SC_(-4.0504589080810546875000000000000000000000e+00), SC_(5.1548034667968750000000000000000000000000e+01), SC_(-7.3280634631632271448589862017055225258464e+01) }, 
      { SC_(7.1881084442138671875000000000000000000000e+00), SC_(-1.9887268066406250000000000000000000000000e+01), SC_(3.1019607543945312500000000000000000000000e+01), SC_(8.0345913979757904607429603815888014394198e-01) }, 
      { SC_(7.7931442260742187500000000000000000000000e+00), SC_(-1.4992691040039062500000000000000000000000e+01), SC_(-3.6580108642578125000000000000000000000000e+01), SC_(1.3644113146571847740838225701777178299868e+00) }, 
      { SC_(7.9630680084228515625000000000000000000000e+00), SC_(-3.4933395385742187500000000000000000000000e+00), SC_(7.8180633544921875000000000000000000000000e+01), SC_(1.8012831116260841379976264026525324670577e+02) }, 
      { SC_(8.2418441772460937500000000000000000000000e+00), SC_(1.1891193389892578125000000000000000000000e+01), SC_(-9.3633453369140625000000000000000000000000e+01), SC_(3.4816049089036381102019335507640564537380e-01) }, 
      { SC_(8.3745918273925781250000000000000000000000e+00), SC_(1.6834991455078125000000000000000000000000e+01), SC_(5.0937332153320312500000000000000000000000e+01), SC_(1.4213912868918489118047786080245840810509e+00) }, 
      { SC_(8.4281539916992187500000000000000000000000e+00), SC_(-1.3495532989501953125000000000000000000000e+01), SC_(2.8792190551757812500000000000000000000000e+01), SC_(7.7546271972967343163149299910212429379822e-01) }, 
      { SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.8823707580566406250000000000000000000000e+01), SC_(9.6221923828125000000000000000000000000000e+01), SC_(1.7237093246196692630140245651027453488455e+00) }, 
      { SC_(9.6258888244628906250000000000000000000000e+00), SC_(9.7252998352050781250000000000000000000000e+00), SC_(-5.0482635498046875000000000000000000000000e+00), SC_(9.4725373575455031061975579092426467539937e-01) }, 
      { SC_(1.0050682067871093750000000000000000000000e+01), SC_(1.2849838256835937500000000000000000000000e+01), SC_(-4.8980987548828125000000000000000000000000e+01), SC_(6.7620736025439815644751726920552278877269e-01) }, 
      { SC_(1.0469245910644531250000000000000000000000e+01), SC_(-1.4028240203857421875000000000000000000000e+01), SC_(-5.3968795776367187500000000000000000000000e+01), SC_(1.4425735254143481929966058353243240077903e+00) }, 
      { SC_(1.0549999237060546875000000000000000000000e+01), SC_(1.8008880615234375000000000000000000000000e+01), SC_(-1.8821868896484375000000000000000000000000e+00), SC_(9.9013578130094518058218326274339300528969e-01) }, 
      { SC_(1.0620670318603515625000000000000000000000e+01), SC_(-1.7951347351074218750000000000000000000000e+01), SC_(5.9039993286132812500000000000000000000000e+01), SC_(7.3251185616667029708221384467470269912755e-01) }, 
      { SC_(1.0956684112548828125000000000000000000000e+01), SC_(1.8389755249023437500000000000000000000000e+01), SC_(1.4750930786132812500000000000000000000000e+01), SC_(1.0755818704952967604657667467570589014694e+00) }, 
      { SC_(1.1688289642333984375000000000000000000000e+01), SC_(1.5137226104736328125000000000000000000000e+01), SC_(9.1898468017578125000000000000000000000000e+01), SC_(1.6525911690388590736778885900608265524748e+00) }, 
      { SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.2011219024658203125000000000000000000000e+01), SC_(-4.0594116210937500000000000000000000000000e+01), SC_(7.4851178379529739742633280077371070510780e-01) }, 
      { SC_(1.2301239013671875000000000000000000000000e+01), SC_(-8.9589996337890625000000000000000000000000e+00), SC_(4.1154846191406250000000000000000000000000e+01), SC_(6.9017196358095451854293654240777274042156e-01) }, 
      { SC_(1.2327018737792968750000000000000000000000e+01), SC_(-1.1047523498535156250000000000000000000000e+01), SC_(-9.6445220947265625000000000000000000000000e+01), SC_(2.0413145669966800018139885964776034907767e+00) }, 
      { SC_(1.2571392059326171875000000000000000000000e+01), SC_(-8.0067329406738281250000000000000000000000e+00), SC_(-5.1295013427734375000000000000000000000000e+01), SC_(1.6793741444375545094325398336730837149668e+00) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158386230468750000000000000000000000000e+01), SC_(6.4222234388403296971258616743176546891569e-01) }, 
      { SC_(1.2833629608154296875000000000000000000000e+01), SC_(2.3828315734863281250000000000000000000000e-01), SC_(8.8014801025390625000000000000000000000000e+01), SC_(2.0522664314371239993932474771758162491563e+02) }, 
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773559570312500000000000000000000000000e+01), SC_(6.2533688088926754811859161270845720628984e-01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.6471855163574218750000000000000000000000e+01), SC_(8.6665632633084739056152697596877041057703e-01) }, 
      { SC_(1.8286674499511718750000000000000000000000e+01), SC_(-1.5605529785156250000000000000000000000000e+01), SC_(-2.9248733520507812500000000000000000000000e+00), SC_(1.0103026896041773017354219597019763585889e+00) }, 
      { SC_(1.8595535278320312500000000000000000000000e+01), SC_(1.8707794189453125000000000000000000000000e+01), SC_(-6.8477386474609375000000000000000000000000e+01), SC_(8.1970974601224314505763503611136167469695e-01) }, 
      { SC_(1.9540863037109375000000000000000000000000e+01), SC_(-9.8287124633789062500000000000000000000000e+00), SC_(-3.3510345458984375000000000000000000000000e+01), SC_(1.1917262344050289610135662112296735911490e+00) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.8300270080566406250000000000000000000000e+01), SC_(9.9292266845703125000000000000000000000000e+01), SC_(1.3120804234519319804237476312835263605802e+00) }, 
      { SC_(1.9762741088867187500000000000000000000000e+01), SC_(1.2938312530517578125000000000000000000000e+01), SC_(6.4380645751953125000000000000000000000000e+01), SC_(1.2817254805809260285294554516970119028856e+00) }, 
      { SC_(4.7215515136718750000000000000000000000000e+01), SC_(-3.4194250488281250000000000000000000000000e+02), SC_(-3.6137561035156250000000000000000000000000e+02), SC_(1.0226309476378112898976543388411657744031e+00) }, 
      { SC_(1.7873510742187500000000000000000000000000e+02), SC_(-1.0126147460937500000000000000000000000000e+02), SC_(2.5774011230468750000000000000000000000000e+02), SC_(9.8586076548119042518076397539909257012054e-01) }, 
      { SC_(1.7970269775390625000000000000000000000000e+02), SC_(-4.9718164062500000000000000000000000000000e+02), SC_(1.5509802246093750000000000000000000000000e+02), SC_(9.9826555310121491756334118823497873454182e-01) }, 
      { SC_(1.9482861328125000000000000000000000000000e+02), SC_(-3.7481726074218750000000000000000000000000e+02), SC_(-1.8290051269531250000000000000000000000000e+02), SC_(1.0025077558685747818258257430550175436007e+00) }, 
      { SC_(1.9907672119140625000000000000000000000000e+02), SC_(-8.7333465576171875000000000000000000000000e+01), SC_(3.9090319824218750000000000000000000000000e+02), SC_(9.7776877363038301340159194122578185239853e-01) }, 
      { SC_(2.0604608154296875000000000000000000000000e+02), SC_(2.9727990722656250000000000000000000000000e+02), SC_(-4.6816723632812500000000000000000000000000e+02), SC_(9.9238577026512882200354686225669434983401e-01) }, 
      { SC_(2.0936480712890625000000000000000000000000e+02), SC_(4.2087475585937500000000000000000000000000e+02), SC_(2.5468664550781250000000000000000000000000e+02), SC_(1.0028944958114437118136349433731517136021e+00) }, 
      { SC_(2.1070385742187500000000000000000000000000e+02), SC_(-3.3738830566406250000000000000000000000000e+02), SC_(1.4396093750000000000000000000000000000000e+02), SC_(9.9797696561938967233481685670351275504285e-01) }, 
      { SC_(2.2583898925781250000000000000000000000000e+02), SC_(4.7059277343750000000000000000000000000000e+02), SC_(4.8110961914062500000000000000000000000000e+02), SC_(1.0045370839403678094885983819734095280482e+00) }, 
      { SC_(2.4064727783203125000000000000000000000000e+02), SC_(2.4313244628906250000000000000000000000000e+02), SC_(-2.5241302490234375000000000000000000000000e+01), SC_(9.9956868458262201774926765165240721223391e-01) }, 
      { SC_(2.5126708984375000000000000000000000000000e+02), SC_(3.2124597167968750000000000000000000000000e+02), SC_(-2.4490490722656250000000000000000000000000e+02), SC_(9.9697050557993868496719715657438194438304e-01) }, 
      { SC_(2.6173120117187500000000000000000000000000e+02), SC_(-3.5070605468750000000000000000000000000000e+02), SC_(-2.6984399414062500000000000000000000000000e+02), SC_(1.0029440955622504123432909399947696491827e+00) }, 
      { SC_(2.6375000000000000000000000000000000000000e+02), SC_(4.5022204589843750000000000000000000000000e+02), SC_(-9.4109497070312500000000000000000000000000e+00), SC_(9.9992075039237587246879146010182205306644e-01) }, 
      { SC_(2.6551684570312500000000000000000000000000e+02), SC_(-4.4878356933593750000000000000000000000000e+02), SC_(2.9519995117187500000000000000000000000000e+02), SC_(9.9752571207922378499500009873424873777641e-01) }, 
      { SC_(2.7391711425781250000000000000000000000000e+02), SC_(4.5974389648437500000000000000000000000000e+02), SC_(7.3754638671875000000000000000000000000000e+01), SC_(1.0005858421906349963985855765556454843429e+00) }, 
      { SC_(2.9220727539062500000000000000000000000000e+02), SC_(3.7843066406250000000000000000000000000000e+02), SC_(4.5949243164062500000000000000000000000000e+02), SC_(1.0041638797684560593149320756621512436288e+00) }, 
      { SC_(2.9810583496093750000000000000000000000000e+02), SC_(3.0028039550781250000000000000000000000000e+02), SC_(-2.0297058105468750000000000000000000000000e+02), SC_(9.9773511249861368695030903074489543409392e-01) }, 
      { SC_(3.0753100585937500000000000000000000000000e+02), SC_(-2.2397491455078125000000000000000000000000e+02), SC_(2.0577423095703125000000000000000000000000e+02), SC_(9.9701699937223895470381479673430418968250e-01) }, 
      { SC_(3.0817541503906250000000000000000000000000e+02), SC_(-2.7618811035156250000000000000000000000000e+02), SC_(-4.8222619628906250000000000000000000000000e+02), SC_(1.0056817113332697933823605681340005184737e+00) }, 
      { SC_(3.1428479003906250000000000000000000000000e+02), SC_(-2.0016827392578125000000000000000000000000e+02), SC_(-2.5647509765625000000000000000000000000000e+02), SC_(1.0040852045181959166386631399212520283122e+00) }, 
      { SC_(3.1472363281250000000000000000000000000000e+02), SC_(-3.6452307128906250000000000000000000000000e+02), SC_(4.0579187011718750000000000000000000000000e+02), SC_(9.9646913231249277134534078280742311695748e-01) }, 
      { SC_(3.2084069824218750000000000000000000000000e+02), SC_(5.9570617675781250000000000000000000000000e+00), SC_(4.4007397460937500000000000000000000000000e+02), SC_(1.2542221647407933480773650336985701643284e+00) }, 
      { SC_(3.3500854492187500000000000000000000000000e+02), SC_(-3.7301318359375000000000000000000000000000e+02), SC_(4.6886779785156250000000000000000000000000e+02), SC_(9.9625496323957175957403384283666340287255e-01) }, 
      { SC_(4.1337585449218750000000000000000000000000e+02), SC_(-2.7896594238281250000000000000000000000000e+02), SC_(1.3235925292968750000000000000000000000000e+02), SC_(9.9885288090238247116006158310367961013934e-01) }, 
      { SC_(4.5716699218750000000000000000000000000000e+02), SC_(-3.9013830566406250000000000000000000000000e+02), SC_(-1.4624359130859375000000000000000000000000e+01), SC_(1.0000819976102168803390282401342006019679e+00) }, 
      { SC_(4.6488842773437500000000000000000000000000e+02), SC_(4.6769494628906250000000000000000000000000e+02), SC_(-3.4238696289062500000000000000000000000000e+02), SC_(9.9842650500965237149048741000997556591022e-01) }, 
      { SC_(4.8852160644531250000000000000000000000000e+02), SC_(-2.4571783447265625000000000000000000000000e+02), SC_(-1.6755175781250000000000000000000000000000e+02), SC_(1.0013967937499620519908303274499378625775e+00) }, 
      { SC_(4.9288122558593750000000000000000000000000e+02), SC_(4.5750683593750000000000000000000000000000e+02), SC_(4.9646130371093750000000000000000000000000e+02), SC_(1.0022040512881354342858258741438783825509e+00) }, 
      { SC_(4.9406848144531250000000000000000000000000e+02), SC_(3.2345776367187500000000000000000000000000e+02), SC_(3.2190319824218750000000000000000000000000e+02), SC_(1.0020163030217476522591853266650047605351e+00) }
   }};
//#undef SC_

