% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\docType{class}
\name{OutputStream}
\alias{OutputStream}
\alias{FileOutputStream}
\alias{BufferOutputStream}
\title{OutputStream classes}
\description{
\code{FileOutputStream} is for writing to a file;
\code{BufferOutputStream} writes to a buffer;
You can create one and pass it to any of the table writers, for example.
}
\section{Factory}{


The \verb{$create()} factory methods instantiate the \code{OutputStream} object and
take the following arguments, depending on the subclass:
\itemize{
\item \code{path} For \code{FileOutputStream}, a character file name
\item \code{initial_capacity} For \code{BufferOutputStream}, the size in bytes of the
buffer.
}
}

\section{Methods}{

\itemize{
\item \verb{$tell()}: return the position in the stream
\item \verb{$close()}: close the stream
\item \verb{$write(x)}: send \code{x} to the stream
\item \verb{$capacity()}: for \code{BufferOutputStream}
\item \verb{$finish()}: for \code{BufferOutputStream}
\item \verb{$GetExtentBytesWritten()}: for \code{MockOutputStream}, report how many bytes
were sent.
}
}

