.\"
.\" "$Id: mime.types.man 11022 2013-06-06 22:14:09Z msweet $"
.\"
.\"   mime.types man page for CUPS.
.\"
.\"   Copyright 2007-2013 by Apple Inc.
.\"   Copyright 1997-2006 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Apple Inc. and are protected by Federal copyright
.\"   law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\"   which should have been included with this file.  If this file is
.\"   file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH mime.types 5 "CUPS" "16 May 2009" "Apple Inc."
.SH NAME
mime.types \- mime type description file for cups
.SH DESCRIPTION
The \fImime.types\fR file defines the recognized file types.
.LP
Additional file types can be added to \fImime.types\fR or
(preferably) in additional files in the CUPS configuration
directory with the extension ".types".
.LP
Each line in the \fImime.types\fR file is a comment, blank, or
rule line. Comment lines start with the # character. Rule lines
start with the MIME type name and are optionally followed by a
series of file recognition rules that are used to automatically
identify print and web files:
.br
.nf

    super/type rule [ ... ruleN]
.fi
MIME type names are case-insensitive and are sorted in ascending alphanumeric
order for the purposes of matching. See the "TYPE MATCHING AND PRIORITY"
section for more information.
.LP
The rules may be grouped using parenthesis, joined using "+" for a
logical AND and "," or whitespace for a logical OR, and negated using
"!".
.SH RULES
Rules take two forms - a filename extension by itself and functions with test
values inside parenthesis. The following functions are available:
.TP 5
match("pattern")
.br
Pattern match on filename
.TP 5
ascii(offset,length)
.br
True if bytes are valid printable ASCII (CR, NL, TAB, BS, 32-126)
.TP 5
printable(offset,length)
.br
True if bytes are printable 8-bit chars (CR, NL, TAB, BS, 32-126, 128-254)
.TP 5
priority(number)
.br
Specifies the relative priority of this MIME type. The default priority is 100.
Larger values have higher priority while smaller values have lower priority.
.TP 5
string(offset,"string")
.br
True if bytes are identical to string
.TP 5
istring(offset,"string")
.br
True if a case-insensitive comparison of the bytes is identical
.TP 5
char(offset,value)
.br
True if byte is identical
.TP 5
short(offset,value)
.br
True if 16-bit integer is identical
.TP 5
int(offset,value)
.br
True if 32-bit integer is identical
.TP 5
locale("string")
.br
True if current locale matches string
.TP 5
contains(offset,range,"string")
.br
True if the range contains the string
.SH STRING CONSTANTS
String constants can be specified inside quotes ("") for strings
containing whitespace and angle brackets (<>) for hexadecimal
strings.
.SH TYPE MATCHING AND PRIORITY
When CUPS needs to determine the MIME type of a given file, it checks every
MIME type defined in the .types files. When two types have the same matching
rules, the type chosen will depend on the type name and priority, with higher-
priority types being used over lower-priority ones. If the types have the same
priority, the type names are sorted alphanumerically in ascending order and the
first type is chosen.
.LP
For example, if two types "text/bar" and "text/foo" are defined as matching the
extension "doc", normally the type "text/bar" will be chosen since its name is
alphanumerically smaller than "text/foo". However, if "text/foo" also defines a
higher priority than "text/bar", "text/foo" will be chosen instead.
.SH SEE ALSO
\fIclasses.conf(5)\fR, \fIcupsd(8)\fR, \fIcupsd.conf(5)\fR,
\fImime.convs(5)\fR, \fIprinters.conf(5)\fR,
.br
http://localhost:631/help
.SH COPYRIGHT
Copyright 2007-2013 by Apple Inc.
.\"
.\" End of "$Id: mime.types.man 11022 2013-06-06 22:14:09Z msweet $".
.\"
