.\" dpkg manual page - dpkg-gensymbols(1)
.\"
.\" Copyright © 2007-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2009-2010 Modestas Vainius <modestas@vainius.eu>
.\" Copyright © 2012-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-gensymbols 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
dpkg\-gensymbols \- Création des fichiers de symboles (information de
dépendances de bibliothèques partagées)
.
.SH SYNOPSIS
\fBdpkg\-gensymbols\fP [\fIoption\fP...]
.
.SH DESCRIPTION
\fBdpkg\-gensymbols\fP analyse un répertoire temporaire de construction (par
défaut debian/tmp), y recherche les bibliothèques et crée un fichier
\fIsymbols\fP qui les décrit. Si ce fichier n'est pas vide, il est installé
dans le sous\-répertoire DEBIAN du répertoire de construction afin de pouvoir
être inclus dans les informations de contrôle du paquet.
.P
Lors de la création de ces fichiers, il utilise en entrée certains fichiers
de symboles fournis par le responsable. Il recherche les fichiers suivants
(en utilisant le premier trouvé)\ :
.IP • 4
debian/\fIpaquet\fP.symbols.\fIarch\fP
.IP • 4
debian/symbols.\fIarch\fP
.IP • 4
debian/\fIpaquet\fP.symbols
.IP • 4
debian/symbols
.P
L'intérêt principal de ces fichiers est de fournir la version minimale
associée à chaque symbole fourni par les bibliothèques. En général, cela
correspond à la première version du paquet qui a fourni ce symbole, mais
cette valeur peut être augmentée manuellement par le responsable si
l'interface binaire applicative (ABI) du symbole est étendue sans casser la
compatibilité avec les versions précédentes. La tenue à jour de ces fichiers
est à la charge du responsable du paquet, avec l'aide de
\fBdpkg\-gensymbols\fP.
.P
Quand les fichiers de symboles créés sont différents de ceux fournis par le
responsable, \fBdpkg\-gensymbols\fP affichera les différences entre les deux
versions. Si ces différences sont trop importantes, le programme peut même
se terminer en échec (le nombre de différences tolérées peut être réglé avec
l'option \fB\-c\fP).
.SH "TENUE À JOUR DES FICHIERS SYMBOLES"
Les fichiers de symboles deviennent réellement utiles lorsqu'ils permettent
de suivre l'évolution du paquet sur plusieurs versions. En conséquence, le
responsable doit les mettre à jour chaque fois qu'un nouveau symbole est
ajouté afin que la version minimale associée corresponde à la réalité. Pour
effectuer cette opération correctement, le fichier de différences indiqué
dans le journal de construction peut être utilisé. Dans la plupart des cas,
ce fichier de différences peut être appliqué tel quel au fichier
debian/\fIpaquet\fP.symbols. Cela étant, quelques adaptations sont généralement
nécessaires\ : il est par exemple recommandé de retirer le numéro de révision
Debian de la version minimale afin que les paquets rétro\-portés, de numéro
de version inférieur mais avec la même version amont continuent à répondre
aux pré\-requis. Si le numéro de révision Debian ne peut vraiment pas être
retiré car le nouveau symbole est la conséquence d'une modification propre à
Debian, il est suggéré d'ajouter un suffixe «\ \fB~\fP\ » au numéro de version.
.P
Avant d'appliquer le correctif au fichier de symboles, le responsable doit
contrôler qu'il est correct. Les symboles publics sont supposés ne jamais
disparaître et le correctif ne devrait donc qu'ajouter des lignes.
.P
Veuillez noter qu'il est possible de placer des commentaires dans les
fichiers de symboles\ :\ toute ligne commençant par «\ #\ » est un commentaire
sauf si elle commence par «\ #include\ » (voir la section \fButilisation des
inclusions\fP). Les lignes commençant par «\ #MISSING:\ » sont des commentaires
spéciaux qui indiquent les symboles qui peuvent avoir disparu.
.P
N'oubliez pas de vérifier si les anciennes versions des symboles ne doivent
pas être incrémentées. Il n'y a pas de moyen pour que \fBdpkg\-gensymbols\fP
prévienne de cela. Appliquer aveuglement le fichier de différences ou
supposer qu'il n'y a rien à changer, s'il n'y a pas de fichier de
différences, sans vérifier s'il y a ces modifications, peut faire que des
paquets, avec des dépendances lâches, prétendent qu'ils peuvent fonctionner
avec des paquets plus anciens avec lesquels ils ne peuvent fonctionner. Cela
introduira des bogues difficiles à trouver avec des mises à niveau
(partielles).
.SS "Utilisation du remplacement de #PACKAGE#"
.P
Dans de rares cas, le nom de la bibliothèque dépend de l'architecture. Afin
d'éviter de coder le nom du paquet en dur dans le fichier de symboles, il
est possible d'utiliser le marqueur \fI#PACKAGE#\fP. Il sera remplacé par le
vrai nom du paquet lors de l'installation des fichiers de symboles. À la
différence du marqueur \fI#MINVER#\fP, \fI#PACKAGE#\fP n'apparaîtra jamais dans le
fichier de symboles d'un paquet binaire.
.SS "Utilisation des étiquettes de symbole"
.P
L'étiquetage des symboles («\ symbol tagging\ ») est utile pour marquer des
symboles qui sont particuliers d'une manière ou d'une autre. Tout symbole
peut avoir un nombre quelconque d'étiquettes associées. Bien que toutes les
étiquettes soient analysées et conservées, seules certaines d'entre elles
sont comprises par \fBdpkg\-gensymbols\fP et déclenchent un traitement
spécifique des symboles. Veuillez consulter la sous\-section \fBÉtiquettes
standard de symbole\fP pour une référence complète à propos de ces étiquettes.
.P
L'indication de l'étiquette vient juste avant le nom du symbole (sans
espace). Elle commence toujours par une parenthèse ouvrante \fB(\fP, se termine
avec une parenthèse fermante \fB)\fP et doit contenir au moins une
étiquette. Les étiquettes multiples doivent être séparées par le caractère
\fB|\fP. Chaque étiquette peut comporter optionnellement une valeur, séparée du
nom de l'étiquette par le caractère \fB=\fP. Les noms et valeurs des étiquettes
sont des chaînes quelconques qui ne doivent pas comporter les caractères
\fB)\fP \fB|\fP et \fB=\fP. Les noms de symbole qui suivent une étiquette peuvent
optionnellement être mis entre guillemets avec les caractères \fB'\fP ou \fB"\fP
afin d'y autoriser la présence d'espaces. Cependant, si aucune étiquette
n'est utilisée, les guillemets sont alors traités comme une partie du nom du
symbole, qui s'arrête alors au premier espace.
.P
 (étiq1=je suis marqué|étiquette avec espace)"symbole comportant des espaces"@Base 1.0
 (optional)symbole_non_protégé@Base 1.0 1
 symbole_non_étiqueté@Base 1.0
.P
Le premier symbole de cet exemple est appelé \fIsymbole comportant des
espaces\fP et utilise deux étiquettes\ :\ \fIétiq1\fP avec la valeur \fIje suis
marqué\fP et \fIétiquette avec espace\fP sans valeur. Le deuxième symbole, appelé
\fIsymbole_non_protégé\fP ne comporte que l'étiquette \fIoptional\fP. Le dernier
symbole est un exemple de symbole normal sans étiquette.
.P
Comme les étiquettes de symbole sont une extension du format de
\fBdeb\-symbols(5)\fP, elles ne peuvent apparaître que dans les fichiers de
symboles des paquets source (ces fichiers peuvent ensuite être vus comme des
modèles permettant de construire les fichiers de symboles inclus dans les
paquets binaires). Lorsque \fBdpkg\-gensymbols\fP est lancé sans l'option \fB\-t\fP,
il affiche les fichiers de symboles compatibles avec le format
\fBdeb\-symbols(5)\fP\ : il traite entièrement les symboles d'après les exigences
des étiquettes standard et supprime les étiquettes dans sa sortie. Au
contraire, dans le mode modèle («\ template\ », option \fB\-t\fP), tous les
symboles et leurs étiquettes (standard et inconnues) sont conservés dans la
sortie et écrits dans leur forme d'origine.
.SS "Étiquettes standard de symbole"
.TP 
\fBoptional\fP
Un symbole marqué comme optionnel peut disparaître de la bibliothèque à tout
moment et ne provoquera pas l'échec de \fBdpkg\-gensymbols\fP. Cependant, les
symboles optionnels disparus apparaîtront en permanence comme manquants dans
le fichier de différences, à chaque nouvelle version du paquet. Ce
comportement sert de rappel au responsable qu'un tel symbole doit être
supprimé du fichier de symboles ou bien rajouté à la bibliothèque. Un tel
symbole optionnel, précédemment déclaré comme manquant («\ MISSING\ »), peut
réapparaître soudainement dans la version suivante en étant remis à l'état
existant («\ existing\ »), sans modification de sa version minimale.

Cette étiquette est utile pour les symboles qui sont privés car leur
disparition ne provoque pas de changement d'interface applicative (ABI). Par
exemple, la plupart des modèles d'instanciation C++ sont dans cette
catégorie. Comme toute autre étiquette, celle\-ci peut comporter une valeur
arbitraire qui peut servir à indiquer pour quelle raison le symbole est
optionnel.
.TP 
\fBarch=\fP\fIliste\-d'architectures\fP
.TQ
\fBarch\-bits=\fP\fIoctets\-architecture\fP
.TQ
\fBarch\-endian=\fP\fIboutisme\-d'architecture\fP
Ces étiquettes permettent de restreindre la liste des architectures avec
lesquelles le symbole est censé exister. Les étiquettes \fBarch\-bits\fP et
\fBarch\-endian\fP sont prises en charge depuis dpkg\ 1.18.0. Lorsque la liste
des symboles est mise à jour avec ceux découverts dans la bibliothèque, tous
les symboles spécifiques d'architectures qui ne concernent pas
l'architecture en cours sont ignorés. Si un symbole propre à l'architecture
en cours n'existe pas dans la bibliothèque, les processus normaux pour des
symboles manquants s'appliquent jusqu'à éventuellement provoquer l'échec de
\fBdpkg\-gensymbols\fP. D'un autre côté, si le symbole propre à une architecture
est trouvé alors qu'il n'est pas censé exister (parce que l'architecture
courante n'est pas mentionnée dans l'étiquette ou ne correspond pas au
boutisme et aux octets), il est rendu indépendant de l'architecture
(c'est\-à\-dire que les étiquettes d'architecture, d'octets de l'architecture
et de boutisme d'architecture sont abandonnées et le symbole apparaît dans
le fichier de différences) mais non considéré comme nouveau. (NdT\ : une
aspirine peut être nécessaire après la lecture de ce paragraphe)

Dans le mode de fonctionnement par défaut (pas en mode «\ modèle\ »), seuls
les symboles spécifiques de certaines architectures qui correspondent à
l'architecture courante sont écrits dans le fichier de symboles. Au
contraire, tous les symboles spécifiques d'architectures (y compris ceux des
architectures différentes) seront écrits dans le fichier de symboles, dans
le mode «\ modèle\ ».

Le format de \fIliste\-d'architectures\fP est le même que le format utilisé dans
les champs \fBBuild\-Depends\fP des fichiers \fIdebian/control\fP (à l'exception
des crochets d'inclusion []). Par exemple, le premier symbole de la liste
qui suit sera pris en compte sur les architectures alpha, n'importe quelle
amd64 et ia64, le second uniquement sur les architectures linux et le
troisième partout sauf sur armel.

 (arch=alpha any\-amd64 ia64)un_symbole_spécifique_64bit@Base 1.0
 (arch=linux\-any)un_symbole_spécifique_linux@Base 1.0
 (arch=!armel)un_symbole_inexistant_sur_armel@Base 1.0

Les \fIoctets\-architecture\fP sont soit \fB32\fP soit \fB64\fP.

 (arch\-bits=32)32bit_specific_symbol@Base 1.0
 (arch\-bits=64)64bit_specific_symbol@Base 1.0

Le \fIboutisme\-d'architecture\fP est soit \fBlittle\fP soit \fBbig\fP.

 (arch\-endian=little)little_endian_specific_symbol@Base 1.0
 (arch\-endian=big)big_endian_specific_symbol@Base 1.0

Plusieurs restrictions peuvent être chaînées.

 (arch\-bits=32|arch\-endian=little)32bit_le_symbol@Base 1.0
.TP 
\fBignore\-blacklist\fP
\fBdpkg\-gensymbols\fP comporte une liste interne de symboles ignorés qui ne
devraient pas apparaître dans les fichiers de symboles car ils sont en
général uniquement des effets de bord de détails de mise en œuvre de la
chaîne d'outils de construction. Si, pour une raison précise, vous voulez
vraiment inclure un de ces symboles dans le fichier, vous pouvez imposer
qu'il soit ignoré, avec \fBignore\-blacklist\fP. Cela peut être utile pour
certaines bibliothèques de bas niveau telles que libgcc.
.TP 
\fBc++\fP
Indique un motif de symbole \fIc++\fP. Voir la sous\-section \fBUtilisation de
motifs de symbole\fP plus loin.
.TP 
\fBsymver\fP
Indique un motif de symbole \fIsymver\fP (version de symbole). Voir la
sous\-section \fBUtilisation des motifs de symbole\fP plus loin.
.TP 
\fBregex\fP
Indique un motif de symbole basé sur une \fIexpression\-rationnelle\fP. Voir la
sous\-section \fBUtilisation des motifs de symbole\fP plus loin.
.SS "Utilisation de motifs de symbole"
.P
Au contraire d'une indication normale de symbole, un motif permet de couvrir
des symboles multiples de la bibliothèque. \fBdpkg\-gensymbols\fP essaie de
faire correspondre chaque motif à chaque symbole qui n'est pas explicitement
défini dans le fichier de symboles. Dès qu'un motif est trouvé qui
correspond au symbole, l'ensemble de ses étiquettes et propriétés sont
utilisées comme spécification de base du symbole. Si aucun des motifs ne
correspond, le symbole sera considéré comme nouveau.

Un motif est considéré comme perdu si aucun symbole ne lui correspond dans
la bibliothèque. Par défaut, cela provoquera un échec de \fBdpkg\-gensymbols\fP
s'il est utilisé avec l'option \fB\-c1\fP (ou une valeur plus
élevée). Cependant, si l'échec n'est pas souhaité, le motif peut être marqué
comme optionnel avec l'étiquette \fIoptional\fP. Dans ce cas, si le motif ne
correspond à rien, il sera simplement mentionné dans le fichier de
différences comme \fIMISSING\fP (manquant). De plus, comme pour tout autre
symbole, le motif peut être limité à des architectures données avec
l'étiquette \fIarch\fP. Veuillez consulter la sous\-section \fBÉtiquettes
standard de symbole\fP pour plus d'informations.

Les motifs sont une extension du format de \fBdeb\-symbols(5)\fP en ce sens
qu'ils ne sont valables que dans les modèles de fichiers de
symboles. Cependant, la partie comportant le nom de symbole est utilisée
comme une expression à faire correspondre à \fIname@version\fP du symbole
réel. Afin de faire la distinction entre les différents types de motifs, un
motif sera usuellement marqué avec une étiquette spéciale.

Actuellement, \fBdpkg\-gensymbols\fP gère trois types de base de motifs\ :
.TP  3
\fBc++\fP
Ce motif est repéré par l'étiquette \fIc++\fP. Il ne sera comparé qu'aux
symboles C++ avec leur nom de symbole rétabli (demangled) tel qu'affiché
avec l'utilitaire \fBc++filt\fP. Ce motif est très pratique pour faire
correspondre les symboles dont les noms décorés (mangled) peuvent différer
selon les architectures bien que leurs noms d'origine restent les mêmes. Un
tel groupe de symboles sont les \fInon\-virtual thunks\fP pour lesquels les
décalages (offsets) spécifiques d'architectures sont inclus dans leur nom
décoré. Une manifestation usuelle de ce cas est le destructeur virtuel qui,
dans le contexte d'un «\ problème du diamant\ », a besoin d'un symbole de
transition spécial (ou «\ thunk\ ») non virtuel. Par exemple, même si
_ZThn8_N3NSB6ClassDD1Ev@Base sur une architecture 32\ bits est identique à
_ZThn16_N3NSB6ClassDD1Ev@Base sur une architecture 64\ bits, les deux peuvent
être indiqués avec le même motif \fIc++\fP\ :

libdummy.so.1 libdummy1 #MINVER#
 [...]
 (c++)"non\-virtual thunk to NSB::ClassD::~ClassD()@Base" 1.0
 [...]

Le nom non décoré ci\-dessus peut être obtenu avec la commande suivante\ :

 $ echo '_ZThn8_N3NSB6ClassDD1Ev@Base' | c++filt

Veuillez noter que, bien que le nom décoré soit unique dans la bibliothèque
par définition, cela n'est pas forcément vrai pour le nom non décoré. Deux
symboles réels différents peuvent avoir le même nom non décoré. C'est par
exemple le cas avec les symboles «\ thunk\ » non virtuels dans des
configurations d'héritage complexes ou avec la plupart des constructeurs et
destructeurs (puisque g++ crée usuellement deux symboles réels pour
eux). Cependant, comme ces collisions se produisent au niveau de l'interface
applicative binaire (ABI), elles ne devraient pas dégrader la qualité du
fichier de symboles.
.TP 
\fBsymver\fP
Ce motif est indiqué par l'étiquette \fIsymver\fP. Les bibliothèques bien
gérées utilisent des symboles versionnés où chaque version correspond à la
version amont à laquelle le symbole a été ajouté. Si c'est le cas, il est
possible d'utiliser un motif \fIsymver\fP pour faire correspondre chaque
symbole associé à la version spécifique. Par exemple\ :

libc.so.6 libc6 #MINVER#
 (symver)GLIBC_2.0 2.0
 [...]
 (symver)GLIBC_2.7 2.7
 access@GLIBC_2.0 2.2

Tous les symboles associés avec les versions GLIBC_2.0 et GLIBC_2.7
conduiront respectivement à des versions minimales de\ 2.0 et\ 2.7, à
l'exception du symbole access@GLIBC_2.0. Ce dernier amène à une dépendance
minimale sur la version\ 2.2 de libc6 bien qu'il soit dans le scope de
«\ (symvar)GLIBC_2.0\ ». Cela est dû au fait que les symboles spécifiques
prennent le pas sur les motifs.

Veuillez noter que les anciens motifs avec caractères génériques (indiqués
sous la forme «\ *@version\ ») dans le champ de nom de symbole sont toujours
gérés. La nouvelle syntaxe «\ (symver|optional)version\ » doit toutefois leur
être préférée. Par exemple, «\ *@GLIBC_2.0\ 2.0\ » devrait être écrit sous la
forme «\ (symver|optional)GLIBC_2.0\ 2.0\ » si un comportement analogue est
recherché.
.TP 
\fBregex\fP
Les motifs d'expressions rationnelles sont indiqués par l'étiquette
\fIexpression\-rationnelle\fP. La correspondance se fait avec une expression
rationnelle Perl sur le champ de nom de symbole. La correspondance est faite
telle quelle et il ne faut donc pas oublier le caractère \fI^\fP, sinon la
correspondance est faite sur n'importe quelle partie du symbole réel
\fIname@version\fP. Par exemple\ :

libdummy.so.1 libdummy1 #MINVER#
 (regex)"^mystack_.*@Base$" 1.0
 (regex|optional)"private" 1.0

Les symboles tels que «\ mystack_new@Base\ », «\ mystack_push@Base\ »,
«\ mystack_pop@Base\ », etc., seront en correspondance avec le premier motif
alors que, par exemple, «\ ng_mystack_new@Base\ » ne le sera pas. Le deuxième
motif correspondra pour tous les symboles qui comportent la chaîne
«\ private\ » dans leur nom et les correspondances hériteront de l'étiquette
\fIoptional\fP depuis le motif.
.P
Les motifs de base indiqués précédemment peuvent être combinés au
besoin. Dans ce cas, ils sont traités dans l'ordre où les étiquettes sont
indiquées. Par exemple, les deux motifs

 (c++|regex)"^NSA::ClassA::Private::privmethod\ed\e(int\e)@Base" 1.0
 (regex|c++)N3NSA6ClassA7Private11privmethod\edEi@Base 1.0

seront en correspondance avec les symboles
«\ _ZN3NSA6ClassA7Private11privmethod1Ei@Base"\ » et
«\ _ZN3NSA6ClassA7Private11privmethod2Ei@Base\ ». Lors de la correspondance
avec le premier motif, le symbole brut est d'abord rétabli d’origine en tant
que symbole C++, puis comparé à l'expression rationnelle. D'un autre côté,
lors de la correspondance avec le deuxième motif, l'expression rationnelle
est comparée au nom de symbole brut, puis le symbole est testé en tant que
symbole C++ en tentant de le rétablir d’origine. L'échec de n'importe quel
motif basique provoquera l'échec de l'ensemble du motif. Ainsi, par exemple,
«\ __N3NSA6ClassA7Private11privmethod\edEi@Base\ » ne correspondra à aucun des
motifs car ce n'est pas un symbole C++ valable (NdT\ :\ j'ai l'impression de
traduire du Klingon\ !).

En général, les motifs sont divisés en deux groupes\ :\ les alias (\fIc++\fP et
\fIsymver\fP basique) et les motifs génériques (\fIexpression\-rationnelle\fP et
toutes les combinaisons de motifs basiques multiples). La correspondance de
motifs basés sur des alias est rapide (O(1)) alors que les motifs génériques
sont O(N) (N étant le nombre de motifs génériques) pour chaque symbole. En
conséquence, il est déconseillé d'abuser des motifs génériques.

Lorsque plusieurs motifs correspondent pour le même symbole réel, les alias
(d'abord \fIc++\fP, puis \fIsymver\fP) sont privilégiés par rapport aux motifs
génériques. Ceux\-ci sont essayés dans l'ordre où ils apparaissent dans le
modèle de fichier de symboles, en s'arrêtant à la première
correspondance. Veuillez noter, cependant, que la modification manuelle de
l'ordre des entrées de fichiers n'est pas recommandée car \fBdpkg\-gensymbols\fP
crée des fichiers de différences d'après l'ordre alphanumérique de leur nom.
.SS "Utilisation des inclusions"
.P
Lorsqu'un jeu de symboles exportés varie selon les architectures, il est
souvent peu efficace d'utiliser un seul fichier de symboles. Pour couvrir
ces cas, une directive d'inclusion peut devenir utile dans certains cas\ :
.IP • 4
Il est possible de factoriser la partie commune dans un fichier externe
donné et l'inclure dans le fichier \fIpaquet\fP.symbols.\fIarch\fP avec une
directive «\ include\ » utilisée de la manière suivante\ :

#include "\fIpaquets\fP.symbols.common"
.IP •
La directive d'inclusion peut également être étiquetée comme tout autre
symbole\ :

(étiquette|...|étiquetteN)#include "fichier_à_inclure"

Le résultat sera que tous les symboles inclus depuis \fIfichier_à_inclure\fP
seront considérés comme étiquetés par défaut avec \fIetiq\fP ... \fIetiqN\fP. Cela
permet de créer un fichier \fIpaquet\fP.symbols commun qui inclut les fichiers
de symboles spécifiques des architectures\ :

  symbole_commun1@Base 1.0
 (arch=amd64 ia64 alpha)#include "package.symbols.64bit"
 (arch=!amd64\ !ia64\ !alpha)#include "package.symbols.32bit"
  symbole_commun2@Base 1.0
.P
Les fichiers de symboles sont lus ligne par ligne et les directives
d'inclusion sont traitées dès qu'elles sont trouvées. En conséquence, le
contenu du fichier d'inclusion peut remplacer une définition qui précède
l'inclusion et ce qui suit l'inclusion peut remplacer une définition qu'elle
ajoutait. Tout symbole (ou même une autre directive d'inclusion) dans le
fichier inclus peut définir des étiquettes supplémentaires ou remplacer les
valeurs d'étiquettes héritées, dans sa définition d'étiquettes. Cependant,
pour un symbole donné, il n'existe pas de méthode permettant de remplacer
une de ses étiquettes héritées.
.P
Un fichier inclus peut reprendre la ligne d'en\-tête qui contient le
«\ SONAME\ » de la bibliothèque. Dans ce cas, cela remplace toute ligne
d'en\-tête précédente. Il est cependant déconseillé de dupliquer les lignes
d'en\-tête. Une façon de le faire est la méthode suivante\ :
.PP
#include "libmachin1.symbols.common"
 symboles_specifique_architecture@Base 1.0
.SS "Bonnes pratiques de gestion des bibliothèques"
.P
Une bibliothèque bien maintenue offre les possibilités suivantes\ :
.IP • 4
son interface de programmation (API) est stable (les symboles publics ne
sont jamais supprimés et les changements ne concernent que des ajouts de
nouveaux symboles publics) et les modifications provoquant une
incompatibilité doivent être combinés avec un changement de SONAME\ ;
.IP • 4
idéalement, elle utilise le versionnage des symboles pour garantir la
stabilité de l'interface applicative binaire (ABI) malgré ses modifications
internes et l'extension de son API\ ;
.IP • 4
elle n'exporte pas les symboles privés (afin de contourner cela, de tels
symboles peuvent être étiquetés comme optionnels).
.P
En maintenant le fichier de symboles, il est facile d'en voir apparaître et
disparaître. Cependant, il est plus difficile de contrôler la présence
d'éventuelles modifications d'API ou ABI. En conséquence, le responsable
doit contrôler soigneusement le journal des modifications amont, à la
recherche de cas où une saine gestion des bibliothèques peut avoir été
omise. Si des problèmes potentiels sont découverts, l'auteur amont doit être
averti(e) car une correction en amont est meilleure qu'un travail spécifique
au paquet Debian.
.SH OPTIONS
.TP 
\fB\-P\fP\fIrépertoire\-construction\-paquet\fP
Analyse de \fIrépertoire\-construction\-paquet\fP, plutôt que debian/tmp.
.TP 
\fB\-p\fP\fIpaquet\fP
Définit le nom du paquet. Requis si plus d'un paquet binaire est indiqué
dans debian/control (ou s'il n'y a pas de fichier debian/control).
.TP 
\fB\-v\fP\fIversion\fP
Définit la version du paquet. La valeur par défaut est la version extraite
de debian/changelog. Ce paramètre est requis si le programme est lancé en
dehors de l'arborescence source d'un paquet.
.TP 
\fB\-e\fP\fIfichier\-bibliothèque\fP
N'analyse que les bibliothèques explicitement mentionnées au lieu de
rechercher toutes les bibliothèques publiques. Les motifs du shell peuvent
être utilisés pour l'expansion des chemins d'accès (voir la page de manuel
de \fBFile::Glob\fP(3perl) pour plus d'informations) dans
\fIfichier\-bibliothèque\fP pour établir une correspondance avec plusieurs
bibliothèques avec un seul paramètre (afin d'éviter d'utiliser plusieurs
options \fB\-e\fP).
.TP 
\fB\-l\fP\fIrépertoire\fP
Ajoute \fIrépertoire\fP au début de la liste des répertoires où chercher des
bibliothèques partagées privées (depuis dpkg\ 1.19.1). Cette option peut être
utilisée plusieurs fois.

Note\ : Utilisez cette option plutôt que le réglage de \fBLD_LIBRARY_PATH\fP,
parce que cette variable d'environnement est utilisée pour contrôler
l'éditeur de liens d'exécution et se servir d'elle pour définir les chemins
des bibliothèques partagées au moment de la construction peut être
problématique, par exemple, lors d'une compilation croisée.
.TP 
\fB\-I\fP\fInom\-de\-fichier\fP
Utilise \fInom\-de\-fichier\fP comme fichier de référence pour créer le fichier
de symboles à intégrer dans le paquet lui\-même.
.TP 
\fB\-O\fP[\fInom\-de\-fichier\fP]
Affiche le fichier de symboles créé sur la sortie standard ou dans le
\fInom\-de\-fichier\fP, si spécifié, plutôt que dans \fBdebian/tmp/DEBIAN/symbols\fP
(ou \fIrépertoire\-construction\-paquet\fP\fB/DEBIAN/symbols\fP si \fB\-P\fP est
présent). Si \fInom\-de\-fichier\fP existe déjà, son contenu sera utilisé comme
base pour le fichier créé. Cette fonctionnalité permet de mettre à jour le
fichier de symboles pour qu'il corresponde à une nouvelle version amont de
la bibliothèque.
.TP 
\fB\-t\fP
Écrit le fichier de symboles en mode modèle plutôt que dans un format
compatible avec \fBdeb\-symbols\fP(5). La différence majeure réside dans le fait
que les noms de symboles et les étiquettes sont écrits dans leur forme
d'origine au lieu d'être interprétés, avec réduction des étiquettes en mode
de compatibilité. De plus, certains symboles peuvent être omis lors de
l'écriture d'un fichier \fBdeb\-symbols\fP(5) standard (selon les règles de
traitement des étiquettes) alors que tous les symboles sont écrits lors de
la création d'un modèle de fichier de symboles.
.TP 
\fB\-c\fP\fI[0\-4]\fP
Définit les contrôles à effectuer lors de la comparaison du fichier de
symboles créé en utilisant le fichier de modèle comme point de départ. Le
niveau par défaut est\ 1. Plus le niveau est augmenté, plus le nombre de
contrôles effectués est important. Chaque niveau de contrôle comporte les
contrôles effectués pour les niveaux inférieurs. Le niveau\ 0 n'échoue
jamais. Le niveau\ 1 échoue si certains symboles ont disparu. Le niveau\ 2
échoue si de nouveaux symboles ont été ajoutés. Le niveau\ 3 échoue si
certaines bibliothèques ont disparu. Le niveau\ 4 échoue si des bibliothèques
ont été ajoutées.

Cette valeur peut être remplacée par la valeur de la variable
d'environnement \fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP.
.TP 
\fB\-q\fP
Fonctionne en mode silencieux et ne crée jamais de fichier de différences
entre le fichier de symboles créé et le fichier modèle utilisé comme point
de départ. N'affiche également aucun avertissement à propos de bibliothèques
nouvelles ou disparues ou de symboles nouveaux ou disparus. Cette option ne
désactive que l'affichage informatif, mais pas les contrôles eux\-mêmes (voir
l'option \fB\-c\fP).
.TP 
\fB\-a\fP\fIarch\fP
Définit \fIarch\fP comme architecture lors du traitement des fichiers de
symboles. Cette option permet de créer un fichier de symboles ou un fichier
de différences pour n'importe quelle architecture, à condition que les
fichiers binaires correspondants soient déjà disponibles.
.TP 
\fB\-d\fP
Active le mode bavard. De nombreux messages sont affichés pour expliquer ce
que \fBdpkg\-gensymbols\fP fait.
.TP 
\fB\-V\fP
Active le mode bavard. Le fichier de symboles créé contiendra les symboles
dépréciés sous forme de commentaires. De plus, en mode modèle, les motifs de
symboles seront suivis de commentaires affichant les symboles réels qui
correspondent au motif.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH ENVIRONNEMENT
.TP 
\fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP
Remplace le niveau de vérification de commande, même si l'argument en ligne
de commande \fB\-c\fP a été donné (notez que cela va à l'encontre de la
convention générale qui veut que les arguments en ligne de commande ont la
préséance sur les variables d'environnement).
.TP 
\fBDPKG_COLORS\fP
Définit le mode de couleur (depuis dpkg\ 1.18.5). Les valeurs actuellement
acceptées sont \fBauto\fP (par défaut), \fBalways\fP et \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Si cette variable est définie, elle sera utilisée pour décider l'activation
de la prise en charge des langues (NLS –\ Native Language Support), connu
aussi comme la gestion de l'internationalisation (ou i18n) (depuis
dpkg\ 1.19.0). Les valeurs permises sont\ : \fB0\fP et \fB1\fP (par défaut).
.
.SH "VOIR AUSSI"
\fBhttps://people.redhat.com/drepper/symbol\-versioning\fP
.br
\fBhttps://people.redhat.com/drepper/goodpractice.pdf\fP
.br
\fBhttps://people.redhat.com/drepper/dsohowto.pdf\fP
.br
\fBdeb\-symbols\fP(5), \fBdpkg\-shlibdeps\fP(1).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
