#include<stdio.h>
typedef unsigned short UINT16;

static UINT16 HuffCodeLEC[] = {
        0x0004, 0x0024, 0x0014, 0x0011, 0x0051, 0x0031, 0x0071, 0x0009, 0x0049, 0x0029, 0x0069, 0x0015, 0x0095, 
0x0055, 0x00d5, 0x0035, 0x00b5, 0x0075, 0x001d, 0x00f5, 0x011d, 0x009d, 0x019d, 0x005d, 0x000d, 0x008d, 0x015d, 
0x00dd, 0x01dd, 0x003d, 0x013d, 0x00bd, 0x004d, 0x01bd, 0x007d, 0x006b, 0x017d, 0x00fd, 0x01fd, 0x0003, 0x0103, 
0x0083, 0x0183, 0x026b, 0x0043, 0x016b, 0x036b, 0x00eb, 0x0143, 0x00c3, 0x02eb, 0x01c3, 0x01eb, 0x0023, 0x03eb, 
0x0123, 0x00a3, 0x01a3, 0x001b, 0x021b, 0x0063, 0x011b, 0x0163, 0x00e3, 0x00cd, 0x01e3, 0x0013, 0x0113, 0x0093, 
0x031b, 0x009b, 0x029b, 0x0193, 0x0053, 0x019b, 0x039b, 0x005b, 0x025b, 0x015b, 0x035b, 0x0153, 0x00d3, 0x00db,
0x02db, 0x01db, 0x03db, 0x003b, 0x023b, 0x013b, 0x01d3, 0x033b, 0x00bb, 0x02bb, 0x01bb, 0x03bb, 0x007b, 0x002d,
0x027b, 0x017b, 0x037b, 0x00fb, 0x02fb, 0x01fb, 0x03fb, 0x0007, 0x0207, 0x0107, 0x0307, 0x0087, 0x0287, 0x0187, 
0x0387, 0x0033, 0x0047, 0x0247, 0x0147, 0x0347, 0x00c7, 0x02c7, 0x01c7, 0x0133, 0x03c7, 0x0027, 0x0227, 0x0127, 
0x0327, 0x00a7, 0x00b3, 0x0019, 0x01b3, 0x0073, 0x02a7, 0x0173, 0x01a7, 0x03a7, 0x0067, 0x00f3, 0x0267, 0x0167, 
0x0367, 0x00e7, 0x02e7, 0x01e7, 0x03e7, 0x01f3, 0x0017, 0x0217, 0x0117, 0x0317, 0x0097, 0x0297, 0x0197, 0x0397, 
0x0057, 0x0257, 0x0157, 0x0357, 0x00d7, 0x02d7, 0x01d7, 0x03d7, 0x0037, 0x0237, 0x0137, 0x0337, 0x00b7, 0x02b7, 
0x01b7, 0x03b7, 0x0077, 0x0277, 0x07ff, 0x0177, 0x0377, 0x00f7, 0x02f7, 0x01f7, 0x03f7, 0x03ff, 0x000f, 0x020f, 
0x010f, 0x030f, 0x008f, 0x028f, 0x018f, 0x038f, 0x004f, 0x024f, 0x014f, 0x034f, 0x00cf, 0x000b, 0x02cf, 0x01cf, 
0x03cf, 0x002f, 0x022f, 0x010b, 0x012f, 0x032f, 0x00af, 0x02af, 0x01af, 0x008b, 0x03af, 0x006f, 0x026f, 0x018b, 
0x016f, 0x036f, 0x00ef, 0x02ef, 0x01ef, 0x03ef, 0x001f, 0x021f, 0x011f, 0x031f, 0x009f, 0x029f, 0x019f, 0x039f, 
0x005f, 0x004b, 0x025f, 0x015f, 0x035f, 0x00df, 0x02df, 0x01df, 0x03df, 0x003f, 0x023f, 0x013f, 0x033f, 0x00bf, 
0x02bf, 0x014b, 0x01bf, 0x00ad, 0x00cb, 0x01cb, 0x03bf, 0x002b, 0x007f, 0x027f, 0x017f, 0x012b, 0x037f, 0x00ff, 
0x02ff, 0x00ab, 0x01ab, 0x006d, 0x0059, 0x17ff, 0x0fff, 0x0039, 0x0079, 0x01ff, 0x0005, 0x0045, 0x0034, 0x000c, 
0x002c, 0x001c, 0x0000, 0x003c, 0x0002, 0x0022, 0x0010, 0x0012, 0x0008, 0x0032, 0x000a, 0x002a, 0x001a, 0x003a, 
0x0006, 0x0026, 0x0016, 0x0036, 0x000e, 0x002e, 0x001e, 0x003e, 0x0001, 0x00ed, 0x0018, 0x0021, 0x0025, 0x0065 };

UINT16 HashTable[512] = { [0 ... 511] = 0xffff };

static UINT16 tab[8] = {511, 0, 508, 448, 494, 347, 486, 482};

UINT16 hash(UINT16 key)
{
        UINT16 h;
        h = (key & 0x1ff) ^ (key  >> 9) ^ (key >> 4) ^ (key >> 7);
        return h;
}

UINT16 minihash(UINT16 key)
{
        UINT16 h;
        h = ((((key >> 8) ^ (key & 0xff)) >> 2) & 0xf);
        if(key >> 9)
                h = ~h;
        return (h % 12);
}

void buildhashtable(void)
{
        int i,j;
        UINT16 h;
        for(i=0;i<293;i++)
        {
                h=hash(HuffCodeLEC[i]);
                if(HashTable[h]!=0xffff)
                {
                        HashTable[h] ^= (HuffCodeLEC[i] & 0xfe00) ^ 0xfe00;
                        HashTable[tab[minihash(HuffCodeLEC[i])]] = i;
                }
                else
                {
                        HashTable[h] = i;
                        HashTable[h] ^= 0xfe00;
                }
        }
}

UINT16 getvalue(UINT16 huff)
{
        UINT16 h = HashTable[hash(huff)];
        if((h ^ huff) >> 9)
                return h & 0x1ff;
        else
                return HashTable[tab[minihash(huff)]];
}

main()
{
        int i;
        buildhashtable();
        printf("static UINT16 HuffIndexLEC[512] = {\n");
        for(i=0;i<512;i++)
        {
                if(i == 511)
                        printf("0x%04x };\n",HashTable[i]);
                else
                        printf("0x%04x, ",HashTable[i]);
        }
        for(i=0;i<293;i++)
                if(i != getvalue(HuffCodeLEC[i]))
                        printf("Fail :( at %d : 0x%04x\n",i,HuffCodeLEC[i]);
        return 0;
}
