/* math-buttons.c generated by valac 0.40.6, the Vala compiler
 * generated from math-buttons.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libcalculator.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
typedef struct _MathButtonsPrivate MathButtonsPrivate;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
enum  {
	MATH_BUTTONS_0_PROPERTY,
	MATH_BUTTONS_MODE_PROPERTY,
	MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY,
	MATH_BUTTONS_NUM_PROPERTIES
};
static GParamSpec* math_buttons_properties[MATH_BUTTONS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MATH_VARIABLE_POPOVER (math_variable_popover_get_type ())
#define MATH_VARIABLE_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLE_POPOVER, MathVariablePopover))
#define MATH_VARIABLE_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLE_POPOVER, MathVariablePopoverClass))
#define IS_MATH_VARIABLE_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLE_POPOVER))
#define IS_MATH_VARIABLE_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLE_POPOVER))
#define MATH_VARIABLE_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLE_POPOVER, MathVariablePopoverClass))

typedef struct _MathVariablePopover MathVariablePopover;
typedef struct _MathVariablePopoverClass MathVariablePopoverClass;

#define TYPE_MATH_FUNCTION_POPOVER (math_function_popover_get_type ())
#define MATH_FUNCTION_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopover))
#define MATH_FUNCTION_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopoverClass))
#define IS_MATH_FUNCTION_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION_POPOVER))
#define IS_MATH_FUNCTION_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION_POPOVER))
#define MATH_FUNCTION_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopoverClass))

typedef struct _MathFunctionPopover MathFunctionPopover;
typedef struct _MathFunctionPopoverClass MathFunctionPopoverClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD
} ButtonMode;

struct _MathButtons {
	GtkBox parent_instance;
	MathButtonsPrivate * priv;
};

struct _MathButtonsClass {
	GtkBoxClass parent_class;
};

struct _MathButtonsPrivate {
	MathEquation* equation;
	ButtonMode _mode;
	gint _programming_base;
	MathConverter* converter;
	GtkBuilder* basic_ui;
	GtkBuilder* advanced_ui;
	GtkBuilder* financial_ui;
	GtkBuilder* programming_ui;
	GtkWidget* bas_panel;
	GtkWidget* adv_panel;
	GtkWidget* fin_panel;
	GtkWidget* prog_panel;
	GtkWidget* active_panel;
	GtkComboBox* base_combo;
	GtkLabel* base_label;
	GtkWidget* bit_panel;
	GList* toggle_bit_buttons;
	GtkDialog* character_code_dialog;
	GtkEntry* character_code_entry;
	GSimpleActionGroup* action_group;
};


static gpointer math_buttons_parent_class = NULL;

GType button_mode_get_type (void) G_GNUC_CONST;
GType math_buttons_get_type (void) G_GNUC_CONST;
GType math_converter_get_type (void) G_GNUC_CONST;
#define MATH_BUTTONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_BUTTONS, MathButtonsPrivate))
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void math_buttons_on_insert (MathButtons* self,
                             GSimpleAction* action,
                             GVariant* param);
static void _math_buttons_on_insert_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void math_buttons_on_insert_digit (MathButtons* self,
                                   GSimpleAction* action,
                                   GVariant* param);
static void _math_buttons_on_insert_digit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void math_buttons_on_subtract (MathButtons* self,
                               GSimpleAction* action,
                               GVariant* param);
static void _math_buttons_on_subtract_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void math_buttons_on_square (MathButtons* self,
                             GSimpleAction* action,
                             GVariant* param);
static void _math_buttons_on_square_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void math_buttons_on_undo (MathButtons* self,
                           GSimpleAction* action,
                           GVariant* param);
static void _math_buttons_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void math_buttons_on_solve (MathButtons* self,
                            GSimpleAction* action,
                            GVariant* param);
static void _math_buttons_on_solve_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void math_buttons_on_clear (MathButtons* self,
                            GSimpleAction* action,
                            GVariant* param);
static void _math_buttons_on_clear_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void math_buttons_on_factorize (MathButtons* self,
                                GSimpleAction* action,
                                GVariant* param);
static void _math_buttons_on_factorize_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void math_buttons_on_insert_exponent (MathButtons* self,
                                      GSimpleAction* action,
                                      GVariant* param);
static void _math_buttons_on_insert_exponent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void math_buttons_on_bitshift (MathButtons* self,
                               GSimpleAction* action,
                               GVariant* param);
static void _math_buttons_on_bitshift_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void math_buttons_on_toggle_bit (MathButtons* self,
                                 GSimpleAction* action,
                                 GVariant* param);
static void _math_buttons_on_toggle_bit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void math_buttons_on_insert_character (MathButtons* self,
                                       GSimpleAction* action,
                                       GVariant* param);
static void _math_buttons_on_insert_character_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void math_buttons_on_insert_numeric_point (MathButtons* self,
                                           GSimpleAction* action,
                                           GVariant* param);
static void _math_buttons_on_insert_numeric_point_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void math_buttons_on_set_number_mode (MathButtons* self,
                                      GSimpleAction* action,
                                      GVariant* param);
static void _math_buttons_on_set_number_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void math_buttons_on_launch_finc_dialog (MathButtons* self,
                                         GSimpleAction* action,
                                         GVariant* param);
static void _math_buttons_on_launch_finc_dialog_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
MathButtons* math_buttons_new (MathEquation* equation);
MathButtons* math_buttons_construct (GType object_type,
                                     MathEquation* equation);
static void math_buttons_load_buttons (MathButtons* self);
static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender,
                                                 gpointer self);
static void __lambda22_ (MathButtons* self,
                  GParamSpec* pspec);
static void math_buttons_update_bit_panel (MathButtons* self);
static void ___lambda22__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda23_ (MathButtons* self,
                  GParamSpec* pspec);
static void math_buttons_number_mode_changed_cb (MathButtons* self);
static void ___lambda23__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda24_ (MathButtons* self,
                  GParamSpec* pspec);
static void ___lambda24__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda25_ (MathButtons* self,
                  GParamSpec* pspec);
static void ___lambda25__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void math_buttons_load_finc_dialogs (MathButtons* self);
static void math_buttons_load_finc_dialog (MathButtons* self,
                                    const gchar* name,
                                    gchar** entry_names,
                                    int entry_names_length1,
                                    FinancialDialog function);
static void math_buttons_finc_response_cb (MathButtons* self,
                                    GtkWidget* widget,
                                    gint response_id);
static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender,
                                                         gint response_id,
                                                         gpointer self);
static void math_buttons_finc_activate_cb (MathButtons* self,
                                    GtkWidget* widget);
static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender,
                                                        gpointer self);
static void math_buttons_base_combobox_changed_cb (MathButtons* self,
                                            GtkComboBox* combo);
void math_buttons_set_programming_base (MathButtons* self,
                                        gint value);
static void math_buttons_base_changed_cb (MathButtons* self);
ButtonMode math_buttons_get_mode (MathButtons* self);
static GtkWidget* math_buttons_load_mode (MathButtons* self,
                                   ButtonMode mode);
static GMenu* math_buttons_create_shift_menu (MathButtons* self,
                                       gboolean shift_left);
MathVariablePopover* math_variable_popover_new (MathEquation* equation);
MathVariablePopover* math_variable_popover_construct (GType object_type,
                                                      MathEquation* equation);
GType math_variable_popover_get_type (void) G_GNUC_CONST;
MathFunctionPopover* math_function_popover_new (MathEquation* equation);
MathFunctionPopover* math_function_popover_construct (GType object_type,
                                                      MathEquation* equation);
GType math_function_popover_get_type (void) G_GNUC_CONST;
static void math_buttons_character_code_dialog_response_cb (MathButtons* self,
                                                     GtkWidget* dialog,
                                                     gint response_id);
static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender,
                                                                          gint response_id,
                                                                          gpointer self);
static gboolean math_buttons_character_code_dialog_delete_cb (MathButtons* self,
                                                       GtkWidget* dialog,
                                                       GdkEventAny* event);
static gboolean _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender,
                                                                                GdkEventAny* event,
                                                                                gpointer self);
static void math_buttons_character_code_dialog_activate_cb (MathButtons* self,
                                                     GtkWidget* entry);
static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender,
                                                                         gpointer self);
static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                   gpointer self);
static void ___lambda21_ (MathButtons* self,
                   GParamSpec* pspec);
static void ____lambda21__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void math_buttons_converter_changed_cb (MathButtons* self);
void math_converter_get_conversion (MathConverter* self,
                                    Unit* * from_unit,
                                    Unit* * to_unit);
MathConverter* math_converter_new (MathEquation* equation);
MathConverter* math_converter_construct (GType object_type,
                                         MathEquation* equation);
static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender,
                                                                gpointer self);
static gchar** _vala_array_dup1 (gchar** self,
                          int length);
static gchar** _vala_array_dup2 (gchar** self,
                          int length);
static gchar** _vala_array_dup3 (gchar** self,
                          int length);
static gchar** _vala_array_dup4 (gchar** self,
                          int length);
static gchar** _vala_array_dup5 (gchar** self,
                          int length);
static gchar** _vala_array_dup6 (gchar** self,
                          int length);
static gchar** _vala_array_dup7 (gchar** self,
                          int length);
static gchar** _vala_array_dup8 (gchar** self,
                          int length);
static gchar** _vala_array_dup9 (gchar** self,
                          int length);
static gchar** _vala_array_dup10 (gchar** self,
                           int length);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (const gchar* value);
static GVariant* _variant_new4 (const gchar* value);
void math_buttons_set_mode (MathButtons* self,
                            ButtonMode value);
void math_converter_set_category (MathConverter* self,
                                  const gchar* category);
void math_converter_set_conversion (MathConverter* self,
                                    const gchar* unit_a,
                                    const gchar* unit_b);
gint math_buttons_get_programming_base (MathButtons* self);
static void math_buttons_finalize (GObject * obj);
static void _vala_math_buttons_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_math_buttons_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const gchar* MATH_BUTTONS_ctrm_entries[3] = {"ctrm_pint", "ctrm_fv", "ctrm_pv"};
static const gchar* MATH_BUTTONS_ddb_entries[3] = {"ddb_cost", "ddb_life", "ddb_period"};
static const gchar* MATH_BUTTONS_fv_entries[3] = {"fv_pmt", "fv_pint", "fv_n"};
static const gchar* MATH_BUTTONS_gpm_entries[2] = {"gpm_cost", "gpm_margin"};
static const gchar* MATH_BUTTONS_pmt_entries[3] = {"pmt_prin", "pmt_pint", "pmt_n"};
static const gchar* MATH_BUTTONS_pv_entries[3] = {"pv_pmt", "pv_pint", "pv_n"};
static const gchar* MATH_BUTTONS_rate_entries[3] = {"rate_fv", "rate_pv", "rate_n"};
static const gchar* MATH_BUTTONS_sln_entries[3] = {"sln_cost", "sln_salvage", "sln_life"};
static const gchar* MATH_BUTTONS_syd_entries[4] = {"syd_cost", "syd_salvage", "syd_life", "syd_period"};
static const gchar* MATH_BUTTONS_term_entries[3] = {"term_pmt", "term_fv", "term_pint"};
static const GActionEntry MATH_BUTTONS_action_entries[15] = {{"insert-general", _math_buttons_on_insert_gsimple_action_activate_callback, "s"}, {"insert-digit", _math_buttons_on_insert_digit_gsimple_action_activate_callback, "i"}, {"subtract", _math_buttons_on_subtract_gsimple_action_activate_callback}, {"square", _math_buttons_on_square_gsimple_action_activate_callback}, {"undo", _math_buttons_on_undo_gsimple_action_activate_callback}, {"solve", _math_buttons_on_solve_gsimple_action_activate_callback}, {"clear", _math_buttons_on_clear_gsimple_action_activate_callback}, {"factorize", _math_buttons_on_factorize_gsimple_action_activate_callback}, {"insert-exponent", _math_buttons_on_insert_exponent_gsimple_action_activate_callback}, {"bitshift", _math_buttons_on_bitshift_gsimple_action_activate_callback, "i"}, {"toggle-bit", _math_buttons_on_toggle_bit_gsimple_action_activate_callback, "i"}, {"insert-character", _math_buttons_on_insert_character_gsimple_action_activate_callback}, {"insert-numeric-point", _math_buttons_on_insert_numeric_point_gsimple_action_activate_callback}, {"set-number-mode", _math_buttons_on_set_number_mode_gsimple_action_activate_callback, "s", "'normal'"}, {"launch-finc-dialog", _math_buttons_on_launch_finc_dialog_gsimple_action_activate_callback, "s"}};

GType
button_mode_get_type (void)
{
	static volatile gsize button_mode_type_id__volatile = 0;
	if (g_once_init_enter (&button_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{BUTTON_MODE_BASIC, "BUTTON_MODE_BASIC", "basic"}, {BUTTON_MODE_ADVANCED, "BUTTON_MODE_ADVANCED", "advanced"}, {BUTTON_MODE_FINANCIAL, "BUTTON_MODE_FINANCIAL", "financial"}, {BUTTON_MODE_PROGRAMMING, "BUTTON_MODE_PROGRAMMING", "programming"}, {BUTTON_MODE_KEYBOARD, "BUTTON_MODE_KEYBOARD", "keyboard"}, {0, NULL, NULL}};
		GType button_mode_type_id;
		button_mode_type_id = g_enum_register_static ("ButtonMode", values);
		g_once_init_leave (&button_mode_type_id__volatile, button_mode_type_id);
	}
	return button_mode_type_id__volatile;
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static void
_math_buttons_on_insert_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	math_buttons_on_insert ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_insert_digit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	math_buttons_on_insert_digit ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_subtract_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	math_buttons_on_subtract ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_square_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	math_buttons_on_square ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	math_buttons_on_undo ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_solve_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	math_buttons_on_solve ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_clear_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	math_buttons_on_clear ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_factorize_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	math_buttons_on_factorize ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_insert_exponent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	math_buttons_on_insert_exponent ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_bitshift_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	math_buttons_on_bitshift ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_toggle_bit_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	math_buttons_on_toggle_bit ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_insert_character_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	math_buttons_on_insert_character ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_insert_numeric_point_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	math_buttons_on_insert_numeric_point ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_set_number_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	math_buttons_on_set_number_mode ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_on_launch_finc_dialog_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	math_buttons_on_launch_finc_dialog ((MathButtons*) self, action, parameter);
}


static void
_math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender,
                                            gpointer self)
{
	math_buttons_load_buttons ((MathButtons*) self);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
__lambda22_ (MathButtons* self,
             GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void
___lambda22__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda22_ ((MathButtons*) self, pspec);
}


static void
__lambda23_ (MathButtons* self,
             GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_buttons_number_mode_changed_cb (self);
}


static void
___lambda23__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda23_ ((MathButtons*) self, pspec);
}


static void
__lambda24_ (MathButtons* self,
             GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void
___lambda24__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda24_ ((MathButtons*) self, pspec);
}


static void
__lambda25_ (MathButtons* self,
             GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void
___lambda25__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda25_ ((MathButtons*) self, pspec);
}


MathButtons*
math_buttons_construct (GType object_type,
                        MathEquation* equation)
{
	MathButtons * self = NULL;
	MathEquation* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathButtons*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "vexpand-set", TRUE, NULL);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _math_buttons_load_buttons_gtk_widget_show, self, 0);
	_tmp0_ = _g_object_ref0 (equation);
	_g_object_unref0 (self->priv->equation);
	self->priv->equation = _tmp0_;
	_tmp1_ = self->priv->action_group;
	g_action_map_add_action_entries ((GActionMap*) _tmp1_, MATH_BUTTONS_action_entries, G_N_ELEMENTS (MATH_BUTTONS_action_entries), self);
	_tmp2_ = self->priv->action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "cal", (GActionGroup*) _tmp2_);
	g_signal_connect_object ((GObject*) equation, "notify::display", (GCallback) ___lambda22__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) equation, "notify::number-mode", (GCallback) ___lambda23__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) equation, "notify::angle-units", (GCallback) ___lambda24__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) equation, "notify::number-format", (GCallback) ___lambda25__g_object_notify, self, 0);
	math_buttons_number_mode_changed_cb (self);
	math_buttons_update_bit_panel (self);
	return self;
}


MathButtons*
math_buttons_new (MathEquation* equation)
{
	return math_buttons_construct (TYPE_MATH_BUTTONS, equation);
}


static void
math_buttons_load_finc_dialogs (MathButtons* self)
{
	g_return_if_fail (self != NULL);
	math_buttons_load_finc_dialog (self, "ctrm_dialog", MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries), FINANCIAL_DIALOG_CTRM_DIALOG);
	math_buttons_load_finc_dialog (self, "ddb_dialog", MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries), FINANCIAL_DIALOG_DDB_DIALOG);
	math_buttons_load_finc_dialog (self, "fv_dialog", MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries), FINANCIAL_DIALOG_FV_DIALOG);
	math_buttons_load_finc_dialog (self, "gpm_dialog", MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries), FINANCIAL_DIALOG_GPM_DIALOG);
	math_buttons_load_finc_dialog (self, "pmt_dialog", MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries), FINANCIAL_DIALOG_PMT_DIALOG);
	math_buttons_load_finc_dialog (self, "pv_dialog", MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries), FINANCIAL_DIALOG_PV_DIALOG);
	math_buttons_load_finc_dialog (self, "rate_dialog", MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries), FINANCIAL_DIALOG_RATE_DIALOG);
	math_buttons_load_finc_dialog (self, "sln_dialog", MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries), FINANCIAL_DIALOG_SLN_DIALOG);
	math_buttons_load_finc_dialog (self, "syd_dialog", MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries), FINANCIAL_DIALOG_SYD_DIALOG);
	math_buttons_load_finc_dialog (self, "term_dialog", MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries), FINANCIAL_DIALOG_TERM_DIALOG);
}


static void
_math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender,
                                                    gint response_id,
                                                    gpointer self)
{
	math_buttons_finc_response_cb ((MathButtons*) self, _sender, response_id);
}


static void
_math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender,
                                                   gpointer self)
{
	math_buttons_finc_activate_cb ((MathButtons*) self, _sender);
}


static void
math_buttons_load_finc_dialog (MathButtons* self,
                               const gchar* name,
                               gchar** entry_names,
                               int entry_names_length1,
                               FinancialDialog function)
{
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp0_;
	GObject* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->financial_ui;
	_tmp1_ = gtk_builder_get_object (_tmp0_, name);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL);
	dialog = _tmp2_;
	_tmp3_ = dialog;
	g_object_set_data_full ((GObject*) _tmp3_, "finc-function", (gpointer) ((gintptr) ((gint) function)), NULL);
	_tmp4_ = dialog;
	g_signal_connect_object (_tmp4_, "response", (GCallback) _math_buttons_finc_response_cb_gtk_dialog_response, self, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp8_;
				gint _tmp9_;
				const gchar* _tmp10_;
				GObject* _tmp11_;
				GtkEntry* _tmp12_;
				gint _tmp13_;
				GtkEntry* _tmp20_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				if (!(_tmp7_ < entry_names_length1)) {
					break;
				}
				_tmp8_ = self->priv->financial_ui;
				_tmp9_ = i;
				_tmp10_ = entry_names[_tmp9_];
				_tmp11_ = gtk_builder_get_object (_tmp8_, _tmp10_);
				_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp11_) : NULL);
				entry = _tmp12_;
				_tmp13_ = i;
				if (_tmp13_ != (entry_names_length1 - 1)) {
					GtkEntry* _tmp14_;
					GtkBuilder* _tmp15_;
					gint _tmp16_;
					const gchar* _tmp17_;
					GObject* _tmp18_;
					GtkEntry* _tmp19_;
					_tmp14_ = entry;
					_tmp15_ = self->priv->financial_ui;
					_tmp16_ = i;
					_tmp17_ = entry_names[_tmp16_ + 1];
					_tmp18_ = gtk_builder_get_object (_tmp15_, _tmp17_);
					_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp18_) : NULL);
					g_object_set_data_full ((GObject*) _tmp14_, "next-entry", _tmp19_, g_object_unref);
				}
				_tmp20_ = entry;
				g_signal_connect_object (_tmp20_, "activate", (GCallback) _math_buttons_finc_activate_cb_gtk_entry_activate, self, 0);
				_g_object_unref0 (entry);
			}
		}
	}
	_g_object_unref0 (dialog);
}


static void
math_buttons_on_insert (MathButtons* self,
                        GSimpleAction* action,
                        GVariant* param)
{
	MathEquation* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = g_variant_get_string (param, NULL);
	math_equation_insert (_tmp0_, _tmp1_);
}


static void
math_buttons_on_insert_digit (MathButtons* self,
                              GSimpleAction* action,
                              GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_digit (_tmp0_, (guint) g_variant_get_int32 (param));
}


static void
math_buttons_on_subtract (MathButtons* self,
                          GSimpleAction* action,
                          GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_subtract (_tmp0_);
}


static void
math_buttons_on_square (MathButtons* self,
                        GSimpleAction* action,
                        GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_square (_tmp0_);
}


static void
math_buttons_on_undo (MathButtons* self,
                      GSimpleAction* action,
                      GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp0_);
}


static void
math_buttons_on_solve (MathButtons* self,
                       GSimpleAction* action,
                       GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_solve (_tmp0_);
}


static void
math_buttons_on_clear (MathButtons* self,
                       GSimpleAction* action,
                       GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_clear (_tmp0_);
}


static void
math_buttons_on_factorize (MathButtons* self,
                           GSimpleAction* action,
                           GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_factorize (_tmp0_);
}


static void
math_buttons_on_insert_exponent (MathButtons* self,
                                 GSimpleAction* action,
                                 GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_exponent (_tmp0_);
}


static void
math_buttons_on_bitshift (MathButtons* self,
                          GSimpleAction* action,
                          GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_shift (_tmp0_, (gint) g_variant_get_int32 (param));
}


static void
math_buttons_on_insert_numeric_point (MathButtons* self,
                                      GSimpleAction* action,
                                      GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_numeric_point (_tmp0_);
}


static void
math_buttons_update_bit_panel (MathButtons* self)
{
	GtkWidget* _tmp0_;
	Number* x = NULL;
	MathEquation* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	guint64 bits = 0ULL;
	gboolean enabled = FALSE;
	Number* _tmp4_;
	gboolean _tmp5_;
	GtkWidget* _tmp16_;
	gboolean _tmp17_;
	GtkLabel* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gint i = 0;
	GList* _tmp21_;
	gint number_base = 0;
	MathEquation* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gchar* label = NULL;
	gchar* _tmp33_;
	gint _tmp34_;
	gint _tmp40_;
	gint _tmp49_;
	GtkLabel* _tmp58_;
	const gchar* _tmp59_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bit_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->equation;
	_tmp2_ = math_equation_get_number (_tmp1_);
	_tmp3_ = _tmp2_;
	x = _tmp3_;
	bits = (guint64) 0;
	_tmp4_ = x;
	enabled = _tmp4_ != NULL;
	_tmp5_ = enabled;
	if (_tmp5_) {
		Number* max = NULL;
		Number* _tmp6_;
		Number* fraction = NULL;
		Number* _tmp7_;
		Number* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		Number* _tmp11_;
		_tmp6_ = number_new_unsigned_integer (G_MAXUINT64, (guint64) 0);
		max = _tmp6_;
		_tmp7_ = x;
		_tmp8_ = number_fractional_part (_tmp7_);
		fraction = _tmp8_;
		_tmp11_ = x;
		if (number_is_negative (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			Number* _tmp12_;
			Number* _tmp13_;
			_tmp12_ = x;
			_tmp13_ = max;
			_tmp10_ = number_compare (_tmp12_, _tmp13_) > 0;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			Number* _tmp14_;
			_tmp14_ = fraction;
			_tmp9_ = !number_is_zero (_tmp14_);
		}
		if (_tmp9_) {
			enabled = FALSE;
		} else {
			Number* _tmp15_;
			_tmp15_ = x;
			bits = number_to_unsigned_integer (_tmp15_);
		}
		_g_object_unref0 (fraction);
		_g_object_unref0 (max);
	}
	_tmp16_ = self->priv->bit_panel;
	_tmp17_ = enabled;
	gtk_widget_set_sensitive (_tmp16_, _tmp17_);
	_tmp18_ = self->priv->base_label;
	_tmp19_ = enabled;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp18_, _tmp19_);
	_tmp20_ = enabled;
	if (!_tmp20_) {
		_g_object_unref0 (x);
		return;
	}
	i = 0;
	_tmp21_ = self->priv->toggle_bit_buttons;
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp21_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			GtkButton* _tmp22_;
			GtkButton* button = NULL;
			_tmp22_ = _g_object_ref0 ((GtkButton*) button_it->data);
			button = _tmp22_;
			{
				gchar* text = NULL;
				gchar* _tmp23_;
				guint64 _tmp24_;
				gint _tmp25_;
				GtkButton* _tmp27_;
				const gchar* _tmp28_;
				gint _tmp29_;
				_tmp23_ = g_strdup ("0");
				text = _tmp23_;
				_tmp24_ = bits;
				_tmp25_ = i;
				if ((_tmp24_ & (1ULL << _tmp25_)) != ((guint64) 0)) {
					gchar* _tmp26_;
					_tmp26_ = g_strdup ("1");
					_g_free0 (text);
					text = _tmp26_;
				}
				_tmp27_ = button;
				_tmp28_ = text;
				gtk_button_set_label (_tmp27_, _tmp28_);
				_tmp29_ = i;
				i = _tmp29_ + 1;
				_g_free0 (text);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp30_ = self->priv->equation;
	_tmp31_ = math_equation_get_number_base (_tmp30_);
	_tmp32_ = _tmp31_;
	number_base = _tmp32_;
	_tmp33_ = g_strdup ("");
	label = _tmp33_;
	_tmp34_ = number_base;
	if (_tmp34_ != 8) {
		const gchar* _tmp35_;
		guint64 _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp35_ = label;
		_tmp36_ = bits;
		_tmp37_ = g_strdup_printf ("%llo₈", _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat (_tmp35_, _tmp38_, NULL);
		_g_free0 (label);
		label = _tmp39_;
		_g_free0 (_tmp38_);
	}
	_tmp40_ = number_base;
	if (_tmp40_ != 10) {
		const gchar* _tmp41_;
		const gchar* _tmp44_;
		guint64 _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		_tmp41_ = label;
		if (g_strcmp0 (_tmp41_, "") != 0) {
			const gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp42_ = label;
			_tmp43_ = g_strconcat (_tmp42_, " = ", NULL);
			_g_free0 (label);
			label = _tmp43_;
		}
		_tmp44_ = label;
		_tmp45_ = bits;
		_tmp46_ = g_strdup_printf ("%llu₁₀", _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_strconcat (_tmp44_, _tmp47_, NULL);
		_g_free0 (label);
		label = _tmp48_;
		_g_free0 (_tmp47_);
	}
	_tmp49_ = number_base;
	if (_tmp49_ != 16) {
		const gchar* _tmp50_;
		const gchar* _tmp53_;
		guint64 _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp50_ = label;
		if (g_strcmp0 (_tmp50_, "") != 0) {
			const gchar* _tmp51_;
			gchar* _tmp52_;
			_tmp51_ = label;
			_tmp52_ = g_strconcat (_tmp51_, " = ", NULL);
			_g_free0 (label);
			label = _tmp52_;
		}
		_tmp53_ = label;
		_tmp54_ = bits;
		_tmp55_ = g_strdup_printf ("%llX₁₆", _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = g_strconcat (_tmp53_, _tmp56_, NULL);
		_g_free0 (label);
		label = _tmp57_;
		_g_free0 (_tmp56_);
	}
	_tmp58_ = self->priv->base_label;
	_tmp59_ = label;
	gtk_label_set_text (_tmp58_, _tmp59_);
	_g_free0 (label);
	_g_object_unref0 (x);
}


static void
math_buttons_base_combobox_changed_cb (MathButtons* self,
                                       GtkComboBox* combo)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = gtk_combo_box_get_active_id (combo);
	_tmp1_ = _tmp0_;
	math_buttons_set_programming_base (self, atoi (_tmp1_));
}


static void
math_buttons_base_changed_cb (MathButtons* self)
{
	ButtonMode _tmp0_;
	ButtonMode _tmp1_;
	MathEquation* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkComboBox* _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_buttons_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != BUTTON_MODE_PROGRAMMING) {
		return;
	}
	_tmp2_ = self->priv->equation;
	_tmp3_ = math_equation_get_number_base (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->_programming_base = _tmp4_;
	_tmp5_ = self->priv->base_combo;
	_tmp6_ = self->priv->_programming_base;
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
	_tmp8_ = _tmp7_;
	gtk_combo_box_set_active_id (_tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	math_buttons_update_bit_panel (self);
}


static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static void
_math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender,
                                                                     gint response_id,
                                                                     gpointer self)
{
	math_buttons_character_code_dialog_response_cb ((MathButtons*) self, _sender, response_id);
}


static gboolean
_math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender,
                                                                       GdkEventAny* event,
                                                                       gpointer self)
{
	gboolean result;
	result = math_buttons_character_code_dialog_delete_cb ((MathButtons*) self, _sender, event);
	return result;
}


static void
_math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender,
                                                                    gpointer self)
{
	math_buttons_character_code_dialog_activate_cb ((MathButtons*) self, _sender);
}


static void
_math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                              gpointer self)
{
	math_buttons_base_combobox_changed_cb ((MathButtons*) self, _sender);
}


static void
___lambda21_ (MathButtons* self,
              GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_buttons_base_changed_cb (self);
}


static void
____lambda21__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda21_ ((MathButtons*) self, pspec);
}


static GtkWidget*
math_buttons_load_mode (MathButtons* self,
                        ButtonMode mode)
{
	GtkWidget* result = NULL;
	GtkBuilder* builder = NULL;
	gchar* builder_resource = NULL;
	GtkWidget* panel = NULL;
	GtkBuilder* _tmp33_;
	GObject* _tmp34_;
	GtkWidget* _tmp35_;
	GtkWidget* _tmp36_;
	GtkButton* button = NULL;
	GtkBuilder* _tmp45_;
	GObject* _tmp46_;
	GtkButton* _tmp47_;
	GtkButton* _tmp48_;
	GtkMenuButton* menu_button = NULL;
	GtkBuilder* _tmp55_;
	GObject* _tmp56_;
	GtkMenuButton* _tmp57_;
	GtkMenuButton* _tmp58_;
	GtkBuilder* _tmp62_;
	GObject* _tmp63_;
	GtkMenuButton* _tmp64_;
	GtkMenuButton* _tmp65_;
	GtkBuilder* _tmp69_;
	GObject* _tmp70_;
	GtkMenuButton* _tmp71_;
	GtkMenuButton* _tmp72_;
	GtkBuilder* _tmp77_;
	GObject* _tmp78_;
	GtkMenuButton* _tmp79_;
	GtkMenuButton* _tmp80_;
	GtkBuilder* _tmp115_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (mode) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp0_;
			GtkBuilder* _tmp3_;
			GtkBuilder* _tmp4_;
			GtkBuilder* _tmp5_;
			gchar* _tmp6_;
			_tmp0_ = self->priv->bas_panel;
			if (_tmp0_ != NULL) {
				GtkWidget* _tmp1_;
				GtkWidget* _tmp2_;
				_tmp1_ = self->priv->bas_panel;
				_tmp2_ = _g_object_ref0 (_tmp1_);
				result = _tmp2_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp3_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->basic_ui);
			self->priv->basic_ui = _tmp3_;
			_tmp4_ = self->priv->basic_ui;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_g_object_unref0 (builder);
			builder = _tmp5_;
			_tmp6_ = g_strdup ("buttons-basic.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp6_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp7_;
			GtkBuilder* _tmp10_;
			GtkBuilder* _tmp11_;
			GtkBuilder* _tmp12_;
			gchar* _tmp13_;
			_tmp7_ = self->priv->adv_panel;
			if (_tmp7_ != NULL) {
				GtkWidget* _tmp8_;
				GtkWidget* _tmp9_;
				_tmp8_ = self->priv->adv_panel;
				_tmp9_ = _g_object_ref0 (_tmp8_);
				result = _tmp9_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp10_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->advanced_ui);
			self->priv->advanced_ui = _tmp10_;
			_tmp11_ = self->priv->advanced_ui;
			_tmp12_ = _g_object_ref0 (_tmp11_);
			_g_object_unref0 (builder);
			builder = _tmp12_;
			_tmp13_ = g_strdup ("buttons-advanced.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp13_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp14_;
			GtkBuilder* _tmp17_;
			GtkBuilder* _tmp18_;
			GtkBuilder* _tmp19_;
			gchar* _tmp20_;
			_tmp14_ = self->priv->fin_panel;
			if (_tmp14_ != NULL) {
				GtkWidget* _tmp15_;
				GtkWidget* _tmp16_;
				_tmp15_ = self->priv->fin_panel;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				result = _tmp16_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp17_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->financial_ui);
			self->priv->financial_ui = _tmp17_;
			_tmp18_ = self->priv->financial_ui;
			_tmp19_ = _g_object_ref0 (_tmp18_);
			_g_object_unref0 (builder);
			builder = _tmp19_;
			_tmp20_ = g_strdup ("buttons-financial.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp20_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp21_;
			GtkBuilder* _tmp24_;
			GtkBuilder* _tmp25_;
			GtkBuilder* _tmp26_;
			gchar* _tmp27_;
			_tmp21_ = self->priv->prog_panel;
			if (_tmp21_ != NULL) {
				GtkWidget* _tmp22_;
				GtkWidget* _tmp23_;
				_tmp22_ = self->priv->prog_panel;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				result = _tmp23_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp24_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->programming_ui);
			self->priv->programming_ui = _tmp24_;
			_tmp25_ = self->priv->programming_ui;
			_tmp26_ = _g_object_ref0 (_tmp25_);
			_g_object_unref0 (builder);
			builder = _tmp26_;
			_tmp27_ = g_strdup ("buttons-programming.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp27_;
			break;
		}
	}
	{
		GtkBuilder* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp28_ = builder;
		_tmp29_ = builder_resource;
		_tmp30_ = g_strdup_printf ("/org/gnome/calculator/%s", _tmp29_);
		_tmp31_ = _tmp30_;
		gtk_builder_add_from_resource (_tmp28_, _tmp31_, &_inner_error_);
		_g_free0 (_tmp31_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp32_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = e->message;
		g_error ("math-buttons.vala:320: Error loading button UI: %s", _tmp32_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (builder_resource);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp33_ = builder;
	_tmp34_ = gtk_builder_get_object (_tmp33_, "button_panel");
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp34_) : NULL);
	panel = _tmp35_;
	_tmp36_ = panel;
	gtk_box_pack_end ((GtkBox*) self, _tmp36_, TRUE, TRUE, (guint) 0);
	switch (mode) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp37_;
			GtkWidget* _tmp38_;
			_tmp37_ = panel;
			_tmp38_ = _g_object_ref0 (_tmp37_);
			_g_object_unref0 (self->priv->bas_panel);
			self->priv->bas_panel = _tmp38_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp39_;
			GtkWidget* _tmp40_;
			_tmp39_ = panel;
			_tmp40_ = _g_object_ref0 (_tmp39_);
			_g_object_unref0 (self->priv->adv_panel);
			self->priv->adv_panel = _tmp40_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp41_;
			GtkWidget* _tmp42_;
			_tmp41_ = panel;
			_tmp42_ = _g_object_ref0 (_tmp41_);
			_g_object_unref0 (self->priv->fin_panel);
			self->priv->fin_panel = _tmp42_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp43_;
			GtkWidget* _tmp44_;
			_tmp43_ = panel;
			_tmp44_ = _g_object_ref0 (_tmp43_);
			_g_object_unref0 (self->priv->prog_panel);
			self->priv->prog_panel = _tmp44_;
			break;
		}
	}
	_tmp45_ = builder;
	_tmp46_ = gtk_builder_get_object (_tmp45_, "calc_numeric_point_button");
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, gtk_button_get_type ()) ? ((GtkButton*) _tmp46_) : NULL);
	button = _tmp47_;
	_tmp48_ = button;
	if (_tmp48_ != NULL) {
		GtkButton* _tmp49_;
		MathEquation* _tmp50_;
		Serializer* _tmp51_;
		Serializer* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp49_ = button;
		_tmp50_ = self->priv->equation;
		_tmp51_ = math_equation_get_serializer (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_unichar_to_string (serializer_get_radix (_tmp52_));
		_tmp54_ = _tmp53_;
		gtk_button_set_label (_tmp49_, _tmp54_);
		_g_free0 (_tmp54_);
	}
	_tmp55_ = builder;
	_tmp56_ = gtk_builder_get_object (_tmp55_, "calc_shift_left_button");
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp56_) : NULL);
	menu_button = _tmp57_;
	_tmp58_ = menu_button;
	if (_tmp58_ != NULL) {
		GtkMenuButton* _tmp59_;
		GMenu* _tmp60_;
		GMenu* _tmp61_;
		_tmp59_ = menu_button;
		_tmp60_ = math_buttons_create_shift_menu (self, TRUE);
		_tmp61_ = _tmp60_;
		gtk_menu_button_set_menu_model (_tmp59_, (GMenuModel*) _tmp61_);
		_g_object_unref0 (_tmp61_);
	}
	_tmp62_ = builder;
	_tmp63_ = gtk_builder_get_object (_tmp62_, "calc_shift_right_button");
	_tmp64_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp63_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp63_) : NULL);
	_g_object_unref0 (menu_button);
	menu_button = _tmp64_;
	_tmp65_ = menu_button;
	if (_tmp65_ != NULL) {
		GtkMenuButton* _tmp66_;
		GMenu* _tmp67_;
		GMenu* _tmp68_;
		_tmp66_ = menu_button;
		_tmp67_ = math_buttons_create_shift_menu (self, FALSE);
		_tmp68_ = _tmp67_;
		gtk_menu_button_set_menu_model (_tmp66_, (GMenuModel*) _tmp68_);
		_g_object_unref0 (_tmp68_);
	}
	_tmp69_ = builder;
	_tmp70_ = gtk_builder_get_object (_tmp69_, "calc_memory_button");
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp70_) : NULL);
	_g_object_unref0 (menu_button);
	menu_button = _tmp71_;
	_tmp72_ = menu_button;
	if (_tmp72_ != NULL) {
		GtkMenuButton* _tmp73_;
		MathEquation* _tmp74_;
		MathVariablePopover* _tmp75_;
		MathVariablePopover* _tmp76_;
		_tmp73_ = menu_button;
		_tmp74_ = self->priv->equation;
		_tmp75_ = math_variable_popover_new (_tmp74_);
		g_object_ref_sink (_tmp75_);
		_tmp76_ = _tmp75_;
		gtk_menu_button_set_popover (_tmp73_, (GtkPopover*) _tmp76_);
		_g_object_unref0 (_tmp76_);
	}
	_tmp77_ = builder;
	_tmp78_ = gtk_builder_get_object (_tmp77_, "calc_function_button");
	_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp78_) : NULL);
	_g_object_unref0 (menu_button);
	menu_button = _tmp79_;
	_tmp80_ = menu_button;
	if (_tmp80_ != NULL) {
		GtkMenuButton* _tmp81_;
		MathEquation* _tmp82_;
		MathFunctionPopover* _tmp83_;
		MathFunctionPopover* _tmp84_;
		_tmp81_ = menu_button;
		_tmp82_ = self->priv->equation;
		_tmp83_ = math_function_popover_new (_tmp82_);
		g_object_ref_sink (_tmp83_);
		_tmp84_ = _tmp83_;
		gtk_menu_button_set_popover (_tmp81_, (GtkPopover*) _tmp84_);
		_g_object_unref0 (_tmp84_);
	}
	if (mode == BUTTON_MODE_PROGRAMMING) {
		GtkBuilder* _tmp85_;
		GObject* _tmp86_;
		GtkLabel* _tmp87_;
		GtkBuilder* _tmp88_;
		GObject* _tmp89_;
		GtkDialog* _tmp90_;
		GtkDialog* _tmp91_;
		GtkDialog* _tmp92_;
		GtkBuilder* _tmp93_;
		GObject* _tmp94_;
		GtkEntry* _tmp95_;
		GtkEntry* _tmp96_;
		GtkBuilder* _tmp97_;
		GObject* _tmp98_;
		GtkWidget* _tmp99_;
		gint i = 0;
		GtkBuilder* _tmp110_;
		GObject* _tmp111_;
		GtkComboBox* _tmp112_;
		GtkComboBox* _tmp113_;
		MathEquation* _tmp114_;
		_tmp85_ = builder;
		_tmp86_ = gtk_builder_get_object (_tmp85_, "base_label");
		_tmp87_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp86_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp86_) : NULL);
		_g_object_unref0 (self->priv->base_label);
		self->priv->base_label = _tmp87_;
		_tmp88_ = builder;
		_tmp89_ = gtk_builder_get_object (_tmp88_, "character_code_dialog");
		_tmp90_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp89_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp89_) : NULL);
		_g_object_unref0 (self->priv->character_code_dialog);
		self->priv->character_code_dialog = _tmp90_;
		_tmp91_ = self->priv->character_code_dialog;
		g_signal_connect_object (_tmp91_, "response", (GCallback) _math_buttons_character_code_dialog_response_cb_gtk_dialog_response, self, 0);
		_tmp92_ = self->priv->character_code_dialog;
		g_signal_connect_object ((GtkWidget*) _tmp92_, "delete-event", (GCallback) _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event, self, 0);
		_tmp93_ = builder;
		_tmp94_ = gtk_builder_get_object (_tmp93_, "character_code_entry");
		_tmp95_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp94_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp94_) : NULL);
		_g_object_unref0 (self->priv->character_code_entry);
		self->priv->character_code_entry = _tmp95_;
		_tmp96_ = self->priv->character_code_entry;
		g_signal_connect_object (_tmp96_, "activate", (GCallback) _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate, self, 0);
		_tmp97_ = builder;
		_tmp98_ = gtk_builder_get_object (_tmp97_, "bit_table");
		_tmp99_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp98_) : NULL);
		_g_object_unref0 (self->priv->bit_panel);
		self->priv->bit_panel = _tmp99_;
		__g_list_free__g_object_unref0_0 (self->priv->toggle_bit_buttons);
		self->priv->toggle_bit_buttons = NULL;
		i = 0;
		while (TRUE) {
			gchar* name = NULL;
			gint _tmp100_;
			gchar* _tmp101_;
			GtkButton* toggle_bit_button = NULL;
			GtkBuilder* _tmp102_;
			const gchar* _tmp103_;
			GObject* _tmp104_;
			GtkButton* _tmp105_;
			GtkButton* _tmp106_;
			GtkButton* _tmp107_;
			GtkButton* _tmp108_;
			gint _tmp109_;
			_tmp100_ = i;
			_tmp101_ = g_strdup_printf ("toggle_bit_%d_button", _tmp100_);
			name = _tmp101_;
			_tmp102_ = builder;
			_tmp103_ = name;
			_tmp104_ = gtk_builder_get_object (_tmp102_, _tmp103_);
			_tmp105_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp104_, gtk_button_get_type ()) ? ((GtkButton*) _tmp104_) : NULL);
			toggle_bit_button = _tmp105_;
			_tmp106_ = toggle_bit_button;
			if (_tmp106_ == NULL) {
				_g_object_unref0 (toggle_bit_button);
				_g_free0 (name);
				break;
			}
			_tmp107_ = toggle_bit_button;
			_tmp108_ = _g_object_ref0 (_tmp107_);
			self->priv->toggle_bit_buttons = g_list_append (self->priv->toggle_bit_buttons, _tmp108_);
			_tmp109_ = i;
			i = _tmp109_ + 1;
			_g_object_unref0 (toggle_bit_button);
			_g_free0 (name);
		}
		self->priv->toggle_bit_buttons = g_list_reverse (self->priv->toggle_bit_buttons);
		_tmp110_ = builder;
		_tmp111_ = gtk_builder_get_object (_tmp110_, "base_combo");
		_tmp112_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp111_, gtk_combo_box_get_type ()) ? ((GtkComboBox*) _tmp111_) : NULL);
		_g_object_unref0 (self->priv->base_combo);
		self->priv->base_combo = _tmp112_;
		_tmp113_ = self->priv->base_combo;
		g_signal_connect_object (_tmp113_, "changed", (GCallback) _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed, self, 0);
		_tmp114_ = self->priv->equation;
		g_signal_connect_object ((GObject*) _tmp114_, "notify::number-base", (GCallback) ____lambda21__g_object_notify, self, 0);
		math_buttons_base_changed_cb (self);
	}
	if (mode == BUTTON_MODE_FINANCIAL) {
		math_buttons_load_finc_dialogs (self);
	}
	_tmp115_ = builder;
	gtk_builder_connect_signals (_tmp115_, self);
	math_buttons_update_bit_panel (self);
	result = panel;
	_g_object_unref0 (menu_button);
	_g_object_unref0 (button);
	_g_free0 (builder_resource);
	_g_object_unref0 (builder);
	return result;
}


static void
math_buttons_converter_changed_cb (MathButtons* self)
{
	Unit* from_unit = NULL;
	Unit* to_unit = NULL;
	MathConverter* _tmp0_;
	Unit* _tmp1_ = NULL;
	Unit* _tmp2_ = NULL;
	ButtonMode _tmp3_;
	ButtonMode _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_get_conversion (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (from_unit);
	from_unit = _tmp1_;
	_g_object_unref0 (to_unit);
	to_unit = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_FINANCIAL) {
		MathEquation* _tmp5_;
		Unit* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		MathEquation* _tmp10_;
		Unit* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp5_ = self->priv->equation;
		_tmp6_ = from_unit;
		_tmp7_ = unit_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		math_equation_set_source_currency (_tmp5_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->equation;
		_tmp11_ = to_unit;
		_tmp12_ = unit_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		math_equation_set_target_currency (_tmp10_, _tmp14_);
		_g_free0 (_tmp14_);
	} else {
		MathEquation* _tmp15_;
		Unit* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		MathEquation* _tmp20_;
		Unit* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp15_ = self->priv->equation;
		_tmp16_ = from_unit;
		_tmp17_ = unit_get_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		math_equation_set_source_units (_tmp15_, _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = self->priv->equation;
		_tmp21_ = to_unit;
		_tmp22_ = unit_get_name (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		math_equation_set_target_units (_tmp20_, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_g_object_unref0 (to_unit);
	_g_object_unref0 (from_unit);
}


static void
_math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender,
                                                           gpointer self)
{
	math_buttons_converter_changed_cb ((MathButtons*) self);
}


static void
math_buttons_load_buttons (MathButtons* self)
{
	MathConverter* _tmp0_;
	GtkWidget* panel = NULL;
	ButtonMode _tmp5_;
	ButtonMode _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GtkWidget* _tmp14_;
	g_return_if_fail (self != NULL);
	if (!gtk_widget_get_visible ((GtkWidget*) self)) {
		return;
	}
	_tmp0_ = self->priv->converter;
	if (_tmp0_ == NULL) {
		MathEquation* _tmp1_;
		MathConverter* _tmp2_;
		MathConverter* _tmp3_;
		MathConverter* _tmp4_;
		_tmp1_ = self->priv->equation;
		_tmp2_ = math_converter_new (_tmp1_);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->converter);
		self->priv->converter = _tmp2_;
		_tmp3_ = self->priv->converter;
		g_signal_connect_object (_tmp3_, "changed", (GCallback) _math_buttons_converter_changed_cb_math_converter_changed, self, 0);
		_tmp4_ = self->priv->converter;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp4_, FALSE, TRUE, (guint) 0);
	}
	_tmp5_ = math_buttons_get_mode (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = math_buttons_load_mode (self, _tmp6_);
	panel = _tmp7_;
	_tmp8_ = self->priv->active_panel;
	_tmp9_ = panel;
	if (_tmp8_ == _tmp9_) {
		_g_object_unref0 (panel);
		return;
	}
	_tmp10_ = self->priv->active_panel;
	if (_tmp10_ != NULL) {
		GtkWidget* _tmp11_;
		_tmp11_ = self->priv->active_panel;
		gtk_widget_hide (_tmp11_);
	}
	_tmp12_ = panel;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->active_panel);
	self->priv->active_panel = _tmp13_;
	_tmp14_ = panel;
	if (_tmp14_ != NULL) {
		GtkWidget* _tmp15_;
		_tmp15_ = panel;
		gtk_widget_show (_tmp15_);
	}
	_g_object_unref0 (panel);
}


static GMenu*
math_buttons_create_shift_menu (MathButtons* self,
                                gboolean shift_left)
{
	GMenu* result = NULL;
	GMenu* shift_menu = NULL;
	GMenu* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_menu_new ();
	shift_menu = _tmp0_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gchar* format = NULL;
				gint _tmp4_;
				gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp9_ = 0;
				gint positions = 0;
				GMenu* _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gint _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < 16)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = g_strdup (ngettext ("%d place", "%d places", (gulong) _tmp4_));
				format = _tmp5_;
				_tmp6_ = i;
				if (_tmp6_ < 10) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = format;
					_tmp8_ = g_strconcat ("_", _tmp7_, NULL);
					_g_free0 (format);
					format = _tmp8_;
				}
				if (shift_left) {
					gint _tmp10_;
					_tmp10_ = i;
					_tmp9_ = _tmp10_;
				} else {
					gint _tmp11_;
					_tmp11_ = i;
					_tmp9_ = -_tmp11_;
				}
				positions = _tmp9_;
				_tmp12_ = shift_menu;
				_tmp13_ = format;
				_tmp14_ = i;
				_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = positions;
				_tmp18_ = g_strdup_printf ("cal.bitshift(%d)", _tmp17_);
				_tmp19_ = _tmp18_;
				g_menu_append (_tmp12_, _tmp16_, _tmp19_);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp16_);
				_g_free0 (format);
			}
		}
	}
	result = shift_menu;
	return result;
}


static void
math_buttons_on_launch_finc_dialog (MathButtons* self,
                                    GSimpleAction* action,
                                    GVariant* param)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp2_;
	GObject* _tmp3_;
	GtkDialog* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp2_ = self->priv->financial_ui;
	_tmp3_ = gtk_builder_get_object (_tmp2_, name);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp3_) : NULL);
	dialog = _tmp4_;
	gtk_dialog_run (dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_free0 (name);
}


static void
math_buttons_on_insert_character (MathButtons* self,
                                  GSimpleAction* action,
                                  GVariant* param)
{
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void
math_buttons_finc_activate_cb (MathButtons* self,
                               GtkWidget* widget)
{
	GtkEntry* next_entry = NULL;
	gconstpointer _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = g_object_get_data ((GObject*) widget, "next-entry");
	_tmp1_ = _g_object_ref0 ((GtkEntry*) _tmp0_);
	next_entry = _tmp1_;
	_tmp2_ = next_entry;
	if (_tmp2_ == NULL) {
		GtkDialog* dialog = NULL;
		GtkWidget* _tmp3_;
		GtkDialog* _tmp4_;
		GtkDialog* _tmp5_;
		_tmp3_ = gtk_widget_get_toplevel (widget);
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp3_) : NULL);
		dialog = _tmp4_;
		_tmp5_ = dialog;
		if (gtk_widget_is_toplevel ((GtkWidget*) _tmp5_)) {
			GtkDialog* _tmp6_;
			_tmp6_ = dialog;
			gtk_dialog_response (_tmp6_, (gint) GTK_RESPONSE_OK);
			_g_object_unref0 (dialog);
			_g_object_unref0 (next_entry);
			return;
		}
		_g_object_unref0 (dialog);
	} else {
		GtkEntry* _tmp7_;
		_tmp7_ = next_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
	}
	_g_object_unref0 (next_entry);
}


static gchar**
_vala_array_dup1 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup2 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup3 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup4 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup5 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup6 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup7 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup8 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup9 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup10 (gchar** self,
                   int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void
math_buttons_finc_response_cb (MathButtons* self,
                               GtkWidget* widget,
                               gint response_id)
{
	FinancialDialog function = 0;
	gconstpointer _tmp0_;
	gchar** entries = NULL;
	gchar** _tmp1_;
	gint entries_length1;
	gint _entries_size_;
	FinancialDialog _tmp2_;
	Number* arg[4] = {0};
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* _tmp16_;
	Number* _tmp17_[4] = {0};
	GtkEntry* first_entry = NULL;
	GtkBuilder* _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	const gchar* _tmp36_;
	GObject* _tmp37_;
	GtkEntry* _tmp38_;
	GtkEntry* _tmp39_;
	MathEquation* _tmp40_;
	FinancialDialog _tmp41_;
	Number* _tmp42_;
	Number* _tmp43_;
	Number* _tmp44_;
	Number* _tmp45_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (response_id != ((gint) GTK_RESPONSE_OK)) {
		return;
	}
	_tmp0_ = g_object_get_data ((GObject*) widget, "finc-function");
	function = (FinancialDialog) ((gint) ((gintptr) _tmp0_));
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	entries = _tmp1_;
	entries_length1 = 0;
	_entries_size_ = entries_length1;
	_tmp2_ = function;
	switch (_tmp2_) {
		case FINANCIAL_DIALOG_CTRM_DIALOG:
		{
			gchar** _tmp3_;
			gint _tmp3__length1;
			_tmp3_ = (MATH_BUTTONS_ctrm_entries != NULL) ? _vala_array_dup1 (MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries)) : ((gpointer) MATH_BUTTONS_ctrm_entries);
			_tmp3__length1 = G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp3_;
			entries_length1 = _tmp3__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_DDB_DIALOG:
		{
			gchar** _tmp4_;
			gint _tmp4__length1;
			_tmp4_ = (MATH_BUTTONS_ddb_entries != NULL) ? _vala_array_dup2 (MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries)) : ((gpointer) MATH_BUTTONS_ddb_entries);
			_tmp4__length1 = G_N_ELEMENTS (MATH_BUTTONS_ddb_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp4_;
			entries_length1 = _tmp4__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_FV_DIALOG:
		{
			gchar** _tmp5_;
			gint _tmp5__length1;
			_tmp5_ = (MATH_BUTTONS_fv_entries != NULL) ? _vala_array_dup3 (MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries)) : ((gpointer) MATH_BUTTONS_fv_entries);
			_tmp5__length1 = G_N_ELEMENTS (MATH_BUTTONS_fv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp5_;
			entries_length1 = _tmp5__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_GPM_DIALOG:
		{
			gchar** _tmp6_;
			gint _tmp6__length1;
			_tmp6_ = (MATH_BUTTONS_gpm_entries != NULL) ? _vala_array_dup4 (MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries)) : ((gpointer) MATH_BUTTONS_gpm_entries);
			_tmp6__length1 = G_N_ELEMENTS (MATH_BUTTONS_gpm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp6_;
			entries_length1 = _tmp6__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PMT_DIALOG:
		{
			gchar** _tmp7_;
			gint _tmp7__length1;
			_tmp7_ = (MATH_BUTTONS_pmt_entries != NULL) ? _vala_array_dup5 (MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries)) : ((gpointer) MATH_BUTTONS_pmt_entries);
			_tmp7__length1 = G_N_ELEMENTS (MATH_BUTTONS_pmt_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp7_;
			entries_length1 = _tmp7__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PV_DIALOG:
		{
			gchar** _tmp8_;
			gint _tmp8__length1;
			_tmp8_ = (MATH_BUTTONS_pv_entries != NULL) ? _vala_array_dup6 (MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries)) : ((gpointer) MATH_BUTTONS_pv_entries);
			_tmp8__length1 = G_N_ELEMENTS (MATH_BUTTONS_pv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp8_;
			entries_length1 = _tmp8__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_RATE_DIALOG:
		{
			gchar** _tmp9_;
			gint _tmp9__length1;
			_tmp9_ = (MATH_BUTTONS_rate_entries != NULL) ? _vala_array_dup7 (MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries)) : ((gpointer) MATH_BUTTONS_rate_entries);
			_tmp9__length1 = G_N_ELEMENTS (MATH_BUTTONS_rate_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp9_;
			entries_length1 = _tmp9__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SLN_DIALOG:
		{
			gchar** _tmp10_;
			gint _tmp10__length1;
			_tmp10_ = (MATH_BUTTONS_sln_entries != NULL) ? _vala_array_dup8 (MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries)) : ((gpointer) MATH_BUTTONS_sln_entries);
			_tmp10__length1 = G_N_ELEMENTS (MATH_BUTTONS_sln_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp10_;
			entries_length1 = _tmp10__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SYD_DIALOG:
		{
			gchar** _tmp11_;
			gint _tmp11__length1;
			_tmp11_ = (MATH_BUTTONS_syd_entries != NULL) ? _vala_array_dup9 (MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries)) : ((gpointer) MATH_BUTTONS_syd_entries);
			_tmp11__length1 = G_N_ELEMENTS (MATH_BUTTONS_syd_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp11_;
			entries_length1 = _tmp11__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_TERM_DIALOG:
		{
			gchar** _tmp12_;
			gint _tmp12__length1;
			_tmp12_ = (MATH_BUTTONS_term_entries != NULL) ? _vala_array_dup10 (MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries)) : ((gpointer) MATH_BUTTONS_term_entries);
			_tmp12__length1 = G_N_ELEMENTS (MATH_BUTTONS_term_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp12_;
			entries_length1 = _tmp12__length1;
			_entries_size_ = entries_length1;
			break;
		}
		default:
		break;
	}
	_tmp13_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp14_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp15_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp16_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp17_[0] = _tmp13_;
	_tmp17_[1] = _tmp14_;
	_tmp17_[2] = _tmp15_;
	_tmp17_[3] = _tmp16_;
	memcpy (arg, _tmp17_, 4 * sizeof (Number*));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				gint _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp22_;
				gchar** _tmp23_;
				gint _tmp23__length1;
				gint _tmp24_;
				const gchar* _tmp25_;
				GObject* _tmp26_;
				GtkEntry* _tmp27_;
				gint _tmp28_;
				GtkEntry* _tmp29_;
				const gchar* _tmp30_;
				Number* _tmp31_;
				Number* _tmp32_;
				GtkEntry* _tmp33_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = i;
				_tmp21_ = entries;
				_tmp21__length1 = entries_length1;
				if (!(_tmp20_ < _tmp21__length1)) {
					break;
				}
				_tmp22_ = self->priv->financial_ui;
				_tmp23_ = entries;
				_tmp23__length1 = entries_length1;
				_tmp24_ = i;
				_tmp25_ = _tmp23_[_tmp24_];
				_tmp26_ = gtk_builder_get_object (_tmp22_, _tmp25_);
				_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp26_) : NULL);
				entry = _tmp27_;
				_tmp28_ = i;
				_tmp29_ = entry;
				_tmp30_ = gtk_entry_get_text (_tmp29_);
				_tmp31_ = mp_set_from_string (_tmp30_, 10);
				_g_object_unref0 (arg[_tmp28_]);
				arg[_tmp28_] = _tmp31_;
				_tmp32_ = arg[_tmp28_];
				_tmp33_ = entry;
				gtk_entry_set_text (_tmp33_, "0");
				_g_object_unref0 (entry);
			}
		}
	}
	_tmp34_ = self->priv->financial_ui;
	_tmp35_ = entries;
	_tmp35__length1 = entries_length1;
	_tmp36_ = _tmp35_[0];
	_tmp37_ = gtk_builder_get_object (_tmp34_, _tmp36_);
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp37_) : NULL);
	first_entry = _tmp38_;
	_tmp39_ = first_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp39_);
	_tmp40_ = self->priv->equation;
	_tmp41_ = function;
	_tmp42_ = arg[0];
	_tmp43_ = arg[1];
	_tmp44_ = arg[2];
	_tmp45_ = arg[3];
	do_finc_expression (_tmp40_, _tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp45_);
	_g_object_unref0 (first_entry);
	_vala_array_destroy (arg, 4, (GDestroyNotify) g_object_unref);
	entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static void
math_buttons_character_code_dialog_response_cb (MathButtons* self,
                                                GtkWidget* dialog,
                                                gint response_id)
{
	gchar* text = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = self->priv->character_code_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
		Number* x = NULL;
		Number* _tmp3_;
		MathEquation* _tmp16_;
		Number* _tmp17_;
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		x = _tmp3_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					const gchar* _tmp6_;
					gint _tmp7_;
					Number* _tmp8_;
					const gchar* _tmp9_;
					gint _tmp10_;
					Number* _tmp11_;
					Number* _tmp12_;
					Number* _tmp13_;
					Number* _tmp14_;
					Number* _tmp15_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = text;
					_tmp7_ = i;
					if (!(string_get (_tmp6_, (glong) _tmp7_) != '\0')) {
						break;
					}
					_tmp8_ = x;
					_tmp9_ = text;
					_tmp10_ = i;
					_tmp11_ = number_new_integer ((gint64) string_get (_tmp9_, (glong) _tmp10_), (gint64) 0);
					_tmp12_ = _tmp11_;
					_tmp13_ = number_add (_tmp8_, _tmp12_);
					_g_object_unref0 (x);
					x = _tmp13_;
					_g_object_unref0 (_tmp12_);
					_tmp14_ = x;
					_tmp15_ = number_shift (_tmp14_, 8);
					_g_object_unref0 (x);
					x = _tmp15_;
				}
			}
		}
		_tmp16_ = self->priv->equation;
		_tmp17_ = x;
		math_equation_insert_number (_tmp16_, _tmp17_);
		_g_object_unref0 (x);
	}
	gtk_widget_hide (dialog);
	_g_free0 (text);
}


static void
math_buttons_character_code_dialog_activate_cb (MathButtons* self,
                                                GtkWidget* entry)
{
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	math_buttons_character_code_dialog_response_cb (self, (GtkWidget*) _tmp0_, (gint) GTK_RESPONSE_OK);
}


static gboolean
math_buttons_character_code_dialog_delete_cb (MathButtons* self,
                                              GtkWidget* dialog,
                                              GdkEventAny* event)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dialog != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	math_buttons_character_code_dialog_response_cb (self, dialog, (gint) GTK_RESPONSE_CANCEL);
	result = TRUE;
	return result;
}


static void
math_buttons_on_toggle_bit (MathButtons* self,
                            GSimpleAction* action,
                            GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_toggle_bit (_tmp0_, (guint) g_variant_get_int32 (param));
}


static void
math_buttons_on_set_number_mode (MathButtons* self,
                                 GSimpleAction* action,
                                 GVariant* param)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_action_get_state ((GAction*) action);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_get_string (_tmp3_, NULL);
	_tmp5_ = g_strcmp0 (_tmp0_, _tmp4_) == 0;
	_g_variant_unref0 (_tmp3_);
	if (_tmp5_) {
		MathEquation* _tmp6_;
		_tmp6_ = self->priv->equation;
		math_equation_set_number_mode (_tmp6_, NUMBER_MODE_NORMAL);
	} else {
		const gchar* _tmp7_;
		_tmp7_ = g_variant_get_string (param, NULL);
		if (g_strcmp0 (_tmp7_, "superscript") == 0) {
			MathEquation* _tmp8_;
			MathEquation* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp8_ = self->priv->equation;
			math_equation_set_number_mode (_tmp8_, NUMBER_MODE_SUPERSCRIPT);
			_tmp9_ = self->priv->equation;
			_tmp10_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp9_);
			_tmp11_ = _tmp10_;
			if (!_tmp11_) {
				MathEquation* _tmp12_;
				_tmp12_ = self->priv->equation;
				math_equation_remove_trailing_spaces (_tmp12_);
			}
		} else {
			const gchar* _tmp13_;
			_tmp13_ = g_variant_get_string (param, NULL);
			if (g_strcmp0 (_tmp13_, "subscript") == 0) {
				MathEquation* _tmp14_;
				MathEquation* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp14_ = self->priv->equation;
				math_equation_set_number_mode (_tmp14_, NUMBER_MODE_SUBSCRIPT);
				_tmp15_ = self->priv->equation;
				_tmp16_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp15_);
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					MathEquation* _tmp18_;
					_tmp18_ = self->priv->equation;
					math_equation_remove_trailing_spaces (_tmp18_);
				}
			}
		}
	}
}


static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant*
_variant_new3 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant*
_variant_new4 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}


static void
math_buttons_number_mode_changed_cb (MathButtons* self)
{
	MathEquation* _tmp0_;
	NumberMode _tmp1_;
	NumberMode _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_equation_get_number_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NUMBER_MODE_SUPERSCRIPT) {
		GSimpleActionGroup* _tmp3_;
		GVariant* _tmp4_;
		_tmp3_ = self->priv->action_group;
		_tmp4_ = _variant_new2 ("superscript");
		g_action_group_change_action_state ((GActionGroup*) _tmp3_, "set-number-mode", _tmp4_);
		_g_variant_unref0 (_tmp4_);
	} else {
		MathEquation* _tmp5_;
		NumberMode _tmp6_;
		NumberMode _tmp7_;
		_tmp5_ = self->priv->equation;
		_tmp6_ = math_equation_get_number_mode (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == NUMBER_MODE_SUBSCRIPT) {
			GSimpleActionGroup* _tmp8_;
			GVariant* _tmp9_;
			_tmp8_ = self->priv->action_group;
			_tmp9_ = _variant_new3 ("subscript");
			g_action_group_change_action_state ((GActionGroup*) _tmp8_, "set-number-mode", _tmp9_);
			_g_variant_unref0 (_tmp9_);
		} else {
			GSimpleActionGroup* _tmp10_;
			GVariant* _tmp11_;
			_tmp10_ = self->priv->action_group;
			_tmp11_ = _variant_new4 ("normal");
			g_action_group_change_action_state ((GActionGroup*) _tmp10_, "set-number-mode", _tmp11_);
			_g_variant_unref0 (_tmp11_);
		}
	}
}


ButtonMode
math_buttons_get_mode (MathButtons* self)
{
	ButtonMode result;
	ButtonMode _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_mode;
	result = _tmp0_;
	return result;
}


void
math_buttons_set_mode (MathButtons* self,
                       ButtonMode value)
{
	ButtonMode _tmp0_;
	ButtonMode _tmp1_;
	ButtonMode _tmp2_;
	gboolean _tmp6_ = FALSE;
	ButtonMode _tmp7_;
	ButtonMode _tmp8_;
	MathConverter* _tmp11_;
	ButtonMode _tmp12_;
	ButtonMode _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_mode;
	if (_tmp0_ == value) {
		return;
	}
	self->priv->_mode = value;
	_tmp1_ = math_buttons_get_mode (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp3_;
		gint _tmp4_;
		_tmp3_ = self->priv->equation;
		_tmp4_ = self->priv->_programming_base;
		math_equation_set_number_base (_tmp3_, _tmp4_);
	} else {
		MathEquation* _tmp5_;
		_tmp5_ = self->priv->equation;
		math_equation_set_number_base (_tmp5_, 10);
	}
	math_buttons_load_buttons (self);
	_tmp7_ = math_buttons_get_mode (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == BUTTON_MODE_ADVANCED) {
		_tmp6_ = TRUE;
	} else {
		ButtonMode _tmp9_;
		ButtonMode _tmp10_;
		_tmp9_ = math_buttons_get_mode (self);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ == BUTTON_MODE_FINANCIAL;
	}
	_tmp11_ = self->priv->converter;
	gtk_widget_set_visible ((GtkWidget*) _tmp11_, _tmp6_);
	_tmp12_ = math_buttons_get_mode (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == BUTTON_MODE_ADVANCED) {
		MathConverter* _tmp14_;
		MathConverter* _tmp15_;
		MathEquation* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		MathEquation* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp14_ = self->priv->converter;
		math_converter_set_category (_tmp14_, NULL);
		_tmp15_ = self->priv->converter;
		_tmp16_ = self->priv->equation;
		_tmp17_ = math_equation_get_source_units (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->equation;
		_tmp21_ = math_equation_get_target_units (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		math_converter_set_conversion (_tmp15_, _tmp19_, _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp19_);
	} else {
		ButtonMode _tmp24_;
		ButtonMode _tmp25_;
		_tmp24_ = math_buttons_get_mode (self);
		_tmp25_ = _tmp24_;
		if (_tmp25_ == BUTTON_MODE_FINANCIAL) {
			MathConverter* _tmp26_;
			MathConverter* _tmp27_;
			MathEquation* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			MathEquation* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp26_ = self->priv->converter;
			math_converter_set_category (_tmp26_, "currency");
			_tmp27_ = self->priv->converter;
			_tmp28_ = self->priv->equation;
			_tmp29_ = math_equation_get_source_currency (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = _tmp30_;
			_tmp32_ = self->priv->equation;
			_tmp33_ = math_equation_get_target_currency (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _tmp34_;
			math_converter_set_conversion (_tmp27_, _tmp31_, _tmp35_);
			_g_free0 (_tmp35_);
			_g_free0 (_tmp31_);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, math_buttons_properties[MATH_BUTTONS_MODE_PROPERTY]);
}


gint
math_buttons_get_programming_base (MathButtons* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_programming_base;
	result = _tmp0_;
	return result;
}


void
math_buttons_set_programming_base (MathButtons* self,
                                   gint value)
{
	gint _tmp0_;
	ButtonMode _tmp1_;
	ButtonMode _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_programming_base;
	if (_tmp0_ == value) {
		return;
	}
	self->priv->_programming_base = value;
	_tmp1_ = math_buttons_get_mode (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp3_;
		_tmp3_ = self->priv->equation;
		math_equation_set_number_base (_tmp3_, value);
	}
	g_object_notify_by_pspec ((GObject *) self, math_buttons_properties[MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY]);
}


static void
math_buttons_class_init (MathButtonsClass * klass)
{
	math_buttons_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathButtonsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_math_buttons_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_buttons_set_property;
	G_OBJECT_CLASS (klass)->finalize = math_buttons_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_MODE_PROPERTY, math_buttons_properties[MATH_BUTTONS_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", TYPE_BUTTON_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY, math_buttons_properties[MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY] = g_param_spec_int ("programming-base", "programming-base", "programming-base", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
math_buttons_instance_init (MathButtons * self)
{
	GSimpleActionGroup* _tmp0_;
	self->priv = MATH_BUTTONS_GET_PRIVATE (self);
	self->priv->_programming_base = 10;
	self->priv->active_panel = NULL;
	_tmp0_ = g_simple_action_group_new ();
	self->priv->action_group = _tmp0_;
}


static void
math_buttons_finalize (GObject * obj)
{
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_BUTTONS, MathButtons);
	_g_object_unref0 (self->priv->equation);
	_g_object_unref0 (self->priv->converter);
	_g_object_unref0 (self->priv->basic_ui);
	_g_object_unref0 (self->priv->advanced_ui);
	_g_object_unref0 (self->priv->financial_ui);
	_g_object_unref0 (self->priv->programming_ui);
	_g_object_unref0 (self->priv->bas_panel);
	_g_object_unref0 (self->priv->adv_panel);
	_g_object_unref0 (self->priv->fin_panel);
	_g_object_unref0 (self->priv->prog_panel);
	_g_object_unref0 (self->priv->active_panel);
	_g_object_unref0 (self->priv->base_combo);
	_g_object_unref0 (self->priv->base_label);
	_g_object_unref0 (self->priv->bit_panel);
	__g_list_free__g_object_unref0_0 (self->priv->toggle_bit_buttons);
	_g_object_unref0 (self->priv->character_code_dialog);
	_g_object_unref0 (self->priv->character_code_entry);
	_g_object_unref0 (self->priv->action_group);
	G_OBJECT_CLASS (math_buttons_parent_class)->finalize (obj);
}


GType
math_buttons_get_type (void)
{
	static volatile gsize math_buttons_type_id__volatile = 0;
	if (g_once_init_enter (&math_buttons_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathButtonsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_buttons_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathButtons), 0, (GInstanceInitFunc) math_buttons_instance_init, NULL };
		GType math_buttons_type_id;
		math_buttons_type_id = g_type_register_static (gtk_box_get_type (), "MathButtons", &g_define_type_info, 0);
		g_once_init_leave (&math_buttons_type_id__volatile, math_buttons_type_id);
	}
	return math_buttons_type_id__volatile;
}


static void
_vala_math_buttons_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE_PROPERTY:
		g_value_set_enum (value, math_buttons_get_mode (self));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY:
		g_value_set_int (value, math_buttons_get_programming_base (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_math_buttons_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE_PROPERTY:
		math_buttons_set_mode (self, g_value_get_enum (value));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY:
		math_buttons_set_programming_base (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



