; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

@hello = private constant [11 x i8] c"helloworld\00", align 1
@NoNulTerminator = private constant [10 x i8] c"helloworld", align 1
@StopCharAfterNulTerminator = private constant [12 x i8] c"helloworld\00x", align 1
@StringWithEOF =  constant [14 x i8] c"helloworld\FFab\00", align 1

declare ptr @memccpy(ptr, ptr, i32, i64)

define ptr @memccpy_to_memcpy(ptr %dst) {
; CHECK-LABEL: @memccpy_to_memcpy(
; CHECK-NEXT:    store i64 8245940763182785896, ptr [[DST:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 8
; CHECK-NEXT:    ret ptr [[TMP2]]
;
  %call = call ptr @memccpy(ptr %dst, ptr @hello, i32 114, i64 12) ; 114 is 'r'
  ret ptr %call
}

define ptr @memccpy_to_memcpy2(ptr %dst) {
; CHECK-LABEL: @memccpy_to_memcpy2(
; CHECK-NEXT:    store i64 8245940763182785896, ptr [[DST:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 8
; CHECK-NEXT:    ret ptr [[TMP2]]
;
  %call = call ptr @memccpy(ptr %dst, ptr @hello, i32 114, i64 8); ; 114 is 'r'
  ret ptr %call
}

define void @memccpy_to_memcpy3(ptr %dst) {
; CHECK-LABEL: @memccpy_to_memcpy3(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(5) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(5) @hello, i64 5, i1 false)
; CHECK-NEXT:    ret void
;
  %call = call ptr @memccpy(ptr %dst, ptr @hello, i32 111, i64 10) ; 111 is 'o'
  ret void
}

define void @memccpy_to_memcpy3_tail(ptr %dst) {
; CHECK-LABEL: @memccpy_to_memcpy3_tail(
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(5) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(5) @hello, i64 5, i1 false)
; CHECK-NEXT:    ret void
;
  %call = tail call ptr @memccpy(ptr %dst, ptr @hello, i32 111, i64 10) ; 111 is 'o'
  ret void
}

define ptr @memccpy_to_memcpy3_musttail(ptr %dst, ptr %x, i32 %y, i64 %z) {
; CHECK-LABEL: @memccpy_to_memcpy3_musttail(
; CHECK-NEXT:    [[CALL:%.*]] = musttail call ptr @memccpy(ptr [[DST:%.*]], ptr nonnull @hello, i32 111, i64 10)
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = musttail call ptr @memccpy(ptr %dst, ptr @hello, i32 111, i64 10) ; 111 is 'o'
  ret ptr %call
}


define void @memccpy_to_memcpy4(ptr %dst) {
; CHECK-LABEL: @memccpy_to_memcpy4(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(11) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(11) @hello, i64 11, i1 false)
; CHECK-NEXT:    ret void
;
  %call = call ptr @memccpy(ptr %dst, ptr @hello, i32 0, i64 12)
  ret void
}

define ptr @memccpy_to_memcpy5(ptr %dst) {
; CHECK-LABEL: @memccpy_to_memcpy5(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(7) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(7) @hello, i64 7, i1 false)
; CHECK-NEXT:    ret ptr null
;
  %call = call ptr @memccpy(ptr %dst, ptr @hello, i32 114, i64 7)
  ret ptr %call
}

define ptr @memccpy_to_memcpy5_tail(ptr %dst) {
; CHECK-LABEL: @memccpy_to_memcpy5_tail(
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(7) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(7) @hello, i64 7, i1 false)
; CHECK-NEXT:    ret ptr null
;
  %call = tail call ptr @memccpy(ptr %dst, ptr @hello, i32 114, i64 7)
  ret ptr %call
}

define ptr @memccpy_to_memcpy5_musttail(ptr %dst, ptr %x, i32 %y, i64 %z) {
; CHECK-LABEL: @memccpy_to_memcpy5_musttail(
; CHECK-NEXT:    [[CALL:%.*]] = musttail call ptr @memccpy(ptr [[DST:%.*]], ptr nonnull @hello, i32 114, i64 7)
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = musttail call ptr @memccpy(ptr %dst, ptr @hello, i32 114, i64 7)
  ret ptr %call
}

define ptr @memccpy_to_memcpy6(ptr %dst) {
; CHECK-LABEL: @memccpy_to_memcpy6(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(6) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(6) @hello, i64 6, i1 false)
; CHECK-NEXT:    ret ptr null
;
  %call = call ptr @memccpy(ptr %dst, ptr @hello, i32 114, i64 6);
  ret ptr %call
}

define ptr @memccpy_to_memcpy7(ptr %dst) {
; CHECK-LABEL: @memccpy_to_memcpy7(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(5) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(5) @hello, i64 5, i1 false)
; CHECK-NEXT:    ret ptr null
;
  %call = call ptr @memccpy(ptr %dst, ptr @hello, i32 115, i64 5) ; 115 is 's'
  ret ptr %call
}

define ptr @memccpy_to_memcpy8(ptr %dst) {
; CHECK-LABEL: @memccpy_to_memcpy8(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(11) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(11) @hello, i64 11, i1 false)
; CHECK-NEXT:    ret ptr null
;
  %call = call ptr @memccpy(ptr %dst, ptr @hello, i32 115, i64 11) ; 115 is 's'
  ret ptr %call
}

define ptr @memccpy_to_memcpy9(ptr %dst, i64 %n) {
; CHECK-LABEL: @memccpy_to_memcpy9(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(12) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(12) @StopCharAfterNulTerminator, i64 12, i1 false)
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 12
; CHECK-NEXT:    ret ptr [[TMP1]]
;
  %call = call ptr @memccpy(ptr %dst, ptr @StopCharAfterNulTerminator, i32 120, i64 15) ; 120 is 'x'
  ret ptr %call
}

define ptr @memccpy_to_memcpy10(ptr %dst, i64 %n) {
; CHECK-LABEL: @memccpy_to_memcpy10(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(11) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(11) @StringWithEOF, i64 11, i1 false)
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 11
; CHECK-NEXT:    ret ptr [[TMP1]]
;
  %call = call ptr @memccpy(ptr %dst, ptr @StringWithEOF, i32 255, i64 15)
  ret ptr %call
}

define ptr @memccpy_to_memcpy11(ptr %dst, i64 %n) {
; CHECK-LABEL: @memccpy_to_memcpy11(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(11) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(11) @StringWithEOF, i64 11, i1 false)
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 11
; CHECK-NEXT:    ret ptr [[TMP1]]
;
  %call = call ptr @memccpy(ptr %dst, ptr @StringWithEOF, i32 -1, i64 15)
  ret ptr %call
}

define ptr @memccpy_to_memcpy12(ptr %dst, i64 %n) {
; CHECK-LABEL: @memccpy_to_memcpy12(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(11) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(11) @StringWithEOF, i64 11, i1 false)
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 11
; CHECK-NEXT:    ret ptr [[TMP1]]
;
  %call = call ptr @memccpy(ptr %dst, ptr @StringWithEOF, i32 1023, i64 15)
  ret ptr %call
}

define ptr @memccpy_to_null(ptr %dst, ptr %src, i32 %c) {
; CHECK-LABEL: @memccpy_to_null(
; CHECK-NEXT:    ret ptr null
;
  %call = call ptr @memccpy(ptr %dst, ptr %src, i32 %c, i64 0)
  ret ptr %call
}

define void @memccpy_dst_src_same_retval_unused(ptr %dst, i32 %c, i64 %n) {
; CHECK-LABEL: @memccpy_dst_src_same_retval_unused(
; CHECK-NEXT:    ret void
;
  %call = call ptr @memccpy(ptr %dst, ptr %dst, i32 %c, i64 %n)
  ret void
}

; Negative tests
define ptr @unknown_src(ptr %dst, ptr %src) {
; CHECK-LABEL: @unknown_src(
; CHECK-NEXT:    [[CALL:%.*]] = call ptr @memccpy(ptr [[DST:%.*]], ptr [[SRC:%.*]], i32 114, i64 12)
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = call ptr @memccpy(ptr %dst, ptr %src, i32 114, i64 12)
  ret ptr %call
}

define ptr @unknown_stop_char(ptr %dst, i32 %c) {
; CHECK-LABEL: @unknown_stop_char(
; CHECK-NEXT:    [[CALL:%.*]] = call ptr @memccpy(ptr [[DST:%.*]], ptr nonnull @hello, i32 [[C:%.*]], i64 12)
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = call ptr @memccpy(ptr %dst, ptr @hello, i32 %c, i64 12)
  ret ptr %call
}

define ptr @unknown_size_n(ptr %dst, i64 %n) {
; CHECK-LABEL: @unknown_size_n(
; CHECK-NEXT:    [[CALL:%.*]] = call ptr @memccpy(ptr [[DST:%.*]], ptr nonnull @hello, i32 114, i64 [[N:%.*]])
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = call ptr @memccpy(ptr %dst, ptr @hello, i32 114, i64 %n)
  ret ptr %call
}

define ptr @no_nul_terminator(ptr %dst, i64 %n) {
; CHECK-LABEL: @no_nul_terminator(
; CHECK-NEXT:    [[CALL:%.*]] = call ptr @memccpy(ptr [[DST:%.*]], ptr nonnull @StopCharAfterNulTerminator, i32 120, i64 [[N:%.*]])
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = call ptr @memccpy(ptr %dst, ptr @StopCharAfterNulTerminator, i32 120, i64 %n) ; 120 is 'x'
  ret ptr %call
}

define ptr @possibly_valid_data_after_array(ptr %dst, i64 %n) {
; CHECK-LABEL: @possibly_valid_data_after_array(
; CHECK-NEXT:    [[CALL:%.*]] = call ptr @memccpy(ptr [[DST:%.*]], ptr nonnull @NoNulTerminator, i32 115, i64 [[N:%.*]])
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = call ptr @memccpy(ptr %dst, ptr @NoNulTerminator, i32 115, i64 %n) ; 115 is 's'
  ret ptr %call
}

define ptr @possibly_valid_data_after_array2(ptr %dst, i64 %n) {
; CHECK-LABEL: @possibly_valid_data_after_array2(
; CHECK-NEXT:    [[CALL:%.*]] = call ptr @memccpy(ptr [[DST:%.*]], ptr nonnull @hello, i32 115, i64 [[N:%.*]])
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = call ptr @memccpy(ptr %dst, ptr @hello, i32 115, i64 %n) ; 115 is 's'
  ret ptr %call
}

define ptr @possibly_valid_data_after_array3(ptr %dst) {
; CHECK-LABEL: @possibly_valid_data_after_array3(
; CHECK-NEXT:    [[CALL:%.*]] = call ptr @memccpy(ptr [[DST:%.*]], ptr nonnull @hello, i32 115, i64 12)
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = call ptr @memccpy(ptr %dst, ptr @hello, i32 115, i64 12) ; 115 is 's'
  ret ptr %call
}

define ptr @memccpy_dst_src_same_retval_used(ptr %dst, i32 %c, i64 %n) {
; CHECK-LABEL: @memccpy_dst_src_same_retval_used(
; CHECK-NEXT:    [[CALL:%.*]] = call ptr @memccpy(ptr [[DST:%.*]], ptr [[DST]], i32 [[C:%.*]], i64 [[N:%.*]])
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = call ptr @memccpy(ptr %dst, ptr %dst, i32 %c, i64 %n)
  ret ptr %call
}

define ptr @memccpy_to_memcpy_musttail(ptr %dst, ptr %x, i32 %y, i64 %z) {
; CHECK-LABEL: @memccpy_to_memcpy_musttail(
; CHECK-NEXT:    [[CALL:%.*]] = musttail call ptr @memccpy(ptr [[DST:%.*]], ptr nonnull @hello, i32 114, i64 12)
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = musttail call ptr @memccpy(ptr %dst, ptr @hello, i32 114, i64 12) ; 114 is 'r'
  ret ptr %call
}

define ptr @memccpy_to_memcpy2_musttail(ptr %dst, ptr %x, i32 %y, i64 %z) {
; CHECK-LABEL: @memccpy_to_memcpy2_musttail(
; CHECK-NEXT:    [[CALL:%.*]] = musttail call ptr @memccpy(ptr [[DST:%.*]], ptr nonnull @hello, i32 114, i64 8)
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = musttail call ptr @memccpy(ptr %dst, ptr @hello, i32 114, i64 8) ; 114 is 'r'
  ret ptr %call
}

